/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.connect.guava.hash;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.sparkproject.connect.errorprone_annotations.CanIgnoreReturnValue;
import org.sparkproject.connect.guava.annotations.Beta;
import org.sparkproject.connect.guava.base.Preconditions;
import org.sparkproject.connect.guava.hash.ElementTypesAreNonnullByDefault;
import org.sparkproject.connect.guava.hash.HashCode;
import org.sparkproject.connect.guava.hash.HashFunction;
import org.sparkproject.connect.guava.hash.Hasher;

@ElementTypesAreNonnullByDefault
@Beta
public final class HashingInputStream
extends FilterInputStream {
    private final Hasher hasher;

    public HashingInputStream(HashFunction hashFunction, InputStream in) {
        super(Preconditions.checkNotNull(in));
        this.hasher = Preconditions.checkNotNull(hashFunction.newHasher());
    }

    @Override
    @CanIgnoreReturnValue
    public int read() throws IOException {
        int b = this.in.read();
        if (b != -1) {
            this.hasher.putByte((byte)b);
        }
        return b;
    }

    @Override
    @CanIgnoreReturnValue
    public int read(byte[] bytes, int off, int len) throws IOException {
        int numOfBytesRead = this.in.read(bytes, off, len);
        if (numOfBytesRead != -1) {
            this.hasher.putBytes(bytes, off, numOfBytesRead);
        }
        return numOfBytesRead;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void mark(int readlimit) {
    }

    @Override
    public void reset() throws IOException {
        throw new IOException("reset not supported");
    }

    public HashCode hash() {
        return this.hasher.hash();
    }
}

