/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connect.service;

import java.io.Serializable;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.GuardedBy;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.connect.service.SessionHolder;
import org.apache.spark.sql.connect.service.SparkConnectStreamingQueryCache$;
import org.apache.spark.sql.streaming.StreamingQuery;
import org.apache.spark.util.Clock;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.mutable.HashMap;
import scala.concurrent.duration.Duration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\r\u001dc!B,Y\u0001i#\u0007\u0002C9\u0001\u0005\u000b\u0007I\u0011A:\t\u0011i\u0004!\u0011!Q\u0001\nQD\u0001b\u001f\u0001\u0003\u0006\u0004%I\u0001 \u0005\n\u0003\u0017\u0001!\u0011!Q\u0001\nuD\u0011\"!\u0004\u0001\u0005\u000b\u0007I\u0011\u0002?\t\u0013\u0005=\u0001A!A!\u0002\u0013i\bbBA\t\u0001\u0011\u0005\u00111\u0003\u0005\b\u0003?\u0001A\u0011AA\u0011\u0011\u001d\t\u0019\u0005\u0001C\u0001\u0003\u000bBq!a\u001e\u0001\t\u0003\tI\b\u0003\u0005\u0002~\u0001!\t\u0001WA@\u0011!\u0011\u0019\u0010\u0001C\u00011\nU\b\"\u0003B|\u0001\t\u0007I\u0011\u0002B}\u0011!\u0019I\u0001\u0001Q\u0001\n\tm\b\"CB\u0011\u0001\t\u0007I\u0011BB\u0012\u0011!\u0019)\u0003\u0001Q\u0001\n\tU\u0003\"CB\u0014\u0001\u0001\u0007I\u0011BB\u0015\u0011%\u0019I\u0004\u0001a\u0001\n\u0013\u0019Y\u0004\u0003\u0005\u0004@\u0001\u0001\u000b\u0015BB\u0016\u0011\u001d\u0019\u0019\u0005\u0001C\u0005\u0005kDqa!\u0012\u0001\t\u0013\u0011)p\u0002\u0005\u0002\bbC\tAWAE\r\u001d9\u0006\f#\u0001[\u0003\u0017Cq!!\u0005\u0018\t\u0003\tiI\u0002\u0004\u0002\u0010^\u0001\u0015\u0011\u0013\u0005\u000b\u0003\u001fJ\"Q3A\u0005\u0002\u0005}\u0005BCAQ3\tE\t\u0015!\u0003\u0002R!Q\u0011\u0011N\r\u0003\u0016\u0004%\t!a(\t\u0015\u0005\r\u0016D!E!\u0002\u0013\t\t\u0006C\u0004\u0002\u0012e!\t!!*\t\u0013\u0005=\u0016$!A\u0005\u0002\u0005E\u0006\"CA\\3E\u0005I\u0011AA]\u0011%\ty-GI\u0001\n\u0003\tI\fC\u0005\u0002Rf\t\t\u0011\"\u0011\u0002T\"I\u00111]\r\u0002\u0002\u0013\u0005\u0011Q\u001d\u0005\n\u0003[L\u0012\u0011!C\u0001\u0003_D\u0011\"a?\u001a\u0003\u0003%\t%!@\t\u0013\t-\u0011$!A\u0005\u0002\t5\u0001\"\u0003B\f3\u0005\u0005I\u0011\tB\r\u0011%\u0011Y\"GA\u0001\n\u0003\u0012i\u0002C\u0005\u0003 e\t\t\u0011\"\u0011\u0003\"\u001dI!QE\f\u0002\u0002#\u0005!q\u0005\u0004\n\u0003\u001f;\u0012\u0011!E\u0001\u0005SAq!!\u0005,\t\u0003\u00119\u0004C\u0005\u0003\u001c-\n\t\u0011\"\u0012\u0003\u001e!I!\u0011H\u0016\u0002\u0002\u0013\u0005%1\b\u0005\n\u0005\u0003Z\u0013\u0011!CA\u0005\u0007B\u0011B!\u0015,\u0003\u0003%IAa\u0015\u0007\r\tms\u0003\u0011B/\u0011)\u0011y&\rBK\u0002\u0013\u0005\u0011q\u0014\u0005\u000b\u0005C\n$\u0011#Q\u0001\n\u0005E\u0003B\u0003B2c\tU\r\u0011\"\u0001\u0002 \"Q!QM\u0019\u0003\u0012\u0003\u0006I!!\u0015\t\u0015\u00055\u0014G!f\u0001\n\u0003\u00119\u0007\u0003\u0006\u0003jE\u0012\t\u0012)A\u0005\u0003_B!\"!\u000e2\u0005+\u0007I\u0011\u0001B6\u0011)\u0011i'\rB\tB\u0003%\u0011q\u0007\u0005\u000b\u0005_\n$Q3A\u0005\u0002\tE\u0004B\u0003B>c\tE\t\u0015!\u0003\u0003t!9\u0011\u0011C\u0019\u0005\u0002\tu\u0004b\u0002B\u000ec\u0011\u0005#1\u0012\u0005\n\u0003_\u000b\u0014\u0011!C\u0001\u0005\u001bC\u0011\"a.2#\u0003%\t!!/\t\u0013\u0005=\u0017'%A\u0005\u0002\u0005e\u0006\"\u0003BMcE\u0005I\u0011\u0001BN\u0011%\u0011y*MI\u0001\n\u0003\u0011\t\u000bC\u0005\u0003&F\n\n\u0011\"\u0001\u0003(\"I\u0011\u0011[\u0019\u0002\u0002\u0013\u0005\u00131\u001b\u0005\n\u0003G\f\u0014\u0011!C\u0001\u0003KD\u0011\"!<2\u0003\u0003%\tAa+\t\u0013\u0005m\u0018'!A\u0005B\u0005u\b\"\u0003B\u0006c\u0005\u0005I\u0011\u0001BX\u0011%\u00119\"MA\u0001\n\u0003\u0012I\u0002C\u0005\u0003 E\n\t\u0011\"\u0011\u00034\u001eI!qW\f\u0002\u0002#\u0005!\u0011\u0018\u0004\n\u00057:\u0012\u0011!E\u0001\u0005wCq!!\u0005M\t\u0003\u0011\u0019\rC\u0005\u0003\u001c1\u000b\t\u0011\"\u0012\u0003\u001e!I!\u0011\b'\u0002\u0002\u0013\u0005%Q\u0019\u0005\n\u0005#d\u0015\u0013!C\u0001\u0005OC\u0011B!\u0011M\u0003\u0003%\tIa5\t\u0013\t}G*%A\u0005\u0002\t\u001d\u0006\"\u0003B)\u0019\u0006\u0005I\u0011\u0002B*\u0011%\u0011\toFI\u0001\n\u0003\u0011\u0019\u000fC\u0005\u0003h^\t\n\u0011\"\u0001\u0003j\"I!Q^\f\u0012\u0002\u0013\u0005!\u0011\u001e\u0002 'B\f'o[\"p]:,7\r^*ue\u0016\fW.\u001b8h#V,'/_\"bG\",'BA-[\u0003\u001d\u0019XM\u001d<jG\u0016T!a\u0017/\u0002\u000f\r|gN\\3di*\u0011QLX\u0001\u0004gFd'BA0a\u0003\u0015\u0019\b/\u0019:l\u0015\t\t'-\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002G\u0006\u0019qN]4\u0014\u0007\u0001)7\u000e\u0005\u0002gS6\tqMC\u0001i\u0003\u0015\u00198-\u00197b\u0013\tQwM\u0001\u0004B]f\u0014VM\u001a\t\u0003Y>l\u0011!\u001c\u0006\u0003]z\u000b\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003a6\u0014q\u0001T8hO&tw-A\u0003dY>\u001c7n\u0001\u0001\u0016\u0003Q\u0004\"!\u001e=\u000e\u0003YT!a\u001e0\u0002\tU$\u0018\u000e\\\u0005\u0003sZ\u0014Qa\u00117pG.\faa\u00197pG.\u0004\u0013!H:u_B\u0004X\rZ)vKJL\u0018J\\1di&4\u0018\u000e^=US6,w.\u001e;\u0016\u0003u\u00042A`A\u0004\u001b\u0005y(\u0002BA\u0001\u0003\u0007\t\u0001\u0002Z;sCRLwN\u001c\u0006\u0004\u0003\u000b9\u0017AC2p]\u000e,(O]3oi&\u0019\u0011\u0011B@\u0003\u0011\u0011+(/\u0019;j_:\fad\u001d;paB,G-U;fefLe.Y2uSZLG/\u001f+j[\u0016|W\u000f\u001e\u0011\u0002)M,7o]5p]B{G\u000e\\5oOB+'/[8e\u0003U\u0019Xm]:j_:\u0004v\u000e\u001c7j]\u001e\u0004VM]5pI\u0002\na\u0001P5oSRtD\u0003CA\u000b\u00033\tY\"!\b\u0011\u0007\u0005]\u0001!D\u0001Y\u0011\u001d\tx\u0001%AA\u0002QDqa_\u0004\u0011\u0002\u0003\u0007Q\u0010\u0003\u0005\u0002\u000e\u001d\u0001\n\u00111\u0001~\u0003e\u0011XmZ5ti\u0016\u0014h*Z<TiJ,\u0017-\\5oOF+XM]=\u0015\r\u0005\r\u0012\u0011FA\u001a!\r1\u0017QE\u0005\u0004\u0003O9'\u0001B+oSRDq!a\u000b\t\u0001\u0004\ti#A\u0007tKN\u001c\u0018n\u001c8I_2$WM\u001d\t\u0005\u0003/\ty#C\u0002\u00022a\u0013QbU3tg&|g\u000eS8mI\u0016\u0014\bbBA\u001b\u0011\u0001\u0007\u0011qG\u0001\u0006cV,'/\u001f\t\u0005\u0003s\ty$\u0004\u0002\u0002<)\u0019\u0011Q\b/\u0002\u0013M$(/Z1nS:<\u0017\u0002BA!\u0003w\u0011ab\u0015;sK\u0006l\u0017N\\4Rk\u0016\u0014\u00180\u0001\bhKR\u001c\u0015m\u00195fIF+XM]=\u0015\u0011\u0005\u001d\u0013QJA4\u0003W\u0002RAZA%\u0003oI1!a\u0013h\u0005\u0019y\u0005\u000f^5p]\"9\u0011qJ\u0005A\u0002\u0005E\u0013aB9vKJL\u0018\n\u001a\t\u0005\u0003'\n\tG\u0004\u0003\u0002V\u0005u\u0003cAA,O6\u0011\u0011\u0011\f\u0006\u0004\u00037\u0012\u0018A\u0002\u001fs_>$h(C\u0002\u0002`\u001d\fa\u0001\u0015:fI\u00164\u0017\u0002BA2\u0003K\u0012aa\u0015;sS:<'bAA0O\"9\u0011\u0011N\u0005A\u0002\u0005E\u0013!\u0002:v]&#\u0007bBA7\u0013\u0001\u0007\u0011qN\u0001\bg\u0016\u001c8/[8o!\u0011\t\t(a\u001d\u000e\u0003qK1!!\u001e]\u00051\u0019\u0006/\u0019:l'\u0016\u001c8/[8o\u0003U\u0019G.Z1okB\u0014VO\u001c8j]\u001e\fV/\u001a:jKN$B!a\t\u0002|!9\u00111\u0006\u0006A\u0002\u00055\u0012AD4fi\u000e\u000b7\r[3e-\u0006dW/\u001a\u000b\u0007\u0003\u0003\u0013yO!=\u0011\u000b\u0019\fI%a!\u0011\u0007\u0005\u0015\u0015GD\u0002\u0002\u0018Y\tqd\u00159be.\u001cuN\u001c8fGR\u001cFO]3b[&tw-U;fef\u001c\u0015m\u00195f!\r\t9bF\n\u0003/\u0015$\"!!#\u0003\u001bE+XM]=DC\u000eDWmS3z'\u0019IR-a%\u0002\u001aB\u0019a-!&\n\u0007\u0005]uMA\u0004Qe>$Wo\u0019;\u0011\u0007\u0019\fY*C\u0002\u0002\u001e\u001e\u0014AbU3sS\u0006d\u0017N_1cY\u0016,\"!!\u0015\u0002\u0011E,XM]=JI\u0002\naA];o\u0013\u0012\u0004CCBAT\u0003W\u000bi\u000bE\u0002\u0002*fi\u0011a\u0006\u0005\b\u0003\u001fr\u0002\u0019AA)\u0011\u001d\tIG\ba\u0001\u0003#\nAaY8qsR1\u0011qUAZ\u0003kC\u0011\"a\u0014 !\u0003\u0005\r!!\u0015\t\u0013\u0005%t\u0004%AA\u0002\u0005E\u0013AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003wSC!!\u0015\u0002>.\u0012\u0011q\u0018\t\u0005\u0003\u0003\fY-\u0004\u0002\u0002D*!\u0011QYAd\u0003%)hn\u00195fG.,GMC\u0002\u0002J\u001e\f!\"\u00198o_R\fG/[8o\u0013\u0011\ti-a1\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\t)\u000e\u0005\u0003\u0002X\u0006\u0005XBAAm\u0015\u0011\tY.!8\u0002\t1\fgn\u001a\u0006\u0003\u0003?\fAA[1wC&!\u00111MAm\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\t9\u000fE\u0002g\u0003SL1!a;h\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\t\t0a>\u0011\u0007\u0019\f\u00190C\u0002\u0002v\u001e\u00141!\u00118z\u0011%\tI\u0010JA\u0001\u0002\u0004\t9/A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003\u007f\u0004bA!\u0001\u0003\b\u0005EXB\u0001B\u0002\u0015\r\u0011)aZ\u0001\u000bG>dG.Z2uS>t\u0017\u0002\u0002B\u0005\u0005\u0007\u0011\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!!q\u0002B\u000b!\r1'\u0011C\u0005\u0004\u0005'9'a\u0002\"p_2,\u0017M\u001c\u0005\n\u0003s4\u0013\u0011!a\u0001\u0003c\f\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0003\u0003O\f\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003+\fa!Z9vC2\u001cH\u0003\u0002B\b\u0005GA\u0011\"!?*\u0003\u0003\u0005\r!!=\u0002\u001bE+XM]=DC\u000eDWmS3z!\r\tIkK\n\u0006W\t-\u0012\u0011\u0014\t\u000b\u0005[\u0011\u0019$!\u0015\u0002R\u0005\u001dVB\u0001B\u0018\u0015\r\u0011\tdZ\u0001\beVtG/[7f\u0013\u0011\u0011)Da\f\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t'\u0007\u0006\u0002\u0003(\u0005)\u0011\r\u001d9msR1\u0011q\u0015B\u001f\u0005\u007fAq!a\u0014/\u0001\u0004\t\t\u0006C\u0004\u0002j9\u0002\r!!\u0015\u0002\u000fUt\u0017\r\u001d9msR!!Q\tB'!\u00151\u0017\u0011\nB$!\u001d1'\u0011JA)\u0003#J1Aa\u0013h\u0005\u0019!V\u000f\u001d7fe!I!qJ\u0018\u0002\u0002\u0003\u0007\u0011qU\u0001\u0004q\u0012\u0002\u0014a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"A!\u0016\u0011\t\u0005]'qK\u0005\u0005\u00053\nIN\u0001\u0004PE*,7\r\u001e\u0002\u0010#V,'/_\"bG\",g+\u00197vKN1\u0011'ZAJ\u00033\u000ba!^:fe&#\u0017aB;tKJLE\rI\u0001\ng\u0016\u001c8/[8o\u0013\u0012\f!b]3tg&|g.\u00133!+\t\ty'\u0001\u0005tKN\u001c\u0018n\u001c8!+\t\t9$\u0001\u0004rk\u0016\u0014\u0018\u0010I\u0001\fKb\u0004\u0018N]3t\u0003Rl5/\u0006\u0002\u0003tA)a-!\u0013\u0003vA\u0019aMa\u001e\n\u0007\tetM\u0001\u0003M_:<\u0017\u0001D3ya&\u0014Xm]!u\u001bN\u0004C\u0003\u0004B@\u0005\u0003\u0013\u0019I!\"\u0003\b\n%\u0005cAAUc!9!q\f\u001fA\u0002\u0005E\u0003b\u0002B2y\u0001\u0007\u0011\u0011\u000b\u0005\b\u0003[b\u0004\u0019AA8\u0011\u001d\t)\u0004\u0010a\u0001\u0003oA\u0011Ba\u001c=!\u0003\u0005\rAa\u001d\u0015\u0005\u0005EC\u0003\u0004B@\u0005\u001f\u0013\tJa%\u0003\u0016\n]\u0005\"\u0003B0}A\u0005\t\u0019AA)\u0011%\u0011\u0019G\u0010I\u0001\u0002\u0004\t\t\u0006C\u0005\u0002ny\u0002\n\u00111\u0001\u0002p!I\u0011Q\u0007 \u0011\u0002\u0003\u0007\u0011q\u0007\u0005\n\u0005_r\u0004\u0013!a\u0001\u0005g\nabY8qs\u0012\"WMZ1vYR$3'\u0006\u0002\u0003\u001e*\"\u0011qNA_\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIQ*\"Aa)+\t\u0005]\u0012QX\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00136+\t\u0011IK\u000b\u0003\u0003t\u0005uF\u0003BAy\u0005[C\u0011\"!?G\u0003\u0003\u0005\r!a:\u0015\t\t=!\u0011\u0017\u0005\n\u0003sD\u0015\u0011!a\u0001\u0003c$BAa\u0004\u00036\"I\u0011\u0011 &\u0002\u0002\u0003\u0007\u0011\u0011_\u0001\u0010#V,'/_\"bG\",g+\u00197vKB\u0019\u0011\u0011\u0016'\u0014\u000b1\u0013i,!'\u0011!\t5\"qXA)\u0003#\ny'a\u000e\u0003t\t}\u0014\u0002\u0002Ba\u0005_\u0011\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c86)\t\u0011I\f\u0006\u0007\u0003\u0000\t\u001d'\u0011\u001aBf\u0005\u001b\u0014y\rC\u0004\u0003`=\u0003\r!!\u0015\t\u000f\t\rt\n1\u0001\u0002R!9\u0011QN(A\u0002\u0005=\u0004bBA\u001b\u001f\u0002\u0007\u0011q\u0007\u0005\n\u0005_z\u0005\u0013!a\u0001\u0005g\nq\"\u00199qYf$C-\u001a4bk2$H%\u000e\u000b\u0005\u0005+\u0014i\u000eE\u0003g\u0003\u0013\u00129\u000eE\u0007g\u00053\f\t&!\u0015\u0002p\u0005]\"1O\u0005\u0004\u00057<'A\u0002+va2,W\u0007C\u0005\u0003PE\u000b\t\u00111\u0001\u0003\u0000\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIU\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\nTC\u0001BsU\r!\u0018QX\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\t-(fA?\u0002>\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIMBq!a\u0014\f\u0001\u0004\t\t\u0006C\u0004\u0002j-\u0001\r!!\u0015\u0002\u0011MDW\u000f\u001e3po:$\"!a\t\u0002\u0015E,XM]=DC\u000eDW-\u0006\u0002\u0003|BA!Q`B\u0002\u0007\u000f\t\u0019)\u0004\u0002\u0003\u0000*!1\u0011\u0001B\u0002\u0003\u001diW\u000f^1cY\u0016LAa!\u0002\u0003\u0000\n9\u0001*Y:i\u001b\u0006\u0004\bcAAC3\u0005Y\u0011/^3ss\u000e\u000b7\r[3!Q\u001dq1QBB\u000f\u0007?\u0001Baa\u0004\u0004\u001a5\u00111\u0011\u0003\u0006\u0005\u0003\u000b\u0019\u0019B\u0003\u0003\u0002J\u000eU!BAB\f\u0003\u0015Q\u0017M^1y\u0013\u0011\u0019Yb!\u0005\u0003\u0013\u001d+\u0018M\u001d3fI\nK\u0018!\u0002<bYV,\u0017EAB\u0011\u00039\tX/\u001a:z\u0007\u0006\u001c\u0007.\u001a'pG.,\"A!\u0016\u0002\u001fE,XM]=DC\u000eDW\rT8dW\u0002\n\u0011c]2iK\u0012,H.\u001a3Fq\u0016\u001cW\u000f^8s+\t\u0019Y\u0003E\u0003g\u0003\u0013\u001ai\u0003\u0005\u0003\u00040\rURBAB\u0019\u0015\u0011\t)aa\r\u000b\u0007]\fi.\u0003\u0003\u00048\rE\"\u0001G*dQ\u0016$W\u000f\\3e\u000bb,7-\u001e;peN+'O^5dK\u0006)2o\u00195fIVdW\rZ#yK\u000e,Ho\u001c:`I\u0015\fH\u0003BA\u0012\u0007{A\u0011\"!?\u0013\u0003\u0003\u0005\raa\u000b\u0002%M\u001c\u0007.\u001a3vY\u0016$W\t_3dkR|'\u000f\t\u0015\b'\r51QDB\u0010\u0003Y\u00198\r[3ek2,\u0007+\u001a:j_\u0012L7m\u00115fG.\u001c\u0018a\u00059fe&|G-[2NC&tG/\u001a8b]\u000e,\u0007")
public class SparkConnectStreamingQueryCache
implements Logging {
    private final Clock clock;
    private final Duration stoppedQueryInactivityTimeout;
    private final Duration sessionPollingPeriod;
    @GuardedBy(value="queryCacheLock")
    private final HashMap<QueryCacheKey, QueryCacheValue> queryCache;
    private final Object queryCacheLock;
    @GuardedBy(value="queryCacheLock")
    private Option<ScheduledExecutorService> scheduledExecutor;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static Duration $lessinit$greater$default$3() {
        return SparkConnectStreamingQueryCache$.MODULE$.$lessinit$greater$default$3();
    }

    public static Duration $lessinit$greater$default$2() {
        return SparkConnectStreamingQueryCache$.MODULE$.$lessinit$greater$default$2();
    }

    public static Clock $lessinit$greater$default$1() {
        return SparkConnectStreamingQueryCache$.MODULE$.$lessinit$greater$default$1();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Clock clock() {
        return this.clock;
    }

    private Duration stoppedQueryInactivityTimeout() {
        return this.stoppedQueryInactivityTimeout;
    }

    private Duration sessionPollingPeriod() {
        return this.sessionPollingPeriod;
    }

    public void registerNewStreamingQuery(SessionHolder sessionHolder, StreamingQuery query) {
        Object object = this.queryCacheLock();
        synchronized (object) {
            QueryCacheValue value = new QueryCacheValue(sessionHolder.userId(), sessionHolder.sessionId(), sessionHolder.session(), query, (Option<Object>)None$.MODULE$);
            Option option = this.queryCache().put((Object)new QueryCacheKey(query.id().toString(), query.runId().toString()), (Object)value);
            if (option instanceof Some) {
                Some some = (Some)option;
                QueryCacheValue existing = (QueryCacheValue)some.value();
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(91).append("Replacing existing query in the cache (unexpected). Query Id: ").append(query.id()).append(".").append("Existing value ").append(existing).append(", new value ").append(value).append(".").toString());
            } else if (None$.MODULE$.equals(option)) {
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(49).append("Adding new query to the cache. Query Id ").append(query.id()).append(", value ").append(value).append(".").toString());
            } else {
                throw new MatchError((Object)option);
            }
            this.schedulePeriodicChecks();
        }
    }

    public Option<StreamingQuery> getCachedQuery(String queryId, String runId, SparkSession session) {
        Option option;
        QueryCacheKey key = new QueryCacheKey(queryId, runId);
        Object object = this.queryCacheLock();
        synchronized (object) {
            option = this.queryCache().get((Object)key).flatMap((Function1 & Serializable & scala.Serializable)v -> {
                SparkSession sparkSession = v.session();
                SparkSession sparkSession2 = session;
                if (!(sparkSession != null ? !sparkSession.equals(sparkSession2) : sparkSession2 != null)) {
                    v.expiresAtMs().foreach((Function1 & Serializable & scala.Serializable)x$1 -> SparkConnectStreamingQueryCache.$anonfun$getCachedQuery$2(this, key, v, BoxesRunTime.unboxToLong((Object)x$1)));
                    return new Some((Object)v.query());
                }
                return None$.MODULE$;
            });
        }
        return option;
    }

    public void cleanupRunningQueries(SessionHolder sessionHolder) {
        this.queryCache().withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)SparkConnectStreamingQueryCache.$anonfun$cleanupRunningQueries$1(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            SparkConnectStreamingQueryCache.$anonfun$cleanupRunningQueries$2(this, sessionHolder, x$2);
            return BoxedUnit.UNIT;
        });
    }

    public Option<QueryCacheValue> getCachedValue(String queryId, String runId) {
        return this.queryCache().get((Object)new QueryCacheKey(queryId, runId));
    }

    public void shutdown() {
        Object object = this.queryCacheLock();
        synchronized (object) {
            this.scheduledExecutor().foreach((Function1 & Serializable & scala.Serializable)executor -> BoxesRunTime.boxToBoolean((boolean)SparkConnectStreamingQueryCache.$anonfun$shutdown$1(executor)));
            this.scheduledExecutor_$eq((Option<ScheduledExecutorService>)None$.MODULE$);
        }
    }

    private HashMap<QueryCacheKey, QueryCacheValue> queryCache() {
        return this.queryCache;
    }

    private Object queryCacheLock() {
        return this.queryCacheLock;
    }

    private Option<ScheduledExecutorService> scheduledExecutor() {
        return this.scheduledExecutor;
    }

    private void scheduledExecutor_$eq(Option<ScheduledExecutorService> x$1) {
        this.scheduledExecutor = x$1;
    }

    private void schedulePeriodicChecks() {
        Object object = this.queryCacheLock();
        synchronized (object) {
            Option<ScheduledExecutorService> option = this.scheduledExecutor();
            if (option instanceof Some) {
            } else if (None$.MODULE$.equals(option)) {
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(53).append("Starting thread for polling streaming sessions every ").append(this.sessionPollingPeriod()).toString());
                this.scheduledExecutor_$eq((Option<ScheduledExecutorService>)new Some((Object)Executors.newSingleThreadScheduledExecutor()));
                ((ScheduledExecutorService)this.scheduledExecutor().get()).scheduleAtFixedRate(() -> {
                    try {
                        this.periodicMaintenance();
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2 = throwable;
                        Option option = NonFatal$.MODULE$.unapply(throwable2);
                        if (!option.isEmpty()) {
                            Throwable ex = (Throwable)option.get();
                            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Unexpected exception in periodic task", ex);
                        }
                        throw throwable;
                    }
                }, this.sessionPollingPeriod().toMillis(), this.sessionPollingPeriod().toMillis(), TimeUnit.MILLISECONDS);
            } else {
                throw new MatchError(option);
            }
        }
    }

    private void periodicMaintenance() {
        Object object = this.queryCacheLock();
        synchronized (object) {
            long nowMs = this.clock().getTimeMillis();
            this.queryCache().withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)SparkConnectStreamingQueryCache.$anonfun$periodicMaintenance$1(check$ifrefutable$2))).foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
                Tuple2 tuple2 = x$3;
                if (tuple2 != null) {
                    QueryCacheKey k = (QueryCacheKey)tuple2._1();
                    QueryCacheValue v = (QueryCacheValue)tuple2._2();
                    String id = k.queryId();
                    boolean bl = false;
                    Some some = null;
                    Option<Object> option = v.expiresAtMs();
                    if (option instanceof Some) {
                        bl = true;
                        some = (Some)option;
                        long ts = BoxesRunTime.unboxToLong((Object)some.value());
                        if (nowMs >= ts) {
                            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("Removing references for ").append(id).append(" in session ").append(v.sessionId()).append(" after expiry period").toString());
                            return this.queryCache().remove((Object)k);
                        }
                    }
                    if (bl) {
                        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(43).append("Waiting for the expiration for ").append(id).append(" in session ").append(v.sessionId()).toString());
                        return BoxedUnit.UNIT;
                    }
                    if (None$.MODULE$.equals(option)) {
                        boolean isActive;
                        boolean bl2 = isActive = v.query().isActive() && Option$.MODULE$.apply((Object)v.session().streams().get(id)).nonEmpty();
                        if (!isActive) {
                            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("Marking query ").append(id).append(" in session ").append(v.sessionId()).append(" inactive.").toString());
                            long expiresAtMs = nowMs + this.stoppedQueryInactivityTimeout().toMillis();
                            Some x$1 = new Some((Object)BoxesRunTime.boxToLong((long)expiresAtMs));
                            String x$2 = v.copy$default$1();
                            String x$32 = v.copy$default$2();
                            SparkSession x$4 = v.copy$default$3();
                            StreamingQuery x$5 = v.copy$default$4();
                            return this.queryCache().put((Object)k, (Object)v.copy(x$2, x$32, x$4, x$5, (Option<Object>)x$1));
                        }
                        return BoxedUnit.UNIT;
                    }
                    throw new MatchError(option);
                }
                throw new MatchError((Object)tuple2);
            });
        }
    }

    public static final /* synthetic */ Option $anonfun$getCachedQuery$2(SparkConnectStreamingQueryCache $this, QueryCacheKey key$1, QueryCacheValue v$1, long x$1) {
        long expiresAtMs = $this.clock().getTimeMillis() + $this.stoppedQueryInactivityTimeout().toMillis();
        Some x$12 = new Some((Object)BoxesRunTime.boxToLong((long)expiresAtMs));
        String x$2 = v$1.copy$default$1();
        String x$3 = v$1.copy$default$2();
        SparkSession x$4 = v$1.copy$default$3();
        StreamingQuery x$5 = v$1.copy$default$4();
        return $this.queryCache().put((Object)key$1, (Object)v$1.copy(x$2, x$3, x$4, x$5, (Option<Object>)x$12));
    }

    public static final /* synthetic */ boolean $anonfun$cleanupRunningQueries$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        return tuple2 != null;
    }

    public static final /* synthetic */ void $anonfun$cleanupRunningQueries$2(SparkConnectStreamingQueryCache $this, SessionHolder sessionHolder$1, Tuple2 x$2) {
        Tuple2 tuple2 = x$2;
        if (tuple2 != null) {
            QueryCacheKey k = (QueryCacheKey)tuple2._1();
            QueryCacheValue v = (QueryCacheValue)tuple2._2();
            if (v.userId().equals(sessionHolder$1.userId()) && v.sessionId().equals(sessionHolder$1.sessionId())) {
                if (v.query().isActive() && Option$.MODULE$.apply((Object)v.session().streams().get(k.queryId())).nonEmpty()) {
                    BoxedUnit boxedUnit;
                    $this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(59).append("Stopping the query with id ").append(k.queryId()).append(" since the session has timed out").toString());
                    try {
                        v.query().stop();
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2 = throwable;
                        Option option = NonFatal$.MODULE$.unapply(throwable2);
                        if (option.isEmpty()) {
                            throw throwable;
                        }
                        Throwable ex = (Throwable)option.get();
                        $this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Failed to stop the query ").append(k.queryId()).append(". Error is ignored.").toString(), ex);
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    return;
                }
                return;
            }
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$shutdown$1(ScheduledExecutorService executor) {
        executor.shutdown();
        return executor.awaitTermination(1L, TimeUnit.MINUTES);
    }

    public static final /* synthetic */ boolean $anonfun$periodicMaintenance$1(Tuple2 check$ifrefutable$2) {
        Tuple2 tuple2 = check$ifrefutable$2;
        return tuple2 != null;
    }

    public SparkConnectStreamingQueryCache(Clock clock, Duration stoppedQueryInactivityTimeout, Duration sessionPollingPeriod) {
        this.clock = clock;
        this.stoppedQueryInactivityTimeout = stoppedQueryInactivityTimeout;
        this.sessionPollingPeriod = sessionPollingPeriod;
        Logging.$init$((Logging)this);
        this.queryCache = new HashMap();
        this.queryCacheLock = new Object();
        this.scheduledExecutor = None$.MODULE$;
    }

    public static class QueryCacheKey
    implements Product,
    scala.Serializable {
        private final String queryId;
        private final String runId;

        public String queryId() {
            return this.queryId;
        }

        public String runId() {
            return this.runId;
        }

        public QueryCacheKey copy(String queryId, String runId) {
            return new QueryCacheKey(queryId, runId);
        }

        public String copy$default$1() {
            return this.queryId();
        }

        public String copy$default$2() {
            return this.runId();
        }

        public String productPrefix() {
            return "QueryCacheKey";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.queryId();
                }
                case 1: {
                    return this.runId();
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(x$1));
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof QueryCacheKey;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof QueryCacheKey)) return false;
            boolean bl = true;
            if (!bl) return false;
            QueryCacheKey queryCacheKey = (QueryCacheKey)x$1;
            String string = this.queryId();
            String string2 = queryCacheKey.queryId();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.runId();
            String string4 = queryCacheKey.runId();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            if (!queryCacheKey.canEqual(this)) return false;
            return true;
        }

        public QueryCacheKey(String queryId, String runId) {
            this.queryId = queryId;
            this.runId = runId;
            Product.$init$((Product)this);
        }
    }

    public static class QueryCacheValue
    implements Product,
    scala.Serializable {
        private final String userId;
        private final String sessionId;
        private final SparkSession session;
        private final StreamingQuery query;
        private final Option<Object> expiresAtMs;

        public String userId() {
            return this.userId;
        }

        public String sessionId() {
            return this.sessionId;
        }

        public SparkSession session() {
            return this.session;
        }

        public StreamingQuery query() {
            return this.query;
        }

        public Option<Object> expiresAtMs() {
            return this.expiresAtMs;
        }

        public String toString() {
            return new StringBuilder(36).append("[session id: ").append(this.sessionId()).append(", query id: ").append(this.query().id()).append(", run id: ").append(this.query().runId()).append("]").toString();
        }

        public QueryCacheValue copy(String userId, String sessionId, SparkSession session, StreamingQuery query, Option<Object> expiresAtMs) {
            return new QueryCacheValue(userId, sessionId, session, query, expiresAtMs);
        }

        public String copy$default$1() {
            return this.userId();
        }

        public String copy$default$2() {
            return this.sessionId();
        }

        public SparkSession copy$default$3() {
            return this.session();
        }

        public StreamingQuery copy$default$4() {
            return this.query();
        }

        public Option<Object> copy$default$5() {
            return this.expiresAtMs();
        }

        public String productPrefix() {
            return "QueryCacheValue";
        }

        public int productArity() {
            return 5;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.userId();
                }
                case 1: {
                    return this.sessionId();
                }
                case 2: {
                    return this.session();
                }
                case 3: {
                    return this.query();
                }
                case 4: {
                    return this.expiresAtMs();
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(x$1));
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof QueryCacheValue;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof QueryCacheValue)) return false;
            boolean bl = true;
            if (!bl) return false;
            QueryCacheValue queryCacheValue = (QueryCacheValue)x$1;
            String string = this.userId();
            String string2 = queryCacheValue.userId();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.sessionId();
            String string4 = queryCacheValue.sessionId();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            SparkSession sparkSession = this.session();
            SparkSession sparkSession2 = queryCacheValue.session();
            if (sparkSession == null) {
                if (sparkSession2 != null) {
                    return false;
                }
            } else if (!sparkSession.equals(sparkSession2)) return false;
            StreamingQuery streamingQuery = this.query();
            StreamingQuery streamingQuery2 = queryCacheValue.query();
            if (streamingQuery == null) {
                if (streamingQuery2 != null) {
                    return false;
                }
            } else if (!streamingQuery.equals(streamingQuery2)) return false;
            Option<Object> option = this.expiresAtMs();
            Option<Object> option2 = queryCacheValue.expiresAtMs();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            if (!queryCacheValue.canEqual(this)) return false;
            return true;
        }

        public QueryCacheValue(String userId, String sessionId, SparkSession session, StreamingQuery query, Option<Object> expiresAtMs) {
            this.userId = userId;
            this.sessionId = sessionId;
            this.session = session;
            this.query = query;
            this.expiresAtMs = expiresAtMs;
            Product.$init$((Product)this);
        }
    }
}

