/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connect.service;

import java.util.concurrent.TimeUnit;
import org.apache.spark.SparkEnv$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.connect.config.Connect$;
import org.apache.spark.sql.connect.service.SessionHolder;
import org.apache.spark.sql.connect.service.SparkConnectInterceptorRegistry$;
import org.apache.spark.sql.connect.service.SparkConnectService;
import org.sparkproject.connect.grpc.Server;
import org.sparkproject.connect.grpc.netty.NettyServerBuilder;
import org.sparkproject.connect.grpc.protobuf.services.ProtoReflectionService;
import org.sparkproject.connect.guava.base.Ticker;
import org.sparkproject.connect.guava.cache.Cache;
import org.sparkproject.connect.guava.cache.CacheBuilder;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class SparkConnectService$ {
    public static final SparkConnectService$ MODULE$ = new SparkConnectService$();
    private static final int CACHE_SIZE = 100;
    private static final int CACHE_TIMEOUT_SECONDS = 3600;
    private static Server server;
    private static final Cache<Tuple2<String, String>, SessionHolder> userSessionMapping;

    static {
        userSessionMapping = MODULE$.cacheBuilder(MODULE$.CACHE_SIZE(), MODULE$.CACHE_TIMEOUT_SECONDS()).build();
    }

    private int CACHE_SIZE() {
        return CACHE_SIZE;
    }

    private int CACHE_TIMEOUT_SECONDS() {
        return CACHE_TIMEOUT_SECONDS;
    }

    public Server server() {
        return server;
    }

    public void server_$eq(Server x$1) {
        server = x$1;
    }

    public int localPort() {
        Predef$.MODULE$.assert(this.server() != null);
        return this.server().getPort();
    }

    private Cache<Tuple2<String, String>, SessionHolder> userSessionMapping() {
        return userSessionMapping;
    }

    /*
     * WARNING - void declaration
     */
    private CacheBuilder<Object, Object> cacheBuilder(int cacheSize, int timeoutSeconds) {
        void var3_3;
        CacheBuilder<Object, Object> cacheBuilder = CacheBuilder.newBuilder().ticker(Ticker.systemTicker());
        if (cacheSize >= 0) {
            cacheBuilder = cacheBuilder.maximumSize(cacheSize);
        }
        Object object = timeoutSeconds >= 0 ? cacheBuilder.expireAfterAccess(timeoutSeconds, TimeUnit.SECONDS) : BoxedUnit.UNIT;
        return var3_3;
    }

    public SessionHolder getOrCreateIsolatedSession(String userId, String sessionId) {
        return this.userSessionMapping().get((Tuple2<String, String>)new Tuple2((Object)userId, (Object)sessionId), () -> new SessionHolder(userId, sessionId, MODULE$.newIsolatedSession()));
    }

    private SparkSession newIsolatedSession() {
        return SparkSession$.MODULE$.active().newSession();
    }

    private void startGRPCService() {
        boolean debugMode = SparkEnv$.MODULE$.get().conf().getBoolean("spark.connect.grpc.debug.enabled", true);
        int port = BoxesRunTime.unboxToInt((Object)SparkEnv$.MODULE$.get().conf().get(Connect$.MODULE$.CONNECT_GRPC_BINDING_PORT()));
        NettyServerBuilder sb = (NettyServerBuilder)NettyServerBuilder.forPort(port).maxInboundMessageSize((int)BoxesRunTime.unboxToLong((Object)SparkEnv$.MODULE$.get().conf().get(Connect$.MODULE$.CONNECT_GRPC_MAX_INBOUND_MESSAGE_SIZE()))).addService(new SparkConnectService(debugMode));
        SparkConnectInterceptorRegistry$.MODULE$.chainInterceptors(sb);
        Object object = debugMode ? sb.addService(ProtoReflectionService.newInstance()) : BoxedUnit.UNIT;
        this.server_$eq(sb.build());
        this.server().start();
    }

    public void start() {
        this.startGRPCService();
    }

    public void stop(Option<Object> timeout, Option<TimeUnit> unit) {
        block2: {
            if (this.server() == null) break block2;
            if (timeout.isDefined() && unit.isDefined()) {
                this.server().shutdown();
                this.server().awaitTermination(BoxesRunTime.unboxToLong((Object)timeout.get()), (TimeUnit)((Object)unit.get()));
            } else {
                this.server().shutdownNow();
            }
        }
    }

    public Option<Object> stop$default$1() {
        return None$.MODULE$;
    }

    public Option<TimeUnit> stop$default$2() {
        return None$.MODULE$;
    }

    private SparkConnectService$() {
    }
}

