/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connect.service;

import java.io.Serializable;
import org.apache.spark.connect.proto.Command;
import org.apache.spark.connect.proto.ExecutePlanRequest;
import org.apache.spark.connect.proto.ExecutePlanResponse;
import org.apache.spark.connect.proto.Plan;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Dataset$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.connect.planner.SparkConnectPlanner;
import org.apache.spark.sql.connect.service.SparkConnectService$;
import org.apache.spark.sql.connect.service.SparkConnectStreamHandler$;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import org.sparkproject.connect.grpc.stub.StreamObserver;
import scala.Function0;
import scala.Function1;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005}d\u0001B\b\u0011\u0001uA\u0001B\u000b\u0001\u0003\u0002\u0003\u0006Ia\u000b\u0005\u0006y\u0001!\t!\u0010\u0005\u0006\u0003\u0002!\tA\u0011\u0005\u0006\u0017\u0002!I\u0001\u0014\u0005\u0006+\u0002!IAV\u0004\u00063BA\tA\u0017\u0004\u0006\u001fAA\ta\u0017\u0005\u0006y\u001d!\t\u0001X\u0003\u0005;\u001e\u0001a\fC\u0003k\u000f\u0011\u00051\u000eC\u0004\u0002<\u001d!\t!!\u0010\t\u000f\u0005\u0015t\u0001\"\u0001\u0002h!9\u0011QN\u0004\u0005\u0002\u0005=\u0004bBA<\u000f\u0011\u0005\u0011\u0011\u0010\u0002\u001a'B\f'o[\"p]:,7\r^*ue\u0016\fW\u000eS1oI2,'O\u0003\u0002\u0012%\u000591/\u001a:wS\u000e,'BA\n\u0015\u0003\u001d\u0019wN\u001c8fGRT!!\u0006\f\u0002\u0007M\fHN\u0003\u0002\u00181\u0005)1\u000f]1sW*\u0011\u0011DG\u0001\u0007CB\f7\r[3\u000b\u0003m\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\u0010%!\ty\"%D\u0001!\u0015\u0005\t\u0013!B:dC2\f\u0017BA\u0012!\u0005\u0019\te.\u001f*fMB\u0011Q\u0005K\u0007\u0002M)\u0011qEF\u0001\tS:$XM\u001d8bY&\u0011\u0011F\n\u0002\b\u0019><w-\u001b8h\u0003A\u0011Xm\u001d9p]N,wJY:feZ,'\u000fE\u0002-gUj\u0011!\f\u0006\u0003]=\nAa\u001d;vE*\u0011\u0001'M\u0001\u0005OJ\u00048MC\u00013\u0003\tIw.\u0003\u00025[\tq1\u000b\u001e:fC6|%m]3sm\u0016\u0014\bC\u0001\u001c;\u001b\u00059$B\u0001\u001d:\u0003\u0015\u0001(o\u001c;p\u0015\t\u0019b#\u0003\u0002<o\t\u0019R\t_3dkR,\u0007\u000b\\1o%\u0016\u001c\bo\u001c8tK\u00061A(\u001b8jiz\"\"A\u0010!\u0011\u0005}\u0002Q\"\u0001\t\t\u000b)\u0012\u0001\u0019A\u0016\u0002\r!\fg\u000e\u001a7f)\t\u0019e\t\u0005\u0002 \t&\u0011Q\t\t\u0002\u0005+:LG\u000fC\u0003H\u0007\u0001\u0007\u0001*A\u0001w!\t1\u0014*\u0003\u0002Ko\t\u0011R\t_3dkR,\u0007\u000b\\1o%\u0016\fX/Z:u\u0003)A\u0017M\u001c3mKBc\u0017M\u001c\u000b\u0004\u00076\u001b\u0006\"\u0002(\u0005\u0001\u0004y\u0015aB:fgNLwN\u001c\t\u0003!Fk\u0011\u0001F\u0005\u0003%R\u0011Ab\u00159be.\u001cVm]:j_:DQ\u0001\u0016\u0003A\u0002!\u000bqA]3rk\u0016\u001cH/A\u0007iC:$G.Z\"p[6\fg\u000e\u001a\u000b\u0004\u0007^C\u0006\"\u0002(\u0006\u0001\u0004y\u0005\"\u0002+\u0006\u0001\u0004A\u0015!G*qCJ\\7i\u001c8oK\u000e$8\u000b\u001e:fC6D\u0015M\u001c3mKJ\u0004\"aP\u0004\u0014\u0005\u001dqB#\u0001.\u0003\u000b\t\u000bGo\u00195\u0011\t}y\u0016mZ\u0005\u0003A\u0002\u0012a\u0001V;qY\u0016\u0014\u0004cA\u0010cI&\u00111\r\t\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003?\u0015L!A\u001a\u0011\u0003\t\tKH/\u001a\t\u0003?!L!!\u001b\u0011\u0003\t1{gnZ\u0001\u0014e><Hk\\!se><8i\u001c8wKJ$XM\u001d\u000b\nY\u0006%\u0011\u0011DA\u0012\u0003O\u0001RaH7p\u0003\u0007I!A\u001c\u0011\u0003\u0013\u0019+hn\u0019;j_:\f\u0004c\u00019yw:\u0011\u0011O\u001e\b\u0003eVl\u0011a\u001d\u0006\u0003ir\ta\u0001\u0010:p_Rt\u0014\"A\u0011\n\u0005]\u0004\u0013a\u00029bG.\fw-Z\u0005\u0003sj\u0014\u0001\"\u0013;fe\u0006$xN\u001d\u0006\u0003o\u0002\u0002\"\u0001`@\u000e\u0003uT!A \u000b\u0002\u0011\r\fG/\u00197zgRL1!!\u0001~\u0005-Ie\u000e^3s]\u0006d'k\\<\u0011\tAD\u0018Q\u0001\t\u0004\u0003\u000fIQ\"A\u0004\t\u000f\u0005-!\u00021\u0001\u0002\u000e\u000511o\u00195f[\u0006\u0004B!a\u0004\u0002\u00165\u0011\u0011\u0011\u0003\u0006\u0004\u0003'!\u0012!\u0002;za\u0016\u001c\u0018\u0002BA\f\u0003#\u0011!b\u0015;sk\u000e$H+\u001f9f\u0011\u001d\tYB\u0003a\u0001\u0003;\t!#\\1y%\u0016\u001cwN\u001d3t!\u0016\u0014()\u0019;dQB\u0019q$a\b\n\u0007\u0005\u0005\u0002EA\u0002J]RDa!!\n\u000b\u0001\u00049\u0017\u0001D7bq\n\u000bGo\u00195TSj,\u0007bBA\u0015\u0015\u0001\u0007\u00111F\u0001\u000bi&lWMW8oK&#\u0007\u0003BA\u0017\u0003kqA!a\f\u00022A\u0011!\u000fI\u0005\u0004\u0003g\u0001\u0013A\u0002)sK\u0012,g-\u0003\u0003\u00028\u0005e\"AB*ue&twMC\u0002\u00024\u0001\nQ\u0003\u001d:pG\u0016\u001c8/Q:BeJ|wOQ1uG\",7\u000fF\u0004D\u0003\u007f\t\u0019%a\u0019\t\u000f\u0005\u00053\u00021\u0001\u0002,\u0005I1/Z:tS>t\u0017\n\u001a\u0005\b\u0003\u000bZ\u0001\u0019AA$\u0003%!\u0017\r^1ge\u0006lW\r\u0005\u0003\u0002J\u0005uc\u0002BA&\u00037rA!!\u0014\u0002Z9!\u0011qJA,\u001d\u0011\t\t&!\u0016\u000f\u0007I\f\u0019&C\u0001\u001c\u0013\tI\"$\u0003\u0002\u00181%\u0011QCF\u0005\u0003oRIA!a\u0018\u0002b\tIA)\u0019;b\rJ\fW.\u001a\u0006\u0003oRAQAK\u0006A\u0002-\nAc]3oIN\u001b\u0007.Z7b)>\u0014Vm\u001d9p]N,G#B\u001b\u0002j\u0005-\u0004bBA!\u0019\u0001\u0007\u00111\u0006\u0005\b\u0003\u0017a\u0001\u0019AA\u0007\u0003U\u0019'/Z1uK6+GO]5dgJ+7\u000f]8og\u0016$R!NA9\u0003gBq!!\u0011\u000e\u0001\u0004\tY\u0003C\u0004\u0002v5\u0001\r!a\u0012\u0002\tI|wo]\u0001\u001eg\u0016tGm\u00142tKJ4X\rZ'fiJL7m\u001d+p%\u0016\u001c\bo\u001c8tKR)Q'a\u001f\u0002~!9\u0011\u0011\t\bA\u0002\u0005-\u0002bBA#\u001d\u0001\u0007\u0011q\t")
public class SparkConnectStreamHandler
implements Logging {
    private final StreamObserver<ExecutePlanResponse> responseObserver;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static ExecutePlanResponse sendObservedMetricsToResponse(String sessionId, Dataset<Row> dataframe) {
        return SparkConnectStreamHandler$.MODULE$.sendObservedMetricsToResponse(sessionId, dataframe);
    }

    public static ExecutePlanResponse createMetricsResponse(String sessionId, Dataset<Row> rows) {
        return SparkConnectStreamHandler$.MODULE$.createMetricsResponse(sessionId, rows);
    }

    public static ExecutePlanResponse sendSchemaToResponse(String sessionId, StructType schema) {
        return SparkConnectStreamHandler$.MODULE$.sendSchemaToResponse(sessionId, schema);
    }

    public static void processAsArrowBatches(String sessionId, Dataset<Row> dataframe, StreamObserver<ExecutePlanResponse> responseObserver) {
        SparkConnectStreamHandler$.MODULE$.processAsArrowBatches(sessionId, dataframe, responseObserver);
    }

    public static Function1<Iterator<InternalRow>, Iterator<Tuple2<byte[], Object>>> rowToArrowConverter(StructType schema, int maxRecordsPerBatch, long maxBatchSize, String timeZoneId) {
        return SparkConnectStreamHandler$.MODULE$.rowToArrowConverter(schema, maxRecordsPerBatch, maxBatchSize, timeZoneId);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public void handle(ExecutePlanRequest v) {
        SparkSession session = SparkConnectService$.MODULE$.getOrCreateIsolatedSession(v.getUserContext().getUserId(), v.getSessionId()).session();
        session.withActive((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Plan.OpTypeCase opTypeCase = v.getPlan().getOpTypeCase();
            if (Plan.OpTypeCase.COMMAND.equals(opTypeCase)) {
                this.handleCommand(session, v);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (Plan.OpTypeCase.ROOT.equals(opTypeCase)) {
                this.handlePlan(session, v);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new UnsupportedOperationException(new StringBuilder(15).append(v.getPlan().getOpTypeCase()).append(" not supported.").toString());
            }
        });
    }

    private void handlePlan(SparkSession session, ExecutePlanRequest request) {
        SparkConnectPlanner planner = new SparkConnectPlanner(session);
        Dataset dataframe = Dataset$.MODULE$.ofRows(session, planner.transformRelation(request.getPlan().getRoot()));
        this.responseObserver.onNext(SparkConnectStreamHandler$.MODULE$.sendSchemaToResponse(request.getSessionId(), dataframe.schema()));
        SparkConnectStreamHandler$.MODULE$.processAsArrowBatches(request.getSessionId(), (Dataset<Row>)dataframe, this.responseObserver);
        this.responseObserver.onNext(SparkConnectStreamHandler$.MODULE$.createMetricsResponse(request.getSessionId(), (Dataset<Row>)dataframe));
        if (dataframe.queryExecution().observedMetrics().nonEmpty()) {
            this.responseObserver.onNext(SparkConnectStreamHandler$.MODULE$.sendObservedMetricsToResponse(request.getSessionId(), (Dataset<Row>)dataframe));
        }
        this.responseObserver.onCompleted();
    }

    private void handleCommand(SparkSession session, ExecutePlanRequest request) {
        Command command = request.getPlan().getCommand();
        SparkConnectPlanner planner = new SparkConnectPlanner(session);
        planner.process(command, request.getSessionId(), this.responseObserver);
        this.responseObserver.onCompleted();
    }

    public SparkConnectStreamHandler(StreamObserver<ExecutePlanResponse> responseObserver) {
        this.responseObserver = responseObserver;
        Logging.$init$((Logging)this);
    }
}

