/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.connect.guava.collect;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.CheckForNull;
import org.sparkproject.connect.checkerframework.checker.nullness.qual.Nullable;
import org.sparkproject.connect.guava.annotations.GwtCompatible;
import org.sparkproject.connect.guava.base.Preconditions;
import org.sparkproject.connect.guava.collect.ElementTypesAreNonnullByDefault;
import org.sparkproject.connect.guava.collect.ImmutableCollection;
import org.sparkproject.connect.guava.collect.ImmutableList;
import org.sparkproject.connect.guava.collect.ImmutableMap;
import org.sparkproject.connect.guava.collect.ImmutableMapEntrySet;
import org.sparkproject.connect.guava.collect.ImmutableMapKeySet;
import org.sparkproject.connect.guava.collect.ImmutableMapValues;
import org.sparkproject.connect.guava.collect.ImmutableSet;
import org.sparkproject.connect.guava.collect.Maps;
import org.sparkproject.connect.guava.collect.RegularImmutableMap;

@ElementTypesAreNonnullByDefault
@GwtCompatible(emulated=true)
final class JdkBackedImmutableMap<K, V>
extends ImmutableMap<K, V> {
    private final transient Map<K, V> delegateMap;
    private final transient ImmutableList<Map.Entry<K, V>> entries;

    static <K, V> ImmutableMap<K, V> create(int n, @Nullable Map.Entry<K, V>[] entryArray) {
        HashMap<K, V> delegateMap = Maps.newHashMapWithExpectedSize(n);
        for (int i = 0; i < n; ++i) {
            entryArray[i] = RegularImmutableMap.makeImmutable(Objects.requireNonNull(entryArray[i]));
            V oldValue = delegateMap.putIfAbsent(entryArray[i].getKey(), entryArray[i].getValue());
            if (oldValue == null) continue;
            String string = String.valueOf(entryArray[i].getKey());
            String string2 = String.valueOf(oldValue);
            throw JdkBackedImmutableMap.conflictException("key", entryArray[i], new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("=").append(string2).toString());
        }
        return new JdkBackedImmutableMap(delegateMap, ImmutableList.asImmutableList(entryArray, n));
    }

    JdkBackedImmutableMap(Map<K, V> delegateMap, ImmutableList<Map.Entry<K, V>> entries) {
        this.delegateMap = delegateMap;
        this.entries = entries;
    }

    @Override
    public int size() {
        return this.entries.size();
    }

    @Override
    @CheckForNull
    public V get(@CheckForNull Object key) {
        return this.delegateMap.get(key);
    }

    @Override
    ImmutableSet<Map.Entry<K, V>> createEntrySet() {
        return new ImmutableMapEntrySet.RegularEntrySet<K, V>(this, this.entries);
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> action) {
        Preconditions.checkNotNull(action);
        this.entries.forEach((Consumer<Map.Entry<K, V>>)((Consumer<Map.Entry>)e -> action.accept((Object)e.getKey(), (Object)e.getValue())));
    }

    @Override
    ImmutableSet<K> createKeySet() {
        return new ImmutableMapKeySet(this);
    }

    @Override
    ImmutableCollection<V> createValues() {
        return new ImmutableMapValues(this);
    }

    @Override
    boolean isPartialView() {
        return false;
    }
}

