/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.connect.guava.collect;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.CheckForNull;
import org.sparkproject.connect.checkerframework.checker.nullness.qual.Nullable;
import org.sparkproject.connect.errorprone_annotations.CanIgnoreReturnValue;
import org.sparkproject.connect.guava.annotations.GwtCompatible;
import org.sparkproject.connect.guava.annotations.VisibleForTesting;
import org.sparkproject.connect.guava.base.Function;
import org.sparkproject.connect.guava.base.Preconditions;
import org.sparkproject.connect.guava.collect.AllEqualOrdering;
import org.sparkproject.connect.guava.collect.ByFunctionOrdering;
import org.sparkproject.connect.guava.collect.CollectPreconditions;
import org.sparkproject.connect.guava.collect.ComparatorOrdering;
import org.sparkproject.connect.guava.collect.CompoundOrdering;
import org.sparkproject.connect.guava.collect.ElementTypesAreNonnullByDefault;
import org.sparkproject.connect.guava.collect.ExplicitOrdering;
import org.sparkproject.connect.guava.collect.ImmutableList;
import org.sparkproject.connect.guava.collect.Iterables;
import org.sparkproject.connect.guava.collect.LexicographicalOrdering;
import org.sparkproject.connect.guava.collect.Lists;
import org.sparkproject.connect.guava.collect.MapMaker;
import org.sparkproject.connect.guava.collect.Maps;
import org.sparkproject.connect.guava.collect.NaturalOrdering;
import org.sparkproject.connect.guava.collect.NullsFirstOrdering;
import org.sparkproject.connect.guava.collect.NullsLastOrdering;
import org.sparkproject.connect.guava.collect.ParametricNullness;
import org.sparkproject.connect.guava.collect.Platform;
import org.sparkproject.connect.guava.collect.ReverseOrdering;
import org.sparkproject.connect.guava.collect.TopKSelector;
import org.sparkproject.connect.guava.collect.UsingToStringOrdering;

@ElementTypesAreNonnullByDefault
@GwtCompatible
public abstract class Ordering<T>
implements Comparator<T> {
    static final int LEFT_IS_GREATER = 1;
    static final int RIGHT_IS_GREATER = -1;

    @GwtCompatible(serializable=true)
    public static <C extends Comparable> Ordering<C> natural() {
        return NaturalOrdering.INSTANCE;
    }

    @GwtCompatible(serializable=true)
    public static <T> Ordering<T> from(Comparator<T> comparator) {
        return comparator instanceof Ordering ? (Ordering<T>)comparator : new ComparatorOrdering<T>(comparator);
    }

    @Deprecated
    @GwtCompatible(serializable=true)
    public static <T> Ordering<T> from(Ordering<T> ordering) {
        return Preconditions.checkNotNull(ordering);
    }

    @GwtCompatible(serializable=true)
    public static <T> Ordering<T> explicit(List<T> valuesInOrder) {
        return new ExplicitOrdering<T>(valuesInOrder);
    }

    @GwtCompatible(serializable=true)
    public static <T> Ordering<T> explicit(T leastValue, T ... remainingValuesInOrder) {
        return Ordering.explicit(Lists.asList(leastValue, remainingValuesInOrder));
    }

    @GwtCompatible(serializable=true)
    public static Ordering<@Nullable Object> allEqual() {
        return AllEqualOrdering.INSTANCE;
    }

    @GwtCompatible(serializable=true)
    public static Ordering<Object> usingToString() {
        return UsingToStringOrdering.INSTANCE;
    }

    public static Ordering<@Nullable Object> arbitrary() {
        return ArbitraryOrderingHolder.ARBITRARY_ORDERING;
    }

    protected Ordering() {
    }

    @GwtCompatible(serializable=true)
    public <S extends T> Ordering<S> reverse() {
        return new ReverseOrdering(this);
    }

    @GwtCompatible(serializable=true)
    public <S extends T> Ordering<@Nullable S> nullsFirst() {
        return new NullsFirstOrdering(this);
    }

    @GwtCompatible(serializable=true)
    public <S extends T> Ordering<@Nullable S> nullsLast() {
        return new NullsLastOrdering(this);
    }

    @GwtCompatible(serializable=true)
    public <F> Ordering<F> onResultOf(Function<F, ? extends T> function) {
        return new ByFunctionOrdering<F, T>(function, this);
    }

    <T2 extends T> Ordering<Map.Entry<T2, ?>> onKeys() {
        return this.onResultOf(Maps.keyFunction());
    }

    @GwtCompatible(serializable=true)
    public <U extends T> Ordering<U> compound(Comparator<? super U> secondaryComparator) {
        return new CompoundOrdering<U>(this, Preconditions.checkNotNull(secondaryComparator));
    }

    @GwtCompatible(serializable=true)
    public static <T> Ordering<T> compound(Iterable<? extends Comparator<? super T>> comparators) {
        return new CompoundOrdering(comparators);
    }

    @GwtCompatible(serializable=true)
    public <S extends T> Ordering<Iterable<S>> lexicographical() {
        return new LexicographicalOrdering(this);
    }

    @Override
    @CanIgnoreReturnValue
    public abstract int compare(@ParametricNullness T var1, @ParametricNullness T var2);

    @ParametricNullness
    public <E extends T> E min(Iterator<E> iterator) {
        E minSoFar = iterator.next();
        while (iterator.hasNext()) {
            minSoFar = this.min(minSoFar, iterator.next());
        }
        return minSoFar;
    }

    @ParametricNullness
    public <E extends T> E min(Iterable<E> iterable) {
        return this.min(iterable.iterator());
    }

    @ParametricNullness
    public <E extends T> E min(@ParametricNullness E a, @ParametricNullness E b) {
        return this.compare(a, b) <= 0 ? a : b;
    }

    @ParametricNullness
    public <E extends T> E min(@ParametricNullness E a, @ParametricNullness E b, @ParametricNullness E c, E ... rest) {
        E minSoFar = this.min(this.min(a, b), c);
        for (E r : rest) {
            minSoFar = this.min(minSoFar, r);
        }
        return minSoFar;
    }

    @ParametricNullness
    public <E extends T> E max(Iterator<E> iterator) {
        E maxSoFar = iterator.next();
        while (iterator.hasNext()) {
            maxSoFar = this.max(maxSoFar, iterator.next());
        }
        return maxSoFar;
    }

    @ParametricNullness
    public <E extends T> E max(Iterable<E> iterable) {
        return this.max(iterable.iterator());
    }

    @ParametricNullness
    public <E extends T> E max(@ParametricNullness E a, @ParametricNullness E b) {
        return this.compare(a, b) >= 0 ? a : b;
    }

    @ParametricNullness
    public <E extends T> E max(@ParametricNullness E a, @ParametricNullness E b, @ParametricNullness E c, E ... rest) {
        E maxSoFar = this.max(this.max(a, b), c);
        for (E r : rest) {
            maxSoFar = this.max(maxSoFar, r);
        }
        return maxSoFar;
    }

    public <E extends T> List<E> leastOf(Iterable<E> iterable, int k) {
        Collection collection;
        if (iterable instanceof Collection && (long)(collection = (Collection)iterable).size() <= 2L * (long)k) {
            Object[] array = collection.toArray();
            Arrays.sort(array, this);
            if (array.length > k) {
                array = Arrays.copyOf(array, k);
            }
            return Collections.unmodifiableList(Arrays.asList(array));
        }
        return this.leastOf(iterable.iterator(), k);
    }

    public <E extends T> List<E> leastOf(Iterator<E> iterator, int k) {
        Preconditions.checkNotNull(iterator);
        CollectPreconditions.checkNonnegative(k, "k");
        if (k == 0 || !iterator.hasNext()) {
            return Collections.emptyList();
        }
        if (k >= 0x3FFFFFFF) {
            ArrayList<E> list = Lists.newArrayList(iterator);
            Collections.sort(list, this);
            if (list.size() > k) {
                list.subList(k, list.size()).clear();
            }
            list.trimToSize();
            return Collections.unmodifiableList(list);
        }
        TopKSelector<E> selector = TopKSelector.least(k, this);
        selector.offerAll(iterator);
        return selector.topK();
    }

    public <E extends T> List<E> greatestOf(Iterable<E> iterable, int k) {
        return this.reverse().leastOf(iterable, k);
    }

    public <E extends T> List<E> greatestOf(Iterator<E> iterator, int k) {
        return this.reverse().leastOf(iterator, k);
    }

    public <E extends T> List<E> sortedCopy(Iterable<E> elements) {
        Object[] array = Iterables.toArray(elements);
        Arrays.sort(array, this);
        return Lists.newArrayList(Arrays.asList(array));
    }

    public <E extends T> ImmutableList<E> immutableSortedCopy(Iterable<E> elements) {
        return ImmutableList.sortedCopyOf(this, elements);
    }

    public boolean isOrdered(Iterable<? extends T> iterable) {
        Iterator<T> it = iterable.iterator();
        if (it.hasNext()) {
            T prev = it.next();
            while (it.hasNext()) {
                T next = it.next();
                if (this.compare(prev, next) > 0) {
                    return false;
                }
                prev = next;
            }
        }
        return true;
    }

    public boolean isStrictlyOrdered(Iterable<? extends T> iterable) {
        Iterator<T> it = iterable.iterator();
        if (it.hasNext()) {
            T prev = it.next();
            while (it.hasNext()) {
                T next = it.next();
                if (this.compare(prev, next) >= 0) {
                    return false;
                }
                prev = next;
            }
        }
        return true;
    }

    @Deprecated
    public int binarySearch(List<? extends T> sortedList, @ParametricNullness T key) {
        return Collections.binarySearch(sortedList, key, this);
    }

    @VisibleForTesting
    static class IncomparableValueException
    extends ClassCastException {
        final Object value;
        private static final long serialVersionUID = 0L;

        IncomparableValueException(Object value) {
            String string = String.valueOf(value);
            super(new StringBuilder(22 + String.valueOf(string).length()).append("Cannot compare value: ").append(string).toString());
            this.value = value;
        }
    }

    @VisibleForTesting
    static class ArbitraryOrdering
    extends Ordering<Object> {
        private final AtomicInteger counter = new AtomicInteger(0);
        private final ConcurrentMap<Object, Integer> uids = Platform.tryWeakKeys(new MapMaker()).makeMap();

        ArbitraryOrdering() {
        }

        private Integer getUid(Object obj) {
            Integer alreadySet;
            Integer uid = (Integer)this.uids.get(obj);
            if (uid == null && (alreadySet = this.uids.putIfAbsent(obj, uid = Integer.valueOf(this.counter.getAndIncrement()))) != null) {
                uid = alreadySet;
            }
            return uid;
        }

        @Override
        public int compare(@CheckForNull Object left, @CheckForNull Object right) {
            int rightCode;
            if (left == right) {
                return 0;
            }
            if (left == null) {
                return -1;
            }
            if (right == null) {
                return 1;
            }
            int leftCode = this.identityHashCode(left);
            if (leftCode != (rightCode = this.identityHashCode(right))) {
                return leftCode < rightCode ? -1 : 1;
            }
            int result = this.getUid(left).compareTo(this.getUid(right));
            if (result == 0) {
                throw new AssertionError();
            }
            return result;
        }

        public String toString() {
            return "Ordering.arbitrary()";
        }

        int identityHashCode(Object object) {
            return System.identityHashCode(object);
        }
    }

    private static class ArbitraryOrderingHolder {
        static final Ordering<@Nullable Object> ARBITRARY_ORDERING = new ArbitraryOrdering();

        private ArbitraryOrderingHolder() {
        }
    }
}

