/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connect.common;

import java.io.Serializable;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Period;
import org.apache.spark.connect.proto.DataType;
import org.apache.spark.connect.proto.Expression;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.catalyst.util.IntervalUtils$;
import org.apache.spark.sql.connect.common.DataTypeProtoConverter$;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.CalendarIntervalType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DayTimeIntervalType$;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.YearMonthIntervalType$;
import org.apache.spark.unsafe.types.CalendarInterval;
import org.sparkproject.connect.protobuf.ByteString;
import scala.Function1;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.mutable.ArraySeq;
import scala.math.BigDecimal;
import scala.math.BigInt;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class LiteralValueProtoConverter$ {
    public static final LiteralValueProtoConverter$ MODULE$ = new LiteralValueProtoConverter$();
    private static org.apache.spark.connect.proto.DataType nullType;
    private static volatile boolean bitmap$0;

    private org.apache.spark.connect.proto.DataType nullType$lzycompute() {
        LiteralValueProtoConverter$ literalValueProtoConverter$ = this;
        synchronized (literalValueProtoConverter$) {
            if (!bitmap$0) {
                nullType = org.apache.spark.connect.proto.DataType.newBuilder().setNull(DataType.NULL.getDefaultInstance()).build();
                bitmap$0 = true;
            }
        }
        return nullType;
    }

    private org.apache.spark.connect.proto.DataType nullType() {
        return !bitmap$0 ? this.nullType$lzycompute() : nullType;
    }

    public Expression.Literal.Builder toLiteralProtoBuilder(Object literal) {
        Expression.Literal.Builder builder;
        block36: {
            Object object;
            Expression.Literal.Builder builder2;
            while (true) {
                builder2 = Expression.Literal.newBuilder();
                object = literal;
                if (object instanceof Boolean) {
                    boolean bl = BoxesRunTime.unboxToBoolean((Object)object);
                    builder = builder2.setBoolean(bl);
                    break block36;
                }
                if (object instanceof Byte) {
                    byte by = BoxesRunTime.unboxToByte((Object)object);
                    builder = builder2.setByte(by);
                    break block36;
                }
                if (object instanceof Short) {
                    short s2 = BoxesRunTime.unboxToShort((Object)object);
                    builder = builder2.setShort(s2);
                    break block36;
                }
                if (object instanceof Integer) {
                    int n = BoxesRunTime.unboxToInt((Object)object);
                    builder = builder2.setInteger(n);
                    break block36;
                }
                if (object instanceof Long) {
                    long l = BoxesRunTime.unboxToLong((Object)object);
                    builder = builder2.setLong(l);
                    break block36;
                }
                if (object instanceof Float) {
                    float f = BoxesRunTime.unboxToFloat((Object)object);
                    builder = builder2.setFloat(f);
                    break block36;
                }
                if (object instanceof Double) {
                    double d = BoxesRunTime.unboxToDouble((Object)object);
                    builder = builder2.setDouble(d);
                    break block36;
                }
                if (object instanceof BigDecimal) {
                    BigDecimal bigDecimal = (BigDecimal)object;
                    builder = builder2.setDecimal(LiteralValueProtoConverter$.decimalBuilder$1(bigDecimal.precision(), bigDecimal.scale(), bigDecimal.toString(), builder2));
                    break block36;
                }
                if (object instanceof java.math.BigDecimal) {
                    java.math.BigDecimal bigDecimal = (java.math.BigDecimal)object;
                    builder = builder2.setDecimal(LiteralValueProtoConverter$.decimalBuilder$1(bigDecimal.precision(), bigDecimal.scale(), bigDecimal.toString(), builder2));
                    break block36;
                }
                if (object instanceof String) {
                    String string = (String)object;
                    builder = builder2.setString(string);
                    break block36;
                }
                if (object instanceof Character) {
                    char c = BoxesRunTime.unboxToChar((Object)object);
                    builder = builder2.setString(Character.toString(c));
                    break block36;
                }
                if (object instanceof char[]) {
                    char[] cArray = (char[])object;
                    builder = builder2.setString(String.valueOf(cArray));
                    break block36;
                }
                if (object instanceof byte[]) {
                    byte[] byArray = (byte[])object;
                    builder = builder2.setBinary(ByteString.copyFrom(byArray));
                    break block36;
                }
                if (!(object instanceof ArraySeq)) break;
                ArraySeq arraySeq = (ArraySeq)object;
                literal = arraySeq.array();
            }
            if (object instanceof LocalDate) {
                LocalDate localDate = (LocalDate)object;
                builder = builder2.setDate((int)localDate.toEpochDay());
            } else if (object instanceof Decimal) {
                Decimal decimal = (Decimal)object;
                builder = builder2.setDecimal(LiteralValueProtoConverter$.decimalBuilder$1(Math.max(decimal.precision(), decimal.scale()), decimal.scale(), decimal.toString(), builder2));
            } else if (object instanceof Instant) {
                Instant instant = (Instant)object;
                builder = builder2.setTimestamp(DateTimeUtils$.MODULE$.instantToMicros(instant));
            } else if (object instanceof Timestamp) {
                Timestamp timestamp = (Timestamp)object;
                builder = builder2.setTimestamp(DateTimeUtils$.MODULE$.fromJavaTimestamp(timestamp));
            } else if (object instanceof LocalDateTime) {
                LocalDateTime localDateTime = (LocalDateTime)object;
                builder = builder2.setTimestampNtz(DateTimeUtils$.MODULE$.localDateTimeToMicros(localDateTime));
            } else if (object instanceof Date) {
                Date date = (Date)object;
                builder = builder2.setDate(DateTimeUtils$.MODULE$.fromJavaDate(date));
            } else if (object instanceof Duration) {
                Duration duration = (Duration)object;
                builder = builder2.setDayTimeInterval(IntervalUtils$.MODULE$.durationToMicros(duration));
            } else if (object instanceof Period) {
                Period period = (Period)object;
                builder = builder2.setYearMonthInterval(IntervalUtils$.MODULE$.periodToMonths(period));
            } else if (ScalaRunTime$.MODULE$.isArray(object, 1)) {
                Object object2 = object;
                builder = builder2.setArray(this.arrayBuilder$1(object2, builder2));
            } else if (object instanceof CalendarInterval) {
                CalendarInterval calendarInterval = (CalendarInterval)object;
                builder = builder2.setCalendarInterval(LiteralValueProtoConverter$.calendarIntervalBuilder$1(calendarInterval.months, calendarInterval.days, calendarInterval.microseconds, builder2));
            } else if (object == null) {
                builder = builder2.setNull(this.nullType());
            } else {
                throw new UnsupportedOperationException(new StringBuilder(29).append("literal ").append(literal).append(" not supported (yet).").toString());
            }
        }
        return builder;
    }

    public Expression.Literal toLiteralProto(Object literal) {
        return this.toLiteralProtoBuilder(literal).build();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private DataType toDataType(Class<?> clz) {
        Class<?> clazz = clz;
        Class<Short> clazz2 = Short.TYPE;
        Class<?> clazz3 = clazz;
        if (clazz2 == null) {
            if (clazz3 == null) return ShortType$.MODULE$;
        } else if (clazz2.equals(clazz3)) {
            return ShortType$.MODULE$;
        }
        Class<Integer> clazz4 = Integer.TYPE;
        Class<?> clazz5 = clazz;
        if (clazz4 == null) {
            if (clazz5 == null) return IntegerType$.MODULE$;
        } else if (clazz4.equals(clazz5)) {
            return IntegerType$.MODULE$;
        }
        Class<Long> clazz6 = Long.TYPE;
        Class<?> clazz7 = clazz;
        if (clazz6 == null) {
            if (clazz7 == null) return LongType$.MODULE$;
        } else if (clazz6.equals(clazz7)) {
            return LongType$.MODULE$;
        }
        Class<Double> clazz8 = Double.TYPE;
        Class<?> clazz9 = clazz;
        if (clazz8 == null) {
            if (clazz9 == null) return DoubleType$.MODULE$;
        } else if (clazz8.equals(clazz9)) {
            return DoubleType$.MODULE$;
        }
        Class<Byte> clazz10 = Byte.TYPE;
        Class<?> clazz11 = clazz;
        if (clazz10 == null) {
            if (clazz11 == null) return ByteType$.MODULE$;
        } else if (clazz10.equals(clazz11)) {
            return ByteType$.MODULE$;
        }
        Class<Float> clazz12 = Float.TYPE;
        Class<?> clazz13 = clazz;
        if (clazz12 == null) {
            if (clazz13 == null) return FloatType$.MODULE$;
        } else if (clazz12.equals(clazz13)) {
            return FloatType$.MODULE$;
        }
        Class<Boolean> clazz14 = Boolean.TYPE;
        Class<?> clazz15 = clazz;
        if (clazz14 == null) {
            if (clazz15 == null) return BooleanType$.MODULE$;
        } else if (clazz14.equals(clazz15)) {
            return BooleanType$.MODULE$;
        }
        Class<Character> clazz16 = Character.TYPE;
        Class<?> clazz17 = clazz;
        if (clazz16 == null) {
            if (clazz17 == null) return StringType$.MODULE$;
        } else if (clazz16.equals(clazz17)) {
            return StringType$.MODULE$;
        }
        Class<?> clazz18 = clz;
        Class<LocalDate> clazz19 = LocalDate.class;
        if (clazz18 == null) {
            if (clazz19 == null) return DateType$.MODULE$;
        } else if (clazz18.equals(clazz19)) return DateType$.MODULE$;
        Class<?> clazz20 = clz;
        Class<Date> clazz21 = Date.class;
        if (clazz20 == null) {
            if (clazz21 == null) return DateType$.MODULE$;
        } else if (clazz20.equals(clazz21)) {
            return DateType$.MODULE$;
        }
        Class<?> clazz22 = clz;
        Class<Instant> clazz23 = Instant.class;
        if (clazz22 == null) {
            if (clazz23 == null) return TimestampType$.MODULE$;
        } else if (clazz22.equals(clazz23)) return TimestampType$.MODULE$;
        Class<?> clazz24 = clz;
        Class<Timestamp> clazz25 = Timestamp.class;
        if (clazz24 == null) {
            if (clazz25 == null) return TimestampType$.MODULE$;
        } else if (clazz24.equals(clazz25)) {
            return TimestampType$.MODULE$;
        }
        Class<?> clazz26 = clz;
        Class<LocalDateTime> clazz27 = LocalDateTime.class;
        if (clazz26 == null) {
            if (clazz27 == null) return TimestampNTZType$.MODULE$;
        } else if (clazz26.equals(clazz27)) {
            return TimestampNTZType$.MODULE$;
        }
        Class<?> clazz28 = clz;
        Class<Duration> clazz29 = Duration.class;
        if (clazz28 == null) {
            if (clazz29 == null) return DayTimeIntervalType$.MODULE$.DEFAULT();
        } else if (clazz28.equals(clazz29)) {
            return DayTimeIntervalType$.MODULE$.DEFAULT();
        }
        Class<?> clazz30 = clz;
        Class<Period> clazz31 = Period.class;
        if (clazz30 == null) {
            if (clazz31 == null) return YearMonthIntervalType$.MODULE$.DEFAULT();
        } else if (clazz30.equals(clazz31)) {
            return YearMonthIntervalType$.MODULE$.DEFAULT();
        }
        Class<?> clazz32 = clz;
        Class<java.math.BigDecimal> clazz33 = java.math.BigDecimal.class;
        if (clazz32 == null) {
            if (clazz33 == null) return DecimalType$.MODULE$.SYSTEM_DEFAULT();
        } else if (clazz32.equals(clazz33)) {
            return DecimalType$.MODULE$.SYSTEM_DEFAULT();
        }
        Class<?> clazz34 = clz;
        Class<byte[]> clazz35 = byte[].class;
        if (clazz34 == null) {
            if (clazz35 == null) return BinaryType$.MODULE$;
        } else if (clazz34.equals(clazz35)) {
            return BinaryType$.MODULE$;
        }
        Class<?> clazz36 = clz;
        Class<char[]> clazz37 = char[].class;
        if (clazz36 == null) {
            if (clazz37 == null) return StringType$.MODULE$;
        } else if (clazz36.equals(clazz37)) {
            return StringType$.MODULE$;
        }
        Class<?> clazz38 = clz;
        Class<Short> clazz39 = Short.class;
        if (clazz38 == null) {
            if (clazz39 == null) return ShortType$.MODULE$;
        } else if (clazz38.equals(clazz39)) {
            return ShortType$.MODULE$;
        }
        Class<?> clazz40 = clz;
        Class<Integer> clazz41 = Integer.class;
        if (clazz40 == null) {
            if (clazz41 == null) return IntegerType$.MODULE$;
        } else if (clazz40.equals(clazz41)) {
            return IntegerType$.MODULE$;
        }
        Class<?> clazz42 = clz;
        Class<Long> clazz43 = Long.class;
        if (clazz42 == null) {
            if (clazz43 == null) return LongType$.MODULE$;
        } else if (clazz42.equals(clazz43)) {
            return LongType$.MODULE$;
        }
        Class<?> clazz44 = clz;
        Class<Double> clazz45 = Double.class;
        if (clazz44 == null) {
            if (clazz45 == null) return DoubleType$.MODULE$;
        } else if (clazz44.equals(clazz45)) {
            return DoubleType$.MODULE$;
        }
        Class<?> clazz46 = clz;
        Class<Byte> clazz47 = Byte.class;
        if (clazz46 == null) {
            if (clazz47 == null) return ByteType$.MODULE$;
        } else if (clazz46.equals(clazz47)) {
            return ByteType$.MODULE$;
        }
        Class<?> clazz48 = clz;
        Class<Float> clazz49 = Float.class;
        if (clazz48 == null) {
            if (clazz49 == null) return FloatType$.MODULE$;
        } else if (clazz48.equals(clazz49)) {
            return FloatType$.MODULE$;
        }
        Class<?> clazz50 = clz;
        Class<Boolean> clazz51 = Boolean.class;
        if (clazz50 == null) {
            if (clazz51 == null) return BooleanType$.MODULE$;
        } else if (clazz50.equals(clazz51)) {
            return BooleanType$.MODULE$;
        }
        Class<?> clazz52 = clz;
        Class<String> clazz53 = String.class;
        if (clazz52 == null) {
            if (clazz53 == null) return StringType$.MODULE$;
        } else if (clazz52.equals(clazz53)) {
            return StringType$.MODULE$;
        }
        Class<?> clazz54 = clz;
        Class<BigInt> clazz55 = BigInt.class;
        if (clazz54 == null) {
            if (clazz55 == null) return DecimalType$.MODULE$.SYSTEM_DEFAULT();
        } else if (clazz54.equals(clazz55)) return DecimalType$.MODULE$.SYSTEM_DEFAULT();
        Class<?> clazz56 = clz;
        Class<BigDecimal> clazz57 = BigDecimal.class;
        if (clazz56 == null) {
            if (clazz57 == null) return DecimalType$.MODULE$.SYSTEM_DEFAULT();
        } else if (clazz56.equals(clazz57)) {
            return DecimalType$.MODULE$.SYSTEM_DEFAULT();
        }
        Class<?> clazz58 = clz;
        Class<CalendarInterval> clazz59 = CalendarInterval.class;
        if (clazz58 == null) {
            if (clazz59 == null) return CalendarIntervalType$.MODULE$;
        } else if (clazz58.equals(clazz59)) {
            return CalendarIntervalType$.MODULE$;
        }
        if (!clz.isArray()) throw new UnsupportedOperationException(new StringBuilder(38).append("Unsupported component type ").append(clz).append(" in arrays.").toString());
        return ArrayType$.MODULE$.apply(this.toDataType(clz.getComponentType()));
    }

    private static final Expression.Literal.Decimal.Builder decimalBuilder$1(int precision, int scale, String value, Expression.Literal.Builder builder$1) {
        return builder$1.getDecimalBuilder().setPrecision(precision).setScale(scale).setValue(value);
    }

    private static final Expression.Literal.CalendarInterval.Builder calendarIntervalBuilder$1(int months, int days, long microseconds, Expression.Literal.Builder builder$1) {
        return builder$1.getCalendarIntervalBuilder().setMonths(months).setDays(days).setMicroseconds(microseconds);
    }

    /*
     * WARNING - void declaration
     */
    private final Expression.Literal.Array.Builder arrayBuilder$1(Object array, Expression.Literal.Builder builder$1) {
        void var3_3;
        Expression.Literal.Array.Builder ab = builder$1.getArrayBuilder().setElementType(DataTypeProtoConverter$.MODULE$.toConnectProtoType(this.toDataType(array.getClass().getComponentType())));
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.genericArrayOps(array), (Function1 & Serializable)x -> ab.addElements(MODULE$.toLiteralProto(x)));
        return var3_3;
    }

    private LiteralValueProtoConverter$() {
    }
}

