/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connect.planner;

import java.io.Serializable;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.Period;
import java.util.Iterator;
import java.util.List;
import org.apache.spark.connect.proto.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.catalyst.util.IntervalUtils$;
import org.apache.spark.sql.connect.common.DataTypeProtoConverter$;
import org.apache.spark.sql.connect.common.InvalidPlanInput;
import org.apache.spark.sql.connect.common.InvalidPlanInput$;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.CalendarIntervalType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DayTimeIntervalType$;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.YearMonthIntervalType$;
import org.apache.spark.unsafe.types.CalendarInterval;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArrayBuilder$;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class LiteralExpressionProtoConverter$ {
    public static final LiteralExpressionProtoConverter$ MODULE$ = new LiteralExpressionProtoConverter$();

    public Literal toCatalystExpression(Expression.Literal lit) {
        Literal literal;
        Expression.Literal.LiteralTypeCase literalTypeCase = lit.getLiteralTypeCase();
        if (Expression.Literal.LiteralTypeCase.NULL.equals(literalTypeCase)) {
            literal = new Literal(null, DataTypeProtoConverter$.MODULE$.toCatalystType(lit.getNull()));
        } else if (Expression.Literal.LiteralTypeCase.BINARY.equals(literalTypeCase)) {
            literal = new Literal((Object)lit.getBinary().toByteArray(), (DataType)BinaryType$.MODULE$);
        } else if (Expression.Literal.LiteralTypeCase.BOOLEAN.equals(literalTypeCase)) {
            literal = new Literal((Object)BoxesRunTime.boxToBoolean((boolean)lit.getBoolean()), (DataType)BooleanType$.MODULE$);
        } else if (Expression.Literal.LiteralTypeCase.BYTE.equals(literalTypeCase)) {
            literal = new Literal((Object)BoxesRunTime.boxToByte((byte)((byte)lit.getByte())), (DataType)ByteType$.MODULE$);
        } else if (Expression.Literal.LiteralTypeCase.SHORT.equals(literalTypeCase)) {
            literal = new Literal((Object)BoxesRunTime.boxToShort((short)((short)lit.getShort())), (DataType)ShortType$.MODULE$);
        } else if (Expression.Literal.LiteralTypeCase.INTEGER.equals(literalTypeCase)) {
            literal = new Literal((Object)BoxesRunTime.boxToInteger((int)lit.getInteger()), (DataType)IntegerType$.MODULE$);
        } else if (Expression.Literal.LiteralTypeCase.LONG.equals(literalTypeCase)) {
            literal = new Literal((Object)BoxesRunTime.boxToLong((long)lit.getLong()), (DataType)LongType$.MODULE$);
        } else if (Expression.Literal.LiteralTypeCase.FLOAT.equals(literalTypeCase)) {
            literal = new Literal((Object)BoxesRunTime.boxToFloat((float)lit.getFloat()), (DataType)FloatType$.MODULE$);
        } else if (Expression.Literal.LiteralTypeCase.DOUBLE.equals(literalTypeCase)) {
            literal = new Literal((Object)BoxesRunTime.boxToDouble((double)lit.getDouble()), (DataType)DoubleType$.MODULE$);
        } else if (Expression.Literal.LiteralTypeCase.DECIMAL.equals(literalTypeCase)) {
            Decimal decimal = Decimal$.MODULE$.apply(lit.getDecimal().getValue());
            int precision = decimal.precision();
            if (lit.getDecimal().hasPrecision()) {
                precision = package$.MODULE$.max(precision, lit.getDecimal().getPrecision());
            }
            int scale = decimal.scale();
            if (lit.getDecimal().hasScale()) {
                scale = package$.MODULE$.max(scale, lit.getDecimal().getScale());
            }
            literal = new Literal((Object)decimal, (DataType)new DecimalType(package$.MODULE$.max(precision, scale), scale));
        } else if (Expression.Literal.LiteralTypeCase.STRING.equals(literalTypeCase)) {
            literal = new Literal((Object)UTF8String.fromString((String)lit.getString()), (DataType)StringType$.MODULE$);
        } else if (Expression.Literal.LiteralTypeCase.DATE.equals(literalTypeCase)) {
            literal = new Literal((Object)BoxesRunTime.boxToInteger((int)lit.getDate()), (DataType)DateType$.MODULE$);
        } else if (Expression.Literal.LiteralTypeCase.TIMESTAMP.equals(literalTypeCase)) {
            literal = new Literal((Object)BoxesRunTime.boxToLong((long)lit.getTimestamp()), (DataType)TimestampType$.MODULE$);
        } else if (Expression.Literal.LiteralTypeCase.TIMESTAMP_NTZ.equals(literalTypeCase)) {
            literal = new Literal((Object)BoxesRunTime.boxToLong((long)lit.getTimestampNtz()), (DataType)TimestampNTZType$.MODULE$);
        } else if (Expression.Literal.LiteralTypeCase.CALENDAR_INTERVAL.equals(literalTypeCase)) {
            CalendarInterval interval = new CalendarInterval(lit.getCalendarInterval().getMonths(), lit.getCalendarInterval().getDays(), lit.getCalendarInterval().getMicroseconds());
            literal = new Literal((Object)interval, (DataType)CalendarIntervalType$.MODULE$);
        } else if (Expression.Literal.LiteralTypeCase.YEAR_MONTH_INTERVAL.equals(literalTypeCase)) {
            literal = new Literal((Object)BoxesRunTime.boxToInteger((int)lit.getYearMonthInterval()), (DataType)YearMonthIntervalType$.MODULE$.apply());
        } else if (Expression.Literal.LiteralTypeCase.DAY_TIME_INTERVAL.equals(literalTypeCase)) {
            literal = new Literal((Object)BoxesRunTime.boxToLong((long)lit.getDayTimeInterval()), (DataType)DayTimeIntervalType$.MODULE$.apply());
        } else if (Expression.Literal.LiteralTypeCase.ARRAY.equals(literalTypeCase)) {
            literal = Literal$.MODULE$.create(this.toArrayData(lit.getArray()), (DataType)ArrayType$.MODULE$.apply(DataTypeProtoConverter$.MODULE$.toCatalystType(lit.getArray().getElementType())));
        } else {
            throw new InvalidPlanInput(new StringBuilder(0).append(new StringBuilder(26).append("Unsupported Literal Type: ").append(lit.getLiteralTypeCase().getNumber()).toString()).append(new StringBuilder(2).append("(").append(lit.getLiteralTypeCase().name()).append(")").toString()).toString(), InvalidPlanInput$.MODULE$.apply$default$2());
        }
        return literal;
    }

    public Object toCatalystValue(Expression.Literal lit) {
        Expression.Literal.LiteralTypeCase literalTypeCase = lit.getLiteralTypeCase();
        Object object = Expression.Literal.LiteralTypeCase.STRING.equals(literalTypeCase) ? lit.getString() : this.toCatalystExpression(lit).value();
        return object;
    }

    private Object toArrayData(Expression.Literal.Array array) {
        Object object;
        org.apache.spark.connect.proto.DataType elementType = array.getElementType();
        if (elementType.hasShort()) {
            object = LiteralExpressionProtoConverter$.makeArrayData$1((Function1 & Serializable)v -> BoxesRunTime.boxToShort((short)LiteralExpressionProtoConverter$.$anonfun$toArrayData$1(v)), (ClassTag)ClassTag$.MODULE$.Short(), array);
        } else if (elementType.hasInteger()) {
            object = LiteralExpressionProtoConverter$.makeArrayData$1((Function1 & Serializable)v -> BoxesRunTime.boxToInteger((int)v.getInteger()), (ClassTag)ClassTag$.MODULE$.Int(), array);
        } else if (elementType.hasLong()) {
            object = LiteralExpressionProtoConverter$.makeArrayData$1((Function1 & Serializable)v -> BoxesRunTime.boxToLong((long)v.getLong()), (ClassTag)ClassTag$.MODULE$.Long(), array);
        } else if (elementType.hasDouble()) {
            object = LiteralExpressionProtoConverter$.makeArrayData$1((Function1 & Serializable)v -> BoxesRunTime.boxToDouble((double)v.getDouble()), (ClassTag)ClassTag$.MODULE$.Double(), array);
        } else if (elementType.hasByte()) {
            object = LiteralExpressionProtoConverter$.makeArrayData$1((Function1 & Serializable)v -> BoxesRunTime.boxToByte((byte)LiteralExpressionProtoConverter$.$anonfun$toArrayData$5(v)), (ClassTag)ClassTag$.MODULE$.Byte(), array);
        } else if (elementType.hasFloat()) {
            object = LiteralExpressionProtoConverter$.makeArrayData$1((Function1 & Serializable)v -> BoxesRunTime.boxToFloat((float)v.getFloat()), (ClassTag)ClassTag$.MODULE$.Float(), array);
        } else if (elementType.hasBoolean()) {
            object = LiteralExpressionProtoConverter$.makeArrayData$1((Function1 & Serializable)v -> BoxesRunTime.boxToBoolean((boolean)v.getBoolean()), (ClassTag)ClassTag$.MODULE$.Boolean(), array);
        } else if (elementType.hasString()) {
            object = LiteralExpressionProtoConverter$.makeArrayData$1((Function1 & Serializable)v -> v.getString(), ClassTag$.MODULE$.apply(String.class), array);
        } else if (elementType.hasBinary()) {
            object = LiteralExpressionProtoConverter$.makeArrayData$1((Function1 & Serializable)v -> v.getBinary().toByteArray(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)), array);
        } else if (elementType.hasDate()) {
            object = LiteralExpressionProtoConverter$.makeArrayData$1((Function1 & Serializable)v -> DateTimeUtils$.MODULE$.toJavaDate(v.getDate()), ClassTag$.MODULE$.apply(Date.class), array);
        } else if (elementType.hasTimestamp()) {
            object = LiteralExpressionProtoConverter$.makeArrayData$1((Function1 & Serializable)v -> DateTimeUtils$.MODULE$.toJavaTimestamp(v.getTimestamp()), ClassTag$.MODULE$.apply(Timestamp.class), array);
        } else if (elementType.hasTimestampNtz()) {
            object = LiteralExpressionProtoConverter$.makeArrayData$1((Function1 & Serializable)v -> DateTimeUtils$.MODULE$.microsToLocalDateTime(v.getTimestampNtz()), ClassTag$.MODULE$.apply(LocalDateTime.class), array);
        } else if (elementType.hasDayTimeInterval()) {
            object = LiteralExpressionProtoConverter$.makeArrayData$1((Function1 & Serializable)v -> IntervalUtils$.MODULE$.microsToDuration(v.getDayTimeInterval()), ClassTag$.MODULE$.apply(Duration.class), array);
        } else if (elementType.hasYearMonthInterval()) {
            object = LiteralExpressionProtoConverter$.makeArrayData$1((Function1 & Serializable)v -> IntervalUtils$.MODULE$.monthsToPeriod(v.getYearMonthInterval()), ClassTag$.MODULE$.apply(Period.class), array);
        } else if (elementType.hasDecimal()) {
            object = LiteralExpressionProtoConverter$.makeArrayData$1((Function1 & Serializable)v -> Decimal$.MODULE$.apply(v.getDecimal().getValue()), ClassTag$.MODULE$.apply(Decimal.class), array);
        } else if (elementType.hasCalendarInterval()) {
            object = LiteralExpressionProtoConverter$.makeArrayData$1((Function1 & Serializable)v -> {
                Expression.Literal.CalendarInterval interval = v.getCalendarInterval();
                return new CalendarInterval(interval.getMonths(), interval.getDays(), interval.getMicroseconds());
            }, ClassTag$.MODULE$.apply(CalendarInterval.class), array);
        } else if (elementType.hasArray()) {
            object = LiteralExpressionProtoConverter$.makeArrayData$1((Function1 & Serializable)v -> MODULE$.toArrayData(v.getArray()), ClassTag$.MODULE$.Any(), array);
        } else {
            throw new InvalidPlanInput(new StringBuilder(27).append("Unsupported Literal Type: ").append(elementType).append(")").toString(), InvalidPlanInput$.MODULE$.apply$default$2());
        }
        return object;
    }

    private static final Object makeArrayData$1(Function1 converter, ClassTag tag, Expression.Literal.Array array$1) {
        ArrayBuilder builder = ArrayBuilder$.MODULE$.make(tag);
        List<Expression.Literal> elementList = array$1.getElementsList();
        builder.sizeHint(elementList.size());
        Iterator<Expression.Literal> iter = elementList.iterator();
        while (iter.hasNext()) {
            builder.$plus$eq(converter.apply((Object)iter.next()));
        }
        return builder.result();
    }

    public static final /* synthetic */ short $anonfun$toArrayData$1(Expression.Literal v) {
        return (short)v.getShort();
    }

    public static final /* synthetic */ byte $anonfun$toArrayData$5(Expression.Literal v) {
        return (byte)v.getByte();
    }

    private LiteralExpressionProtoConverter$() {
    }
}

