/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.connect.guava.io;

import java.io.IOException;
import java.io.Reader;
import java.nio.CharBuffer;
import java.util.ArrayDeque;
import java.util.Queue;
import javax.annotation.CheckForNull;
import org.sparkproject.connect.errorprone_annotations.CanIgnoreReturnValue;
import org.sparkproject.connect.guava.annotations.Beta;
import org.sparkproject.connect.guava.annotations.GwtIncompatible;
import org.sparkproject.connect.guava.base.Preconditions;
import org.sparkproject.connect.guava.io.CharStreams;
import org.sparkproject.connect.guava.io.ElementTypesAreNonnullByDefault;
import org.sparkproject.connect.guava.io.Java8Compatibility;
import org.sparkproject.connect.guava.io.LineBuffer;

@ElementTypesAreNonnullByDefault
@Beta
@GwtIncompatible
public final class LineReader {
    private final Readable readable;
    @CheckForNull
    private final Reader reader;
    private final CharBuffer cbuf = CharStreams.createBuffer();
    private final char[] buf = this.cbuf.array();
    private final Queue<String> lines = new ArrayDeque<String>();
    private final LineBuffer lineBuf = new LineBuffer(){

        @Override
        protected void handleLine(String line, String end) {
            LineReader.this.lines.add(line);
        }
    };

    public LineReader(Readable readable) {
        this.readable = Preconditions.checkNotNull(readable);
        this.reader = readable instanceof Reader ? (Reader)readable : null;
    }

    @CheckForNull
    @CanIgnoreReturnValue
    public String readLine() throws IOException {
        while (this.lines.peek() == null) {
            int read;
            Java8Compatibility.clear(this.cbuf);
            int n = read = this.reader != null ? this.reader.read(this.buf, 0, this.buf.length) : this.readable.read(this.cbuf);
            if (read == -1) {
                this.lineBuf.finish();
                break;
            }
            this.lineBuf.add(this.buf, 0, read);
        }
        return this.lines.poll();
    }
}

