/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connect.service;

import java.io.Serializable;
import java.util.List;
import java.util.UUID;
import org.apache.spark.SparkEnv$;
import org.apache.spark.SparkSQLException;
import org.apache.spark.connect.proto.ExecutePlanRequest;
import org.apache.spark.connect.proto.ExecutePlanResponse;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.connect.common.ProtoUtils$;
import org.apache.spark.sql.connect.config.Connect$;
import org.apache.spark.sql.connect.execution.ExecuteGrpcResponseSender;
import org.apache.spark.sql.connect.execution.ExecuteResponseObserver;
import org.apache.spark.sql.connect.execution.ExecuteThreadRunner;
import org.apache.spark.sql.connect.service.ExecuteEventsManager;
import org.apache.spark.sql.connect.service.ExecuteInfo;
import org.apache.spark.sql.connect.service.ExecuteJobTag$;
import org.apache.spark.sql.connect.service.ExecuteKey;
import org.apache.spark.sql.connect.service.SessionHolder;
import org.apache.spark.util.Clock;
import org.apache.spark.util.SystemClock;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.JavaConverters$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\tUa!B\u00181\u0001Ib\u0004\u0002C%\u0001\u0005\u000b\u0007I\u0011A&\t\u0011M\u0003!\u0011!Q\u0001\n1C\u0001\u0002\u0016\u0001\u0003\u0006\u0004%\t!\u0016\u0005\t5\u0002\u0011\t\u0011)A\u0005-\")1\f\u0001C\u00019\"9\u0001\r\u0001b\u0001\n\u0003\t\u0007B\u00024\u0001A\u0003%!\rC\u0004h\u0001\t\u0007I\u0011\u00015\t\rE\u0004\u0001\u0015!\u0003j\u0011\u001d\u0011\bA1A\u0005\u0002MDaA \u0001!\u0002\u0013!\b\u0002C@\u0001\u0005\u0004%\t!!\u0001\t\u0011\u0005%\u0001\u0001)A\u0005\u0003\u0007A\u0011\"a\u0003\u0001\u0005\u0004%\t!!\u0004\t\u0011\u0005U\u0001\u0001)A\u0005\u0003\u001fA\u0011\"a\u0006\u0001\u0005\u0004%\t!!\u0007\t\u0011\u00055\u0002\u0001)A\u0005\u00037A\u0011\"a\f\u0001\u0005\u0004%\t!!\r\t\u0011\u0005e\u0002\u0001)A\u0005\u0003gA\u0011\"a\u000f\u0001\u0005\u0004%I!!\u0010\t\u0011\u0005\u0015\u0003\u0001)A\u0005\u0003\u007fA\u0011\"a\u0012\u0001\u0005\u0004%\t!!\u0013\t\u0011\u0005E\u0003\u0001)A\u0005\u0003\u0017B\u0011\"a\u0015\u0001\u0001\u0004%\t!!\u0016\t\u0013\u0005u\u0003\u00011A\u0005\u0002\u0005}\u0003\u0002CA6\u0001\u0001\u0006K!a\u0016\t\u0013\u0005U\u0004\u00011A\u0005\n\u0005U\u0003\"CA<\u0001\u0001\u0007I\u0011BA=\u0011!\ti\b\u0001Q!\n\u0005]\u0003\"CA@\u0001\t\u0007I\u0011BAA\u0011!\tI\n\u0001Q\u0001\n\u0005\r\u0005bBAN\u0001\u0011\u0005\u0011Q\u0014\u0005\b\u0003?\u0003A\u0011AAO\u0011\u001d\t\t\u000b\u0001C\u0001\u0003GCq!!)\u0001\t\u0003\tI\u000bC\u0004\u00022\u0002!I!a-\t\u000f\u0005e\u0006\u0001\"\u0001\u0002<\"A\u0011q\u001c\u0001\u0005\u0002I\n\t\u000f\u0003\u0005\u0002h\u0002!\tAMAO\u0011\u001d\tI\u000f\u0001C\u0001\u0003;Cq!a;\u0001\t\u0003\ti\u000fC\u0004\u0002t\u0002!\t!!>\t\u000f\u0005]\b\u0001\"\u0001\u0002\u001e\"9\u0011\u0011 \u0001\u0005\u0002\u0005m\bb\u0002B\u0001\u0001\u0011\u0005!1\u0001\u0005\b\u0005\u0017\u0001A\u0011\u0001B\u0007\u00055)\u00050Z2vi\u0016Du\u000e\u001c3fe*\u0011\u0011GM\u0001\bg\u0016\u0014h/[2f\u0015\t\u0019D'A\u0004d_:tWm\u0019;\u000b\u0005U2\u0014aA:rY*\u0011q\u0007O\u0001\u0006gB\f'o\u001b\u0006\u0003si\na!\u00199bG\",'\"A\u001e\u0002\u0007=\u0014xmE\u0002\u0001{\r\u0003\"AP!\u000e\u0003}R\u0011\u0001Q\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0005~\u0012a!\u00118z%\u00164\u0007C\u0001#H\u001b\u0005)%B\u0001$7\u0003!Ig\u000e^3s]\u0006d\u0017B\u0001%F\u0005\u001daunZ4j]\u001e\fqA]3rk\u0016\u001cHo\u0001\u0001\u0016\u00031\u0003\"!T)\u000e\u00039S!a\u0014)\u0002\u000bA\u0014x\u000e^8\u000b\u0005M2\u0014B\u0001*O\u0005I)\u00050Z2vi\u0016\u0004F.\u00198SKF,Xm\u001d;\u0002\u0011I,\u0017/^3ti\u0002\nQb]3tg&|g\u000eS8mI\u0016\u0014X#\u0001,\u0011\u0005]CV\"\u0001\u0019\n\u0005e\u0003$!D*fgNLwN\u001c%pY\u0012,'/\u0001\btKN\u001c\u0018n\u001c8I_2$WM\u001d\u0011\u0002\rqJg.\u001b;?)\rifl\u0018\t\u0003/\u0002AQ!S\u0003A\u00021CQ\u0001V\u0003A\u0002Y\u000bqa]3tg&|g.F\u0001c!\t\u0019G-D\u00015\u0013\t)GG\u0001\u0007Ta\u0006\u00148nU3tg&|g.\u0001\u0005tKN\u001c\u0018n\u001c8!\u0003-y\u0007/\u001a:bi&|g.\u00133\u0016\u0003%\u0004\"A[8\u000e\u0003-T!\u0001\\7\u0002\t1\fgn\u001a\u0006\u0002]\u0006!!.\u0019<b\u0013\t\u00018N\u0001\u0004TiJLgnZ\u0001\r_B,'/\u0019;j_:LE\rI\u0001\u0007U>\u0014G+Y4\u0016\u0003Q\u0004\"!\u001e?\u000f\u0005YT\bCA<@\u001b\u0005A(BA=K\u0003\u0019a$o\\8u}%\u00111pP\u0001\u0007!J,G-\u001a4\n\u0005Al(BA>@\u0003\u001dQwN\u0019+bO\u0002\n\u0001c\u001d9be.\u001cVm]:j_:$\u0016mZ:\u0016\u0005\u0005\r\u0001\u0003B;\u0002\u0006QL1!a\u0002~\u0005\r\u0019V\r^\u0001\u0012gB\f'o[*fgNLwN\u001c+bON\u0004\u0013\u0001\u0004:fCR$\u0018m\u00195bE2,WCAA\b!\rq\u0014\u0011C\u0005\u0004\u0003'y$a\u0002\"p_2,\u0017M\\\u0001\u000ee\u0016\fG\u000f^1dQ\u0006\u0014G.\u001a\u0011\u0002!I,7\u000f]8og\u0016|%m]3sm\u0016\u0014XCAA\u000e!\u0019\ti\"a\t\u0002(5\u0011\u0011q\u0004\u0006\u0004\u0003C\u0011\u0014!C3yK\u000e,H/[8o\u0013\u0011\t)#a\b\u0003/\u0015CXmY;uKJ+7\u000f]8og\u0016|%m]3sm\u0016\u0014\bcA'\u0002*%\u0019\u00111\u0006(\u0003'\u0015CXmY;uKBc\u0017M\u001c*fgB|gn]3\u0002#I,7\u000f]8og\u0016|%m]3sm\u0016\u0014\b%A\u0007fm\u0016tGo]'b]\u0006<WM]\u000b\u0003\u0003g\u00012aVA\u001b\u0013\r\t9\u0004\r\u0002\u0015\u000bb,7-\u001e;f\u000bZ,g\u000e^:NC:\fw-\u001a:\u0002\u001d\u00154XM\u001c;t\u001b\u0006t\u0017mZ3sA\u00051!/\u001e8oKJ,\"!a\u0010\u0011\t\u0005u\u0011\u0011I\u0005\u0005\u0003\u0007\nyBA\nFq\u0016\u001cW\u000f^3UQJ,\u0017\r\u001a*v]:,'/A\u0004sk:tWM\u001d\u0011\u0002\u0019\r\u0014X-\u0019;j_:$\u0016.\\3\u0016\u0005\u0005-\u0003c\u0001 \u0002N%\u0019\u0011qJ \u0003\t1{gnZ\u0001\u000eGJ,\u0017\r^5p]RKW.\u001a\u0011\u0002'1\f7\u000f^!ui\u0006\u001c\u0007.\u001a3Sa\u000e$\u0016.\\3\u0016\u0005\u0005]\u0003#\u0002 \u0002Z\u0005-\u0013bAA.\u007f\t1q\n\u001d;j_:\fq\u0003\\1ti\u0006#H/Y2iK\u0012\u0014\u0006o\u0019+j[\u0016|F%Z9\u0015\t\u0005\u0005\u0014q\r\t\u0004}\u0005\r\u0014bAA3\u007f\t!QK\\5u\u0011%\tI'GA\u0001\u0002\u0004\t9&A\u0002yIE\nA\u0003\\1ti\u0006#H/Y2iK\u0012\u0014\u0006o\u0019+j[\u0016\u0004\u0003f\u0001\u000e\u0002pA\u0019a(!\u001d\n\u0007\u0005MtH\u0001\u0005w_2\fG/\u001b7f\u0003)\u0019Gn\\:fIRKW.Z\u0001\u000fG2|7/\u001a3US6,w\fJ3r)\u0011\t\t'a\u001f\t\u0013\u0005%D$!AA\u0002\u0005]\u0013aC2m_N,G\rV5nK\u0002\n1c\u001a:qGJ+7\u000f]8og\u0016\u001cVM\u001c3feN,\"!a!\u0011\r\u0005\u0015\u0015qRAJ\u001b\t\t9I\u0003\u0003\u0002\n\u0006-\u0015aB7vi\u0006\u0014G.\u001a\u0006\u0004\u0003\u001b{\u0014AC2pY2,7\r^5p]&!\u0011\u0011SAD\u0005-\t%O]1z\u0005V4g-\u001a:\u0011\r\u0005u\u0011QSA\u0014\u0013\u0011\t9*a\b\u00033\u0015CXmY;uK\u001e\u0013\bo\u0019*fgB|gn]3TK:$WM]\u0001\u0015OJ\u00048MU3ta>t7/Z*f]\u0012,'o\u001d\u0011\u0002\u000bM$\u0018M\u001d;\u0015\u0005\u0005\u0005\u0014\u0001\u00026pS:\fQC];o\u000fJ\u00048MU3ta>t7/Z*f]\u0012,'\u000f\u0006\u0003\u0002b\u0005\u0015\u0006bBATE\u0001\u0007\u00111S\u0001\u000fe\u0016\u001c\bo\u001c8tKN+g\u000eZ3s)\u0019\t\t'a+\u0002.\"9\u0011qU\u0012A\u0002\u0005M\u0005BBAXG\u0001\u0007A/\u0001\fmCN$8i\u001c8tk6,GMU3ta>t7/Z%e\u0003U\tG\rZ$sa\u000e\u0014Vm\u001d9p]N,7+\u001a8eKJ$B!!\u0019\u00026\"9\u0011q\u0017\u0013A\u0002\u0005M\u0015AB:f]\u0012,'/\u0001\rsK6|g/Z$sa\u000e\u0014Vm\u001d9p]N,7+\u001a8eKJ,B!!0\u0002\\R!\u0011\u0011MA`\u0011\u001d\t9,\na\u0001\u0003\u0003\u0004D!a1\u0002JB1\u0011QDAK\u0003\u000b\u0004B!a2\u0002J2\u0001A\u0001DAf\u0003\u007f\u000b\t\u0011!A\u0003\u0002\u00055'aA0%cE!\u0011qZAk!\rq\u0014\u0011[\u0005\u0004\u0003'|$a\u0002(pi\"Lgn\u001a\t\u0004}\u0005]\u0017bAAm\u007f\t\u0019\u0011I\\=\u0005\u000f\u0005uWE1\u0001\u0002N\n!q\f\n\u00132\u0003y\u0019X\r^$sa\u000e\u0014Vm\u001d9p]N,7+\u001a8eKJ\u001cH)Z1eY&tW\r\u0006\u0003\u0002b\u0005\r\bbBAsM\u0001\u0007\u00111J\u0001\u000bI\u0016\fG\r\\5oK6\u001b\u0018\u0001H5oi\u0016\u0014(/\u001e9u\u000fJ\u00048MU3ta>t7/Z*f]\u0012,'o]\u0001\u0010C\u001a$XM]%oSRL\u0017\r\u001c*Q\u0007\u00061\"/\u001a7fCN,WK\u001c;jYJ+7\u000f]8og\u0016LE\r\u0006\u0003\u0002b\u0005=\bBBAyS\u0001\u0007A/\u0001\u0006sKN\u0004xN\\:f\u0013\u0012\f\u0011\"\u001b8uKJ\u0014X\u000f\u001d;\u0015\u0005\u0005=\u0011!B2m_N,\u0017\u0001\u0005;bOR{7\u000b]1sW*{'\rV1h)\r!\u0018Q \u0005\u0007\u0003\u007fd\u0003\u0019\u0001;\u0002\u0007Q\fw-\u0001\bhKR,\u00050Z2vi\u0016LeNZ8\u0016\u0005\t\u0015\u0001cA,\u0003\b%\u0019!\u0011\u0002\u0019\u0003\u0017\u0015CXmY;uK&sgm\\\u0001\u0004W\u0016LXC\u0001B\b!\r9&\u0011C\u0005\u0004\u0005'\u0001$AC#yK\u000e,H/Z&fs\u0002")
public class ExecuteHolder
implements Logging {
    private final ExecutePlanRequest request;
    private final SessionHolder sessionHolder;
    private final SparkSession session;
    private final String operationId;
    private final String jobTag;
    private final Set<String> sparkSessionTags;
    private final boolean reattachable;
    private final ExecuteResponseObserver<ExecutePlanResponse> responseObserver;
    private final ExecuteEventsManager eventsManager;
    private final ExecuteThreadRunner runner;
    private final long creationTime;
    private volatile Option<Object> lastAttachedRpcTime;
    private Option<Object> closedTime;
    private final ArrayBuffer<ExecuteGrpcResponseSender<ExecutePlanResponse>> grpcResponseSenders;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public ExecutePlanRequest request() {
        return this.request;
    }

    public SessionHolder sessionHolder() {
        return this.sessionHolder;
    }

    public SparkSession session() {
        return this.session;
    }

    public String operationId() {
        return this.operationId;
    }

    public String jobTag() {
        return this.jobTag;
    }

    public Set<String> sparkSessionTags() {
        return this.sparkSessionTags;
    }

    public boolean reattachable() {
        return this.reattachable;
    }

    public ExecuteResponseObserver<ExecutePlanResponse> responseObserver() {
        return this.responseObserver;
    }

    public ExecuteEventsManager eventsManager() {
        return this.eventsManager;
    }

    private ExecuteThreadRunner runner() {
        return this.runner;
    }

    public long creationTime() {
        return this.creationTime;
    }

    public Option<Object> lastAttachedRpcTime() {
        return this.lastAttachedRpcTime;
    }

    public void lastAttachedRpcTime_$eq(Option<Object> x$1) {
        this.lastAttachedRpcTime = x$1;
    }

    private Option<Object> closedTime() {
        return this.closedTime;
    }

    private void closedTime_$eq(Option<Object> x$1) {
        this.closedTime = x$1;
    }

    private ArrayBuffer<ExecuteGrpcResponseSender<ExecutePlanResponse>> grpcResponseSenders() {
        return this.grpcResponseSenders;
    }

    public void start() {
        this.runner().start();
    }

    public void join() {
        this.runner().join();
    }

    public void runGrpcResponseSender(ExecuteGrpcResponseSender<ExecutePlanResponse> responseSender) {
        this.addGrpcResponseSender(responseSender);
        responseSender.run(0L);
    }

    public void runGrpcResponseSender(ExecuteGrpcResponseSender<ExecutePlanResponse> responseSender, String lastConsumedResponseId) {
        long lastConsumedIndex = this.responseObserver().getResponseIndexById(lastConsumedResponseId);
        this.addGrpcResponseSender(responseSender);
        responseSender.run(lastConsumedIndex);
    }

    private synchronized void addGrpcResponseSender(ExecuteGrpcResponseSender<ExecutePlanResponse> sender) {
        if (this.closedTime().isEmpty()) {
            this.grpcResponseSenders().$plus$eq(sender);
            this.lastAttachedRpcTime_$eq((Option<Object>)None$.MODULE$);
        } else {
            sender.interrupt();
        }
    }

    public synchronized <_$$1> void removeGrpcResponseSender(ExecuteGrpcResponseSender<?> sender) {
        block1: {
            if (!this.closedTime().isEmpty()) break block1;
            this.grpcResponseSenders().$minus$eq(sender);
            if (this.grpcResponseSenders().isEmpty()) {
                this.lastAttachedRpcTime_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)System.currentTimeMillis())));
            }
        }
    }

    public synchronized void setGrpcResponseSendersDeadline(long deadlineMs) {
        this.grpcResponseSenders().foreach((Function1 & Serializable)x$1 -> {
            x$1.setDeadline(deadlineMs);
            return BoxedUnit.UNIT;
        });
    }

    public synchronized void interruptGrpcResponseSenders() {
        this.grpcResponseSenders().foreach((Function1 & Serializable)x$2 -> {
            x$2.interrupt();
            return BoxedUnit.UNIT;
        });
    }

    public synchronized void afterInitialRPC() {
        block0: {
            if (!this.closedTime().isEmpty() || !this.grpcResponseSenders().isEmpty()) break block0;
            this.lastAttachedRpcTime_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)System.currentTimeMillis())));
        }
    }

    public void releaseUntilResponseId(String responseId) {
        this.responseObserver().removeResponsesUntilId(responseId);
    }

    public boolean interrupt() {
        return this.runner().interrupt();
    }

    public synchronized void close() {
        block1: {
            if (!this.closedTime().isEmpty()) break block1;
            this.runner().interrupt();
            this.runner().join();
            this.grpcResponseSenders().foreach((Function1 & Serializable)x$3 -> {
                x$3.interrupt();
                return BoxedUnit.UNIT;
            });
            if (this.grpcResponseSenders().nonEmpty()) {
                this.lastAttachedRpcTime_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)System.currentTimeMillis())));
                this.grpcResponseSenders().clear();
            }
            this.responseObserver().removeAll();
            this.eventsManager().postClosed();
            this.closedTime_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)System.currentTimeMillis())));
        }
    }

    public String tagToSparkJobTag(String tag) {
        return new StringBuilder(21).append("SparkConnect_Execute_").append(new StringBuilder(19).append("User_").append(this.sessionHolder().userId()).append("_Session_").append(this.sessionHolder().sessionId()).append("_Tag_").append(tag).toString()).toString();
    }

    public synchronized ExecuteInfo getExecuteInfo() {
        return new ExecuteInfo(this.request(), this.sessionHolder().userId(), this.sessionHolder().sessionId(), this.operationId(), this.jobTag(), this.sparkSessionTags(), this.reattachable(), this.eventsManager().status(), this.creationTime(), this.lastAttachedRpcTime(), this.closedTime());
    }

    public ExecuteKey key() {
        return new ExecuteKey(this.sessionHolder().userId(), this.sessionHolder().sessionId(), this.operationId());
    }

    private final /* synthetic */ String liftedTree1$1() {
        String string;
        try {
            string = UUID.fromString(this.request().getOperationId()).toString();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new SparkSQLException("INVALID_HANDLE.FORMAT", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"handle"), (Object)this.request().getOperationId())})));
        }
        return string;
    }

    public static final /* synthetic */ boolean $anonfun$reattachable$1(ExecutePlanRequest.RequestOption option) {
        return option.hasReattachOptions() && option.getReattachOptions().getReattachable();
    }

    public ExecuteHolder(ExecutePlanRequest request, SessionHolder sessionHolder) {
        this.request = request;
        this.sessionHolder = sessionHolder;
        Logging.$init$((Logging)this);
        this.session = sessionHolder.session();
        this.operationId = request.hasOperationId() ? this.liftedTree1$1() : UUID.randomUUID().toString();
        this.jobTag = ExecuteJobTag$.MODULE$.apply(sessionHolder.userId(), sessionHolder.sessionId(), this.operationId());
        this.sparkSessionTags = ((IterableOnceOps)((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter((List)request.getTagsList()).asScala()).toSeq().map((Function1 & Serializable)tag -> {
            ProtoUtils$.MODULE$.throwIfInvalidTag((String)tag);
            return tag;
        })).toSet();
        this.reattachable = BoxesRunTime.unboxToBoolean((Object)SparkEnv$.MODULE$.get().conf().get(Connect$.MODULE$.CONNECT_EXECUTE_REATTACHABLE_ENABLED())) && ((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(request.getRequestOptionsList()).asScala()).exists((Function1 & Serializable)option -> BoxesRunTime.boxToBoolean((boolean)ExecuteHolder.$anonfun$reattachable$1(option)));
        this.responseObserver = new ExecuteResponseObserver(this);
        this.eventsManager = new ExecuteEventsManager(this, (Clock)new SystemClock());
        this.runner = new ExecuteThreadRunner(this);
        this.creationTime = System.currentTimeMillis();
        this.lastAttachedRpcTime = None$.MODULE$;
        this.closedTime = None$.MODULE$;
        this.grpcResponseSenders = new ArrayBuffer();
    }
}

