/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connect.service;

import java.io.Serializable;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkEnv$;
import org.apache.spark.SparkSQLException;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.UI$;
import org.apache.spark.scheduler.SparkListenerInterface;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.connect.config.Connect$;
import org.apache.spark.sql.connect.service.ExecuteInfo;
import org.apache.spark.sql.connect.service.SessionHolder;
import org.apache.spark.sql.connect.service.SparkConnectExecutionManager;
import org.apache.spark.sql.connect.service.SparkConnectInterceptorRegistry$;
import org.apache.spark.sql.connect.service.SparkConnectService;
import org.apache.spark.sql.connect.service.SparkConnectStreamingQueryCache;
import org.apache.spark.sql.connect.service.SparkConnectStreamingQueryCache$;
import org.apache.spark.sql.connect.ui.SparkConnectServerAppStatusStore;
import org.apache.spark.sql.connect.ui.SparkConnectServerListener;
import org.apache.spark.sql.connect.ui.SparkConnectServerListener$;
import org.apache.spark.sql.connect.ui.SparkConnectServerTab;
import org.apache.spark.sql.connect.ui.SparkConnectServerTab$;
import org.apache.spark.status.ElementTrackingStore;
import org.apache.spark.util.kvstore.KVStore;
import org.slf4j.Logger;
import org.sparkproject.connect.grpc.Server;
import org.sparkproject.connect.grpc.netty.NettyServerBuilder;
import org.sparkproject.connect.grpc.protobuf.services.ProtoReflectionService;
import org.sparkproject.connect.guava.base.Ticker;
import org.sparkproject.connect.guava.cache.Cache;
import org.sparkproject.connect.guava.cache.CacheBuilder;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;

public final class SparkConnectService$
implements Logging {
    public static final SparkConnectService$ MODULE$ = new SparkConnectService$();
    private static SparkConnectExecutionManager executionManager;
    private static final int CACHE_SIZE;
    private static final int CACHE_TIMEOUT_SECONDS;
    private static Server server;
    private static Option<SparkConnectServerTab> uiTab;
    private static SparkConnectServerListener listener;
    private static final Cache<Tuple2<String, String>, SessionHolder> userSessionMapping;
    private static final SparkConnectStreamingQueryCache streamingSessionManager;
    private static transient Logger org$apache$spark$internal$Logging$$log_;
    private static volatile boolean bitmap$0;

    static {
        Logging.$init$((Logging)MODULE$);
        CACHE_SIZE = 100;
        CACHE_TIMEOUT_SECONDS = 3600;
        uiTab = None$.MODULE$;
        userSessionMapping = MODULE$.cacheBuilder(MODULE$.CACHE_SIZE(), MODULE$.CACHE_TIMEOUT_SECONDS()).build();
        streamingSessionManager = new SparkConnectStreamingQueryCache(SparkConnectStreamingQueryCache$.MODULE$.$lessinit$greater$default$1(), SparkConnectStreamingQueryCache$.MODULE$.$lessinit$greater$default$2(), SparkConnectStreamingQueryCache$.MODULE$.$lessinit$greater$default$3());
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private int CACHE_SIZE() {
        return CACHE_SIZE;
    }

    private int CACHE_TIMEOUT_SECONDS() {
        return CACHE_TIMEOUT_SECONDS;
    }

    public Server server() {
        return server;
    }

    public void server_$eq(Server x$1) {
        server = x$1;
    }

    public Option<SparkConnectServerTab> uiTab() {
        return uiTab;
    }

    public void uiTab_$eq(Option<SparkConnectServerTab> x$1) {
        uiTab = x$1;
    }

    public SparkConnectServerListener listener() {
        return listener;
    }

    public void listener_$eq(SparkConnectServerListener x$1) {
        listener = x$1;
    }

    public int localPort() {
        Predef$.MODULE$.assert(this.server() != null);
        return this.server().getPort();
    }

    private Cache<Tuple2<String, String>, SessionHolder> userSessionMapping() {
        return userSessionMapping;
    }

    private SparkConnectExecutionManager executionManager$lzycompute() {
        SparkConnectService$ sparkConnectService$ = this;
        synchronized (sparkConnectService$) {
            if (!bitmap$0) {
                executionManager = new SparkConnectExecutionManager();
                bitmap$0 = true;
            }
        }
        return executionManager;
    }

    public SparkConnectExecutionManager executionManager() {
        return !bitmap$0 ? this.executionManager$lzycompute() : executionManager;
    }

    public SparkConnectStreamingQueryCache streamingSessionManager() {
        return streamingSessionManager;
    }

    /*
     * WARNING - void declaration
     */
    private CacheBuilder<Object, Object> cacheBuilder(int cacheSize, int timeoutSeconds) {
        void var3_3;
        CacheBuilder<Object, Object> cacheBuilder = CacheBuilder.newBuilder().ticker(Ticker.systemTicker());
        if (cacheSize >= 0) {
            cacheBuilder = cacheBuilder.maximumSize(cacheSize);
        }
        Object object = timeoutSeconds >= 0 ? cacheBuilder.expireAfterAccess(timeoutSeconds, TimeUnit.SECONDS) : BoxedUnit.UNIT;
        cacheBuilder.removalListener(new SparkConnectService.RemoveSessionListener());
        return var3_3;
    }

    public SessionHolder getOrCreateIsolatedSession(String userId, String sessionId) {
        return this.getSessionOrDefault(userId, sessionId, () -> {
            void var2_2;
            SessionHolder holder = new SessionHolder(userId, sessionId, MODULE$.newIsolatedSession());
            holder.initializeSession();
            return var2_2;
        });
    }

    public SessionHolder getIsolatedSession(String userId, String sessionId) {
        return this.getSessionOrDefault(userId, sessionId, () -> {
            MODULE$.logDebug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(23).append("Session not found: (").append(userId).append(", ").append(sessionId).append(")").toString());
            throw new SparkSQLException("INVALID_HANDLE.SESSION_NOT_FOUND", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"handle"), (Object)sessionId)})));
        });
    }

    private SessionHolder getSessionOrDefault(String userId, String sessionId, Callable<SessionHolder> callable) {
        try {
            UUID.fromString(sessionId).toString();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new SparkSQLException("INVALID_HANDLE.FORMAT", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"handle"), (Object)sessionId)})));
        }
        return this.userSessionMapping().get((Tuple2<String, String>)new Tuple2((Object)userId, (Object)sessionId), callable);
    }

    public Either<Object, Seq<ExecuteInfo>> listActiveExecutions() {
        return this.executionManager().listActiveExecutions();
    }

    public void invalidateAllSessions() {
        this.userSessionMapping().invalidateAll();
    }

    public void putSessionForTesting(SessionHolder sessionHolder) {
        this.userSessionMapping().put((Tuple2<String, String>)new Tuple2((Object)sessionHolder.userId(), (Object)sessionHolder.sessionId()), sessionHolder);
    }

    private SparkSession newIsolatedSession() {
        return SparkSession$.MODULE$.active().newSession();
    }

    private void createListenerAndUI(SparkContext sc) {
        ElementTrackingStore kvStore = (ElementTrackingStore)sc.statusStore().store();
        this.listener_$eq(new SparkConnectServerListener(kvStore, sc.conf(), SparkConnectServerListener$.MODULE$.$lessinit$greater$default$3()));
        sc.listenerBus().addToStatusQueue((SparkListenerInterface)this.listener());
        this.uiTab_$eq((Option<SparkConnectServerTab>)(BoxesRunTime.unboxToBoolean((Object)sc.getConf().get(UI$.MODULE$.UI_ENABLED())) ? new Some((Object)new SparkConnectServerTab(new SparkConnectServerAppStatusStore((KVStore)kvStore), SparkConnectServerTab$.MODULE$.getSparkUI(sc))) : None$.MODULE$));
    }

    private void startGRPCService() {
        boolean debugMode = SparkEnv$.MODULE$.get().conf().getBoolean("spark.connect.grpc.debug.enabled", true);
        int port = BoxesRunTime.unboxToInt((Object)SparkEnv$.MODULE$.get().conf().get(Connect$.MODULE$.CONNECT_GRPC_BINDING_PORT()));
        NettyServerBuilder sb = (NettyServerBuilder)NettyServerBuilder.forPort(port).maxInboundMessageSize((int)BoxesRunTime.unboxToLong((Object)SparkEnv$.MODULE$.get().conf().get(Connect$.MODULE$.CONNECT_GRPC_MAX_INBOUND_MESSAGE_SIZE()))).addService(new SparkConnectService(debugMode));
        SparkConnectInterceptorRegistry$.MODULE$.chainInterceptors(sb);
        Object object = debugMode ? sb.addService(ProtoReflectionService.newInstance()) : BoxedUnit.UNIT;
        this.server_$eq(sb.build());
        this.server().start();
    }

    public void start(SparkContext sc) {
        this.startGRPCService();
        this.createListenerAndUI(sc);
    }

    public void stop(Option<Object> timeout, Option<TimeUnit> unit) {
        Object object;
        if (this.server() != null) {
            if (timeout.isDefined() && unit.isDefined()) {
                this.server().shutdown();
                object = BoxesRunTime.boxToBoolean((boolean)this.server().awaitTermination(BoxesRunTime.unboxToLong((Object)timeout.get()), (TimeUnit)((Object)unit.get())));
            } else {
                object = this.server().shutdownNow();
            }
        } else {
            object = BoxedUnit.UNIT;
        }
        this.streamingSessionManager().shutdown();
        this.executionManager().shutdown();
        this.userSessionMapping().invalidateAll();
        this.uiTab().foreach((Function1 & Serializable)x$3 -> {
            x$3.detach();
            return BoxedUnit.UNIT;
        });
    }

    public Option<Object> stop$default$1() {
        return None$.MODULE$;
    }

    public Option<TimeUnit> stop$default$2() {
        return None$.MODULE$;
    }

    public String extractErrorMessage(Throwable st) {
        String message = StringUtils.abbreviate((String)st.getMessage(), (int)2048);
        return this.convertNullString(message);
    }

    public String convertNullString(String str) {
        return str != null ? str : "";
    }

    private SparkConnectService$() {
    }
}

