/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connect.ui;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.spark.util.kvstore.KVIndex;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005-4QAD\b\u0001#mA\u0001B\t\u0001\u0003\u0006\u0004%\t\u0001\n\u0005\t\u0007\u0002\u0011\t\u0011)A\u0005K!AA\t\u0001BC\u0002\u0013\u0005Q\t\u0003\u0005J\u0001\t\u0005\t\u0015!\u0003G\u0011!Q\u0005A!b\u0001\n\u0003!\u0003\u0002C&\u0001\u0005\u0003\u0005\u000b\u0011B\u0013\t\u00111\u0003!Q1A\u0005\u0002\u0015C\u0001\"\u0014\u0001\u0003\u0002\u0003\u0006IA\u0012\u0005\t\u001d\u0002\u0011)\u0019!C\u0001\u000b\"Aq\n\u0001B\u0001B\u0003%a\tC\u0003Q\u0001\u0011\u0005\u0011\u000bC\u0003Z\u0001\u0011%Q\tC\u0003k\u0001\u0011\u0005QIA\u0006TKN\u001c\u0018n\u001c8J]\u001a|'B\u0001\t\u0012\u0003\t)\u0018N\u0003\u0002\u0013'\u000591m\u001c8oK\u000e$(B\u0001\u000b\u0016\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003-]\tQa\u001d9be.T!\u0001G\r\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Q\u0012aA8sON\u0011\u0001\u0001\b\t\u0003;\u0001j\u0011A\b\u0006\u0002?\u0005)1oY1mC&\u0011\u0011E\b\u0002\u0007\u0003:L(+\u001a4\u0002\u0013M,7o]5p]&#7\u0001A\u000b\u0002KA\u0011a%\f\b\u0003O-\u0002\"\u0001\u000b\u0010\u000e\u0003%R!AK\u0012\u0002\rq\u0012xn\u001c;?\u0013\tac$\u0001\u0004Qe\u0016$WMZ\u0005\u0003]=\u0012aa\u0015;sS:<'B\u0001\u0017\u001fQ\t\t\u0011G\u000b\u00023uA\u00111\u0007O\u0007\u0002i)\u0011QGN\u0001\bWZ\u001cHo\u001c:f\u0015\t9T#\u0001\u0003vi&d\u0017BA\u001d5\u0005\u001dYe+\u00138eKb\\\u0013a\u000f\t\u0003y\u0005k\u0011!\u0010\u0006\u0003}}\nA!\\3uC*\u0011\u0001IH\u0001\u000bC:tw\u000e^1uS>t\u0017B\u0001\">\u0005\u00199W\r\u001e;fe\u0006Q1/Z:tS>t\u0017\n\u001a\u0011\u0002\u001dM$\u0018M\u001d;US6,7\u000f^1naV\ta\t\u0005\u0002\u001e\u000f&\u0011\u0001J\b\u0002\u0005\u0019>tw-A\bti\u0006\u0014H\u000fV5nKN$\u0018-\u001c9!\u0003\u0019)8/\u001a:JI\u00069Qo]3s\u0013\u0012\u0004\u0013a\u00044j]&\u001c\b\u000eV5nKN$\u0018-\u001c9\u0002!\u0019Lg.[:i)&lWm\u001d;b[B\u0004\u0013A\u0004;pi\u0006dW\t_3dkRLwN\\\u0001\u0010i>$\u0018\r\\#yK\u000e,H/[8oA\u00051A(\u001b8jiz\"bA\u0015+V-^C\u0006CA*\u0001\u001b\u0005y\u0001\"\u0002\u0012\f\u0001\u0004)\u0003\"\u0002#\f\u0001\u00041\u0005\"\u0002&\f\u0001\u0004)\u0003\"\u0002'\f\u0001\u00041\u0005\"\u0002(\f\u0001\u00041\u0015a\u00044j]&\u001c\b\u000eV5nK&sG-\u001a=)\t1\u00114\fX\u0001\u0006m\u0006dW/Z\u0011\u0002;\u0006Qa-\u001b8jg\"$\u0016.\\3)\u00051y\u0006C\u00011i\u001b\u0005\t'B\u0001!c\u0015\t\u0019G-A\u0004kC\u000e\\7o\u001c8\u000b\u0005\u00154\u0017!\u00034bgR,'\u000f_7m\u0015\u00059\u0017aA2p[&\u0011\u0011.\u0019\u0002\u000b\u0015N|g.S4o_J,\u0017!\u0003;pi\u0006dG+[7f\u0001")
public class SessionInfo {
    private final String sessionId;
    private final long startTimestamp;
    private final String userId;
    private final long finishTimestamp;
    private final long totalExecution;

    @KVIndex
    public String sessionId() {
        return this.sessionId;
    }

    public long startTimestamp() {
        return this.startTimestamp;
    }

    public String userId() {
        return this.userId;
    }

    public long finishTimestamp() {
        return this.finishTimestamp;
    }

    public long totalExecution() {
        return this.totalExecution;
    }

    @JsonIgnore
    @KVIndex(value="finishTime")
    private long finishTimeIndex() {
        return this.finishTimestamp() > 0L ? this.finishTimestamp() : -1L;
    }

    public long totalTime() {
        return this.finishTimestamp() == 0L ? System.currentTimeMillis() - this.startTimestamp() : this.finishTimestamp() - this.startTimestamp();
    }

    public SessionInfo(String sessionId, long startTimestamp, String userId, long finishTimestamp, long totalExecution) {
        this.sessionId = sessionId;
        this.startTimestamp = startTimestamp;
        this.userId = userId;
        this.finishTimestamp = finishTimestamp;
        this.totalExecution = totalExecution;
    }
}

