/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connect.common;

import java.io.Serializable;
import java.text.NumberFormat;
import org.sparkproject.connect.protobuf.ByteString;
import org.sparkproject.connect.protobuf.Descriptors;
import org.sparkproject.connect.protobuf.Message;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class ProtoUtils$ {
    public static final ProtoUtils$ MODULE$ = new ProtoUtils$();
    private static final NumberFormat format = NumberFormat.getInstance();
    private static final int MAX_BYTES_SIZE = 8;
    private static final int MAX_STRING_SIZE = 1024;
    private static final char SPARK_JOB_TAGS_SEP = (char)44;

    private NumberFormat format() {
        return format;
    }

    private int MAX_BYTES_SIZE() {
        return MAX_BYTES_SIZE;
    }

    private int MAX_STRING_SIZE() {
        return MAX_STRING_SIZE;
    }

    public Message abbreviate(Message message, int maxStringSize) {
        Message.Builder builder = message.toBuilder();
        ((IterableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(message.getAllFields()).asScala()).iterator().foreach((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Descriptors.FieldDescriptor field = (Descriptors.FieldDescriptor)tuple2._1();
                Object string = tuple2._2();
                if (field != null) {
                    Descriptors.FieldDescriptor fieldDescriptor = field;
                    if (string instanceof String) {
                        String string2 = (String)string;
                        Descriptors.FieldDescriptor.JavaType javaType = fieldDescriptor.getJavaType();
                        Descriptors.FieldDescriptor.JavaType javaType2 = Descriptors.FieldDescriptor.JavaType.STRING;
                        if (!(javaType != null ? !((Object)((Object)javaType)).equals((Object)javaType2) : javaType2 != null) && string2 != null) {
                            int size = StringOps$.MODULE$.size$extension(Predef$.MODULE$.augmentString(string2));
                            return size > maxStringSize ? builder.setField(fieldDescriptor, MODULE$.createString(StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(string2), maxStringSize), size)) : builder.setField(fieldDescriptor, string2);
                        }
                    }
                }
            }
            if (tuple2 != null) {
                Descriptors.FieldDescriptor field = (Descriptors.FieldDescriptor)tuple2._1();
                Object byteString = tuple2._2();
                if (field != null) {
                    Descriptors.FieldDescriptor fieldDescriptor = field;
                    if (byteString instanceof ByteString) {
                        ByteString byteString2 = (ByteString)byteString;
                        Descriptors.FieldDescriptor.JavaType javaType = fieldDescriptor.getJavaType();
                        Descriptors.FieldDescriptor.JavaType javaType3 = Descriptors.FieldDescriptor.JavaType.BYTE_STRING;
                        if (!(javaType != null ? !((Object)((Object)javaType)).equals((Object)javaType3) : javaType3 != null) && byteString2 != null) {
                            Message.Builder builder;
                            int size = byteString2.size();
                            if (size > maxStringSize) {
                                byte[] prefix = (byte[])Array$.MODULE$.tabulate(maxStringSize, (Function1 & Serializable)index -> BoxesRunTime.boxToByte((byte)byteString2.byteAt(BoxesRunTime.unboxToInt((Object)index))), (ClassTag)ClassTag$.MODULE$.Byte());
                                builder = builder.setField(fieldDescriptor, MODULE$.createByteString(prefix, size));
                                return builder;
                            } else {
                                builder = builder.setField(fieldDescriptor, byteString2);
                            }
                            return builder;
                        }
                    }
                }
            }
            if (tuple2 != null) {
                Descriptors.FieldDescriptor field = (Descriptors.FieldDescriptor)tuple2._1();
                Object byteArray = tuple2._2();
                if (field != null) {
                    Descriptors.FieldDescriptor fieldDescriptor = field;
                    if (byteArray instanceof byte[]) {
                        byte[] byArray = (byte[])byteArray;
                        Descriptors.FieldDescriptor.JavaType javaType = fieldDescriptor.getJavaType();
                        Descriptors.FieldDescriptor.JavaType javaType4 = Descriptors.FieldDescriptor.JavaType.BYTE_STRING;
                        if (!(javaType != null ? !((Object)((Object)javaType)).equals((Object)javaType4) : javaType4 != null) && byArray != null) {
                            Message.Builder builder;
                            int size = ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.byteArrayOps(byArray));
                            if (size > MODULE$.MAX_BYTES_SIZE()) {
                                byte[] prefix = (byte[])ArrayOps$.MODULE$.take$extension(Predef$.MODULE$.byteArrayOps(byArray), MODULE$.MAX_BYTES_SIZE());
                                builder = builder.setField(fieldDescriptor, MODULE$.createByteString(prefix, size));
                                return builder;
                            } else {
                                builder = builder.setField(fieldDescriptor, byArray);
                            }
                            return builder;
                        }
                    }
                }
            }
            if (tuple2 != null) {
                Descriptors.FieldDescriptor field = (Descriptors.FieldDescriptor)tuple2._1();
                Object msg = tuple2._2();
                if (field != null) {
                    Descriptors.FieldDescriptor fieldDescriptor = field;
                    if (msg instanceof Message) {
                        Message message = (Message)msg;
                        Descriptors.FieldDescriptor.JavaType javaType = fieldDescriptor.getJavaType();
                        Descriptors.FieldDescriptor.JavaType javaType5 = Descriptors.FieldDescriptor.JavaType.MESSAGE;
                        if (!(javaType != null ? !((Object)((Object)javaType)).equals((Object)javaType5) : javaType5 != null) && message != null) {
                            return builder.setField(fieldDescriptor, MODULE$.abbreviate(message, MODULE$.abbreviate$default$2()));
                        }
                    }
                }
            }
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            Descriptors.FieldDescriptor field = (Descriptors.FieldDescriptor)tuple2._1();
            Object value = tuple2._2();
            if (field == null) throw new MatchError((Object)tuple2);
            Descriptors.FieldDescriptor fieldDescriptor = field;
            if (value == null) throw new MatchError((Object)tuple2);
            Object object = value;
            return builder.setField(fieldDescriptor, object);
        });
        return builder.build();
    }

    public int abbreviate$default$2() {
        return this.MAX_STRING_SIZE();
    }

    private ByteString createByteString(byte[] prefix, int size) {
        return ByteString.copyFrom((Iterable)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ByteString[]{ByteString.copyFrom(prefix), ByteString.copyFromUtf8(new StringBuilder(18).append("[truncated(size=").append(this.format().format(size)).append(")]").toString())}))).asJava());
    }

    private String createString(String prefix, int size) {
        return new StringBuilder(18).append(prefix).append("[truncated(size=").append(this.format().format(size)).append(")]").toString();
    }

    private char SPARK_JOB_TAGS_SEP() {
        return SPARK_JOB_TAGS_SEP;
    }

    public void throwIfInvalidTag(String tag) {
        if (tag == null) {
            throw new IllegalArgumentException("Spark Connect tag cannot be null.");
        }
        if (StringOps$.MODULE$.contains$extension(Predef$.MODULE$.augmentString(tag), this.SPARK_JOB_TAGS_SEP())) {
            throw new IllegalArgumentException(new StringBuilder(36).append("Spark Connect tag cannot contain '").append(this.SPARK_JOB_TAGS_SEP()).append("'.").toString());
        }
        if (tag.isEmpty()) {
            throw new IllegalArgumentException("Spark Connect tag cannot be an empty string.");
        }
    }

    private ProtoUtils$() {
    }
}

