/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connect.common;

import java.io.Serializable;
import org.apache.spark.connect.proto.DataType;
import org.apache.spark.sql.connect.common.InvalidPlanInput;
import org.apache.spark.sql.connect.common.InvalidPlanInput$;
import org.apache.spark.sql.connect.common.ProtoDataTypes$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.CalendarIntervalType$;
import org.apache.spark.sql.types.CharType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DayTimeIntervalType;
import org.apache.spark.sql.types.DayTimeIntervalType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.Metadata$;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.PythonUserDefinedType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.UserDefinedType;
import org.apache.spark.sql.types.VarcharType;
import org.apache.spark.sql.types.YearMonthIntervalType;
import org.apache.spark.sql.types.YearMonthIntervalType$;
import org.apache.spark.util.SparkClassUtils$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Seq;
import scala.collection.convert.ImplicitConversions$;
import scala.runtime.BoxedUnit;

public final class DataTypeProtoConverter$ {
    public static final DataTypeProtoConverter$ MODULE$ = new DataTypeProtoConverter$();

    public DataType toCatalystType(org.apache.spark.connect.proto.DataType t2) {
        UserDefinedType<?> userDefinedType;
        DataType.KindCase kindCase = t2.getKindCase();
        if (DataType.KindCase.NULL.equals(kindCase)) {
            userDefinedType = NullType$.MODULE$;
        } else if (DataType.KindCase.BINARY.equals(kindCase)) {
            userDefinedType = BinaryType$.MODULE$;
        } else if (DataType.KindCase.BOOLEAN.equals(kindCase)) {
            userDefinedType = BooleanType$.MODULE$;
        } else if (DataType.KindCase.BYTE.equals(kindCase)) {
            userDefinedType = ByteType$.MODULE$;
        } else if (DataType.KindCase.SHORT.equals(kindCase)) {
            userDefinedType = ShortType$.MODULE$;
        } else if (DataType.KindCase.INTEGER.equals(kindCase)) {
            userDefinedType = IntegerType$.MODULE$;
        } else if (DataType.KindCase.LONG.equals(kindCase)) {
            userDefinedType = LongType$.MODULE$;
        } else if (DataType.KindCase.FLOAT.equals(kindCase)) {
            userDefinedType = FloatType$.MODULE$;
        } else if (DataType.KindCase.DOUBLE.equals(kindCase)) {
            userDefinedType = DoubleType$.MODULE$;
        } else if (DataType.KindCase.DECIMAL.equals(kindCase)) {
            userDefinedType = this.toCatalystDecimalType(t2.getDecimal());
        } else if (DataType.KindCase.STRING.equals(kindCase)) {
            userDefinedType = StringType$.MODULE$;
        } else if (DataType.KindCase.CHAR.equals(kindCase)) {
            userDefinedType = new CharType(t2.getChar().getLength());
        } else if (DataType.KindCase.VAR_CHAR.equals(kindCase)) {
            userDefinedType = new VarcharType(t2.getVarChar().getLength());
        } else if (DataType.KindCase.DATE.equals(kindCase)) {
            userDefinedType = DateType$.MODULE$;
        } else if (DataType.KindCase.TIMESTAMP.equals(kindCase)) {
            userDefinedType = TimestampType$.MODULE$;
        } else if (DataType.KindCase.TIMESTAMP_NTZ.equals(kindCase)) {
            userDefinedType = TimestampNTZType$.MODULE$;
        } else if (DataType.KindCase.CALENDAR_INTERVAL.equals(kindCase)) {
            userDefinedType = CalendarIntervalType$.MODULE$;
        } else if (DataType.KindCase.YEAR_MONTH_INTERVAL.equals(kindCase)) {
            userDefinedType = this.toCatalystYearMonthIntervalType(t2.getYearMonthInterval());
        } else if (DataType.KindCase.DAY_TIME_INTERVAL.equals(kindCase)) {
            userDefinedType = this.toCatalystDayTimeIntervalType(t2.getDayTimeInterval());
        } else if (DataType.KindCase.ARRAY.equals(kindCase)) {
            userDefinedType = this.toCatalystArrayType(t2.getArray());
        } else if (DataType.KindCase.STRUCT.equals(kindCase)) {
            userDefinedType = this.toCatalystStructType(t2.getStruct());
        } else if (DataType.KindCase.MAP.equals(kindCase)) {
            userDefinedType = this.toCatalystMapType(t2.getMap());
        } else if (DataType.KindCase.UDT.equals(kindCase)) {
            userDefinedType = this.toCatalystUDT(t2.getUdt());
        } else {
            throw new InvalidPlanInput(new StringBuilder(44).append("Does not support convert ").append(t2.getKindCase()).append(" to catalyst types.").toString(), InvalidPlanInput$.MODULE$.apply$default$2());
        }
        return userDefinedType;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private DecimalType toCatalystDecimalType(DataType.Decimal t2) {
        Tuple2.mcZZ.sp sp2 = new Tuple2.mcZZ.sp(t2.hasPrecision(), t2.hasScale());
        if (sp2 != null) {
            boolean bl = sp2._1$mcZ$sp();
            boolean bl2 = sp2._2$mcZ$sp();
            if (bl && bl2) {
                return new DecimalType(t2.getPrecision(), t2.getScale());
            }
        }
        if (sp2 == null) return new DecimalType();
        boolean bl = sp2._1$mcZ$sp();
        boolean bl3 = sp2._2$mcZ$sp();
        if (true != bl) return new DecimalType();
        if (false != bl3) return new DecimalType();
        return new DecimalType(t2.getPrecision());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private YearMonthIntervalType toCatalystYearMonthIntervalType(DataType.YearMonthInterval t2) {
        Tuple2.mcZZ.sp sp2 = new Tuple2.mcZZ.sp(t2.hasStartField(), t2.hasEndField());
        if (sp2 != null) {
            boolean bl = sp2._1$mcZ$sp();
            boolean bl2 = sp2._2$mcZ$sp();
            if (bl && bl2) {
                return new YearMonthIntervalType((byte)t2.getStartField(), (byte)t2.getEndField());
            }
        }
        if (sp2 == null) return YearMonthIntervalType$.MODULE$.apply();
        boolean bl = sp2._1$mcZ$sp();
        boolean bl3 = sp2._2$mcZ$sp();
        if (true != bl) return YearMonthIntervalType$.MODULE$.apply();
        if (false != bl3) return YearMonthIntervalType$.MODULE$.apply();
        return YearMonthIntervalType$.MODULE$.apply((byte)t2.getStartField());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private DayTimeIntervalType toCatalystDayTimeIntervalType(DataType.DayTimeInterval t2) {
        Tuple2.mcZZ.sp sp2 = new Tuple2.mcZZ.sp(t2.hasStartField(), t2.hasEndField());
        if (sp2 != null) {
            boolean bl = sp2._1$mcZ$sp();
            boolean bl2 = sp2._2$mcZ$sp();
            if (bl && bl2) {
                return new DayTimeIntervalType((byte)t2.getStartField(), (byte)t2.getEndField());
            }
        }
        if (sp2 == null) return DayTimeIntervalType$.MODULE$.apply();
        boolean bl = sp2._1$mcZ$sp();
        boolean bl3 = sp2._2$mcZ$sp();
        if (true != bl) return DayTimeIntervalType$.MODULE$.apply();
        if (false != bl3) return DayTimeIntervalType$.MODULE$.apply();
        return DayTimeIntervalType$.MODULE$.apply((byte)t2.getStartField());
    }

    private ArrayType toCatalystArrayType(DataType.Array t2) {
        return new ArrayType(this.toCatalystType(t2.getElementType()), t2.getContainsNull());
    }

    private StructType toCatalystStructType(DataType.Struct t2) {
        scala.collection.immutable.Seq fields = (scala.collection.immutable.Seq)ImplicitConversions$.MODULE$.list$u0020asScalaBuffer(t2.getFieldsList()).toSeq().map((Function1 & Serializable)protoField -> {
            Metadata metadata = protoField.hasMetadata() ? Metadata$.MODULE$.fromJson(protoField.getMetadata()) : Metadata$.MODULE$.empty();
            return new StructField(protoField.getName(), MODULE$.toCatalystType(protoField.getDataType()), protoField.getNullable(), metadata);
        });
        return StructType$.MODULE$.apply(fields);
    }

    private MapType toCatalystMapType(DataType.Map t2) {
        return new MapType(this.toCatalystType(t2.getKeyType()), this.toCatalystType(t2.getValueType()), t2.getValueContainsNull());
    }

    private UserDefinedType<?> toCatalystUDT(DataType.UDT t2) {
        PythonUserDefinedType pythonUserDefinedType;
        String string = t2.getType();
        String string2 = "udt";
        if (string == null ? string2 != null : !string.equals(string2)) {
            throw new InvalidPlanInput(new StringBuilder(66).append("UserDefinedType requires the 'type' field to be 'udt', but got '").append(t2.getType()).append("'.").toString(), InvalidPlanInput$.MODULE$.apply$default$2());
        }
        if (t2.hasJvmClass()) {
            pythonUserDefinedType = (UserDefinedType)SparkClassUtils$.MODULE$.classForName(t2.getJvmClass(), SparkClassUtils$.MODULE$.classForName$default$2(), SparkClassUtils$.MODULE$.classForName$default$3()).getConstructor(new Class[0]).newInstance(new Object[0]);
        } else {
            if (!(t2.hasPythonClass() && t2.hasSerializedPythonClass() && t2.hasSqlType())) {
                throw new InvalidPlanInput("PythonUserDefinedType requires all the three fields: python_class, serialized_python_class and sql_type.", InvalidPlanInput$.MODULE$.apply$default$2());
            }
            pythonUserDefinedType = new PythonUserDefinedType(this.toCatalystType(t2.getSqlType()), t2.getPythonClass(), t2.getSerializedPythonClass());
        }
        return pythonUserDefinedType;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public org.apache.spark.connect.proto.DataType toConnectProtoType(DataType t2) {
        StructType structType;
        StructField[] fields;
        DecimalType decimalType;
        Option option;
        DataType dataType = t2;
        if (NullType$.MODULE$.equals(dataType)) {
            return ProtoDataTypes$.MODULE$.NullType();
        }
        if (BooleanType$.MODULE$.equals(dataType)) {
            return ProtoDataTypes$.MODULE$.BooleanType();
        }
        if (BinaryType$.MODULE$.equals(dataType)) {
            return ProtoDataTypes$.MODULE$.BinaryType();
        }
        if (ByteType$.MODULE$.equals(dataType)) {
            return ProtoDataTypes$.MODULE$.ByteType();
        }
        if (ShortType$.MODULE$.equals(dataType)) {
            return ProtoDataTypes$.MODULE$.ShortType();
        }
        if (IntegerType$.MODULE$.equals(dataType)) {
            return ProtoDataTypes$.MODULE$.IntegerType();
        }
        if (LongType$.MODULE$.equals(dataType)) {
            return ProtoDataTypes$.MODULE$.LongType();
        }
        if (FloatType$.MODULE$.equals(dataType)) {
            return ProtoDataTypes$.MODULE$.FloatType();
        }
        if (DoubleType$.MODULE$.equals(dataType)) {
            return ProtoDataTypes$.MODULE$.DoubleType();
        }
        if (dataType instanceof DecimalType && !(option = DecimalType.Fixed$.MODULE$.unapply(decimalType = (DecimalType)dataType)).isEmpty()) {
            int precision = ((Tuple2)option.get())._1$mcI$sp();
            int scale = ((Tuple2)option.get())._2$mcI$sp();
            return org.apache.spark.connect.proto.DataType.newBuilder().setDecimal(DataType.Decimal.newBuilder().setPrecision(precision).setScale(scale).build()).build();
        }
        if (StringType$.MODULE$.equals(dataType)) {
            return ProtoDataTypes$.MODULE$.StringType();
        }
        if (dataType instanceof CharType) {
            CharType charType = (CharType)dataType;
            int length = charType.length();
            return org.apache.spark.connect.proto.DataType.newBuilder().setChar(DataType.Char.newBuilder().setLength(length).build()).build();
        }
        if (dataType instanceof VarcharType) {
            VarcharType varcharType = (VarcharType)dataType;
            int length = varcharType.length();
            return org.apache.spark.connect.proto.DataType.newBuilder().setVarChar(DataType.VarChar.newBuilder().setLength(length).build()).build();
        }
        if (DateType$.MODULE$.equals(dataType)) {
            return ProtoDataTypes$.MODULE$.DateType();
        }
        if (TimestampType$.MODULE$.equals(dataType)) {
            return ProtoDataTypes$.MODULE$.TimestampType();
        }
        if (TimestampNTZType$.MODULE$.equals(dataType)) {
            return ProtoDataTypes$.MODULE$.TimestampNTZType();
        }
        if (CalendarIntervalType$.MODULE$.equals(dataType)) {
            return ProtoDataTypes$.MODULE$.CalendarIntervalType();
        }
        if (dataType instanceof YearMonthIntervalType) {
            YearMonthIntervalType yearMonthIntervalType = (YearMonthIntervalType)dataType;
            byte startField = yearMonthIntervalType.startField();
            byte endField = yearMonthIntervalType.endField();
            return org.apache.spark.connect.proto.DataType.newBuilder().setYearMonthInterval(DataType.YearMonthInterval.newBuilder().setStartField(startField).setEndField(endField).build()).build();
        }
        if (dataType instanceof DayTimeIntervalType) {
            DayTimeIntervalType dayTimeIntervalType = (DayTimeIntervalType)dataType;
            byte startField = dayTimeIntervalType.startField();
            byte endField = dayTimeIntervalType.endField();
            return org.apache.spark.connect.proto.DataType.newBuilder().setDayTimeInterval(DataType.DayTimeInterval.newBuilder().setStartField(startField).setEndField(endField).build()).build();
        }
        if (dataType instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType;
            DataType elementType = arrayType.elementType();
            boolean containsNull = arrayType.containsNull();
            if (elementType != null) {
                DataType dataType2 = elementType;
                if (true) {
                    boolean bl = containsNull;
                    return org.apache.spark.connect.proto.DataType.newBuilder().setArray(DataType.Array.newBuilder().setElementType(this.toConnectProtoType(dataType2)).setContainsNull(bl).build()).build();
                }
            }
        }
        if (dataType instanceof StructType && (fields = (structType = (StructType)dataType).fields()) != null) {
            StructField[] structFieldArray = fields;
            scala.collection.immutable.Seq protoFields = (scala.collection.immutable.Seq)ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])structFieldArray)).map((Function1 & Serializable)x0$1 -> {
                boolean bl;
                DataType dataType;
                String string;
                Metadata metadata;
                block3: {
                    StructField structField;
                    block2: {
                        structField = x0$1;
                        if (structField == null) break block2;
                        String name = structField.name();
                        DataType dataType2 = structField.dataType();
                        boolean nullable = structField.nullable();
                        metadata = structField.metadata();
                        if (name == null) break block2;
                        string = name;
                        if (dataType2 == null) break block2;
                        dataType = dataType2;
                        if (!true) break block2;
                        bl = nullable;
                        if (metadata != null) break block3;
                    }
                    throw new MatchError((Object)structField);
                }
                Metadata metadata2 = metadata;
                DataType.StructField structField = metadata2.equals((Object)Metadata$.MODULE$.empty()) ? DataType.StructField.newBuilder().setName(string).setDataType(MODULE$.toConnectProtoType(dataType)).setNullable(bl).build() : DataType.StructField.newBuilder().setName(string).setDataType(MODULE$.toConnectProtoType(dataType)).setNullable(bl).setMetadata(metadata2.json()).build();
                return structField;
            });
            return org.apache.spark.connect.proto.DataType.newBuilder().setStruct(DataType.Struct.newBuilder().addAllFields(ImplicitConversions$.MODULE$.seq$u0020AsJavaList((Seq)protoFields)).build()).build();
        }
        if (dataType instanceof MapType) {
            MapType mapType = (MapType)dataType;
            DataType keyType = mapType.keyType();
            DataType valueType = mapType.valueType();
            boolean valueContainsNull = mapType.valueContainsNull();
            if (keyType != null) {
                DataType dataType3 = keyType;
                if (valueType != null) {
                    DataType dataType4 = valueType;
                    if (true) {
                        boolean bl = valueContainsNull;
                        return org.apache.spark.connect.proto.DataType.newBuilder().setMap(DataType.Map.newBuilder().setKeyType(this.toConnectProtoType(dataType3)).setValueType(this.toConnectProtoType(dataType4)).setValueContainsNull(bl).build()).build();
                    }
                }
            }
        }
        if (dataType instanceof PythonUserDefinedType) {
            PythonUserDefinedType pythonUserDefinedType = (PythonUserDefinedType)dataType;
            return org.apache.spark.connect.proto.DataType.newBuilder().setUdt(DataType.UDT.newBuilder().setType("udt").setPythonClass(pythonUserDefinedType.pyUDT()).setSqlType(this.toConnectProtoType(pythonUserDefinedType.sqlType())).setSerializedPythonClass(pythonUserDefinedType.serializedPyClass()).build()).build();
        }
        if (!(dataType instanceof UserDefinedType)) throw new InvalidPlanInput(new StringBuilder(49).append("Does not support convert ").append(t2.typeName()).append(" to connect proto types.").toString(), InvalidPlanInput$.MODULE$.apply$default$2());
        UserDefinedType userDefinedType = (UserDefinedType)dataType;
        DataType.UDT.Builder builder = DataType.UDT.newBuilder();
        builder.setType("udt").setJvmClass(userDefinedType.getClass().getName()).setSqlType(this.toConnectProtoType(userDefinedType.sqlType()));
        Object object = userDefinedType.pyUDT() != null ? builder.setPythonClass(userDefinedType.pyUDT()) : BoxedUnit.UNIT;
        return org.apache.spark.connect.proto.DataType.newBuilder().setUdt(builder.build()).build();
    }

    private DataTypeProtoConverter$() {
    }
}

