/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connect;

import io.grpc.Channel;
import io.grpc.ManagedChannel;
import java.io.Serializable;
import java.util.UUID;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.connect.proto.ExecutePlanRequest;
import org.apache.spark.connect.proto.ExecutePlanResponse;
import org.apache.spark.connect.proto.Plan;
import org.apache.spark.connect.proto.ReattachExecuteRequest;
import org.apache.spark.connect.proto.ReattachOptions;
import org.apache.spark.connect.proto.SparkConnectServiceGrpc;
import org.apache.spark.connect.proto.UserContext;
import org.apache.spark.sql.connect.client.CloseableIterator;
import org.apache.spark.sql.connect.client.CustomSparkConnectBlockingStub;
import org.apache.spark.sql.connect.client.ExecutePlanResponseReattachableIterator;
import org.apache.spark.sql.connect.client.GrpcRetryHandler;
import org.apache.spark.sql.connect.client.SparkConnectClient;
import org.apache.spark.sql.connect.client.SparkConnectClient$;
import org.apache.spark.sql.connect.client.WrappedCloseableIterator;
import org.apache.spark.sql.connect.common.config.ConnectCommon$;
import org.apache.spark.sql.connect.config.Connect$;
import org.apache.spark.sql.connect.dsl.package;
import org.apache.spark.sql.connect.service.ExecuteHolder;
import org.apache.spark.sql.connect.service.ExecuteInfo;
import org.apache.spark.sql.connect.service.SparkConnectService$;
import org.apache.spark.sql.test.SharedSparkSession;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions;
import org.scalatest.Assertions$;
import org.scalatest.concurrent.Eventually$;
import org.scalatest.concurrent.Signaler$;
import org.scalatest.concurrent.TimeLimits$;
import org.scalatest.enablers.Retrying$;
import org.scalatest.enablers.Timed$;
import org.scalatest.time.Span;
import org.scalatest.time.SpanSugar$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Random$;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0005\t}baB\u0013'!\u0003\r\t!\r\u0005\u0006y\u0001!\t!\u0010\u0005\b\t\u0002\u0011\r\u0011\"\u0001F\u0011\u001dI\u0005A1A\u0005\u0002)CQa\u0015\u0001\u0005BuBQ\u0001\u0016\u0001\u0005BuBQ!\u0016\u0001\u0005BuBQA\u0016\u0001\u0005BuBQa\u0016\u0001\u0005\u0012uBq\u0001\u0017\u0001C\u0002\u0013E\u0011\fC\u0004c\u0001\t\u0007I\u0011C-\t\u000f\r\u0004!\u0019!C\tI\"9A\u0010\u0001b\u0001\n#i\bbBA\u0006\u0001\u0011E\u0011Q\u0002\u0005\n\u0003k\u0001\u0011\u0013!C\t\u0003oA\u0011\"!\u0014\u0001#\u0003%\t\"a\u000e\t\u000f\u0005=\u0003\u0001\"\u0005\u0002R!9\u0011Q\r\u0001\u0005\u0012\u0005\u001d\u0004bBA7\u0001\u0011E\u0011q\u000e\u0005\u0007\u0003\u001b\u0003A\u0011C\u001f\t\r\u0005=\u0005\u0001\"\u0005>\u0011\u0019\t\t\n\u0001C\t{!1\u00111\u0013\u0001\u0005\u0012uBq!!&\u0001\t#\t9\nC\u0004\u0002\u001c\u0002!\t\"!(\t\u000f\u0005\u0005\u0006\u0001\"\u0005\u0002$\"9\u0011\u0011\u0017\u0001\u0005\u0012\u0005M\u0006bBAc\u0001\u0011E\u0011q\u0019\u0005\b\u0003C\u0004A\u0011CAr\u0011%\u0011\u0019\u0001AI\u0001\n#\u0011)\u0001C\u0004\u0003\n\u0001!\tBa\u0003\t\u000f\t%\u0001\u0001\"\u0005\u0003\u001e!I!Q\u0005\u0001\u0012\u0002\u0013E!q\u0005\u0005\u000e\u0005W\u0001\u0001\u0013aA\u0001\u0002\u0013%QH!\f\t\u001b\t=\u0002\u0001%A\u0002\u0002\u0003%I!\u0010B\u0019\u00115\u0011\u0019\u0004\u0001I\u0001\u0004\u0003\u0005I\u0011B\u001f\u00036!i!1\b\u0001\u0011\u0002\u0007\u0005\t\u0011\"\u0003>\u0005{\u0011ac\u00159be.\u001cuN\u001c8fGR\u001cVM\u001d<feR+7\u000f\u001e\u0006\u0003O!\nqaY8o]\u0016\u001cGO\u0003\u0002*U\u0005\u00191/\u001d7\u000b\u0005-b\u0013!B:qCJ\\'BA\u0017/\u0003\u0019\t\u0007/Y2iK*\tq&A\u0002pe\u001e\u001c\u0001aE\u0002\u0001eY\u0002\"a\r\u001b\u000e\u0003)J!!\u000e\u0016\u0003\u001bM\u0003\u0018M]6Gk:\u001cV/\u001b;f!\t9$(D\u00019\u0015\tI\u0004&\u0001\u0003uKN$\u0018BA\u001e9\u0005I\u0019\u0006.\u0019:fIN\u0003\u0018M]6TKN\u001c\u0018n\u001c8\u0002\r\u0011Jg.\u001b;%)\u0005q\u0004CA C\u001b\u0005\u0001%\"A!\u0002\u000bM\u001c\u0017\r\\1\n\u0005\r\u0003%\u0001B+oSR\f!b]3sm\u0016\u0014\bk\u001c:u+\u00051\u0005CA H\u0013\tA\u0005IA\u0002J]R\f\u0011#\u001a<f]R,\u0018\r\u001c7z)&lWm\\;u+\u0005Y\u0005C\u0001'R\u001b\u0005i%B\u0001(P\u0003\u0011!\u0018.\\3\u000b\u0005As\u0013!C:dC2\fG/Z:u\u0013\t\u0011VJ\u0001\u0003Ta\u0006t\u0017!\u00032fM>\u0014X-\u00117m\u0003!\tg\r^3s\u00032d\u0017A\u00032fM>\u0014X-R1dQ\u0006I\u0011M\u001a;fe\u0016\u000b7\r[\u0001\u0013G2,\u0017M]!mY\u0016CXmY;uS>t7/\u0001\teK\u001a\fW\u000f\u001c;TKN\u001c\u0018n\u001c8JIV\t!\f\u0005\u0002\\A6\tAL\u0003\u0002^=\u0006!A.\u00198h\u0015\u0005y\u0016\u0001\u00026bm\u0006L!!\u0019/\u0003\rM#(/\u001b8h\u00035!WMZ1vYR,6/\u001a:JI\u0006\u0019Am\u001d7\u0016\u0003\u0015\u0004\"AZ=\u000f\u0005\u001d4hB\u00015v\u001d\tIGO\u0004\u0002kg:\u00111N\u001d\b\u0003YFt!!\u001c9\u000e\u00039T!a\u001c\u0019\u0002\rq\u0012xn\u001c;?\u0013\u0005y\u0013BA\u0017/\u0013\tYC&\u0003\u0002*U%\u0011q\u0005K\u0005\u0003G\u001aJ!a\u001e=\u0002\u000fA\f7m[1hK*\u00111MJ\u0005\u0003un\u0014\u0011#T8dWJ+Wn\u001c;f'\u0016\u001c8/[8o\u0015\t9\b0A\u0006vg\u0016\u00148i\u001c8uKb$X#\u0001@\u0011\u0007}\f9!\u0004\u0002\u0002\u0002)!\u00111AA\u0003\u0003\u0015\u0001(o\u001c;p\u0015\t9#&\u0003\u0003\u0002\n\u0005\u0005!aC+tKJ\u001cuN\u001c;fqR\fqCY;jY\u0012,\u00050Z2vi\u0016\u0004F.\u00198SKF,Xm\u001d;\u0015\u0011\u0005=\u0011QCA\u0010\u0003c\u00012a`A\t\u0013\u0011\t\u0019\"!\u0001\u0003%\u0015CXmY;uKBc\u0017M\u001c*fcV,7\u000f\u001e\u0005\b\u0003/i\u0001\u0019AA\r\u0003\u0011\u0001H.\u00198\u0011\u0007}\fY\"\u0003\u0003\u0002\u001e\u0005\u0005!\u0001\u0002)mC:D\u0011\"!\t\u000e!\u0003\u0005\r!a\t\u0002\u0013M,7o]5p]&#\u0007\u0003BA\u0013\u0003[qA!a\n\u0002*A\u0011Q\u000eQ\u0005\u0004\u0003W\u0001\u0015A\u0002)sK\u0012,g-C\u0002b\u0003_Q1!a\u000bA\u0011%\t\u0019$\u0004I\u0001\u0002\u0004\t\u0019#A\u0006pa\u0016\u0014\u0018\r^5p]&#\u0017!\t2vS2$W\t_3dkR,\u0007\u000b\\1o%\u0016\fX/Z:uI\u0011,g-Y;mi\u0012\u0012TCAA\u001dU\u0011\t\u0019#a\u000f,\u0005\u0005u\u0002\u0003BA \u0003\u0013j!!!\u0011\u000b\t\u0005\r\u0013QI\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a\u0012A\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003\u0017\n\tEA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f\u0011EY;jY\u0012,\u00050Z2vi\u0016\u0004F.\u00198SKF,Xm\u001d;%I\u00164\u0017-\u001e7uIM\n1DY;jY\u0012\u0014V-\u0019;uC\u000eDW\t_3dkR,'+Z9vKN$HCBA*\u00033\nY\u0006E\u0002\u0000\u0003+JA!a\u0016\u0002\u0002\t1\"+Z1ui\u0006\u001c\u0007.\u0012=fGV$XMU3rk\u0016\u001cH\u000fC\u0004\u00024A\u0001\r!a\t\t\u000f\u0005u\u0003\u00031\u0001\u0002`\u0005Q!/Z:q_:\u001cX-\u00133\u0011\u000b}\n\t'a\t\n\u0007\u0005\r\u0004I\u0001\u0004PaRLwN\\\u0001\nEVLG\u000e\u001a)mC:$B!!\u0007\u0002j!9\u00111N\tA\u0002\u0005\r\u0012!B9vKJL\u0018aF4fiJ+\u0017\r\u001e;bG\"\f'\r\\3Ji\u0016\u0014\u0018\r^8s)\u0011\t\t(! \u0011\t\u0005M\u0014\u0011P\u0007\u0003\u0003kR1!a\u001e'\u0003\u0019\u0019G.[3oi&!\u00111PA;\u0005\u001d*\u00050Z2vi\u0016\u0004F.\u00198SKN\u0004xN\\:f%\u0016\fG\u000f^1dQ\u0006\u0014G.Z%uKJ\fGo\u001c:\t\u000f\u0005}$\u00031\u0001\u0002\u0002\u0006a1\u000f^;c\u0013R,'/\u0019;peB1\u00111OAB\u0003\u000fKA!!\"\u0002v\t\t2\t\\8tK\u0006\u0014G.Z%uKJ\fGo\u001c:\u0011\u0007}\fI)\u0003\u0003\u0002\f\u0006\u0005!aE#yK\u000e,H/\u001a)mC:\u0014Vm\u001d9p]N,\u0017AE1tg\u0016\u0014HOT8BGRLg/\u001a*qGN\fA$Y:tKJ$XI^3oiV\fG\u000e\\=O_\u0006\u001bG/\u001b<f%B\u001c7/\u0001\rbgN,'\u000f\u001e(p\u0003\u000e$\u0018N^3Fq\u0016\u001cW\u000f^5p]N\f!%Y:tKJ$XI^3oiV\fG\u000e\\=O_\u0006\u001bG/\u001b<f\u000bb,7-\u001e;j_:\u001c\u0018aF1tg\u0016\u0014H/\u0012=fGV$\u0018n\u001c8SK2,\u0017m]3e)\rq\u0014\u0011\u0014\u0005\b\u0003g9\u0002\u0019AA\u0012\u0003\u0005\n7o]3si\u00163XM\u001c;vC2d\u00170\u0012=fGV$\u0018n\u001c8SK2,\u0017m]3e)\rq\u0014q\u0014\u0005\b\u0003gA\u0002\u0019AA\u0012\u0003I9W\r^#yK\u000e,H/[8o\u0011>dG-\u001a:\u0016\u0005\u0005\u0015\u0006\u0003BAT\u0003[k!!!+\u000b\u0007\u0005-f%A\u0004tKJ4\u0018nY3\n\t\u0005=\u0016\u0011\u0016\u0002\u000e\u000bb,7-\u001e;f\u0011>dG-\u001a:\u0002\u0015]LG\u000f[\"mS\u0016tG\u000fF\u0002?\u0003kCq!a.\u001b\u0001\u0004\tI,A\u0001g!\u0019y\u00141XA`}%\u0019\u0011Q\u0018!\u0003\u0013\u0019+hn\u0019;j_:\f\u0004\u0003BA:\u0003\u0003LA!a1\u0002v\t\u00112\u000b]1sW\u000e{gN\\3di\u000ec\u0017.\u001a8u\u0003M9\u0018\u000e\u001e5SC^\u0014En\\2lS:<7\u000b^;c)\rq\u0014\u0011\u001a\u0005\b\u0003o[\u0002\u0019AAf!\u0019y\u00141XAg}A!\u0011qZAn\u001d\u0011\t\t.a6\u000f\t\u0005M\u0017Q[\u0007\u0003\u0003\u000bIA!a\u0001\u0002\u0006%!\u0011\u0011\\A\u0001\u0003]\u0019\u0006/\u0019:l\u0007>tg.Z2u'\u0016\u0014h/[2f\u000fJ\u00048-\u0003\u0003\u0002^\u0006}'aH*qCJ\\7i\u001c8oK\u000e$8+\u001a:wS\u000e,'\t\\8dW&twm\u0015;vE*!\u0011\u0011\\A\u0001\u0003Y9\u0018\u000e\u001e5DkN$x.\u001c\"m_\u000e\\\u0017N\\4TiV\u0014G\u0003BAs\u0003c$2APAt\u0011\u001d\t9\f\ba\u0001\u0003S\u0004baPA^\u0003Wt\u0004\u0003BA:\u0003[LA!a<\u0002v\tq2)^:u_6\u001c\u0006/\u0019:l\u0007>tg.Z2u\u00052|7m[5oON#XO\u0019\u0005\n\u0003gd\u0002\u0013!a\u0001\u0003k\f1B]3uef\u0004v\u000e\\5dsB!\u0011q_A\u007f\u001d\u0011\t\u0019(!?\n\t\u0005m\u0018QO\u0001\u0011\u000fJ\u00048MU3uefD\u0015M\u001c3mKJLA!a@\u0003\u0002\tY!+\u001a;ssB{G.[2z\u0015\u0011\tY0!\u001e\u0002A]LG\u000f[\"vgR|WN\u00117pG.LgnZ*uk\n$C-\u001a4bk2$H%M\u000b\u0003\u0005\u000fQC!!>\u0002<\u0005A!/\u001e8Rk\u0016\u0014\u0018\u0010F\u0004?\u0005\u001b\u0011yAa\u0005\t\u000f\u0005]a\u00041\u0001\u0002\u001a!1!\u0011\u0003\u0010A\u0002-\u000bA\"];fef$\u0016.\\3pkRDqA!\u0006\u001f\u0001\u0004\u00119\"A\u0005ji\u0016\u00148\u000b\\3faB\u0019qH!\u0007\n\u0007\tm\u0001I\u0001\u0003M_:<Gc\u0002 \u0003 \t\u0005\"1\u0005\u0005\b\u0003Wz\u0002\u0019AA\u0012\u0011\u0019\u0011\tb\ba\u0001\u0017\"I!QC\u0010\u0011\u0002\u0003\u0007!qC\u0001\u0013eVt\u0017+^3ss\u0012\"WMZ1vYR$3'\u0006\u0002\u0003*)\"!qCA\u001e\u0003=\u0019X\u000f]3sI\t,gm\u001c:f\u00032d\u0017BA*;\u00039\u0019X\u000f]3sI\u00054G/\u001a:BY2L!\u0001\u0016\u001e\u0002!M,\b/\u001a:%E\u00164wN]3FC\u000eD\u0017bA+\u00038%\u0019!\u0011\b\u001d\u0003-MC\u0017M]3e'B\f'o[*fgNLwN\u001c\"bg\u0016\fqb];qKJ$\u0013M\u001a;fe\u0016\u000b7\r[\u0005\u0004-\n]\u0002")
public interface SparkConnectServerTest
extends SharedSparkSession {
    public void org$apache$spark$sql$connect$SparkConnectServerTest$_setter_$serverPort_$eq(int var1);

    public void org$apache$spark$sql$connect$SparkConnectServerTest$_setter_$eventuallyTimeout_$eq(Span var1);

    public void org$apache$spark$sql$connect$SparkConnectServerTest$_setter_$defaultSessionId_$eq(String var1);

    public void org$apache$spark$sql$connect$SparkConnectServerTest$_setter_$defaultUserId_$eq(String var1);

    public void org$apache$spark$sql$connect$SparkConnectServerTest$_setter_$dsl_$eq(package.MockRemoteSession var1);

    public void org$apache$spark$sql$connect$SparkConnectServerTest$_setter_$userContext_$eq(UserContext var1);

    public /* synthetic */ void org$apache$spark$sql$connect$SparkConnectServerTest$$super$beforeAll();

    public /* synthetic */ void org$apache$spark$sql$connect$SparkConnectServerTest$$super$afterAll();

    public /* synthetic */ void org$apache$spark$sql$connect$SparkConnectServerTest$$super$beforeEach();

    public /* synthetic */ void org$apache$spark$sql$connect$SparkConnectServerTest$$super$afterEach();

    public int serverPort();

    public Span eventuallyTimeout();

    public static /* synthetic */ void beforeAll$(SparkConnectServerTest $this) {
        $this.beforeAll();
    }

    default public void beforeAll() {
        this.org$apache$spark$sql$connect$SparkConnectServerTest$$super$beforeAll();
        SparkConnectService$.MODULE$.executionManager().shutdown();
        ((SparkFunSuite)this).withSparkEnvConfs((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)Connect$.MODULE$.CONNECT_GRPC_BINDING_PORT().key(), (Object)Integer.toString(this.serverPort()))}), (Function0)(JFunction0.mcV.sp & Serializable)() -> SparkConnectService$.MODULE$.start(this.spark().sparkContext()));
    }

    public static /* synthetic */ void afterAll$(SparkConnectServerTest $this) {
        $this.afterAll();
    }

    default public void afterAll() {
        SparkConnectService$.MODULE$.stop(SparkConnectService$.MODULE$.stop$default$1(), SparkConnectService$.MODULE$.stop$default$2());
        this.org$apache$spark$sql$connect$SparkConnectServerTest$$super$afterAll();
    }

    public static /* synthetic */ void beforeEach$(SparkConnectServerTest $this) {
        $this.beforeEach();
    }

    default public void beforeEach() {
        this.org$apache$spark$sql$connect$SparkConnectServerTest$$super$beforeEach();
        this.clearAllExecutions();
    }

    public static /* synthetic */ void afterEach$(SparkConnectServerTest $this) {
        $this.afterEach();
    }

    default public void afterEach() {
        this.clearAllExecutions();
        this.org$apache$spark$sql$connect$SparkConnectServerTest$$super$afterEach();
    }

    public static /* synthetic */ void clearAllExecutions$(SparkConnectServerTest $this) {
        $this.clearAllExecutions();
    }

    default public void clearAllExecutions() {
        SparkConnectService$.MODULE$.executionManager().listExecuteHolders().foreach((Function1 & Serializable)x$1 -> {
            x$1.close();
            return BoxedUnit.UNIT;
        });
        SparkConnectService$.MODULE$.executionManager().periodicMaintenance(0L);
        this.assertNoActiveExecutions();
    }

    public String defaultSessionId();

    public String defaultUserId();

    public package.MockRemoteSession dsl();

    public UserContext userContext();

    public static /* synthetic */ ExecutePlanRequest buildExecutePlanRequest$(SparkConnectServerTest $this, Plan plan, String sessionId, String operationId) {
        return $this.buildExecutePlanRequest(plan, sessionId, operationId);
    }

    default public ExecutePlanRequest buildExecutePlanRequest(Plan plan, String sessionId, String operationId) {
        return ExecutePlanRequest.newBuilder().setUserContext(this.userContext()).setSessionId(sessionId).setOperationId(operationId).setPlan(plan).addRequestOptions(ExecutePlanRequest.RequestOption.newBuilder().setReattachOptions(ReattachOptions.newBuilder().setReattachable(true).build()).build()).build();
    }

    public static /* synthetic */ String buildExecutePlanRequest$default$2$(SparkConnectServerTest $this) {
        return $this.buildExecutePlanRequest$default$2();
    }

    default public String buildExecutePlanRequest$default$2() {
        return this.defaultSessionId();
    }

    public static /* synthetic */ String buildExecutePlanRequest$default$3$(SparkConnectServerTest $this) {
        return $this.buildExecutePlanRequest$default$3();
    }

    default public String buildExecutePlanRequest$default$3() {
        return UUID.randomUUID().toString();
    }

    public static /* synthetic */ ReattachExecuteRequest buildReattachExecuteRequest$(SparkConnectServerTest $this, String operationId, Option responseId) {
        return $this.buildReattachExecuteRequest(operationId, (Option<String>)responseId);
    }

    default public ReattachExecuteRequest buildReattachExecuteRequest(String operationId, Option<String> responseId) {
        ReattachExecuteRequest.Builder req = ReattachExecuteRequest.newBuilder().setUserContext(this.userContext()).setSessionId(this.defaultSessionId()).setOperationId(operationId);
        Object object = responseId.isDefined() ? req.setLastResponseId((String)responseId.get()) : BoxedUnit.UNIT;
        return req.build();
    }

    public static /* synthetic */ Plan buildPlan$(SparkConnectServerTest $this, String query) {
        return $this.buildPlan(query);
    }

    default public Plan buildPlan(String query) {
        return Plan.newBuilder().setRoot(package.plans$.MODULE$.DslMockRemoteSession(this.dsl()).sql(query)).build();
    }

    public static /* synthetic */ ExecutePlanResponseReattachableIterator getReattachableIterator$(SparkConnectServerTest $this, CloseableIterator stubIterator) {
        return $this.getReattachableIterator((CloseableIterator<ExecutePlanResponse>)stubIterator);
    }

    default public ExecutePlanResponseReattachableIterator getReattachableIterator(CloseableIterator<ExecutePlanResponse> stubIterator) {
        return (ExecutePlanResponseReattachableIterator)((WrappedCloseableIterator)stubIterator).innerIterator();
    }

    public static /* synthetic */ void assertNoActiveRpcs$(SparkConnectServerTest $this) {
        $this.assertNoActiveRpcs();
    }

    default public void assertNoActiveRpcs() {
        Either either = SparkConnectService$.MODULE$.executionManager().listActiveExecutions();
        if (either instanceof Left) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (either instanceof Right) {
            Right right = (Right)either;
            Seq executions = (Seq)right.value();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(executions.forall((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)SparkConnectServerTest.$anonfun$assertNoActiveRpcs$1(x$2))), "executions.forall(((x$2: org.apache.spark.sql.connect.service.ExecuteInfo) => x$2.lastAttachedRpcTime.isDefined))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder(26).append("Expected no RPCs, but got ").append(executions).toString(), Prettifier$.MODULE$.default(), new Position("SparkConnectServerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 142));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)either);
        }
    }

    public static /* synthetic */ void assertEventuallyNoActiveRpcs$(SparkConnectServerTest $this) {
        $this.assertEventuallyNoActiveRpcs();
    }

    default public void assertEventuallyNoActiveRpcs() {
        Eventually$.MODULE$.eventually(this.timeout(this.eventuallyTimeout()), (Function0)(JFunction0.mcV.sp & Serializable)() -> this.assertNoActiveRpcs(), Eventually$.MODULE$.patienceConfig(), Retrying$.MODULE$.retryingNatureOfT(), new Position("SparkConnectServerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 149));
    }

    public static /* synthetic */ void assertNoActiveExecutions$(SparkConnectServerTest $this) {
        $this.assertNoActiveExecutions();
    }

    default public void assertNoActiveExecutions() {
        Either either = SparkConnectService$.MODULE$.executionManager().listActiveExecutions();
        if (!(either instanceof Left)) {
            if (either instanceof Right) {
                Right right = (Right)either;
                Seq executions = (Seq)right.value();
                throw ((Assertions)this).fail(new StringBuilder(24).append("Expected empty, but got ").append(executions).toString(), new Position("SparkConnectServerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 157));
            }
            throw new MatchError((Object)either);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static /* synthetic */ void assertEventuallyNoActiveExecutions$(SparkConnectServerTest $this) {
        $this.assertEventuallyNoActiveExecutions();
    }

    default public void assertEventuallyNoActiveExecutions() {
        Eventually$.MODULE$.eventually(this.timeout(this.eventuallyTimeout()), (Function0)(JFunction0.mcV.sp & Serializable)() -> this.assertNoActiveExecutions(), Eventually$.MODULE$.patienceConfig(), Retrying$.MODULE$.retryingNatureOfT(), new Position("SparkConnectServerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 162));
    }

    public static /* synthetic */ void assertExecutionReleased$(SparkConnectServerTest $this, String operationId) {
        $this.assertExecutionReleased(operationId);
    }

    default public void assertExecutionReleased(String operationId) {
        Either either = SparkConnectService$.MODULE$.executionManager().listActiveExecutions();
        if (either instanceof Left) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (either instanceof Right) {
            Right right = (Right)either;
            Seq executions = (Seq)right.value();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(executions.exists((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)SparkConnectServerTest.$anonfun$assertExecutionReleased$1(operationId, x$3))), "executions.exists(((x$3: org.apache.spark.sql.connect.service.ExecuteInfo) => x$3.operationId.==(operationId)))", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectServerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 170));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)either);
        }
    }

    public static /* synthetic */ void assertEventuallyExecutionReleased$(SparkConnectServerTest $this, String operationId) {
        $this.assertEventuallyExecutionReleased(operationId);
    }

    default public void assertEventuallyExecutionReleased(String operationId) {
        Eventually$.MODULE$.eventually(this.timeout(this.eventuallyTimeout()), (Function0)(JFunction0.mcV.sp & Serializable)() -> this.assertExecutionReleased(operationId), Eventually$.MODULE$.patienceConfig(), Retrying$.MODULE$.retryingNatureOfT(), new Position("SparkConnectServerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 175));
    }

    public static /* synthetic */ ExecuteHolder getExecutionHolder$(SparkConnectServerTest $this) {
        return $this.getExecutionHolder();
    }

    default public ExecuteHolder getExecutionHolder() {
        Seq executions;
        Seq $org_scalatest_assert_macro_left = executions = SparkConnectService$.MODULE$.executionManager().listExecuteHolders();
        int $org_scalatest_assert_macro_right = 1;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectServerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 183));
        return (ExecuteHolder)executions.head();
    }

    public static /* synthetic */ void withClient$(SparkConnectServerTest $this, Function1 f) {
        $this.withClient((Function1<SparkConnectClient, BoxedUnit>)f);
    }

    default public void withClient(Function1<SparkConnectClient, BoxedUnit> f) {
        SparkConnectClient client = SparkConnectClient$.MODULE$.builder().port(this.serverPort()).sessionId(this.defaultSessionId()).userId(this.defaultUserId()).enableReattachableExecute().build();
        try {
            f.apply((Object)client);
        }
        finally {
            client.shutdown();
        }
    }

    public static /* synthetic */ void withRawBlockingStub$(SparkConnectServerTest $this, Function1 f) {
        $this.withRawBlockingStub((Function1<SparkConnectServiceGrpc.SparkConnectServiceBlockingStub, BoxedUnit>)f);
    }

    default public void withRawBlockingStub(Function1<SparkConnectServiceGrpc.SparkConnectServiceBlockingStub, BoxedUnit> f) {
        int x$1 = this.serverPort();
        String x$2 = SparkConnectClient.Configuration$.MODULE$.apply$default$1();
        String x$3 = SparkConnectClient.Configuration$.MODULE$.apply$default$2();
        String x$4 = SparkConnectClient.Configuration$.MODULE$.apply$default$3();
        Option x$5 = SparkConnectClient.Configuration$.MODULE$.apply$default$5();
        Option x$6 = SparkConnectClient.Configuration$.MODULE$.apply$default$6();
        Map x$7 = SparkConnectClient.Configuration$.MODULE$.apply$default$7();
        String x$8 = SparkConnectClient.Configuration$.MODULE$.apply$default$8();
        GrpcRetryHandler.RetryPolicy x$9 = SparkConnectClient.Configuration$.MODULE$.apply$default$9();
        boolean x$10 = SparkConnectClient.Configuration$.MODULE$.apply$default$10();
        List x$11 = SparkConnectClient.Configuration$.MODULE$.apply$default$11();
        Option x$12 = SparkConnectClient.Configuration$.MODULE$.apply$default$12();
        SparkConnectClient.Configuration conf = new SparkConnectClient.Configuration(x$2, x$3, x$4, x$1, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12);
        ManagedChannel channel = conf.createChannel();
        SparkConnectServiceGrpc.SparkConnectServiceBlockingStub bstub = SparkConnectServiceGrpc.newBlockingStub((Channel)channel);
        try {
            f.apply((Object)bstub);
        }
        finally {
            channel.shutdownNow();
        }
    }

    public static /* synthetic */ void withCustomBlockingStub$(SparkConnectServerTest $this, GrpcRetryHandler.RetryPolicy retryPolicy, Function1 f) {
        $this.withCustomBlockingStub(retryPolicy, (Function1<CustomSparkConnectBlockingStub, BoxedUnit>)f);
    }

    default public void withCustomBlockingStub(GrpcRetryHandler.RetryPolicy retryPolicy, Function1<CustomSparkConnectBlockingStub, BoxedUnit> f) {
        int x$1 = this.serverPort();
        String x$2 = SparkConnectClient.Configuration$.MODULE$.apply$default$1();
        String x$3 = SparkConnectClient.Configuration$.MODULE$.apply$default$2();
        String x$4 = SparkConnectClient.Configuration$.MODULE$.apply$default$3();
        Option x$5 = SparkConnectClient.Configuration$.MODULE$.apply$default$5();
        Option x$6 = SparkConnectClient.Configuration$.MODULE$.apply$default$6();
        Map x$7 = SparkConnectClient.Configuration$.MODULE$.apply$default$7();
        String x$8 = SparkConnectClient.Configuration$.MODULE$.apply$default$8();
        GrpcRetryHandler.RetryPolicy x$9 = SparkConnectClient.Configuration$.MODULE$.apply$default$9();
        boolean x$10 = SparkConnectClient.Configuration$.MODULE$.apply$default$10();
        List x$11 = SparkConnectClient.Configuration$.MODULE$.apply$default$11();
        Option x$12 = SparkConnectClient.Configuration$.MODULE$.apply$default$12();
        SparkConnectClient.Configuration conf = new SparkConnectClient.Configuration(x$2, x$3, x$4, x$1, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12);
        ManagedChannel channel = conf.createChannel();
        CustomSparkConnectBlockingStub bstub = new CustomSparkConnectBlockingStub(channel, retryPolicy);
        try {
            f.apply((Object)bstub);
        }
        finally {
            channel.shutdownNow();
        }
    }

    public static /* synthetic */ GrpcRetryHandler.RetryPolicy withCustomBlockingStub$default$1$(SparkConnectServerTest $this) {
        return $this.withCustomBlockingStub$default$1();
    }

    default public GrpcRetryHandler.RetryPolicy withCustomBlockingStub$default$1() {
        return new GrpcRetryHandler.RetryPolicy(GrpcRetryHandler.RetryPolicy$.MODULE$.apply$default$1(), GrpcRetryHandler.RetryPolicy$.MODULE$.apply$default$2(), GrpcRetryHandler.RetryPolicy$.MODULE$.apply$default$3(), GrpcRetryHandler.RetryPolicy$.MODULE$.apply$default$4(), GrpcRetryHandler.RetryPolicy$.MODULE$.apply$default$5(), GrpcRetryHandler.RetryPolicy$.MODULE$.apply$default$6(), GrpcRetryHandler.RetryPolicy$.MODULE$.apply$default$7());
    }

    public static /* synthetic */ void runQuery$(SparkConnectServerTest $this, Plan plan, Span queryTimeout, long iterSleep) {
        $this.runQuery(plan, queryTimeout, iterSleep);
    }

    default public void runQuery(Plan plan, Span queryTimeout, long iterSleep) {
        this.withClient((Function1<SparkConnectClient, BoxedUnit>)(Function1 & Serializable)client -> {
            TimeLimits$.MODULE$.failAfter(queryTimeout, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                CloseableIterator iter = client.execute(plan$1);
                None$ operationId = None$.MODULE$;
                ExecutePlanResponse r = null;
                ExecutePlanResponseReattachableIterator reattachableIter = $this.getReattachableIterator((CloseableIterator<ExecutePlanResponse>)iter);
                while (iter.hasNext()) {
                    BoxedUnit boxedUnit;
                    r = (ExecutePlanResponse)iter.next();
                    None$ none$ = operationId;
                    if (None$.MODULE$.equals(none$)) {
                        operationId = new Some((Object)r.getOperationId());
                        boxedUnit = BoxedUnit.UNIT;
                    } else if (none$ instanceof Some) {
                        Some some = (Some)none$;
                        String id = (String)some.value();
                        String $org_scalatest_assert_macro_left = r.getOperationId();
                        String $org_scalatest_assert_macro_right = id;
                        String string = $org_scalatest_assert_macro_left;
                        String string2 = $org_scalatest_assert_macro_right;
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
                        boxedUnit = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectServerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 235));
                    } else {
                        throw new MatchError((Object)none$);
                    }
                    if (iterSleep$1 <= 0L) continue;
                    Thread.sleep(iterSleep$1);
                }
                ExecutePlanResponse $org_scalatest_assert_macro_left = r;
                Object $org_scalatest_assert_macro_right = null;
                ExecutePlanResponse executePlanResponse = $org_scalatest_assert_macro_left;
                Object var20_18 = null;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "!=", null, executePlanResponse == null ? var20_18 != null : !executePlanResponse.equals(var20_18), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectServerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 242));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(r.hasResultComplete(), "r.hasResultComplete()", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectServerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 243));
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(reattachableIter.resultComplete(), "reattachableIter.resultComplete", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectServerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 245));
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(operationId.isDefined(), "operationId.isDefined", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectServerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 247));
                $this.assertEventuallyExecutionReleased((String)operationId.get());
            }, Signaler$.MODULE$.default(), Prettifier$.MODULE$.default(), new Position("SparkConnectServerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 226), Timed$.MODULE$.timed());
            return BoxedUnit.UNIT;
        });
    }

    public static /* synthetic */ void runQuery$(SparkConnectServerTest $this, String query, Span queryTimeout, long iterSleep) {
        $this.runQuery(query, queryTimeout, iterSleep);
    }

    default public void runQuery(String query, Span queryTimeout, long iterSleep) {
        Plan plan = this.buildPlan(query);
        this.runQuery(plan, queryTimeout, iterSleep);
    }

    public static /* synthetic */ long runQuery$default$3$(SparkConnectServerTest $this) {
        return $this.runQuery$default$3();
    }

    default public long runQuery$default$3() {
        return 0L;
    }

    public static /* synthetic */ boolean $anonfun$assertNoActiveRpcs$1(ExecuteInfo x$2) {
        return x$2.lastAttachedRpcTime().isDefined();
    }

    public static /* synthetic */ boolean $anonfun$assertExecutionReleased$1(String operationId$1, ExecuteInfo x$3) {
        String string = x$3.operationId();
        String string2 = operationId$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static void $init$(SparkConnectServerTest $this) {
        $this.org$apache$spark$sql$connect$SparkConnectServerTest$_setter_$serverPort_$eq(ConnectCommon$.MODULE$.CONNECT_GRPC_BINDING_PORT() + Random$.MODULE$.nextInt(1000));
        $this.org$apache$spark$sql$connect$SparkConnectServerTest$_setter_$eventuallyTimeout_$eq(SpanSugar$.MODULE$.convertIntToGrainOfTime(30).seconds());
        $this.org$apache$spark$sql$connect$SparkConnectServerTest$_setter_$defaultSessionId_$eq(UUID.randomUUID().toString());
        $this.org$apache$spark$sql$connect$SparkConnectServerTest$_setter_$defaultUserId_$eq(UUID.randomUUID().toString());
        $this.org$apache$spark$sql$connect$SparkConnectServerTest$_setter_$dsl_$eq(new package.MockRemoteSession());
        $this.org$apache$spark$sql$connect$SparkConnectServerTest$_setter_$userContext_$eq(UserContext.newBuilder().setUserId($this.defaultUserId()).build());
    }
}

