/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connect.artifact;

import java.io.File;
import java.io.Serializable;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.ZoneId;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkException;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.AliasHelper;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeMap;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.PredicateHelper;
import org.apache.spark.sql.catalyst.plans.PlanTestBase;
import org.apache.spark.sql.catalyst.plans.SQLHelper;
import org.apache.spark.sql.catalyst.plans.logical.Aggregate;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.connect.ResourceHelper;
import org.apache.spark.sql.connect.artifact.ArtifactManagerSuite$;
import org.apache.spark.sql.connect.artifact.SparkConnectArtifactManager;
import org.apache.spark.sql.connect.artifact.SparkConnectArtifactManager$;
import org.apache.spark.sql.connect.service.SessionHolder;
import org.apache.spark.sql.connect.service.SparkConnectService$;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.test.SQLTestData;
import org.apache.spark.sql.test.SQLTestData$internalImplicits$;
import org.apache.spark.sql.test.SQLTestUtils;
import org.apache.spark.sql.test.SQLTestUtilsBase;
import org.apache.spark.sql.test.SQLTestUtilsBase$testImplicits$;
import org.apache.spark.sql.test.SharedSparkSession;
import org.apache.spark.sql.test.SharedSparkSessionBase;
import org.apache.spark.sql.test.TestSparkSession;
import org.apache.spark.storage.BlockData;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BlockManager;
import org.apache.spark.storage.CacheId;
import org.apache.spark.util.Utils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import org.scalatest.concurrent.AbstractPatienceConfiguration;
import org.scalatest.concurrent.AbstractPatienceConfiguration$PatienceConfig$;
import org.scalatest.concurrent.Eventually;
import org.scalatest.concurrent.PatienceConfiguration;
import org.scalatest.concurrent.ScaledTimeSpans;
import org.scalatest.enablers.Retrying;
import org.scalatest.time.Span;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005y3A!\u0003\u0006\u0001/!)a\u0005\u0001C\u0001O!)!\u0006\u0001C)W!9q\u0006\u0001b\u0001\n\u0013\u0001\u0004BB\u001e\u0001A\u0003%\u0011\u0007C\u0003=\u0001\u0011%Q\b\u0003\u0005E\u0001!\u0015\r\u0011\"\u0003F\u0011\u0015I\u0005\u0001\"\u0003K\u0011\u0015A\u0006\u0001\"\u0011Z\u0005Q\t%\u000f^5gC\u000e$X*\u00198bO\u0016\u00148+^5uK*\u00111\u0002D\u0001\tCJ$\u0018NZ1di*\u0011QBD\u0001\bG>tg.Z2u\u0015\ty\u0001#A\u0002tc2T!!\u0005\n\u0002\u000bM\u0004\u0018M]6\u000b\u0005M!\u0012AB1qC\u000eDWMC\u0001\u0016\u0003\ry'oZ\u0002\u0001'\u0011\u0001\u0001\u0004\b\u0012\u0011\u0005eQR\"\u0001\t\n\u0005m\u0001\"!D*qCJ\\g)\u001e8Tk&$X\r\u0005\u0002\u001eA5\taD\u0003\u0002 \u001d\u0005!A/Z:u\u0013\t\tcD\u0001\nTQ\u0006\u0014X\rZ*qCJ\\7+Z:tS>t\u0007CA\u0012%\u001b\u0005a\u0011BA\u0013\r\u00059\u0011Vm]8ve\u000e,\u0007*\u001a7qKJ\fa\u0001P5oSRtD#\u0001\u0015\u0011\u0005%\u0002Q\"\u0001\u0006\u0002\u0013M\u0004\u0018M]6D_:4W#\u0001\u0017\u0011\u0005ei\u0013B\u0001\u0018\u0011\u0005%\u0019\u0006/\u0019:l\u0007>tg-\u0001\u0007beRLg-Y2u!\u0006$\b.F\u00012!\t\u0011\u0014(D\u00014\u0015\t!T'\u0001\u0003gS2,'B\u0001\u001c8\u0003\rq\u0017n\u001c\u0006\u0002q\u0005!!.\u0019<b\u0013\tQ4G\u0001\u0003QCRD\u0017!D1si&4\u0017m\u0019;QCRD\u0007%A\u0007tKN\u001c\u0018n\u001c8I_2$WM\u001d\u000b\u0002}A\u0011qHQ\u0007\u0002\u0001*\u0011\u0011\tD\u0001\bg\u0016\u0014h/[2f\u0013\t\u0019\u0005IA\u0007TKN\u001c\u0018n\u001c8I_2$WM]\u0001\u0010CJ$\u0018NZ1di6\u000bg.Y4feV\ta\t\u0005\u0002*\u000f&\u0011\u0001J\u0003\u0002\u001c'B\f'o[\"p]:,7\r^!si&4\u0017m\u0019;NC:\fw-\u001a:\u0002\u0017M,7o]5p]V+\u0016\nR\u000b\u0002\u0017B\u0011A*\u0016\b\u0003\u001bN\u0003\"AT)\u000e\u0003=S!\u0001\u0015\f\u0002\rq\u0012xn\u001c;?\u0015\u0005\u0011\u0016!B:dC2\f\u0017B\u0001+R\u0003\u0019\u0001&/\u001a3fM&\u0011ak\u0016\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005Q\u000b\u0016!C1gi\u0016\u0014X)Y2i)\u0005Q\u0006CA.]\u001b\u0005\t\u0016BA/R\u0005\u0011)f.\u001b;")
public class ArtifactManagerSuite
extends SparkFunSuite
implements SharedSparkSession,
ResourceHelper {
    private SparkConnectArtifactManager artifactManager;
    private final Path artifactPath;
    private Path baseResourcePath;
    private Path commonResourcePath;
    private boolean enableAutoThreadAudit;
    private TestSparkSession org$apache$spark$sql$test$SharedSparkSessionBase$$_spark;
    private boolean org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests;
    private Function1<String, Dataset<Row>> sql;
    private volatile SQLTestUtilsBase$testImplicits$ testImplicits$module;
    private String sparkHome;
    private volatile SQLTestData$internalImplicits$ internalImplicits$module;
    private Dataset<Row> emptyTestData;
    private Dataset<Row> testData;
    private Dataset<Row> testData2;
    private Dataset<Row> testData3;
    private Dataset<Row> negativeData;
    private Dataset<Row> largeAndSmallInts;
    private Dataset<Row> decimalData;
    private Dataset<Row> binaryData;
    private Dataset<Row> upperCaseData;
    private Dataset<Row> lowerCaseData;
    private Dataset<Row> lowerCaseDataWithDuplicates;
    private RDD<SQLTestData.ArrayData> arrayData;
    private RDD<SQLTestData.MapData> mapData;
    private RDD<SQLTestData.IntervalData> calendarIntervalData;
    private RDD<SQLTestData.StringData> repeatedData;
    private RDD<SQLTestData.StringData> nullableRepeatedData;
    private Dataset<Row> nullInts;
    private Dataset<Row> allNulls;
    private Dataset<Row> nullStrings;
    private Dataset<Row> tableName;
    private RDD<String> unparsedStrings;
    private RDD<SQLTestData.IntField> withEmptyParts;
    private Dataset<Row> person;
    private Dataset<Row> salary;
    private Dataset<Row> complexData;
    private Dataset<Row> courseSales;
    private Dataset<Row> trainingSales;
    private Dataset<Row> intervalData;
    private AbstractPatienceConfiguration.PatienceConfig org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig;
    private volatile AbstractPatienceConfiguration$PatienceConfig$ PatienceConfig$module;
    private volatile int bitmap$0;

    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSession$$super$beforeAll() {
        SharedSparkSessionBase.beforeAll$((SharedSparkSessionBase)this);
    }

    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSession$$super$afterAll() {
        SharedSparkSessionBase.afterAll$((SharedSparkSessionBase)this);
    }

    public void beforeAll() {
        SharedSparkSession.beforeAll$((SharedSparkSession)this);
    }

    public void afterAll() {
        SharedSparkSession.afterAll$((SharedSparkSession)this);
    }

    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSessionBase$$super$beforeAll() {
        SQLTestUtils.beforeAll$((SQLTestUtils)this);
    }

    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSessionBase$$super$afterAll() {
        super.afterAll();
    }

    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSessionBase$$super$beforeEach() {
        BeforeAndAfterEach.beforeEach$((BeforeAndAfterEach)this);
    }

    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSessionBase$$super$afterEach() {
        BeforeAndAfterEach.afterEach$((BeforeAndAfterEach)this);
    }

    public SparkSession spark() {
        return SharedSparkSessionBase.spark$((SharedSparkSessionBase)this);
    }

    public SQLContext sqlContext() {
        return SharedSparkSessionBase.sqlContext$((SharedSparkSessionBase)this);
    }

    public TestSparkSession createSparkSession() {
        return SharedSparkSessionBase.createSparkSession$((SharedSparkSessionBase)this);
    }

    public void initializeSession() {
        SharedSparkSessionBase.initializeSession$((SharedSparkSessionBase)this);
    }

    public void beforeEach() {
        SharedSparkSessionBase.beforeEach$((SharedSparkSessionBase)this);
    }

    public /* synthetic */ void org$apache$spark$sql$test$SQLTestUtils$$super$beforeAll() {
        super.beforeAll();
    }

    public /* synthetic */ void org$apache$spark$sql$test$SQLTestUtils$$super$withTempDir(Function1 f) {
        super.withTempDir(f);
    }

    public /* synthetic */ void org$apache$spark$sql$test$SQLTestUtils$$super$test(String testName, Seq testTags, Function0 testBody, Position pos) {
        super.test(testName, testTags, testBody, pos);
    }

    public void withTempDir(Function1<File, BoxedUnit> f) {
        SQLTestUtils.withTempDir$((SQLTestUtils)this, f);
    }

    public void testWithWholeStageCodegenOnAndOff(String testName, Function1<String, BoxedUnit> f) {
        SQLTestUtils.testWithWholeStageCodegenOnAndOff$((SQLTestUtils)this, (String)testName, f);
    }

    public void setupTestData() {
        SQLTestUtils.setupTestData$((SQLTestUtils)this);
    }

    public void testQuietly(String name, Function0<BoxedUnit> f) {
        SQLTestUtils.testQuietly$((SQLTestUtils)this, (String)name, f);
    }

    public void test(String testName, Seq<Tag> testTags, Function0<Object> testFun, Position pos) {
        SQLTestUtils.test$((SQLTestUtils)this, (String)testName, testTags, testFun, (Position)pos);
    }

    public void testWithUninterruptibleThread(String name, boolean quietly, Function0<BoxedUnit> body) {
        SQLTestUtils.testWithUninterruptibleThread$((SQLTestUtils)this, (String)name, (boolean)quietly, body);
    }

    public boolean testWithUninterruptibleThread$default$2() {
        return SQLTestUtils.testWithUninterruptibleThread$default$2$((SQLTestUtils)this);
    }

    public void withResourceTempPath(String resourcePath, Function1<File, BoxedUnit> f) {
        SQLTestUtils.withResourceTempPath$((SQLTestUtils)this, (String)resourcePath, f);
    }

    public void waitForTasksToFinish() {
        SQLTestUtils.waitForTasksToFinish$((SQLTestUtils)this);
    }

    public void withTempPaths(int numPaths, Function1<Seq<File>, BoxedUnit> f) {
        SQLTestUtils.withTempPaths$((SQLTestUtils)this, (int)numPaths, f);
    }

    public /* synthetic */ void org$apache$spark$sql$test$SQLTestUtilsBase$$super$withSQLConf(Seq pairs, Function0 f) {
        SQLHelper.withSQLConf$((SQLHelper)this, (Seq)pairs, (Function0)f);
    }

    public SparkContext sparkContext() {
        return SQLTestUtilsBase.sparkContext$((SQLTestUtilsBase)this);
    }

    public void withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withSQLConf$((SQLTestUtilsBase)this, pairs, f);
    }

    public void withUserDefinedFunction(Seq<Tuple2<String, Object>> functions, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withUserDefinedFunction$((SQLTestUtilsBase)this, functions, f);
    }

    public void withTempView(Seq<String> viewNames, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withTempView$((SQLTestUtilsBase)this, viewNames, f);
    }

    public void withGlobalTempView(Seq<String> viewNames, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withGlobalTempView$((SQLTestUtilsBase)this, viewNames, f);
    }

    public void withTable(Seq<String> tableNames, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withTable$((SQLTestUtilsBase)this, tableNames, f);
    }

    public void withView(Seq<String> viewNames, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withView$((SQLTestUtilsBase)this, viewNames, f);
    }

    public void withCache(Seq<String> cacheNames, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withCache$((SQLTestUtilsBase)this, cacheNames, f);
    }

    public void uncacheTable(String tableName) {
        SQLTestUtilsBase.uncacheTable$((SQLTestUtilsBase)this, (String)tableName);
    }

    public void withTempDatabase(Function1<String, BoxedUnit> f) {
        SQLTestUtilsBase.withTempDatabase$((SQLTestUtilsBase)this, f);
    }

    public void withDatabase(Seq<String> dbNames, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withDatabase$((SQLTestUtilsBase)this, dbNames, f);
    }

    public void withNamespace(Seq<String> namespaces, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withNamespace$((SQLTestUtilsBase)this, namespaces, f);
    }

    public void withCurrentCatalogAndNamespace(Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withCurrentCatalogAndNamespace$((SQLTestUtilsBase)this, f);
    }

    public void withLocale(String language, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withLocale$((SQLTestUtilsBase)this, (String)language, f);
    }

    public void activateDatabase(String db, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.activateDatabase$((SQLTestUtilsBase)this, (String)db, f);
    }

    public Dataset<Row> stripSparkFilter(Dataset<Row> df) {
        return SQLTestUtilsBase.stripSparkFilter$((SQLTestUtilsBase)this, df);
    }

    public Dataset<Row> logicalPlanToSparkQuery(LogicalPlan plan) {
        return SQLTestUtilsBase.logicalPlanToSparkQuery$((SQLTestUtilsBase)this, (LogicalPlan)plan);
    }

    public URI makeQualifiedPath(String path) {
        return SQLTestUtilsBase.makeQualifiedPath$((SQLTestUtilsBase)this, (String)path);
    }

    public String testFile(String fileName) {
        return SQLTestUtilsBase.testFile$((SQLTestUtilsBase)this, (String)fileName);
    }

    public long getLocalDirSize(File file) {
        return SQLTestUtilsBase.getLocalDirSize$((SQLTestUtilsBase)this, (File)file);
    }

    public LogicalPlan normalizeExprIds(LogicalPlan plan) {
        return PlanTestBase.normalizeExprIds$((PlanTestBase)this, (LogicalPlan)plan);
    }

    public LogicalPlan rewriteNameFromAttrNullability(LogicalPlan plan) {
        return PlanTestBase.rewriteNameFromAttrNullability$((PlanTestBase)this, (LogicalPlan)plan);
    }

    public LogicalPlan normalizePlan(LogicalPlan plan) {
        return PlanTestBase.normalizePlan$((PlanTestBase)this, (LogicalPlan)plan);
    }

    public void comparePlans(LogicalPlan plan1, LogicalPlan plan2, boolean checkAnalysis) {
        PlanTestBase.comparePlans$((PlanTestBase)this, (LogicalPlan)plan1, (LogicalPlan)plan2, (boolean)checkAnalysis);
    }

    public boolean comparePlans$default$3() {
        return PlanTestBase.comparePlans$default$3$((PlanTestBase)this);
    }

    public void compareExpressions(Expression e1, Expression e2) {
        PlanTestBase.compareExpressions$((PlanTestBase)this, (Expression)e1, (Expression)e2);
    }

    public SQLConf conf() {
        return SQLConfHelper.conf$((SQLConfHelper)this);
    }

    public void withTempPath(Function1<File, BoxedUnit> f) {
        SQLHelper.withTempPath$((SQLHelper)this, f);
    }

    public <T> void testSpecialDatetimeValues(Function1<ZoneId, T> test) {
        SQLHelper.testSpecialDatetimeValues$((SQLHelper)this, test);
    }

    public Seq<Expression> splitConjunctivePredicates(Expression condition) {
        return PredicateHelper.splitConjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Option<Tuple2<Expression, LogicalPlan>> findExpressionAndTrackLineageDown(Expression exp, LogicalPlan plan) {
        return PredicateHelper.findExpressionAndTrackLineageDown$((PredicateHelper)this, (Expression)exp, (LogicalPlan)plan);
    }

    public Seq<Expression> splitDisjunctivePredicates(Expression condition) {
        return PredicateHelper.splitDisjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Expression buildBalancedPredicate(Seq<Expression> expressions, Function2<Expression, Expression, Expression> op) {
        return PredicateHelper.buildBalancedPredicate$((PredicateHelper)this, expressions, op);
    }

    public boolean canEvaluate(Expression expr, LogicalPlan plan) {
        return PredicateHelper.canEvaluate$((PredicateHelper)this, (Expression)expr, (LogicalPlan)plan);
    }

    public boolean canEvaluateWithinJoin(Expression expr) {
        return PredicateHelper.canEvaluateWithinJoin$((PredicateHelper)this, (Expression)expr);
    }

    public Option<Expression> extractPredicatesWithinOutputSet(Expression condition, AttributeSet outputSet) {
        return PredicateHelper.extractPredicatesWithinOutputSet$((PredicateHelper)this, (Expression)condition, (AttributeSet)outputSet);
    }

    public boolean isNullIntolerant(Expression expr) {
        return PredicateHelper.isNullIntolerant$((PredicateHelper)this, (Expression)expr);
    }

    public Seq<Attribute> outputWithNullability(Seq<Attribute> output, Seq<ExprId> nonNullAttrExprIds) {
        return PredicateHelper.outputWithNullability$((PredicateHelper)this, output, nonNullAttrExprIds);
    }

    public boolean isLikelySelective(Expression e) {
        return PredicateHelper.isLikelySelective$((PredicateHelper)this, (Expression)e);
    }

    public AttributeMap<Alias> getAliasMap(Project plan) {
        return AliasHelper.getAliasMap$((AliasHelper)this, (Project)plan);
    }

    public AttributeMap<Alias> getAliasMap(Aggregate plan) {
        return AliasHelper.getAliasMap$((AliasHelper)this, (Aggregate)plan);
    }

    public AttributeMap<Alias> getAliasMap(Seq<NamedExpression> exprs) {
        return AliasHelper.getAliasMap$((AliasHelper)this, exprs);
    }

    public Expression replaceAlias(Expression expr, AttributeMap<Alias> aliasMap) {
        return AliasHelper.replaceAlias$((AliasHelper)this, (Expression)expr, aliasMap);
    }

    public NamedExpression replaceAliasButKeepName(NamedExpression expr, AttributeMap<Alias> aliasMap) {
        return AliasHelper.replaceAliasButKeepName$((AliasHelper)this, (NamedExpression)expr, aliasMap);
    }

    public Expression trimAliases(Expression e) {
        return AliasHelper.trimAliases$((AliasHelper)this, (Expression)e);
    }

    public <T extends Expression> T trimNonTopLevelAliases(T e) {
        return (T)AliasHelper.trimNonTopLevelAliases$((AliasHelper)this, e);
    }

    public void loadTestData() {
        SQLTestData.loadTestData$((SQLTestData)this);
    }

    public <T> T eventually(PatienceConfiguration.Timeout timeout, PatienceConfiguration.Interval interval, Function0<T> fun, Retrying<T> retrying, Position pos) {
        return (T)Eventually.eventually$((Eventually)this, (PatienceConfiguration.Timeout)timeout, (PatienceConfiguration.Interval)interval, fun, retrying, (Position)pos);
    }

    public <T> T eventually(PatienceConfiguration.Timeout timeout, Function0<T> fun, AbstractPatienceConfiguration.PatienceConfig config, Retrying<T> retrying, Position pos) {
        return (T)Eventually.eventually$((Eventually)this, (PatienceConfiguration.Timeout)timeout, fun, (AbstractPatienceConfiguration.PatienceConfig)config, retrying, (Position)pos);
    }

    public <T> T eventually(PatienceConfiguration.Interval interval, Function0<T> fun, AbstractPatienceConfiguration.PatienceConfig config, Retrying<T> retrying, Position pos) {
        return (T)Eventually.eventually$((Eventually)this, (PatienceConfiguration.Interval)interval, fun, (AbstractPatienceConfiguration.PatienceConfig)config, retrying, (Position)pos);
    }

    public <T> T eventually(Function0<T> fun, AbstractPatienceConfiguration.PatienceConfig config, Retrying<T> retrying, Position pos) {
        return (T)Eventually.eventually$((Eventually)this, fun, (AbstractPatienceConfiguration.PatienceConfig)config, retrying, (Position)pos);
    }

    public AbstractPatienceConfiguration.PatienceConfig patienceConfig() {
        return PatienceConfiguration.patienceConfig$((PatienceConfiguration)this);
    }

    public PatienceConfiguration.Timeout timeout(Span value) {
        return PatienceConfiguration.timeout$((PatienceConfiguration)this, (Span)value);
    }

    public PatienceConfiguration.Interval interval(Span value) {
        return PatienceConfiguration.interval$((PatienceConfiguration)this, (Span)value);
    }

    public final Span scaled(Span span) {
        return ScaledTimeSpans.scaled$((ScaledTimeSpans)this, (Span)span);
    }

    public double spanScaleFactor() {
        return ScaledTimeSpans.spanScaleFactor$((ScaledTimeSpans)this);
    }

    @Override
    public Path baseResourcePath() {
        return this.baseResourcePath;
    }

    @Override
    public Path commonResourcePath() {
        return this.commonResourcePath;
    }

    @Override
    public void org$apache$spark$sql$connect$ResourceHelper$_setter_$baseResourcePath_$eq(Path x$1) {
        this.baseResourcePath = x$1;
    }

    @Override
    public void org$apache$spark$sql$connect$ResourceHelper$_setter_$commonResourcePath_$eq(Path x$1) {
        this.commonResourcePath = x$1;
    }

    public boolean enableAutoThreadAudit() {
        return this.enableAutoThreadAudit;
    }

    public void org$apache$spark$sql$test$SharedSparkSession$_setter_$enableAutoThreadAudit_$eq(boolean x$1) {
        this.enableAutoThreadAudit = x$1;
    }

    public TestSparkSession org$apache$spark$sql$test$SharedSparkSessionBase$$_spark() {
        return this.org$apache$spark$sql$test$SharedSparkSessionBase$$_spark;
    }

    public void org$apache$spark$sql$test$SharedSparkSessionBase$$_spark_$eq(TestSparkSession x$1) {
        this.org$apache$spark$sql$test$SharedSparkSessionBase$$_spark = x$1;
    }

    public boolean org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests() {
        return this.org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests;
    }

    public void org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests_$eq(boolean x$1) {
        this.org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests = x$1;
    }

    private Function1<String, Dataset<Row>> sql$lzycompute() {
        ArtifactManagerSuite artifactManagerSuite = this;
        synchronized (artifactManagerSuite) {
            if ((this.bitmap$0 & 2) == 0) {
                this.sql = SQLTestUtilsBase.sql$((SQLTestUtilsBase)this);
                this.bitmap$0 |= 2;
            }
        }
        return this.sql;
    }

    public Function1<String, Dataset<Row>> sql() {
        return (this.bitmap$0 & 2) == 0 ? this.sql$lzycompute() : this.sql;
    }

    public SQLTestUtilsBase$testImplicits$ testImplicits() {
        if (this.testImplicits$module == null) {
            this.testImplicits$lzycompute$1();
        }
        return this.testImplicits$module;
    }

    private String sparkHome$lzycompute() {
        ArtifactManagerSuite artifactManagerSuite = this;
        synchronized (artifactManagerSuite) {
            if ((this.bitmap$0 & 4) == 0) {
                this.sparkHome = SQLHelper.sparkHome$((SQLHelper)this);
                this.bitmap$0 |= 4;
            }
        }
        return this.sparkHome;
    }

    public String sparkHome() {
        return (this.bitmap$0 & 4) == 0 ? this.sparkHome$lzycompute() : this.sparkHome;
    }

    public SQLTestData$internalImplicits$ org$apache$spark$sql$test$SQLTestData$$internalImplicits() {
        if (this.internalImplicits$module == null) {
            this.org$apache$spark$sql$test$SQLTestData$$internalImplicits$lzycompute$1();
        }
        return this.internalImplicits$module;
    }

    private Dataset<Row> emptyTestData$lzycompute() {
        ArtifactManagerSuite artifactManagerSuite = this;
        synchronized (artifactManagerSuite) {
            if ((this.bitmap$0 & 8) == 0) {
                this.emptyTestData = SQLTestData.emptyTestData$((SQLTestData)this);
                this.bitmap$0 |= 8;
            }
        }
        return this.emptyTestData;
    }

    public Dataset<Row> emptyTestData() {
        return (this.bitmap$0 & 8) == 0 ? this.emptyTestData$lzycompute() : this.emptyTestData;
    }

    private Dataset<Row> testData$lzycompute() {
        ArtifactManagerSuite artifactManagerSuite = this;
        synchronized (artifactManagerSuite) {
            if ((this.bitmap$0 & 0x10) == 0) {
                this.testData = SQLTestData.testData$((SQLTestData)this);
                this.bitmap$0 |= 0x10;
            }
        }
        return this.testData;
    }

    public Dataset<Row> testData() {
        return (this.bitmap$0 & 0x10) == 0 ? this.testData$lzycompute() : this.testData;
    }

    private Dataset<Row> testData2$lzycompute() {
        ArtifactManagerSuite artifactManagerSuite = this;
        synchronized (artifactManagerSuite) {
            if ((this.bitmap$0 & 0x20) == 0) {
                this.testData2 = SQLTestData.testData2$((SQLTestData)this);
                this.bitmap$0 |= 0x20;
            }
        }
        return this.testData2;
    }

    public Dataset<Row> testData2() {
        return (this.bitmap$0 & 0x20) == 0 ? this.testData2$lzycompute() : this.testData2;
    }

    private Dataset<Row> testData3$lzycompute() {
        ArtifactManagerSuite artifactManagerSuite = this;
        synchronized (artifactManagerSuite) {
            if ((this.bitmap$0 & 0x40) == 0) {
                this.testData3 = SQLTestData.testData3$((SQLTestData)this);
                this.bitmap$0 |= 0x40;
            }
        }
        return this.testData3;
    }

    public Dataset<Row> testData3() {
        return (this.bitmap$0 & 0x40) == 0 ? this.testData3$lzycompute() : this.testData3;
    }

    private Dataset<Row> negativeData$lzycompute() {
        ArtifactManagerSuite artifactManagerSuite = this;
        synchronized (artifactManagerSuite) {
            if ((this.bitmap$0 & 0x80) == 0) {
                this.negativeData = SQLTestData.negativeData$((SQLTestData)this);
                this.bitmap$0 |= 0x80;
            }
        }
        return this.negativeData;
    }

    public Dataset<Row> negativeData() {
        return (this.bitmap$0 & 0x80) == 0 ? this.negativeData$lzycompute() : this.negativeData;
    }

    private Dataset<Row> largeAndSmallInts$lzycompute() {
        ArtifactManagerSuite artifactManagerSuite = this;
        synchronized (artifactManagerSuite) {
            if ((this.bitmap$0 & 0x100) == 0) {
                this.largeAndSmallInts = SQLTestData.largeAndSmallInts$((SQLTestData)this);
                this.bitmap$0 |= 0x100;
            }
        }
        return this.largeAndSmallInts;
    }

    public Dataset<Row> largeAndSmallInts() {
        return (this.bitmap$0 & 0x100) == 0 ? this.largeAndSmallInts$lzycompute() : this.largeAndSmallInts;
    }

    private Dataset<Row> decimalData$lzycompute() {
        ArtifactManagerSuite artifactManagerSuite = this;
        synchronized (artifactManagerSuite) {
            if ((this.bitmap$0 & 0x200) == 0) {
                this.decimalData = SQLTestData.decimalData$((SQLTestData)this);
                this.bitmap$0 |= 0x200;
            }
        }
        return this.decimalData;
    }

    public Dataset<Row> decimalData() {
        return (this.bitmap$0 & 0x200) == 0 ? this.decimalData$lzycompute() : this.decimalData;
    }

    private Dataset<Row> binaryData$lzycompute() {
        ArtifactManagerSuite artifactManagerSuite = this;
        synchronized (artifactManagerSuite) {
            if ((this.bitmap$0 & 0x400) == 0) {
                this.binaryData = SQLTestData.binaryData$((SQLTestData)this);
                this.bitmap$0 |= 0x400;
            }
        }
        return this.binaryData;
    }

    public Dataset<Row> binaryData() {
        return (this.bitmap$0 & 0x400) == 0 ? this.binaryData$lzycompute() : this.binaryData;
    }

    private Dataset<Row> upperCaseData$lzycompute() {
        ArtifactManagerSuite artifactManagerSuite = this;
        synchronized (artifactManagerSuite) {
            if ((this.bitmap$0 & 0x800) == 0) {
                this.upperCaseData = SQLTestData.upperCaseData$((SQLTestData)this);
                this.bitmap$0 |= 0x800;
            }
        }
        return this.upperCaseData;
    }

    public Dataset<Row> upperCaseData() {
        return (this.bitmap$0 & 0x800) == 0 ? this.upperCaseData$lzycompute() : this.upperCaseData;
    }

    private Dataset<Row> lowerCaseData$lzycompute() {
        ArtifactManagerSuite artifactManagerSuite = this;
        synchronized (artifactManagerSuite) {
            if ((this.bitmap$0 & 0x1000) == 0) {
                this.lowerCaseData = SQLTestData.lowerCaseData$((SQLTestData)this);
                this.bitmap$0 |= 0x1000;
            }
        }
        return this.lowerCaseData;
    }

    public Dataset<Row> lowerCaseData() {
        return (this.bitmap$0 & 0x1000) == 0 ? this.lowerCaseData$lzycompute() : this.lowerCaseData;
    }

    private Dataset<Row> lowerCaseDataWithDuplicates$lzycompute() {
        ArtifactManagerSuite artifactManagerSuite = this;
        synchronized (artifactManagerSuite) {
            if ((this.bitmap$0 & 0x2000) == 0) {
                this.lowerCaseDataWithDuplicates = SQLTestData.lowerCaseDataWithDuplicates$((SQLTestData)this);
                this.bitmap$0 |= 0x2000;
            }
        }
        return this.lowerCaseDataWithDuplicates;
    }

    public Dataset<Row> lowerCaseDataWithDuplicates() {
        return (this.bitmap$0 & 0x2000) == 0 ? this.lowerCaseDataWithDuplicates$lzycompute() : this.lowerCaseDataWithDuplicates;
    }

    private RDD<SQLTestData.ArrayData> arrayData$lzycompute() {
        ArtifactManagerSuite artifactManagerSuite = this;
        synchronized (artifactManagerSuite) {
            if ((this.bitmap$0 & 0x4000) == 0) {
                this.arrayData = SQLTestData.arrayData$((SQLTestData)this);
                this.bitmap$0 |= 0x4000;
            }
        }
        return this.arrayData;
    }

    public RDD<SQLTestData.ArrayData> arrayData() {
        return (this.bitmap$0 & 0x4000) == 0 ? this.arrayData$lzycompute() : this.arrayData;
    }

    private RDD<SQLTestData.MapData> mapData$lzycompute() {
        ArtifactManagerSuite artifactManagerSuite = this;
        synchronized (artifactManagerSuite) {
            if ((this.bitmap$0 & 0x8000) == 0) {
                this.mapData = SQLTestData.mapData$((SQLTestData)this);
                this.bitmap$0 |= 0x8000;
            }
        }
        return this.mapData;
    }

    public RDD<SQLTestData.MapData> mapData() {
        return (this.bitmap$0 & 0x8000) == 0 ? this.mapData$lzycompute() : this.mapData;
    }

    private RDD<SQLTestData.IntervalData> calendarIntervalData$lzycompute() {
        ArtifactManagerSuite artifactManagerSuite = this;
        synchronized (artifactManagerSuite) {
            if ((this.bitmap$0 & 0x10000) == 0) {
                this.calendarIntervalData = SQLTestData.calendarIntervalData$((SQLTestData)this);
                this.bitmap$0 |= 0x10000;
            }
        }
        return this.calendarIntervalData;
    }

    public RDD<SQLTestData.IntervalData> calendarIntervalData() {
        return (this.bitmap$0 & 0x10000) == 0 ? this.calendarIntervalData$lzycompute() : this.calendarIntervalData;
    }

    private RDD<SQLTestData.StringData> repeatedData$lzycompute() {
        ArtifactManagerSuite artifactManagerSuite = this;
        synchronized (artifactManagerSuite) {
            if ((this.bitmap$0 & 0x20000) == 0) {
                this.repeatedData = SQLTestData.repeatedData$((SQLTestData)this);
                this.bitmap$0 |= 0x20000;
            }
        }
        return this.repeatedData;
    }

    public RDD<SQLTestData.StringData> repeatedData() {
        return (this.bitmap$0 & 0x20000) == 0 ? this.repeatedData$lzycompute() : this.repeatedData;
    }

    private RDD<SQLTestData.StringData> nullableRepeatedData$lzycompute() {
        ArtifactManagerSuite artifactManagerSuite = this;
        synchronized (artifactManagerSuite) {
            if ((this.bitmap$0 & 0x40000) == 0) {
                this.nullableRepeatedData = SQLTestData.nullableRepeatedData$((SQLTestData)this);
                this.bitmap$0 |= 0x40000;
            }
        }
        return this.nullableRepeatedData;
    }

    public RDD<SQLTestData.StringData> nullableRepeatedData() {
        return (this.bitmap$0 & 0x40000) == 0 ? this.nullableRepeatedData$lzycompute() : this.nullableRepeatedData;
    }

    private Dataset<Row> nullInts$lzycompute() {
        ArtifactManagerSuite artifactManagerSuite = this;
        synchronized (artifactManagerSuite) {
            if ((this.bitmap$0 & 0x80000) == 0) {
                this.nullInts = SQLTestData.nullInts$((SQLTestData)this);
                this.bitmap$0 |= 0x80000;
            }
        }
        return this.nullInts;
    }

    public Dataset<Row> nullInts() {
        return (this.bitmap$0 & 0x80000) == 0 ? this.nullInts$lzycompute() : this.nullInts;
    }

    private Dataset<Row> allNulls$lzycompute() {
        ArtifactManagerSuite artifactManagerSuite = this;
        synchronized (artifactManagerSuite) {
            if ((this.bitmap$0 & 0x100000) == 0) {
                this.allNulls = SQLTestData.allNulls$((SQLTestData)this);
                this.bitmap$0 |= 0x100000;
            }
        }
        return this.allNulls;
    }

    public Dataset<Row> allNulls() {
        return (this.bitmap$0 & 0x100000) == 0 ? this.allNulls$lzycompute() : this.allNulls;
    }

    private Dataset<Row> nullStrings$lzycompute() {
        ArtifactManagerSuite artifactManagerSuite = this;
        synchronized (artifactManagerSuite) {
            if ((this.bitmap$0 & 0x200000) == 0) {
                this.nullStrings = SQLTestData.nullStrings$((SQLTestData)this);
                this.bitmap$0 |= 0x200000;
            }
        }
        return this.nullStrings;
    }

    public Dataset<Row> nullStrings() {
        return (this.bitmap$0 & 0x200000) == 0 ? this.nullStrings$lzycompute() : this.nullStrings;
    }

    private Dataset<Row> tableName$lzycompute() {
        ArtifactManagerSuite artifactManagerSuite = this;
        synchronized (artifactManagerSuite) {
            if ((this.bitmap$0 & 0x400000) == 0) {
                this.tableName = SQLTestData.tableName$((SQLTestData)this);
                this.bitmap$0 |= 0x400000;
            }
        }
        return this.tableName;
    }

    public Dataset<Row> tableName() {
        return (this.bitmap$0 & 0x400000) == 0 ? this.tableName$lzycompute() : this.tableName;
    }

    private RDD<String> unparsedStrings$lzycompute() {
        ArtifactManagerSuite artifactManagerSuite = this;
        synchronized (artifactManagerSuite) {
            if ((this.bitmap$0 & 0x800000) == 0) {
                this.unparsedStrings = SQLTestData.unparsedStrings$((SQLTestData)this);
                this.bitmap$0 |= 0x800000;
            }
        }
        return this.unparsedStrings;
    }

    public RDD<String> unparsedStrings() {
        return (this.bitmap$0 & 0x800000) == 0 ? this.unparsedStrings$lzycompute() : this.unparsedStrings;
    }

    private RDD<SQLTestData.IntField> withEmptyParts$lzycompute() {
        ArtifactManagerSuite artifactManagerSuite = this;
        synchronized (artifactManagerSuite) {
            if ((this.bitmap$0 & 0x1000000) == 0) {
                this.withEmptyParts = SQLTestData.withEmptyParts$((SQLTestData)this);
                this.bitmap$0 |= 0x1000000;
            }
        }
        return this.withEmptyParts;
    }

    public RDD<SQLTestData.IntField> withEmptyParts() {
        return (this.bitmap$0 & 0x1000000) == 0 ? this.withEmptyParts$lzycompute() : this.withEmptyParts;
    }

    private Dataset<Row> person$lzycompute() {
        ArtifactManagerSuite artifactManagerSuite = this;
        synchronized (artifactManagerSuite) {
            if ((this.bitmap$0 & 0x2000000) == 0) {
                this.person = SQLTestData.person$((SQLTestData)this);
                this.bitmap$0 |= 0x2000000;
            }
        }
        return this.person;
    }

    public Dataset<Row> person() {
        return (this.bitmap$0 & 0x2000000) == 0 ? this.person$lzycompute() : this.person;
    }

    private Dataset<Row> salary$lzycompute() {
        ArtifactManagerSuite artifactManagerSuite = this;
        synchronized (artifactManagerSuite) {
            if ((this.bitmap$0 & 0x4000000) == 0) {
                this.salary = SQLTestData.salary$((SQLTestData)this);
                this.bitmap$0 |= 0x4000000;
            }
        }
        return this.salary;
    }

    public Dataset<Row> salary() {
        return (this.bitmap$0 & 0x4000000) == 0 ? this.salary$lzycompute() : this.salary;
    }

    private Dataset<Row> complexData$lzycompute() {
        ArtifactManagerSuite artifactManagerSuite = this;
        synchronized (artifactManagerSuite) {
            if ((this.bitmap$0 & 0x8000000) == 0) {
                this.complexData = SQLTestData.complexData$((SQLTestData)this);
                this.bitmap$0 |= 0x8000000;
            }
        }
        return this.complexData;
    }

    public Dataset<Row> complexData() {
        return (this.bitmap$0 & 0x8000000) == 0 ? this.complexData$lzycompute() : this.complexData;
    }

    private Dataset<Row> courseSales$lzycompute() {
        ArtifactManagerSuite artifactManagerSuite = this;
        synchronized (artifactManagerSuite) {
            if ((this.bitmap$0 & 0x10000000) == 0) {
                this.courseSales = SQLTestData.courseSales$((SQLTestData)this);
                this.bitmap$0 |= 0x10000000;
            }
        }
        return this.courseSales;
    }

    public Dataset<Row> courseSales() {
        return (this.bitmap$0 & 0x10000000) == 0 ? this.courseSales$lzycompute() : this.courseSales;
    }

    private Dataset<Row> trainingSales$lzycompute() {
        ArtifactManagerSuite artifactManagerSuite = this;
        synchronized (artifactManagerSuite) {
            if ((this.bitmap$0 & 0x20000000) == 0) {
                this.trainingSales = SQLTestData.trainingSales$((SQLTestData)this);
                this.bitmap$0 |= 0x20000000;
            }
        }
        return this.trainingSales;
    }

    public Dataset<Row> trainingSales() {
        return (this.bitmap$0 & 0x20000000) == 0 ? this.trainingSales$lzycompute() : this.trainingSales;
    }

    private Dataset<Row> intervalData$lzycompute() {
        ArtifactManagerSuite artifactManagerSuite = this;
        synchronized (artifactManagerSuite) {
            if ((this.bitmap$0 & 0x40000000) == 0) {
                this.intervalData = SQLTestData.intervalData$((SQLTestData)this);
                this.bitmap$0 |= 0x40000000;
            }
        }
        return this.intervalData;
    }

    public Dataset<Row> intervalData() {
        return (this.bitmap$0 & 0x40000000) == 0 ? this.intervalData$lzycompute() : this.intervalData;
    }

    public AbstractPatienceConfiguration.PatienceConfig org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig() {
        return this.org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig;
    }

    public final void org$scalatest$concurrent$PatienceConfiguration$_setter_$org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig_$eq(AbstractPatienceConfiguration.PatienceConfig x$1) {
        this.org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig = x$1;
    }

    public AbstractPatienceConfiguration$PatienceConfig$ PatienceConfig() {
        if (this.PatienceConfig$module == null) {
            this.PatienceConfig$lzycompute$1();
        }
        return this.PatienceConfig$module;
    }

    public SparkConf sparkConf() {
        SparkConf conf = SharedSparkSessionBase.sparkConf$((SharedSparkSessionBase)this);
        return conf.set("spark.plugins", "org.apache.spark.sql.connect.SparkConnectPlugin").set("spark.connect.copyFromLocalToFs.allowDestLocal", "true");
    }

    private Path artifactPath() {
        return this.artifactPath;
    }

    private SessionHolder sessionHolder() {
        return new SessionHolder("test", this.spark().sessionUUID(), this.spark());
    }

    private SparkConnectArtifactManager artifactManager$lzycompute() {
        ArtifactManagerSuite artifactManagerSuite = this;
        synchronized (artifactManagerSuite) {
            if ((this.bitmap$0 & 1) == 0) {
                this.artifactManager = new SparkConnectArtifactManager(this.sessionHolder());
                this.bitmap$0 |= 1;
            }
        }
        return this.artifactManager;
    }

    private SparkConnectArtifactManager artifactManager() {
        return (this.bitmap$0 & 1) == 0 ? this.artifactManager$lzycompute() : this.artifactManager;
    }

    private String sessionUUID() {
        return this.spark().sessionUUID();
    }

    public void afterEach() {
        this.artifactManager().cleanUpResources();
        SharedSparkSessionBase.afterEach$((SharedSparkSessionBase)this);
    }

    private final void testImplicits$lzycompute$1() {
        ArtifactManagerSuite artifactManagerSuite = this;
        synchronized (artifactManagerSuite) {
            if (this.testImplicits$module == null) {
                this.testImplicits$module = new SQLTestUtilsBase$testImplicits$((SQLTestUtilsBase)this);
            }
        }
    }

    private final void org$apache$spark$sql$test$SQLTestData$$internalImplicits$lzycompute$1() {
        ArtifactManagerSuite artifactManagerSuite = this;
        synchronized (artifactManagerSuite) {
            if (this.internalImplicits$module == null) {
                this.internalImplicits$module = new SQLTestData$internalImplicits$((SQLTestData)this);
            }
        }
    }

    private final void PatienceConfig$lzycompute$1() {
        ArtifactManagerSuite artifactManagerSuite = this;
        synchronized (artifactManagerSuite) {
            if (this.PatienceConfig$module == null) {
                this.PatienceConfig$module = new AbstractPatienceConfiguration$PatienceConfig$((AbstractPatienceConfiguration)this);
            }
        }
    }

    public static final /* synthetic */ void $anonfun$new$6(ArtifactManagerSuite $this, File path) {
        Path stagingPath = path.toPath();
        Files.write(path.toPath(), "test".getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        Path remotePath = Paths.get("cache/abc", new String[0]);
        SessionHolder session = $this.sessionHolder();
        BlockManager blockManager = $this.spark().sparkContext().env().blockManager();
        CacheId blockId = new CacheId(session.userId(), session.sessionId(), "abc");
        try {
            $this.artifactManager().addArtifact(remotePath, stagingPath, (Option)None$.MODULE$);
            Option bytes = blockManager.getLocalBytes((BlockId)blockId);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(bytes.isDefined(), "bytes.isDefined", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ArtifactManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 133));
            String readback = new String(((BlockData)bytes.get()).toByteBuffer().array(), StandardCharsets.UTF_8);
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = $this.convertToEqualizer(readback);
            String $org_scalatest_assert_macro_right = "test";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ArtifactManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 135));
        }
        finally {
            blockManager.releaseLock((BlockId)blockId, blockManager.releaseLock$default$2());
            blockManager.removeCache(session.userId(), session.sessionId());
        }
    }

    public static final /* synthetic */ void $anonfun$new$8(ArtifactManagerSuite $this, File path) {
        Path stagingPath = path.toPath();
        Files.write(path.toPath(), "test".getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        Path remotePath = Paths.get("pyfiles/abc.zip", new String[0]);
        $this.artifactManager().addArtifact(remotePath, stagingPath, (Option)None$.MODULE$);
        Seq $org_scalatest_assert_macro_left = $this.artifactManager().getSparkConnectPythonIncludes();
        Seq $org_scalatest_assert_macro_right = (Seq)scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"abc.zip"}));
        Seq seq = $org_scalatest_assert_macro_left;
        Seq seq2 = $org_scalatest_assert_macro_right;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(seq != null ? !seq.equals(seq2) : seq2 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ArtifactManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 149));
    }

    public static final /* synthetic */ void $anonfun$new$11(ArtifactManagerSuite $this, File path) {
        Path stagingPath = path.toPath();
        Files.write(path.toPath(), "test".getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        Path remotePath = Paths.get("cache/abc", new String[0]);
        SessionHolder session = $this.sessionHolder();
        BlockManager blockManager = $this.spark().sparkContext().env().blockManager();
        CacheId blockId = new CacheId(session.userId(), session.sessionId(), "abc");
        Path copyDir = Utils$.MODULE$.createTempDir().toPath();
        FileUtils.copyDirectory((File)$this.artifactPath().toFile(), (File)copyDir.toFile());
        try {
            $this.artifactManager().addArtifact(remotePath, stagingPath, (Option)None$.MODULE$);
            Path stagingPathFile = copyDir.resolve("smallClassFile.class");
            Path remotePathFile = Paths.get("classes/smallClassFile.class", new String[0]);
            $this.artifactManager().addArtifact(remotePathFile, stagingPathFile, (Option)None$.MODULE$);
            Option bytes = blockManager.getLocalBytes((BlockId)blockId);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(bytes.isDefined(), "bytes.isDefined", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ArtifactManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 187));
            blockManager.releaseLock((BlockId)blockId, blockManager.releaseLock$default$2());
            Path expectedPath = SparkConnectArtifactManager$.MODULE$.artifactRootPath().resolve(new StringBuilder(29).append($this.sessionUUID()).append("/classes/smallClassFile.class").toString());
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(expectedPath.toFile().exists(), "expectedPath.toFile().exists()", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ArtifactManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 191));
            $this.artifactManager().cleanUpResources();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(blockManager.getLocalBytes((BlockId)blockId).isDefined(), "blockManager.getLocalBytes(blockId).isDefined", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ArtifactManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 196));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(expectedPath.toFile().exists(), "expectedPath.toFile().exists()", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ArtifactManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 197));
        }
        catch (Throwable throwable) {
            try {
                try {
                    blockManager.releaseLock((BlockId)blockId, blockManager.releaseLock$default$2());
                }
                catch (SparkException sparkException) {
                }
                catch (Throwable throwable2) {
                    throw throwable2;
                }
            }
            finally {
                FileUtils.deleteDirectory((File)copyDir.toFile());
                blockManager.removeCache(session.userId(), session.sessionId());
            }
            throw throwable;
        }
        try {
            try {
                blockManager.releaseLock((BlockId)blockId, blockManager.releaseLock$default$2());
            }
            catch (SparkException sparkException) {
            }
            catch (Throwable throwable) {
                throw throwable;
            }
        }
        finally {
            FileUtils.deleteDirectory((File)copyDir.toFile());
            blockManager.removeCache(session.userId(), session.sessionId());
        }
    }

    private final void addHelloClass$1(SessionHolder holder) {
        Path copyDir = Utils$.MODULE$.createTempDir().toPath();
        FileUtils.copyDirectory((File)this.artifactPath().toFile(), (File)copyDir.toFile());
        Path stagingPath = copyDir.resolve("Hello.class");
        Path remotePath = Paths.get("classes/Hello.class", new String[0]);
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(stagingPath.toFile().exists(), "stagingPath.toFile().exists()", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ArtifactManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 224));
        holder.addArtifact(remotePath, stagingPath, (Option)None$.MODULE$);
    }

    public static final /* synthetic */ boolean $anonfun$new$14(Row x$1) {
        return x$1.getString(0).contains("Talon");
    }

    public static final /* synthetic */ boolean $anonfun$new$17(Row x$2) {
        return x$2.getString(0).contains("Ahri");
    }

    public ArtifactManagerSuite() {
        ScaledTimeSpans.$init$((ScaledTimeSpans)this);
        AbstractPatienceConfiguration.$init$((AbstractPatienceConfiguration)this);
        PatienceConfiguration.$init$((PatienceConfiguration)this);
        Eventually.$init$((Eventually)this);
        SQLTestData.$init$((SQLTestData)this);
        AliasHelper.$init$((AliasHelper)this);
        PredicateHelper.$init$((PredicateHelper)this);
        SQLHelper.$init$((SQLHelper)this);
        SQLConfHelper.$init$((SQLConfHelper)this);
        PlanTestBase.$init$((PlanTestBase)this);
        SQLTestUtilsBase.$init$((SQLTestUtilsBase)this);
        SQLTestUtils.$init$((SQLTestUtils)this);
        SharedSparkSessionBase.$init$((SharedSparkSessionBase)this);
        SharedSparkSession.$init$((SharedSparkSession)this);
        ResourceHelper.$init$(this);
        this.artifactPath = this.commonResourcePath().resolve("artifact-tests");
        this.test("Class artifacts are added to the correct directory.", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            Path copyDir = Utils$.MODULE$.createTempDir().toPath();
            FileUtils.copyDirectory((File)this.artifactPath().toFile(), (File)copyDir.toFile());
            Path stagingPath = copyDir.resolve("smallClassFile.class");
            Path remotePath = Paths.get("classes/smallClassFile.class", new String[0]);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(stagingPath.toFile().exists(), "stagingPath.toFile().exists()", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ArtifactManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 60));
            this.artifactManager().addArtifact(remotePath, stagingPath, (Option)None$.MODULE$);
            File movedClassFile = SparkConnectArtifactManager$.MODULE$.artifactRootPath().resolve(new StringBuilder(29).append(this.sessionUUID()).append("/classes/smallClassFile.class").toString()).toFile();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(movedClassFile.exists(), "movedClassFile.exists()", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ArtifactManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 66));
        }, new Position("ArtifactManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 55));
        this.test("Class file artifacts are added to SC classloader", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            Object msg;
            Path copyDir = Utils$.MODULE$.createTempDir().toPath();
            FileUtils.copyDirectory((File)this.artifactPath().toFile(), (File)copyDir.toFile());
            Path stagingPath = copyDir.resolve("Hello.class");
            Path remotePath = Paths.get("classes/Hello.class", new String[0]);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(stagingPath.toFile().exists(), "stagingPath.toFile().exists()", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ArtifactManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 74));
            this.artifactManager().addArtifact(remotePath, stagingPath, (Option)None$.MODULE$);
            File movedClassFile = SparkConnectArtifactManager$.MODULE$.artifactRootPath().resolve(new StringBuilder(20).append(this.sessionUUID()).append("/classes/Hello.class").toString()).toFile();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(movedClassFile.exists(), "movedClassFile.exists()", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ArtifactManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 80));
            ClassLoader classLoader = this.artifactManager().classloader();
            Object instance = classLoader.loadClass("Hello").getDeclaredConstructor(String.class).newInstance("Talon");
            Object $org_scalatest_assert_macro_left = msg = instance.getClass().getMethod("msg", new Class[0]).invoke(instance, new Object[0]);
            String $org_scalatest_assert_macro_right = "Hello Talon! Nice to meet you!";
            Object object = $org_scalatest_assert_macro_left;
            String string = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(object != null ? !object.equals(string) : string != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ArtifactManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 90));
        }, new Position("ArtifactManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 69));
        this.test("UDF can reference added class file", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            Path copyDir = Utils$.MODULE$.createTempDir().toPath();
            FileUtils.copyDirectory((File)this.artifactPath().toFile(), (File)copyDir.toFile());
            Path stagingPath = copyDir.resolve("Hello.class");
            Path remotePath = Paths.get("classes/Hello.class", new String[0]);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(stagingPath.toFile().exists(), "stagingPath.toFile().exists()", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ArtifactManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 98));
            SessionHolder sessionHolder = SparkConnectService$.MODULE$.getOrCreateIsolatedSession("c1", UUID.randomUUID().toString());
            sessionHolder.addArtifact(remotePath, stagingPath, (Option)None$.MODULE$);
            File movedClassFile = SparkConnectArtifactManager$.MODULE$.artifactRootPath().resolve(new StringBuilder(20).append(sessionHolder.session().sessionUUID()).append("/classes/Hello.class").toString()).toFile();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(movedClassFile.exists(), "movedClassFile.exists()", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ArtifactManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 107));
            ClassLoader classLoader = sessionHolder.classloader();
            Function1 instance = (Function1)classLoader.loadClass("Hello").getDeclaredConstructor(String.class).newInstance("Talon");
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(ArtifactManagerSuite.class.getClassLoader());
            JavaUniverse $u2 = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(ArtifactManagerSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_connect_artifact_ArtifactManagerSuite$$typecreator1$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$);
                }

                public Org_apache_spark_sql_connect_artifact_ArtifactManagerSuite$$typecreator1$1(ArtifactManagerSuite $outer) {
                }
            }
            public final class Org_apache_spark_sql_connect_artifact_ArtifactManagerSuite$$typecreator2$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$);
                }

                public Org_apache_spark_sql_connect_artifact_ArtifactManagerSuite$$typecreator2$1(ArtifactManagerSuite $outer) {
                }
            }
            UserDefinedFunction udf = functions$.MODULE$.udf(instance, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_connect_artifact_ArtifactManagerSuite$$typecreator1$1(null)), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_sql_connect_artifact_ArtifactManagerSuite$$typecreator2$1(null)));
            return (Row[])sessionHolder.withSession((Function1 & Serializable)session -> (Row[])session.range(10L).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{udf.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("id").cast("string")}))})).collect());
        }, new Position("ArtifactManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 93));
        this.test("add a cache artifact to the Block Manager", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable)path -> {
            ArtifactManagerSuite.$anonfun$new$6(this, path);
            return BoxedUnit.UNIT;
        }), new Position("ArtifactManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 122));
        this.test("Check Python includes when zipped package is added", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable)path -> {
            ArtifactManagerSuite.$anonfun$new$8(this, path);
            return BoxedUnit.UNIT;
        }), new Position("ArtifactManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 143));
        this.test("SPARK-43790: Forward artifact file to cloud storage path", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            Path copyDir = Utils$.MODULE$.createTempDir().toPath();
            Path destFSDir = Utils$.MODULE$.createTempDir().toPath();
            FileUtils.copyDirectory((File)this.artifactPath().toFile(), (File)copyDir.toFile());
            Path stagingPath = copyDir.resolve("smallClassFile.class");
            Path remotePath = Paths.get("forward_to_fs", ((Object)destFSDir).toString(), "smallClassFileCopied.class");
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(stagingPath.toFile().exists(), "stagingPath.toFile().exists()", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ArtifactManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 159));
            this.artifactManager().uploadArtifactToFs(remotePath, stagingPath);
            this.artifactManager().addArtifact(remotePath, stagingPath, (Option)None$.MODULE$);
            File copiedClassFile = Paths.get(((Object)destFSDir).toString(), "smallClassFileCopied.class").toFile();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(copiedClassFile.exists(), "copiedClassFile.exists()", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ArtifactManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 164));
        }, new Position("ArtifactManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 153));
        this.test("Removal of resources", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTempPath((Function1<File, BoxedUnit>)(Function1 & Serializable)path -> {
            ArtifactManagerSuite.$anonfun$new$11(this, path);
            return BoxedUnit.UNIT;
        }), new Position("ArtifactManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 167));
        this.test("Classloaders for spark sessions are isolated", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            String sessionId = UUID.randomUUID().toString();
            SessionHolder holder1 = SparkConnectService$.MODULE$.getOrCreateIsolatedSession("c1", sessionId);
            SessionHolder holder2 = SparkConnectService$.MODULE$.getOrCreateIsolatedSession("c2", sessionId);
            SessionHolder holder3 = SparkConnectService$.MODULE$.getOrCreateIsolatedSession("c3", sessionId);
            this.addHelloClass$1(holder1);
            ClassLoader classLoader1 = holder1.classloader();
            Function1 instance1 = (Function1)classLoader1.loadClass("Hello").getDeclaredConstructor(String.class).newInstance("Talon");
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(ArtifactManagerSuite.class.getClassLoader());
            JavaUniverse $u2 = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(ArtifactManagerSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_connect_artifact_ArtifactManagerSuite$$typecreator3$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$);
                }

                public Org_apache_spark_sql_connect_artifact_ArtifactManagerSuite$$typecreator3$1(ArtifactManagerSuite $outer) {
                }
            }
            public final class Org_apache_spark_sql_connect_artifact_ArtifactManagerSuite$$typecreator4$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$);
                }

                public Org_apache_spark_sql_connect_artifact_ArtifactManagerSuite$$typecreator4$1(ArtifactManagerSuite $outer) {
                }
            }
            UserDefinedFunction udf1 = functions$.MODULE$.udf(instance1, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_connect_artifact_ArtifactManagerSuite$$typecreator3$1(null)), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_sql_connect_artifact_ArtifactManagerSuite$$typecreator4$1(null)));
            holder1.withSession((Function1 & Serializable)session -> {
                Row[] result = (Row[])session.range(10L).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{udf1.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("id").cast("string")}))})).collect();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(ArrayOps$.MODULE$.forall$extension(Predef$.MODULE$.refArrayOps((Object[])result), (Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ArtifactManagerSuite.$anonfun$new$14(x$1))), "scala.Predef.refArrayOps[org.apache.spark.sql.Row](result).forall(((x$1: org.apache.spark.sql.Row) => x$1.getString(0).contains(\"Talon\")))", Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ArtifactManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 241));
            });
            this.assertThrows((Function0)(JFunction0.mcV.sp & Serializable)() -> {
                ClassLoader classLoader2 = holder2.classloader();
                Function1 function1 = (Function1)classLoader2.loadClass("Hello").getDeclaredConstructor(String.class).newInstance("Talon");
            }, ClassTag$.MODULE$.apply(ClassNotFoundException.class), new Position("ArtifactManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 244));
            this.addHelloClass$1(holder3);
            Function1 instance3 = (Function1)holder3.classloader().loadClass("Hello").getDeclaredConstructor(String.class).newInstance("Ahri");
            JavaUniverse $u3 = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m3 = package$.MODULE$.universe().runtimeMirror(ArtifactManagerSuite.class.getClassLoader());
            JavaUniverse $u4 = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m4 = package$.MODULE$.universe().runtimeMirror(ArtifactManagerSuite.class.getClassLoader());
            public final class Org_apache_spark_sql_connect_artifact_ArtifactManagerSuite$$typecreator5$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$);
                }

                public Org_apache_spark_sql_connect_artifact_ArtifactManagerSuite$$typecreator5$1(ArtifactManagerSuite $outer) {
                }
            }
            public final class Org_apache_spark_sql_connect_artifact_ArtifactManagerSuite$$typecreator6$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($m.staticPackage("scala").asModule().moduleClass().asType().toTypeConstructor(), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$);
                }

                public Org_apache_spark_sql_connect_artifact_ArtifactManagerSuite$$typecreator6$1(ArtifactManagerSuite $outer) {
                }
            }
            UserDefinedFunction udf3 = functions$.MODULE$.udf(instance3, ((TypeTags)$u3).TypeTag().apply((Mirror)$m3, (TypeCreator)new Org_apache_spark_sql_connect_artifact_ArtifactManagerSuite$$typecreator5$1(null)), ((TypeTags)$u4).TypeTag().apply((Mirror)$m4, (TypeCreator)new Org_apache_spark_sql_connect_artifact_ArtifactManagerSuite$$typecreator6$1(null)));
            return (Assertion)holder3.withSession((Function1 & Serializable)session -> {
                Row[] result = (Row[])session.range(10L).select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{udf3.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("id").cast("string")}))})).collect();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(ArrayOps$.MODULE$.forall$extension(Predef$.MODULE$.refArrayOps((Object[])result), (Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ArtifactManagerSuite.$anonfun$new$17(x$2))), "scala.Predef.refArrayOps[org.apache.spark.sql.Row](result).forall(((x$2: org.apache.spark.sql.Row) => x$2.getString(0).contains(\"Ahri\")))", Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ArtifactManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 264));
            });
        }, new Position("ArtifactManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 212));
        this.test("SPARK-44300: Cleaning up resources only deletes session-specific resources", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            Path copyDir = Utils$.MODULE$.createTempDir().toPath();
            FileUtils.copyDirectory((File)this.artifactPath().toFile(), (File)copyDir.toFile());
            Path stagingPath = copyDir.resolve("Hello.class");
            Path remotePath = Paths.get("classes/Hello.class", new String[0]);
            SessionHolder sessionHolder = SparkConnectService$.MODULE$.getOrCreateIsolatedSession("c1", UUID.randomUUID().toString());
            sessionHolder.addArtifact(remotePath, stagingPath, (Option)None$.MODULE$);
            File sessionDirectory = ((Path)SparkConnectArtifactManager$.MODULE$.getArtifactDirectoryAndUriForSession(sessionHolder)._1()).toFile();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(sessionDirectory.exists(), "sessionDirectory.exists()", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ArtifactManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 280));
            sessionHolder.artifactManager().cleanUpResources();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(sessionDirectory.exists(), "sessionDirectory.exists()", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ArtifactManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 283));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(SparkConnectArtifactManager$.MODULE$.artifactRootPath().toFile().exists(), "SparkConnectArtifactManager.artifactRootPath.toFile().exists()", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ArtifactManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 284));
        }, new Position("ArtifactManagerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 268));
        Statics.releaseFence();
    }
}

