/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connect.client.arrow;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Period;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.complex.ListVector;
import org.apache.arrow.vector.complex.MapVector;
import org.apache.arrow.vector.complex.StructVector;
import org.apache.spark.sql.catalyst.ScalaReflection$;
import org.apache.spark.sql.catalyst.encoders.AgnosticEncoder;
import org.apache.spark.sql.catalyst.encoders.AgnosticEncoders;
import org.apache.spark.sql.catalyst.expressions.GenericRowWithSchema;
import org.apache.spark.sql.connect.client.CloseableIterator;
import org.apache.spark.sql.connect.client.arrow.AbstractMessageIterator;
import org.apache.spark.sql.connect.client.arrow.ArrowDeserializers;
import org.apache.spark.sql.connect.client.arrow.ArrowDeserializingIterator;
import org.apache.spark.sql.connect.client.arrow.ArrowEncoderUtils$;
import org.apache.spark.sql.connect.client.arrow.ArrowEncoderUtils$Classes$;
import org.apache.spark.sql.connect.client.arrow.ConcatenatingArrowStreamReader;
import org.apache.spark.sql.connect.client.arrow.EmptyDeserializingIterator;
import org.apache.spark.sql.connect.client.arrow.MessageIterator;
import org.apache.spark.sql.connect.client.arrow.ScalaCollectionUtils$;
import org.apache.spark.sql.connect.client.arrow.StructVectors$;
import org.apache.spark.sql.errors.CompilationErrors$;
import org.apache.spark.sql.errors.ExecutionErrors$;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.util.ArrayImplicits$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableFactory;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.MapFactory;
import scala.collection.immutable.ArraySeq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArrayBuilder$;
import scala.collection.mutable.Builder;
import scala.collection.mutable.Map$;
import scala.math.BigInt;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Symbols;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;

public final class ArrowDeserializers$ {
    public static final ArrowDeserializers$ MODULE$ = new ArrowDeserializers$();
    private static final MethodHandles.Lookup methodLookup = MethodHandles.lookup();

    public <T> CloseableIterator<T> deserializeFromArrow(Iterator<byte[]> input, AgnosticEncoder<T> encoder, BufferAllocator allocator, String timeZoneId) {
        CloseableIterator<T> closeableIterator;
        try {
            ConcatenatingArrowStreamReader reader = new ConcatenatingArrowStreamReader(allocator, (Iterator<AbstractMessageIterator>)input.map((Function1 & Serializable)bytes -> new MessageIterator(new ByteArrayInputStream((byte[])bytes), allocator)), true);
            closeableIterator = new ArrowDeserializingIterator<T>(encoder, reader, timeZoneId);
        }
        catch (IOException iOException) {
            closeableIterator = new EmptyDeserializingIterator<T>(encoder);
        }
        return closeableIterator;
    }

    public <T> ArrowDeserializers.Deserializer<T> deserializerFor(AgnosticEncoder<T> encoder, VectorSchemaRoot root, String timeZoneId) {
        VectorSchemaRoot data = encoder.isStruct() ? root : root.getVector(0);
        return this.deserializerFor(encoder, (Object)data, timeZoneId);
    }

    public ArrowDeserializers.Deserializer<Object> deserializerFor(AgnosticEncoder<?> encoder, Object data, String timeZoneId) {
        AgnosticEncoder agnosticEncoder;
        AgnosticEncoder agnosticEncoder2;
        Tuple2 tuple2 = new Tuple2(encoder, data);
        if (tuple2 != null) {
            AgnosticEncoder agnosticEncoder3 = (AgnosticEncoder)tuple2._1();
            Object v = tuple2._2();
            if ((AgnosticEncoders.PrimitiveBooleanEncoder$.MODULE$.equals(agnosticEncoder3) ? true : AgnosticEncoders.BoxedBooleanEncoder$.MODULE$.equals(agnosticEncoder3)) && v instanceof FieldVector) {
                FieldVector fieldVector = (FieldVector)v;
                return new ArrowDeserializers.LeafFieldDeserializer<Object>(encoder, fieldVector, timeZoneId){

                    public boolean value(int i) {
                        return this.reader().getBoolean(i);
                    }
                };
            }
        }
        if (tuple2 != null) {
            AgnosticEncoder agnosticEncoder4 = (AgnosticEncoder)tuple2._1();
            Object v = tuple2._2();
            if ((AgnosticEncoders.PrimitiveByteEncoder$.MODULE$.equals(agnosticEncoder4) ? true : AgnosticEncoders.BoxedByteEncoder$.MODULE$.equals(agnosticEncoder4)) && v instanceof FieldVector) {
                FieldVector fieldVector = (FieldVector)v;
                return new ArrowDeserializers.LeafFieldDeserializer<Object>(encoder, fieldVector, timeZoneId){

                    public byte value(int i) {
                        return this.reader().getByte(i);
                    }
                };
            }
        }
        if (tuple2 != null) {
            AgnosticEncoder agnosticEncoder5 = (AgnosticEncoder)tuple2._1();
            Object v = tuple2._2();
            if ((AgnosticEncoders.PrimitiveShortEncoder$.MODULE$.equals(agnosticEncoder5) ? true : AgnosticEncoders.BoxedShortEncoder$.MODULE$.equals(agnosticEncoder5)) && v instanceof FieldVector) {
                FieldVector fieldVector = (FieldVector)v;
                return new ArrowDeserializers.LeafFieldDeserializer<Object>(encoder, fieldVector, timeZoneId){

                    public short value(int i) {
                        return this.reader().getShort(i);
                    }
                };
            }
        }
        if (tuple2 != null) {
            AgnosticEncoder agnosticEncoder6 = (AgnosticEncoder)tuple2._1();
            Object v = tuple2._2();
            if ((AgnosticEncoders.PrimitiveIntEncoder$.MODULE$.equals(agnosticEncoder6) ? true : AgnosticEncoders.BoxedIntEncoder$.MODULE$.equals(agnosticEncoder6)) && v instanceof FieldVector) {
                FieldVector fieldVector = (FieldVector)v;
                return new ArrowDeserializers.LeafFieldDeserializer<Object>(encoder, fieldVector, timeZoneId){

                    public int value(int i) {
                        return this.reader().getInt(i);
                    }
                };
            }
        }
        if (tuple2 != null) {
            AgnosticEncoder agnosticEncoder7 = (AgnosticEncoder)tuple2._1();
            Object v = tuple2._2();
            if ((AgnosticEncoders.PrimitiveLongEncoder$.MODULE$.equals(agnosticEncoder7) ? true : AgnosticEncoders.BoxedLongEncoder$.MODULE$.equals(agnosticEncoder7)) && v instanceof FieldVector) {
                FieldVector fieldVector = (FieldVector)v;
                return new ArrowDeserializers.LeafFieldDeserializer<Object>(encoder, fieldVector, timeZoneId){

                    public long value(int i) {
                        return this.reader().getLong(i);
                    }
                };
            }
        }
        if (tuple2 != null) {
            AgnosticEncoder agnosticEncoder8 = (AgnosticEncoder)tuple2._1();
            Object v = tuple2._2();
            if ((AgnosticEncoders.PrimitiveFloatEncoder$.MODULE$.equals(agnosticEncoder8) ? true : AgnosticEncoders.BoxedFloatEncoder$.MODULE$.equals(agnosticEncoder8)) && v instanceof FieldVector) {
                FieldVector fieldVector = (FieldVector)v;
                return new ArrowDeserializers.LeafFieldDeserializer<Object>(encoder, fieldVector, timeZoneId){

                    public float value(int i) {
                        return this.reader().getFloat(i);
                    }
                };
            }
        }
        if (tuple2 != null) {
            AgnosticEncoder agnosticEncoder9 = (AgnosticEncoder)tuple2._1();
            Object v = tuple2._2();
            if ((AgnosticEncoders.PrimitiveDoubleEncoder$.MODULE$.equals(agnosticEncoder9) ? true : AgnosticEncoders.BoxedDoubleEncoder$.MODULE$.equals(agnosticEncoder9)) && v instanceof FieldVector) {
                FieldVector fieldVector = (FieldVector)v;
                return new ArrowDeserializers.LeafFieldDeserializer<Object>(encoder, fieldVector, timeZoneId){

                    public double value(int i) {
                        return this.reader().getDouble(i);
                    }
                };
            }
        }
        if (tuple2 != null && AgnosticEncoders.NullEncoder$.MODULE$.equals(agnosticEncoder2 = (AgnosticEncoder)tuple2._1()) && tuple2._2() instanceof FieldVector) {
            return new ArrowDeserializers.Deserializer<Object>(){

                public Object get(int i) {
                    return null;
                }
            };
        }
        if (tuple2 != null) {
            AgnosticEncoder agnosticEncoder10 = (AgnosticEncoder)tuple2._1();
            Object v = tuple2._2();
            if (AgnosticEncoders.StringEncoder$.MODULE$.equals(agnosticEncoder10) && v instanceof FieldVector) {
                FieldVector fieldVector = (FieldVector)v;
                return new ArrowDeserializers.LeafFieldDeserializer<String>(encoder, fieldVector, timeZoneId){

                    public String value(int i) {
                        return this.reader().getString(i);
                    }
                };
            }
        }
        if (tuple2 != null) {
            AgnosticEncoder agnosticEncoder11 = (AgnosticEncoder)tuple2._1();
            Object v = tuple2._2();
            if (agnosticEncoder11 instanceof AgnosticEncoders.JavaEnumEncoder) {
                AgnosticEncoders.JavaEnumEncoder javaEnumEncoder = (AgnosticEncoders.JavaEnumEncoder)agnosticEncoder11;
                ClassTag tag = javaEnumEncoder.clsTag();
                if (v instanceof FieldVector) {
                    FieldVector fieldVector = (FieldVector)v;
                    MethodHandle valueOf = this.methodLookup().findStatic(tag.runtimeClass(), "valueOf", MethodType.methodType(tag.runtimeClass(), String.class));
                    return new ArrowDeserializers.LeafFieldDeserializer<Enum<?>>(encoder, fieldVector, timeZoneId, valueOf){
                        private final MethodHandle valueOf$1;

                        public Enum<?> value(int i) {
                            return (Enum)this.valueOf$1.invoke(this.reader().getString(i));
                        }
                        {
                            this.valueOf$1 = valueOf$1;
                            super(encoder$1, x39$1, timeZoneId$1);
                        }
                    };
                }
            }
        }
        if (tuple2 != null) {
            AgnosticEncoder agnosticEncoder12 = (AgnosticEncoder)tuple2._1();
            Object v = tuple2._2();
            if (agnosticEncoder12 instanceof AgnosticEncoders.ScalaEnumEncoder) {
                AgnosticEncoders.ScalaEnumEncoder scalaEnumEncoder = (AgnosticEncoders.ScalaEnumEncoder)agnosticEncoder12;
                Class parent = scalaEnumEncoder.parent();
                if (v instanceof FieldVector) {
                    FieldVector fieldVector = (FieldVector)v;
                    JavaUniverse.JavaMirror mirror = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
                    Symbols.ModuleSymbolApi module = mirror.classSymbol((Object)parent).module().asModule();
                    Enumeration enumeration = (Enumeration)mirror.reflectModule(module).instance();
                    return new ArrowDeserializers.LeafFieldDeserializer<Enumeration.Value>(encoder, fieldVector, timeZoneId, enumeration){
                        private final Enumeration enumeration$1;

                        public Enumeration.Value value(int i) {
                            return this.enumeration$1.withName(this.reader().getString(i));
                        }
                        {
                            this.enumeration$1 = enumeration$1;
                            super(encoder$1, x43$1, timeZoneId$1);
                        }
                    };
                }
            }
        }
        if (tuple2 != null) {
            AgnosticEncoder agnosticEncoder13 = (AgnosticEncoder)tuple2._1();
            Object v = tuple2._2();
            if (AgnosticEncoders.BinaryEncoder$.MODULE$.equals(agnosticEncoder13) && v instanceof FieldVector) {
                FieldVector fieldVector = (FieldVector)v;
                return new ArrowDeserializers.LeafFieldDeserializer<byte[]>(encoder, fieldVector, timeZoneId){

                    public byte[] value(int i) {
                        return this.reader().getBytes(i);
                    }
                };
            }
        }
        if (tuple2 != null) {
            AgnosticEncoder agnosticEncoder14 = (AgnosticEncoder)tuple2._1();
            Object v = tuple2._2();
            if (agnosticEncoder14 instanceof AgnosticEncoders.SparkDecimalEncoder && v instanceof FieldVector) {
                FieldVector fieldVector = (FieldVector)v;
                return new ArrowDeserializers.LeafFieldDeserializer<Decimal>(encoder, fieldVector, timeZoneId){

                    public Decimal value(int i) {
                        return this.reader().getDecimal(i);
                    }
                };
            }
        }
        if (tuple2 != null) {
            AgnosticEncoder agnosticEncoder15 = (AgnosticEncoder)tuple2._1();
            Object v = tuple2._2();
            if (agnosticEncoder15 instanceof AgnosticEncoders.ScalaDecimalEncoder && v instanceof FieldVector) {
                FieldVector fieldVector = (FieldVector)v;
                return new ArrowDeserializers.LeafFieldDeserializer<scala.math.BigDecimal>(encoder, fieldVector, timeZoneId){

                    public scala.math.BigDecimal value(int i) {
                        return this.reader().getScalaDecimal(i);
                    }
                };
            }
        }
        if (tuple2 != null) {
            AgnosticEncoder agnosticEncoder16 = (AgnosticEncoder)tuple2._1();
            Object v = tuple2._2();
            if (agnosticEncoder16 instanceof AgnosticEncoders.JavaDecimalEncoder && v instanceof FieldVector) {
                FieldVector fieldVector = (FieldVector)v;
                return new ArrowDeserializers.LeafFieldDeserializer<BigDecimal>(encoder, fieldVector, timeZoneId){

                    public BigDecimal value(int i) {
                        return this.reader().getJavaDecimal(i);
                    }
                };
            }
        }
        if (tuple2 != null) {
            AgnosticEncoder agnosticEncoder17 = (AgnosticEncoder)tuple2._1();
            Object v = tuple2._2();
            if (AgnosticEncoders.ScalaBigIntEncoder$.MODULE$.equals(agnosticEncoder17) && v instanceof FieldVector) {
                FieldVector fieldVector = (FieldVector)v;
                return new ArrowDeserializers.LeafFieldDeserializer<BigInt>(encoder, fieldVector, timeZoneId){

                    public BigInt value(int i) {
                        return this.reader().getScalaBigInt(i);
                    }
                };
            }
        }
        if (tuple2 != null) {
            AgnosticEncoder agnosticEncoder18 = (AgnosticEncoder)tuple2._1();
            Object v = tuple2._2();
            if (AgnosticEncoders.JavaBigIntEncoder$.MODULE$.equals(agnosticEncoder18) && v instanceof FieldVector) {
                FieldVector fieldVector = (FieldVector)v;
                return new ArrowDeserializers.LeafFieldDeserializer<BigInteger>(encoder, fieldVector, timeZoneId){

                    public BigInteger value(int i) {
                        return this.reader().getJavaBigInt(i);
                    }
                };
            }
        }
        if (tuple2 != null) {
            AgnosticEncoder agnosticEncoder19 = (AgnosticEncoder)tuple2._1();
            Object v = tuple2._2();
            if (AgnosticEncoders.DayTimeIntervalEncoder$.MODULE$.equals(agnosticEncoder19) && v instanceof FieldVector) {
                FieldVector fieldVector = (FieldVector)v;
                return new ArrowDeserializers.LeafFieldDeserializer<Duration>(encoder, fieldVector, timeZoneId){

                    public Duration value(int i) {
                        return this.reader().getDuration(i);
                    }
                };
            }
        }
        if (tuple2 != null) {
            AgnosticEncoder agnosticEncoder20 = (AgnosticEncoder)tuple2._1();
            Object v = tuple2._2();
            if (AgnosticEncoders.YearMonthIntervalEncoder$.MODULE$.equals(agnosticEncoder20) && v instanceof FieldVector) {
                FieldVector fieldVector = (FieldVector)v;
                return new ArrowDeserializers.LeafFieldDeserializer<Period>(encoder, fieldVector, timeZoneId){

                    public Period value(int i) {
                        return this.reader().getPeriod(i);
                    }
                };
            }
        }
        if (tuple2 != null) {
            AgnosticEncoder agnosticEncoder21 = (AgnosticEncoder)tuple2._1();
            Object v = tuple2._2();
            if (agnosticEncoder21 instanceof AgnosticEncoders.DateEncoder && v instanceof FieldVector) {
                FieldVector fieldVector = (FieldVector)v;
                return new ArrowDeserializers.LeafFieldDeserializer<Date>(encoder, fieldVector, timeZoneId){

                    public Date value(int i) {
                        return this.reader().getDate(i);
                    }
                };
            }
        }
        if (tuple2 != null) {
            AgnosticEncoder agnosticEncoder22 = (AgnosticEncoder)tuple2._1();
            Object v = tuple2._2();
            if (agnosticEncoder22 instanceof AgnosticEncoders.LocalDateEncoder && v instanceof FieldVector) {
                FieldVector fieldVector = (FieldVector)v;
                return new ArrowDeserializers.LeafFieldDeserializer<LocalDate>(encoder, fieldVector, timeZoneId){

                    public LocalDate value(int i) {
                        return this.reader().getLocalDate(i);
                    }
                };
            }
        }
        if (tuple2 != null) {
            AgnosticEncoder agnosticEncoder23 = (AgnosticEncoder)tuple2._1();
            Object v = tuple2._2();
            if (agnosticEncoder23 instanceof AgnosticEncoders.TimestampEncoder && v instanceof FieldVector) {
                FieldVector fieldVector = (FieldVector)v;
                return new ArrowDeserializers.LeafFieldDeserializer<Timestamp>(encoder, fieldVector, timeZoneId){

                    public Timestamp value(int i) {
                        return this.reader().getTimestamp(i);
                    }
                };
            }
        }
        if (tuple2 != null) {
            AgnosticEncoder agnosticEncoder24 = (AgnosticEncoder)tuple2._1();
            Object v = tuple2._2();
            if (agnosticEncoder24 instanceof AgnosticEncoders.InstantEncoder && v instanceof FieldVector) {
                FieldVector fieldVector = (FieldVector)v;
                return new ArrowDeserializers.LeafFieldDeserializer<Instant>(encoder, fieldVector, timeZoneId){

                    public Instant value(int i) {
                        return this.reader().getInstant(i);
                    }
                };
            }
        }
        if (tuple2 != null) {
            AgnosticEncoder agnosticEncoder25 = (AgnosticEncoder)tuple2._1();
            Object v = tuple2._2();
            if (AgnosticEncoders.LocalDateTimeEncoder$.MODULE$.equals(agnosticEncoder25) && v instanceof FieldVector) {
                FieldVector fieldVector = (FieldVector)v;
                return new ArrowDeserializers.LeafFieldDeserializer<LocalDateTime>(encoder, fieldVector, timeZoneId){

                    public LocalDateTime value(int i) {
                        return this.reader().getLocalDateTime(i);
                    }
                };
            }
        }
        if (tuple2 != null) {
            AgnosticEncoder agnosticEncoder26 = (AgnosticEncoder)tuple2._1();
            Object v = tuple2._2();
            if (agnosticEncoder26 instanceof AgnosticEncoders.OptionEncoder) {
                AgnosticEncoders.OptionEncoder optionEncoder = (AgnosticEncoders.OptionEncoder)agnosticEncoder26;
                AgnosticEncoder value2 = optionEncoder.elementEncoder();
                ArrowDeserializers.Deserializer<Object> deserializer = this.deserializerFor(value2, v, timeZoneId);
                return new ArrowDeserializers.Deserializer<Object>(deserializer){
                    private final ArrowDeserializers.Deserializer deserializer$1;

                    public Object get(int i) {
                        return Option$.MODULE$.apply(this.deserializer$1.get(i));
                    }
                    {
                        this.deserializer$1 = deserializer$1;
                    }
                };
            }
        }
        if (tuple2 != null) {
            AgnosticEncoder agnosticEncoder27 = (AgnosticEncoder)tuple2._1();
            Object v = tuple2._2();
            if (agnosticEncoder27 instanceof AgnosticEncoders.ArrayEncoder) {
                AgnosticEncoders.ArrayEncoder arrayEncoder = (AgnosticEncoders.ArrayEncoder)agnosticEncoder27;
                AgnosticEncoder element = arrayEncoder.element();
                if (v instanceof ListVector) {
                    ListVector listVector = (ListVector)v;
                    ArrowDeserializers.Deserializer<Object> deserializer = this.deserializerFor(element, listVector.getDataVector(), timeZoneId);
                    return new ArrowDeserializers.VectorFieldDeserializer<Object, ListVector>(listVector, deserializer, element){
                        private final ArrowDeserializers.Deserializer deserializer$2;
                        private final AgnosticEncoder element$1;

                        public Object value(int i) {
                            return ArrowDeserializers$.MODULE$.org$apache$spark$sql$connect$client$arrow$ArrowDeserializers$$getArray((ListVector)this.vector(), i, this.deserializer$2, (ClassTag<Object>)this.element$1.clsTag());
                        }
                        {
                            this.deserializer$2 = deserializer$2;
                            this.element$1 = element$1;
                            super(x96$1);
                        }
                    };
                }
            }
        }
        if (tuple2 != null) {
            AgnosticEncoder agnosticEncoder28 = (AgnosticEncoder)tuple2._1();
            Object v = tuple2._2();
            if (agnosticEncoder28 instanceof AgnosticEncoders.IterableEncoder) {
                AgnosticEncoders.IterableEncoder iterableEncoder = (AgnosticEncoders.IterableEncoder)agnosticEncoder28;
                ClassTag tag = iterableEncoder.clsTag();
                AgnosticEncoder element = iterableEncoder.element();
                if (v instanceof ListVector) {
                    ListVector listVector = (ListVector)v;
                    ArrowDeserializers.Deserializer<Object> deserializer = this.deserializerFor(element, listVector.getDataVector(), timeZoneId);
                    if (ArrowEncoderUtils$.MODULE$.isSubClass(ArrowEncoderUtils$Classes$.MODULE$.MUTABLE_ARRAY_SEQ(), tag)) {
                        return new ArrowDeserializers.VectorFieldDeserializer<scala.collection.mutable.ArraySeq<Object>, ListVector>(listVector, deserializer, element){
                            private final ArrowDeserializers.Deserializer deserializer$3;
                            private final AgnosticEncoder element$2;

                            public scala.collection.mutable.ArraySeq<Object> value(int i) {
                                Object array = ArrowDeserializers$.MODULE$.org$apache$spark$sql$connect$client$arrow$ArrowDeserializers$$getArray((ListVector)this.vector(), i, this.deserializer$3, (ClassTag<Object>)this.element$2.clsTag());
                                return ScalaCollectionUtils$.MODULE$.wrap(array);
                            }
                            {
                                this.deserializer$3 = deserializer$3;
                                this.element$2 = element$2;
                                super(x101$1);
                            }
                        };
                    }
                    if (ArrowEncoderUtils$.MODULE$.isSubClass(ArrowEncoderUtils$Classes$.MODULE$.IMMUTABLE_ARRAY_SEQ(), tag)) {
                        return new ArrowDeserializers.VectorFieldDeserializer<ArraySeq<Object>, ListVector>(listVector, deserializer, element){
                            private final ArrowDeserializers.Deserializer deserializer$3;
                            private final AgnosticEncoder element$2;

                            public ArraySeq<Object> value(int i) {
                                Object array = ArrowDeserializers$.MODULE$.org$apache$spark$sql$connect$client$arrow$ArrowDeserializers$$getArray((ListVector)this.vector(), i, this.deserializer$3, (ClassTag<Object>)this.element$2.clsTag());
                                return ArrayImplicits$.MODULE$.SparkArrayOps(array).toImmutableArraySeq();
                            }
                            {
                                this.deserializer$3 = deserializer$3;
                                this.element$2 = element$2;
                                super(x101$1);
                            }
                        };
                    }
                    if (ArrowEncoderUtils$.MODULE$.isSubClass(ArrowEncoderUtils$Classes$.MODULE$.ITERABLE(), tag)) {
                        IterableFactory<Iterable> companion = ScalaCollectionUtils$.MODULE$.getIterableCompanion(tag);
                        return new ArrowDeserializers.VectorFieldDeserializer<Iterable<Object>, ListVector>(listVector, companion, deserializer){
                            private final IterableFactory companion$1;
                            private final ArrowDeserializers.Deserializer deserializer$3;

                            public Iterable<Object> value(int i) {
                                Builder builder = this.companion$1.newBuilder();
                                ArrowDeserializers$.MODULE$.org$apache$spark$sql$connect$client$arrow$ArrowDeserializers$$loadListIntoBuilder((ListVector)this.vector(), i, this.deserializer$3, builder);
                                return (Iterable)builder.result();
                            }
                            {
                                this.companion$1 = companion$1;
                                this.deserializer$3 = deserializer$3;
                                super(x101$1);
                            }
                        };
                    }
                    if (ArrowEncoderUtils$.MODULE$.isSubClass(ArrowEncoderUtils$Classes$.MODULE$.JLIST(), tag)) {
                        Function1<Object, List<Object>> newInstance = this.resolveJavaListCreator(tag);
                        return new ArrowDeserializers.VectorFieldDeserializer<List<Object>, ListVector>(listVector, newInstance, deserializer){
                            private final ListVector x101$1;
                            private final Function1 newInstance$1;
                            private final ArrowDeserializers.Deserializer deserializer$3;

                            public List<Object> value(int i) {
                                int index;
                                int end = this.x101$1.getElementEndIndex(i);
                                List list = (List)this.newInstance$1.apply((Object)BoxesRunTime.boxToInteger((int)(end - index)));
                                for (index = this.x101$1.getElementStartIndex(i); index < end; ++index) {
                                    list.add(this.deserializer$3.get(index));
                                }
                                return list;
                            }
                            {
                                this.x101$1 = x101$1;
                                this.newInstance$1 = newInstance$1;
                                this.deserializer$3 = deserializer$3;
                                super(x101$1);
                            }
                        };
                    }
                    throw ArrowEncoderUtils$.MODULE$.unsupportedCollectionType(tag.runtimeClass());
                }
            }
        }
        if (tuple2 != null) {
            AgnosticEncoder agnosticEncoder29 = (AgnosticEncoder)tuple2._1();
            Object v = tuple2._2();
            if (agnosticEncoder29 instanceof AgnosticEncoders.MapEncoder) {
                AgnosticEncoders.MapEncoder mapEncoder = (AgnosticEncoders.MapEncoder)agnosticEncoder29;
                ClassTag tag = mapEncoder.clsTag();
                AgnosticEncoder key = mapEncoder.keyEncoder();
                AgnosticEncoder value3 = mapEncoder.valueEncoder();
                if (v instanceof MapVector) {
                    MapVector mapVector = (MapVector)v;
                    StructVector structVector = (StructVector)mapVector.getDataVector();
                    ArrowDeserializers.Deserializer<Object> keyDeserializer = this.deserializerFor(key, structVector.getChild("key"), timeZoneId);
                    ArrowDeserializers.Deserializer<Object> valueDeserializer = this.deserializerFor(value3, structVector.getChild("value"), timeZoneId);
                    if (ArrowEncoderUtils$.MODULE$.isSubClass(ArrowEncoderUtils$Classes$.MODULE$.MAP(), tag)) {
                        MapFactory<scala.collection.immutable.Map> companion = ScalaCollectionUtils$.MODULE$.getMapCompanion(tag);
                        return new ArrowDeserializers.VectorFieldDeserializer<scala.collection.immutable.Map<Object, Object>, MapVector>(mapVector, companion, keyDeserializer, valueDeserializer){
                            private final MapFactory companion$2;
                            private final MapVector x105$1;
                            private final ArrowDeserializers.Deserializer keyDeserializer$1;
                            private final ArrowDeserializers.Deserializer valueDeserializer$1;

                            public scala.collection.immutable.Map<Object, Object> value(int i) {
                                int index;
                                Builder builder = this.companion$2.newBuilder();
                                int end = this.x105$1.getElementEndIndex(i);
                                builder.sizeHint(end - index);
                                for (index = this.x105$1.getElementStartIndex(i); index < end; ++index) {
                                    builder.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(this.keyDeserializer$1.get(index)), this.valueDeserializer$1.get(index)));
                                }
                                return (scala.collection.immutable.Map)builder.result();
                            }
                            {
                                this.companion$2 = companion$2;
                                this.x105$1 = x105$1;
                                this.keyDeserializer$1 = keyDeserializer$1;
                                this.valueDeserializer$1 = valueDeserializer$1;
                                super(x105$1);
                            }
                        };
                    }
                    if (ArrowEncoderUtils$.MODULE$.isSubClass(ArrowEncoderUtils$Classes$.MODULE$.JMAP(), tag)) {
                        Function0<Map<Object, Object>> newInstance = this.resolveJavaMapCreator(tag);
                        return new ArrowDeserializers.VectorFieldDeserializer<Map<Object, Object>, MapVector>(mapVector, newInstance, keyDeserializer, valueDeserializer){
                            private final Function0 newInstance$2;
                            private final MapVector x105$1;
                            private final ArrowDeserializers.Deserializer keyDeserializer$1;
                            private final ArrowDeserializers.Deserializer valueDeserializer$1;

                            public Map<Object, Object> value(int i) {
                                Map map = (Map)this.newInstance$2.apply();
                                int end = this.x105$1.getElementEndIndex(i);
                                for (int index = this.x105$1.getElementStartIndex(i); index < end; ++index) {
                                    map.put(this.keyDeserializer$1.get(index), this.valueDeserializer$1.get(index));
                                }
                                return map;
                            }
                            {
                                this.newInstance$2 = newInstance$2;
                                this.x105$1 = x105$1;
                                this.keyDeserializer$1 = keyDeserializer$1;
                                this.valueDeserializer$1 = valueDeserializer$1;
                                super(x105$1);
                            }
                        };
                    }
                    throw ArrowEncoderUtils$.MODULE$.unsupportedCollectionType(tag.runtimeClass());
                }
            }
        }
        if (tuple2 != null) {
            AgnosticEncoder agnosticEncoder30 = (AgnosticEncoder)tuple2._1();
            Object object = tuple2._2();
            if (agnosticEncoder30 instanceof AgnosticEncoders.ProductEncoder) {
                Option<Tuple2<StructVector, Seq<FieldVector>>> option;
                AgnosticEncoders.ProductEncoder productEncoder = (AgnosticEncoders.ProductEncoder)agnosticEncoder30;
                ClassTag tag = productEncoder.clsTag();
                Seq fields = productEncoder.fields();
                Option outerPointerGetter = productEncoder.outerPointerGetter();
                if (object != null && !(option = StructVectors$.MODULE$.unapply(object)).isEmpty()) {
                    Seq seq;
                    StructVector struct = (StructVector)((Tuple2)option.get())._1();
                    Seq vectors = (Seq)((Tuple2)option.get())._2();
                    Seq outer = Option$.MODULE$.option2Iterable(outerPointerGetter.map((Function1 & Serializable)x$1 -> x$1.apply())).toSeq();
                    Option option2 = ScalaReflection$.MODULE$.findConstructor(tag.runtimeClass(), (Seq)((IterableOps)outer.map((Function1 & Serializable)x$2 -> x$2.getClass())).$plus$plus((IterableOnce)fields.map((Function1 & Serializable)x$3 -> x$3.enc().clsTag().runtimeClass())));
                    if (!(option2 instanceof Some)) {
                        throw new MatchError((Object)option2);
                    }
                    Some some = (Some)option2;
                    Function1 constructor = (Function1)some.value();
                    Function1 constructor2 = constructor;
                    if (this.isTuple(tag.runtimeClass())) {
                        seq = (Seq)((IterableOps)fields.zip((IterableOnce)vectors)).map((Function1 & Serializable)x0$1 -> {
                            Tuple2 tuple2 = x0$1;
                            if (tuple2 != null) {
                                AgnosticEncoders.EncoderField field = (AgnosticEncoders.EncoderField)tuple2._1();
                                FieldVector vector = (FieldVector)tuple2._2();
                                return MODULE$.deserializerFor(field.enc(), vector, timeZoneId);
                            }
                            throw new MatchError((Object)tuple2);
                        });
                    } else {
                        Seq outerDeserializer = (Seq)outer.map((Function1 & Serializable)value -> new ArrowDeserializers.Deserializer<Object>(value){
                            private final Object value$1;

                            public Object get(int i) {
                                return this.value$1;
                            }
                            {
                                this.value$1 = value$1;
                            }
                        });
                        Function1<String, FieldVector> lookup = this.createFieldLookup((Seq<FieldVector>)vectors);
                        seq = (Seq)outerDeserializer.$plus$plus((IterableOnce)fields.map((Function1 & Serializable)field -> MODULE$.deserializerFor(field.enc(), lookup.apply((Object)field.name()), timeZoneId)));
                    }
                    Seq deserializers = seq;
                    return new ArrowDeserializers.StructFieldSerializer<Object>(struct, constructor2, deserializers){
                        private final Function1 constructor$1;
                        private final Seq deserializers$1;

                        public Object value(int i) {
                            return this.constructor$1.apply(this.deserializers$1.map((Function1 & Serializable)x$4 -> x$4.get(i)));
                        }
                        {
                            this.constructor$1 = constructor$1;
                            this.deserializers$1 = deserializers$1;
                            super(struct$1);
                        }

                        private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                            return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$value$1(int org.apache.spark.sql.connect.client.arrow.ArrowDeserializers$Deserializer )}, serializedLambda);
                        }
                    };
                }
            }
        }
        if (tuple2 != null) {
            AgnosticEncoder r = (AgnosticEncoder)tuple2._1();
            Object object = tuple2._2();
            if (r instanceof AgnosticEncoders.RowEncoder) {
                Option<Tuple2<StructVector, Seq<FieldVector>>> option;
                AgnosticEncoders.RowEncoder rowEncoder = (AgnosticEncoders.RowEncoder)r;
                Seq fields = rowEncoder.fields();
                if (object != null && !(option = StructVectors$.MODULE$.unapply(object)).isEmpty()) {
                    StructVector struct = (StructVector)((Tuple2)option.get())._1();
                    Seq vectors = (Seq)((Tuple2)option.get())._2();
                    Function1<String, FieldVector> lookup = this.createFieldLookup((Seq<FieldVector>)vectors);
                    ArrowDeserializers.Deserializer[] deserializers = (ArrowDeserializers.Deserializer[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])fields.toArray(ClassTag$.MODULE$.apply(AgnosticEncoders.EncoderField.class))), (Function1 & Serializable)field -> MODULE$.deserializerFor(field.enc(), lookup.apply((Object)field.name()), timeZoneId), ClassTag$.MODULE$.apply(ArrowDeserializers.Deserializer.class));
                    return new ArrowDeserializers.StructFieldSerializer<Object>(struct, deserializers, rowEncoder){
                        private final ArrowDeserializers.Deserializer[] deserializers$2;
                        private final AgnosticEncoders.RowEncoder x111$1;

                        public Object value(int i) {
                            Object[] values = (Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])this.deserializers$2), (Function1 & Serializable)x$5 -> x$5.get(i), ClassTag$.MODULE$.Any());
                            return new GenericRowWithSchema(values, this.x111$1.schema());
                        }
                        {
                            this.deserializers$2 = deserializers$2;
                            this.x111$1 = x111$1;
                            super(struct$2);
                        }

                        private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                            return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$value$2(int org.apache.spark.sql.connect.client.arrow.ArrowDeserializers$Deserializer )}, serializedLambda);
                        }
                    };
                }
            }
        }
        if (tuple2 != null) {
            AgnosticEncoder agnosticEncoder31 = (AgnosticEncoder)tuple2._1();
            Object object = tuple2._2();
            if (agnosticEncoder31 instanceof AgnosticEncoders.JavaBeanEncoder) {
                Option<Tuple2<StructVector, Seq<FieldVector>>> option;
                AgnosticEncoders.JavaBeanEncoder javaBeanEncoder = (AgnosticEncoders.JavaBeanEncoder)agnosticEncoder31;
                ClassTag tag = javaBeanEncoder.clsTag();
                Seq fields = javaBeanEncoder.fields();
                if (object != null && !(option = StructVectors$.MODULE$.unapply(object)).isEmpty()) {
                    StructVector struct = (StructVector)((Tuple2)option.get())._1();
                    Seq vectors = (Seq)((Tuple2)option.get())._2();
                    MethodHandle constructor = this.methodLookup().findConstructor(tag.runtimeClass(), MethodType.methodType(BoxedUnit.TYPE));
                    Function1<String, FieldVector> lookup = this.createFieldLookup((Seq<FieldVector>)vectors);
                    Seq setters = (Seq)((IterableOps)fields.filter((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)ArrowDeserializers$.$anonfun$deserializerFor$8(x$6)))).map((Function1 & Serializable)field -> {
                        FieldVector vector = (FieldVector)lookup.apply((Object)field.name());
                        ArrowDeserializers.Deserializer<Object> deserializer = MODULE$.deserializerFor(field.enc(), vector, timeZoneId);
                        MethodHandle setter = MODULE$.methodLookup().findVirtual(tag.runtimeClass(), (String)field.writeMethod().get(), MethodType.methodType(BoxedUnit.TYPE, field.enc().clsTag().runtimeClass()));
                        return (Function2 & Serializable)(bean, i) -> setter.invoke(bean, deserializer.get(BoxesRunTime.unboxToInt((Object)i)));
                    });
                    return new ArrowDeserializers.StructFieldSerializer<Object>(struct, constructor, setters){
                        private final MethodHandle constructor$2;
                        private final Seq setters$1;

                        public Object value(int i) {
                            Object instance = this.constructor$2.invoke();
                            this.setters$1.foreach((Function1 & Serializable)x$7 -> x$7.apply(instance, (Object)BoxesRunTime.boxToInteger((int)i)));
                            return instance;
                        }
                        {
                            this.constructor$2 = constructor$2;
                            this.setters$1 = setters$1;
                            super(struct$3);
                        }

                        private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                            return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$value$3(java.lang.Object int scala.Function2 )}, serializedLambda);
                        }
                    };
                }
            }
        }
        if (tuple2 != null && (AgnosticEncoders.CalendarIntervalEncoder$.MODULE$.equals(agnosticEncoder = (AgnosticEncoder)tuple2._1()) ? true : agnosticEncoder instanceof AgnosticEncoders.UDTEncoder)) {
            throw ExecutionErrors$.MODULE$.unsupportedDataTypeError(encoder.dataType());
        }
        throw new RuntimeException("Unsupported Encoder(" + encoder + ")/Vector(" + data.getClass() + ") combination.");
    }

    private MethodHandles.Lookup methodLookup() {
        return methodLookup;
    }

    public <T> T resolveCompanion(ClassTag<?> tag) {
        JavaUniverse.JavaMirror mirror = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        Symbols.ModuleSymbolApi module = mirror.classSymbol((Object)tag.runtimeClass()).companion().asModule();
        return (T)mirror.reflectModule(module).instance();
    }

    private Function1<Object, List<Object>> resolveJavaListCreator(ClassTag<?> tag) {
        Function1 & Serializable intersect;
        Class cls = tag.runtimeClass();
        int modifiers = cls.getModifiers();
        if (Modifier.isInterface(modifiers) || Modifier.isAbstract(modifiers)) {
            if (!cls.isAssignableFrom(ArrayList.class)) {
                throw ArrowEncoderUtils$.MODULE$.unsupportedCollectionType(cls);
            }
            return (Function1 & Serializable)size -> ArrowDeserializers$.$anonfun$resolveJavaListCreator$1(BoxesRunTime.unboxToInt((Object)size));
        }
        try {
            MethodHandle ctor = this.methodLookup().findConstructor(tag.runtimeClass(), MethodType.methodType(BoxedUnit.TYPE, Integer.TYPE));
            intersect = (Function1 & Serializable)size -> ArrowDeserializers$.$anonfun$resolveJavaListCreator$2(ctor, BoxesRunTime.unboxToInt((Object)size));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            MethodHandle ctor = this.methodLookup().findConstructor(tag.runtimeClass(), MethodType.methodType(BoxedUnit.TYPE));
            intersect = (Function1 & Serializable)x$8 -> ArrowDeserializers$.$anonfun$resolveJavaListCreator$3(ctor, BoxesRunTime.unboxToInt((Object)x$8));
        }
        return intersect;
    }

    private Function0<Map<Object, Object>> resolveJavaMapCreator(ClassTag<?> tag) {
        Class cls = tag.runtimeClass();
        int modifiers = cls.getModifiers();
        if (Modifier.isInterface(modifiers) || Modifier.isAbstract(modifiers)) {
            if (!cls.isAssignableFrom(HashMap.class)) {
                throw ArrowEncoderUtils$.MODULE$.unsupportedCollectionType(cls);
            }
            return (Function0 & Serializable)() -> new HashMap();
        }
        MethodHandle ctor = this.methodLookup().findConstructor(tag.runtimeClass(), MethodType.methodType(BoxedUnit.TYPE));
        return (Function0 & Serializable)() -> (Map)ctor.invoke();
    }

    private Function1<String, FieldVector> createFieldLookup(Seq<FieldVector> fields) {
        scala.collection.mutable.Map lookup = (scala.collection.mutable.Map)Map$.MODULE$.empty();
        fields.foreach((Function1 & Serializable)field -> {
            ArrowDeserializers$.$anonfun$createFieldLookup$1(lookup, fields, field);
            return BoxedUnit.UNIT;
        });
        return (Function1 & Serializable)name -> (FieldVector)lookup.getOrElse((Object)ArrowDeserializers$.toKey$1(name), (Function0 & Serializable)() -> {
            throw CompilationErrors$.MODULE$.columnNotFoundError(name);
        });
    }

    private boolean isTuple(Class<?> cls) {
        return cls.getName().startsWith("scala.Tuple");
    }

    public void org$apache$spark$sql$connect$client$arrow$ArrowDeserializers$$loadListIntoBuilder(ListVector v, int i, ArrowDeserializers.Deserializer<Object> deserializer, Builder<Object, ?> builder) {
        int index;
        int end = v.getElementEndIndex(i);
        builder.sizeHint(end - index);
        for (index = v.getElementStartIndex(i); index < end; ++index) {
            builder.$plus$eq(deserializer.get(index));
        }
    }

    public Object org$apache$spark$sql$connect$client$arrow$ArrowDeserializers$$getArray(ListVector v, int i, ArrowDeserializers.Deserializer<Object> deserializer, ClassTag<Object> tag) {
        ArrayBuilder builder = ArrayBuilder$.MODULE$.make(tag);
        this.org$apache$spark$sql$connect$client$arrow$ArrowDeserializers$$loadListIntoBuilder(v, i, deserializer, (Builder<Object, ?>)builder);
        return builder.result();
    }

    public static final /* synthetic */ boolean $anonfun$deserializerFor$8(AgnosticEncoders.EncoderField x$6) {
        return x$6.writeMethod().isDefined();
    }

    public static final /* synthetic */ ArrayList $anonfun$resolveJavaListCreator$1(int size) {
        return new ArrayList(size);
    }

    public static final /* synthetic */ List $anonfun$resolveJavaListCreator$2(MethodHandle ctor$1, int size) {
        return (List)ctor$1.invoke(size);
    }

    public static final /* synthetic */ List $anonfun$resolveJavaListCreator$3(MethodHandle ctor$2, int x$8) {
        return (List)ctor$2.invoke();
    }

    private static final String toKey$1(String k) {
        return k.toLowerCase(Locale.ROOT);
    }

    public static final /* synthetic */ boolean $anonfun$createFieldLookup$2(String key$1, FieldVector f) {
        String string = ArrowDeserializers$.toKey$1(f.getName());
        String string2 = key$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$createFieldLookup$1(scala.collection.mutable.Map lookup$4, Seq fields$1, FieldVector field) {
        String key = ArrowDeserializers$.toKey$1(field.getName());
        Option old = lookup$4.put((Object)key, (Object)field);
        if (old.isDefined()) {
            String string = field.getName();
            throw CompilationErrors$.MODULE$.ambiguousColumnOrFieldError((Seq)Nil$.MODULE$.$colon$colon((Object)string), fields$1.count((Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)ArrowDeserializers$.$anonfun$createFieldLookup$2(key, f))));
        }
    }

    private ArrowDeserializers$() {
    }
}

