/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connect.common;

import java.io.Serializable;
import java.text.NumberFormat;
import java.util.List;
import org.sparkproject.connect.protobuf.ByteString;
import org.sparkproject.connect.protobuf.Descriptors;
import org.sparkproject.connect.protobuf.Message;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005Ma!\u0002\n\u0014\u0001Uy\u0002\u0002C\u001a\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001b\t\u000b\t\u0003A\u0011A\"\t\u000f\u001d\u0003!\u0019!C\u0005\u0011\"1\u0011\u000b\u0001Q\u0001\n%CqA\u0015\u0001C\u0002\u0013%1\u000b\u0003\u0004U\u0001\u0001\u0006Ia\u0010\u0005\b+\u0002\u0011\r\u0011\"\u0003T\u0011\u00191\u0006\u0001)A\u0005\u007f!9q\u000b\u0001b\u0001\n\u0013\u0019\u0006B\u0002-\u0001A\u0003%q\bC\u0004Z\u0001\t\u0007I\u0011B*\t\ri\u0003\u0001\u0015!\u0003@\u0011\u0015Y\u0006\u0001\"\u0001]\u0011\u0015\u0011\b\u0001\"\u0003t\u0011\u00151\b\u0001\"\u0003x\u0011\u00151\b\u0001\"\u0003~\u0011\u001d\tY\u0001\u0001C\u0005\u0003\u001b\u00111\"\u00112ce\u00164\u0018.\u0019;pe*\u0011A#F\u0001\u0007G>lWn\u001c8\u000b\u0005Y9\u0012aB2p]:,7\r\u001e\u0006\u00031e\t1a]9m\u0015\tQ2$A\u0003ta\u0006\u00148N\u0003\u0002\u001d;\u00051\u0011\r]1dQ\u0016T\u0011AH\u0001\u0004_J<7c\u0001\u0001!MA\u0011\u0011\u0005J\u0007\u0002E)\t1%A\u0003tG\u0006d\u0017-\u0003\u0002&E\t1\u0011I\\=SK\u001a\u0004\"a\n\u0019\u000f\u0005!rcBA\u0015.\u001b\u0005Q#BA\u0016-\u0003\u0019a$o\\8u}\r\u0001\u0011\"A\u0012\n\u0005=\u0012\u0013a\u00029bG.\fw-Z\u0005\u0003cI\u0012AbU3sS\u0006d\u0017N_1cY\u0016T!a\f\u0012\u0002\u0015QD'/Z:i_2$7\u000f\u0005\u00036sqzdB\u0001\u001c8!\tI#%\u0003\u00029E\u00051\u0001K]3eK\u001aL!AO\u001e\u0003\u00075\u000b\u0007O\u0003\u00029EA\u0011Q'P\u0005\u0003}m\u0012aa\u0015;sS:<\u0007CA\u0011A\u0013\t\t%EA\u0002J]R\fa\u0001P5oSRtDC\u0001#G!\t)\u0005!D\u0001\u0014\u0011\u0015\u0019$\u00011\u00015\u0003\u00191wN]7biV\t\u0011\n\u0005\u0002K\u001f6\t1J\u0003\u0002M\u001b\u0006!A/\u001a=u\u0015\u0005q\u0015\u0001\u00026bm\u0006L!\u0001U&\u0003\u00199+XNY3s\r>\u0014X.\u0019;\u0002\u000f\u0019|'/\\1uA\u0005qQ*\u0011-`\u0005f#ViU0T\u0013j+U#A \u0002\u001f5\u000b\u0005l\u0018\"Z)\u0016\u001bvlU%[\u000b\u0002\nq\"T!Y?N#&+\u0013(H?NK%,R\u0001\u0011\u001b\u0006Cvl\u0015+S\u0013:;ulU%[\u000b\u0002\nQ\"\\1y'R\u0014\u0018N\\4TSj,\u0017AD7bqN#(/\u001b8h'&TX\rI\u0001\r[\u0006D()\u001f;fgNK'0Z\u0001\u000e[\u0006D()\u001f;fgNK'0\u001a\u0011\u0002\u0015\u0005\u0014'M]3wS\u0006$X-\u0006\u0002^AR\u0011a\f\u001d\t\u0003?\u0002d\u0001\u0001B\u0003b\u001b\t\u0007!MA\u0001U#\t\u0019g\r\u0005\u0002\"I&\u0011QM\t\u0002\b\u001d>$\b.\u001b8h!\t9g.D\u0001i\u0015\tI'.\u0001\u0005qe>$xNY;g\u0015\tYG.\u0001\u0004h_><G.\u001a\u0006\u0002[\u0006\u00191m\\7\n\u0005=D'aB'fgN\fw-\u001a\u0005\u0006c6\u0001\rAX\u0001\b[\u0016\u001c8/Y4f\u00039!(/\u001e8dCR,7\u000b\u001e:j]\u001e$\"\u0001\u0010;\t\u000bUt\u0001\u0019\u0001\u001f\u0002\u0007M$(/A\u0007ueVt7-\u0019;f\u0005f$Xm\u001d\u000b\u0003qn\u0004\"aZ=\n\u0005iD'A\u0003\"zi\u0016\u001cFO]5oO\")Ap\u0004a\u0001q\u0006)!-\u001f;fgR\u0011\u0001P \u0005\u0006yB\u0001\ra \t\u0006C\u0005\u0005\u0011QA\u0005\u0004\u0003\u0007\u0011#!B!se\u0006L\bcA\u0011\u0002\b%\u0019\u0011\u0011\u0002\u0012\u0003\t\tKH/Z\u0001\u0011Ef$Xm\u0015;sS:<7+\u001e4gSb$2\u0001_A\b\u0011\u0019\t\t\"\u0005a\u0001\u007f\u0005!1/\u001b>f\u0001")
public class Abbreviator
implements Serializable {
    private final NumberFormat format = NumberFormat.getInstance();
    private final int MAX_BYTES_SIZE;
    private final int MAX_STRING_SIZE;
    private final int maxStringSize;
    private final int maxBytesSize;

    private NumberFormat format() {
        return this.format;
    }

    private int MAX_BYTES_SIZE() {
        return this.MAX_BYTES_SIZE;
    }

    private int MAX_STRING_SIZE() {
        return this.MAX_STRING_SIZE;
    }

    private int maxStringSize() {
        return this.maxStringSize;
    }

    private int maxBytesSize() {
        return this.maxBytesSize;
    }

    public <T extends Message> T abbreviate(T message) {
        Message.Builder builder = message.toBuilder();
        CollectionConverters$.MODULE$.MapHasAsScala(message.getAllFields()).asScala().iterator().foreach((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Descriptors.FieldDescriptor field = (Descriptors.FieldDescriptor)tuple2._1();
                Object string = tuple2._2();
                if (string instanceof String) {
                    String string2 = (String)string;
                    Descriptors.FieldDescriptor.JavaType javaType = field.getJavaType();
                    Descriptors.FieldDescriptor.JavaType javaType2 = Descriptors.FieldDescriptor.JavaType.STRING;
                    if (!(javaType != null ? !((Object)((Object)javaType)).equals((Object)javaType2) : javaType2 != null)) {
                        if (!field.isRepeated() && string2 != null && string2.length() > this.maxStringSize()) {
                            return builder.setField(field, this.truncateString(string2));
                        }
                    }
                }
            }
            if (tuple2 != null) {
                Descriptors.FieldDescriptor field = (Descriptors.FieldDescriptor)tuple2._1();
                Object strings = tuple2._2();
                if (strings instanceof List) {
                    List list = (List)strings;
                    Descriptors.FieldDescriptor.JavaType javaType = field.getJavaType();
                    Descriptors.FieldDescriptor.JavaType javaType3 = Descriptors.FieldDescriptor.JavaType.STRING;
                    if (!(javaType != null ? !((Object)((Object)javaType)).equals((Object)javaType3) : javaType3 != null)) {
                        if (field.isRepeated() && list != null && !list.isEmpty()) {
                            CollectionConverters$.MODULE$.IteratorHasAsScala(list.iterator()).asScala().zipWithIndex().foreach((Function1 & Serializable)x0$2 -> {
                                Tuple2 tuple2 = x0$2;
                                if (tuple2 != null) {
                                    String string;
                                    Object string2 = tuple2._1();
                                    int i = tuple2._2$mcI$sp();
                                    if (string2 instanceof String && (string = (String)string2) != null && string.length() > this.maxStringSize()) {
                                        return builder.setRepeatedField(field, i, this.truncateString(string));
                                    }
                                }
                                return BoxedUnit.UNIT;
                            });
                            return BoxedUnit.UNIT;
                        }
                    }
                }
            }
            if (tuple2 != null) {
                Descriptors.FieldDescriptor field = (Descriptors.FieldDescriptor)tuple2._1();
                Object bytes = tuple2._2();
                if (bytes instanceof ByteString) {
                    ByteString byteString = (ByteString)bytes;
                    Descriptors.FieldDescriptor.JavaType javaType = field.getJavaType();
                    Descriptors.FieldDescriptor.JavaType javaType4 = Descriptors.FieldDescriptor.JavaType.BYTE_STRING;
                    if (!(javaType != null ? !((Object)((Object)javaType)).equals((Object)javaType4) : javaType4 != null)) {
                        if (!field.isRepeated() && byteString != null && byteString.size() > this.maxBytesSize()) {
                            return builder.setField(field, this.truncateBytes(byteString));
                        }
                    }
                }
            }
            if (tuple2 != null) {
                Descriptors.FieldDescriptor field = (Descriptors.FieldDescriptor)tuple2._1();
                Object bytes = tuple2._2();
                if (bytes instanceof byte[]) {
                    byte[] byArray = (byte[])bytes;
                    Descriptors.FieldDescriptor.JavaType javaType = field.getJavaType();
                    Descriptors.FieldDescriptor.JavaType javaType5 = Descriptors.FieldDescriptor.JavaType.BYTE_STRING;
                    if (!(javaType != null ? !((Object)((Object)javaType)).equals((Object)javaType5) : javaType5 != null)) {
                        if (!field.isRepeated() && byArray != null && byArray.length > this.maxBytesSize()) {
                            return builder.setField(field, this.truncateBytes(byArray));
                        }
                    }
                }
            }
            if (tuple2 != null) {
                Descriptors.FieldDescriptor field = (Descriptors.FieldDescriptor)tuple2._1();
                Object msg = tuple2._2();
                if (msg instanceof Message) {
                    Message message = (Message)msg;
                    Descriptors.FieldDescriptor.JavaType javaType = field.getJavaType();
                    Descriptors.FieldDescriptor.JavaType javaType6 = Descriptors.FieldDescriptor.JavaType.MESSAGE;
                    if (!(javaType != null ? !((Object)((Object)javaType)).equals((Object)javaType6) : javaType6 != null)) {
                        if (!field.isRepeated() && message != null) {
                            return builder.setField(field, this.abbreviate(message));
                        }
                    }
                }
            }
            if (tuple2 != null) {
                Descriptors.FieldDescriptor field = (Descriptors.FieldDescriptor)tuple2._1();
                Object msgs = tuple2._2();
                if (msgs instanceof List) {
                    List list = (List)msgs;
                    Descriptors.FieldDescriptor.JavaType javaType = field.getJavaType();
                    Descriptors.FieldDescriptor.JavaType javaType7 = Descriptors.FieldDescriptor.JavaType.MESSAGE;
                    if (!(javaType != null ? !((Object)((Object)javaType)).equals((Object)javaType7) : javaType7 != null)) {
                        if (field.isRepeated() && list != null && !list.isEmpty()) {
                            CollectionConverters$.MODULE$.IteratorHasAsScala(list.iterator()).asScala().zipWithIndex().foreach((Function1 & Serializable)x0$3 -> {
                                Tuple2 tuple2 = x0$3;
                                if (tuple2 != null) {
                                    Message message;
                                    Object msg = tuple2._1();
                                    int i = tuple2._2$mcI$sp();
                                    if (msg instanceof Message && (message = (Message)msg) != null) {
                                        return builder.setRepeatedField(field, i, this.abbreviate(message));
                                    }
                                }
                                return BoxedUnit.UNIT;
                            });
                            return BoxedUnit.UNIT;
                        }
                    }
                }
            }
            return BoxedUnit.UNIT;
        });
        return (T)builder.build();
    }

    private String truncateString(String str) {
        return StringOps$.MODULE$.take$extension(Predef$.MODULE$.augmentString(str), this.maxStringSize()) + "[truncated(size=" + this.format().format(str.length()) + ")]";
    }

    private ByteString truncateBytes(ByteString bytes) {
        return bytes.substring(0, this.maxBytesSize()).concat(this.byteStringSuffix(bytes.size()));
    }

    private ByteString truncateBytes(byte[] bytes) {
        return ByteString.copyFrom(bytes, 0, this.maxBytesSize()).concat(this.byteStringSuffix(bytes.length));
    }

    private ByteString byteStringSuffix(int size) {
        return ByteString.copyFromUtf8("[truncated(size=" + this.format().format(size) + ")]");
    }

    public Abbreviator(Map<String, Object> thresholds) {
        this.MAX_BYTES_SIZE = 8;
        this.MAX_STRING_SIZE = 1024;
        this.maxStringSize = BoxesRunTime.unboxToInt((Object)thresholds.getOrElse((Object)"STRING", (Function0)(JFunction0.mcI.sp & Serializable)() -> this.MAX_STRING_SIZE()));
        this.maxBytesSize = BoxesRunTime.unboxToInt((Object)thresholds.getOrElse((Object)"BYTES", (Function0)(JFunction0.mcI.sp & Serializable)() -> this.MAX_BYTES_SIZE()));
    }
}

