/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connect.execution;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.spark.SparkEnv$;
import org.apache.spark.connect.proto.ExecutePlanRequest;
import org.apache.spark.connect.proto.ExecutePlanResponse;
import org.apache.spark.connect.proto.Plan;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Dataset$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.QueryPlanningTracker;
import org.apache.spark.sql.connect.common.DataTypeProtoConverter$;
import org.apache.spark.sql.connect.config.Connect$;
import org.apache.spark.sql.connect.execution.ExecuteResponseObserver;
import org.apache.spark.sql.connect.execution.SparkConnectPlanExecution$;
import org.apache.spark.sql.connect.planner.SparkConnectPlanner;
import org.apache.spark.sql.connect.service.ExecuteHolder;
import org.apache.spark.sql.connect.service.SessionHolder;
import org.apache.spark.sql.connect.utils.MetricGenerator$;
import org.apache.spark.sql.execution.DoNotCleanup$;
import org.apache.spark.sql.execution.LocalTableScanExec;
import org.apache.spark.sql.execution.RemoveShuffleFiles$;
import org.apache.spark.sql.execution.SQLExecution$;
import org.apache.spark.sql.execution.ShuffleCleanupMode;
import org.apache.spark.sql.execution.SkipMigration$;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.arrow.ArrowConverters;
import org.apache.spark.sql.execution.arrow.ArrowConverters$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.ThreadUtils$;
import org.sparkproject.connect.grpc.stub.StreamObserver;
import org.sparkproject.connect.protobuf.ByteString;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.math.Integral;
import scala.math.Numeric;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0005\u0005=f!B\t\u0013\u0001Iq\u0002\u0002C\u0013\u0001\u0005\u0003\u0005\u000b\u0011B\u0014\t\u000b5\u0002A\u0011\u0001\u0018\t\u000fI\u0002!\u0019!C\u0005g!1q\u0007\u0001Q\u0001\nQBq\u0001\u000f\u0001C\u0002\u0013%\u0011\b\u0003\u0004?\u0001\u0001\u0006IA\u000f\u0005\u0006\u007f\u0001!\t\u0001Q\u0003\u0005!\u0002\u0001\u0011\u000bC\u0003^\u0001\u0011\u0005a\fC\u0004\u0002,\u0001!\t!!\f\t\u000f\u0005%\u0004\u0001\"\u0003\u0002l!9\u00111\u000f\u0001\u0005\n\u0005UtaBAA%!\u0005\u00111\u0011\u0004\u0007#IA\t!!\"\t\r5rA\u0011AAD\u0011\u001d\t\u0019H\u0004C\u0001\u0003\u0013\u0013\u0011d\u00159be.\u001cuN\u001c8fGR\u0004F.\u00198Fq\u0016\u001cW\u000f^5p]*\u00111\u0003F\u0001\nKb,7-\u001e;j_:T!!\u0006\f\u0002\u000f\r|gN\\3di*\u0011q\u0003G\u0001\u0004gFd'BA\r\u001b\u0003\u0015\u0019\b/\u0019:l\u0015\tYB$\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002;\u0005\u0019qN]4\u0014\u0005\u0001y\u0002C\u0001\u0011$\u001b\u0005\t#\"\u0001\u0012\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0011\n#AB!osJ+g-A\u0007fq\u0016\u001cW\u000f^3I_2$WM]\u0002\u0001!\tA3&D\u0001*\u0015\tQC#A\u0004tKJ4\u0018nY3\n\u00051J#!D#yK\u000e,H/\u001a%pY\u0012,'/\u0001\u0004=S:LGO\u0010\u000b\u0003_E\u0002\"\u0001\r\u0001\u000e\u0003IAQ!\n\u0002A\u0002\u001d\nQb]3tg&|g\u000eS8mI\u0016\u0014X#\u0001\u001b\u0011\u0005!*\u0014B\u0001\u001c*\u00055\u0019Vm]:j_:Du\u000e\u001c3fe\u0006q1/Z:tS>t\u0007j\u001c7eKJ\u0004\u0013aB:fgNLwN\\\u000b\u0002uA\u00111\bP\u0007\u0002-%\u0011QH\u0006\u0002\r'B\f'o[*fgNLwN\\\u0001\tg\u0016\u001c8/[8oA\u0005Q\u0001.\u00198eY\u0016\u0004F.\u00198\u0015\u0005\u0005#\u0005C\u0001\u0011C\u0013\t\u0019\u0015E\u0001\u0003V]&$\b\"B#\b\u0001\u00041\u0015\u0001\u0005:fgB|gn]3PEN,'O^3s!\r\u0001t)S\u0005\u0003\u0011J\u0011q#\u0012=fGV$XMU3ta>t7/Z(cg\u0016\u0014h/\u001a:\u0011\u0005)sU\"A&\u000b\u00051k\u0015!\u00029s_R|'BA\u000b\u0019\u0013\ty5JA\nFq\u0016\u001cW\u000f^3QY\u0006t'+Z:q_:\u001cXMA\u0003CCR\u001c\u0007\u000e\u0005\u0003!%RS\u0016BA*\"\u0005\u0019!V\u000f\u001d7feA\u0019\u0001%V,\n\u0005Y\u000b#!B!se\u0006L\bC\u0001\u0011Y\u0013\tI\u0016E\u0001\u0003CsR,\u0007C\u0001\u0011\\\u0013\ta\u0016E\u0001\u0003M_:<\u0017a\u0005:poR{\u0017I\u001d:po\u000e{gN^3si\u0016\u0014H#C0x\u007f\u0006%\u0011QBA\u0011!\u0011\u0001\u0003M\u0019;\n\u0005\u0005\f#!\u0003$v]\u000e$\u0018n\u001c82!\r\u00197N\u001c\b\u0003I&t!!\u001a5\u000e\u0003\u0019T!a\u001a\u0014\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0011\u0013B\u00016\"\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001\\7\u0003\u0011%#XM]1u_JT!A[\u0011\u0011\u0005=\u0014X\"\u00019\u000b\u0005E4\u0012\u0001C2bi\u0006d\u0017p\u001d;\n\u0005M\u0004(aC%oi\u0016\u0014h.\u00197S_^\u00042aY6v!\t1\b\"D\u0001\u0001\u0011\u0015A\u0018\u00021\u0001z\u0003\u0019\u00198\r[3nCB\u0011!0`\u0007\u0002w*\u0011APF\u0001\u0006if\u0004Xm]\u0005\u0003}n\u0014!b\u0015;sk\u000e$H+\u001f9f\u0011\u001d\t\t!\u0003a\u0001\u0003\u0007\t!#\\1y%\u0016\u001cwN\u001d3t!\u0016\u0014()\u0019;dQB\u0019\u0001%!\u0002\n\u0007\u0005\u001d\u0011EA\u0002J]RDa!a\u0003\n\u0001\u0004Q\u0016\u0001D7bq\n\u000bGo\u00195TSj,\u0007bBA\b\u0013\u0001\u0007\u0011\u0011C\u0001\u000bi&lWMW8oK&#\u0007\u0003BA\n\u00037qA!!\u0006\u0002\u0018A\u0011Q-I\u0005\u0004\u00033\t\u0013A\u0002)sK\u0012,g-\u0003\u0003\u0002\u001e\u0005}!AB*ue&twMC\u0002\u0002\u001a\u0005Bq!a\t\n\u0001\u0004\t)#A\u000efeJ|'o\u00148EkBd\u0017nY1uK\u00124\u0015.\u001a7e\u001d\u0006lWm\u001d\t\u0004A\u0005\u001d\u0012bAA\u0015C\t9!i\\8mK\u0006t\u0017!\u00069s_\u000e,7o]!t\u0003J\u0014xn\u001e\"bi\u000eDWm\u001d\u000b\b\u0003\u0006=\u0012qJA3\u0011\u001d\t\tD\u0003a\u0001\u0003g\t\u0011\u0002Z1uC\u001a\u0014\u0018-\\3\u0011\t\u0005U\u0012\u0011\n\b\u0005\u0003o\t9E\u0004\u0003\u0002:\u0005\u0015c\u0002BA\u001e\u0003\u0007rA!!\u0010\u0002B9\u0019Q-a\u0010\n\u0003uI!a\u0007\u000f\n\u0005eQ\u0012BA\f\u0019\u0013\tQg#\u0003\u0003\u0002L\u00055#!\u0003#bi\u00064%/Y7f\u0015\tQg\u0003\u0003\u0004F\u0015\u0001\u0007\u0011\u0011\u000b\t\u0006\u0003'\n\t'S\u0007\u0003\u0003+RA!a\u0016\u0002Z\u0005!1\u000f^;c\u0015\u0011\tY&!\u0018\u0002\t\u001d\u0014\bo\u0019\u0006\u0003\u0003?\n!![8\n\t\u0005\r\u0014Q\u000b\u0002\u000f'R\u0014X-Y7PEN,'O^3s\u0011\u0019\t9G\u0003a\u0001O\u0005YQ\r_3dkR,\u0007\u000b\\1o\u0003Q\u0019'/Z1uKN\u001b\u0007.Z7b%\u0016\u001c\bo\u001c8tKR)\u0011*!\u001c\u0002r!9\u0011qN\u0006A\u0002\u0005E\u0011!C:fgNLwN\\%e\u0011\u0015A8\u00021\u0001z\u0003u\u0019'/Z1uK>\u00137/\u001a:wK\u0012lU\r\u001e:jGN\u0014Vm\u001d9p]N,GCBA<\u0003{\ny\b\u0005\u0003!\u0003sJ\u0015bAA>C\t1q\n\u001d;j_:Dq!a\u001c\r\u0001\u0004\t\t\u0002C\u0004\u000221\u0001\r!a\r\u00023M\u0003\u0018M]6D_:tWm\u0019;QY\u0006tW\t_3dkRLwN\u001c\t\u0003a9\u0019\"AD\u0010\u0015\u0005\u0005\rE#C%\u0002\f\u00065\u0015\u0011SAK\u0011\u001d\ty\u0007\u0005a\u0001\u0003#Aq!a$\u0011\u0001\u0004\t\t\"A\btKJ4XM]*fgNLwN\\%e\u0011\u0019\t\u0019\n\u0005a\u00015\u00061\u0001\u000f\\1o\u0013\u0012Dq!a&\u0011\u0001\u0004\tI*A\u0004nKR\u0014\u0018nY:\u0011\u0011\u0005M\u00111TA\t\u0003?KA!!(\u0002 \t\u0019Q*\u00199\u0011\u000b\r\f\t+!*\n\u0007\u0005\rVNA\u0002TKF\u0004b\u0001\t*\u0002(\u0006%\u0006#\u0002\u0011\u0002z\u0005E\u0001c\u0001\u0011\u0002,&\u0019\u0011QV\u0011\u0003\u0007\u0005s\u0017\u0010")
public class SparkConnectPlanExecution {
    public final ExecuteHolder org$apache$spark$sql$connect$execution$SparkConnectPlanExecution$$executeHolder;
    private final SessionHolder sessionHolder;
    private final SparkSession session;

    private SessionHolder sessionHolder() {
        return this.sessionHolder;
    }

    private SparkSession session() {
        return this.session;
    }

    public void handlePlan(ExecuteResponseObserver<ExecutePlanResponse> responseObserver) {
        ExecutePlanRequest request = this.org$apache$spark$sql$connect$execution$SparkConnectPlanExecution$$executeHolder.request();
        Plan.OpTypeCase opTypeCase = request.getPlan().getOpTypeCase();
        Plan.OpTypeCase opTypeCase2 = Plan.OpTypeCase.ROOT;
        if (opTypeCase == null ? opTypeCase2 != null : !opTypeCase.equals(opTypeCase2)) {
            throw new IllegalStateException("Illegal operation type " + request.getPlan().getOpTypeCase() + " to be handled here.");
        }
        SparkConnectPlanner planner = new SparkConnectPlanner(this.org$apache$spark$sql$connect$execution$SparkConnectPlanExecution$$executeHolder);
        QueryPlanningTracker tracker = this.org$apache$spark$sql$connect$execution$SparkConnectPlanExecution$$executeHolder.eventsManager().createQueryPlanningTracker();
        SQLConf conf = this.session().sessionState().conf();
        RemoveShuffleFiles$ shuffleCleanupMode = BoxesRunTime.unboxToBoolean((Object)conf.getConf(SQLConf$.MODULE$.SHUFFLE_DEPENDENCY_FILE_CLEANUP_ENABLED())) ? RemoveShuffleFiles$.MODULE$ : (BoxesRunTime.unboxToBoolean((Object)conf.getConf(SQLConf$.MODULE$.SHUFFLE_DEPENDENCY_SKIP_MIGRATION_ENABLED())) ? SkipMigration$.MODULE$ : DoNotCleanup$.MODULE$);
        Dataset dataframe = Dataset$.MODULE$.ofRows(this.sessionHolder().session(), planner.transformRelation(request.getPlan().getRoot(), true), tracker, (ShuffleCleanupMode)shuffleCleanupMode);
        responseObserver.onNext(this.createSchemaResponse(request.getSessionId(), dataframe.schema()));
        this.processAsArrowBatches((Dataset<Row>)dataframe, responseObserver, this.org$apache$spark$sql$connect$execution$SparkConnectPlanExecution$$executeHolder);
        responseObserver.onNext(MetricGenerator$.MODULE$.createMetricsResponse(this.sessionHolder(), (Dataset<Row>)dataframe));
        this.createObservedMetricsResponse(request.getSessionId(), (Dataset<Row>)dataframe).foreach((Function1 & Serializable)r -> {
            responseObserver.onNext(r);
            return BoxedUnit.UNIT;
        });
    }

    public Function1<Iterator<InternalRow>, Iterator<Tuple2<byte[], Object>>> rowToArrowConverter(StructType schema, int maxRecordsPerBatch, long maxBatchSize, String timeZoneId, boolean errorOnDuplicatedFieldNames) {
        return (Function1 & Serializable)rows -> {
            ArrowConverters.ArrowBatchWithSchemaIterator batches = ArrowConverters$.MODULE$.toBatchWithSchemaIterator(rows, schema, (long)maxRecordsPerBatch, maxBatchSize, timeZoneId, errorOnDuplicatedFieldNames);
            return batches.map((Function1 & Serializable)b -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(b), (Object)BoxesRunTime.boxToLong((long)batches.rowCountInLastBatch())));
        };
    }

    public void processAsArrowBatches(Dataset<Row> dataframe, StreamObserver<ExecutePlanResponse> responseObserver, ExecuteHolder executePlan) {
        String sessionId = executePlan.sessionHolder().sessionId();
        SparkSession spark = dataframe.sparkSession();
        StructType schema = dataframe.schema();
        int maxRecordsPerBatch = spark.sessionState().conf().arrowMaxRecordsPerBatch();
        String timeZoneId = spark.sessionState().conf().sessionLocalTimeZone();
        long maxBatchSize = (long)((double)BoxesRunTime.unboxToLong((Object)SparkEnv$.MODULE$.get().conf().get(Connect$.MODULE$.CONNECT_GRPC_ARROW_MAX_BATCH_SIZE())) * 0.7);
        Function1<Iterator<InternalRow>, Iterator<Tuple2<byte[], Object>>> converter = this.rowToArrowConverter(schema, maxRecordsPerBatch, maxBatchSize, timeZoneId, false);
        IntRef numSent = IntRef.create((int)0);
        SparkPlan sparkPlan = dataframe.queryExecution().executedPlan();
        if (sparkPlan instanceof LocalTableScanExec) {
            LocalTableScanExec localTableScanExec = (LocalTableScanExec)sparkPlan;
            Seq rows = localTableScanExec.rows();
            executePlan.eventsManager().postFinished((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)rows.length())), executePlan.eventsManager().postFinished$default$2());
            LongRef offset = LongRef.create((long)0L);
            ((IterableOnceOps)converter.apply((Object)rows.iterator())).foreach((Function1 & Serializable)x0$1 -> {
                SparkConnectPlanExecution.$anonfun$processAsArrowBatches$1(this, offset, sessionId, responseObserver, numSent, x0$1);
                return BoxedUnit.UNIT;
            });
        } else {
            SQLExecution$.MODULE$.withNewExecutionId(dataframe.queryExecution(), (Option)new Some((Object)"collectArrow"), (Function0 & Serializable)() -> {
                RDD rows = dataframe.queryExecution().executedPlan().execute();
                int numPartitions = rows.getNumPartitions();
                if (numPartitions > 0) {
                    RDD batches = rows.mapPartitionsInternal(converter, rows.mapPartitionsInternal$default$2(), ClassTag$.MODULE$.apply(Tuple2.class));
                    Object signal = new Object();
                    Tuple2[][] partitions = new Tuple2[numPartitions][];
                    IntRef numFinishedPartitions = IntRef.create((int)0);
                    LongRef totalNumRows = LongRef.create((long)0L);
                    ObjectRef error = ObjectRef.create((Object)None$.MODULE$);
                    Function2 & Serializable resultHandler = (Function2 & Serializable)(partitionId, partition) -> {
                        SparkConnectPlanExecution.$anonfun$processAsArrowBatches$3(signal, partitions, totalNumRows, numFinishedPartitions, numPartitions, executePlan, BoxesRunTime.unboxToInt((Object)partitionId), partition);
                        return BoxedUnit.UNIT;
                    };
                    Future future = spark.sparkContext().submitJob(batches, (Function1 & Serializable)iter -> (Tuple2[])iter.toArray(ClassTag$.MODULE$.apply(Tuple2.class)), (Seq)package$.MODULE$.Seq().range((Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)numPartitions), (Integral)Numeric.IntIsIntegral$.MODULE$), (Function2)resultHandler, (Function0 & Serializable)() -> (JFunction0.mcV.sp & Serializable)() -> {}).andThen((PartialFunction)new Serializable(null, signal, error){
                        private static final long serialVersionUID = 0L;
                        private final Object signal$1;
                        private final ObjectRef error$1;

                        public final <A1 extends Try<Function0<BoxedUnit>>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                            A1 A1 = x1;
                            if (A1 instanceof Success) {
                                return (B1)BoxedUnit.UNIT;
                            }
                            if (A1 instanceof Failure) {
                                Failure failure = (Failure)A1;
                                Throwable throwable = failure.exception();
                                Object object = this.signal$1;
                                synchronized (object) {
                                    this.error$1.elem = new Some((Object)throwable);
                                    this.signal$1.notify();
                                }
                                return (B1)BoxedUnit.UNIT;
                            }
                            return (B1)function1.apply(x1);
                        }

                        public final boolean isDefinedAt(Try<Function0<BoxedUnit>> x1) {
                            Try<Function0<BoxedUnit>> try_ = x1;
                            if (try_ instanceof Success) {
                                return true;
                            }
                            return try_ instanceof Failure;
                        }
                        {
                            this.signal$1 = signal$1;
                            this.error$1 = error$1;
                        }
                    }, (ExecutionContext)ThreadUtils$.MODULE$.sameThread());
                    LongRef currentOffset = LongRef.create((long)0L);
                    for (int currentPartitionId = 0; currentPartitionId < numPartitions; ++currentPartitionId) {
                        Tuple2[] tuple2Array;
                        Object object = signal;
                        synchronized (object) {
                            Tuple2[] part = partitions[currentPartitionId];
                            while (part == null && ((Option)error.elem).isEmpty()) {
                                signal.wait();
                                part = partitions[currentPartitionId];
                            }
                            partitions[currentPartitionId] = null;
                            ((Option)error.elem).foreach((Function1 & Serializable)other -> {
                                throw other;
                            });
                            tuple2Array = part;
                        }
                        Tuple2[] partition2 = tuple2Array;
                        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])partition2), (Function1 & Serializable)x0$2 -> {
                            SparkConnectPlanExecution.$anonfun$processAsArrowBatches$9(this, currentOffset, sessionId, responseObserver, numSent, x0$2);
                            return BoxedUnit.UNIT;
                        });
                    }
                    return ThreadUtils$.MODULE$.awaitReady((Awaitable)future, (Duration)Duration$.MODULE$.Inf());
                }
                executePlan.eventsManager().postFinished((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)0L)), executePlan.eventsManager().postFinished$default$2());
                return BoxedUnit.UNIT;
            });
        }
        if (numSent.elem == 0) {
            this.sendBatch$1(ArrowConverters$.MODULE$.createEmptyArrowBatch(schema, timeZoneId, false), 0L, 0L, sessionId, responseObserver, numSent);
            return;
        }
    }

    private ExecutePlanResponse createSchemaResponse(String sessionId, StructType schema) {
        return ExecutePlanResponse.newBuilder().setSessionId(sessionId).setServerSideSessionId(this.sessionHolder().serverSessionId()).setSchema(DataTypeProtoConverter$.MODULE$.toConnectProtoType((DataType)schema)).build();
    }

    private Option<ExecutePlanResponse> createObservedMetricsResponse(String sessionId, Dataset<Row> dataframe) {
        Map observedMetrics = (Map)dataframe.queryExecution().observedMetrics().collect((PartialFunction)new Serializable(this){
            private static final long serialVersionUID = 0L;
            private final /* synthetic */ SparkConnectPlanExecution $outer;

            public final <A1 extends Tuple2<String, Row>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 != null) {
                    String name = (String)A1._1();
                    Row row = (Row)A1._2();
                    if (!this.$outer.org$apache$spark$sql$connect$execution$SparkConnectPlanExecution$$executeHolder.observations().contains((Object)name)) {
                        IndexedSeq values = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), row.length()).map((Function1 & Serializable)i -> $anonfun$2.$anonfun$applyOrElse$1(row, BoxesRunTime.unboxToInt((Object)i)));
                        return (B1)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)name), (Object)values);
                    }
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Tuple2<String, Row> x1) {
                Tuple2<String, Row> tuple2 = x1;
                if (tuple2 != null) {
                    String name = (String)tuple2._1();
                    if (!this.$outer.org$apache$spark$sql$connect$execution$SparkConnectPlanExecution$$executeHolder.observations().contains((Object)name)) {
                        return true;
                    }
                }
                return false;
            }

            public static final /* synthetic */ Tuple2 $anonfun$applyOrElse$1(Row row$1, int i) {
                return new Tuple2(row$1.schema() != null ? new Some((Object)row$1.schema().fieldNames()[i]) : None$.MODULE$, row$1.apply(i));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1$adapted(org.apache.spark.sql.Row java.lang.Object )}, serializedLambda);
            }
        });
        if (observedMetrics.nonEmpty()) {
            long planId = this.org$apache$spark$sql$connect$execution$SparkConnectPlanExecution$$executeHolder.request().getPlan().getRoot().getCommon().getPlanId();
            return new Some((Object)SparkConnectPlanExecution$.MODULE$.createObservedMetricsResponse(sessionId, this.sessionHolder().serverSessionId(), planId, (Map<String, Seq<Tuple2<Option<String>, Object>>>)observedMetrics));
        }
        return None$.MODULE$;
    }

    private final void sendBatch$1(byte[] bytes, long count, long startOffset, String sessionId$1, StreamObserver responseObserver$2, IntRef numSent$1) {
        ExecutePlanResponse.Builder response = ExecutePlanResponse.newBuilder().setSessionId(sessionId$1).setServerSideSessionId(this.sessionHolder().serverSessionId());
        ExecutePlanResponse.ArrowBatch batch = ExecutePlanResponse.ArrowBatch.newBuilder().setRowCount(count).setData(ByteString.copyFrom(bytes)).setStartOffset(startOffset).build();
        response.setArrowBatch(batch);
        responseObserver$2.onNext(response.build());
        ++numSent$1.elem;
    }

    public static final /* synthetic */ void $anonfun$processAsArrowBatches$1(SparkConnectPlanExecution $this, LongRef offset$1, String sessionId$1, StreamObserver responseObserver$2, IntRef numSent$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            byte[] bytes = (byte[])tuple2._1();
            long count = tuple2._2$mcJ$sp();
            $this.sendBatch$1(bytes, count, offset$1.elem, sessionId$1, responseObserver$2, numSent$1);
            offset$1.elem += count;
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$processAsArrowBatches$3(Object signal$1, Tuple2[][] partitions$1, LongRef totalNumRows$1, IntRef numFinishedPartitions$1, int numPartitions$1, ExecuteHolder executePlan$1, int partitionId, Tuple2[] partition) {
        Object object = signal$1;
        synchronized (object) {
            partitions$1[partitionId] = partition;
            totalNumRows$1.elem += BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.wrapLongArray((long[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])partition), (Function1 & Serializable)x$1 -> BoxesRunTime.boxToLong((long)x$1._2$mcJ$sp()), (ClassTag)ClassTag$.MODULE$.Long())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
            ++numFinishedPartitions$1.elem;
            if (numFinishedPartitions$1.elem == numPartitions$1) {
                executePlan$1.eventsManager().postFinished((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)totalNumRows$1.elem)), executePlan$1.eventsManager().postFinished$default$2());
            }
            signal$1.notify();
        }
    }

    public static final /* synthetic */ void $anonfun$processAsArrowBatches$9(SparkConnectPlanExecution $this, LongRef currentOffset$1, String sessionId$1, StreamObserver responseObserver$2, IntRef numSent$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            byte[] bytes = (byte[])tuple2._1();
            long count = tuple2._2$mcJ$sp();
            $this.sendBatch$1(bytes, count, currentOffset$1.elem, sessionId$1, responseObserver$2, numSent$1);
            currentOffset$1.elem += count;
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public SparkConnectPlanExecution(ExecuteHolder executeHolder) {
        this.org$apache$spark$sql$connect$execution$SparkConnectPlanExecution$$executeHolder = executeHolder;
        this.sessionHolder = executeHolder.sessionHolder();
        this.session = executeHolder.session();
    }
}

