/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connect.plugin;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.spark.SparkEnv$;
import org.apache.spark.SparkException;
import org.apache.spark.sql.connect.config.Connect$;
import org.apache.spark.sql.connect.plugin.CommandPlugin;
import org.apache.spark.sql.connect.plugin.ExpressionPlugin;
import org.apache.spark.sql.connect.plugin.RelationPlugin;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class SparkConnectPluginRegistry$ {
    public static final SparkConnectPluginRegistry$ MODULE$ = new SparkConnectPluginRegistry$();
    private static Seq<Function0<RelationPlugin>> relationPluginChain;
    private static Seq<Function0<ExpressionPlugin>> expressionPluginChain;
    private static Seq<Function0<CommandPlugin>> commandPluginChain;
    private static boolean initialized;
    private static Seq<RelationPlugin> relationRegistryCache;
    private static Seq<ExpressionPlugin> expressionRegistryCache;
    private static Seq<CommandPlugin> commandRegistryCache;
    private static volatile byte bitmap$0;

    static {
        initialized = false;
        relationRegistryCache = (Seq)package$.MODULE$.Seq().empty();
        expressionRegistryCache = (Seq)package$.MODULE$.Seq().empty();
        commandRegistryCache = (Seq)package$.MODULE$.Seq().empty();
    }

    private Seq<Function0<RelationPlugin>> relationPluginChain$lzycompute() {
        SparkConnectPluginRegistry$ sparkConnectPluginRegistry$ = this;
        synchronized (sparkConnectPluginRegistry$) {
            if ((byte)(bitmap$0 & 1) == 0) {
                relationPluginChain = (Seq)Nil$.MODULE$;
                bitmap$0 = (byte)(bitmap$0 | 1);
            }
        }
        return relationPluginChain;
    }

    private Seq<Function0<RelationPlugin>> relationPluginChain() {
        if ((byte)(bitmap$0 & 1) == 0) {
            return this.relationPluginChain$lzycompute();
        }
        return relationPluginChain;
    }

    private Seq<Function0<ExpressionPlugin>> expressionPluginChain$lzycompute() {
        SparkConnectPluginRegistry$ sparkConnectPluginRegistry$ = this;
        synchronized (sparkConnectPluginRegistry$) {
            if ((byte)(bitmap$0 & 2) == 0) {
                expressionPluginChain = (Seq)Nil$.MODULE$;
                bitmap$0 = (byte)(bitmap$0 | 2);
            }
        }
        return expressionPluginChain;
    }

    private Seq<Function0<ExpressionPlugin>> expressionPluginChain() {
        if ((byte)(bitmap$0 & 2) == 0) {
            return this.expressionPluginChain$lzycompute();
        }
        return expressionPluginChain;
    }

    private Seq<Function0<CommandPlugin>> commandPluginChain$lzycompute() {
        SparkConnectPluginRegistry$ sparkConnectPluginRegistry$ = this;
        synchronized (sparkConnectPluginRegistry$) {
            if ((byte)(bitmap$0 & 4) == 0) {
                commandPluginChain = (Seq)Nil$.MODULE$;
                bitmap$0 = (byte)(bitmap$0 | 4);
            }
        }
        return commandPluginChain;
    }

    private Seq<Function0<CommandPlugin>> commandPluginChain() {
        if ((byte)(bitmap$0 & 4) == 0) {
            return this.commandPluginChain$lzycompute();
        }
        return commandPluginChain;
    }

    private boolean initialized() {
        return initialized;
    }

    private void initialized_$eq(boolean x$1) {
        initialized = x$1;
    }

    private Seq<RelationPlugin> relationRegistryCache() {
        return relationRegistryCache;
    }

    private void relationRegistryCache_$eq(Seq<RelationPlugin> x$1) {
        relationRegistryCache = x$1;
    }

    private Seq<ExpressionPlugin> expressionRegistryCache() {
        return expressionRegistryCache;
    }

    private void expressionRegistryCache_$eq(Seq<ExpressionPlugin> x$1) {
        expressionRegistryCache = x$1;
    }

    private Seq<CommandPlugin> commandRegistryCache() {
        return commandRegistryCache;
    }

    private void commandRegistryCache_$eq(Seq<CommandPlugin> x$1) {
        commandRegistryCache = x$1;
    }

    public Seq<RelationPlugin> relationRegistry() {
        return this.withInitialize((Function0 & Serializable)() -> MODULE$.relationRegistryCache());
    }

    public Seq<ExpressionPlugin> expressionRegistry() {
        return this.withInitialize((Function0 & Serializable)() -> MODULE$.expressionRegistryCache());
    }

    public Seq<CommandPlugin> commandRegistry() {
        return this.withInitialize((Function0 & Serializable)() -> MODULE$.commandRegistryCache());
    }

    private <T> Seq<T> withInitialize(Function0<Seq<T>> f) {
        SparkConnectPluginRegistry$ sparkConnectPluginRegistry$ = this;
        synchronized (sparkConnectPluginRegistry$) {
            if (!this.initialized()) {
                this.relationRegistryCache_$eq(this.loadRelationPlugins());
                this.expressionRegistryCache_$eq(this.loadExpressionPlugins());
                this.commandRegistryCache_$eq(this.loadCommandPlugins());
                this.initialized_$eq(true);
            }
        }
        return (Seq)f.apply();
    }

    public synchronized void reset() {
        this.initialized_$eq(false);
    }

    public Seq<RelationPlugin> loadRelationPlugins() {
        return (Seq)((IterableOps)this.relationPluginChain().map((Function1 & Serializable)x -> (RelationPlugin)x.apply())).$plus$plus(this.createConfiguredPlugins((Seq<String>)((Seq)SparkEnv$.MODULE$.get().conf().get(Connect$.MODULE$.CONNECT_EXTENSIONS_RELATION_CLASSES()))));
    }

    public Seq<ExpressionPlugin> loadExpressionPlugins() {
        return (Seq)((IterableOps)this.expressionPluginChain().map((Function1 & Serializable)x -> (ExpressionPlugin)x.apply())).$plus$plus(this.createConfiguredPlugins((Seq<String>)((Seq)SparkEnv$.MODULE$.get().conf().get(Connect$.MODULE$.CONNECT_EXTENSIONS_EXPRESSION_CLASSES()))));
    }

    public Seq<CommandPlugin> loadCommandPlugins() {
        return (Seq)((IterableOps)this.commandPluginChain().map((Function1 & Serializable)x -> (CommandPlugin)x.apply())).$plus$plus(this.createConfiguredPlugins((Seq<String>)((Seq)SparkEnv$.MODULE$.get().conf().get(Connect$.MODULE$.CONNECT_EXTENSIONS_COMMAND_CLASSES()))));
    }

    public <T> Seq<T> createConfiguredPlugins(Seq<String> values) {
        if (values.nonEmpty()) {
            return (Seq)((IterableOps)((IterableOps)((IterableOps)values.map((Function1 & Serializable)x$1 -> x$1.trim())).filter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(x$2))))).map((Function1 & Serializable)x$3 -> Utils$.MODULE$.classForName(x$3, Utils$.MODULE$.classForName$default$2(), Utils$.MODULE$.classForName$default$3()))).map((Function1 & Serializable)x$4 -> MODULE$.createInstance((Class)x$4));
        }
        return (Seq)package$.MODULE$.Seq().empty();
    }

    private <B, T extends B> B createInstance(Class<T> cls) {
        Object t2;
        Option ctorOpt = ArrayOps$.MODULE$.find$extension(Predef$.MODULE$.refArrayOps((Object[])cls.getConstructors()), (Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)SparkConnectPluginRegistry$.$anonfun$createInstance$1(x$5)));
        if (ctorOpt.isEmpty()) {
            throw new SparkException("CONNECT.PLUGIN_CTOR_MISSING", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"cls"), (Object)cls.getName())})), null);
        }
        try {
            t2 = ((Constructor)ctorOpt.get()).newInstance(new Object[0]);
        }
        catch (InvocationTargetException e) {
            throw new SparkException("CONNECT.PLUGIN_RUNTIME_ERROR", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"msg"), (Object)e.getTargetException().getMessage())})), (Throwable)e);
        }
        catch (Exception e) {
            throw new SparkException("CONNECT.PLUGIN_RUNTIME_ERROR", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"msg"), (Object)e.getMessage())})), (Throwable)e);
        }
        return (B)t2;
    }

    public <T extends RelationPlugin> Function0<RelationPlugin> relation(Class<T> cls) {
        return (Function0 & Serializable)() -> (RelationPlugin)MODULE$.createInstance(cls);
    }

    public <T extends ExpressionPlugin> Function0<ExpressionPlugin> expression(Class<T> cls) {
        return (Function0 & Serializable)() -> (ExpressionPlugin)MODULE$.createInstance(cls);
    }

    public <T extends CommandPlugin> Function0<CommandPlugin> command(Class<T> cls) {
        return (Function0 & Serializable)() -> (CommandPlugin)MODULE$.createInstance(cls);
    }

    public static final /* synthetic */ boolean $anonfun$createInstance$1(Constructor x$5) {
        return x$5.getParameterCount() == 0;
    }

    private SparkConnectPluginRegistry$() {
    }
}

