/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connect.service;

import java.io.Serializable;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.GuardedBy;
import org.apache.spark.SparkEnv$;
import org.apache.spark.SparkException$;
import org.apache.spark.SparkSQLException;
import org.apache.spark.connect.proto.Relation;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.artifact.ArtifactManager;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.connect.common.InvalidPlanInput;
import org.apache.spark.sql.connect.common.InvalidPlanInput$;
import org.apache.spark.sql.connect.config.Connect$;
import org.apache.spark.sql.connect.planner.PythonStreamingQueryListener;
import org.apache.spark.sql.connect.planner.StreamingForeachBatchHelper;
import org.apache.spark.sql.connect.service.ExecuteHolder;
import org.apache.spark.sql.connect.service.ServerSideListenerHolder;
import org.apache.spark.sql.connect.service.SessionEventsManager;
import org.apache.spark.sql.connect.service.SessionHolder$;
import org.apache.spark.sql.connect.service.SessionHolderInfo;
import org.apache.spark.sql.connect.service.SessionKey;
import org.apache.spark.sql.connect.service.SessionStatus;
import org.apache.spark.sql.connect.service.SessionStatus$Pending$;
import org.apache.spark.sql.connect.service.SparkConnectService$;
import org.apache.spark.sql.streaming.StreamingQueryListener;
import org.apache.spark.util.Clock;
import org.apache.spark.util.CollectionAccumulator;
import org.apache.spark.util.SystemClock;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import org.sparkproject.connect.guava.base.Ticker;
import org.sparkproject.connect.guava.cache.Cache;
import org.sparkproject.connect.guava.cache.CacheBuilder;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\u0011\u0015c\u0001B*U\u0001\u0006D\u0001\" \u0001\u0003\u0016\u0004%\tA \u0005\n\u0003\u001f\u0001!\u0011#Q\u0001\n}D\u0011\"!\u0005\u0001\u0005+\u0007I\u0011\u0001@\t\u0013\u0005M\u0001A!E!\u0002\u0013y\bBCA\u000b\u0001\tU\r\u0011\"\u0001\u0002\u0018!Q\u0011\u0011\u0005\u0001\u0003\u0012\u0003\u0006I!!\u0007\t\u000f\u0005\r\u0002\u0001\"\u0001\u0002&!Q\u0011\u0011\u0007\u0001\t\u0006\u0004%I!a\r\t\u0013\u0005U\u0004A1A\u0005\n\u0005]\u0004\u0002CA@\u0001\u0001\u0006I!!\u001f\t\u0013\u0005\u0005\u0005\u00011A\u0005\n\u0005]\u0004\"CAB\u0001\u0001\u0007I\u0011BAC\u0011!\t\t\n\u0001Q!\n\u0005e\u0004\"CAN\u0001\u0001\u0007I\u0011BAO\u0011%\t\t\u000b\u0001a\u0001\n\u0013\t\u0019\u000b\u0003\u0005\u0002(\u0002\u0001\u000b\u0015BAP\u0011%\tY\u000b\u0001a\u0001\n\u0013\ti\nC\u0005\u0002.\u0002\u0001\r\u0011\"\u0003\u00020\"A\u00111\u0017\u0001!B\u0013\ty\nC\u0005\u00028\u0002\u0011\r\u0011\"\u0003\u0002:\"A\u0011Q\u001b\u0001!\u0002\u0013\tY\f\u0003\u0006\u0002X\u0002\u0011\r\u0011\"\u0001W\u00033D\u0001\"a9\u0001A\u0003%\u00111\u001c\u0005\n\u0003K\u0004!\u0019!C\u0001\u0003OD\u0001\"a<\u0001A\u0003%\u0011\u0011\u001e\u0005\f\u0003c\u0004\u0001R1A\u0005\u0002i\u000b\u0019\u0010\u0003\u0006\u0003\u0014\u0001A)\u0019!C\u0005\u0005+A1B!\n\u0001\u0011\u000b\u0007I\u0011\u0001,\u0003(!Y!Q\b\u0001\t\u0006\u0004%\tA\u0016B \u0011\u001d\u00119\u0005\u0001C\u0001\u0005\u0013BaA!\u0015\u0001\t\u0003q\b\u0002\u0003B*\u0001\u0011\u0005AK!\u0016\t\u0011\tU\u0004\u0001\"\u0001U\u0005oB\u0001B!\u0017\u0001\t\u00031&q\u0010\u0005\t\u0005\u000b\u0003A\u0011\u0001+\u0003\b\"A!q\u0012\u0001\u0005\u0002Q\u0013\t\n\u0003\u0005\u0003\u0018\u0002!\t\u0001\u0016BM\u0011!\u0011i\n\u0001C\u0001-\n}\u0005\u0002\u0003BW\u0001\u0011\u0005aKa,\t\u000f\t=\u0007\u0001\"\u0001\u0003R\"A!q\u001c\u0001\u0005\u0002Y\u0013\t\u000f\u0003\u0005\u0003d\u0002!\tA\u0016Bs\u0011!\u0011Y\u000f\u0001C\u0001-\n\u0005\b\u0002\u0003Bw\u0001\u0011\u0005aK!9\t\u000f\t=\b\u0001\"\u0001\u0003r\"91Q\u0003\u0001\u0005\u0002\r]\u0001\u0002CB\u0010\u0001\u0011\u0005ak!\t\t\u0011\r-\u0002\u0001\"\u0001W\u0007[A\u0001b!\r\u0001\t\u0003161\u0007\u0005\t\u0007o\u0001A\u0011\u0001,\u0004:!A11\t\u0001\u0005\u0002Y\u001b)\u0005\u0003\u0005\u0004L\u0001!\tAVB'\u0011\u001d\u0019\t\u0006\u0001C\u0005\u0005CD\u0001ba\u0015\u0001\t\u00031&q\u0011\u0005\u000b\u0007+\u0002!\u0019!C\u0001-\u000e]\u0003\u0002CB=\u0001\u0001\u0006Ia!\u0017\t\u0011\rm\u0004\u0001\"\u0001W\u0007{B\u0001b!&\u0001\t\u0003!\u00161\u0007\u0005\n\u0007/\u0003\u0011\u0011!C\u0001\u00073C\u0011b!)\u0001#\u0003%\taa)\t\u0013\r]\u0006!%A\u0005\u0002\r\r\u0006\"CB]\u0001E\u0005I\u0011AB^\u0011%\u0019y\fAA\u0001\n\u0003\u001a\t\rC\u0005\u0004H\u0002\t\t\u0011\"\u0001\u0004J\"I1\u0011\u001b\u0001\u0002\u0002\u0013\u000511\u001b\u0005\n\u0007/\u0004\u0011\u0011!C!\u00073D\u0011ba:\u0001\u0003\u0003%\ta!;\t\u0013\r5\b!!A\u0005B\r=\b\"CBz\u0001\u0005\u0005I\u0011IB{\u0011%\u00199\u0010AA\u0001\n\u0003\u001aI\u0010C\u0005\u0004|\u0002\t\t\u0011\"\u0011\u0004~\u001e9A\u0011\u0001+\t\u0002\u0011\raAB*U\u0011\u0003!)\u0001C\u0004\u0002$%#\t\u0001\"\u0005\t\u0013\u0011M\u0011J1A\u0005\n\r%\u0007\u0002\u0003C\u000b\u0013\u0002\u0006Iaa3\t\u0013\u0011]\u0011J1A\u0005\n\r%\u0007\u0002\u0003C\r\u0013\u0002\u0006Iaa3\t\u000f\u0011m\u0011\n\"\u0001\u0005\u001e!IA\u0011E%\u0002\u0002\u0013\u0005E1\u0005\u0005\n\tWI\u0015\u0011!CA\t[A\u0011\u0002b\u000fJ\u0003\u0003%I\u0001\"\u0010\u0003\u001bM+7o]5p]\"{G\u000eZ3s\u0015\t)f+A\u0004tKJ4\u0018nY3\u000b\u0005]C\u0016aB2p]:,7\r\u001e\u0006\u00033j\u000b1a]9m\u0015\tYF,A\u0003ta\u0006\u00148N\u0003\u0002^=\u00061\u0011\r]1dQ\u0016T\u0011aX\u0001\u0004_J<7\u0001A\n\u0006\u0001\tDg.\u001d\t\u0003G\u001al\u0011\u0001\u001a\u0006\u0002K\u0006)1oY1mC&\u0011q\r\u001a\u0002\u0007\u0003:L(+\u001a4\u0011\u0005%dW\"\u00016\u000b\u0005-T\u0016\u0001C5oi\u0016\u0014h.\u00197\n\u00055T'a\u0002'pO\u001eLgn\u001a\t\u0003G>L!\u0001\u001d3\u0003\u000fA\u0013x\u000eZ;diB\u0011!O\u001f\b\u0003gbt!\u0001^<\u000e\u0003UT!A\u001e1\u0002\rq\u0012xn\u001c;?\u0013\u0005)\u0017BA=e\u0003\u001d\u0001\u0018mY6bO\u0016L!a\u001f?\u0003\u0019M+'/[1mSj\f'\r\\3\u000b\u0005e$\u0017AB;tKJLE-F\u0001\u0000!\u0011\t\t!!\u0003\u000f\t\u0005\r\u0011Q\u0001\t\u0003i\u0012L1!a\u0002e\u0003\u0019\u0001&/\u001a3fM&!\u00111BA\u0007\u0005\u0019\u0019FO]5oO*\u0019\u0011q\u00013\u0002\u000fU\u001cXM]%eA\u0005I1/Z:tS>t\u0017\nZ\u0001\u000bg\u0016\u001c8/[8o\u0013\u0012\u0004\u0013aB:fgNLwN\\\u000b\u0003\u00033\u0001B!a\u0007\u0002\u001e5\t\u0001,C\u0002\u0002 a\u0013Ab\u00159be.\u001cVm]:j_:\f\u0001b]3tg&|g\u000eI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0011\u0005\u001d\u00121FA\u0017\u0003_\u00012!!\u000b\u0001\u001b\u0005!\u0006\"B?\b\u0001\u0004y\bBBA\t\u000f\u0001\u0007q\u0010C\u0004\u0002\u0016\u001d\u0001\r!!\u0007\u0002\u0013Ad\u0017M\\\"bG\",WCAA\u001b!\u0015\u0019\u0017qGA\u001e\u0013\r\tI\u0004\u001a\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0011\u0005u\u0012qJA*\u0003Cj!!a\u0010\u000b\t\u0005\u0005\u00131I\u0001\u0006G\u0006\u001c\u0007.\u001a\u0006\u0005\u0003\u000b\n9%\u0001\u0004d_6lwN\u001c\u0006\u0005\u0003\u0013\nY%\u0001\u0004h_><G.\u001a\u0006\u0003\u0003\u001b\n1aY8n\u0013\u0011\t\t&a\u0010\u0003\u000b\r\u000b7\r[3\u0011\t\u0005U\u0013QL\u0007\u0003\u0003/RA!!\u0017\u0002\\\u0005)\u0001O]8u_*\u0011qKW\u0005\u0005\u0003?\n9F\u0001\u0005SK2\fG/[8o!\u0011\t\u0019'!\u001d\u000e\u0005\u0005\u0015$\u0002BA4\u0003S\nq\u0001\\8hS\u000e\fGN\u0003\u0003\u0002l\u00055\u0014!\u00029mC:\u001c(bAA81\u0006A1-\u0019;bYf\u001cH/\u0003\u0003\u0002t\u0005\u0015$a\u0003'pO&\u001c\u0017\r\u001c)mC:\f1b\u001d;beR$\u0016.\\3NgV\u0011\u0011\u0011\u0010\t\u0004G\u0006m\u0014bAA?I\n!Aj\u001c8h\u00031\u0019H/\u0019:u)&lW-T:!\u0003Aa\u0017m\u001d;BG\u000e,7o\u001d+j[\u0016l5/\u0001\u000bmCN$\u0018iY2fgN$\u0016.\\3Ng~#S-\u001d\u000b\u0005\u0003\u000f\u000bi\tE\u0002d\u0003\u0013K1!a#e\u0005\u0011)f.\u001b;\t\u0013\u0005=E\"!AA\u0002\u0005e\u0014a\u0001=%c\u0005\tB.Y:u\u0003\u000e\u001cWm]:US6,Wj\u001d\u0011)\u00075\t)\nE\u0002d\u0003/K1!!'e\u0005!1x\u000e\\1uS2,\u0017\u0001D2m_N,G\rV5nK6\u001bXCAAP!\u0015\u0019\u0017qGA=\u0003A\u0019Gn\\:fIRKW.Z't?\u0012*\u0017\u000f\u0006\u0003\u0002\b\u0006\u0015\u0006\"CAH\u001f\u0005\u0005\t\u0019AAP\u00035\u0019Gn\\:fIRKW.Z'tA!\u001a\u0001#!&\u0002/\r,8\u000f^8n\u0013:\f7\r^5wKRKW.Z8vi6\u001b\u0018aG2vgR|W.\u00138bGRLg/\u001a+j[\u0016|W\u000f^'t?\u0012*\u0017\u000f\u0006\u0003\u0002\b\u0006E\u0006\"CAH%\u0005\u0005\t\u0019AAP\u0003a\u0019Wo\u001d;p[&s\u0017m\u0019;jm\u0016$\u0016.\\3pkRl5\u000f\t\u0015\u0004'\u0005U\u0015AC3yK\u000e,H/[8ogV\u0011\u00111\u0018\t\b\u0003{\u000bYm`Ah\u001b\t\tyL\u0003\u0003\u0002B\u0006\r\u0017AC2p]\u000e,(O]3oi*!\u0011QYAd\u0003\u0011)H/\u001b7\u000b\u0005\u0005%\u0017\u0001\u00026bm\u0006LA!!4\u0002@\ni1i\u001c8dkJ\u0014XM\u001c;NCB\u0004B!!\u000b\u0002R&\u0019\u00111\u001b+\u0003\u001b\u0015CXmY;uK\"{G\u000eZ3s\u0003-)\u00070Z2vi&|gn\u001d\u0011\u0002\u001d\u0015\u0014(o\u001c:JIR{WI\u001d:peV\u0011\u00111\u001c\t\b\u0003{\tye`Ao!\r\u0011\u0018q\\\u0005\u0004\u0003Cd(!\u0003+ie><\u0018M\u00197f\u0003=)'O]8s\u0013\u0012$v.\u0012:s_J\u0004\u0013\u0001D3wK:$X*\u00198bO\u0016\u0014XCAAu!\u0011\tI#a;\n\u0007\u00055HK\u0001\u000bTKN\u001c\u0018n\u001c8Fm\u0016tGo]'b]\u0006<WM]\u0001\u000eKZ,g\u000e^'b]\u0006<WM\u001d\u0011\u0002\u001d\u0011\fG/\u0019$sC6,7)Y2iKV\u0011\u0011Q\u001f\t\b\u0003{\u000bYm`A|!\u0011\tIP!\u0004\u000f\t\u0005m(1\u0002\b\u0005\u0003{\u0014IA\u0004\u0003\u0002\u0000\n\u001da\u0002\u0002B\u0001\u0005\u000bq1\u0001\u001eB\u0002\u0013\u0005y\u0016BA/_\u0013\tYF,\u0003\u0002Z5&\u0011\u0011\u0010W\u0005\u0005\u0005\u001f\u0011\tBA\u0005ECR\fgI]1nK*\u0011\u0011\u0010W\u0001\u000eY&\u001cH/\u001a8fe\u000e\u000b7\r[3\u0016\u0005\t]\u0001cBA_\u0003\u0017|(\u0011\u0004\t\u0005\u00057\u0011\t#\u0004\u0002\u0003\u001e)\u0019!q\u0004-\u0002\u0013M$(/Z1nS:<\u0017\u0002\u0002B\u0012\u0005;\u0011ac\u0015;sK\u0006l\u0017N\\4Rk\u0016\u0014\u0018\u0010T5ti\u0016tWM]\u0001(gR\u0014X-Y7j]\u001e4uN]3bG\"\u0014\u0015\r^2i%Vtg.\u001a:DY\u0016\fg.\u001a:DC\u000eDW-\u0006\u0002\u0003*A!!1\u0006B\u001c\u001d\u0011\u0011iCa\r\u000e\u0005\t=\"b\u0001B\u0019-\u00069\u0001\u000f\\1o]\u0016\u0014\u0018\u0002\u0002B\u001b\u0005_\t1d\u0015;sK\u0006l\u0017N\\4G_J,\u0017m\u00195CCR\u001c\u0007\u000eS3ma\u0016\u0014\u0018\u0002\u0002B\u001d\u0005w\u0011Ab\u00117fC:,'oQ1dQ\u0016TAA!\u000e\u00030\u0005\t3\u000f\u001e:fC6LgnZ*feZ,'o]5eK2K7\u000f^3oKJDu\u000e\u001c3feV\u0011!\u0011\t\t\u0005\u0003S\u0011\u0019%C\u0002\u0003FQ\u0013\u0001dU3sm\u0016\u00148+\u001b3f\u0019&\u001cH/\u001a8fe\"{G\u000eZ3s\u0003\rYW-_\u000b\u0003\u0005\u0017\u0002B!!\u000b\u0003N%\u0019!q\n+\u0003\u0015M+7o]5p].+\u00170A\btKJ4XM]*fgNLwN\\%e\u0003A\tG\rZ#yK\u000e,H/\u001a%pY\u0012,'\u000f\u0006\u0003\u0002\b\n]\u0003b\u0002B-A\u0001\u0007\u0011qZ\u0001\u000eKb,7-\u001e;f\u0011>dG-\u001a:)\u000f\u0001\u0012iFa\u001c\u0003rA!!q\fB6\u001b\t\u0011\tG\u0003\u0003\u0002B\n\r$\u0002\u0002B3\u0005O\n!\"\u00198o_R\fG/[8o\u0015\t\u0011I'A\u0003kCZ\f\u00070\u0003\u0003\u0003n\t\u0005$!C$vCJ$W\r\u001a\"z\u0003\u00151\u0018\r\\;fC\t\u0011\u0019(A\u001aTa\u0006\u00148nQ8o]\u0016\u001cGoU3sm&\u001cWML3yK\u000e,H/[8o\u001b\u0006t\u0017mZ3s]\u0015DXmY;uS>t7\u000fT8dW\u0006\u0019\"/Z7pm\u0016,\u00050Z2vi\u0016Du\u000e\u001c3feR!\u0011q\u0011B=\u0011\u0019\u0011Y(\ta\u0001\u007f\u0006Yq\u000e]3sCRLwN\\%eQ\u001d\t#Q\fB8\u0005c\"BA!!\u0003\u0004B)1-a\u000e\u0002P\"1!1\u0010\u0012A\u0002}\fA\"\u001b8uKJ\u0014X\u000f\u001d;BY2$\"A!#\u0011\tI\u0014Yi`\u0005\u0004\u0005\u001bc(aA*fc\u0006a\u0011N\u001c;feJ,\b\u000f\u001e+bOR!!\u0011\u0012BJ\u0011\u0019\u0011)\n\na\u0001\u007f\u0006\u0019A/Y4\u0002%%tG/\u001a:skB$x\n]3sCRLwN\u001c\u000b\u0005\u0005\u0013\u0013Y\n\u0003\u0004\u0003|\u0015\u0002\ra`\u0001\u0010CJ$\u0018NZ1di6\u000bg.Y4feV\u0011!\u0011\u0015\t\u0005\u0005G\u0013I+\u0004\u0002\u0003&*\u0019!q\u0015-\u0002\u0011\u0005\u0014H/\u001b4bGRLAAa+\u0003&\ny\u0011I\u001d;jM\u0006\u001cG/T1oC\u001e,'/A\u0006bI\u0012\f%\u000f^5gC\u000e$H\u0003CAD\u0005c\u0013)M!3\t\u000f\tMv\u00051\u0001\u00036\u0006\u0011\"/Z7pi\u0016\u0014V\r\\1uSZ,\u0007+\u0019;i!\u0011\u00119L!1\u000e\u0005\te&\u0002\u0002B^\u0005{\u000bAAZ5mK*!!qXAd\u0003\rq\u0017n\\\u0005\u0005\u0005\u0007\u0014IL\u0001\u0003QCRD\u0007b\u0002BdO\u0001\u0007!QW\u0001\u0017g\u0016\u0014h/\u001a:M_\u000e\fGn\u0015;bO&tw\rU1uQ\"9!1Z\u0014A\u0002\t5\u0017\u0001\u00034sC\u001elWM\u001c;\u0011\t\r\f9d`\u0001\fG2\f7o\u001d7pC\u0012,'/\u0006\u0002\u0003TB!!Q\u001bBn\u001b\t\u00119N\u0003\u0003\u0003Z\u0006\u001d\u0017\u0001\u00027b]\u001eLAA!8\u0003X\nY1\t\\1tg2{\u0017\rZ3s\u0003A)\b\u000fZ1uK\u0006\u001b7-Z:t)&lW\r\u0006\u0002\u0002\b\u0006Q2/\u001a;DkN$x.\\%oC\u000e$\u0018N^3US6,w.\u001e;NgR!\u0011q\u0011Bt\u0011\u001d\u0011IO\u000ba\u0001\u0003?\u000bAC\\3x\u0013:\f7\r^5wKRKW.Z8vi6\u001b\u0018!E5oSRL\u0017\r\\5{KN+7o]5p]\u0006)1\r\\8tK\u0006Yq/\u001b;i'\u0016\u001c8/[8o+\u0011\u0011\u0019P!?\u0015\t\tU81\u0002\t\u0005\u0005o\u0014I\u0010\u0004\u0001\u0005\u000f\tmXF1\u0001\u0003~\n\tA+\u0005\u0003\u0003\u0000\u000e\u0015\u0001cA2\u0004\u0002%\u001911\u00013\u0003\u000f9{G\u000f[5oOB\u00191ma\u0002\n\u0007\r%AMA\u0002B]fDqa!\u0004.\u0001\u0004\u0019y!A\u0001g!\u001d\u00197\u0011CA\r\u0005kL1aa\u0005e\u0005%1UO\\2uS>t\u0017'\u0001\u000bhKR\u001cVm]:j_:Du\u000e\u001c3fe&sgm\\\u000b\u0003\u00073\u0001B!!\u000b\u0004\u001c%\u00191Q\u0004+\u0003#M+7o]5p]\"{G\u000eZ3s\u0013:4w.\u0001\ndC\u000eDW\rR1uC\u001a\u0013\u0018-\\3Cs&#GCBAD\u0007G\u00199\u0003\u0003\u0004\u0004&=\u0002\ra`\u0001\u0005I\u001aLE\rC\u0004\u0004*=\u0002\r!a>\u0002\u0005\u00114\u0017aE4fi\u0012\u000bG/\u0019$sC6,wJ\u001d+ie><H\u0003BA|\u0007_Aaa!\n1\u0001\u0004y\u0018!\u0006:f[>4XmQ1dQ\u0016$G)\u0019;b\rJ\fW.\u001a\u000b\u0005\u0003o\u001c)\u0004\u0003\u0004\u0004&E\u0002\ra`\u0001\u0012G\u0006\u001c\u0007.\u001a'jgR,g.\u001a:Cs&#GCBAD\u0007w\u0019y\u0004\u0003\u0004\u0004>I\u0002\ra`\u0001\u0003S\u0012Dqa!\u00113\u0001\u0004\u0011I\"\u0001\u0005mSN$XM\\3s\u0003-9W\r\u001e'jgR,g.\u001a:\u0015\t\r\u001d3\u0011\n\t\u0006G\u0006]\"\u0011\u0004\u0005\u0007\u0007{\u0019\u0004\u0019A@\u0002)I,Wn\u001c<f\u0007\u0006\u001c\u0007.\u001a3MSN$XM\\3s)\u0011\t9ia\u0014\t\r\ruB\u00071\u0001\u0000\u0003I\u0011X-\\8wK\u0006cG\u000eT5ti\u0016tWM]:\u0002\u001f1L7\u000f\u001e'jgR,g.\u001a:JIN\f\u0011\u0003]=uQ>t\u0017iY2v[Vd\u0017\r^8s+\t\u0019I\u0006E\u0003d\u0003o\u0019Y\u0006\u0005\u0003\u0004^\rMd\u0002BB0\u0007[rAa!\u0019\u0004h9!\u0011Q`B2\u0013\r\u0019)GW\u0001\u0004CBL\u0017\u0002BB5\u0007W\na\u0001]=uQ>t'bAB35&!1qNB9\u00039\u0001\u0016\u0010\u001e5p]\u001a+hn\u0019;j_:TAa!\u001b\u0004l%!1QOB<\u0005E\u0001\u0016\u0010\u001e5p]\u0006\u001b7-^7vY\u0006$xN\u001d\u0006\u0005\u0007_\u001a\t(\u0001\nqsRDwN\\!dGVlW\u000f\\1u_J\u0004\u0013\u0001D;tKBc\u0017M\\\"bG\",GCBB@\u0007\u000f\u001bY\t\u0006\u0003\u0002b\r\u0005\u0005bBBBs\u0001\u00071QQ\u0001\niJ\fgn\u001d4pe6\u0004raYB\t\u0003'\n\t\u0007C\u0004\u0004\nf\u0002\r!a\u0015\u0002\u0007I,G\u000eC\u0004\u0004\u000ef\u0002\raa$\u0002\u0013\r\f7\r[3QY\u0006t\u0007cA2\u0004\u0012&\u001911\u00133\u0003\u000f\t{w\u000e\\3b]\u0006aq-\u001a;QY\u0006t7)Y2iK\u0006!1m\u001c9z)!\t9ca'\u0004\u001e\u000e}\u0005bB?<!\u0003\u0005\ra \u0005\t\u0003#Y\u0004\u0013!a\u0001\u007f\"I\u0011QC\u001e\u0011\u0002\u0003\u0007\u0011\u0011D\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\u0019)KK\u0002\u0000\u0007O[#a!+\u0011\t\r-61W\u0007\u0003\u0007[SAaa,\u00042\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0005K\"\u0017\u0002BB[\u0007[\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII\nabY8qs\u0012\"WMZ1vYR$3'\u0006\u0002\u0004>*\"\u0011\u0011DBT\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u001111\u0019\t\u0005\u0005+\u001c)-\u0003\u0003\u0002\f\t]\u0017\u0001\u00049s_\u0012,8\r^!sSRLXCABf!\r\u00197QZ\u0005\u0004\u0007\u001f$'aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BB\u0003\u0007+D\u0011\"a$B\u0003\u0003\u0005\raa3\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"aa7\u0011\r\ru71]B\u0003\u001b\t\u0019yNC\u0002\u0004b\u0012\f!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0019)oa8\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0007\u001f\u001bY\u000fC\u0005\u0002\u0010\u000e\u000b\t\u00111\u0001\u0004\u0006\u0005\u0011\u0002O]8ek\u000e$X\t\\3nK:$h*Y7f)\u0011\u0019\u0019m!=\t\u0013\u0005=E)!AA\u0002\r-\u0017\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0005\r-\u0017\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\r\r\u0017AB3rk\u0006d7\u000f\u0006\u0003\u0004\u0010\u000e}\b\"CAH\u000f\u0006\u0005\t\u0019AB\u0003\u00035\u0019Vm]:j_:Du\u000e\u001c3feB\u0019\u0011\u0011F%\u0014\t%\u0013Gq\u0001\t\u0005\t\u0013!y!\u0004\u0002\u0005\f)!AQBAd\u0003\tIw.C\u0002|\t\u0017!\"\u0001b\u0001\u0002!\u0015\u0013&k\u0014*`\u0007\u0006\u001b\u0005*R0T\u0013j+\u0015!E#S%>\u0013vlQ!D\u0011\u0016{6+\u0013.FA\u00059RI\u0015*P%~\u001b\u0015i\u0011%F?RKU*R(V)~\u001bViQ\u0001\u0019\u000bJ\u0013vJU0D\u0003\u000eCUi\u0018+J\u001b\u0016{U\u000bV0T\u000b\u000e\u0003\u0013A\u00034peR+7\u000f^5oOR!\u0011q\u0005C\u0010\u0011\u001d\t)b\u0014a\u0001\u00033\tQ!\u00199qYf$\u0002\"a\n\u0005&\u0011\u001dB\u0011\u0006\u0005\u0006{B\u0003\ra \u0005\u0007\u0003#\u0001\u0006\u0019A@\t\u000f\u0005U\u0001\u000b1\u0001\u0002\u001a\u00059QO\\1qa2LH\u0003\u0002C\u0018\to\u0001RaYA\u001c\tc\u0001ra\u0019C\u001a\u007f~\fI\"C\u0002\u00056\u0011\u0014a\u0001V;qY\u0016\u001c\u0004\"\u0003C\u001d#\u0006\u0005\t\u0019AA\u0014\u0003\rAH\u0005M\u0001\roJLG/\u001a*fa2\f7-\u001a\u000b\u0003\t\u007f\u0001BA!6\u0005B%!A1\tBl\u0005\u0019y%M[3di\u0002")
public class SessionHolder
implements Logging,
Product,
Serializable {
    private Option<Cache<Relation, LogicalPlan>> planCache;
    private ConcurrentMap<String, Dataset<Row>> dataFrameCache;
    private ConcurrentMap<String, StreamingQueryListener> listenerCache;
    private StreamingForeachBatchHelper.CleanerCache streamingForeachBatchRunnerCleanerCache;
    private ServerSideListenerHolder streamingServersideListenerHolder;
    private final String userId;
    private final String sessionId;
    private final SparkSession session;
    private final long startTimeMs;
    private volatile long lastAccessTimeMs;
    private volatile Option<Object> closedTimeMs;
    private volatile Option<Object> customInactiveTimeoutMs;
    private final ConcurrentMap<String, ExecuteHolder> executions;
    private final Cache<String, Throwable> errorIdToError;
    private final SessionEventsManager eventManager;
    private final Option<CollectionAccumulator<byte[]>> pythonAccumulator;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile byte bitmap$0;

    public static Option<Tuple3<String, String, SparkSession>> unapply(SessionHolder x$0) {
        return SessionHolder$.MODULE$.unapply(x$0);
    }

    public static SessionHolder apply(String userId, String sessionId, SparkSession session) {
        return SessionHolder$.MODULE$.apply(userId, sessionId, session);
    }

    public static SessionHolder forTesting(SparkSession session) {
        return SessionHolder$.MODULE$.forTesting(session);
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(HashMap<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String userId() {
        return this.userId;
    }

    public String sessionId() {
        return this.sessionId;
    }

    public SparkSession session() {
        return this.session;
    }

    private Option<Cache<Relation, LogicalPlan>> planCache$lzycompute() {
        SessionHolder sessionHolder = this;
        synchronized (sessionHolder) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                Some some;
                if (BoxesRunTime.unboxToInt((Object)SparkEnv$.MODULE$.get().conf().get(Connect$.MODULE$.CONNECT_SESSION_PLAN_CACHE_SIZE())) <= 0) {
                    this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Session plan cache is disabled due to non-positive cache size. Current value of '" + Connect$.MODULE$.CONNECT_SESSION_PLAN_CACHE_SIZE().key() + "' is " + SparkEnv$.MODULE$.get().conf().get(Connect$.MODULE$.CONNECT_SESSION_PLAN_CACHE_SIZE()) + ".");
                    some = None$.MODULE$;
                } else {
                    some = new Some(CacheBuilder.newBuilder().maximumSize(BoxesRunTime.unboxToInt((Object)SparkEnv$.MODULE$.get().conf().get(Connect$.MODULE$.CONNECT_SESSION_PLAN_CACHE_SIZE()))).build());
                }
                this.planCache = some;
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.planCache;
    }

    private Option<Cache<Relation, LogicalPlan>> planCache() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.planCache$lzycompute();
        }
        return this.planCache;
    }

    private long startTimeMs() {
        return this.startTimeMs;
    }

    private long lastAccessTimeMs() {
        return this.lastAccessTimeMs;
    }

    private void lastAccessTimeMs_$eq(long x$1) {
        this.lastAccessTimeMs = x$1;
    }

    private Option<Object> closedTimeMs() {
        return this.closedTimeMs;
    }

    private void closedTimeMs_$eq(Option<Object> x$1) {
        this.closedTimeMs = x$1;
    }

    private Option<Object> customInactiveTimeoutMs() {
        return this.customInactiveTimeoutMs;
    }

    private void customInactiveTimeoutMs_$eq(Option<Object> x$1) {
        this.customInactiveTimeoutMs = x$1;
    }

    private ConcurrentMap<String, ExecuteHolder> executions() {
        return this.executions;
    }

    public Cache<String, Throwable> errorIdToError() {
        return this.errorIdToError;
    }

    public SessionEventsManager eventManager() {
        return this.eventManager;
    }

    private ConcurrentMap<String, Dataset<Row>> dataFrameCache$lzycompute() {
        SessionHolder sessionHolder = this;
        synchronized (sessionHolder) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.dataFrameCache = new ConcurrentHashMap<String, Dataset<Row>>();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.dataFrameCache;
    }

    public ConcurrentMap<String, Dataset<Row>> dataFrameCache() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.dataFrameCache$lzycompute();
        }
        return this.dataFrameCache;
    }

    private ConcurrentMap<String, StreamingQueryListener> listenerCache$lzycompute() {
        SessionHolder sessionHolder = this;
        synchronized (sessionHolder) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.listenerCache = new ConcurrentHashMap<String, StreamingQueryListener>();
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.listenerCache;
    }

    private ConcurrentMap<String, StreamingQueryListener> listenerCache() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.listenerCache$lzycompute();
        }
        return this.listenerCache;
    }

    private StreamingForeachBatchHelper.CleanerCache streamingForeachBatchRunnerCleanerCache$lzycompute() {
        SessionHolder sessionHolder = this;
        synchronized (sessionHolder) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.streamingForeachBatchRunnerCleanerCache = new StreamingForeachBatchHelper.CleanerCache(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.streamingForeachBatchRunnerCleanerCache;
    }

    public StreamingForeachBatchHelper.CleanerCache streamingForeachBatchRunnerCleanerCache() {
        if ((byte)(this.bitmap$0 & 8) == 0) {
            return this.streamingForeachBatchRunnerCleanerCache$lzycompute();
        }
        return this.streamingForeachBatchRunnerCleanerCache;
    }

    private ServerSideListenerHolder streamingServersideListenerHolder$lzycompute() {
        SessionHolder sessionHolder = this;
        synchronized (sessionHolder) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                this.streamingServersideListenerHolder = new ServerSideListenerHolder(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
        }
        return this.streamingServersideListenerHolder;
    }

    public ServerSideListenerHolder streamingServersideListenerHolder() {
        if ((byte)(this.bitmap$0 & 0x10) == 0) {
            return this.streamingServersideListenerHolder$lzycompute();
        }
        return this.streamingServersideListenerHolder;
    }

    public SessionKey key() {
        return new SessionKey(this.userId(), this.sessionId());
    }

    public String serverSessionId() {
        if (Utils$.MODULE$.isTesting() && this.session() == null) {
            return "";
        }
        String string = this.session().sessionUUID();
        String string2 = this.sessionId();
        Predef$.MODULE$.assert(string == null ? string2 != null : !string.equals(string2));
        return this.session().sessionUUID();
    }

    @GuardedBy(value="SparkConnectService.executionManager.executionsLock")
    public void addExecuteHolder(ExecuteHolder executeHolder) {
        if (this.closedTimeMs().isDefined()) {
            throw new SparkSQLException("INVALID_HANDLE.SESSION_CLOSED", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"handle"), (Object)this.sessionId())})));
        }
        ExecuteHolder oldExecute = this.executions().putIfAbsent(executeHolder.operationId(), executeHolder);
        if (oldExecute != null) {
            throw new IllegalStateException("ExecuteHolder with opId=" + executeHolder.operationId() + " already exists!");
        }
    }

    @GuardedBy(value="SparkConnectService.executionManager.executionsLock")
    public void removeExecuteHolder(String operationId) {
        this.executions().remove(operationId);
    }

    public Option<ExecuteHolder> executeHolder(String operationId) {
        return Option$.MODULE$.apply(this.executions().get(operationId));
    }

    public Seq<String> interruptAll() {
        ArrayBuffer interruptedIds = new ArrayBuffer();
        CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(this.executions()).asScala().values().foreach((Function1 & Serializable)execute -> {
            if (execute.interrupt()) {
                return interruptedIds.$plus$eq((Object)execute.operationId());
            }
            return BoxedUnit.UNIT;
        });
        return interruptedIds.toSeq();
    }

    public Seq<String> interruptTag(String tag) {
        ArrayBuffer interruptedIds = new ArrayBuffer();
        CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(this.executions()).asScala().values().foreach((Function1 & Serializable)execute -> {
            if (execute.sparkSessionTags().contains((Object)tag)) {
                if (execute.interrupt()) {
                    return interruptedIds.$plus$eq((Object)execute.operationId());
                }
                return BoxedUnit.UNIT;
            }
            return BoxedUnit.UNIT;
        });
        return interruptedIds.toSeq();
    }

    public Seq<String> interruptOperation(String operationId) {
        ArrayBuffer interruptedIds = new ArrayBuffer();
        Option$.MODULE$.apply(this.executions().get(operationId)).foreach((Function1 & Serializable)execute -> {
            if (execute.interrupt()) {
                return interruptedIds.$plus$eq((Object)execute.operationId());
            }
            return BoxedUnit.UNIT;
        });
        return interruptedIds.toSeq();
    }

    public ArtifactManager artifactManager() {
        return this.session().artifactManager();
    }

    public void addArtifact(Path remoteRelativePath, Path serverLocalStagingPath, Option<String> fragment) {
        this.artifactManager().addArtifact(remoteRelativePath, serverLocalStagingPath, fragment);
    }

    public ClassLoader classloader() {
        return this.artifactManager().classloader();
    }

    public void updateAccessTime() {
        this.lastAccessTimeMs_$eq(System.currentTimeMillis());
        this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Session ", " accessed, "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.SESSION_KEY$.MODULE$, (Object)this.key())})).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"time ", " ms."}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.LAST_ACCESS_TIME$.MODULE$, (Object)BoxesRunTime.boxToLong((long)this.lastAccessTimeMs()))})))));
    }

    public void setCustomInactiveTimeoutMs(Option<Object> newInactiveTimeoutMs) {
        this.customInactiveTimeoutMs_$eq(newInactiveTimeoutMs);
        this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Session ", " "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.SESSION_KEY$.MODULE$, (Object)this.key())})).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"inactive timeout set to ", " ms."}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.TIMEOUT$.MODULE$, this.customInactiveTimeoutMs())})))));
    }

    public void initializeSession() {
        this.eventManager().postStarted();
    }

    public void close() {
        if (this.closedTimeMs().isDefined()) {
            throw new IllegalStateException("Session " + this.key() + " is already closed.");
        }
        this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Closing session with userId: ", " and "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.USER_ID$.MODULE$, (Object)this.userId())})).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"sessionId: ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.SESSION_ID$.MODULE$, (Object)this.sessionId())})))));
        this.closedTimeMs_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)System.currentTimeMillis())));
        if (Utils$.MODULE$.isTesting()) {
            SessionStatus sessionStatus = this.eventManager().status();
            SessionStatus$Pending$ sessionStatus$Pending$ = SessionStatus$Pending$.MODULE$;
            if (!(sessionStatus != null ? !sessionStatus.equals(sessionStatus$Pending$) : sessionStatus$Pending$ != null)) {
                return;
            }
        }
        this.artifactManager().cleanUpResources();
        SparkConnectService$.MODULE$.streamingSessionManager().cleanupRunningQueries(this);
        this.streamingForeachBatchRunnerCleanerCache().cleanUpAll();
        this.removeAllListeners();
        if (this.streamingServersideListenerHolder().isServerSideListenerRegistered()) {
            this.streamingServersideListenerHolder().cleanUp();
        }
        SparkConnectService$.MODULE$.executionManager().removeAllExecutionsForSession(this.key());
        this.eventManager().postClosed();
    }

    public <T> T withSession(Function1<SparkSession, T> f) {
        return (T)this.artifactManager().withResources((Function0 & Serializable)() -> this.session().withActive((Function0 & Serializable)() -> f.apply((Object)this.session())));
    }

    public SessionHolderInfo getSessionHolderInfo() {
        String x$1 = this.userId();
        String x$2 = this.sessionId();
        String x$3 = this.serverSessionId();
        SessionStatus x$4 = this.eventManager().status();
        long x$5 = this.startTimeMs();
        long x$6 = this.lastAccessTimeMs();
        Option<Object> x$7 = this.customInactiveTimeoutMs();
        Option<Object> x$8 = this.closedTimeMs();
        return new SessionHolderInfo(x$1, x$2, x$3, x$4, x$7, x$5, x$6, x$8);
    }

    public void cacheDataFrameById(String dfId, Dataset<Row> df) {
        if (this.dataFrameCache().putIfAbsent(dfId, df) != null) {
            throw SparkException$.MODULE$.internalError("A dataframe is already associated with id " + dfId);
        }
    }

    public Dataset<Row> getDataFrameOrThrow(String dfId) {
        return (Dataset)Option$.MODULE$.apply(this.dataFrameCache().get(dfId)).getOrElse((Function0 & Serializable)() -> {
            throw new InvalidPlanInput("No DataFrame with id " + dfId + " is found in the session " + this.sessionId(), InvalidPlanInput$.MODULE$.apply$default$2());
        });
    }

    public Dataset<Row> removeCachedDataFrame(String dfId) {
        return (Dataset)this.dataFrameCache().remove(dfId);
    }

    public void cacheListenerById(String id, StreamingQueryListener listener) {
        if (this.listenerCache().putIfAbsent(id, listener) != null) {
            throw SparkException$.MODULE$.internalError("A listener is already associated with id " + id);
        }
    }

    public Option<StreamingQueryListener> getListener(String id) {
        return Option$.MODULE$.apply(this.listenerCache().get(id));
    }

    public void removeCachedListener(String id) {
        Some some;
        StreamingQueryListener pyListener;
        Option option = Option$.MODULE$.apply(this.listenerCache().remove(id));
        if (option instanceof Some && (pyListener = (StreamingQueryListener)(some = (Some)option).value()) instanceof PythonStreamingQueryListener) {
            PythonStreamingQueryListener pythonStreamingQueryListener = (PythonStreamingQueryListener)pyListener;
            pythonStreamingQueryListener.stopListenerProcess();
            return;
        }
    }

    private void removeAllListeners() {
        this.listenerCache().forEach((id, listener) -> {
            this.session().streams().removeListener(listener);
            this.removeCachedListener((String)id);
        });
    }

    public Seq<String> listListenerIds() {
        return CollectionConverters$.MODULE$.SetHasAsScala(this.listenerCache().keySet()).asScala().toSeq();
    }

    public Option<CollectionAccumulator<byte[]>> pythonAccumulator() {
        return this.pythonAccumulator;
    }

    public LogicalPlan usePlanCache(Relation rel, boolean cachePlan, Function1<Relation, LogicalPlan> transform) {
        boolean planCacheEnabled = Option$.MODULE$.apply((Object)this.session()).forall((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)SessionHolder.$anonfun$usePlanCache$1(x$1)));
        boolean hasPlanId = rel.hasCommon() && rel.getCommon().hasPlanId();
        return (LogicalPlan)this.getPlanCache$1(rel, planCacheEnabled, hasPlanId).getOrElse((Function0 & Serializable)() -> {
            LogicalPlan plan;
            block0: {
                plan = (LogicalPlan)transform.apply((Object)rel);
                if (!cachePlan) break block0;
                this.putPlanCache$1(rel, plan, planCacheEnabled, hasPlanId);
            }
            return plan;
        });
    }

    public Option<Cache<Relation, LogicalPlan>> getPlanCache() {
        return this.planCache();
    }

    public SessionHolder copy(String userId, String sessionId, SparkSession session) {
        return new SessionHolder(userId, sessionId, session);
    }

    public String copy$default$1() {
        return this.userId();
    }

    public String copy$default$2() {
        return this.sessionId();
    }

    public SparkSession copy$default$3() {
        return this.session();
    }

    public String productPrefix() {
        return "SessionHolder";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.userId();
            }
            case 1: {
                return this.sessionId();
            }
            case 2: {
                return this.session();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof SessionHolder;
    }

    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "userId";
            }
            case 1: {
                return "sessionId";
            }
            case 2: {
                return "session";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof SessionHolder)) return false;
        boolean bl = true;
        if (!bl) return false;
        SessionHolder sessionHolder = (SessionHolder)x$1;
        String string = this.userId();
        String string2 = sessionHolder.userId();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        String string3 = this.sessionId();
        String string4 = sessionHolder.sessionId();
        if (string3 == null) {
            if (string4 != null) {
                return false;
            }
        } else if (!string3.equals(string4)) return false;
        SparkSession sparkSession = this.session();
        SparkSession sparkSession2 = sessionHolder.session();
        if (sparkSession == null) {
            if (sparkSession2 != null) {
                return false;
            }
        } else if (!sparkSession.equals(sparkSession2)) return false;
        if (!sessionHolder.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$usePlanCache$1(SparkSession x$1) {
        return BoxesRunTime.unboxToBoolean((Object)x$1.conf().get(Connect$.MODULE$.CONNECT_SESSION_PLAN_CACHE_ENABLED(), (Object)BoxesRunTime.boxToBoolean((boolean)true)));
    }

    private final Option getPlanCache$1(Relation rel, boolean planCacheEnabled$1, boolean hasPlanId$1) {
        Option<Cache<Relation, LogicalPlan>> option = this.planCache();
        if (option instanceof Some) {
            Some some = (Some)option;
            Cache cache = (Cache)some.value();
            if (planCacheEnabled$1 && hasPlanId$1) {
                Option option2 = Option$.MODULE$.apply(cache.getIfPresent(rel));
                if (option2 instanceof Some) {
                    Some some2 = (Some)option2;
                    LogicalPlan plan = (LogicalPlan)some2.value();
                    this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Using cached plan for relation '" + rel + "': " + plan);
                    return new Some((Object)plan);
                }
                if (None$.MODULE$.equals(option2)) {
                    return None$.MODULE$;
                }
                throw new MatchError((Object)option2);
            }
        }
        return None$.MODULE$;
    }

    private final void putPlanCache$1(Relation rel, LogicalPlan plan, boolean planCacheEnabled$1, boolean hasPlanId$1) {
        Option<Cache<Relation, LogicalPlan>> option = this.planCache();
        if (option instanceof Some) {
            Some some = (Some)option;
            Cache cache = (Cache)some.value();
            if (planCacheEnabled$1 && hasPlanId$1) {
                cache.put(rel, plan);
                return;
            }
        }
    }

    public SessionHolder(String userId, String sessionId, SparkSession session) {
        this.userId = userId;
        this.sessionId = sessionId;
        this.session = session;
        Logging.$init$((Logging)this);
        Product.$init$((Product)this);
        this.startTimeMs = System.currentTimeMillis();
        this.lastAccessTimeMs = System.currentTimeMillis();
        this.closedTimeMs = None$.MODULE$;
        this.customInactiveTimeoutMs = None$.MODULE$;
        this.executions = new ConcurrentHashMap<String, ExecuteHolder>();
        this.errorIdToError = CacheBuilder.newBuilder().ticker(Ticker.systemTicker()).maximumSize(SessionHolder$.MODULE$.org$apache$spark$sql$connect$service$SessionHolder$$ERROR_CACHE_SIZE()).expireAfterAccess(SessionHolder$.MODULE$.org$apache$spark$sql$connect$service$SessionHolder$$ERROR_CACHE_TIMEOUT_SEC(), TimeUnit.SECONDS).build();
        this.eventManager = new SessionEventsManager(this, (Clock)new SystemClock());
        this.pythonAccumulator = Try$.MODULE$.apply((Function0 & Serializable)() -> this.session().sparkContext().collectionAccumulator()).toOption();
    }
}

