/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connect.service;

import java.io.Serializable;
import java.util.HashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.GuardedBy;
import org.apache.spark.SparkEnv$;
import org.apache.spark.SparkSQLException;
import org.apache.spark.connect.proto.ExecutePlanRequest;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.sql.connect.config.Connect$;
import org.apache.spark.sql.connect.service.ExecuteHolder;
import org.apache.spark.sql.connect.service.ExecuteInfo;
import org.apache.spark.sql.connect.service.ExecuteKey;
import org.apache.spark.sql.connect.service.SessionHolder;
import org.apache.spark.sql.connect.service.SessionKey;
import org.apache.spark.sql.connect.service.SparkConnectService$;
import org.apache.spark.util.ThreadUtils$;
import org.slf4j.Logger;
import org.sparkproject.connect.guava.cache.Cache;
import org.sparkproject.connect.guava.cache.CacheBuilder;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\u0005%g!\u0002\u000f\u001e\u0001}I\u0003\"\u0002\u001c\u0001\t\u0003A\u0004bB\u001e\u0001\u0005\u0004%I\u0001\u0010\u0005\u0007\u0017\u0002\u0001\u000b\u0011B\u001f\t\u000fe\u0003!\u0019!C\u00055\"11\r\u0001Q\u0001\nmCq\u0001\u001a\u0001C\u0002\u0013%Q\r\u0003\u0004v\u0001\u0001\u0006IA\u001a\u0005\bm\u0002\u0001\r\u0011\"\u0003x\u0011\u001dq\b\u00011A\u0005\n}Dq!a\u0003\u0001A\u0003&\u0001\u0010C\u0005\u0002\u0010\u0001\u0001\r\u0011\"\u0003\u0002\u0012!I\u00111\u0005\u0001A\u0002\u0013%\u0011Q\u0005\u0005\t\u0003S\u0001\u0001\u0015)\u0003\u0002\u0014!A\u00111\u0006\u0001\u0005\u0002}\ti\u0003\u0003\u0005\u0002B\u0001!\taHA\"\u0011)\t\u0019\u0006AI\u0001\n\u0003y\u0012Q\u000b\u0005\t\u0003S\u0002A\u0011A\u0010\u0002l!A\u0011\u0011\u000f\u0001\u0005\u0002}\t\u0019\b\u0003\u0005\u0002~\u0001!\taHA@\u0011\u001d\t)\t\u0001C\u0001\u0003\u000fCq!a*\u0001\t\u0003\tI\u000b\u0003\u0005\u0002,\u0002!\taHAW\u0011\u001d\ty\u000b\u0001C\u0005\u0003[C\u0001\"!-\u0001\t\u0003y\u00121\u0017\u0005\t\u0003s\u0003A\u0011A\u0010\u0002<\"A\u0011\u0011\u0019\u0001\u0005\u0002}\ti\u000b\u0003\u0005\u0002D\u0002!\taHAc\u0005q\u0019\u0006/\u0019:l\u0007>tg.Z2u\u000bb,7-\u001e;j_:l\u0015M\\1hKJT!AH\u0010\u0002\u000fM,'O^5dK*\u0011\u0001%I\u0001\bG>tg.Z2u\u0015\t\u00113%A\u0002tc2T!\u0001J\u0013\u0002\u000bM\u0004\u0018M]6\u000b\u0005\u0019:\u0013AB1qC\u000eDWMC\u0001)\u0003\ry'oZ\n\u0004\u0001)\u0002\u0004CA\u0016/\u001b\u0005a#\"A\u0017\u0002\u000bM\u001c\u0017\r\\1\n\u0005=b#AB!osJ+g\r\u0005\u00022i5\t!G\u0003\u00024G\u0005A\u0011N\u001c;fe:\fG.\u0003\u00026e\t9Aj\\4hS:<\u0017A\u0002\u001fj]&$hh\u0001\u0001\u0015\u0003e\u0002\"A\u000f\u0001\u000e\u0003u\t!\"\u001a=fGV$\u0018n\u001c8t+\u0005i\u0004\u0003\u0002 D\u000b\"k\u0011a\u0010\u0006\u0003\u0001\u0006\u000bq!\\;uC\ndWM\u0003\u0002CY\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005\u0011{$a\u0002%bg\"l\u0015\r\u001d\t\u0003u\u0019K!aR\u000f\u0003\u0015\u0015CXmY;uK.+\u0017\u0010\u0005\u0002;\u0013&\u0011!*\b\u0002\u000e\u000bb,7-\u001e;f\u0011>dG-\u001a:\u0002\u0017\u0015DXmY;uS>t7\u000f\t\u0015\u0005\u00075;\u0006\f\u0005\u0002O+6\tqJ\u0003\u0002Q#\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005I\u001b\u0016AC1o]>$\u0018\r^5p]*\tA+A\u0003kCZ\f\u00070\u0003\u0002W\u001f\nIq)^1sI\u0016$')_\u0001\u0006m\u0006dW/Z\u0011\u00023\u0006qQ\r_3dkRLwN\\:M_\u000e\\W#A.\u0011\u0005q\u000bW\"A/\u000b\u0005y{\u0016\u0001\u00027b]\u001eT\u0011\u0001Y\u0001\u0005U\u00064\u0018-\u0003\u0002c;\n1qJ\u00196fGR\fq\"\u001a=fGV$\u0018n\u001c8t\u0019>\u001c7\u000eI\u0001\u0014C\n\fg\u000eZ8oK\u0012$v.\u001c2ti>tWm]\u000b\u0002MB!q\r]#s\u001b\u0005A'BA5k\u0003\u0015\u0019\u0017m\u00195f\u0015\tYG.\u0001\u0004d_6lwN\u001c\u0006\u0003[:\faaZ8pO2,'\"A8\u0002\u0007\r|W.\u0003\u0002rQ\n)1)Y2iKB\u0011!h]\u0005\u0003iv\u00111\"\u0012=fGV$X-\u00138g_\u0006!\u0012MY1oI>tW\r\u001a+p[\n\u001cHo\u001c8fg\u0002\n1\u0003\\1ti\u0016CXmY;uS>tG+[7f\u001bN,\u0012\u0001\u001f\t\u0004We\\\u0018B\u0001>-\u0005\u0019y\u0005\u000f^5p]B\u00111\u0006`\u0005\u0003{2\u0012A\u0001T8oO\u00069B.Y:u\u000bb,7-\u001e;j_:$\u0016.\\3Ng~#S-\u001d\u000b\u0005\u0003\u0003\t9\u0001E\u0002,\u0003\u0007I1!!\u0002-\u0005\u0011)f.\u001b;\t\u0011\u0005%\u0011\"!AA\u0002a\f1\u0001\u001f\u00132\u0003Qa\u0017m\u001d;Fq\u0016\u001cW\u000f^5p]RKW.Z'tA!\"!\"T,Y\u0003E\u00198\r[3ek2,G-\u0012=fGV$xN]\u000b\u0003\u0003'\u0001BaK=\u0002\u0016A!\u0011qCA\u0010\u001b\t\tIBC\u0002Q\u00037Q1!!\b`\u0003\u0011)H/\u001b7\n\t\u0005\u0005\u0012\u0011\u0004\u0002\u0019'\u000eDW\rZ;mK\u0012,\u00050Z2vi>\u00148+\u001a:wS\u000e,\u0017!F:dQ\u0016$W\u000f\\3e\u000bb,7-\u001e;pe~#S-\u001d\u000b\u0005\u0003\u0003\t9\u0003C\u0005\u0002\n1\t\t\u00111\u0001\u0002\u0014\u0005\u00112o\u00195fIVdW\rZ#yK\u000e,Ho\u001c:!\u0003M\u0019'/Z1uK\u0016CXmY;uK\"{G\u000eZ3s)\rA\u0015q\u0006\u0005\b\u0003cq\u0001\u0019AA\u001a\u0003\u001d\u0011X-];fgR\u0004B!!\u000e\u0002>5\u0011\u0011q\u0007\u0006\u0005\u0003s\tY$A\u0003qe>$xN\u0003\u0002!G%!\u0011qHA\u001c\u0005I)\u00050Z2vi\u0016\u0004F.\u00198SKF,Xm\u001d;\u0002'I,Wn\u001c<f\u000bb,7-\u001e;f\u0011>dG-\u001a:\u0015\r\u0005\u0005\u0011QIA%\u0011\u0019\t9e\u0004a\u0001\u000b\u0006\u00191.Z=\t\u0013\u0005-s\u0002%AA\u0002\u00055\u0013!C1cC:$wN\\3e!\rY\u0013qJ\u0005\u0004\u0003#b#a\u0002\"p_2,\u0017M\\\u0001\u001ee\u0016lwN^3Fq\u0016\u001cW\u000f^3I_2$WM\u001d\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011q\u000b\u0016\u0005\u0003\u001b\nIf\u000b\u0002\u0002\\A!\u0011QLA3\u001b\t\tyF\u0003\u0003\u0002b\u0005\r\u0014!C;oG\",7m[3e\u0015\t\u0011F&\u0003\u0003\u0002h\u0005}#!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006\u0001r-\u001a;Fq\u0016\u001cW\u000f^3I_2$WM\u001d\u000b\u0005\u0003[\ny\u0007E\u0002,s\"Ca!a\u0012\u0012\u0001\u0004)\u0015!\b:f[>4X-\u00117m\u000bb,7-\u001e;j_:\u001chi\u001c:TKN\u001c\u0018n\u001c8\u0015\t\u0005\u0005\u0011Q\u000f\u0005\b\u0003\u000f\u0012\u0002\u0019AA<!\rQ\u0014\u0011P\u0005\u0004\u0003wj\"AC*fgNLwN\\&fs\u0006)r-\u001a;BE\u0006tGm\u001c8fIR{WNY:u_:,G\u0003BAA\u0003\u0007\u00032aK=s\u0011\u0019\t9e\u0005a\u0001\u000b\u0006!B.[:u\u0003\u000e$\u0018N^3Fq\u0016\u001cW\u000f^5p]N,\"!!#\u0011\u000f\u0005-\u00151T>\u0002\":!\u0011QRAL\u001d\u0011\ty)!&\u000e\u0005\u0005E%bAAJo\u00051AH]8pizJ\u0011!L\u0005\u0004\u00033c\u0013a\u00029bG.\fw-Z\u0005\u0005\u0003;\u000byJ\u0001\u0004FSRDWM\u001d\u0006\u0004\u00033c\u0003#BAF\u0003G\u0013\u0018\u0002BAS\u0003?\u00131aU3r\u0003]a\u0017n\u001d;BE\u0006tGm\u001c8fI\u0016CXmY;uS>t7/\u0006\u0002\u0002\"\u0006A1\u000f[;uI><h\u000e\u0006\u0002\u0002\u0002\u000512o\u00195fIVdW\rU3sS>$\u0017nY\"iK\u000e\\7/A\nqKJLw\u000eZ5d\u001b\u0006Lg\u000e^3oC:\u001cW\r\u0006\u0003\u0002\u0002\u0005U\u0006BBA\\1\u0001\u000710A\u0004uS6,w.\u001e;\u0002%M,G/\u00117m%B\u001b5\u000fR3bI2Lg.\u001a\u000b\u0005\u0003\u0003\ti\f\u0003\u0004\u0002@f\u0001\ra_\u0001\u000bI\u0016\fG\r\\5oK6\u001b\u0018\u0001E5oi\u0016\u0014(/\u001e9u\u00032d'\u000bU\"t\u0003Ia\u0017n\u001d;Fq\u0016\u001cW\u000f^3I_2$WM]:\u0016\u0005\u0005\u001d\u0007#BAF\u0003GC\u0005")
public class SparkConnectExecutionManager
implements Logging {
    @GuardedBy(value="executionsLock")
    private final scala.collection.mutable.HashMap<ExecuteKey, ExecuteHolder> executions;
    private final Object executionsLock;
    private final Cache<ExecuteKey, ExecuteInfo> abandonedTombstones;
    @GuardedBy(value="executionsLock")
    private Option<Object> lastExecutionTimeMs;
    private Option<ScheduledExecutorService> scheduledExecutor;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(HashMap<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private scala.collection.mutable.HashMap<ExecuteKey, ExecuteHolder> executions() {
        return this.executions;
    }

    private Object executionsLock() {
        return this.executionsLock;
    }

    private Cache<ExecuteKey, ExecuteInfo> abandonedTombstones() {
        return this.abandonedTombstones;
    }

    private Option<Object> lastExecutionTimeMs() {
        return this.lastExecutionTimeMs;
    }

    private void lastExecutionTimeMs_$eq(Option<Object> x$1) {
        this.lastExecutionTimeMs = x$1;
    }

    private Option<ScheduledExecutorService> scheduledExecutor() {
        return this.scheduledExecutor;
    }

    private void scheduledExecutor_$eq(Option<ScheduledExecutorService> x$1) {
        this.scheduledExecutor = x$1;
    }

    public ExecuteHolder createExecuteHolder(ExecutePlanRequest request) {
        Some some;
        boolean bl = request.hasClientObservedServerSideSessionId();
        if (bl) {
            some = new Some((Object)request.getClientObservedServerSideSessionId());
        } else if (!bl) {
            some = None$.MODULE$;
        } else {
            throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
        }
        Some previousSessionId = some;
        SessionHolder sessionHolder = SparkConnectService$.MODULE$.getOrCreateIsolatedSession(request.getUserContext().getUserId(), request.getSessionId(), (Option<String>)previousSessionId);
        ExecuteHolder executeHolder = new ExecuteHolder(request, sessionHolder);
        Object object = this.executionsLock();
        synchronized (object) {
            if (this.executions().get((Object)executeHolder.key()).isDefined()) {
                throw new SparkSQLException("INVALID_HANDLE.OPERATION_ALREADY_EXISTS", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"handle"), (Object)executeHolder.operationId())})));
            }
            if (this.getAbandonedTombstone(executeHolder.key()).isDefined()) {
                throw new SparkSQLException("INVALID_HANDLE.OPERATION_ABANDONED", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"handle"), (Object)executeHolder.operationId())})));
            }
            sessionHolder.addExecuteHolder(executeHolder);
            this.executions().put((Object)executeHolder.key(), (Object)executeHolder);
            this.lastExecutionTimeMs_$eq((Option<Object>)None$.MODULE$);
            this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"ExecuteHolder ", " is created."}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.EXECUTE_KEY$.MODULE$, (Object)executeHolder.key())}))));
        }
        this.schedulePeriodicChecks();
        return executeHolder;
    }

    public void removeExecuteHolder(ExecuteKey key, boolean abandoned) {
        None$ executeHolder = None$.MODULE$;
        Object object = this.executionsLock();
        synchronized (object) {
            executeHolder = this.executions().remove((Object)key);
            executeHolder.foreach((Function1 & Serializable)e -> {
                SparkConnectExecutionManager.$anonfun$removeExecuteHolder$1(this, abandoned, key, e);
                return BoxedUnit.UNIT;
            });
            if (this.executions().isEmpty()) {
                this.lastExecutionTimeMs_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)System.currentTimeMillis())));
            }
            this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"ExecuteHolder ", " is removed."}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.EXECUTE_KEY$.MODULE$, (Object)key)}))));
        }
        executeHolder.foreach((Function1 & Serializable)e -> {
            SparkConnectExecutionManager.$anonfun$removeExecuteHolder$3(this, abandoned, key, e);
            return BoxedUnit.UNIT;
        });
    }

    public boolean removeExecuteHolder$default$2() {
        return false;
    }

    public Option<ExecuteHolder> getExecuteHolder(ExecuteKey key) {
        Option option;
        Object object = this.executionsLock();
        synchronized (object) {
            option = this.executions().get((Object)key);
        }
        return option;
    }

    public void removeAllExecutionsForSession(SessionKey key) {
        scala.collection.mutable.HashMap hashMap;
        Object object = this.executionsLock();
        synchronized (object) {
            hashMap = (scala.collection.mutable.HashMap)this.executions().filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)SparkConnectExecutionManager.$anonfun$removeAllExecutionsForSession$1(key, x$1)));
        }
        scala.collection.mutable.HashMap sessionExecutionHolders = hashMap;
        sessionExecutionHolders.foreach((Function1 & Serializable)x0$1 -> {
            SparkConnectExecutionManager.$anonfun$removeAllExecutionsForSession$2(this, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public Option<ExecuteInfo> getAbandonedTombstone(ExecuteKey key) {
        return Option$.MODULE$.apply((Object)this.abandonedTombstones().getIfPresent(key));
    }

    public Either<Object, Seq<ExecuteInfo>> listActiveExecutions() {
        Left left;
        Object object = this.executionsLock();
        synchronized (object) {
            left = this.executions().isEmpty() ? new Left(this.lastExecutionTimeMs().get()) : new Right((Object)((IterableOnceOps)this.executions().values().map((Function1 & Serializable)x$2 -> x$2.getExecuteInfo())).toBuffer().toSeq());
        }
        return left;
    }

    public Seq<ExecuteInfo> listAbandonedExecutions() {
        return CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(this.abandonedTombstones().asMap()).asScala().values().toSeq();
    }

    public void shutdown() {
        Object object = this.executionsLock();
        synchronized (object) {
            this.scheduledExecutor().foreach((Function1 & Serializable)executor -> {
                ThreadUtils$.MODULE$.shutdown((ExecutorService)executor, (Duration)FiniteDuration$.MODULE$.apply(1L, TimeUnit.MINUTES));
                return BoxedUnit.UNIT;
            });
            this.scheduledExecutor_$eq((Option<ScheduledExecutorService>)None$.MODULE$);
            this.executions().clear();
            this.abandonedTombstones().invalidateAll();
            if (this.lastExecutionTimeMs().isEmpty()) {
                this.lastExecutionTimeMs_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)System.currentTimeMillis())));
            }
        }
    }

    private void schedulePeriodicChecks() {
        Object object = this.executionsLock();
        synchronized (object) {
            Option<ScheduledExecutorService> option = this.scheduledExecutor();
            if (option instanceof Some) {
            } else if (None$.MODULE$.equals(option)) {
                long interval = BoxesRunTime.unboxToLong((Object)SparkEnv$.MODULE$.get().conf().get(Connect$.MODULE$.CONNECT_EXECUTE_MANAGER_MAINTENANCE_INTERVAL()));
                this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Starting thread for cleanup of abandoned executions every "}))).log((Seq)Nil$.MODULE$).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", " ms"}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.INTERVAL$.MODULE$, (Object)BoxesRunTime.boxToLong((long)interval))})))));
                this.scheduledExecutor_$eq((Option<ScheduledExecutorService>)new Some((Object)Executors.newSingleThreadScheduledExecutor()));
                ((ScheduledExecutorService)this.scheduledExecutor().get()).scheduleAtFixedRate(() -> {
                    try {
                        long timeout = BoxesRunTime.unboxToLong((Object)SparkEnv$.MODULE$.get().conf().get(Connect$.MODULE$.CONNECT_EXECUTE_MANAGER_DETACHED_TIMEOUT()));
                        this.periodicMaintenance(timeout);
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2 = throwable;
                        if (NonFatal$.MODULE$.apply(throwable2)) {
                            this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Unexpected exception in periodic task", throwable2);
                        }
                        throw throwable;
                    }
                }, interval, interval, TimeUnit.MILLISECONDS);
            } else {
                throw new MatchError(option);
            }
        }
    }

    public void periodicMaintenance(long timeout) {
        this.logInfo((Function0<String>)(Function0 & Serializable)() -> "Started periodic run of SparkConnectExecutionManager maintenance.");
        ArrayBuffer toRemove = new ArrayBuffer();
        Object object = this.executionsLock();
        synchronized (object) {
            long nowMs = System.currentTimeMillis();
            this.executions().values().foreach((Function1 & Serializable)executeHolder -> {
                Option<Object> option = executeHolder.lastAttachedRpcTimeMs();
                if (option instanceof Some) {
                    Some some = (Some)option;
                    long detached = BoxesRunTime.unboxToLong((Object)some.value());
                    if (detached + timeout <= nowMs) {
                        return toRemove.$plus$eq(executeHolder);
                    }
                    return BoxedUnit.UNIT;
                }
                return BoxedUnit.UNIT;
            });
        }
        toRemove.foreach((Function1 & Serializable)executeHolder -> {
            SparkConnectExecutionManager.$anonfun$periodicMaintenance$3(this, executeHolder);
            return BoxedUnit.UNIT;
        });
        this.logInfo((Function0<String>)(Function0 & Serializable)() -> "Finished periodic run of SparkConnectExecutionManager maintenance.");
    }

    public void setAllRPCsDeadline(long deadlineMs) {
        Object object = this.executionsLock();
        synchronized (object) {
            this.executions().values().foreach((Function1 & Serializable)x$3 -> {
                x$3.setGrpcResponseSendersDeadline(deadlineMs);
                return BoxedUnit.UNIT;
            });
        }
    }

    public void interruptAllRPCs() {
        Object object = this.executionsLock();
        synchronized (object) {
            this.executions().values().foreach((Function1 & Serializable)x$4 -> {
                x$4.interruptGrpcResponseSenders();
                return BoxedUnit.UNIT;
            });
        }
    }

    public Seq<ExecuteHolder> listExecuteHolders() {
        Seq seq;
        Object object = this.executionsLock();
        synchronized (object) {
            seq = this.executions().values().toSeq();
        }
        return seq;
    }

    public static final /* synthetic */ void $anonfun$removeExecuteHolder$1(SparkConnectExecutionManager $this, boolean abandoned$1, ExecuteKey key$1, ExecuteHolder e) {
        if (abandoned$1) {
            $this.abandonedTombstones().put(key$1, e.getExecuteInfo());
        }
        e.sessionHolder().removeExecuteHolder(e.operationId());
    }

    public static final /* synthetic */ void $anonfun$removeExecuteHolder$3(SparkConnectExecutionManager $this, boolean abandoned$1, ExecuteKey key$1, ExecuteHolder e) {
        e.close();
        if (abandoned$1) {
            $this.abandonedTombstones().put(key$1, e.getExecuteInfo());
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$removeAllExecutionsForSession$1(SessionKey key$2, Tuple2 x$1) {
        SessionKey sessionKey = ((ExecuteHolder)x$1._2()).sessionHolder().key();
        SessionKey sessionKey2 = key$2;
        return !(sessionKey != null ? !((Object)sessionKey).equals(sessionKey2) : sessionKey2 != null);
    }

    public static final /* synthetic */ void $anonfun$removeAllExecutionsForSession$2(SparkConnectExecutionManager $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            ExecuteHolder executeHolder = (ExecuteHolder)tuple2._2();
            ExecuteInfo info = executeHolder.getExecuteInfo();
            $this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> $this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Execution ", " removed in removeSessionExecutions."}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.EXECUTE_INFO$.MODULE$, (Object)info)}))));
            $this.removeExecuteHolder(executeHolder.key(), true);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$periodicMaintenance$3(SparkConnectExecutionManager $this, ExecuteHolder executeHolder) {
        ExecuteInfo info = executeHolder.getExecuteInfo();
        $this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> $this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Found execution ", " that was abandoned "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.EXECUTE_INFO$.MODULE$, (Object)info)})).$plus($this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"and expired and will be removed."}))).log((Seq)Nil$.MODULE$))));
        $this.removeExecuteHolder(executeHolder.key(), true);
    }

    public SparkConnectExecutionManager() {
        Logging.$init$((Logging)this);
        this.executions = new scala.collection.mutable.HashMap();
        this.executionsLock = new Object();
        this.abandonedTombstones = CacheBuilder.newBuilder().maximumSize(BoxesRunTime.unboxToInt((Object)SparkEnv$.MODULE$.get().conf().get(Connect$.MODULE$.CONNECT_EXECUTE_MANAGER_ABANDONED_TOMBSTONES_SIZE()))).build();
        this.lastExecutionTimeMs = new Some((Object)BoxesRunTime.boxToLong((long)System.currentTimeMillis()));
        this.scheduledExecutor = None$.MODULE$;
    }
}

