/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connect.service;

import java.io.Serializable;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkEnv$;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.config.UI$;
import org.apache.spark.scheduler.SparkListenerInterface;
import org.apache.spark.sql.connect.config.Connect$;
import org.apache.spark.sql.connect.execution.ConnectProgressExecutionListener;
import org.apache.spark.sql.connect.service.ExecuteInfo;
import org.apache.spark.sql.connect.service.SessionHolder;
import org.apache.spark.sql.connect.service.SessionKey;
import org.apache.spark.sql.connect.service.SparkConnectExecutionManager;
import org.apache.spark.sql.connect.service.SparkConnectInterceptorRegistry$;
import org.apache.spark.sql.connect.service.SparkConnectService;
import org.apache.spark.sql.connect.service.SparkConnectSessionManager;
import org.apache.spark.sql.connect.service.SparkConnectStreamingQueryCache;
import org.apache.spark.sql.connect.service.SparkConnectStreamingQueryCache$;
import org.apache.spark.sql.connect.ui.SparkConnectServerAppStatusStore;
import org.apache.spark.sql.connect.ui.SparkConnectServerListener;
import org.apache.spark.sql.connect.ui.SparkConnectServerListener$;
import org.apache.spark.sql.connect.ui.SparkConnectServerTab;
import org.apache.spark.sql.connect.ui.SparkConnectServerTab$;
import org.apache.spark.status.ElementTrackingStore;
import org.apache.spark.util.kvstore.KVStore;
import org.slf4j.Logger;
import org.sparkproject.connect.grpc.Server;
import org.sparkproject.connect.grpc.netty.NettyServerBuilder;
import org.sparkproject.connect.grpc.protobuf.services.ProtoReflectionService;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;

public final class SparkConnectService$
implements Logging {
    public static final SparkConnectService$ MODULE$ = new SparkConnectService$();
    private static SparkConnectExecutionManager executionManager;
    private static SparkConnectSessionManager sessionManager;
    private static Server server;
    private static Option<SparkConnectServerTab> uiTab;
    private static SparkConnectServerListener listener;
    private static Option<ConnectProgressExecutionListener> executionListener;
    private static final SparkConnectStreamingQueryCache streamingSessionManager;
    private static transient Logger org$apache$spark$internal$Logging$$log_;
    private static volatile byte bitmap$0;

    static {
        Logging.$init$((Logging)MODULE$);
        uiTab = None$.MODULE$;
        executionListener = None$.MODULE$;
        streamingSessionManager = new SparkConnectStreamingQueryCache(SparkConnectStreamingQueryCache$.MODULE$.$lessinit$greater$default$1(), SparkConnectStreamingQueryCache$.MODULE$.$lessinit$greater$default$2(), SparkConnectStreamingQueryCache$.MODULE$.$lessinit$greater$default$3());
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(HashMap<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Server server() {
        return server;
    }

    public void server_$eq(Server x$1) {
        server = x$1;
    }

    public Option<SparkConnectServerTab> uiTab() {
        return uiTab;
    }

    public void uiTab_$eq(Option<SparkConnectServerTab> x$1) {
        uiTab = x$1;
    }

    public SparkConnectServerListener listener() {
        return listener;
    }

    public void listener_$eq(SparkConnectServerListener x$1) {
        listener = x$1;
    }

    public Option<ConnectProgressExecutionListener> executionListener() {
        return executionListener;
    }

    public void executionListener_$eq(Option<ConnectProgressExecutionListener> x$1) {
        executionListener = x$1;
    }

    public int localPort() {
        Predef$.MODULE$.assert(this.server() != null);
        return this.server().getPort();
    }

    private SparkConnectExecutionManager executionManager$lzycompute() {
        SparkConnectService$ sparkConnectService$ = this;
        synchronized (sparkConnectService$) {
            if ((byte)(bitmap$0 & 1) == 0) {
                executionManager = new SparkConnectExecutionManager();
                bitmap$0 = (byte)(bitmap$0 | 1);
            }
        }
        return executionManager;
    }

    public SparkConnectExecutionManager executionManager() {
        if ((byte)(bitmap$0 & 1) == 0) {
            return this.executionManager$lzycompute();
        }
        return executionManager;
    }

    private SparkConnectSessionManager sessionManager$lzycompute() {
        SparkConnectService$ sparkConnectService$ = this;
        synchronized (sparkConnectService$) {
            if ((byte)(bitmap$0 & 2) == 0) {
                sessionManager = new SparkConnectSessionManager();
                bitmap$0 = (byte)(bitmap$0 | 2);
            }
        }
        return sessionManager;
    }

    public SparkConnectSessionManager sessionManager() {
        if ((byte)(bitmap$0 & 2) == 0) {
            return this.sessionManager$lzycompute();
        }
        return sessionManager;
    }

    public SparkConnectStreamingQueryCache streamingSessionManager() {
        return streamingSessionManager;
    }

    public SessionHolder getOrCreateIsolatedSession(String userId, String sessionId, Option<String> previoslyObservedSessionId) {
        return this.sessionManager().getOrCreateIsolatedSession(new SessionKey(userId, sessionId), previoslyObservedSessionId);
    }

    public SessionHolder getOrCreateIsolatedSession(String userId, String sessionId) {
        return this.getOrCreateIsolatedSession(userId, sessionId, (Option<String>)None$.MODULE$);
    }

    public Either<Object, Seq<ExecuteInfo>> listActiveExecutions() {
        return this.executionManager().listActiveExecutions();
    }

    private void createListenerAndUI(SparkContext sc) {
        ElementTrackingStore kvStore = (ElementTrackingStore)sc.statusStore().store();
        this.listener_$eq(new SparkConnectServerListener(kvStore, sc.conf(), SparkConnectServerListener$.MODULE$.$lessinit$greater$default$3()));
        sc.listenerBus().addToStatusQueue((SparkListenerInterface)this.listener());
        this.uiTab_$eq((Option<SparkConnectServerTab>)(BoxesRunTime.unboxToBoolean((Object)sc.getConf().get(UI$.MODULE$.UI_ENABLED())) ? new Some((Object)new SparkConnectServerTab(new SparkConnectServerAppStatusStore((KVStore)kvStore), SparkConnectServerTab$.MODULE$.getSparkUI(sc))) : None$.MODULE$));
        this.executionListener_$eq((Option<ConnectProgressExecutionListener>)new Some((Object)new ConnectProgressExecutionListener()));
        sc.addSparkListener((SparkListenerInterface)this.executionListener().get());
    }

    private void startGRPCService() {
        NettyServerBuilder nettyServerBuilder;
        boolean debugMode = SparkEnv$.MODULE$.get().conf().getBoolean("spark.connect.grpc.debug.enabled", true);
        Option bindAddress = (Option)SparkEnv$.MODULE$.get().conf().get(Connect$.MODULE$.CONNECT_GRPC_BINDING_ADDRESS());
        int port = BoxesRunTime.unboxToInt((Object)SparkEnv$.MODULE$.get().conf().get(Connect$.MODULE$.CONNECT_GRPC_BINDING_PORT()));
        Option option = bindAddress;
        if (option instanceof Some) {
            Some some = (Some)option;
            String hostname = (String)some.value();
            this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"start GRPC service at: ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.HOST$.MODULE$, (Object)hostname)}))));
            nettyServerBuilder = NettyServerBuilder.forAddress(new InetSocketAddress(hostname, port));
        } else {
            nettyServerBuilder = NettyServerBuilder.forPort(port);
        }
        NettyServerBuilder sb = nettyServerBuilder;
        sb.maxInboundMessageSize((int)BoxesRunTime.unboxToLong((Object)SparkEnv$.MODULE$.get().conf().get(Connect$.MODULE$.CONNECT_GRPC_MAX_INBOUND_MESSAGE_SIZE()))).addService(new SparkConnectService(debugMode));
        SparkConnectInterceptorRegistry$.MODULE$.chainInterceptors(sb);
        Object object = debugMode ? sb.addService(ProtoReflectionService.newInstance()) : BoxedUnit.UNIT;
        this.server_$eq(sb.build());
        this.server().start();
    }

    public void start(SparkContext sc) {
        this.startGRPCService();
        this.createListenerAndUI(sc);
    }

    public void stop(Option<Object> timeout, Option<TimeUnit> unit) {
        if (this.server() != null) {
            if (timeout.isDefined() && unit.isDefined()) {
                this.server().shutdown();
                v0 = BoxesRunTime.boxToBoolean((boolean)this.server().awaitTermination(BoxesRunTime.unboxToLong((Object)timeout.get()), (TimeUnit)((Object)unit.get())));
            } else {
                v0 = this.server().shutdownNow();
            }
        } else {
            v0 = BoxedUnit.UNIT;
        }
        this.streamingSessionManager().shutdown();
        this.executionManager().shutdown();
        this.sessionManager().shutdown();
        this.uiTab().foreach((Function1 & Serializable)x$3 -> {
            x$3.detach();
            return BoxedUnit.UNIT;
        });
    }

    public Option<Object> stop$default$1() {
        return None$.MODULE$;
    }

    public Option<TimeUnit> stop$default$2() {
        return None$.MODULE$;
    }

    public String extractErrorMessage(Throwable st) {
        String message = StringUtils.abbreviate((String)st.getMessage(), (int)2048);
        return this.convertNullString(message);
    }

    public String convertNullString(String str) {
        if (str != null) {
            return str;
        }
        return "";
    }

    private SparkConnectService$() {
    }
}

