/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connect.service;

import java.io.Serializable;
import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.GuardedBy;
import org.apache.spark.SparkEnv$;
import org.apache.spark.SparkSQLException;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.connect.config.Connect$;
import org.apache.spark.sql.connect.service.SessionHolder;
import org.apache.spark.sql.connect.service.SessionHolderInfo;
import org.apache.spark.sql.connect.service.SessionKey;
import org.apache.spark.util.ThreadUtils$;
import org.slf4j.Logger;
import org.sparkproject.connect.guava.cache.Cache;
import org.sparkproject.connect.guava.cache.CacheBuilder;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.HashMap$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\u0005Mg\u0001B\u000f\u001f\u0001-BQ\u0001\u000f\u0001\u0005\u0002eBq\u0001\u0010\u0001C\u0002\u0013%Q\b\u0003\u0004G\u0001\u0001\u0006IA\u0010\u0005\b\u000f\u0002\u0011\r\u0011\"\u0003I\u0011\u00199\u0006\u0001)A\u0005\u0013\"9Q\r\u0001b\u0001\n\u00131\u0007B\u0002<\u0001A\u0003%q\rC\u0004x\u0001\u0001\u0007I\u0011\u0002=\t\u0013\u0005\u001d\u0001\u00011A\u0005\n\u0005%\u0001bBA\u000b\u0001\u0001\u0006K!\u001f\u0005\b\u0003/\u0001A\u0011BA\r\u0011!\ti\u0004\u0001C\u0001A\u0005}\u0002\u0002CA%\u0001\u0011\u0005\u0001%a\u0013\t\u0011\u0005E\u0003\u0001\"\u0001!\u0003'Bq!!\u0017\u0001\t\u0013\tY\u0006C\u0004\u0002l\u0001!I!!\u001c\t\u000f\u0005E\u0004\u0001\"\u0003\u0002t!9\u0011\u0011\u0010\u0001\u0005\u0002\u0005m\u0004\u0002CA@\u0001\u0011\u0005\u0001%!!\t\u000f\u0005\r\u0005\u0001\"\u0001\u0002\u0006\"9\u0011\u0011\u0014\u0001\u0005\u0002\u0005\u0015\u0005bBAN\u0001\u0011%\u0011\u0011\u0011\u0005\t\u0003;\u0003A\u0011\u0001\u0011\u0002 \"9\u0011Q\u0014\u0001\u0005\n\u0005-\u0006bBA]\u0001\u0011%\u00111\u0018\u0005\b\u0003\u000b\u0004A\u0011BAd\u0011!\tY\r\u0001C\u0001A\u0005\u0005\u0005\u0002CAg\u0001\u0011\u0005\u0001%a4\u00035M\u0003\u0018M]6D_:tWm\u0019;TKN\u001c\u0018n\u001c8NC:\fw-\u001a:\u000b\u0005}\u0001\u0013aB:feZL7-\u001a\u0006\u0003C\t\nqaY8o]\u0016\u001cGO\u0003\u0002$I\u0005\u00191/\u001d7\u000b\u0005\u00152\u0013!B:qCJ\\'BA\u0014)\u0003\u0019\t\u0007/Y2iK*\t\u0011&A\u0002pe\u001e\u001c\u0001aE\u0002\u0001YI\u0002\"!\f\u0019\u000e\u00039R\u0011aL\u0001\u0006g\u000e\fG.Y\u0005\u0003c9\u0012a!\u00118z%\u00164\u0007CA\u001a7\u001b\u0005!$BA\u001b%\u0003!Ig\u000e^3s]\u0006d\u0017BA\u001c5\u0005\u001daunZ4j]\u001e\fa\u0001P5oSRtD#\u0001\u001e\u0011\u0005m\u0002Q\"\u0001\u0010\u0002\u0019M,7o]5p]NdunY6\u0016\u0003y\u0002\"a\u0010#\u000e\u0003\u0001S!!\u0011\"\u0002\t1\fgn\u001a\u0006\u0002\u0007\u0006!!.\u0019<b\u0013\t)\u0005I\u0001\u0004PE*,7\r^\u0001\u000eg\u0016\u001c8/[8og2{7m\u001b\u0011\u0002\u0019M,7o]5p]N#xN]3\u0016\u0003%\u0003BAS(R)6\t1J\u0003\u0002M\u001b\u00069Q.\u001e;bE2,'B\u0001(/\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003!.\u0013q\u0001S1tQ6\u000b\u0007\u000f\u0005\u0002<%&\u00111K\b\u0002\u000b'\u0016\u001c8/[8o\u0017\u0016L\bCA\u001eV\u0013\t1fDA\u0007TKN\u001c\u0018n\u001c8I_2$WM]\u0001\u000eg\u0016\u001c8/[8o'R|'/\u001a\u0011)\t\u0015I6\r\u001a\t\u00035\u0006l\u0011a\u0017\u0006\u00039v\u000b!bY8oGV\u0014(/\u001a8u\u0015\tqv,\u0001\u0006b]:|G/\u0019;j_:T\u0011\u0001Y\u0001\u0006U\u00064\u0018\r_\u0005\u0003En\u0013\u0011bR;be\u0012,GMQ=\u0002\u000bY\fG.^3\"\u0003q\n1c\u00197pg\u0016$7+Z:tS>t7oQ1dQ\u0016,\u0012a\u001a\t\u0005QF\f6/D\u0001j\u0015\tQ7.A\u0003dC\u000eDWM\u0003\u0002m[\u000611m\\7n_:T!A\\8\u0002\r\u001d|wn\u001a7f\u0015\u0005\u0001\u0018aA2p[&\u0011!/\u001b\u0002\u0006\u0007\u0006\u001c\u0007.\u001a\t\u0003wQL!!\u001e\u0010\u0003#M+7o]5p]\"{G\u000eZ3s\u0013:4w.\u0001\u000bdY>\u001cX\rZ*fgNLwN\\:DC\u000eDW\rI\u0001\u0012g\u000eDW\rZ;mK\u0012,\u00050Z2vi>\u0014X#A=\u0011\u00075RH0\u0003\u0002|]\t1q\n\u001d;j_:\u00042!`A\u0002\u001b\u0005q(B\u0001/\u0000\u0015\r\t\tAQ\u0001\u0005kRLG.C\u0002\u0002\u0006y\u0014\u0001dU2iK\u0012,H.\u001a3Fq\u0016\u001cW\u000f^8s'\u0016\u0014h/[2f\u0003U\u00198\r[3ek2,G-\u0012=fGV$xN]0%KF$B!a\u0003\u0002\u0012A\u0019Q&!\u0004\n\u0007\u0005=aF\u0001\u0003V]&$\b\u0002CA\n\u0013\u0005\u0005\t\u0019A=\u0002\u0007a$\u0013'\u0001\ntG\",G-\u001e7fI\u0016CXmY;u_J\u0004\u0013!\u0005<bY&$\u0017\r^3TKN\u001c\u0018n\u001c8JIRA\u00111BA\u000e\u0003?\tI\u0004\u0003\u0004\u0002\u001e-\u0001\r!U\u0001\u0004W\u0016L\bbBA\u0011\u0017\u0001\u0007\u00111E\u0001\fg\u0016\u001c8/[8o+VKE\t\u0005\u0003\u0002&\u0005Mb\u0002BA\u0014\u0003_\u00012!!\u000b/\u001b\t\tYCC\u0002\u0002.)\na\u0001\u0010:p_Rt\u0014bAA\u0019]\u00051\u0001K]3eK\u001aLA!!\u000e\u00028\t11\u000b\u001e:j]\u001eT1!!\r/\u0011\u001d\tYd\u0003a\u0001\u0003G\t1\u0004\u001d:fm&|Wo\u001d7z\u001f\n\u001cXM\u001d<fIN+7o]5p]&#\u0017AG4fi>\u00138I]3bi\u0016L5o\u001c7bi\u0016$7+Z:tS>tG#\u0002+\u0002B\u0005\r\u0003BBA\u000f\u0019\u0001\u0007\u0011\u000bC\u0004\u0002F1\u0001\r!a\u0012\u00029A\u0014XM^5pkNd\u0017p\u00142tKJ4X\rZ*fgN\u001c\u0018n\u001c8JIB!QF_A\u0012\u0003I9W\r^%t_2\fG/\u001a3TKN\u001c\u0018n\u001c8\u0015\u000bQ\u000bi%a\u0014\t\r\u0005uQ\u00021\u0001R\u0011\u001d\t)%\u0004a\u0001\u0003\u000f\n1dZ3u\u0013N|G.\u0019;fIN+7o]5p]&3\u0007K]3tK:$H\u0003BA+\u0003/\u00022!\f>U\u0011\u0019\tiB\u0004a\u0001#\u0006Qq-\u001a;TKN\u001c\u0018n\u001c8\u0015\u000bQ\u000bi&a\u0018\t\r\u0005uq\u00021\u0001R\u0011\u001d\t\tg\u0004a\u0001\u0003G\nq\u0001Z3gCVdG\u000f\u0005\u0003.u\u0006\u0015\u0004\u0003B\u0017\u0002hQK1!!\u001b/\u0005%1UO\\2uS>t\u0007'A\nsK6|g/Z*fgNLwN\u001c%pY\u0012,'\u000f\u0006\u0003\u0002V\u0005=\u0004BBA\u000f!\u0001\u0007\u0011+A\u000btQV$Hm\\<o'\u0016\u001c8/[8o\u0011>dG-\u001a:\u0015\t\u0005-\u0011Q\u000f\u0005\u0007\u0003o\n\u0002\u0019\u0001+\u0002\u001bM,7o]5p]\"{G\u000eZ3s\u00031\u0019Gn\\:f'\u0016\u001c8/[8o)\u0011\tY!! \t\r\u0005u!\u00031\u0001R\u0003!\u0019\b.\u001e;e_^tGCAA\u0006\u0003Ia\u0017n\u001d;BGRLg/Z*fgNLwN\\:\u0016\u0005\u0005\u001d\u0005#BAE\u0003'\u001bh\u0002BAF\u0003\u001fsA!!\u000b\u0002\u000e&\tq&C\u0002\u0002\u0012:\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002\u0016\u0006]%aA*fc*\u0019\u0011\u0011\u0013\u0018\u0002%1L7\u000f^\"m_N,GmU3tg&|gn]\u0001\u0017g\u000eDW\rZ;mKB+'/[8eS\u000e\u001c\u0005.Z2lg\u0006\u0019\u0002/\u001a:j_\u0012L7-T1j]R,g.\u00198dKR!\u00111BAQ\u0011\u001d\t\u0019k\u0006a\u0001\u0003K\u000b\u0001\u0004Z3gCVdG/\u00138bGRLg/\u001a+j[\u0016|W\u000f^'t!\ri\u0013qU\u0005\u0004\u0003Ss#\u0001\u0002'p]\u001e$b!a\u0003\u0002.\u0006=\u0006bBAR1\u0001\u0007\u0011Q\u0015\u0005\b\u0003cC\u0002\u0019AAZ\u0003MIwM\\8sK\u000e+8\u000f^8n)&lWm\\;u!\ri\u0013QW\u0005\u0004\u0003os#a\u0002\"p_2,\u0017M\\\u0001\u0013]\u0016<\u0018j]8mCR,GmU3tg&|g\u000e\u0006\u0002\u0002>B!\u0011qXAa\u001b\u0005\u0011\u0013bAAbE\ta1\u000b]1sWN+7o]5p]\u0006)b/\u00197jI\u0006$XmU3tg&|gn\u0011:fCR,G\u0003BA\u0006\u0003\u0013Da!!\b\u001b\u0001\u0004\t\u0016!F5om\u0006d\u0017\u000eZ1uK\u0006cGnU3tg&|gn]\u0001\u0015aV$8+Z:tS>tgi\u001c:UKN$\u0018N\\4\u0015\t\u0005-\u0011\u0011\u001b\u0005\u0007\u0003ob\u0002\u0019\u0001+")
public class SparkConnectSessionManager
implements Logging {
    private final Object sessionsLock;
    @GuardedBy(value="sessionsLock")
    private final scala.collection.mutable.HashMap<SessionKey, SessionHolder> sessionStore;
    private final Cache<SessionKey, SessionHolderInfo> closedSessionsCache;
    private Option<ScheduledExecutorService> scheduledExecutor;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(HashMap<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private Object sessionsLock() {
        return this.sessionsLock;
    }

    private scala.collection.mutable.HashMap<SessionKey, SessionHolder> sessionStore() {
        return this.sessionStore;
    }

    private Cache<SessionKey, SessionHolderInfo> closedSessionsCache() {
        return this.closedSessionsCache;
    }

    private Option<ScheduledExecutorService> scheduledExecutor() {
        return this.scheduledExecutor;
    }

    private void scheduledExecutor_$eq(Option<ScheduledExecutorService> x$1) {
        this.scheduledExecutor = x$1;
    }

    private void validateSessionId(SessionKey key, String sessionUUID, String previouslyObservedSessionId) {
        String string = sessionUUID;
        String string2 = previouslyObservedSessionId;
        if (string == null ? string2 != null : !string.equals(string2)) {
            throw new SparkSQLException("INVALID_HANDLE.SESSION_CHANGED", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"handle"), (Object)key.sessionId())})));
        }
    }

    public SessionHolder getOrCreateIsolatedSession(SessionKey key, Option<String> previouslyObservedSesssionId) {
        SessionHolder holder = this.getSession(key, (Option<Function0<SessionHolder>>)new Some((Function0 & Serializable)() -> {
            this.validateSessionCreate(key);
            SessionHolder holder = new SessionHolder(key.userId(), key.sessionId(), this.newIsolatedSession());
            holder.initializeSession();
            return holder;
        }));
        previouslyObservedSesssionId.foreach((Function1 & Serializable)sessionId -> {
            this.validateSessionId(key, holder.session().sessionUUID(), sessionId);
            return BoxedUnit.UNIT;
        });
        return holder;
    }

    public SessionHolder getIsolatedSession(SessionKey key, Option<String> previouslyObservedSesssionId) {
        SessionHolder holder = this.getSession(key, (Option<Function0<SessionHolder>>)new Some((Function0 & Serializable)() -> {
            this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Session not found: " + key);
            if (this.closedSessionsCache().getIfPresent(key) != null) {
                throw new SparkSQLException("INVALID_HANDLE.SESSION_CLOSED", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"handle"), (Object)key.sessionId())})));
            }
            throw new SparkSQLException("INVALID_HANDLE.SESSION_NOT_FOUND", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"handle"), (Object)key.sessionId())})));
        }));
        previouslyObservedSesssionId.foreach((Function1 & Serializable)sessionId -> {
            this.validateSessionId(key, holder.session().sessionUUID(), sessionId);
            return BoxedUnit.UNIT;
        });
        return holder;
    }

    public Option<SessionHolder> getIsolatedSessionIfPresent(SessionKey key) {
        return Option$.MODULE$.apply((Object)this.getSession(key, (Option<Function0<SessionHolder>>)None$.MODULE$));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private SessionHolder getSession(SessionKey key, Option<Function0<SessionHolder>> option) {
        this.schedulePeriodicChecks();
        Object object = this.sessionsLock();
        synchronized (object) {
            SessionHolder session;
            SessionHolder sessionHolder;
            Option sessionOpt;
            Option option2 = sessionOpt = this.sessionStore().get((Object)key);
            if (option2 instanceof Some) {
                SessionHolder s2;
                Some some = (Some)option2;
                sessionHolder = s2 = (SessionHolder)some.value();
            } else {
                if (!None$.MODULE$.equals(option2)) throw new MatchError((Object)option2);
                Option<Function0<SessionHolder>> option3 = option;
                if (option3 instanceof Some) {
                    Some some = (Some)option3;
                    Function0 callable = (Function0)some.value();
                    SessionHolder session2 = (SessionHolder)callable.apply();
                    this.sessionStore().put((Object)key, (Object)session2);
                    sessionHolder = session2;
                } else {
                    if (!None$.MODULE$.equals(option3)) throw new MatchError(option3);
                    return null;
                }
            }
            SessionHolder sessionHolder2 = session = sessionHolder;
            if (sessionHolder2 == null) {
                return null;
            }
            if (sessionHolder2 == null) throw new MatchError((Object)sessionHolder2);
            SessionHolder sessionHolder3 = sessionHolder2;
            sessionHolder3.updateAccessTime();
            SessionHolder sessionHolder4 = sessionHolder3;
            return sessionHolder4;
        }
    }

    private Option<SessionHolder> removeSessionHolder(SessionKey key) {
        None$ sessionHolder = None$.MODULE$;
        Object object = this.sessionsLock();
        synchronized (object) {
            sessionHolder = this.sessionStore().remove((Object)key);
            sessionHolder.foreach((Function1 & Serializable)s2 -> {
                SparkConnectSessionManager.$anonfun$removeSessionHolder$1(this, s2);
                return BoxedUnit.UNIT;
            });
        }
        return sessionHolder;
    }

    private void shutdownSessionHolder(SessionHolder sessionHolder) {
        sessionHolder.close();
        this.closedSessionsCache().put(sessionHolder.key(), sessionHolder.getSessionHolderInfo());
    }

    public void closeSession(SessionKey key) {
        Option<SessionHolder> sessionHolder = this.removeSessionHolder(key);
        sessionHolder.foreach((Function1 & Serializable)x$1 -> {
            this.shutdownSessionHolder(x$1);
            return BoxedUnit.UNIT;
        });
    }

    public void shutdown() {
        Object object = this.sessionsLock();
        synchronized (object) {
            this.scheduledExecutor().foreach((Function1 & Serializable)executor -> {
                ThreadUtils$.MODULE$.shutdown((ExecutorService)executor, (Duration)FiniteDuration$.MODULE$.apply(1L, TimeUnit.MINUTES));
                return BoxedUnit.UNIT;
            });
            this.scheduledExecutor_$eq((Option<ScheduledExecutorService>)None$.MODULE$);
            this.sessionStore().clear();
            this.closedSessionsCache().invalidateAll();
        }
    }

    public Seq<SessionHolderInfo> listActiveSessions() {
        Seq seq;
        Object object = this.sessionsLock();
        synchronized (object) {
            seq = ((IterableOnceOps)this.sessionStore().values().map((Function1 & Serializable)x$2 -> x$2.getSessionHolderInfo())).toSeq();
        }
        return seq;
    }

    public Seq<SessionHolderInfo> listClosedSessions() {
        Seq seq;
        Object object = this.sessionsLock();
        synchronized (object) {
            seq = CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(this.closedSessionsCache().asMap()).asScala().values().toSeq();
        }
        return seq;
    }

    private void schedulePeriodicChecks() {
        Object object = this.sessionsLock();
        synchronized (object) {
            Option<ScheduledExecutorService> option = this.scheduledExecutor();
            if (option instanceof Some) {
            } else if (None$.MODULE$.equals(option)) {
                long interval = BoxesRunTime.unboxToLong((Object)SparkEnv$.MODULE$.get().conf().get(Connect$.MODULE$.CONNECT_SESSION_MANAGER_MAINTENANCE_INTERVAL()));
                this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Starting thread for cleanup of expired sessions every "}))).log((Seq)Nil$.MODULE$).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", " ms"}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.INTERVAL$.MODULE$, (Object)BoxesRunTime.boxToLong((long)interval))})))));
                this.scheduledExecutor_$eq((Option<ScheduledExecutorService>)new Some((Object)Executors.newSingleThreadScheduledExecutor()));
                ((ScheduledExecutorService)this.scheduledExecutor().get()).scheduleAtFixedRate(() -> {
                    try {
                        long defaultInactiveTimeoutMs = BoxesRunTime.unboxToLong((Object)SparkEnv$.MODULE$.get().conf().get(Connect$.MODULE$.CONNECT_SESSION_MANAGER_DEFAULT_SESSION_TIMEOUT()));
                        this.periodicMaintenance(defaultInactiveTimeoutMs);
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2 = throwable;
                        if (NonFatal$.MODULE$.apply(throwable2)) {
                            this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Unexpected exception in periodic task", throwable2);
                        }
                        throw throwable;
                    }
                }, interval, interval, TimeUnit.MILLISECONDS);
            } else {
                throw new MatchError(option);
            }
        }
    }

    public void periodicMaintenance(long defaultInactiveTimeoutMs) {
        this.periodicMaintenance(defaultInactiveTimeoutMs, false);
    }

    private void periodicMaintenance(long defaultInactiveTimeoutMs, boolean ignoreCustomTimeout) {
        this.logInfo((Function0<String>)(Function0 & Serializable)() -> "Started periodic run of SparkConnectSessionManager maintenance.");
        ArrayBuffer toRemove = new ArrayBuffer();
        Object object = this.sessionsLock();
        synchronized (object) {
            long nowMs = System.currentTimeMillis();
            this.sessionStore().values().foreach((Function1 & Serializable)sessionHolder -> {
                if (SparkConnectSessionManager.shouldExpire$1(sessionHolder.getSessionHolderInfo(), nowMs, ignoreCustomTimeout, defaultInactiveTimeoutMs)) {
                    return toRemove.$plus$eq(sessionHolder);
                }
                return BoxedUnit.UNIT;
            });
        }
        toRemove.foreach((Function1 & Serializable)sessionHolder -> {
            SparkConnectSessionManager.$anonfun$periodicMaintenance$3(this, ignoreCustomTimeout, defaultInactiveTimeoutMs, sessionHolder);
            return BoxedUnit.UNIT;
        });
        this.logInfo((Function0<String>)(Function0 & Serializable)() -> "Finished periodic run of SparkConnectSessionManager maintenance.");
    }

    private SparkSession newIsolatedSession() {
        SparkSession active = SparkSession$.MODULE$.active();
        if (active.sparkContext().isStopped()) {
            Predef$.MODULE$.assert(SparkSession$.MODULE$.getDefaultSession().nonEmpty());
            return ((SparkSession)SparkSession$.MODULE$.getDefaultSession().get()).newSession();
        }
        return active.newSession();
    }

    private void validateSessionCreate(SessionKey key) {
        try {
            UUID.fromString(key.sessionId()).toString();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new SparkSQLException("INVALID_HANDLE.FORMAT", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"handle"), (Object)key.sessionId())})));
        }
        if (this.closedSessionsCache().getIfPresent(key) != null) {
            throw new SparkSQLException("INVALID_HANDLE.SESSION_CLOSED", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"handle"), (Object)key.sessionId())})));
        }
    }

    public void invalidateAllSessions() {
        Object object = this.sessionsLock();
        synchronized (object) {
            this.periodicMaintenance(0L, true);
            Predef$.MODULE$.assert(this.sessionStore().isEmpty());
            this.closedSessionsCache().invalidateAll();
        }
    }

    public void putSessionForTesting(SessionHolder sessionHolder) {
        this.sessionStore().put((Object)sessionHolder.key(), (Object)sessionHolder);
    }

    public static final /* synthetic */ void $anonfun$removeSessionHolder$1(SparkConnectSessionManager $this, SessionHolder s2) {
        $this.closedSessionsCache().put(s2.key(), s2.getSessionHolderInfo());
    }

    private static final boolean shouldExpire$1(SessionHolderInfo info, long nowMs, boolean ignoreCustomTimeout$1, long defaultInactiveTimeoutMs$1) {
        long timeoutMs = info.customInactiveTimeoutMs().isDefined() && !ignoreCustomTimeout$1 ? BoxesRunTime.unboxToLong((Object)info.customInactiveTimeoutMs().get()) : defaultInactiveTimeoutMs$1;
        return timeoutMs != -1L && info.lastAccessTimeMs() + timeoutMs <= nowMs;
    }

    public static final /* synthetic */ void $anonfun$periodicMaintenance$3(SparkConnectSessionManager $this, boolean ignoreCustomTimeout$1, long defaultInactiveTimeoutMs$1, SessionHolder sessionHolder) {
        Option<SessionHolder> option;
        Object object = $this.sessionsLock();
        synchronized (object) {
            Option<SessionHolder> option2;
            SessionHolderInfo info = sessionHolder.getSessionHolderInfo();
            if (SparkConnectSessionManager.shouldExpire$1(info, System.currentTimeMillis(), ignoreCustomTimeout$1, defaultInactiveTimeoutMs$1)) {
                $this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> $this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Found session ", " that expired "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.SESSION_HOLD_INFO$.MODULE$, (Object)info)})).$plus($this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"and will be closed."}))).log((Seq)Nil$.MODULE$))));
                option2 = $this.removeSessionHolder(info.key());
            } else {
                option2 = None$.MODULE$;
            }
            option = option2;
        }
        Option<SessionHolder> removedSession = option;
        try {
            removedSession.foreach((Function1 & Serializable)x$3 -> {
                $this.shutdownSessionHolder(x$3);
                return BoxedUnit.UNIT;
            });
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (NonFatal$.MODULE$.apply(throwable2)) {
                $this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Unexpected exception closing session", throwable2);
            }
            throw throwable;
        }
    }

    public SparkConnectSessionManager() {
        Logging.$init$((Logging)this);
        this.sessionsLock = new Object();
        this.sessionStore = (scala.collection.mutable.HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.closedSessionsCache = CacheBuilder.newBuilder().maximumSize(BoxesRunTime.unboxToInt((Object)SparkEnv$.MODULE$.get().conf().get(Connect$.MODULE$.CONNECT_SESSION_MANAGER_CLOSED_SESSIONS_TOMBSTONES_SIZE()))).build();
        this.scheduledExecutor = None$.MODULE$;
    }
}

