/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connect.utils;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.HashMap;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.spark.SparkEnv$;
import org.apache.spark.SparkException;
import org.apache.spark.SparkThrowable;
import org.apache.spark.api.python.PythonException;
import org.apache.spark.connect.proto.FetchErrorDetailsResponse;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.sql.connect.config.Connect$;
import org.apache.spark.sql.connect.service.ExecuteEventsManager;
import org.apache.spark.sql.connect.service.SessionHolder;
import org.apache.spark.sql.connect.service.SessionKey;
import org.apache.spark.sql.connect.service.SparkConnectService$;
import org.apache.spark.sql.connect.utils.ErrorUtils$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.util.ArrayImplicits$;
import org.json4s.JValue;
import org.json4s.JsonDSL$;
import org.json4s.jackson.JsonMethods$;
import org.slf4j.Logger;
import org.sparkproject.connect.google_protos.rpc.ErrorInfo;
import org.sparkproject.connect.google_protos.rpc.Status;
import org.sparkproject.connect.grpc.protobuf.StatusProto;
import org.sparkproject.connect.grpc.stub.StreamObserver;
import org.sparkproject.connect.protobuf.Any;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LazyRef;
import scala.runtime.ScalaRunTime$;
import scala.util.control.NonFatal$;

public final class ErrorUtils$
implements Logging {
    public static final ErrorUtils$ MODULE$ = new ErrorUtils$();
    private static final int MAX_ERROR_CHAIN_LENGTH;
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
        MAX_ERROR_CHAIN_LENGTH = 5;
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(HashMap<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private scala.collection.immutable.Seq<Class<?>> allClasses(Class<?> cl) {
        ArrayBuffer classes = ArrayBuffer$.MODULE$.empty();
        Object object = cl != null && !cl.equals(Object.class) ? classes.append(cl) : BoxedUnit.UNIT;
        this.appendSuperClasses$1(cl, classes);
        return classes.toSeq();
    }

    public int MAX_ERROR_CHAIN_LENGTH() {
        return MAX_ERROR_CHAIN_LENGTH;
    }

    public FetchErrorDetailsResponse throwableToFetchErrorDetailsResponse(Throwable st, boolean serverStackTraceEnabled) {
        Buffer buffer = (Buffer)Buffer$.MODULE$.empty();
        for (Throwable currentError = st; buffer.size() < this.MAX_ERROR_CHAIN_LENGTH() && currentError != null; currentError = currentError.getCause()) {
            FetchErrorDetailsResponse.Error.Builder builder = FetchErrorDetailsResponse.Error.newBuilder().setMessage(currentError.getMessage()).addAllErrorTypeHierarchy(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)this.allClasses(currentError.getClass()).map((Function1 & Serializable)x$1 -> x$1.getName())).asJava());
            Object object = serverStackTraceEnabled ? builder.addAllStackTrace(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)ArrayImplicits$.MODULE$.SparkArrayOps(ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])currentError.getStackTrace()), (Function1 & Serializable)stackTraceElement -> {
                FetchErrorDetailsResponse.StackTraceElement.Builder stackTraceBuilder = FetchErrorDetailsResponse.StackTraceElement.newBuilder().setDeclaringClass(stackTraceElement.getClassName()).setMethodName(stackTraceElement.getMethodName()).setLineNumber(stackTraceElement.getLineNumber());
                Object object = stackTraceElement.getFileName() != null ? stackTraceBuilder.setFileName(stackTraceElement.getFileName()) : BoxedUnit.UNIT;
                return stackTraceBuilder.build();
            }, ClassTag$.MODULE$.apply(FetchErrorDetailsResponse.StackTraceElement.class))).toImmutableArraySeq()).asJava()) : BoxedUnit.UNIT;
            Throwable throwable = currentError;
            if (throwable instanceof SparkThrowable) {
                Throwable throwable2 = throwable;
                FetchErrorDetailsResponse.SparkThrowable.Builder sparkThrowableBuilder = FetchErrorDetailsResponse.SparkThrowable.newBuilder();
                Object object2 = ((SparkThrowable)throwable2).getErrorClass() != null ? sparkThrowableBuilder.setErrorClass(((SparkThrowable)throwable2).getErrorClass()) : BoxedUnit.UNIT;
                ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])((SparkThrowable)throwable2).getQueryContext()), (Function1 & Serializable)queryCtx -> sparkThrowableBuilder.addQueryContexts(FetchErrorDetailsResponse.QueryContext.newBuilder().setObjectType(queryCtx.objectType()).setObjectName(queryCtx.objectName()).setStartIndex(queryCtx.startIndex()).setStopIndex(queryCtx.stopIndex()).setFragment(queryCtx.fragment()).build()));
                Object object3 = ((SparkThrowable)throwable2).getSqlState() != null ? sparkThrowableBuilder.setSqlState(((SparkThrowable)throwable2).getSqlState()) : BoxedUnit.UNIT;
                sparkThrowableBuilder.putAllMessageParameters(((SparkThrowable)throwable2).getMessageParameters());
                builder.setSparkThrowable(sparkThrowableBuilder.build());
            }
            int causeIdx = buffer.size() + 1;
            Object object4 = causeIdx < this.MAX_ERROR_CHAIN_LENGTH() && currentError.getCause() != null ? builder.setCauseIdx(causeIdx) : BoxedUnit.UNIT;
            buffer.append((Object)builder.build());
        }
        return FetchErrorDetailsResponse.newBuilder().setRootErrorIdx(0).addAllErrors(CollectionConverters$.MODULE$.BufferHasAsJava(buffer).asJava()).build();
    }

    public boolean throwableToFetchErrorDetailsResponse$default$2() {
        return false;
    }

    public Status buildStatusFromThrowable(Throwable st, Option<SessionHolder> sessionHolderOpt) {
        ErrorInfo.Builder builder;
        LazyRef stackTrace$lzy = new LazyRef();
        ErrorInfo.Builder errorInfo = ErrorInfo.newBuilder().setReason(st.getClass().getName()).setDomain("org.apache.spark").putMetadata("classes", JsonMethods$.MODULE$.compact(JsonMethods$.MODULE$.render((JValue)JsonDSL$.MODULE$.seq2jvalue((Iterable)this.allClasses(st.getClass()).map((Function1 & Serializable)x$2 -> x$2.getName()), (Function1 & Serializable)x -> JsonDSL$.MODULE$.string2jvalue(x)), JsonMethods$.MODULE$.render$default$2(), JsonMethods$.MODULE$.render$default$3())));
        long maxMetadataSize = BoxesRunTime.unboxToLong((Object)SparkEnv$.MODULE$.get().conf().get(Connect$.MODULE$.CONNECT_GRPC_MAX_METADATA_SIZE()));
        Throwable throwable = st;
        if (throwable instanceof SparkThrowable) {
            Throwable throwable2 = throwable;
            String state = ((SparkThrowable)throwable2).getSqlState();
            Object object = state != null && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(state)) ? errorInfo.putMetadata("sqlState", state) : BoxedUnit.UNIT;
            String errorClass = ((SparkThrowable)throwable2).getErrorClass();
            if (errorClass != null && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(errorClass))) {
                String messageParameters = JsonMethods$.MODULE$.compact(JsonMethods$.MODULE$.render((JValue)JsonDSL$.MODULE$.map2jvalue(CollectionConverters$.MODULE$.MapHasAsScala(((SparkThrowable)throwable2).getMessageParameters()).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), (Function1 & Serializable)x -> JsonDSL$.MODULE$.string2jvalue(x)), JsonMethods$.MODULE$.render$default$2(), JsonMethods$.MODULE$.render$default$3()));
                if ((long)messageParameters.length() <= maxMetadataSize) {
                    errorInfo.putMetadata("errorClass", errorClass);
                    errorInfo.putMetadata("messageParameters", messageParameters);
                }
            }
        }
        if (sessionHolderOpt.exists((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)ErrorUtils$.$anonfun$buildStatusFromThrowable$4(x$3)))) {
            String errorId = UUID.randomUUID().toString();
            errorInfo.putMetadata("errorId", errorId);
            ((SessionHolder)sessionHolderOpt.get()).errorIdToError().put(errorId, st);
        }
        if (sessionHolderOpt.exists((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)ErrorUtils$.$anonfun$buildStatusFromThrowable$5(stackTrace$lzy, st, x$4)))) {
            long maxSize = Math.min((long)BoxesRunTime.unboxToInt((Object)SparkEnv$.MODULE$.get().conf().get(Connect$.MODULE$.CONNECT_JVM_STACK_TRACE_MAX_SIZE())), maxMetadataSize);
            builder = errorInfo.putMetadata("stackTrace", StringUtils.abbreviate((String)((String)ErrorUtils$.stackTrace$1(stackTrace$lzy, st).get()), (int)((int)maxSize)));
        } else {
            builder = errorInfo;
        }
        ErrorInfo.Builder withStackTrace = builder;
        return Status.newBuilder().setCode(13).addDetails(Any.pack(withStackTrace.build())).setMessage(SparkConnectService$.MODULE$.extractErrorMessage(st)).build();
    }

    public boolean org$apache$spark$sql$connect$utils$ErrorUtils$$isPythonExecutionException(SparkException se) {
        return se.getCause() != null && se.getCause() instanceof PythonException && ArrayOps$.MODULE$.exists$extension(Predef$.MODULE$.refArrayOps((Object[])se.getCause().getStackTrace()), (Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)ErrorUtils$.$anonfun$isPythonExecutionException$1(x$5)));
    }

    public <V> PartialFunction<Throwable, BoxedUnit> handleError(String opType, StreamObserver<V> observer, String userId, String sessionId, Option<ExecuteEventsManager> events, boolean isInterrupted, Option<Function0<BoxedUnit>> callback) {
        Option<SessionHolder> sessionHolderOpt = SparkConnectService$.MODULE$.sessionManager().getIsolatedSessionIfPresent(new SessionKey(userId, sessionId));
        Serializable partial = new Serializable(sessionHolderOpt){
            private static final long serialVersionUID = 0L;
            private final Option sessionHolderOpt$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1;
                SparkException sparkException;
                A1 A12 = x1;
                if (A12 instanceof SparkException && ErrorUtils$.MODULE$.org$apache$spark$sql$connect$utils$ErrorUtils$$isPythonExecutionException(sparkException = (SparkException)A12)) {
                    return (B1)new Tuple2((Object)sparkException, (Object)StatusProto.toStatusRuntimeException(ErrorUtils$.MODULE$.buildStatusFromThrowable(sparkException.getCause(), (Option<SessionHolder>)this.sessionHolderOpt$1)));
                }
                if (A12 != null && ((A1 = A12) instanceof SparkThrowable || NonFatal$.MODULE$.apply(A1))) {
                    return (B1)new Tuple2(A1, (Object)StatusProto.toStatusRuntimeException(ErrorUtils$.MODULE$.buildStatusFromThrowable(A1, (Option<SessionHolder>)this.sessionHolderOpt$1)));
                }
                if (A12 != null) {
                    A1 A13 = A12;
                    return (B1)new Tuple2(A13, (Object)org.sparkproject.connect.grpc.Status.UNKNOWN.withCause(A13).withDescription(StringUtils.abbreviate((String)A13.getMessage(), (int)2048)).asRuntimeException());
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable;
                SparkException sparkException;
                Throwable throwable2 = x1;
                if (throwable2 instanceof SparkException && ErrorUtils$.MODULE$.org$apache$spark$sql$connect$utils$ErrorUtils$$isPythonExecutionException(sparkException = (SparkException)throwable2)) {
                    return true;
                }
                if (throwable2 != null && ((throwable = throwable2) instanceof SparkThrowable || NonFatal$.MODULE$.apply(throwable))) {
                    return true;
                }
                return throwable2 != null;
            }
            {
                this.sessionHolderOpt$1 = sessionHolderOpt$1;
            }
        };
        return partial.andThen((PartialFunction)new Serializable(events, opType, userId, sessionId, isInterrupted, callback, observer){
            private static final long serialVersionUID = 0L;
            private final Option events$1;
            private final String opType$1;
            private final String userId$1;
            private final String sessionId$1;
            private final boolean isInterrupted$1;
            private final Option callback$1;
            private final StreamObserver observer$1;

            public final <A1 extends Tuple2<Throwable, Throwable>, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                A1 A1 = x2;
                if (A1 != null) {
                    Throwable original = (Throwable)A1._1();
                    Throwable wrapped = (Throwable)A1._2();
                    if (this.events$1.isDefined()) {
                        ErrorUtils$.MODULE$.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> ErrorUtils$.MODULE$.LogStringContext(new StringContext((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Spark Connect error during: ", ". "}))).log((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.OP_TYPE$.MODULE$, (Object)$this.opType$1)})).$plus(ErrorUtils$.MODULE$.LogStringContext(new StringContext((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"UserId: ", ". SessionId: ", "."}))).log((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.USER_ID$.MODULE$, (Object)$this.userId$1), new MDC((LogKey)LogKeys.SESSION_ID$.MODULE$, (Object)$this.sessionId$1)})))), original);
                    } else {
                        ErrorUtils$.MODULE$.logError(LogEntry$.MODULE$.from((Function0 & Serializable)() -> ErrorUtils$.MODULE$.LogStringContext(new StringContext((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Spark Connect RPC error during: ", ". "}))).log((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.OP_TYPE$.MODULE$, (Object)$this.opType$1)})).$plus(ErrorUtils$.MODULE$.LogStringContext(new StringContext((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"UserId: ", ". SessionId: ", "."}))).log((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.USER_ID$.MODULE$, (Object)$this.userId$1), new MDC((LogKey)LogKeys.SESSION_ID$.MODULE$, (Object)$this.sessionId$1)})))), original);
                    }
                    this.events$1.foreach((Function1 & Serializable)executeEventsManager -> {
                        anonfun.handleError.1.$anonfun$applyOrElse$3(this, wrapped, executeEventsManager);
                        return BoxedUnit.UNIT;
                    });
                    this.callback$1.foreach((Function1 & Serializable)x$6 -> {
                        anonfun.handleError.1.$anonfun$applyOrElse$4(x$6);
                        return BoxedUnit.UNIT;
                    });
                    this.observer$1.onError(wrapped);
                    return (B1)BoxedUnit.UNIT;
                }
                return (B1)function1.apply(x2);
            }

            public final boolean isDefinedAt(Tuple2<Throwable, Throwable> x2) {
                Tuple2<Throwable, Throwable> tuple2 = x2;
                return tuple2 != null;
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$3(anonfun.handleError.1 $this, Throwable wrapped$1, ExecuteEventsManager executeEventsManager) {
                if ($this.isInterrupted$1) {
                    executeEventsManager.postCanceled();
                    return;
                }
                executeEventsManager.postFailed(wrapped$1.getMessage());
            }

            public static final /* synthetic */ void $anonfun$applyOrElse$4(Function0 x$6) {
                x$6.apply$mcV$sp();
            }
            {
                this.events$1 = events$1;
                this.opType$1 = opType$1;
                this.userId$1 = userId$1;
                this.sessionId$1 = sessionId$1;
                this.isInterrupted$1 = isInterrupted$1;
                this.callback$1 = callback$1;
                this.observer$1 = observer$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(org.apache.spark.sql.connect.utils.ErrorUtils$$anonfun$handleError$1 ), $anonfun$applyOrElse$2(org.apache.spark.sql.connect.utils.ErrorUtils$$anonfun$handleError$1 ), $anonfun$applyOrElse$3$adapted(org.apache.spark.sql.connect.utils.ErrorUtils$$anonfun$handleError$1 java.lang.Throwable org.apache.spark.sql.connect.service.ExecuteEventsManager ), $anonfun$applyOrElse$4$adapted(scala.Function0 )}, serializedLambda);
            }
        });
    }

    public <V> Option<ExecuteEventsManager> handleError$default$5() {
        return None$.MODULE$;
    }

    public <V> boolean handleError$default$6() {
        return false;
    }

    public <V> Option<Function0<BoxedUnit>> handleError$default$7() {
        return None$.MODULE$;
    }

    private final void appendSuperClasses$1(Class clazz, ArrayBuffer classes$1) {
        while (clazz != null && !clazz.equals(Object.class)) {
            classes$1.append(clazz.getSuperclass());
            clazz = clazz.getSuperclass();
        }
        return;
    }

    public static final /* synthetic */ boolean $anonfun$buildStatusFromThrowable$4(SessionHolder x$3) {
        return BoxesRunTime.unboxToBoolean((Object)x$3.session().conf().get(Connect$.MODULE$.CONNECT_ENRICH_ERROR_ENABLED()));
    }

    private static final /* synthetic */ Option stackTrace$lzycompute$1(LazyRef stackTrace$lzy$1, Throwable st$1) {
        Option option;
        LazyRef lazyRef = stackTrace$lzy$1;
        synchronized (lazyRef) {
            option = stackTrace$lzy$1.initialized() ? (Option)stackTrace$lzy$1.value() : (Option)stackTrace$lzy$1.initialize((Object)Option$.MODULE$.apply((Object)ExceptionUtils.getStackTrace((Throwable)st$1)));
        }
        return option;
    }

    private static final Option stackTrace$1(LazyRef stackTrace$lzy$1, Throwable st$1) {
        if (stackTrace$lzy$1.initialized()) {
            return (Option)stackTrace$lzy$1.value();
        }
        return ErrorUtils$.stackTrace$lzycompute$1(stackTrace$lzy$1, st$1);
    }

    public static final /* synthetic */ boolean $anonfun$buildStatusFromThrowable$5(LazyRef stackTrace$lzy$1, Throwable st$1, SessionHolder x$4) {
        return BoxesRunTime.unboxToBoolean((Object)x$4.session().conf().get(SQLConf$.MODULE$.PYSPARK_JVM_STACKTRACE_ENABLED())) && ErrorUtils$.stackTrace$1(stackTrace$lzy$1, st$1).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$isPythonExecutionException$1(StackTraceElement x$5) {
        return x$5.toString().contains("org.apache.spark.sql.execution.python");
    }

    private ErrorUtils$() {
    }
}

