/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.connect.grpc.netty;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.EventLoop;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.sparkproject.connect.grpc.Attributes;
import org.sparkproject.connect.grpc.Metadata;
import org.sparkproject.connect.grpc.Status;
import org.sparkproject.connect.grpc.internal.AbstractServerStream;
import org.sparkproject.connect.grpc.internal.StatsTraceContext;
import org.sparkproject.connect.grpc.internal.TransportTracer;
import org.sparkproject.connect.grpc.internal.WritableBuffer;
import org.sparkproject.connect.grpc.netty.CancelServerStreamCommand;
import org.sparkproject.connect.grpc.netty.NettyReadableBuffer;
import org.sparkproject.connect.grpc.netty.NettyServerHandler;
import org.sparkproject.connect.grpc.netty.NettyWritableBuffer;
import org.sparkproject.connect.grpc.netty.NettyWritableBufferAllocator;
import org.sparkproject.connect.grpc.netty.SendGrpcFrameCommand;
import org.sparkproject.connect.grpc.netty.SendResponseHeadersCommand;
import org.sparkproject.connect.grpc.netty.StreamIdHolder;
import org.sparkproject.connect.grpc.netty.Utils;
import org.sparkproject.connect.grpc.netty.WriteQueue;
import org.sparkproject.connect.guava.base.Preconditions;
import org.sparkproject.connect.io_perfmark.Link;
import org.sparkproject.connect.io_perfmark.PerfMark;
import org.sparkproject.connect.io_perfmark.Tag;
import org.sparkproject.connect.io_perfmark.TaskCloseable;

class NettyServerStream
extends AbstractServerStream {
    private static final Logger log = Logger.getLogger(NettyServerStream.class.getName());
    private final Sink sink = new Sink();
    private final TransportState state;
    private final WriteQueue writeQueue;
    private final Attributes attributes;
    private final String authority;
    private final TransportTracer transportTracer;
    private final int streamId;

    public NettyServerStream(Channel channel, TransportState state, Attributes transportAttrs, String authority, StatsTraceContext statsTraceCtx, TransportTracer transportTracer) {
        super(new NettyWritableBufferAllocator(channel.alloc()), statsTraceCtx);
        this.state = Preconditions.checkNotNull(state, "transportState");
        this.writeQueue = state.handler.getWriteQueue();
        this.attributes = Preconditions.checkNotNull(transportAttrs);
        this.authority = authority;
        this.transportTracer = Preconditions.checkNotNull(transportTracer, "transportTracer");
        this.streamId = this.transportState().id();
    }

    @Override
    protected TransportState transportState() {
        return this.state;
    }

    @Override
    protected Sink abstractServerStreamSink() {
        return this.sink;
    }

    @Override
    public Attributes getAttributes() {
        return this.attributes;
    }

    @Override
    public String getAuthority() {
        return this.authority;
    }

    @Override
    public int streamId() {
        return this.streamId;
    }

    public static class TransportState
    extends AbstractServerStream.TransportState
    implements StreamIdHolder {
        private final Http2Stream http2Stream;
        private final NettyServerHandler handler;
        private final EventLoop eventLoop;
        private final Tag tag;

        public TransportState(NettyServerHandler handler, EventLoop eventLoop, Http2Stream http2Stream, int maxMessageSize, StatsTraceContext statsTraceCtx, TransportTracer transportTracer, String methodName) {
            super(maxMessageSize, statsTraceCtx, transportTracer);
            this.http2Stream = Preconditions.checkNotNull(http2Stream, "http2Stream");
            this.handler = Preconditions.checkNotNull(handler, "handler");
            this.eventLoop = eventLoop;
            this.tag = PerfMark.createTag(methodName, http2Stream.id());
        }

        @Override
        public void runOnTransportThread(final Runnable r) {
            if (this.eventLoop.inEventLoop()) {
                r.run();
            } else {
                final Link link = PerfMark.linkOut();
                this.eventLoop.execute(new Runnable(){

                    @Override
                    public void run() {
                        try (TaskCloseable ignore = PerfMark.traceTask("NettyServerStream$TransportState.runOnTransportThread");){
                            PerfMark.attachTag(tag);
                            PerfMark.linkIn(link);
                            r.run();
                        }
                    }
                });
            }
        }

        @Override
        public void bytesRead(int processedBytes) {
            this.handler.returnProcessedBytes(this.http2Stream, processedBytes);
            this.handler.getWriteQueue().scheduleFlush();
        }

        @Override
        public void deframeFailed(Throwable cause) {
            log.log(Level.WARNING, "Exception processing message", cause);
            Status status = Status.fromThrowable(cause);
            this.transportReportStatus(status);
            this.handler.getWriteQueue().enqueue(new CancelServerStreamCommand(this, status), true);
        }

        void inboundDataReceived(ByteBuf frame, boolean endOfStream) {
            super.inboundDataReceived(new NettyReadableBuffer(frame.retain()), endOfStream);
        }

        @Override
        public int id() {
            return this.http2Stream.id();
        }

        @Override
        public Tag tag() {
            return this.tag;
        }
    }

    private class Sink
    implements AbstractServerStream.Sink {
        private Sink() {
        }

        @Override
        public void writeHeaders(Metadata headers, boolean flush) {
            try (TaskCloseable ignore = PerfMark.traceTask("NettyServerStream$Sink.writeHeaders");){
                NettyServerStream.this.writeQueue.enqueue(SendResponseHeadersCommand.createHeaders(NettyServerStream.this.transportState(), Utils.convertServerHeaders(headers)), flush);
            }
        }

        private void writeFrameInternal(WritableBuffer frame, boolean flush, final int numMessages) {
            Preconditions.checkArgument(numMessages >= 0);
            ByteBuf bytebuf = ((NettyWritableBuffer)frame).bytebuf().touch();
            final int numBytes = bytebuf.readableBytes();
            NettyServerStream.this.onSendingBytes(numBytes);
            NettyServerStream.this.writeQueue.enqueue(new SendGrpcFrameCommand(NettyServerStream.this.transportState(), bytebuf, false), flush).addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    NettyServerStream.this.transportState().onSentBytes(numBytes);
                    if (future.isSuccess()) {
                        NettyServerStream.this.transportTracer.reportMessageSent(numMessages);
                    }
                }
            });
        }

        @Override
        public void writeFrame(WritableBuffer frame, boolean flush, int numMessages) {
            try (TaskCloseable ignore = PerfMark.traceTask("NettyServerStream$Sink.writeFrame");){
                this.writeFrameInternal(frame, flush, numMessages);
            }
        }

        @Override
        public void writeTrailers(Metadata trailers, boolean headersSent, Status status) {
            try (TaskCloseable ignore = PerfMark.traceTask("NettyServerStream$Sink.writeTrailers");){
                Http2Headers http2Trailers = Utils.convertTrailers(trailers, headersSent);
                NettyServerStream.this.writeQueue.enqueue(SendResponseHeadersCommand.createTrailers(NettyServerStream.this.transportState(), http2Trailers, status), true);
            }
        }

        @Override
        public void cancel(Status status) {
            try (TaskCloseable ignore = PerfMark.traceTask("NettyServerStream$Sink.cancel");){
                NettyServerStream.this.writeQueue.enqueue(new CancelServerStreamCommand(NettyServerStream.this.transportState(), status), true);
            }
        }
    }
}

