/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connect.service;

import java.io.Serializable;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.GuardedBy;
import org.apache.spark.SparkEnv$;
import org.apache.spark.SparkException$;
import org.apache.spark.SparkSQLException;
import org.apache.spark.connect.proto.Relation;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.artifact.ArtifactManager;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.connect.common.InvalidPlanInput;
import org.apache.spark.sql.connect.common.InvalidPlanInput$;
import org.apache.spark.sql.connect.config.Connect$;
import org.apache.spark.sql.connect.planner.PythonStreamingQueryListener;
import org.apache.spark.sql.connect.planner.StreamingForeachBatchHelper;
import org.apache.spark.sql.connect.service.ExecuteHolder;
import org.apache.spark.sql.connect.service.ServerSideListenerHolder;
import org.apache.spark.sql.connect.service.SessionEventsManager;
import org.apache.spark.sql.connect.service.SessionHolder$;
import org.apache.spark.sql.connect.service.SessionHolderInfo;
import org.apache.spark.sql.connect.service.SessionKey;
import org.apache.spark.sql.connect.service.SessionStatus;
import org.apache.spark.sql.connect.service.SessionStatus$Pending$;
import org.apache.spark.sql.connect.service.SparkConnectService$;
import org.apache.spark.sql.connect.service.SparkConnectStreamingQueryCache;
import org.apache.spark.sql.streaming.StreamingQueryListener;
import org.apache.spark.util.Clock;
import org.apache.spark.util.CollectionAccumulator;
import org.apache.spark.util.SystemClock;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import org.sparkproject.connect.guava.base.Ticker;
import org.sparkproject.connect.guava.cache.Cache;
import org.sparkproject.connect.guava.cache.CacheBuilder;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.Future$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\u0011ub\u0001\u0002*T\u0001\u0002D\u0001\u0002 \u0001\u0003\u0016\u0004%\t! \u0005\n\u0003\u001b\u0001!\u0011#Q\u0001\nyD\u0011\"a\u0004\u0001\u0005+\u0007I\u0011A?\t\u0013\u0005E\u0001A!E!\u0002\u0013q\bBCA\n\u0001\tU\r\u0011\"\u0001\u0002\u0016!Q\u0011q\u0004\u0001\u0003\u0012\u0003\u0006I!a\u0006\t\u000f\u0005\u0005\u0002\u0001\"\u0001\u0002$!Q\u0011q\u0006\u0001\t\u0006\u0004%I!!\r\t\u0013\u0005M\u0004A1A\u0005\n\u0005U\u0004\u0002CA?\u0001\u0001\u0006I!a\u001e\t\u0013\u0005}\u0004\u00011A\u0005\n\u0005U\u0004\"CAA\u0001\u0001\u0007I\u0011BAB\u0011!\ty\t\u0001Q!\n\u0005]\u0004\"CAM\u0001\u0001\u0007I\u0011BAN\u0011%\ty\n\u0001a\u0001\n\u0013\t\t\u000b\u0003\u0005\u0002&\u0002\u0001\u000b\u0015BAO\u0011%\tI\u000b\u0001a\u0001\n\u0013\tY\nC\u0005\u0002,\u0002\u0001\r\u0011\"\u0003\u0002.\"A\u0011\u0011\u0017\u0001!B\u0013\ti\nC\u0005\u00026\u0002\u0011\r\u0011\"\u0003\u00028\"A\u00111\u001b\u0001!\u0002\u0013\tI\f\u0003\u0006\u0002V\u0002\u0011\r\u0011\"\u0001V\u0003/D\u0001\"!9\u0001A\u0003%\u0011\u0011\u001c\u0005\n\u0003G\u0004!\u0019!C\u0001\u0003KD\u0001\"!<\u0001A\u0003%\u0011q\u001d\u0005\f\u0003_\u0004\u0001R1A\u0005\u0002e\u000b\t\u0010\u0003\u0006\u0003\u0012\u0001A)\u0019!C\u0005\u0005'A1Ba\t\u0001\u0011\u000b\u0007I\u0011A+\u0003&!Y!1\b\u0001\t\u0006\u0004%\t!\u0016B\u001f\u0011\u001d\u0011)\u0005\u0001C\u0001\u0005\u000fBaAa\u0014\u0001\t\u0003i\b\u0002\u0003B)\u0001\u0011\u00051Ka\u0015\t\u0011\tM\u0004\u0001\"\u0001T\u0005kB\u0001Ba\u0016\u0001\t\u0003)&Q\u0010\u0005\t\u0005\u0007\u0003A\u0011A*\u0003\u0006\"A!Q\u0012\u0001\u0005\u0002M\u0013y\t\u0003\u0005\u0003\u0016\u0002!\ta\u0015BL\u0011!\u0011Y\n\u0001C\u0001+\nu\u0005\u0002\u0003BV\u0001\u0011\u0005QK!,\t\u000f\t5\u0007\u0001\"\u0001\u0003P\"A!Q\u001c\u0001\u0005\u0002U\u0013y\u000e\u0003\u0005\u0003b\u0002!\t!\u0016Br\u0011!\u0011I\u000f\u0001C\u0001+\n}\u0007\u0002\u0003Bv\u0001\u0011\u0005QKa8\t\u000f\t5\b\u0001\"\u0001\u0003p\"911\u0003\u0001\u0005\u0002\rU\u0001\u0002CB\u000f\u0001\u0011\u0005Qka\b\t\u0011\r%\u0002\u0001\"\u0001V\u0007WA\u0001ba\f\u0001\t\u0003)6\u0011\u0007\u0005\t\u0007k\u0001A\u0011A+\u00048!A1\u0011\t\u0001\u0005\u0002U\u001b\u0019\u0005\u0003\u0005\u0004J\u0001!\t!VB&\u0011\u001d\u0019y\u0005\u0001C\u0005\u0005?D\u0001b!\u0015\u0001\t\u0003)&Q\u0011\u0005\u000b\u0007'\u0002!\u0019!C\u0001+\u000eU\u0003\u0002CB<\u0001\u0001\u0006Iaa\u0016\t\u0011\re\u0004\u0001\"\u0001V\u0007wB\u0001ba%\u0001\t\u0003\u0019\u0016\u0011\u0007\u0005\n\u0007+\u0003\u0011\u0011!C\u0001\u0007/C\u0011ba(\u0001#\u0003%\ta!)\t\u0013\rU\u0006!%A\u0005\u0002\r\u0005\u0006\"CB\\\u0001E\u0005I\u0011AB]\u0011%\u0019i\fAA\u0001\n\u0003\u001ay\fC\u0005\u0004F\u0002\t\t\u0011\"\u0001\u0004H\"I1q\u001a\u0001\u0002\u0002\u0013\u00051\u0011\u001b\u0005\n\u0007+\u0004\u0011\u0011!C!\u0007/D\u0011b!:\u0001\u0003\u0003%\taa:\t\u0013\r-\b!!A\u0005B\r5\b\"CBy\u0001\u0005\u0005I\u0011IBz\u0011%\u0019)\u0010AA\u0001\n\u0003\u001a9\u0010C\u0005\u0004z\u0002\t\t\u0011\"\u0011\u0004|\u001e91q`*\t\u0002\u0011\u0005aA\u0002*T\u0011\u0003!\u0019\u0001C\u0004\u0002\"%#\t\u0001b\u0004\t\u0013\u0011E\u0011J1A\u0005\n\r\u001d\u0007\u0002\u0003C\n\u0013\u0002\u0006Ia!3\t\u0013\u0011U\u0011J1A\u0005\n\r\u001d\u0007\u0002\u0003C\f\u0013\u0002\u0006Ia!3\t\u0013\u0011e\u0011*!A\u0005\u0002\u0012m\u0001\"\u0003C\u0012\u0013\u0006\u0005I\u0011\u0011C\u0013\u0011%!\u0019$SA\u0001\n\u0013!)DA\u0007TKN\u001c\u0018n\u001c8I_2$WM\u001d\u0006\u0003)V\u000bqa]3sm&\u001cWM\u0003\u0002W/\u000691m\u001c8oK\u000e$(B\u0001-Z\u0003\r\u0019\u0018\u000f\u001c\u0006\u00035n\u000bQa\u001d9be.T!\u0001X/\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005q\u0016aA8sO\u000e\u00011#\u0002\u0001bO6\u0004\bC\u00012f\u001b\u0005\u0019'\"\u00013\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0019\u001c'AB!osJ+g\r\u0005\u0002iW6\t\u0011N\u0003\u0002k3\u0006A\u0011N\u001c;fe:\fG.\u0003\u0002mS\n9Aj\\4hS:<\u0007C\u00012o\u0013\ty7MA\u0004Qe>$Wo\u0019;\u0011\u0005ELhB\u0001:x\u001d\t\u0019h/D\u0001u\u0015\t)x,\u0001\u0004=e>|GOP\u0005\u0002I&\u0011\u0001pY\u0001\ba\u0006\u001c7.Y4f\u0013\tQ8P\u0001\u0007TKJL\u0017\r\\5{C\ndWM\u0003\u0002yG\u00061Qo]3s\u0013\u0012,\u0012A \t\u0004\u007f\u0006\u001da\u0002BA\u0001\u0003\u0007\u0001\"a]2\n\u0007\u0005\u00151-\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u0013\tYA\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003\u000b\u0019\u0017aB;tKJLE\rI\u0001\ng\u0016\u001c8/[8o\u0013\u0012\f!b]3tg&|g.\u00133!\u0003\u001d\u0019Xm]:j_:,\"!a\u0006\u0011\t\u0005e\u00111D\u0007\u0002/&\u0019\u0011QD,\u0003\u0019M\u0003\u0018M]6TKN\u001c\u0018n\u001c8\u0002\u0011M,7o]5p]\u0002\na\u0001P5oSRtD\u0003CA\u0013\u0003S\tY#!\f\u0011\u0007\u0005\u001d\u0002!D\u0001T\u0011\u0015ax\u00011\u0001\u007f\u0011\u0019\tya\u0002a\u0001}\"9\u00111C\u0004A\u0002\u0005]\u0011!\u00039mC:\u001c\u0015m\u00195f+\t\t\u0019\u0004E\u0003c\u0003k\tI$C\u0002\u00028\r\u0014aa\u00149uS>t\u0007\u0003CA\u001e\u0003\u001b\n\t&a\u0018\u000e\u0005\u0005u\"\u0002BA \u0003\u0003\nQaY1dQ\u0016TA!a\u0011\u0002F\u000511m\\7n_:TA!a\u0012\u0002J\u00051qm\\8hY\u0016T!!a\u0013\u0002\u0007\r|W.\u0003\u0003\u0002P\u0005u\"!B\"bG\",\u0007\u0003BA*\u00037j!!!\u0016\u000b\t\u0005]\u0013\u0011L\u0001\u0006aJ|Go\u001c\u0006\u0003-fKA!!\u0018\u0002V\tA!+\u001a7bi&|g\u000e\u0005\u0003\u0002b\u0005=TBAA2\u0015\u0011\t)'a\u001a\u0002\u000f1|w-[2bY*!\u0011\u0011NA6\u0003\u0015\u0001H.\u00198t\u0015\r\tigV\u0001\tG\u0006$\u0018\r\\=ti&!\u0011\u0011OA2\u0005-aunZ5dC2\u0004F.\u00198\u0002\u0017M$\u0018M\u001d;US6,Wj]\u000b\u0003\u0003o\u00022AYA=\u0013\r\tYh\u0019\u0002\u0005\u0019>tw-\u0001\u0007ti\u0006\u0014H\u000fV5nK6\u001b\b%\u0001\tmCN$\u0018iY2fgN$\u0016.\\3Ng\u0006!B.Y:u\u0003\u000e\u001cWm]:US6,Wj]0%KF$B!!\"\u0002\fB\u0019!-a\"\n\u0007\u0005%5M\u0001\u0003V]&$\b\"CAG\u0019\u0005\u0005\t\u0019AA<\u0003\rAH%M\u0001\u0012Y\u0006\u001cH/Q2dKN\u001cH+[7f\u001bN\u0004\u0003fA\u0007\u0002\u0014B\u0019!-!&\n\u0007\u0005]5M\u0001\u0005w_2\fG/\u001b7f\u00031\u0019Gn\\:fIRKW.Z't+\t\ti\nE\u0003c\u0003k\t9(\u0001\tdY>\u001cX\r\u001a+j[\u0016l5o\u0018\u0013fcR!\u0011QQAR\u0011%\tiiDA\u0001\u0002\u0004\ti*A\u0007dY>\u001cX\r\u001a+j[\u0016l5\u000f\t\u0015\u0004!\u0005M\u0015aF2vgR|W.\u00138bGRLg/\u001a+j[\u0016|W\u000f^'t\u0003m\u0019Wo\u001d;p[&s\u0017m\u0019;jm\u0016$\u0016.\\3pkRl5o\u0018\u0013fcR!\u0011QQAX\u0011%\tiIEA\u0001\u0002\u0004\ti*\u0001\rdkN$x.\\%oC\u000e$\u0018N^3US6,w.\u001e;Ng\u0002B3aEAJ\u0003))\u00070Z2vi&|gn]\u000b\u0003\u0003s\u0003r!a/\u0002Jz\fi-\u0004\u0002\u0002>*!\u0011qXAa\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0005\u0003\u0007\f)-\u0001\u0003vi&d'BAAd\u0003\u0011Q\u0017M^1\n\t\u0005-\u0017Q\u0018\u0002\u000e\u0007>t7-\u001e:sK:$X*\u00199\u0011\t\u0005\u001d\u0012qZ\u0005\u0004\u0003#\u001c&!D#yK\u000e,H/\u001a%pY\u0012,'/A\u0006fq\u0016\u001cW\u000f^5p]N\u0004\u0013AD3se>\u0014\u0018\n\u001a+p\u000bJ\u0014xN]\u000b\u0003\u00033\u0004r!a\u000f\u0002Ny\fY\u000eE\u0002r\u0003;L1!a8|\u0005%!\u0006N]8xC\ndW-A\bfeJ|'/\u00133U_\u0016\u0013(o\u001c:!\u00031)g/\u001a8u\u001b\u0006t\u0017mZ3s+\t\t9\u000f\u0005\u0003\u0002(\u0005%\u0018bAAv'\n!2+Z:tS>tWI^3oiNl\u0015M\\1hKJ\fQ\"\u001a<f]Rl\u0015M\\1hKJ\u0004\u0013A\u00043bi\u00064%/Y7f\u0007\u0006\u001c\u0007.Z\u000b\u0003\u0003g\u0004r!a/\u0002Jz\f)\u0010\u0005\u0003\u0002x\n-a\u0002BA}\u0005\u0013qA!a?\u0003\b9!\u0011Q B\u0003\u001d\u0011\tyPa\u0001\u000f\u0007M\u0014\t!C\u0001_\u0013\taV,\u0003\u0002[7&\u0011\u0001,W\u0005\u0003q^KAA!\u0004\u0003\u0010\tIA)\u0019;b\rJ\fW.\u001a\u0006\u0003q^\u000bQ\u0002\\5ti\u0016tWM]\"bG\",WC\u0001B\u000b!\u001d\tY,!3\u007f\u0005/\u0001BA!\u0007\u0003 5\u0011!1\u0004\u0006\u0004\u0005;9\u0016!C:ue\u0016\fW.\u001b8h\u0013\u0011\u0011\tCa\u0007\u0003-M#(/Z1nS:<\u0017+^3ss2K7\u000f^3oKJ\fqe\u001d;sK\u0006l\u0017N\\4G_J,\u0017m\u00195CCR\u001c\u0007NU;o]\u0016\u00148\t\\3b]\u0016\u00148)Y2iKV\u0011!q\u0005\t\u0005\u0005S\u0011)D\u0004\u0003\u0003,\tERB\u0001B\u0017\u0015\r\u0011y#V\u0001\ba2\fgN\\3s\u0013\u0011\u0011\u0019D!\f\u00027M#(/Z1nS:<gi\u001c:fC\u000eD')\u0019;dQ\"+G\u000e]3s\u0013\u0011\u00119D!\u000f\u0003\u0019\rcW-\u00198fe\u000e\u000b7\r[3\u000b\t\tM\"QF\u0001\"gR\u0014X-Y7j]\u001e\u001cVM\u001d<feNLG-\u001a'jgR,g.\u001a:I_2$WM]\u000b\u0003\u0005\u007f\u0001B!a\n\u0003B%\u0019!1I*\u00031M+'O^3s'&$W\rT5ti\u0016tWM\u001d%pY\u0012,'/A\u0002lKf,\"A!\u0013\u0011\t\u0005\u001d\"1J\u0005\u0004\u0005\u001b\u001a&AC*fgNLwN\\&fs\u0006y1/\u001a:wKJ\u001cVm]:j_:LE-\u0001\tbI\u0012,\u00050Z2vi\u0016Du\u000e\u001c3feR!\u0011Q\u0011B+\u0011\u001d\u00119\u0006\ta\u0001\u0003\u001b\fQ\"\u001a=fGV$X\rS8mI\u0016\u0014\bf\u0002\u0011\u0003\\\t5$q\u000e\t\u0005\u0005;\u0012I'\u0004\u0002\u0003`)!\u0011q\u0018B1\u0015\u0011\u0011\u0019G!\u001a\u0002\u0015\u0005tgn\u001c;bi&|gN\u0003\u0002\u0003h\u0005)!.\u0019<bq&!!1\u000eB0\u0005%9U/\u0019:eK\u0012\u0014\u00150A\u0003wC2,X-\t\u0002\u0003r\u0005\u00194\u000b]1sW\u000e{gN\\3diN+'O^5dK:*\u00070Z2vi&|g.T1oC\u001e,'OL3yK\u000e,H/[8og2{7m[\u0001\u0014e\u0016lwN^3Fq\u0016\u001cW\u000f^3I_2$WM\u001d\u000b\u0005\u0003\u000b\u00139\b\u0003\u0004\u0003z\u0005\u0002\rA`\u0001\f_B,'/\u0019;j_:LE\rK\u0004\"\u00057\u0012iGa\u001c\u0015\t\t}$\u0011\u0011\t\u0006E\u0006U\u0012Q\u001a\u0005\u0007\u0005s\u0012\u0003\u0019\u0001@\u0002\u0019%tG/\u001a:skB$\u0018\t\u001c7\u0015\u0005\t\u001d\u0005\u0003B9\u0003\nzL1Aa#|\u0005\r\u0019V-]\u0001\rS:$XM\u001d:vaR$\u0016m\u001a\u000b\u0005\u0005\u000f\u0013\t\n\u0003\u0004\u0003\u0014\u0012\u0002\rA`\u0001\u0004i\u0006<\u0017AE5oi\u0016\u0014(/\u001e9u\u001fB,'/\u0019;j_:$BAa\"\u0003\u001a\"1!\u0011P\u0013A\u0002y\fq\"\u0019:uS\u001a\f7\r^'b]\u0006<WM]\u000b\u0003\u0005?\u0003BA!)\u0003(6\u0011!1\u0015\u0006\u0004\u0005K;\u0016\u0001C1si&4\u0017m\u0019;\n\t\t%&1\u0015\u0002\u0010\u0003J$\u0018NZ1di6\u000bg.Y4fe\u0006Y\u0011\r\u001a3BeRLg-Y2u)!\t)Ia,\u0003D\n\u001d\u0007b\u0002BYO\u0001\u0007!1W\u0001\u0013e\u0016lw\u000e^3SK2\fG/\u001b<f!\u0006$\b\u000e\u0005\u0003\u00036\n}VB\u0001B\\\u0015\u0011\u0011ILa/\u0002\t\u0019LG.\u001a\u0006\u0005\u0005{\u000b)-A\u0002oS>LAA!1\u00038\n!\u0001+\u0019;i\u0011\u001d\u0011)m\na\u0001\u0005g\u000bac]3sm\u0016\u0014Hj\\2bYN#\u0018mZ5oOB\u000bG\u000f\u001b\u0005\b\u0005\u0013<\u0003\u0019\u0001Bf\u0003!1'/Y4nK:$\b\u0003\u00022\u00026y\f1b\u00197bgNdw.\u00193feV\u0011!\u0011\u001b\t\u0005\u0005'\u0014I.\u0004\u0002\u0003V*!!q[Ac\u0003\u0011a\u0017M\\4\n\t\tm'Q\u001b\u0002\f\u00072\f7o\u001d'pC\u0012,'/\u0001\tva\u0012\fG/Z!dG\u0016\u001c8\u000fV5nKR\u0011\u0011QQ\u0001\u001bg\u0016$8)^:u_6Le.Y2uSZ,G+[7f_V$Xj\u001d\u000b\u0005\u0003\u000b\u0013)\u000fC\u0004\u0003h*\u0002\r!!(\u0002)9,w/\u00138bGRLg/\u001a+j[\u0016|W\u000f^'t\u0003EIg.\u001b;jC2L'0Z*fgNLwN\\\u0001\u0006G2|7/Z\u0001\fo&$\bnU3tg&|g.\u0006\u0003\u0003r\n]H\u0003\u0002Bz\u0007\u0013\u0001BA!>\u0003x2\u0001Aa\u0002B}[\t\u0007!1 \u0002\u0002)F!!Q`B\u0002!\r\u0011'q`\u0005\u0004\u0007\u0003\u0019'a\u0002(pi\"Lgn\u001a\t\u0004E\u000e\u0015\u0011bAB\u0004G\n\u0019\u0011I\\=\t\u000f\r-Q\u00061\u0001\u0004\u000e\u0005\ta\rE\u0004c\u0007\u001f\t9Ba=\n\u0007\rE1MA\u0005Gk:\u001cG/[8oc\u0005!r-\u001a;TKN\u001c\u0018n\u001c8I_2$WM]%oM>,\"aa\u0006\u0011\t\u0005\u001d2\u0011D\u0005\u0004\u00077\u0019&!E*fgNLwN\u001c%pY\u0012,'/\u00138g_\u0006\u00112-Y2iK\u0012\u000bG/\u0019$sC6,')_%e)\u0019\t)i!\t\u0004&!111E\u0018A\u0002y\fA\u0001\u001a4JI\"91qE\u0018A\u0002\u0005U\u0018A\u00013g\u0003M9W\r\u001e#bi\u00064%/Y7f\u001fJ$\u0006N]8x)\u0011\t)p!\f\t\r\r\r\u0002\u00071\u0001\u007f\u0003U\u0011X-\\8wK\u000e\u000b7\r[3e\t\u0006$\u0018M\u0012:b[\u0016$B!!>\u00044!111E\u0019A\u0002y\f\u0011cY1dQ\u0016d\u0015n\u001d;f]\u0016\u0014()_%e)\u0019\t)i!\u000f\u0004>!111\b\u001aA\u0002y\f!!\u001b3\t\u000f\r}\"\u00071\u0001\u0003\u0018\u0005AA.[:uK:,'/A\u0006hKRd\u0015n\u001d;f]\u0016\u0014H\u0003BB#\u0007\u000f\u0002RAYA\u001b\u0005/Aaaa\u000f4\u0001\u0004q\u0018\u0001\u0006:f[>4XmQ1dQ\u0016$G*[:uK:,'\u000f\u0006\u0003\u0002\u0006\u000e5\u0003BBB\u001ei\u0001\u0007a0\u0001\nsK6|g/Z!mY2K7\u000f^3oKJ\u001c\u0018a\u00047jgRd\u0015n\u001d;f]\u0016\u0014\u0018\nZ:\u0002#ALH\u000f[8o\u0003\u000e\u001cW/\\;mCR|'/\u0006\u0002\u0004XA)!-!\u000e\u0004ZA!11LB9\u001d\u0011\u0019ifa\u001b\u000f\t\r}3Q\r\b\u0005\u0003w\u001c\t'C\u0002\u0004de\u000b1!\u00199j\u0013\u0011\u00199g!\u001b\u0002\rALH\u000f[8o\u0015\r\u0019\u0019'W\u0005\u0005\u0007[\u001ay'\u0001\bQsRDwN\u001c$v]\u000e$\u0018n\u001c8\u000b\t\r\u001d4\u0011N\u0005\u0005\u0007g\u001a)HA\tQsRDwN\\!dGVlW\u000f\\1u_JTAa!\u001c\u0004p\u0005\u0011\u0002/\u001f;i_:\f5mY;nk2\fGo\u001c:!\u00031)8/\u001a)mC:\u001c\u0015m\u00195f)\u0019\u0019ih!\"\u0004\nR!\u0011qLB@\u0011\u001d\u0019\t)\u000fa\u0001\u0007\u0007\u000b\u0011\u0002\u001e:b]N4wN]7\u0011\u000f\t\u001cy!!\u0015\u0002`!91qQ\u001dA\u0002\u0005E\u0013a\u0001:fY\"911R\u001dA\u0002\r5\u0015!C2bG\",\u0007\u000b\\1o!\r\u00117qR\u0005\u0004\u0007#\u001b'a\u0002\"p_2,\u0017M\\\u0001\rO\u0016$\b\u000b\\1o\u0007\u0006\u001c\u0007.Z\u0001\u0005G>\u0004\u0018\u0010\u0006\u0005\u0002&\re51TBO\u0011\u001da8\b%AA\u0002yD\u0001\"a\u0004<!\u0003\u0005\rA \u0005\n\u0003'Y\u0004\u0013!a\u0001\u0003/\tabY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0004$*\u001aap!*,\u0005\r\u001d\u0006\u0003BBU\u0007ck!aa+\u000b\t\r56qV\u0001\nk:\u001c\u0007.Z2lK\u0012T1Aa\u0019d\u0013\u0011\u0019\u0019la+\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%gU\u001111\u0018\u0016\u0005\u0003/\u0019)+A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0007\u0003\u0004BAa5\u0004D&!\u0011\u0011\u0002Bk\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\u0019I\rE\u0002c\u0007\u0017L1a!4d\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\u0019\u0019aa5\t\u0013\u00055\u0015)!AA\u0002\r%\u0017a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\re\u0007CBBn\u0007C\u001c\u0019!\u0004\u0002\u0004^*\u00191q\\2\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0004d\u000eu'\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$Ba!$\u0004j\"I\u0011QR\"\u0002\u0002\u0003\u000711A\u0001\u0013aJ|G-^2u\u000b2,W.\u001a8u\u001d\u0006lW\r\u0006\u0003\u0004B\u000e=\b\"CAG\t\u0006\u0005\t\u0019ABe\u0003!A\u0017m\u001d5D_\u0012,GCABe\u0003!!xn\u0015;sS:<GCABa\u0003\u0019)\u0017/^1mgR!1QRB\u007f\u0011%\tiiRA\u0001\u0002\u0004\u0019\u0019!A\u0007TKN\u001c\u0018n\u001c8I_2$WM\u001d\t\u0004\u0003OI5\u0003B%b\t\u000b\u0001B\u0001b\u0002\u0005\u000e5\u0011A\u0011\u0002\u0006\u0005\t\u0017\t)-\u0001\u0002j_&\u0019!\u0010\"\u0003\u0015\u0005\u0011\u0005\u0011\u0001E#S%>\u0013vlQ!D\u0011\u0016{6+\u0013.F\u0003E)%KU(S?\u000e\u000b5\tS#`'&SV\tI\u0001\u0018\u000bJ\u0013vJU0D\u0003\u000eCUi\u0018+J\u001b\u0016{U\u000bV0T\u000b\u000e\u000b\u0001$\u0012*S\u001fJ{6)Q\"I\u000b~#\u0016*T#P+R{6+R\"!\u0003\u0015\t\u0007\u000f\u001d7z)!\t)\u0003\"\b\u0005 \u0011\u0005\u0002\"\u0002?P\u0001\u0004q\bBBA\b\u001f\u0002\u0007a\u0010C\u0004\u0002\u0014=\u0003\r!a\u0006\u0002\u000fUt\u0017\r\u001d9msR!Aq\u0005C\u0018!\u0015\u0011\u0017Q\u0007C\u0015!\u001d\u0011G1\u0006@\u007f\u0003/I1\u0001\"\fd\u0005\u0019!V\u000f\u001d7fg!IA\u0011\u0007)\u0002\u0002\u0003\u0007\u0011QE\u0001\u0004q\u0012\u0002\u0014\u0001D<sSR,'+\u001a9mC\u000e,GC\u0001C\u001c!\u0011\u0011\u0019\u000e\"\u000f\n\t\u0011m\"Q\u001b\u0002\u0007\u001f\nTWm\u0019;")
public class SessionHolder
implements Logging,
Product,
Serializable {
    private Option<Cache<Relation, LogicalPlan>> planCache;
    private ConcurrentMap<String, Dataset<Row>> dataFrameCache;
    private ConcurrentMap<String, StreamingQueryListener> listenerCache;
    private StreamingForeachBatchHelper.CleanerCache streamingForeachBatchRunnerCleanerCache;
    private ServerSideListenerHolder streamingServersideListenerHolder;
    private final String userId;
    private final String sessionId;
    private final SparkSession session;
    private final long startTimeMs;
    private volatile long lastAccessTimeMs;
    private volatile Option<Object> closedTimeMs;
    private volatile Option<Object> customInactiveTimeoutMs;
    private final ConcurrentMap<String, ExecuteHolder> executions;
    private final Cache<String, Throwable> errorIdToError;
    private final SessionEventsManager eventManager;
    private final Option<CollectionAccumulator<byte[]>> pythonAccumulator;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile byte bitmap$0;

    public static Option<Tuple3<String, String, SparkSession>> unapply(SessionHolder x$0) {
        return SessionHolder$.MODULE$.unapply(x$0);
    }

    public static SessionHolder apply(String userId, String sessionId, SparkSession session) {
        return SessionHolder$.MODULE$.apply(userId, sessionId, session);
    }

    public Iterator<String> productElementNames() {
        return Product.productElementNames$((Product)this);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(HashMap<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String userId() {
        return this.userId;
    }

    public String sessionId() {
        return this.sessionId;
    }

    public SparkSession session() {
        return this.session;
    }

    private Option<Cache<Relation, LogicalPlan>> planCache$lzycompute() {
        SessionHolder sessionHolder = this;
        synchronized (sessionHolder) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                Some some;
                if (BoxesRunTime.unboxToInt((Object)SparkEnv$.MODULE$.get().conf().get(Connect$.MODULE$.CONNECT_SESSION_PLAN_CACHE_SIZE())) <= 0) {
                    this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Session plan cache is disabled due to non-positive cache size."}))).log((Seq)Nil$.MODULE$).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{" Current value of "}))).log((Seq)Nil$.MODULE$)).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"'", "' is ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.CONFIG$.MODULE$, (Object)Connect$.MODULE$.CONNECT_SESSION_PLAN_CACHE_SIZE().key()), new MDC((LogKey)LogKeys.CACHE_SIZE$.MODULE$, SparkEnv$.MODULE$.get().conf().get(Connect$.MODULE$.CONNECT_SESSION_PLAN_CACHE_SIZE()))})))));
                    some = None$.MODULE$;
                } else {
                    some = new Some(CacheBuilder.newBuilder().maximumSize(BoxesRunTime.unboxToInt((Object)SparkEnv$.MODULE$.get().conf().get(Connect$.MODULE$.CONNECT_SESSION_PLAN_CACHE_SIZE()))).build());
                }
                this.planCache = some;
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.planCache;
    }

    private Option<Cache<Relation, LogicalPlan>> planCache() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.planCache$lzycompute();
        }
        return this.planCache;
    }

    private long startTimeMs() {
        return this.startTimeMs;
    }

    private long lastAccessTimeMs() {
        return this.lastAccessTimeMs;
    }

    private void lastAccessTimeMs_$eq(long x$1) {
        this.lastAccessTimeMs = x$1;
    }

    private Option<Object> closedTimeMs() {
        return this.closedTimeMs;
    }

    private void closedTimeMs_$eq(Option<Object> x$1) {
        this.closedTimeMs = x$1;
    }

    private Option<Object> customInactiveTimeoutMs() {
        return this.customInactiveTimeoutMs;
    }

    private void customInactiveTimeoutMs_$eq(Option<Object> x$1) {
        this.customInactiveTimeoutMs = x$1;
    }

    private ConcurrentMap<String, ExecuteHolder> executions() {
        return this.executions;
    }

    public Cache<String, Throwable> errorIdToError() {
        return this.errorIdToError;
    }

    public SessionEventsManager eventManager() {
        return this.eventManager;
    }

    private ConcurrentMap<String, Dataset<Row>> dataFrameCache$lzycompute() {
        SessionHolder sessionHolder = this;
        synchronized (sessionHolder) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.dataFrameCache = new ConcurrentHashMap<String, Dataset<Row>>();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.dataFrameCache;
    }

    public ConcurrentMap<String, Dataset<Row>> dataFrameCache() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.dataFrameCache$lzycompute();
        }
        return this.dataFrameCache;
    }

    private ConcurrentMap<String, StreamingQueryListener> listenerCache$lzycompute() {
        SessionHolder sessionHolder = this;
        synchronized (sessionHolder) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.listenerCache = new ConcurrentHashMap<String, StreamingQueryListener>();
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.listenerCache;
    }

    private ConcurrentMap<String, StreamingQueryListener> listenerCache() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.listenerCache$lzycompute();
        }
        return this.listenerCache;
    }

    private StreamingForeachBatchHelper.CleanerCache streamingForeachBatchRunnerCleanerCache$lzycompute() {
        SessionHolder sessionHolder = this;
        synchronized (sessionHolder) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.streamingForeachBatchRunnerCleanerCache = new StreamingForeachBatchHelper.CleanerCache(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.streamingForeachBatchRunnerCleanerCache;
    }

    public StreamingForeachBatchHelper.CleanerCache streamingForeachBatchRunnerCleanerCache() {
        if ((byte)(this.bitmap$0 & 8) == 0) {
            return this.streamingForeachBatchRunnerCleanerCache$lzycompute();
        }
        return this.streamingForeachBatchRunnerCleanerCache;
    }

    private ServerSideListenerHolder streamingServersideListenerHolder$lzycompute() {
        SessionHolder sessionHolder = this;
        synchronized (sessionHolder) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                this.streamingServersideListenerHolder = new ServerSideListenerHolder(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
        }
        return this.streamingServersideListenerHolder;
    }

    public ServerSideListenerHolder streamingServersideListenerHolder() {
        if ((byte)(this.bitmap$0 & 0x10) == 0) {
            return this.streamingServersideListenerHolder$lzycompute();
        }
        return this.streamingServersideListenerHolder;
    }

    public SessionKey key() {
        return new SessionKey(this.userId(), this.sessionId());
    }

    public String serverSessionId() {
        if (Utils$.MODULE$.isTesting() && this.session() == null) {
            return "";
        }
        String string = this.session().sessionUUID();
        String string2 = this.sessionId();
        Predef$.MODULE$.assert(string == null ? string2 != null : !string.equals(string2));
        return this.session().sessionUUID();
    }

    @GuardedBy(value="SparkConnectService.executionManager.executionsLock")
    public void addExecuteHolder(ExecuteHolder executeHolder) {
        if (this.closedTimeMs().isDefined()) {
            throw new SparkSQLException("INVALID_HANDLE.SESSION_CLOSED", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"handle"), (Object)this.sessionId())})));
        }
        ExecuteHolder oldExecute = this.executions().putIfAbsent(executeHolder.operationId(), executeHolder);
        if (oldExecute != null) {
            throw new IllegalStateException("ExecuteHolder with opId=" + executeHolder.operationId() + " already exists!");
        }
    }

    @GuardedBy(value="SparkConnectService.executionManager.executionsLock")
    public void removeExecuteHolder(String operationId) {
        this.executions().remove(operationId);
    }

    public Option<ExecuteHolder> executeHolder(String operationId) {
        return Option$.MODULE$.apply(this.executions().get(operationId));
    }

    public Seq<String> interruptAll() {
        ArrayBuffer interruptedIds = new ArrayBuffer();
        Seq<String> operationsIds = SparkConnectService$.MODULE$.streamingSessionManager().cleanupRunningQueries(this, false);
        CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(this.executions()).asScala().values().foreach((Function1 & Serializable)execute -> {
            if (execute.interrupt()) {
                return interruptedIds.$plus$eq((Object)execute.operationId());
            }
            return BoxedUnit.UNIT;
        });
        return (Seq)interruptedIds.toSeq().$plus$plus(operationsIds);
    }

    public Seq<String> interruptTag(String tag) {
        ArrayBuffer interruptedIds = new ArrayBuffer();
        Seq<SparkConnectStreamingQueryCache.QueryCacheValue> queries = SparkConnectService$.MODULE$.streamingSessionManager().getTaggedQuery(tag, this.session());
        queries.foreach((Function1 & Serializable)q -> Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> q.query().stop(), (ExecutionContext)ExecutionContext$.MODULE$.global()));
        CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(this.executions()).asScala().values().foreach((Function1 & Serializable)execute -> {
            if (execute.sparkSessionTags().contains((Object)tag)) {
                if (execute.interrupt()) {
                    return interruptedIds.$plus$eq((Object)execute.operationId());
                }
                return BoxedUnit.UNIT;
            }
            return BoxedUnit.UNIT;
        });
        return (Seq)interruptedIds.toSeq().$plus$plus((IterableOnce)queries.map((Function1 & Serializable)x$1 -> x$1.operationId()));
    }

    public Seq<String> interruptOperation(String operationId) {
        ArrayBuffer interruptedIds = new ArrayBuffer();
        Option$.MODULE$.apply(this.executions().get(operationId)).foreach((Function1 & Serializable)execute -> {
            if (execute.interrupt()) {
                return interruptedIds.$plus$eq((Object)execute.operationId());
            }
            return BoxedUnit.UNIT;
        });
        return interruptedIds.toSeq();
    }

    public ArtifactManager artifactManager() {
        return this.session().artifactManager();
    }

    public void addArtifact(Path remoteRelativePath, Path serverLocalStagingPath, Option<String> fragment) {
        ArtifactManager qual$1 = this.artifactManager();
        Path x$1 = remoteRelativePath;
        Path x$2 = serverLocalStagingPath;
        Option<String> x$3 = fragment;
        boolean x$4 = qual$1.addArtifact$default$4();
        qual$1.addArtifact(x$1, x$2, x$3, x$4);
    }

    public ClassLoader classloader() {
        return this.artifactManager().classloader();
    }

    public void updateAccessTime() {
        this.lastAccessTimeMs_$eq(System.currentTimeMillis());
        this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Session with userId: ", " and "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.USER_ID$.MODULE$, (Object)this.userId())})).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"sessionId: ", " accessed,"}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.SESSION_ID$.MODULE$, (Object)this.sessionId())}))).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"time ", " ms."}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.LAST_ACCESS_TIME$.MODULE$, (Object)BoxesRunTime.boxToLong((long)this.lastAccessTimeMs()))})))));
    }

    public void setCustomInactiveTimeoutMs(Option<Object> newInactiveTimeoutMs) {
        this.customInactiveTimeoutMs_$eq(newInactiveTimeoutMs);
        this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Session with userId: ", " and "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.USER_ID$.MODULE$, (Object)this.userId())})).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"sessionId: ", " inactive timeout set to "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.SESSION_ID$.MODULE$, (Object)this.sessionId())}))).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", " ms"}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.TIMEOUT$.MODULE$, this.customInactiveTimeoutMs())})))));
    }

    public void initializeSession() {
        this.eventManager().postStarted();
    }

    public void close() {
        if (this.closedTimeMs().isDefined()) {
            throw new IllegalStateException("Session " + this.key() + " is already closed.");
        }
        this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Closing session with userId: ", " and "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.USER_ID$.MODULE$, (Object)this.userId())})).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"sessionId: ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.SESSION_ID$.MODULE$, (Object)this.sessionId())})))));
        this.closedTimeMs_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)System.currentTimeMillis())));
        if (Utils$.MODULE$.isTesting()) {
            SessionStatus sessionStatus = this.eventManager().status();
            SessionStatus$Pending$ sessionStatus$Pending$ = SessionStatus$Pending$.MODULE$;
            if (!(sessionStatus != null ? !sessionStatus.equals(sessionStatus$Pending$) : sessionStatus$Pending$ != null)) {
                return;
            }
        }
        this.artifactManager().cleanUpResources();
        SparkConnectService$.MODULE$.streamingSessionManager().cleanupRunningQueries(this, true);
        this.streamingForeachBatchRunnerCleanerCache().cleanUpAll();
        this.removeAllListeners();
        if (this.streamingServersideListenerHolder().isServerSideListenerRegistered()) {
            this.streamingServersideListenerHolder().cleanUp();
        }
        SparkConnectService$.MODULE$.executionManager().removeAllExecutionsForSession(this.key());
        this.eventManager().postClosed();
    }

    public <T> T withSession(Function1<SparkSession, T> f) {
        return (T)this.artifactManager().withResources((Function0 & Serializable)() -> this.session().withActive((Function0 & Serializable)() -> f.apply((Object)this.session())));
    }

    public SessionHolderInfo getSessionHolderInfo() {
        String x$1 = this.userId();
        String x$2 = this.sessionId();
        String x$3 = this.serverSessionId();
        SessionStatus x$4 = this.eventManager().status();
        long x$5 = this.startTimeMs();
        long x$6 = this.lastAccessTimeMs();
        Option<Object> x$7 = this.customInactiveTimeoutMs();
        Option<Object> x$8 = this.closedTimeMs();
        return new SessionHolderInfo(x$1, x$2, x$3, x$4, x$7, x$5, x$6, x$8);
    }

    public void cacheDataFrameById(String dfId, Dataset<Row> df) {
        if (this.dataFrameCache().putIfAbsent(dfId, df) != null) {
            throw SparkException$.MODULE$.internalError("A dataframe is already associated with id " + dfId);
        }
    }

    public Dataset<Row> getDataFrameOrThrow(String dfId) {
        return (Dataset)Option$.MODULE$.apply(this.dataFrameCache().get(dfId)).getOrElse((Function0 & Serializable)() -> {
            throw new InvalidPlanInput("No DataFrame with id " + dfId + " is found in the session " + this.sessionId(), InvalidPlanInput$.MODULE$.apply$default$2());
        });
    }

    public Dataset<Row> removeCachedDataFrame(String dfId) {
        return (Dataset)this.dataFrameCache().remove(dfId);
    }

    public void cacheListenerById(String id, StreamingQueryListener listener) {
        if (this.listenerCache().putIfAbsent(id, listener) != null) {
            throw SparkException$.MODULE$.internalError("A listener is already associated with id " + id);
        }
    }

    public Option<StreamingQueryListener> getListener(String id) {
        return Option$.MODULE$.apply(this.listenerCache().get(id));
    }

    public void removeCachedListener(String id) {
        Some some;
        StreamingQueryListener pyListener;
        Option option = Option$.MODULE$.apply(this.listenerCache().remove(id));
        if (option instanceof Some && (pyListener = (StreamingQueryListener)(some = (Some)option).value()) instanceof PythonStreamingQueryListener) {
            PythonStreamingQueryListener pythonStreamingQueryListener = (PythonStreamingQueryListener)pyListener;
            pythonStreamingQueryListener.stopListenerProcess();
            return;
        }
    }

    private void removeAllListeners() {
        this.listenerCache().forEach((id, listener) -> {
            this.session().streams().removeListener(listener);
            this.removeCachedListener((String)id);
        });
    }

    public Seq<String> listListenerIds() {
        return CollectionConverters$.MODULE$.SetHasAsScala(this.listenerCache().keySet()).asScala().toSeq();
    }

    public Option<CollectionAccumulator<byte[]>> pythonAccumulator() {
        return this.pythonAccumulator;
    }

    public LogicalPlan usePlanCache(Relation rel, boolean cachePlan, Function1<Relation, LogicalPlan> transform) {
        boolean planCacheEnabled = Option$.MODULE$.apply((Object)this.session()).forall((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)SessionHolder.$anonfun$usePlanCache$1(x$2)));
        boolean hasPlanId = rel.hasCommon() && rel.getCommon().hasPlanId();
        return (LogicalPlan)this.getPlanCache$1(rel, planCacheEnabled, hasPlanId).getOrElse((Function0 & Serializable)() -> {
            LogicalPlan plan;
            block0: {
                plan = (LogicalPlan)transform.apply((Object)rel);
                if (!cachePlan) break block0;
                this.putPlanCache$1(rel, plan, planCacheEnabled, hasPlanId);
            }
            return plan;
        });
    }

    public Option<Cache<Relation, LogicalPlan>> getPlanCache() {
        return this.planCache();
    }

    public SessionHolder copy(String userId, String sessionId, SparkSession session) {
        return new SessionHolder(userId, sessionId, session);
    }

    public String copy$default$1() {
        return this.userId();
    }

    public String copy$default$2() {
        return this.sessionId();
    }

    public SparkSession copy$default$3() {
        return this.session();
    }

    public String productPrefix() {
        return "SessionHolder";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.userId();
            }
            case 1: {
                return this.sessionId();
            }
            case 2: {
                return this.session();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof SessionHolder;
    }

    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "userId";
            }
            case 1: {
                return "sessionId";
            }
            case 2: {
                return "session";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof SessionHolder)) return false;
        boolean bl = true;
        if (!bl) return false;
        SessionHolder sessionHolder = (SessionHolder)x$1;
        String string = this.userId();
        String string2 = sessionHolder.userId();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        String string3 = this.sessionId();
        String string4 = sessionHolder.sessionId();
        if (string3 == null) {
            if (string4 != null) {
                return false;
            }
        } else if (!string3.equals(string4)) return false;
        SparkSession sparkSession = this.session();
        SparkSession sparkSession2 = sessionHolder.session();
        if (sparkSession == null) {
            if (sparkSession2 != null) {
                return false;
            }
        } else if (!sparkSession.equals(sparkSession2)) return false;
        if (!sessionHolder.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$usePlanCache$1(SparkSession x$2) {
        return BoxesRunTime.unboxToBoolean((Object)x$2.conf().get(Connect$.MODULE$.CONNECT_SESSION_PLAN_CACHE_ENABLED(), (Object)BoxesRunTime.boxToBoolean((boolean)true)));
    }

    private final Option getPlanCache$1(Relation rel, boolean planCacheEnabled$1, boolean hasPlanId$1) {
        Option<Cache<Relation, LogicalPlan>> option = this.planCache();
        if (option instanceof Some) {
            Some some = (Some)option;
            Cache cache = (Cache)some.value();
            if (planCacheEnabled$1 && hasPlanId$1) {
                Option option2 = Option$.MODULE$.apply(cache.getIfPresent(rel));
                if (option2 instanceof Some) {
                    Some some2 = (Some)option2;
                    LogicalPlan plan = (LogicalPlan)some2.value();
                    this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Using cached plan for relation '" + rel + "': " + plan);
                    return new Some((Object)plan);
                }
                if (None$.MODULE$.equals(option2)) {
                    return None$.MODULE$;
                }
                throw new MatchError((Object)option2);
            }
        }
        return None$.MODULE$;
    }

    private final void putPlanCache$1(Relation rel, LogicalPlan plan, boolean planCacheEnabled$1, boolean hasPlanId$1) {
        Option<Cache<Relation, LogicalPlan>> option = this.planCache();
        if (option instanceof Some) {
            Some some = (Some)option;
            Cache cache = (Cache)some.value();
            if (planCacheEnabled$1 && hasPlanId$1) {
                cache.put(rel, plan);
                return;
            }
        }
    }

    public SessionHolder(String userId, String sessionId, SparkSession session) {
        this.userId = userId;
        this.sessionId = sessionId;
        this.session = session;
        Logging.$init$((Logging)this);
        Product.$init$((Product)this);
        this.startTimeMs = System.currentTimeMillis();
        this.lastAccessTimeMs = System.currentTimeMillis();
        this.closedTimeMs = None$.MODULE$;
        this.customInactiveTimeoutMs = None$.MODULE$;
        this.executions = new ConcurrentHashMap<String, ExecuteHolder>();
        this.errorIdToError = CacheBuilder.newBuilder().ticker(Ticker.systemTicker()).maximumSize(SessionHolder$.MODULE$.org$apache$spark$sql$connect$service$SessionHolder$$ERROR_CACHE_SIZE()).expireAfterAccess(SessionHolder$.MODULE$.org$apache$spark$sql$connect$service$SessionHolder$$ERROR_CACHE_TIMEOUT_SEC(), TimeUnit.SECONDS).build();
        this.eventManager = new SessionEventsManager(this, (Clock)new SystemClock());
        this.pythonAccumulator = Try$.MODULE$.apply((Function0 & Serializable)() -> this.session().sparkContext().collectionAccumulator()).toOption();
    }
}

