/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connect.service;

import java.io.Serializable;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.GuardedBy;
import org.apache.spark.SparkEnv$;
import org.apache.spark.SparkSQLException;
import org.apache.spark.connect.proto.ExecutePlanRequest;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.sql.connect.config.Connect$;
import org.apache.spark.sql.connect.service.ExecuteHolder;
import org.apache.spark.sql.connect.service.ExecuteInfo;
import org.apache.spark.sql.connect.service.ExecuteKey;
import org.apache.spark.sql.connect.service.ExecuteKey$;
import org.apache.spark.sql.connect.service.SessionHolder;
import org.apache.spark.sql.connect.service.SessionKey;
import org.apache.spark.sql.connect.service.SparkConnectService$;
import org.apache.spark.util.ThreadUtils$;
import org.slf4j.Logger;
import org.sparkproject.connect.guava.cache.Cache;
import org.sparkproject.connect.guava.cache.CacheBuilder;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\u0005}f!\u0002\u000f\u001e\u0001}I\u0003\"\u0002\u001c\u0001\t\u0003A\u0004bB\u001e\u0001\u0005\u0004%I\u0001\u0010\u0005\u0007\u001b\u0002\u0001\u000b\u0011B\u001f\t\u000f9\u0003!\u0019!C\u0005\u001f\"1a\u000b\u0001Q\u0001\nACqa\u0016\u0001C\u0002\u0013%\u0001\f\u0003\u0004i\u0001\u0001\u0006I!\u0017\u0005\bS\u0002\u0001\r\u0011\"\u0003k\u0011\u001d\t\b\u00011A\u0005\nIDa\u0001\u001f\u0001!B\u0013Y\u0007\"CA\u0006\u0001\u0001\u0007I\u0011BA\u0007\u0011%\t9\u0002\u0001a\u0001\n\u0013\tI\u0002\u0003\u0005\u0002\u001e\u0001\u0001\u000b\u0015BA\b\u0011!\t\t\u0003\u0001C\u0001?\u0005\r\u0002\u0002CA\u001c\u0001\u0011\u0005q$!\u000f\t\u0015\u0005%\u0003!%A\u0005\u0002}\tY\u0005\u0003\u0005\u0002`\u0001!\taHA1\u0011!\t9\u0007\u0001C\u0001?\u0005%\u0004\u0002CA:\u0001\u0011\u0005q$!\u001e\t\u000f\u0005m\u0004\u0001\"\u0001\u0002~!9\u0011Q\u0014\u0001\u0005\u0002\u0005}\u0005\u0002CAQ\u0001\u0011\u0005q$a)\t\u000f\u0005\u0015\u0006\u0001\"\u0003\u0002$\"A\u0011q\u0015\u0001\u0005\u0002}\tI\u000b\u0003\u0005\u00020\u0002!\taHAY\u0011!\t9\f\u0001C\u0001?\u0005\r\u0006\u0002CA]\u0001\u0011\u0005q$a/\u00039M\u0003\u0018M]6D_:tWm\u0019;Fq\u0016\u001cW\u000f^5p]6\u000bg.Y4fe*\u0011adH\u0001\bg\u0016\u0014h/[2f\u0015\t\u0001\u0013%A\u0004d_:tWm\u0019;\u000b\u0005\t\u001a\u0013aA:rY*\u0011A%J\u0001\u0006gB\f'o\u001b\u0006\u0003M\u001d\na!\u00199bG\",'\"\u0001\u0015\u0002\u0007=\u0014xmE\u0002\u0001UA\u0002\"a\u000b\u0018\u000e\u00031R\u0011!L\u0001\u0006g\u000e\fG.Y\u0005\u0003_1\u0012a!\u00118z%\u00164\u0007CA\u00195\u001b\u0005\u0011$BA\u001a$\u0003!Ig\u000e^3s]\u0006d\u0017BA\u001b3\u0005\u001daunZ4j]\u001e\fa\u0001P5oSRt4\u0001\u0001\u000b\u0002sA\u0011!\bA\u0007\u0002;\u0005QQ\r_3dkRLwN\\:\u0016\u0003u\u0002BAP#H\u00156\tqH\u0003\u0002A\u0003\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005\t\u001b\u0015\u0001B;uS2T\u0011\u0001R\u0001\u0005U\u00064\u0018-\u0003\u0002G\u007f\ti1i\u001c8dkJ\u0014XM\u001c;NCB\u0004\"A\u000f%\n\u0005%k\"AC#yK\u000e,H/Z&fsB\u0011!hS\u0005\u0003\u0019v\u0011Q\"\u0012=fGV$X\rS8mI\u0016\u0014\u0018aC3yK\u000e,H/[8og\u0002\na\"\u001a=fGV$\u0018n\u001c8t\u0019>\u001c7.F\u0001Q!\t\tF+D\u0001S\u0015\t\u00196)\u0001\u0003mC:<\u0017BA+S\u0005\u0019y%M[3di\u0006yQ\r_3dkRLwN\\:M_\u000e\\\u0007%A\nbE\u0006tGm\u001c8fIR{WNY:u_:,7/F\u0001Z!\u0011Q6mR3\u000e\u0003mS!\u0001X/\u0002\u000b\r\f7\r[3\u000b\u0005y{\u0016AB2p[6|gN\u0003\u0002aC\u00061qm\\8hY\u0016T\u0011AY\u0001\u0004G>l\u0017B\u00013\\\u0005\u0015\u0019\u0015m\u00195f!\tQd-\u0003\u0002h;\tYQ\t_3dkR,\u0017J\u001c4p\u0003Q\t'-\u00198e_:,G\rV8nEN$xN\\3tA\u0005\u0019B.Y:u\u000bb,7-\u001e;j_:$\u0016.\\3NgV\t1\u000eE\u0002,Y:L!!\u001c\u0017\u0003\r=\u0003H/[8o!\tYs.\u0003\u0002qY\t!Aj\u001c8h\u0003]a\u0017m\u001d;Fq\u0016\u001cW\u000f^5p]RKW.Z't?\u0012*\u0017\u000f\u0006\u0002tmB\u00111\u0006^\u0005\u0003k2\u0012A!\u00168ji\"9q/CA\u0001\u0002\u0004Y\u0017a\u0001=%c\u0005!B.Y:u\u000bb,7-\u001e;j_:$\u0016.\\3Ng\u0002BcA\u0003>\u0002\b\u0005%\u0001cA>\u0002\u00045\tAP\u0003\u0002A{*\u0011ap`\u0001\u000bC:tw\u000e^1uS>t'BAA\u0001\u0003\u0015Q\u0017M^1y\u0013\r\t)\u0001 \u0002\n\u000fV\f'\u000fZ3e\u0005f\fQA^1mk\u0016\f\u0013AT\u0001\u0012g\u000eDW\rZ;mK\u0012,\u00050Z2vi>\u0014XCAA\b!\u0011YC.!\u0005\u0011\u0007y\n\u0019\"C\u0002\u0002\u0016}\u0012\u0001dU2iK\u0012,H.\u001a3Fq\u0016\u001cW\u000f^8s'\u0016\u0014h/[2f\u0003U\u00198\r[3ek2,G-\u0012=fGV$xN]0%KF$2a]A\u000e\u0011!9H\"!AA\u0002\u0005=\u0011AE:dQ\u0016$W\u000f\\3e\u000bb,7-\u001e;pe\u0002Bc!\u0004>\u0002\b\u0005%\u0011aE2sK\u0006$X-\u0012=fGV$X\rS8mI\u0016\u0014Hc\u0001&\u0002&!9\u0011q\u0005\bA\u0002\u0005%\u0012a\u0002:fcV,7\u000f\u001e\t\u0005\u0003W\t\u0019$\u0004\u0002\u0002.)!\u0011qFA\u0019\u0003\u0015\u0001(o\u001c;p\u0015\t\u00013%\u0003\u0003\u00026\u00055\"AE#yK\u000e,H/\u001a)mC:\u0014V-];fgR\f1C]3n_Z,W\t_3dkR,\u0007j\u001c7eKJ$Ra]A\u001e\u0003\u007fAa!!\u0010\u0010\u0001\u00049\u0015aA6fs\"I\u0011\u0011I\b\u0011\u0002\u0003\u0007\u00111I\u0001\nC\n\fg\u000eZ8oK\u0012\u00042aKA#\u0013\r\t9\u0005\f\u0002\b\u0005>|G.Z1o\u0003u\u0011X-\\8wK\u0016CXmY;uK\"{G\u000eZ3sI\u0011,g-Y;mi\u0012\u0012TCAA'U\u0011\t\u0019%a\u0014,\u0005\u0005E\u0003\u0003BA*\u00037j!!!\u0016\u000b\t\u0005]\u0013\u0011L\u0001\nk:\u001c\u0007.Z2lK\u0012T!A \u0017\n\t\u0005u\u0013Q\u000b\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017\u0001E4fi\u0016CXmY;uK\"{G\u000eZ3s)\u0011\t\u0019'!\u001a\u0011\u0007-b'\n\u0003\u0004\u0002>E\u0001\raR\u0001\u001ee\u0016lwN^3BY2,\u00050Z2vi&|gn\u001d$peN+7o]5p]R\u00191/a\u001b\t\u000f\u0005u\"\u00031\u0001\u0002nA\u0019!(a\u001c\n\u0007\u0005ETD\u0001\u0006TKN\u001c\u0018n\u001c8LKf\fQcZ3u\u0003\n\fg\u000eZ8oK\u0012$v.\u001c2ti>tW\r\u0006\u0003\u0002x\u0005e\u0004cA\u0016mK\"1\u0011QH\nA\u0002\u001d\u000bA\u0003\\5ti\u0006\u001bG/\u001b<f\u000bb,7-\u001e;j_:\u001cXCAA@!\u001d\t\t)!%o\u0003/sA!a!\u0002\u000e:!\u0011QQAF\u001b\t\t9IC\u0002\u0002\n^\na\u0001\u0010:p_Rt\u0014\"A\u0017\n\u0007\u0005=E&A\u0004qC\u000e\\\u0017mZ3\n\t\u0005M\u0015Q\u0013\u0002\u0007\u000b&$\b.\u001a:\u000b\u0007\u0005=E\u0006E\u0003\u0002\u0002\u0006eU-\u0003\u0003\u0002\u001c\u0006U%aA*fc\u00069B.[:u\u0003\n\fg\u000eZ8oK\u0012,\u00050Z2vi&|gn]\u000b\u0003\u0003/\u000b\u0001b\u001d5vi\u0012|wO\u001c\u000b\u0002g\u000612o\u00195fIVdW\rU3sS>$\u0017nY\"iK\u000e\\7/A\nqKJLw\u000eZ5d\u001b\u0006Lg\u000e^3oC:\u001cW\rF\u0002t\u0003WCa!!,\u0019\u0001\u0004q\u0017a\u0002;j[\u0016|W\u000f^\u0001\u0013g\u0016$\u0018\t\u001c7S!\u000e\u001bH)Z1eY&tW\rF\u0002t\u0003gCa!!.\u001a\u0001\u0004q\u0017A\u00033fC\u0012d\u0017N\\3Ng\u0006\u0001\u0012N\u001c;feJ,\b\u000f^!mYJ\u00036i]\u0001\u0013Y&\u001cH/\u0012=fGV$X\rS8mI\u0016\u00148/\u0006\u0002\u0002>B)\u0011\u0011QAM\u0015\u0002")
public class SparkConnectExecutionManager
implements Logging {
    private final ConcurrentMap<ExecuteKey, ExecuteHolder> executions;
    private final Object executionsLock;
    private final Cache<ExecuteKey, ExecuteInfo> abandonedTombstones;
    @GuardedBy(value="executionsLock")
    private Option<Object> lastExecutionTimeMs;
    @GuardedBy(value="executionsLock")
    private Option<ScheduledExecutorService> scheduledExecutor;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(HashMap<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private ConcurrentMap<ExecuteKey, ExecuteHolder> executions() {
        return this.executions;
    }

    private Object executionsLock() {
        return this.executionsLock;
    }

    private Cache<ExecuteKey, ExecuteInfo> abandonedTombstones() {
        return this.abandonedTombstones;
    }

    private Option<Object> lastExecutionTimeMs() {
        return this.lastExecutionTimeMs;
    }

    private void lastExecutionTimeMs_$eq(Option<Object> x$1) {
        this.lastExecutionTimeMs = x$1;
    }

    private Option<ScheduledExecutorService> scheduledExecutor() {
        return this.scheduledExecutor;
    }

    private void scheduledExecutor_$eq(Option<ScheduledExecutorService> x$1) {
        this.scheduledExecutor = x$1;
    }

    public ExecuteHolder createExecuteHolder(ExecutePlanRequest request) {
        Some some;
        boolean bl = request.hasClientObservedServerSideSessionId();
        if (bl) {
            some = new Some((Object)request.getClientObservedServerSideSessionId());
        } else if (!bl) {
            some = None$.MODULE$;
        } else {
            throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
        }
        Some previousSessionId = some;
        SessionHolder sessionHolder = SparkConnectService$.MODULE$.getOrCreateIsolatedSession(request.getUserContext().getUserId(), request.getSessionId(), (Option<String>)previousSessionId);
        ExecuteKey executeKey2 = ExecuteKey$.MODULE$.apply(request, sessionHolder);
        ExecuteHolder executeHolder = this.executions().compute(executeKey2, (executeKey, oldExecuteHolder) -> {
            if (oldExecuteHolder != null) {
                throw new SparkSQLException("INVALID_HANDLE.OPERATION_ALREADY_EXISTS", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"handle"), (Object)executeKey.operationId())})));
            }
            if (this.getAbandonedTombstone((ExecuteKey)executeKey).isDefined()) {
                throw new SparkSQLException("INVALID_HANDLE.OPERATION_ABANDONED", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"handle"), (Object)executeKey.operationId())})));
            }
            return new ExecuteHolder((ExecuteKey)executeKey, request, sessionHolder);
        });
        sessionHolder.addExecuteHolder(executeHolder);
        Object object = this.executionsLock();
        synchronized (object) {
            if (!this.executions().isEmpty()) {
                this.lastExecutionTimeMs_$eq((Option<Object>)None$.MODULE$);
            }
        }
        this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"ExecuteHolder ", " is created."}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.EXECUTE_KEY$.MODULE$, (Object)executeHolder.key())}))));
        this.schedulePeriodicChecks();
        return executeHolder;
    }

    public void removeExecuteHolder(ExecuteKey key, boolean abandoned) {
        ExecuteHolder executeHolder = (ExecuteHolder)this.executions().get(key);
        if (executeHolder == null) {
            return;
        }
        if (abandoned) {
            this.abandonedTombstones().put(key, executeHolder.getExecuteInfo());
        }
        this.executions().remove(key);
        executeHolder.sessionHolder().removeExecuteHolder(executeHolder.operationId());
        Object object = this.executionsLock();
        synchronized (object) {
            if (this.executions().isEmpty()) {
                this.lastExecutionTimeMs_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)System.currentTimeMillis())));
            }
        }
        this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"ExecuteHolder ", " is removed."}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.EXECUTE_KEY$.MODULE$, (Object)key)}))));
        executeHolder.close();
        if (abandoned) {
            this.abandonedTombstones().put(key, executeHolder.getExecuteInfo());
            return;
        }
    }

    public boolean removeExecuteHolder$default$2() {
        return false;
    }

    public Option<ExecuteHolder> getExecuteHolder(ExecuteKey key) {
        return Option$.MODULE$.apply(this.executions().get(key));
    }

    public void removeAllExecutionsForSession(SessionKey key) {
        ObjectRef sessionExecutionHolders = ObjectRef.create((Object)((ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$)));
        this.executions().forEach((x$1, executeHolder) -> {
            SessionKey sessionKey = executeHolder.sessionHolder().key();
            SessionKey sessionKey2 = key;
            if (!(sessionKey != null ? !((Object)sessionKey).equals(sessionKey2) : sessionKey2 != null)) {
                ((ArrayBuffer)sessionExecutionHolders$1.elem).$plus$eq(executeHolder);
                return;
            }
        });
        ((ArrayBuffer)sessionExecutionHolders.elem).foreach((Function1 & Serializable)executeHolder -> {
            SparkConnectExecutionManager.$anonfun$removeAllExecutionsForSession$2(this, executeHolder);
            return BoxedUnit.UNIT;
        });
    }

    public Option<ExecuteInfo> getAbandonedTombstone(ExecuteKey key) {
        return Option$.MODULE$.apply((Object)this.abandonedTombstones().getIfPresent(key));
    }

    public Either<Object, Seq<ExecuteInfo>> listActiveExecutions() {
        if (this.executions().isEmpty()) {
            return new Left(this.lastExecutionTimeMs().get());
        }
        return new Right((Object)((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(this.executions().values()).asScala().map((Function1 & Serializable)x$2 -> x$2.getExecuteInfo())).toBuffer().toSeq());
    }

    public Seq<ExecuteInfo> listAbandonedExecutions() {
        return CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(this.abandonedTombstones().asMap()).asScala().values().toSeq();
    }

    public void shutdown() {
        Object object = this.executionsLock();
        synchronized (object) {
            this.scheduledExecutor().foreach((Function1 & Serializable)executor -> {
                ThreadUtils$.MODULE$.shutdown((ExecutorService)executor, (Duration)FiniteDuration$.MODULE$.apply(1L, TimeUnit.MINUTES));
                return BoxedUnit.UNIT;
            });
            this.scheduledExecutor_$eq((Option<ScheduledExecutorService>)None$.MODULE$);
        }
        this.executions().clear();
        this.abandonedTombstones().invalidateAll();
        Object object2 = this.executionsLock();
        synchronized (object2) {
            if (this.lastExecutionTimeMs().isEmpty()) {
                this.lastExecutionTimeMs_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)System.currentTimeMillis())));
            }
        }
    }

    private void schedulePeriodicChecks() {
        Object object = this.executionsLock();
        synchronized (object) {
            Option<ScheduledExecutorService> option = this.scheduledExecutor();
            if (option instanceof Some) {
            } else if (None$.MODULE$.equals(option)) {
                long interval = BoxesRunTime.unboxToLong((Object)SparkEnv$.MODULE$.get().conf().get(Connect$.MODULE$.CONNECT_EXECUTE_MANAGER_MAINTENANCE_INTERVAL()));
                this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Starting thread for cleanup of abandoned executions every "}))).log((Seq)Nil$.MODULE$).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", " ms"}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.INTERVAL$.MODULE$, (Object)BoxesRunTime.boxToLong((long)interval))})))));
                this.scheduledExecutor_$eq((Option<ScheduledExecutorService>)new Some((Object)Executors.newSingleThreadScheduledExecutor()));
                ((ScheduledExecutorService)this.scheduledExecutor().get()).scheduleAtFixedRate(() -> {
                    try {
                        long timeout = BoxesRunTime.unboxToLong((Object)SparkEnv$.MODULE$.get().conf().get(Connect$.MODULE$.CONNECT_EXECUTE_MANAGER_DETACHED_TIMEOUT()));
                        this.periodicMaintenance(timeout);
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2 = throwable;
                        if (NonFatal$.MODULE$.apply(throwable2)) {
                            this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Unexpected exception in periodic task", throwable2);
                        }
                        throw throwable;
                    }
                }, interval, interval, TimeUnit.MILLISECONDS);
            } else {
                throw new MatchError(option);
            }
        }
    }

    public void periodicMaintenance(long timeout) {
        this.logInfo((Function0<String>)(Function0 & Serializable)() -> "Started periodic run of SparkConnectExecutionManager maintenance.");
        ArrayBuffer toRemove = new ArrayBuffer();
        long nowMs = System.currentTimeMillis();
        this.executions().forEach((x$3, executeHolder) -> {
            Option<Object> option = executeHolder.lastAttachedRpcTimeMs();
            if (option instanceof Some) {
                Some some = (Some)option;
                long detached = BoxesRunTime.unboxToLong((Object)some.value());
                if (detached + timeout <= nowMs) {
                    toRemove.$plus$eq(executeHolder);
                    return;
                }
                return;
            }
        });
        toRemove.foreach((Function1 & Serializable)executeHolder -> {
            SparkConnectExecutionManager.$anonfun$periodicMaintenance$3(this, executeHolder);
            return BoxedUnit.UNIT;
        });
        this.logInfo((Function0<String>)(Function0 & Serializable)() -> "Finished periodic run of SparkConnectExecutionManager maintenance.");
    }

    public void setAllRPCsDeadline(long deadlineMs) {
        CollectionConverters$.MODULE$.CollectionHasAsScala(this.executions().values()).asScala().foreach((Function1 & Serializable)x$4 -> {
            x$4.setGrpcResponseSendersDeadline(deadlineMs);
            return BoxedUnit.UNIT;
        });
    }

    public void interruptAllRPCs() {
        CollectionConverters$.MODULE$.CollectionHasAsScala(this.executions().values()).asScala().foreach((Function1 & Serializable)x$5 -> {
            x$5.interruptGrpcResponseSenders();
            return BoxedUnit.UNIT;
        });
    }

    public Seq<ExecuteHolder> listExecuteHolders() {
        return CollectionConverters$.MODULE$.CollectionHasAsScala(this.executions().values()).asScala().toSeq();
    }

    public static final /* synthetic */ void $anonfun$removeAllExecutionsForSession$2(SparkConnectExecutionManager $this, ExecuteHolder executeHolder) {
        ExecuteInfo info = executeHolder.getExecuteInfo();
        $this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> $this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Execution ", " removed in removeSessionExecutions."}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.EXECUTE_INFO$.MODULE$, (Object)info)}))));
        $this.removeExecuteHolder(executeHolder.key(), true);
    }

    public static final /* synthetic */ void $anonfun$periodicMaintenance$3(SparkConnectExecutionManager $this, ExecuteHolder executeHolder) {
        ExecuteInfo info = executeHolder.getExecuteInfo();
        $this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> $this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Found execution ", " that was abandoned "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.EXECUTE_INFO$.MODULE$, (Object)info)})).$plus($this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"and expired and will be removed."}))).log((Seq)Nil$.MODULE$))));
        $this.removeExecuteHolder(executeHolder.key(), true);
    }

    public SparkConnectExecutionManager() {
        Logging.$init$((Logging)this);
        this.executions = new ConcurrentHashMap<ExecuteKey, ExecuteHolder>();
        this.executionsLock = new Object();
        this.abandonedTombstones = CacheBuilder.newBuilder().maximumSize(BoxesRunTime.unboxToInt((Object)SparkEnv$.MODULE$.get().conf().get(Connect$.MODULE$.CONNECT_EXECUTE_MANAGER_ABANDONED_TOMBSTONES_SIZE()))).build();
        this.lastExecutionTimeMs = new Some((Object)BoxesRunTime.boxToLong((long)System.currentTimeMillis()));
        this.scheduledExecutor = None$.MODULE$;
    }
}

