/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connect.service;

import java.io.Serializable;
import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.GuardedBy;
import org.apache.spark.SparkEnv$;
import org.apache.spark.SparkSQLException;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.connect.config.Connect$;
import org.apache.spark.sql.connect.service.SessionHolder;
import org.apache.spark.sql.connect.service.SessionHolderInfo;
import org.apache.spark.sql.connect.service.SessionKey;
import org.apache.spark.util.ThreadUtils$;
import org.slf4j.Logger;
import org.sparkproject.connect.guava.cache.Cache;
import org.sparkproject.connect.guava.cache.CacheBuilder;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\u0005%g\u0001B\u000f\u001f\u0001-BQ\u0001\u000f\u0001\u0005\u0002eBq\u0001\u0010\u0001C\u0002\u0013%Q\b\u0003\u0004G\u0001\u0001\u0006IA\u0010\u0005\b\u000f\u0002\u0011\r\u0011\"\u0003I\u0011\u00199\u0006\u0001)A\u0005\u0013\"9\u0001\f\u0001b\u0001\n\u0013I\u0006BB5\u0001A\u0003%!\fC\u0004k\u0001\u0001\u0007I\u0011B6\t\u000fI\u0004\u0001\u0019!C\u0005g\"1\u0011\u0010\u0001Q!\n1Dq!!\u0004\u0001\t\u0013\ty\u0001\u0003\u0005\u00024\u0001!\t\u0001IA\u001b\u0011!\ty\u0004\u0001C\u0001A\u0005\u0005\u0003\u0002CA$\u0001\u0011\u0005\u0001%!\u0013\t\u000f\u0005=\u0003\u0001\"\u0003\u0002R!9\u0011\u0011\r\u0001\u0005\n\u0005\r\u0004bBA4\u0001\u0011%\u0011\u0011\u000e\u0005\b\u0003_\u0002A\u0011AA9\u0011!\t)\b\u0001C\u0001A\u0005]\u0004bBA=\u0001\u0011\u0005\u00111\u0010\u0005\b\u0003\u001f\u0003A\u0011AA>\u0011\u001d\t\t\n\u0001C\u0005\u0003oB\u0001\"a%\u0001\t\u0003\u0001\u0013Q\u0013\u0005\b\u0003'\u0003A\u0011BAQ\u0011\u001d\ty\u000b\u0001C\u0005\u0003cCq!a/\u0001\t\u0013\ti\f\u0003\u0005\u0002B\u0002!\t\u0001IA<\u0011!\t\u0019\r\u0001C\u0001A\u0005\u0015'AG*qCJ\\7i\u001c8oK\u000e$8+Z:tS>tW*\u00198bO\u0016\u0014(BA\u0010!\u0003\u001d\u0019XM\u001d<jG\u0016T!!\t\u0012\u0002\u000f\r|gN\\3di*\u00111\u0005J\u0001\u0004gFd'BA\u0013'\u0003\u0015\u0019\b/\u0019:l\u0015\t9\u0003&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002S\u0005\u0019qN]4\u0004\u0001M\u0019\u0001\u0001\f\u001a\u0011\u00055\u0002T\"\u0001\u0018\u000b\u0003=\nQa]2bY\u0006L!!\r\u0018\u0003\r\u0005s\u0017PU3g!\t\u0019d'D\u00015\u0015\t)D%\u0001\u0005j]R,'O\\1m\u0013\t9DGA\u0004M_\u001e<\u0017N\\4\u0002\rqJg.\u001b;?)\u0005Q\u0004CA\u001e\u0001\u001b\u0005q\u0012\u0001D:fgNLwN\\:M_\u000e\\W#\u0001 \u0011\u0005}\"U\"\u0001!\u000b\u0005\u0005\u0013\u0015\u0001\u00027b]\u001eT\u0011aQ\u0001\u0005U\u00064\u0018-\u0003\u0002F\u0001\n1qJ\u00196fGR\fQb]3tg&|gn\u001d'pG.\u0004\u0013\u0001D:fgNLwN\\*u_J,W#A%\u0011\t){\u0015\u000bV\u0007\u0002\u0017*\u0011A*T\u0001\u000bG>t7-\u001e:sK:$(B\u0001(C\u0003\u0011)H/\u001b7\n\u0005A[%!D\"p]\u000e,(O]3oi6\u000b\u0007\u000f\u0005\u0002<%&\u00111K\b\u0002\u000b'\u0016\u001c8/[8o\u0017\u0016L\bCA\u001eV\u0013\t1fDA\u0007TKN\u001c\u0018n\u001c8I_2$WM]\u0001\u000eg\u0016\u001c8/[8o'R|'/\u001a\u0011\u0002'\rdwn]3e'\u0016\u001c8/[8og\u000e\u000b7\r[3\u0016\u0003i\u0003Ba\u00173RM6\tAL\u0003\u0002^=\u0006)1-Y2iK*\u0011q\fY\u0001\u0007G>lWn\u001c8\u000b\u0005\u0005\u0014\u0017AB4p_\u001edWMC\u0001d\u0003\r\u0019w.\\\u0005\u0003Kr\u0013QaQ1dQ\u0016\u0004\"aO4\n\u0005!t\"!E*fgNLwN\u001c%pY\u0012,'/\u00138g_\u0006!2\r\\8tK\u0012\u001cVm]:j_:\u001c8)Y2iK\u0002\n\u0011c]2iK\u0012,H.\u001a3Fq\u0016\u001cW\u000f^8s+\u0005a\u0007cA\u0017n_&\u0011aN\f\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005)\u0003\u0018BA9L\u0005a\u00196\r[3ek2,G-\u0012=fGV$xN]*feZL7-Z\u0001\u0016g\u000eDW\rZ;mK\u0012,\u00050Z2vi>\u0014x\fJ3r)\t!x\u000f\u0005\u0002.k&\u0011aO\f\u0002\u0005+:LG\u000fC\u0004y\u0013\u0005\u0005\t\u0019\u00017\u0002\u0007a$\u0013'\u0001\ntG\",G-\u001e7fI\u0016CXmY;u_J\u0004\u0003F\u0002\u0006|\u0003\u0013\tY\u0001E\u0002}\u0003\u000bi\u0011! \u0006\u0003\u0019zT1a`A\u0001\u0003)\tgN\\8uCRLwN\u001c\u0006\u0003\u0003\u0007\tQA[1wCbL1!a\u0002~\u0005%9U/\u0019:eK\u0012\u0014\u00150A\u0003wC2,X-I\u0001=\u0003E1\u0018\r\\5eCR,7+Z:tS>t\u0017\n\u001a\u000b\bi\u0006E\u0011QCA\u0018\u0011\u0019\t\u0019b\u0003a\u0001#\u0006\u00191.Z=\t\u000f\u0005]1\u00021\u0001\u0002\u001a\u0005Y1/Z:tS>tW+V%E!\u0011\tY\"!\u000b\u000f\t\u0005u\u0011Q\u0005\t\u0004\u0003?qSBAA\u0011\u0015\r\t\u0019CK\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005\u001db&\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003W\tiC\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003Oq\u0003bBA\u0019\u0017\u0001\u0007\u0011\u0011D\u0001\u001caJ,g/[8vg2LxJY:feZ,GmU3tg&|g.\u00133\u00025\u001d,Go\u0014:De\u0016\fG/Z%t_2\fG/\u001a3TKN\u001c\u0018n\u001c8\u0015\u000bQ\u000b9$!\u000f\t\r\u0005MA\u00021\u0001R\u0011\u001d\tY\u0004\u0004a\u0001\u0003{\tA\u0004\u001d:fm&|Wo\u001d7z\u001f\n\u001cXM\u001d<fIN+7o]:j_:LE\r\u0005\u0003.[\u0006e\u0011AE4fi&\u001bx\u000e\\1uK\u0012\u001cVm]:j_:$R\u0001VA\"\u0003\u000bBa!a\u0005\u000e\u0001\u0004\t\u0006bBA\u001e\u001b\u0001\u0007\u0011QH\u0001\u001cO\u0016$\u0018j]8mCR,GmU3tg&|g.\u00134Qe\u0016\u001cXM\u001c;\u0015\t\u0005-\u0013Q\n\t\u0004[5$\u0006BBA\n\u001d\u0001\u0007\u0011+\u0001\u0006hKR\u001cVm]:j_:$R\u0001VA*\u0003+Ba!a\u0005\u0010\u0001\u0004\t\u0006bBA,\u001f\u0001\u0007\u0011\u0011L\u0001\bI\u00164\u0017-\u001e7u!\u0011iS.a\u0017\u0011\t5\ni\u0006V\u0005\u0004\u0003?r#!\u0003$v]\u000e$\u0018n\u001c81\u0003M\u0011X-\\8wKN+7o]5p]\"{G\u000eZ3s)\u0011\tY%!\u001a\t\r\u0005M\u0001\u00031\u0001R\u0003U\u0019\b.\u001e;e_^t7+Z:tS>t\u0007j\u001c7eKJ$2\u0001^A6\u0011\u0019\ti'\u0005a\u0001)\u0006i1/Z:tS>t\u0007j\u001c7eKJ\fAb\u00197pg\u0016\u001cVm]:j_:$2\u0001^A:\u0011\u0019\t\u0019B\u0005a\u0001#\u0006A1\u000f[;uI><h\u000eF\u0001u\u0003Ia\u0017n\u001d;BGRLg/Z*fgNLwN\\:\u0016\u0005\u0005u\u0004#BA@\u0003\u00133g\u0002BAA\u0003\u000bsA!a\b\u0002\u0004&\tq&C\u0002\u0002\b:\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002\f\u00065%aA*fc*\u0019\u0011q\u0011\u0018\u0002%1L7\u000f^\"m_N,GmU3tg&|gn]\u0001\u0017g\u000eDW\rZ;mKB+'/[8eS\u000e\u001c\u0005.Z2lg\u0006\u0019\u0002/\u001a:j_\u0012L7-T1j]R,g.\u00198dKR\u0019A/a&\t\u000f\u0005eu\u00031\u0001\u0002\u001c\u0006AB-\u001a4bk2$\u0018J\\1di&4X\rV5nK>,H/T:\u0011\u00075\ni*C\u0002\u0002 :\u0012A\u0001T8oOR)A/a)\u0002&\"9\u0011\u0011\u0014\rA\u0002\u0005m\u0005bBAT1\u0001\u0007\u0011\u0011V\u0001\u0014S\u001etwN]3DkN$x.\u001c+j[\u0016|W\u000f\u001e\t\u0004[\u0005-\u0016bAAW]\t9!i\\8mK\u0006t\u0017A\u00058fo&\u001bx\u000e\\1uK\u0012\u001cVm]:j_:$\"!a-\u0011\t\u0005U\u0016qW\u0007\u0002E%\u0019\u0011\u0011\u0018\u0012\u0003\u0019M\u0003\u0018M]6TKN\u001c\u0018n\u001c8\u0002+Y\fG.\u001b3bi\u0016\u001cVm]:j_:\u001c%/Z1uKR\u0019A/a0\t\r\u0005M!\u00041\u0001R\u0003UIgN^1mS\u0012\fG/Z!mYN+7o]5p]N\fA\u0003];u'\u0016\u001c8/[8o\r>\u0014H+Z:uS:<Gc\u0001;\u0002H\"1\u0011Q\u000e\u000fA\u0002Q\u0003")
public class SparkConnectSessionManager
implements Logging {
    private final Object sessionsLock;
    private final ConcurrentMap<SessionKey, SessionHolder> sessionStore;
    private final Cache<SessionKey, SessionHolderInfo> closedSessionsCache;
    @GuardedBy(value="sessionsLock")
    private Option<ScheduledExecutorService> scheduledExecutor;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(HashMap<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private Object sessionsLock() {
        return this.sessionsLock;
    }

    private ConcurrentMap<SessionKey, SessionHolder> sessionStore() {
        return this.sessionStore;
    }

    private Cache<SessionKey, SessionHolderInfo> closedSessionsCache() {
        return this.closedSessionsCache;
    }

    private Option<ScheduledExecutorService> scheduledExecutor() {
        return this.scheduledExecutor;
    }

    private void scheduledExecutor_$eq(Option<ScheduledExecutorService> x$1) {
        this.scheduledExecutor = x$1;
    }

    private void validateSessionId(SessionKey key, String sessionUUID, String previouslyObservedSessionId) {
        String string = sessionUUID;
        String string2 = previouslyObservedSessionId;
        if (string == null ? string2 != null : !string.equals(string2)) {
            throw new SparkSQLException("INVALID_HANDLE.SESSION_CHANGED", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"handle"), (Object)key.sessionId())})));
        }
    }

    public SessionHolder getOrCreateIsolatedSession(SessionKey key, Option<String> previouslyObservedSesssionId) {
        SessionHolder holder = this.getSession(key, (Option<Function0<SessionHolder>>)new Some((Function0 & Serializable)() -> {
            this.validateSessionCreate(key);
            SessionHolder holder = new SessionHolder(key.userId(), key.sessionId(), this.newIsolatedSession());
            holder.initializeSession();
            return holder;
        }));
        previouslyObservedSesssionId.foreach((Function1 & Serializable)sessionId -> {
            this.validateSessionId(key, holder.session().sessionUUID(), sessionId);
            return BoxedUnit.UNIT;
        });
        return holder;
    }

    public SessionHolder getIsolatedSession(SessionKey key, Option<String> previouslyObservedSesssionId) {
        SessionHolder holder = this.getSession(key, (Option<Function0<SessionHolder>>)new Some((Function0 & Serializable)() -> {
            this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Session not found: " + key);
            if (this.closedSessionsCache().getIfPresent(key) != null) {
                throw new SparkSQLException("INVALID_HANDLE.SESSION_CLOSED", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"handle"), (Object)key.sessionId())})));
            }
            throw new SparkSQLException("INVALID_HANDLE.SESSION_NOT_FOUND", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"handle"), (Object)key.sessionId())})));
        }));
        previouslyObservedSesssionId.foreach((Function1 & Serializable)sessionId -> {
            this.validateSessionId(key, holder.session().sessionUUID(), sessionId);
            return BoxedUnit.UNIT;
        });
        return holder;
    }

    public Option<SessionHolder> getIsolatedSessionIfPresent(SessionKey key) {
        return Option$.MODULE$.apply((Object)this.getSession(key, (Option<Function0<SessionHolder>>)None$.MODULE$));
    }

    private SessionHolder getSession(SessionKey key, Option<Function0<SessionHolder>> option) {
        SessionHolder session;
        block4: {
            SessionHolder sessionHolder;
            this.schedulePeriodicChecks();
            Option<Function0<SessionHolder>> option2 = option;
            if (option2 instanceof Some) {
                Some some = (Some)option2;
                Function0 callable = (Function0)some.value();
                sessionHolder = this.sessionStore().computeIfAbsent(key, x$1 -> (SessionHolder)callable.apply());
            } else if (None$.MODULE$.equals(option2)) {
                sessionHolder = (SessionHolder)this.sessionStore().get(key);
            } else {
                throw new MatchError(option2);
            }
            session = sessionHolder;
            if (session == null) break block4;
            session.updateAccessTime();
        }
        return session;
    }

    private Option<SessionHolder> removeSessionHolder(SessionKey key) {
        None$ sessionHolder = None$.MODULE$;
        sessionHolder = Option$.MODULE$.apply(this.sessionStore().get(key));
        sessionHolder.foreach((Function1 & Serializable)s2 -> {
            this.closedSessionsCache().put(s2.key(), s2.getSessionHolderInfo());
            return (SessionHolder)this.sessionStore().remove(key);
        });
        return sessionHolder;
    }

    private void shutdownSessionHolder(SessionHolder sessionHolder) {
        sessionHolder.close();
        this.closedSessionsCache().put(sessionHolder.key(), sessionHolder.getSessionHolderInfo());
    }

    public void closeSession(SessionKey key) {
        Option<SessionHolder> sessionHolder = this.removeSessionHolder(key);
        sessionHolder.foreach((Function1 & Serializable)x$2 -> {
            this.shutdownSessionHolder(x$2);
            return BoxedUnit.UNIT;
        });
    }

    public void shutdown() {
        Object object = this.sessionsLock();
        synchronized (object) {
            this.scheduledExecutor().foreach((Function1 & Serializable)executor -> {
                ThreadUtils$.MODULE$.shutdown((ExecutorService)executor, (Duration)FiniteDuration$.MODULE$.apply(1L, TimeUnit.MINUTES));
                return BoxedUnit.UNIT;
            });
            this.scheduledExecutor_$eq((Option<ScheduledExecutorService>)None$.MODULE$);
        }
        this.sessionStore().clear();
        this.closedSessionsCache().invalidateAll();
    }

    public Seq<SessionHolderInfo> listActiveSessions() {
        return ((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(this.sessionStore().values()).asScala().map((Function1 & Serializable)x$3 -> x$3.getSessionHolderInfo())).toSeq();
    }

    public Seq<SessionHolderInfo> listClosedSessions() {
        return CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(this.closedSessionsCache().asMap()).asScala().values().toSeq();
    }

    private void schedulePeriodicChecks() {
        Object object = this.sessionsLock();
        synchronized (object) {
            Option<ScheduledExecutorService> option = this.scheduledExecutor();
            if (option instanceof Some) {
            } else if (None$.MODULE$.equals(option)) {
                long interval = BoxesRunTime.unboxToLong((Object)SparkEnv$.MODULE$.get().conf().get(Connect$.MODULE$.CONNECT_SESSION_MANAGER_MAINTENANCE_INTERVAL()));
                this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Starting thread for cleanup of expired sessions every "}))).log((Seq)Nil$.MODULE$).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", " ms"}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.INTERVAL$.MODULE$, (Object)BoxesRunTime.boxToLong((long)interval))})))));
                this.scheduledExecutor_$eq((Option<ScheduledExecutorService>)new Some((Object)Executors.newSingleThreadScheduledExecutor()));
                ((ScheduledExecutorService)this.scheduledExecutor().get()).scheduleAtFixedRate(() -> {
                    try {
                        long defaultInactiveTimeoutMs = BoxesRunTime.unboxToLong((Object)SparkEnv$.MODULE$.get().conf().get(Connect$.MODULE$.CONNECT_SESSION_MANAGER_DEFAULT_SESSION_TIMEOUT()));
                        this.periodicMaintenance(defaultInactiveTimeoutMs);
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2 = throwable;
                        if (NonFatal$.MODULE$.apply(throwable2)) {
                            this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Unexpected exception in periodic task", throwable2);
                        }
                        throw throwable;
                    }
                }, interval, interval, TimeUnit.MILLISECONDS);
            } else {
                throw new MatchError(option);
            }
        }
    }

    public void periodicMaintenance(long defaultInactiveTimeoutMs) {
        this.periodicMaintenance(defaultInactiveTimeoutMs, false);
    }

    private void periodicMaintenance(long defaultInactiveTimeoutMs, boolean ignoreCustomTimeout) {
        this.logInfo((Function0<String>)(Function0 & Serializable)() -> "Started periodic run of SparkConnectSessionManager maintenance.");
        ArrayBuffer toRemove = new ArrayBuffer();
        long nowMs = System.currentTimeMillis();
        this.sessionStore().forEach((x$4, sessionHolder) -> {
            if (SparkConnectSessionManager.shouldExpire$1(sessionHolder.getSessionHolderInfo(), nowMs, ignoreCustomTimeout, defaultInactiveTimeoutMs)) {
                toRemove.$plus$eq(sessionHolder);
                return;
            }
        });
        toRemove.foreach((Function1 & Serializable)sessionHolder -> {
            SparkConnectSessionManager.$anonfun$periodicMaintenance$3(this, ignoreCustomTimeout, defaultInactiveTimeoutMs, sessionHolder);
            return BoxedUnit.UNIT;
        });
        this.logInfo((Function0<String>)(Function0 & Serializable)() -> "Finished periodic run of SparkConnectSessionManager maintenance.");
    }

    private SparkSession newIsolatedSession() {
        SparkSession active = SparkSession$.MODULE$.active();
        if (active.sparkContext().isStopped()) {
            Predef$.MODULE$.assert(SparkSession$.MODULE$.getDefaultSession().nonEmpty());
            return ((SparkSession)SparkSession$.MODULE$.getDefaultSession().get()).newSession();
        }
        return active.newSession();
    }

    private void validateSessionCreate(SessionKey key) {
        try {
            UUID.fromString(key.sessionId()).toString();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new SparkSQLException("INVALID_HANDLE.FORMAT", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"handle"), (Object)key.sessionId())})));
        }
        if (this.closedSessionsCache().getIfPresent(key) != null) {
            throw new SparkSQLException("INVALID_HANDLE.SESSION_CLOSED", (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"handle"), (Object)key.sessionId())})));
        }
    }

    public void invalidateAllSessions() {
        this.periodicMaintenance(0L, true);
        Predef$.MODULE$.assert(this.sessionStore().isEmpty());
        this.closedSessionsCache().invalidateAll();
    }

    public void putSessionForTesting(SessionHolder sessionHolder) {
        this.sessionStore().put(sessionHolder.key(), sessionHolder);
    }

    private static final boolean shouldExpire$1(SessionHolderInfo info, long nowMs, boolean ignoreCustomTimeout$1, long defaultInactiveTimeoutMs$1) {
        long timeoutMs = info.customInactiveTimeoutMs().isDefined() && !ignoreCustomTimeout$1 ? BoxesRunTime.unboxToLong((Object)info.customInactiveTimeoutMs().get()) : defaultInactiveTimeoutMs$1;
        return timeoutMs != -1L && info.lastAccessTimeMs() + timeoutMs <= nowMs;
    }

    public static final /* synthetic */ void $anonfun$periodicMaintenance$3(SparkConnectSessionManager $this, boolean ignoreCustomTimeout$1, long defaultInactiveTimeoutMs$1, SessionHolder sessionHolder) {
        Option<SessionHolder> option;
        SessionHolderInfo info = sessionHolder.getSessionHolderInfo();
        if (SparkConnectSessionManager.shouldExpire$1(info, System.currentTimeMillis(), ignoreCustomTimeout$1, defaultInactiveTimeoutMs$1)) {
            $this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> $this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Found session ", " that expired "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.SESSION_HOLD_INFO$.MODULE$, (Object)info)})).$plus($this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"and will be closed."}))).log((Seq)Nil$.MODULE$))));
            option = $this.removeSessionHolder(info.key());
        } else {
            option = None$.MODULE$;
        }
        Option<SessionHolder> removedSession = option;
        try {
            removedSession.foreach((Function1 & Serializable)x$5 -> {
                $this.shutdownSessionHolder(x$5);
                return BoxedUnit.UNIT;
            });
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (NonFatal$.MODULE$.apply(throwable2)) {
                $this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Unexpected exception closing session", throwable2);
            }
            throw throwable;
        }
    }

    public SparkConnectSessionManager() {
        Logging.$init$((Logging)this);
        this.sessionsLock = new Object();
        this.sessionStore = new ConcurrentHashMap<SessionKey, SessionHolder>();
        this.closedSessionsCache = CacheBuilder.newBuilder().maximumSize(BoxesRunTime.unboxToInt((Object)SparkEnv$.MODULE$.get().conf().get(Connect$.MODULE$.CONNECT_SESSION_MANAGER_CLOSED_SESSIONS_TOMBSTONES_SIZE()))).build();
        this.scheduledExecutor = None$.MODULE$;
    }
}

