/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connect.ui;

import jakarta.servlet.http.HttpServletRequest;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.connect.ui.ExecutionInfo;
import org.apache.spark.sql.connect.ui.SparkConnectServerAppStatusStore;
import org.apache.spark.sql.connect.ui.SparkConnectServerTab;
import org.apache.spark.sql.connect.ui.SqlStatsPagedTable;
import org.apache.spark.ui.SparkUITab;
import org.apache.spark.ui.UIUtils$;
import org.apache.spark.ui.WebUIPage;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.xml.Elem;
import scala.xml.MetaData;
import scala.xml.NamespaceBinding;
import scala.xml.Node;
import scala.xml.NodeBuffer;
import scala.xml.NodeSeq;
import scala.xml.NodeSeq$;
import scala.xml.Null$;
import scala.xml.Text;
import scala.xml.TopScope$;
import scala.xml.UnprefixedAttribute;

@ScalaSignature(bytes="\u0006\u0005=4QAC\u0006\u0001\u0017]A\u0001b\t\u0001\u0003\u0002\u0003\u0006I!\n\u0005\u0006S\u0001!\tA\u000b\u0005\b[\u0001\u0011\r\u0011\"\u0001/\u0011\u0019\u0011\u0004\u0001)A\u0005_!91\u0007\u0001b\u0001\n\u0013!\u0004BB\u001f\u0001A\u0003%Q\u0007C\u0003?\u0001\u0011\u0005q\bC\u0003a\u0001\u0011%\u0011\rC\u0003c\u0001\u0011%1MA\u000fTa\u0006\u00148nQ8o]\u0016\u001cGoU3sm\u0016\u00148+Z:tS>t\u0007+Y4f\u0015\taQ\"\u0001\u0002vS*\u0011abD\u0001\bG>tg.Z2u\u0015\t\u0001\u0012#A\u0002tc2T!AE\n\u0002\u000bM\u0004\u0018M]6\u000b\u0005Q)\u0012AB1qC\u000eDWMC\u0001\u0017\u0003\ry'oZ\n\u0004\u0001ai\u0002CA\r\u001c\u001b\u0005Q\"B\u0001\u0007\u0012\u0013\ta\"DA\u0005XK\n,\u0016\nU1hKB\u0011a$I\u0007\u0002?)\u0011\u0001%E\u0001\tS:$XM\u001d8bY&\u0011!e\b\u0002\b\u0019><w-\u001b8h\u0003\u0019\u0001\u0018M]3oi\u000e\u0001\u0001C\u0001\u0014(\u001b\u0005Y\u0011B\u0001\u0015\f\u0005U\u0019\u0006/\u0019:l\u0007>tg.Z2u'\u0016\u0014h/\u001a:UC\n\fa\u0001P5oSRtDCA\u0016-!\t1\u0003\u0001C\u0003$\u0005\u0001\u0007Q%A\u0003ti>\u0014X-F\u00010!\t1\u0003'\u0003\u00022\u0017\t\u00013\u000b]1sW\u000e{gN\\3diN+'O^3s\u0003B\u00048\u000b^1ukN\u001cFo\u001c:f\u0003\u0019\u0019Ho\u001c:fA\u0005I1\u000f^1siRKW.Z\u000b\u0002kA\u0011agO\u0007\u0002o)\u0011\u0001(O\u0001\u0005kRLGNC\u0001;\u0003\u0011Q\u0017M^1\n\u0005q:$\u0001\u0002#bi\u0016\f!b\u001d;beR$\u0016.\\3!\u0003\u0019\u0011XM\u001c3feR\u0011\u0001\t\u0016\t\u0004\u0003.seB\u0001\"I\u001d\t\u0019e)D\u0001E\u0015\t)E%\u0001\u0004=e>|GOP\u0005\u0002\u000f\u0006)1oY1mC&\u0011\u0011JS\u0001\ba\u0006\u001c7.Y4f\u0015\u00059\u0015B\u0001'N\u0005\r\u0019V-\u001d\u0006\u0003\u0013*\u0003\"a\u0014*\u000e\u0003AS!!\u0015&\u0002\u0007alG.\u0003\u0002T!\n!aj\u001c3f\u0011\u0015)v\u00011\u0001W\u0003\u001d\u0011X-];fgR\u0004\"a\u00160\u000e\u0003aS!!\u0017.\u0002\t!$H\u000f\u001d\u0006\u00037r\u000bqa]3sm2,GOC\u0001^\u0003\u001dQ\u0017m[1si\u0006L!a\u0018-\u0003%!#H\u000f]*feZdW\r\u001e*fcV,7\u000f^\u0001\u0013O\u0016tWM]1uK\n\u000b7/[2Ti\u0006$8\u000fF\u0001A\u0003U9WM\\3sCR,7+\u0015'Ti\u0006$8\u000fV1cY\u0016$2\u0001\u00113f\u0011\u0015)\u0016\u00021\u0001W\u0011\u00151\u0017\u00021\u0001h\u0003%\u0019Xm]:j_:LE\t\u0005\u0002iY:\u0011\u0011N\u001b\t\u0003\u0007*K!a\u001b&\u0002\rA\u0013X\rZ3g\u0013\tigN\u0001\u0004TiJLgn\u001a\u0006\u0003W*\u0003")
public class SparkConnectServerSessionPage
extends WebUIPage
implements Logging {
    private final SparkConnectServerTab parent;
    private final SparkConnectServerAppStatusStore store;
    private final Date startTime;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(HashMap<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public SparkConnectServerAppStatusStore store() {
        return this.store;
    }

    private Date startTime() {
        return this.startTime;
    }

    public scala.collection.immutable.Seq<Node> render(HttpServletRequest request) {
        scala.collection.immutable.Seq seq;
        String sessionId = request.getParameter("id");
        Predef$.MODULE$.require(sessionId != null && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(sessionId)), (Function0 & Serializable)() -> "Missing id parameter");
        SparkConnectServerAppStatusStore sparkConnectServerAppStatusStore = this.store();
        synchronized (sparkConnectServerAppStatusStore) {
            seq = (scala.collection.immutable.Seq)this.store().getSession(sessionId).map((Function1 & Serializable)sessionStat -> {
                void var3_3;
                IterableOps iterableOps = (IterableOps)this.generateBasicStats().$plus$plus((IterableOnce)new Elem(null, "br", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, true, (scala.collection.immutable.Seq)Nil$.MODULE$));
                NodeBuffer $buf = new NodeBuffer();
                $buf.$amp$plus((Object)new Text("\n            User\n            "));
                $buf.$amp$plus((Object)sessionStat.userId());
                $buf.$amp$plus((Object)new Text("\n            ,\n            Session created at\n            "));
                $buf.$amp$plus((Object)UIUtils$.MODULE$.formatDate(sessionStat.startTimestamp()));
                $buf.$amp$plus((Object)new Text("\n            ,\n            Total run\n            "));
                $buf.$amp$plus((Object)BoxesRunTime.boxToLong((long)sessionStat.totalExecution()));
                $buf.$amp$plus((Object)new Text("\n            Request(s)\n          "));
                return (scala.collection.immutable.Seq)((IterableOps)iterableOps.$plus$plus((IterableOnce)new Elem(null, "h4", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)var3_3)))).$plus$plus(this.generateSQLStatsTable(request, sessionStat.sessionId()));
            }).getOrElse((Function0 & Serializable)() -> {
                void var1_1;
                NodeBuffer $buf = new NodeBuffer();
                $buf.$amp$plus((Object)new Text("No information to display for session "));
                $buf.$amp$plus((Object)sessionId);
                return new Elem(null, "div", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)var1_1));
            });
        }
        scala.collection.immutable.Seq content = seq;
        return UIUtils$.MODULE$.headerSparkPage(request, "Spark Connect Session", (Function0 & Serializable)() -> content, (SparkUITab)this.parent, UIUtils$.MODULE$.headerSparkPage$default$5(), UIUtils$.MODULE$.headerSparkPage$default$6(), UIUtils$.MODULE$.headerSparkPage$default$7());
    }

    private scala.collection.immutable.Seq<Node> generateBasicStats() {
        long timeSinceStart = System.currentTimeMillis() - this.startTime().getTime();
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("class", (Seq)new Text("list-unstyled"), (MetaData)$md);
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("Started at: "));
        $buf2.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf3)));
        $buf2.$amp$plus((Object)new Text(" "));
        $buf2.$amp$plus((Object)UIUtils$.MODULE$.formatDate(this.startTime()));
        $buf2.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "li", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf2)));
        $buf.$amp$plus((Object)new Text("\n      "));
        NodeBuffer $buf4 = new NodeBuffer();
        $buf4.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf5 = new NodeBuffer();
        $buf5.$amp$plus((Object)new Text("Time since start: "));
        $buf4.$amp$plus((Object)new Elem(null, "strong", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf5)));
        $buf4.$amp$plus((Object)UIUtils$.MODULE$.formatDurationVerbose(timeSinceStart));
        $buf4.$amp$plus((Object)new Text("\n      "));
        $buf.$amp$plus((Object)new Elem(null, "li", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf4)));
        $buf.$amp$plus((Object)new Text("\n    "));
        return new Elem(null, "ul", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf));
    }

    private scala.collection.immutable.Seq<Node> generateSQLStatsTable(HttpServletRequest request, String sessionID) {
        None$ none$;
        scala.collection.immutable.Seq executionList = (scala.collection.immutable.Seq)this.store().getExecutionList().filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)SparkConnectServerSessionPage.$anonfun$generateSQLStatsTable$1(sessionID, x$1)));
        int numStatement = executionList.size();
        if (numStatement > 0) {
            String sqlTableTag = "sqlsessionstat";
            int sqlTablePage = BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply((Object)request.getParameter(sqlTableTag + ".page")).map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$2)))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 1));
            try {
                none$ = new Some(new SqlStatsPagedTable(request, this.parent, (scala.collection.immutable.Seq<ExecutionInfo>)executionList, "connect/session", UIUtils$.MODULE$.prependBaseUri(request, this.parent.basePath(), UIUtils$.MODULE$.prependBaseUri$default$3()), sqlTableTag, false).table(sqlTablePage));
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable2 instanceof IllegalArgumentException ? true : throwable2 instanceof IndexOutOfBoundsException) {
                    Null$ $md = Null$.MODULE$;
                    $md = new UnprefixedAttribute("class", (Seq)new Text("alert alert-error"), (MetaData)$md);
                    NodeBuffer $buf = new NodeBuffer();
                    $buf.$amp$plus((Object)new Text("\n            "));
                    NodeBuffer $buf2 = new NodeBuffer();
                    $buf2.$amp$plus((Object)new Text("Error while rendering job table:"));
                    $buf.$amp$plus((Object)new Elem(null, "p", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf2)));
                    $buf.$amp$plus((Object)new Text("\n            "));
                    NodeBuffer $buf3 = new NodeBuffer();
                    $buf3.$amp$plus((Object)new Text("\n              "));
                    $buf3.$amp$plus((Object)Utils$.MODULE$.exceptionString(throwable2));
                    $buf3.$amp$plus((Object)new Text("\n            "));
                    $buf.$amp$plus((Object)new Elem(null, "pre", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf3)));
                    $buf.$amp$plus((Object)new Text("\n          "));
                    Some some = new Some((Object)new Elem(null, "div", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf)));
                    none$ = some;
                }
                throw throwable;
            }
        } else {
            none$ = None$.MODULE$;
        }
        None$ table = none$;
        Null$ $md = Null$.MODULE$;
        $md = new UnprefixedAttribute("onClick", (Seq)new Text("collapseTable('collapse-aggregated-sqlsessionstat',\n                'aggregated-sqlsessionstat')"), (MetaData)$md);
        $md = new UnprefixedAttribute("class", (Seq)new Text("collapse-aggregated-sqlsessionstat collapse-table"), (MetaData)$md);
        $md = new UnprefixedAttribute("id", (Seq)new Text("sqlsessionstat"), (MetaData)$md);
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("\n        "));
        NodeBuffer $buf4 = new NodeBuffer();
        $buf4.$amp$plus((Object)new Text("\n          "));
        Null$ $md2 = Null$.MODULE$;
        $md2 = new UnprefixedAttribute("class", (Seq)new Text("collapse-table-arrow arrow-open"), (MetaData)$md2);
        $buf4.$amp$plus((Object)new Elem(null, "span", (MetaData)$md2, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)Nil$.MODULE$));
        $buf4.$amp$plus((Object)new Text("\n          "));
        NodeBuffer $buf5 = new NodeBuffer();
        $buf5.$amp$plus((Object)new Text("Request Statistics"));
        $buf4.$amp$plus((Object)new Elem(null, "a", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf5)));
        $buf4.$amp$plus((Object)new Text("\n        "));
        $buf.$amp$plus((Object)new Elem(null, "h4", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf4)));
        $buf.$amp$plus((Object)new Text("\n      "));
        Elem elem = new Elem(null, "span", (MetaData)$md, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf));
        Null$ $md3 = Null$.MODULE$;
        $md3 = new UnprefixedAttribute("class", (Seq)new Text("aggregated-sqlsessionstat collapsible-table"), (MetaData)$md3);
        NodeBuffer $buf6 = new NodeBuffer();
        $buf6.$amp$plus((Object)new Text("\n          "));
        $buf6.$amp$plus(table.getOrElse((Function0 & Serializable)() -> "No statistics have been generated yet."));
        $buf6.$amp$plus((Object)new Text("\n        "));
        NodeSeq content = elem.$plus$plus((scala.collection.immutable.Seq)new Elem(null, "div", (MetaData)$md3, (NamespaceBinding)TopScope$.MODULE$, false, (scala.collection.immutable.Seq)NodeSeq$.MODULE$.seqToNodeSeq((Seq)$buf6)));
        return content;
    }

    public static final /* synthetic */ boolean $anonfun$generateSQLStatsTable$1(String sessionID$1, ExecutionInfo x$1) {
        String string = x$1.sessionId();
        String string2 = sessionID$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public SparkConnectServerSessionPage(SparkConnectServerTab parent) {
        this.parent = parent;
        super("session");
        Logging.$init$((Logging)this);
        this.store = parent.store();
        this.startTime = parent.startTime();
    }
}

