/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connect;

import com.google.protobuf.ByteString;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.util.TimeZone;
import java.util.UUID;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.FieldVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.ipc.ArrowStreamReader;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.connect.proto.Command;
import org.apache.spark.connect.proto.ExecutePlanRequest;
import org.apache.spark.connect.proto.ExecutePlanResponse;
import org.apache.spark.connect.proto.LocalRelation;
import org.apache.spark.connect.proto.Plan;
import org.apache.spark.connect.proto.ReattachExecuteRequest;
import org.apache.spark.connect.proto.ReattachOptions;
import org.apache.spark.connect.proto.Relation;
import org.apache.spark.connect.proto.ReleaseSessionRequest;
import org.apache.spark.connect.proto.SparkConnectServiceGrpc;
import org.apache.spark.connect.proto.SqlCommand;
import org.apache.spark.connect.proto.UserContext;
import org.apache.spark.sql.catalyst.ScalaReflection$;
import org.apache.spark.sql.catalyst.encoders.AgnosticEncoder;
import org.apache.spark.sql.connect.client.CloseableIterator;
import org.apache.spark.sql.connect.client.CustomSparkConnectBlockingStub;
import org.apache.spark.sql.connect.client.ExecutePlanResponseReattachableIterator;
import org.apache.spark.sql.connect.client.ExecutePlanResponseReattachableIterator$;
import org.apache.spark.sql.connect.client.RetryPolicy;
import org.apache.spark.sql.connect.client.RetryPolicy$;
import org.apache.spark.sql.connect.client.SparkConnectClient;
import org.apache.spark.sql.connect.client.SparkConnectClient$;
import org.apache.spark.sql.connect.client.SparkConnectStubState;
import org.apache.spark.sql.connect.client.arrow.ArrowSerializer$;
import org.apache.spark.sql.connect.common.config.ConnectCommon$;
import org.apache.spark.sql.connect.config.Connect$;
import org.apache.spark.sql.connect.dsl.package;
import org.apache.spark.sql.connect.dsl.package$plans$;
import org.apache.spark.sql.connect.service.ExecuteHolder;
import org.apache.spark.sql.connect.service.ExecuteInfo;
import org.apache.spark.sql.connect.service.SparkConnectService$;
import org.apache.spark.sql.test.SharedSparkSession;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions;
import org.scalatest.Assertions$;
import org.scalatest.compatible.Assertion;
import org.scalatest.concurrent.Eventually$;
import org.scalatest.concurrent.Signaler$;
import org.scalatest.concurrent.TimeLimits$;
import org.scalatest.enablers.Retrying$;
import org.scalatest.enablers.Timed$;
import org.scalatest.time.Span;
import org.scalatest.time.SpanSugar$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.SeqOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.reflect.api.TypeTags;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Random$;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0005\r%baB\u00193!\u0003\r\t!\u0010\u0005\u0006\u0011\u0002!\t!\u0013\u0005\b!\u0002\u0011\r\u0011\"\u0001R\u0011\u001d)\u0006A1A\u0005\u0002YCqa\u0018\u0001C\u0002\u0013\u0005\u0001\rC\u0003j\u0001\u0011\u0005\u0013\nC\u0003k\u0001\u0011\u0005\u0013\nC\u0003l\u0001\u0011\u0005\u0013\nC\u0003m\u0001\u0011\u0005\u0013\nC\u0003n\u0001\u0011E\u0011\nC\u0004o\u0001\t\u0007I\u0011C8\t\u000fa\u0004!\u0019!C\t_\"9\u0011\u0010\u0001b\u0001\n#Q\b\"CA\u0013\u0001\t\u0007I\u0011CA\u0014\u0011\u001d\t9\u0004\u0001C\t\u0003sA\u0011\"!\u0019\u0001#\u0003%\t\"a\u0019\t\u0013\u0005e\u0004!%A\u0005\u0012\u0005\r\u0004bBA>\u0001\u0011E\u0011Q\u0010\u0005\b\u0003#\u0003A\u0011CAJ\u0011%\t9\u000bAI\u0001\n#\t\u0019\u0007C\u0005\u0002*\u0002\t\n\u0011\"\u0005\u0002,\"9\u0011q\u0016\u0001\u0005\u0012\u0005E\u0006bBA\\\u0001\u0011E\u0011\u0011\u0018\u0005\b\u0003\u007f\u0003A\u0011CAa\u0011\u001d\u0011y\u0002\u0001C\t\u0005CAaAa\u0010\u0001\t#I\u0005B\u0002B!\u0001\u0011E\u0011\n\u0003\u0004\u0003D\u0001!\t\"\u0013\u0005\u0007\u0005\u000b\u0002A\u0011C%\t\u000f\t\u001d\u0003\u0001\"\u0005\u0003J!9!Q\n\u0001\u0005\u0012\t=\u0003b\u0002B*\u0001\u0011E!Q\u000b\u0005\b\u0005G\u0002A\u0011\u0003B+\u0011\u001d\u0011)\u0007\u0001C\t\u0005OB\u0011B!!\u0001#\u0003%\t\"a\u0019\t\u0013\t\r\u0005!%A\u0005\u0012\u0005\r\u0004b\u0002B3\u0001\u0011E!Q\u0011\u0005\b\u0005K\u0002A\u0011\u0003BE\u0011\u001d\u0011\t\n\u0001C\t\u0005'CqA!,\u0001\t#\u0011y\u000bC\u0005\u0003J\u0002\t\n\u0011\"\u0005\u0003L\"9!q\u001a\u0001\u0005\u0012\tE\u0007b\u0002Bh\u0001\u0011E!1\u001d\u0005\n\u0005W\u0004\u0011\u0013!C\t\u0005[DqA!=\u0001\t#\u0011\u0019\u0010C\u0007\u0004\u0016\u0001\u0001\n1!A\u0001\n\u0013I5q\u0003\u0005\u000e\u00073\u0001\u0001\u0013aA\u0001\u0002\u0013%\u0011ja\u0007\t\u001b\ru\u0001\u0001%A\u0002\u0002\u0003%I!SB\u0010\u00115\u0019)\u0003\u0001I\u0001\u0004\u0003\u0005I\u0011B%\u0004(\t12\u000b]1sW\u000e{gN\\3diN+'O^3s)\u0016\u001cHO\u0003\u00024i\u000591m\u001c8oK\u000e$(BA\u001b7\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003oa\nQa\u001d9be.T!!\u000f\u001e\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0014aA8sO\u000e\u00011c\u0001\u0001?\u0005B\u0011q\bQ\u0007\u0002m%\u0011\u0011I\u000e\u0002\u000e'B\f'o\u001b$v]N+\u0018\u000e^3\u0011\u0005\r3U\"\u0001#\u000b\u0005\u0015#\u0014\u0001\u0002;fgRL!a\u0012#\u0003%MC\u0017M]3e'B\f'o[*fgNLwN\\\u0001\u0007I%t\u0017\u000e\u001e\u0013\u0015\u0003)\u0003\"a\u0013(\u000e\u00031S\u0011!T\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001f2\u0013A!\u00168ji\u0006Q1/\u001a:wKJ\u0004vN\u001d;\u0016\u0003I\u0003\"aS*\n\u0005Qc%aA%oi\u0006\tRM^3oiV\fG\u000e\\=US6,w.\u001e;\u0016\u0003]\u0003\"\u0001W/\u000e\u0003eS!AW.\u0002\tQLW.\u001a\u0006\u00039j\n\u0011b]2bY\u0006$Xm\u001d;\n\u0005yK&\u0001B*qC:\f\u0011\"\u00197m_\u000e\fGo\u001c:\u0016\u0003\u0005\u0004\"AY4\u000e\u0003\rT!\u0001Z3\u0002\r5,Wn\u001c:z\u0015\t1\u0007(A\u0003beJ|w/\u0003\u0002iG\ni!k\\8u\u00032dwnY1u_J\f\u0011BY3g_J,\u0017\t\u001c7\u0002\u0011\u00054G/\u001a:BY2\f!BY3g_J,W)Y2i\u0003%\tg\r^3s\u000b\u0006\u001c\u0007.\u0001\ndY\u0016\f'/\u00117m\u000bb,7-\u001e;j_:\u001c\u0018\u0001\u00053fM\u0006,H\u000e^*fgNLwN\\%e+\u0005\u0001\bCA9w\u001b\u0005\u0011(BA:u\u0003\u0011a\u0017M\\4\u000b\u0003U\fAA[1wC&\u0011qO\u001d\u0002\u0007'R\u0014\u0018N\\4\u0002\u001b\u0011,g-Y;miV\u001bXM]%e\u0003\r!7\u000f\\\u000b\u0002wB\u0019A0a\b\u000f\u0007u\fIBD\u0002\u007f\u0003/q1a`A\u000b\u001d\u0011\t\t!a\u0005\u000f\t\u0005\r\u0011\u0011\u0003\b\u0005\u0003\u000b\tyA\u0004\u0003\u0002\b\u00055QBAA\u0005\u0015\r\tY\u0001P\u0001\u0007yI|w\u000e\u001e \n\u0003mJ!!\u000f\u001e\n\u0005]B\u0014BA\u001b7\u0013\t\u0019D'\u0003\u0002ze%!\u00111DA\u000f\u0003\u001d\u0001\u0018mY6bO\u0016T!!\u001f\u001a\n\t\u0005\u0005\u00121\u0005\u0002\u0012\u001b>\u001c7NU3n_R,7+Z:tS>t'\u0002BA\u000e\u0003;\t1\"^:fe\u000e{g\u000e^3yiV\u0011\u0011\u0011\u0006\t\u0005\u0003W\t\u0019$\u0004\u0002\u0002.)!\u0011qFA\u0019\u0003\u0015\u0001(o\u001c;p\u0015\t\u0019d'\u0003\u0003\u00026\u00055\"aC+tKJ\u001cuN\u001c;fqR\fqCY;jY\u0012,\u00050Z2vi\u0016\u0004F.\u00198SKF,Xm\u001d;\u0015\u0011\u0005m\u0012\u0011IA&\u0003;\u0002B!a\u000b\u0002>%!\u0011qHA\u0017\u0005I)\u00050Z2vi\u0016\u0004F.\u00198SKF,Xm\u001d;\t\u000f\u0005\rc\u00021\u0001\u0002F\u0005!\u0001\u000f\\1o!\u0011\tY#a\u0012\n\t\u0005%\u0013Q\u0006\u0002\u0005!2\fg\u000eC\u0005\u0002N9\u0001\n\u00111\u0001\u0002P\u0005I1/Z:tS>t\u0017\n\u001a\t\u0005\u0003#\nIF\u0004\u0003\u0002T\u0005U\u0003cAA\u0004\u0019&\u0019\u0011q\u000b'\u0002\rA\u0013X\rZ3g\u0013\r9\u00181\f\u0006\u0004\u0003/b\u0005\"CA0\u001dA\u0005\t\u0019AA(\u0003-y\u0007/\u001a:bi&|g.\u00133\u0002C\t,\u0018\u000e\u001c3Fq\u0016\u001cW\u000f^3QY\u0006t'+Z9vKN$H\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005\u0015$\u0006BA(\u0003OZ#!!\u001b\u0011\t\u0005-\u0014QO\u0007\u0003\u0003[RA!a\u001c\u0002r\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003gb\u0015AC1o]>$\u0018\r^5p]&!\u0011qOA7\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\"EVLG\u000eZ#yK\u000e,H/\u001a)mC:\u0014V-];fgR$C-\u001a4bk2$HeM\u0001\u001cEVLG\u000e\u001a*fCR$\u0018m\u00195Fq\u0016\u001cW\u000f^3SKF,Xm\u001d;\u0015\r\u0005}\u0014QQAD!\u0011\tY#!!\n\t\u0005\r\u0015Q\u0006\u0002\u0017%\u0016\fG\u000f^1dQ\u0016CXmY;uKJ+\u0017/^3ti\"9\u0011qL\tA\u0002\u0005=\u0003bBAE#\u0001\u0007\u00111R\u0001\u000be\u0016\u001c\bo\u001c8tK&#\u0007#B&\u0002\u000e\u0006=\u0013bAAH\u0019\n1q\n\u001d;j_:\f!DY;jY\u0012\u0014V\r\\3bg\u0016\u001cVm]:j_:\u0014V-];fgR$b!!&\u0002\u001c\u0006u\u0005\u0003BA\u0016\u0003/KA!!'\u0002.\t)\"+\u001a7fCN,7+Z:tS>t'+Z9vKN$\b\"CA'%A\u0005\t\u0019AA(\u0011%\tyJ\u0005I\u0001\u0002\u0004\t\t+\u0001\bbY2|wOU3d_:tWm\u0019;\u0011\u0007-\u000b\u0019+C\u0002\u0002&2\u0013qAQ8pY\u0016\fg.\u0001\u0013ck&dGMU3mK\u0006\u001cXmU3tg&|gNU3rk\u0016\u001cH\u000f\n3fM\u0006,H\u000e\u001e\u00132\u0003\u0011\u0012W/\u001b7e%\u0016dW-Y:f'\u0016\u001c8/[8o%\u0016\fX/Z:uI\u0011,g-Y;mi\u0012\u0012TCAAWU\u0011\t\t+a\u001a\u0002\u0013\t,\u0018\u000e\u001c3QY\u0006tG\u0003BA#\u0003gCq!!.\u0016\u0001\u0004\ty%A\u0003rk\u0016\u0014\u00180A\nck&dGmU9m\u0007>lW.\u00198e!2\fg\u000e\u0006\u0003\u0002F\u0005m\u0006bBA_-\u0001\u0007\u0011qJ\u0001\u000bgFd7i\\7nC:$\u0017A\u00052vS2$Gj\\2bYJ+G.\u0019;j_:,B!a1\u0002~R!\u0011Q\u0019B\b)\u0011\t)%a2\t\u0013\u0005%w#!AA\u0004\u0005-\u0017AC3wS\u0012,gnY3%cA1\u0011QZAw\u0003stA!a4\u0002h:!\u0011\u0011[Ar\u001d\u0011\t\u0019.!8\u000f\t\u0005U\u0017\u0011\u001c\b\u0005\u0003\u000f\t9.C\u0001N\u0013\r\tY\u000eT\u0001\be\u00164G.Z2u\u0013\u0011\ty.!9\u0002\u000fI,h\u000e^5nK*\u0019\u00111\u001c'\n\t\u0005m\u0011Q\u001d\u0006\u0005\u0003?\f\t/\u0003\u0003\u0002j\u0006-\u0018\u0001C;oSZ,'o]3\u000b\t\u0005m\u0011Q]\u0005\u0005\u0003_\f\tPA\u0004UsB,G+Y4\n\t\u0005M\u0018Q\u001f\u0002\t)f\u0004X\rV1hg*!\u0011q_Aq\u0003\r\t\u0007/\u001b\t\u0005\u0003w\fi\u0010\u0004\u0001\u0005\u000f\u0005}xC1\u0001\u0003\u0002\t\t\u0011)\u0005\u0003\u0003\u0004\t%\u0001cA&\u0003\u0006%\u0019!q\u0001'\u0003\u000f9{G\u000f[5oOB\u00191Ja\u0003\n\u0007\t5AJA\u0004Qe>$Wo\u0019;\t\u000f\tEq\u00031\u0001\u0003\u0014\u0005!A-\u0019;b!\u0019\u0011)B!\u0007\u0002z:!\u0011Q\u001bB\f\u0013\r\tY\u0002T\u0005\u0005\u00057\u0011iBA\u0002TKFT1!a\u0007M\u0003]9W\r\u001e*fCR$\u0018m\u00195bE2,\u0017\n^3sCR|'\u000f\u0006\u0003\u0003$\t=\u0002\u0003\u0002B\u0013\u0005Wi!Aa\n\u000b\u0007\t%\"'\u0001\u0004dY&,g\u000e^\u0005\u0005\u0005[\u00119CA\u0014Fq\u0016\u001cW\u000f^3QY\u0006t'+Z:q_:\u001cXMU3biR\f7\r[1cY\u0016LE/\u001a:bi>\u0014\bb\u0002B\u00191\u0001\u0007!1G\u0001\rgR,(-\u0013;fe\u0006$xN\u001d\t\u0007\u0005K\u0011)D!\u000f\n\t\t]\"q\u0005\u0002\u0012\u00072|7/Z1cY\u0016LE/\u001a:bi>\u0014\b\u0003BA\u0016\u0005wIAA!\u0010\u0002.\t\u0019R\t_3dkR,\u0007\u000b\\1o%\u0016\u001c\bo\u001c8tK\u0006\u0011\u0012m]:feRtu.Q2uSZ,'\u000b]2t\u0003q\t7o]3si\u00163XM\u001c;vC2d\u0017PT8BGRLg/\u001a*qGN\f\u0001$Y:tKJ$hj\\!di&4X-\u0012=fGV$\u0018n\u001c8t\u0003\t\n7o]3si\u00163XM\u001c;vC2d\u0017PT8BGRLg/Z#yK\u000e,H/[8og\u00069\u0012m]:feR,\u00050Z2vi&|gNU3mK\u0006\u001cX\r\u001a\u000b\u0004\u0015\n-\u0003bBA0;\u0001\u0007\u0011qJ\u0001\"CN\u001cXM\u001d;Fm\u0016tG/^1mYf,\u00050Z2vi&|gNU3mK\u0006\u001cX\r\u001a\u000b\u0004\u0015\nE\u0003bBA0=\u0001\u0007\u0011qJ\u0001\u0013O\u0016$X\t_3dkRLwN\u001c%pY\u0012,'/\u0006\u0002\u0003XA!!\u0011\fB0\u001b\t\u0011YFC\u0002\u0003^I\nqa]3sm&\u001cW-\u0003\u0003\u0003b\tm#!D#yK\u000e,H/\u001a%pY\u0012,'/\u0001\u000ffm\u0016tG/^1mYf<U\r^#yK\u000e,H/[8o\u0011>dG-\u001a:\u0002\u0015]LG\u000f[\"mS\u0016tG\u000f\u0006\u0004\u0003j\tm$Q\u0010\u000b\u0004\u0015\n-\u0004b\u0002B7C\u0001\u0007!qN\u0001\u0002MB11J!\u001d\u0003v)K1Aa\u001dM\u0005%1UO\\2uS>t\u0017\u0007\u0005\u0003\u0003&\t]\u0014\u0002\u0002B=\u0005O\u0011!c\u00159be.\u001cuN\u001c8fGR\u001cE.[3oi\"I\u0011QJ\u0011\u0011\u0002\u0003\u0007\u0011q\n\u0005\n\u0005\u007f\n\u0003\u0013!a\u0001\u0003\u001f\na!^:fe&#\u0017\u0001F<ji\"\u001cE.[3oi\u0012\"WMZ1vYR$\u0013'\u0001\u000bxSRD7\t\\5f]R$C-\u001a4bk2$HE\r\u000b\u0004\u0015\n\u001d\u0005b\u0002B7I\u0001\u0007!q\u000e\u000b\b\u0015\n-%Q\u0012BH\u0011\u001d\u0011i'\na\u0001\u0005_Bq!!\u0014&\u0001\u0004\ty\u0005C\u0004\u0003\u0000\u0015\u0002\r!a\u0014\u0002']LG\u000f\u001b*bo\ncwnY6j]\u001e\u001cF/\u001e2\u0015\u0007)\u0013)\nC\u0004\u0003n\u0019\u0002\rAa&\u0011\r-\u0013\tH!'K!\u0011\u0011YJa*\u000f\t\tu%1\u0015\b\u0005\u0005?\u0013\t+\u0004\u0002\u00022%!\u0011qFA\u0019\u0013\u0011\u0011)+!\f\u0002/M\u0003\u0018M]6D_:tWm\u0019;TKJ4\u0018nY3HeB\u001c\u0017\u0002\u0002BU\u0005W\u0013qd\u00159be.\u001cuN\u001c8fGR\u001cVM\u001d<jG\u0016\u0014En\\2lS:<7\u000b^;c\u0015\u0011\u0011)+!\f\u0002-]LG\u000f[\"vgR|WN\u00117pG.LgnZ*uk\n$BA!-\u0003>R\u0019!Ja-\t\u000f\t5t\u00051\u0001\u00036B11J!\u001d\u00038*\u0003BA!\n\u0003:&!!1\u0018B\u0014\u0005y\u0019Uo\u001d;p[N\u0003\u0018M]6D_:tWm\u0019;CY>\u001c7.\u001b8h'R,(\rC\u0005\u0003@\u001e\u0002\n\u00111\u0001\u0003B\u0006i!/\u001a;ssB{G.[2jKN\u0004bA!\u0006\u0003\u001a\t\r\u0007\u0003\u0002B\u0013\u0005\u000bLAAa2\u0003(\tY!+\u001a;ssB{G.[2z\u0003\u0001:\u0018\u000e\u001e5DkN$x.\u001c\"m_\u000e\\\u0017N\\4TiV\u0014G\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\t5'\u0006\u0002Ba\u0003O\n\u0001B];o#V,'/\u001f\u000b\b\u0015\nM'Q\u001bBm\u0011\u001d\t\u0019%\u000ba\u0001\u0003\u000bBaAa6*\u0001\u00049\u0016\u0001D9vKJLH+[7f_V$\bb\u0002BnS\u0001\u0007!Q\\\u0001\nSR,'o\u00157fKB\u00042a\u0013Bp\u0013\r\u0011\t\u000f\u0014\u0002\u0005\u0019>tw\rF\u0004K\u0005K\u00149O!;\t\u000f\u0005U&\u00061\u0001\u0002P!1!q\u001b\u0016A\u0002]C\u0011Ba7+!\u0003\u0005\rA!8\u0002%I,h.U;fef$C-\u001a4bk2$HeM\u000b\u0003\u0005_TCA!8\u0002h\u000592\r[3dWN\u000bHnQ8n[\u0006tGMU3ta>t7/\u001a\u000b\u0006\u0015\nU8q\u0001\u0005\b\u0005od\u0003\u0019\u0001B}\u0003\u0019\u0011Xm];miB!!1`B\u0001\u001d\u0011\tYC!@\n\t\t}\u0018QF\u0001\u0014\u000bb,7-\u001e;f!2\fgNU3ta>t7/Z\u0005\u0005\u0007\u0007\u0019)A\u0001\tTc2\u001cu.\\7b]\u0012\u0014Vm];mi*!!q`A\u0017\u0011\u001d\u0019I\u0001\fa\u0001\u0007\u0017\t\u0001\"\u001a=qK\u000e$X\r\u001a\t\u0007\u0005+\u0011Ib!\u0004\u0011\r\tU!\u0011DB\b!\rY5\u0011C\u0005\u0004\u0007'a%aA!os\u0006y1/\u001e9fe\u0012\u0012WMZ8sK\u0006cG.\u0003\u0002j\r\u0006q1/\u001e9fe\u0012\ng\r^3s\u00032d\u0017B\u00016G\u0003A\u0019X\u000f]3sI\t,gm\u001c:f\u000b\u0006\u001c\u0007.C\u0002l\u0007CI1aa\tE\u0005Y\u0019\u0006.\u0019:fIN\u0003\u0018M]6TKN\u001c\u0018n\u001c8CCN,\u0017aD:va\u0016\u0014H%\u00194uKJ,\u0015m\u00195\n\u00071\u001c\t\u0003")
public interface SparkConnectServerTest
extends SharedSparkSession {
    public void org$apache$spark$sql$connect$SparkConnectServerTest$_setter_$serverPort_$eq(int var1);

    public void org$apache$spark$sql$connect$SparkConnectServerTest$_setter_$eventuallyTimeout_$eq(Span var1);

    public void org$apache$spark$sql$connect$SparkConnectServerTest$_setter_$allocator_$eq(RootAllocator var1);

    public void org$apache$spark$sql$connect$SparkConnectServerTest$_setter_$defaultSessionId_$eq(String var1);

    public void org$apache$spark$sql$connect$SparkConnectServerTest$_setter_$defaultUserId_$eq(String var1);

    public void org$apache$spark$sql$connect$SparkConnectServerTest$_setter_$dsl_$eq(package.MockRemoteSession var1);

    public void org$apache$spark$sql$connect$SparkConnectServerTest$_setter_$userContext_$eq(UserContext var1);

    public /* synthetic */ void org$apache$spark$sql$connect$SparkConnectServerTest$$super$beforeAll();

    public /* synthetic */ void org$apache$spark$sql$connect$SparkConnectServerTest$$super$afterAll();

    public /* synthetic */ void org$apache$spark$sql$connect$SparkConnectServerTest$$super$beforeEach();

    public /* synthetic */ void org$apache$spark$sql$connect$SparkConnectServerTest$$super$afterEach();

    public int serverPort();

    public Span eventuallyTimeout();

    public RootAllocator allocator();

    public static /* synthetic */ void beforeAll$(SparkConnectServerTest $this) {
        $this.beforeAll();
    }

    default public void beforeAll() {
        this.org$apache$spark$sql$connect$SparkConnectServerTest$$super$beforeAll();
        SparkConnectService$.MODULE$.executionManager().shutdown();
        ((SparkFunSuite)this).withSparkEnvConfs((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)Connect$.MODULE$.CONNECT_GRPC_BINDING_PORT().key(), (Object)Integer.toString(this.serverPort()))}), (Function0)(JFunction0.mcV.sp & Serializable)() -> SparkConnectService$.MODULE$.start(this.spark().sparkContext()));
    }

    public static /* synthetic */ void afterAll$(SparkConnectServerTest $this) {
        $this.afterAll();
    }

    default public void afterAll() {
        SparkConnectService$.MODULE$.stop(SparkConnectService$.MODULE$.stop$default$1(), SparkConnectService$.MODULE$.stop$default$2());
        this.allocator().close();
        this.org$apache$spark$sql$connect$SparkConnectServerTest$$super$afterAll();
    }

    public static /* synthetic */ void beforeEach$(SparkConnectServerTest $this) {
        $this.beforeEach();
    }

    default public void beforeEach() {
        this.org$apache$spark$sql$connect$SparkConnectServerTest$$super$beforeEach();
        this.clearAllExecutions();
    }

    public static /* synthetic */ void afterEach$(SparkConnectServerTest $this) {
        $this.afterEach();
    }

    default public void afterEach() {
        this.clearAllExecutions();
        this.org$apache$spark$sql$connect$SparkConnectServerTest$$super$afterEach();
    }

    public static /* synthetic */ void clearAllExecutions$(SparkConnectServerTest $this) {
        $this.clearAllExecutions();
    }

    default public void clearAllExecutions() {
        SparkConnectService$.MODULE$.executionManager().listExecuteHolders().foreach((Function1 & Serializable)x$1 -> {
            x$1.close();
            return BoxedUnit.UNIT;
        });
        SparkConnectService$.MODULE$.executionManager().periodicMaintenance(0L);
        SparkConnectService$.MODULE$.sessionManager().invalidateAllSessions();
        this.assertNoActiveExecutions();
    }

    public String defaultSessionId();

    public String defaultUserId();

    public package.MockRemoteSession dsl();

    public UserContext userContext();

    public static /* synthetic */ ExecutePlanRequest buildExecutePlanRequest$(SparkConnectServerTest $this, Plan plan, String sessionId, String operationId) {
        return $this.buildExecutePlanRequest(plan, sessionId, operationId);
    }

    default public ExecutePlanRequest buildExecutePlanRequest(Plan plan, String sessionId, String operationId) {
        return ExecutePlanRequest.newBuilder().setUserContext(this.userContext()).setSessionId(sessionId).setOperationId(operationId).setPlan(plan).addRequestOptions(ExecutePlanRequest.RequestOption.newBuilder().setReattachOptions(ReattachOptions.newBuilder().setReattachable(true).build()).build()).build();
    }

    public static /* synthetic */ String buildExecutePlanRequest$default$2$(SparkConnectServerTest $this) {
        return $this.buildExecutePlanRequest$default$2();
    }

    default public String buildExecutePlanRequest$default$2() {
        return this.defaultSessionId();
    }

    public static /* synthetic */ String buildExecutePlanRequest$default$3$(SparkConnectServerTest $this) {
        return $this.buildExecutePlanRequest$default$3();
    }

    default public String buildExecutePlanRequest$default$3() {
        return UUID.randomUUID().toString();
    }

    public static /* synthetic */ ReattachExecuteRequest buildReattachExecuteRequest$(SparkConnectServerTest $this, String operationId, Option responseId) {
        return $this.buildReattachExecuteRequest(operationId, (Option<String>)responseId);
    }

    default public ReattachExecuteRequest buildReattachExecuteRequest(String operationId, Option<String> responseId) {
        ReattachExecuteRequest.Builder req = ReattachExecuteRequest.newBuilder().setUserContext(this.userContext()).setSessionId(this.defaultSessionId()).setOperationId(operationId);
        Object object = responseId.isDefined() ? req.setLastResponseId((String)responseId.get()) : BoxedUnit.UNIT;
        return req.build();
    }

    public static /* synthetic */ ReleaseSessionRequest buildReleaseSessionRequest$(SparkConnectServerTest $this, String sessionId, boolean allowReconnect) {
        return $this.buildReleaseSessionRequest(sessionId, allowReconnect);
    }

    default public ReleaseSessionRequest buildReleaseSessionRequest(String sessionId, boolean allowReconnect) {
        return ReleaseSessionRequest.newBuilder().setUserContext(this.userContext()).setSessionId(sessionId).setAllowReconnect(allowReconnect).build();
    }

    public static /* synthetic */ String buildReleaseSessionRequest$default$1$(SparkConnectServerTest $this) {
        return $this.buildReleaseSessionRequest$default$1();
    }

    default public String buildReleaseSessionRequest$default$1() {
        return this.defaultSessionId();
    }

    public static /* synthetic */ boolean buildReleaseSessionRequest$default$2$(SparkConnectServerTest $this) {
        return $this.buildReleaseSessionRequest$default$2();
    }

    default public boolean buildReleaseSessionRequest$default$2() {
        return false;
    }

    public static /* synthetic */ Plan buildPlan$(SparkConnectServerTest $this, String query) {
        return $this.buildPlan(query);
    }

    default public Plan buildPlan(String query) {
        return Plan.newBuilder().setRoot(package$plans$.MODULE$.DslMockRemoteSession(this.dsl()).sql(query)).build();
    }

    public static /* synthetic */ Plan buildSqlCommandPlan$(SparkConnectServerTest $this, String sqlCommand) {
        return $this.buildSqlCommandPlan(sqlCommand);
    }

    default public Plan buildSqlCommandPlan(String sqlCommand) {
        return Plan.newBuilder().setCommand(Command.newBuilder().setSqlCommand(SqlCommand.newBuilder().setSql(sqlCommand).build()).build()).build();
    }

    public static /* synthetic */ Plan buildLocalRelation$(SparkConnectServerTest $this, Seq data, TypeTags.TypeTag evidence$1) {
        return $this.buildLocalRelation(data, evidence$1);
    }

    default public <A extends Product> Plan buildLocalRelation(Seq<A> data, TypeTags.TypeTag<A> evidence$1) {
        AgnosticEncoder encoder = ScalaReflection$.MODULE$.encoderFor(evidence$1);
        ByteString arrowData = ArrowSerializer$.MODULE$.serialize(data.iterator(), encoder, (BufferAllocator)this.allocator(), TimeZone.getDefault().getID(), false);
        LocalRelation localRelation = LocalRelation.newBuilder().setData(arrowData).setSchema(encoder.schema().json()).build();
        Relation relation = Relation.newBuilder().setLocalRelation(localRelation).build();
        return Plan.newBuilder().setRoot(relation).build();
    }

    public static /* synthetic */ ExecutePlanResponseReattachableIterator getReattachableIterator$(SparkConnectServerTest $this, CloseableIterator stubIterator) {
        return $this.getReattachableIterator((CloseableIterator<ExecutePlanResponse>)stubIterator);
    }

    default public ExecutePlanResponseReattachableIterator getReattachableIterator(CloseableIterator<ExecutePlanResponse> stubIterator) {
        return ExecutePlanResponseReattachableIterator$.MODULE$.fromIterator(stubIterator);
    }

    public static /* synthetic */ void assertNoActiveRpcs$(SparkConnectServerTest $this) {
        $this.assertNoActiveRpcs();
    }

    default public void assertNoActiveRpcs() {
        Either either = SparkConnectService$.MODULE$.executionManager().listActiveExecutions();
        if (either instanceof Left) {
            return;
        }
        if (either instanceof Right) {
            Right right = (Right)either;
            Seq executions = (Seq)right.value();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(executions.forall((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)SparkConnectServerTest.$anonfun$assertNoActiveRpcs$1(x$2))), "executions.forall(((x$2: org.apache.spark.sql.connect.service.ExecuteInfo) => x$2.lastAttachedRpcTimeNs.isDefined))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)("Expected no RPCs, but got " + executions), Prettifier$.MODULE$.default(), new Position("SparkConnectServerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 192));
            return;
        }
        throw new MatchError((Object)either);
    }

    public static /* synthetic */ void assertEventuallyNoActiveRpcs$(SparkConnectServerTest $this) {
        $this.assertEventuallyNoActiveRpcs();
    }

    default public void assertEventuallyNoActiveRpcs() {
        Eventually$.MODULE$.eventually(this.timeout(this.eventuallyTimeout()), (Function0)(JFunction0.mcV.sp & Serializable)() -> this.assertNoActiveRpcs(), Eventually$.MODULE$.patienceConfig(), Retrying$.MODULE$.retryingNatureOfT(), new Position("SparkConnectServerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 199));
    }

    public static /* synthetic */ void assertNoActiveExecutions$(SparkConnectServerTest $this) {
        $this.assertNoActiveExecutions();
    }

    default public void assertNoActiveExecutions() {
        Either either = SparkConnectService$.MODULE$.executionManager().listActiveExecutions();
        if (either instanceof Left) {
            return;
        }
        if (either instanceof Right) {
            Right right = (Right)either;
            Seq executions = (Seq)right.value();
            throw ((Assertions)this).fail("Expected empty, but got " + executions, new Position("SparkConnectServerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 207));
        }
        throw new MatchError((Object)either);
    }

    public static /* synthetic */ void assertEventuallyNoActiveExecutions$(SparkConnectServerTest $this) {
        $this.assertEventuallyNoActiveExecutions();
    }

    default public void assertEventuallyNoActiveExecutions() {
        Eventually$.MODULE$.eventually(this.timeout(this.eventuallyTimeout()), (Function0)(JFunction0.mcV.sp & Serializable)() -> this.assertNoActiveExecutions(), Eventually$.MODULE$.patienceConfig(), Retrying$.MODULE$.retryingNatureOfT(), new Position("SparkConnectServerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 212));
    }

    public static /* synthetic */ void assertExecutionReleased$(SparkConnectServerTest $this, String operationId) {
        $this.assertExecutionReleased(operationId);
    }

    default public void assertExecutionReleased(String operationId) {
        Either either = SparkConnectService$.MODULE$.executionManager().listActiveExecutions();
        if (either instanceof Left) {
            return;
        }
        if (either instanceof Right) {
            Right right = (Right)either;
            Seq executions = (Seq)right.value();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(executions.exists((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)SparkConnectServerTest.$anonfun$assertExecutionReleased$1(operationId, x$3))), "executions.exists(((x$3: org.apache.spark.sql.connect.service.ExecuteInfo) => x$3.operationId.==(operationId)))", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectServerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 220));
            return;
        }
        throw new MatchError((Object)either);
    }

    public static /* synthetic */ void assertEventuallyExecutionReleased$(SparkConnectServerTest $this, String operationId) {
        $this.assertEventuallyExecutionReleased(operationId);
    }

    default public void assertEventuallyExecutionReleased(String operationId) {
        Eventually$.MODULE$.eventually(this.timeout(this.eventuallyTimeout()), (Function0)(JFunction0.mcV.sp & Serializable)() -> this.assertExecutionReleased(operationId), Eventually$.MODULE$.patienceConfig(), Retrying$.MODULE$.retryingNatureOfT(), new Position("SparkConnectServerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 225));
    }

    public static /* synthetic */ ExecuteHolder getExecutionHolder$(SparkConnectServerTest $this) {
        return $this.getExecutionHolder();
    }

    default public ExecuteHolder getExecutionHolder() {
        Seq executions;
        Seq $org_scalatest_assert_macro_left = executions = SparkConnectService$.MODULE$.executionManager().listExecuteHolders();
        int $org_scalatest_assert_macro_right = 1;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectServerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 233));
        return (ExecuteHolder)executions.head();
    }

    public static /* synthetic */ ExecuteHolder eventuallyGetExecutionHolder$(SparkConnectServerTest $this) {
        return $this.eventuallyGetExecutionHolder();
    }

    default public ExecuteHolder eventuallyGetExecutionHolder() {
        return (ExecuteHolder)Eventually$.MODULE$.eventually(this.timeout(this.eventuallyTimeout()), (Function0 & Serializable)() -> this.getExecutionHolder(), Eventually$.MODULE$.patienceConfig(), Retrying$.MODULE$.retryingNatureOfT(), new Position("SparkConnectServerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 238));
    }

    public static /* synthetic */ void withClient$(SparkConnectServerTest $this, String sessionId, String userId, Function1 f) {
        $this.withClient(sessionId, userId, (Function1<SparkConnectClient, BoxedUnit>)f);
    }

    default public void withClient(String sessionId, String userId, Function1<SparkConnectClient, BoxedUnit> f) {
        this.withClient(f, sessionId, userId);
    }

    public static /* synthetic */ void withClient$(SparkConnectServerTest $this, Function1 f) {
        $this.withClient((Function1<SparkConnectClient, BoxedUnit>)f);
    }

    default public void withClient(Function1<SparkConnectClient, BoxedUnit> f) {
        this.withClient(f, this.defaultSessionId(), this.defaultUserId());
    }

    public static /* synthetic */ void withClient$(SparkConnectServerTest $this, Function1 f, String sessionId, String userId) {
        $this.withClient((Function1<SparkConnectClient, BoxedUnit>)f, sessionId, userId);
    }

    default public void withClient(Function1<SparkConnectClient, BoxedUnit> f, String sessionId, String userId) {
        SparkConnectClient client = SparkConnectClient$.MODULE$.builder().port(this.serverPort()).sessionId(sessionId).userId(userId).enableReattachableExecute().build();
        try {
            f.apply((Object)client);
        }
        finally {
            client.shutdown();
        }
    }

    public static /* synthetic */ String withClient$default$1$(SparkConnectServerTest $this) {
        return $this.withClient$default$1();
    }

    default public String withClient$default$1() {
        return this.defaultSessionId();
    }

    public static /* synthetic */ String withClient$default$2$(SparkConnectServerTest $this) {
        return $this.withClient$default$2();
    }

    default public String withClient$default$2() {
        return this.defaultUserId();
    }

    public static /* synthetic */ void withRawBlockingStub$(SparkConnectServerTest $this, Function1 f) {
        $this.withRawBlockingStub((Function1<SparkConnectServiceGrpc.SparkConnectServiceBlockingStub, BoxedUnit>)f);
    }

    default public void withRawBlockingStub(Function1<SparkConnectServiceGrpc.SparkConnectServiceBlockingStub, BoxedUnit> f) {
        int x$1 = this.serverPort();
        String x$2 = SparkConnectClient.Configuration$.MODULE$.apply$default$1();
        String x$3 = SparkConnectClient.Configuration$.MODULE$.apply$default$2();
        String x$4 = SparkConnectClient.Configuration$.MODULE$.apply$default$3();
        Option x$5 = SparkConnectClient.Configuration$.MODULE$.apply$default$5();
        Option x$6 = SparkConnectClient.Configuration$.MODULE$.apply$default$6();
        Map x$7 = SparkConnectClient.Configuration$.MODULE$.apply$default$7();
        String x$8 = SparkConnectClient.Configuration$.MODULE$.apply$default$8();
        Seq x$9 = SparkConnectClient.Configuration$.MODULE$.apply$default$9();
        boolean x$10 = SparkConnectClient.Configuration$.MODULE$.apply$default$10();
        List x$11 = SparkConnectClient.Configuration$.MODULE$.apply$default$11();
        Option x$12 = SparkConnectClient.Configuration$.MODULE$.apply$default$12();
        int x$13 = SparkConnectClient.Configuration$.MODULE$.apply$default$13();
        int x$14 = SparkConnectClient.Configuration$.MODULE$.apply$default$14();
        SparkConnectClient.Configuration conf = new SparkConnectClient.Configuration(x$2, x$3, x$4, x$1, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14);
        ManagedChannel channel = conf.createChannel();
        SparkConnectServiceGrpc.SparkConnectServiceBlockingStub bstub = SparkConnectServiceGrpc.newBlockingStub((Channel)channel);
        try {
            f.apply((Object)bstub);
        }
        finally {
            channel.shutdownNow();
        }
    }

    public static /* synthetic */ void withCustomBlockingStub$(SparkConnectServerTest $this, Seq retryPolicies, Function1 f) {
        $this.withCustomBlockingStub((Seq<RetryPolicy>)retryPolicies, (Function1<CustomSparkConnectBlockingStub, BoxedUnit>)f);
    }

    default public void withCustomBlockingStub(Seq<RetryPolicy> retryPolicies, Function1<CustomSparkConnectBlockingStub, BoxedUnit> f) {
        int x$1 = this.serverPort();
        String x$2 = SparkConnectClient.Configuration$.MODULE$.apply$default$1();
        String x$3 = SparkConnectClient.Configuration$.MODULE$.apply$default$2();
        String x$4 = SparkConnectClient.Configuration$.MODULE$.apply$default$3();
        Option x$5 = SparkConnectClient.Configuration$.MODULE$.apply$default$5();
        Option x$6 = SparkConnectClient.Configuration$.MODULE$.apply$default$6();
        Map x$7 = SparkConnectClient.Configuration$.MODULE$.apply$default$7();
        String x$8 = SparkConnectClient.Configuration$.MODULE$.apply$default$8();
        Seq x$9 = SparkConnectClient.Configuration$.MODULE$.apply$default$9();
        boolean x$10 = SparkConnectClient.Configuration$.MODULE$.apply$default$10();
        List x$11 = SparkConnectClient.Configuration$.MODULE$.apply$default$11();
        Option x$12 = SparkConnectClient.Configuration$.MODULE$.apply$default$12();
        int x$13 = SparkConnectClient.Configuration$.MODULE$.apply$default$13();
        int x$14 = SparkConnectClient.Configuration$.MODULE$.apply$default$14();
        SparkConnectClient.Configuration conf = new SparkConnectClient.Configuration(x$2, x$3, x$4, x$1, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14);
        ManagedChannel channel = conf.createChannel();
        SparkConnectStubState stubState = new SparkConnectStubState(channel, retryPolicies);
        CustomSparkConnectBlockingStub bstub = new CustomSparkConnectBlockingStub(channel, stubState);
        try {
            f.apply((Object)bstub);
        }
        finally {
            channel.shutdownNow();
        }
    }

    public static /* synthetic */ Seq withCustomBlockingStub$default$1$(SparkConnectServerTest $this) {
        return $this.withCustomBlockingStub$default$1();
    }

    default public Seq<RetryPolicy> withCustomBlockingStub$default$1() {
        return RetryPolicy$.MODULE$.defaultPolicies();
    }

    public static /* synthetic */ void runQuery$(SparkConnectServerTest $this, Plan plan, Span queryTimeout, long iterSleep) {
        $this.runQuery(plan, queryTimeout, iterSleep);
    }

    default public void runQuery(Plan plan, Span queryTimeout, long iterSleep) {
        this.withClient((Function1<SparkConnectClient, BoxedUnit>)(Function1 & Serializable)client -> {
            TimeLimits$.MODULE$.failAfter(queryTimeout, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                CloseableIterator iter = client.execute(plan$1);
                None$ operationId = None$.MODULE$;
                ExecutePlanResponse r = null;
                ExecutePlanResponseReattachableIterator reattachableIter = $this.getReattachableIterator((CloseableIterator<ExecutePlanResponse>)iter);
                while (iter.hasNext()) {
                    r = (ExecutePlanResponse)iter.next();
                    None$ none$ = operationId;
                    if (None$.MODULE$.equals(none$)) {
                        operationId = new Some((Object)r.getOperationId());
                    } else if (none$ instanceof Some) {
                        Some some = (Some)none$;
                        String id = (String)some.value();
                        String $org_scalatest_assert_macro_left = r.getOperationId();
                        String $org_scalatest_assert_macro_right = id;
                        String string = $org_scalatest_assert_macro_left;
                        String string2 = $org_scalatest_assert_macro_right;
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
                        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectServerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 304));
                    } else {
                        throw new MatchError((Object)none$);
                    }
                    if (iterSleep$1 <= 0L) continue;
                    Thread.sleep(iterSleep$1);
                }
                ExecutePlanResponse $org_scalatest_assert_macro_left = r;
                Object $org_scalatest_assert_macro_right = null;
                ExecutePlanResponse executePlanResponse = $org_scalatest_assert_macro_left;
                Object var20_17 = null;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "!=", null, executePlanResponse == null ? var20_17 != null : !executePlanResponse.equals(var20_17), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectServerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 311));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(r.hasResultComplete(), "r.hasResultComplete()", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectServerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 312));
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(reattachableIter.resultComplete(), "reattachableIter.resultComplete", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectServerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 314));
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(operationId.isDefined(), "operationId.isDefined", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectServerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 316));
                $this.assertEventuallyExecutionReleased((String)operationId.get());
            }, Signaler$.MODULE$.default(), Prettifier$.MODULE$.default(), new Position("SparkConnectServerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 295), Timed$.MODULE$.timed());
            return BoxedUnit.UNIT;
        });
    }

    public static /* synthetic */ void runQuery$(SparkConnectServerTest $this, String query, Span queryTimeout, long iterSleep) {
        $this.runQuery(query, queryTimeout, iterSleep);
    }

    default public void runQuery(String query, Span queryTimeout, long iterSleep) {
        Plan plan = this.buildPlan(query);
        this.runQuery(plan, queryTimeout, iterSleep);
    }

    public static /* synthetic */ long runQuery$default$3$(SparkConnectServerTest $this) {
        return $this.runQuery$default$3();
    }

    default public long runQuery$default$3() {
        return 0L;
    }

    public static /* synthetic */ void checkSqlCommandResponse$(SparkConnectServerTest $this, ExecutePlanResponse.SqlCommandResult result, Seq expected) {
        $this.checkSqlCommandResponse(result, (Seq<Seq<Object>>)expected);
    }

    default public void checkSqlCommandResponse(ExecutePlanResponse.SqlCommandResult result, Seq<Seq<Object>> expected) {
        byte[] dataBytes = result.getRelation().getLocalRelation().getData().toByteArray();
        RootAllocator allocator = new RootAllocator(Long.MAX_VALUE);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(dataBytes);
        ArrowStreamReader reader = new ArrowStreamReader((InputStream)inputStream, (BufferAllocator)allocator);
        try {
            VectorSchemaRoot root = reader.getVectorSchemaRoot();
            reader.loadNextBatch();
            int rowCount = root.getRowCount();
            int colCount = root.getFieldVectors().size();
            int $org_scalatest_assert_macro_left = rowCount;
            int $org_scalatest_assert_macro_right = expected.length();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"Row count mismatch", Prettifier$.MODULE$.default(), new Position("SparkConnectServerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 347));
            int $org_scalatest_assert_macro_left2 = colCount;
            int $org_scalatest_assert_macro_right2 = ((SeqOps)expected.head()).length();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"Column count mismatch", Prettifier$.MODULE$.default(), new Position("SparkConnectServerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 348));
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), rowCount).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), colCount).foreach((Function1 & Serializable)j -> SparkConnectServerTest.$anonfun$checkSqlCommandResponse$2(root, i, expected, BoxesRunTime.unboxToInt((Object)j))));
        }
        finally {
            reader.close();
            allocator.close();
        }
    }

    public static /* synthetic */ boolean $anonfun$assertNoActiveRpcs$1(ExecuteInfo x$2) {
        return x$2.lastAttachedRpcTimeNs().isDefined();
    }

    public static /* synthetic */ boolean $anonfun$assertExecutionReleased$1(String operationId$1, ExecuteInfo x$3) {
        String string = x$3.operationId();
        String string2 = operationId$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static /* synthetic */ Assertion $anonfun$checkSqlCommandResponse$2(VectorSchemaRoot root$1, int i$1, Seq expected$1, int j) {
        FieldVector col = (FieldVector)root$1.getFieldVectors().get(j);
        Object value = col.getObject(i$1);
        Predef$.MODULE$.print(value);
        Object $org_scalatest_assert_macro_left = value;
        Object $org_scalatest_assert_macro_right = ((SeqOps)expected$1.apply(i$1)).apply(j);
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left, "==", $org_scalatest_assert_macro_right, BoxesRunTime.equals((Object)$org_scalatest_assert_macro_left, (Object)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)("Value mismatch at (" + i$1 + ", " + j + ")"), Prettifier$.MODULE$.default(), new Position("SparkConnectServerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 356));
    }

    public static void $init$(SparkConnectServerTest $this) {
        $this.org$apache$spark$sql$connect$SparkConnectServerTest$_setter_$serverPort_$eq(ConnectCommon$.MODULE$.CONNECT_GRPC_BINDING_PORT() + Random$.MODULE$.nextInt(1000));
        $this.org$apache$spark$sql$connect$SparkConnectServerTest$_setter_$eventuallyTimeout_$eq(SpanSugar$.MODULE$.convertIntToGrainOfTime(30).seconds());
        $this.org$apache$spark$sql$connect$SparkConnectServerTest$_setter_$allocator_$eq(new RootAllocator());
        $this.org$apache$spark$sql$connect$SparkConnectServerTest$_setter_$defaultSessionId_$eq(UUID.randomUUID().toString());
        $this.org$apache$spark$sql$connect$SparkConnectServerTest$_setter_$defaultUserId_$eq(UUID.randomUUID().toString());
        $this.org$apache$spark$sql$connect$SparkConnectServerTest$_setter_$dsl_$eq(new package.MockRemoteSession());
        $this.org$apache$spark$sql$connect$SparkConnectServerTest$_setter_$userContext_$eq(UserContext.newBuilder().setUserId($this.defaultUserId()).build());
    }
}

