/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connect.messages;

import com.google.protobuf.Any;
import com.google.protobuf.ByteString;
import com.google.protobuf.Message;
import java.io.Serializable;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.connect.proto.CommonInlineUserDefinedFunction;
import org.apache.spark.connect.proto.Expression;
import org.apache.spark.connect.proto.PythonUDF;
import org.apache.spark.connect.proto.UserContext;
import org.apache.spark.sql.connect.common.DataTypeProtoConverter$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005e1AAA\u0002\u0001!!)Q\u0003\u0001C\u0001-\tI2i\u001c8oK\u000e$\bK]8u_6+7o]1hKN\u001cV/\u001b;f\u0015\t!Q!\u0001\u0005nKN\u001c\u0018mZ3t\u0015\t1q!A\u0004d_:tWm\u0019;\u000b\u0005!I\u0011aA:rY*\u0011!bC\u0001\u0006gB\f'o\u001b\u0006\u0003\u00195\ta!\u00199bG\",'\"\u0001\b\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001\t\u0002C\u0001\n\u0014\u001b\u0005I\u0011B\u0001\u000b\n\u00055\u0019\u0006/\u0019:l\rVt7+^5uK\u00061A(\u001b8jiz\"\u0012a\u0006\t\u00031\u0001i\u0011a\u0001")
public class ConnectProtoMessagesSuite
extends SparkFunSuite {
    public ConnectProtoMessagesSuite() {
        this.test("UserContext can deal with extensions", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            UserContext.Builder builder = UserContext.newBuilder().setUserId("1").setUserName("Martin");
            Expression.Builder lit = Expression.newBuilder().setLiteral(Expression.Literal.newBuilder().setInteger(32).build());
            Any aval = Any.pack((Message)lit.build());
            builder.addExtensions(aval);
            byte[] serialized = builder.build().toByteArray();
            UserContext result = UserContext.parseFrom((byte[])serialized);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(result.getUserId().equals("1"), "result.getUserId().equals(\"1\")", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ConnectProtoMessagesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 44));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(result.getUserName().equals("Martin"), "result.getUserName().equals(\"Martin\")", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ConnectProtoMessagesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 45));
            int $org_scalatest_assert_macro_left = result.getExtensionsCount();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ConnectProtoMessagesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 46));
            Any ext = result.getExtensions(0);
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(ext.is(Expression.class), "ext.is[org.apache.spark.connect.proto.Expression](classOf[org.apache.spark.connect.proto.Expression])", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ConnectProtoMessagesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 49));
            Expression extLit = (Expression)ext.unpack(Expression.class);
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(extLit.hasLiteral(), "extLit.hasLiteral()", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("ConnectProtoMessagesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 51));
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.simpleMacroBool(extLit.getLiteral().hasInteger(), "extLit.getLiteral().hasInteger()", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("ConnectProtoMessagesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 52));
            int $org_scalatest_assert_macro_left2 = extLit.getLiteral().getInteger();
            int $org_scalatest_assert_macro_right2 = 32;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("ConnectProtoMessagesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 53));
        }, new Position("ConnectProtoMessagesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 27));
        this.test("CommonInlineUserDefinedFunction", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Expression arguments = Expression.newBuilder().setUnresolvedAttribute(Expression.UnresolvedAttribute.newBuilder().setUnparsedIdentifier("id")).build();
            PythonUDF pythonUdf = PythonUDF.newBuilder().setEvalType(100).setOutputType(DataTypeProtoConverter$.MODULE$.toConnectProtoType((DataType)IntegerType$.MODULE$)).setCommand(ByteString.copyFrom((byte[])"command".getBytes())).setPythonVer("3.10").build();
            Expression commonInlineUserDefinedFunctionExpr = Expression.newBuilder().setCommonInlineUserDefinedFunction(CommonInlineUserDefinedFunction.newBuilder().setFunctionName("f").setDeterministic(true).addArguments(arguments).setPythonUdf(pythonUdf)).build();
            CommonInlineUserDefinedFunction fun = commonInlineUserDefinedFunctionExpr.getCommonInlineUserDefinedFunction();
            String $org_scalatest_assert_macro_left = fun.getFunctionName();
            String $org_scalatest_assert_macro_right = "f";
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("ConnectProtoMessagesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 83));
            boolean $org_scalatest_assert_macro_left2 = fun.getDeterministic();
            boolean $org_scalatest_assert_macro_right2 = true;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("ConnectProtoMessagesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 84));
            int $org_scalatest_assert_macro_left3 = fun.getArgumentsCount();
            int $org_scalatest_assert_macro_right3 = 1;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 == $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("ConnectProtoMessagesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 85));
            boolean $org_scalatest_assert_macro_left4 = fun.hasPythonUdf();
            boolean $org_scalatest_assert_macro_right4 = true;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_left4), "==", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4 == $org_scalatest_assert_macro_right4, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("ConnectProtoMessagesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 86));
            String $org_scalatest_assert_macro_left5 = pythonUdf.getPythonVer();
            String $org_scalatest_assert_macro_right5 = "3.10";
            String string3 = $org_scalatest_assert_macro_left5;
            String string4 = $org_scalatest_assert_macro_right5;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", (Object)$org_scalatest_assert_macro_right5, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("ConnectProtoMessagesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 87));
        }, new Position("ConnectProtoMessagesSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 56));
    }
}

