/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connect.service;

import java.io.Serializable;
import java.util.UUID;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.classic.StreamingQuery;
import org.apache.spark.sql.classic.StreamingQueryManager;
import org.apache.spark.sql.connect.service.SessionHolder;
import org.apache.spark.sql.connect.service.SparkConnectStreamingQueryCache;
import org.apache.spark.util.Clock;
import org.apache.spark.util.ManualClock;
import org.mockito.ArgumentCaptor;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.concurrent.Eventually$;
import org.scalatest.concurrent.Futures$;
import org.scalatest.enablers.Retrying$;
import org.scalatest.time.Span$;
import org.scalatestplus.mockito.MockitoSugar;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u001d2Aa\u0001\u0003\u0001#!)a\u0004\u0001C\u0001?!)!\u0005\u0001C\u0005G\t!3\u000b]1sW\u000e{gN\\3diN#(/Z1nS:<\u0017+^3ss\u000e\u000b7\r[3Tk&$XM\u0003\u0002\u0006\r\u000591/\u001a:wS\u000e,'BA\u0004\t\u0003\u001d\u0019wN\u001c8fGRT!!\u0003\u0006\u0002\u0007M\fHN\u0003\u0002\f\u0019\u0005)1\u000f]1sW*\u0011QBD\u0001\u0007CB\f7\r[3\u000b\u0003=\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\n\u0017!\t\u0019B#D\u0001\u000b\u0013\t)\"BA\u0007Ta\u0006\u00148NR;o'VLG/\u001a\t\u0003/qi\u0011\u0001\u0007\u0006\u00033i\tq!\\8dW&$xN\u0003\u0002\u001c\u001d\u0005i1oY1mCR,7\u000f\u001e9mkNL!!\b\r\u0003\u00195{7m[5u_N+x-\u0019:\u0002\rqJg.\u001b;?)\u0005\u0001\u0003CA\u0011\u0001\u001b\u0005!\u0011\u0001F2sK\u0006$XmU3tg&|g.T1oC\u001e,'\u000fF\u0001%!\t\tS%\u0003\u0002'\t\ty2\u000b]1sW\u000e{gN\\3diN#(/Z1nS:<\u0017+^3ss\u000e\u000b7\r[3")
public class SparkConnectStreamingQueryCacheSuite
extends SparkFunSuite
implements MockitoSugar {
    public <T> T mock(ClassTag<T> classTag) {
        return (T)MockitoSugar.mock$((MockitoSugar)this, classTag);
    }

    public <T> T mock(Answer<?> defaultAnswer, ClassTag<T> classTag) {
        return (T)MockitoSugar.mock$((MockitoSugar)this, defaultAnswer, classTag);
    }

    public <T> T mock(MockSettings mockSettings, ClassTag<T> classTag) {
        return (T)MockitoSugar.mock$((MockitoSugar)this, (MockSettings)mockSettings, classTag);
    }

    public <T> T mock(String name, ClassTag<T> classTag) {
        return (T)MockitoSugar.mock$((MockitoSugar)this, (String)name, classTag);
    }

    public <T> ArgumentCaptor<T> capture(ClassTag<T> classTag) {
        return MockitoSugar.capture$((MockitoSugar)this, classTag);
    }

    public <T> T invokeCaptureOnArgumentCaptor(ArgumentCaptor<T> captor) {
        return (T)MockitoSugar.invokeCaptureOnArgumentCaptor$((MockitoSugar)this, captor);
    }

    private SparkConnectStreamingQueryCache createSessionManager() {
        return new SparkConnectStreamingQueryCache((Clock)new ManualClock(), (Duration)new package.DurationInt(package$.MODULE$.DurationInt(1)).minute(), (Duration)new package.DurationInt(package$.MODULE$.DurationInt(20)).milliseconds());
    }

    public SparkConnectStreamingQueryCacheSuite() {
        MockitoSugar.$init$((MockitoSugar)this);
        this.test("Session cache functionality with a streaming query", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            long expiresAtMs;
            String queryId = UUID.randomUUID().toString();
            String runId = UUID.randomUUID().toString();
            String tag = "test_tag";
            org.apache.spark.sql.classic.SparkSession mockSession = (org.apache.spark.sql.classic.SparkSession)this.mock(ClassTag$.MODULE$.apply(org.apache.spark.sql.classic.SparkSession.class));
            StreamingQuery mockQuery = (StreamingQuery)this.mock(ClassTag$.MODULE$.apply(StreamingQuery.class));
            StreamingQueryManager mockStreamingQueryManager = (StreamingQueryManager)this.mock(ClassTag$.MODULE$.apply(StreamingQueryManager.class));
            SessionHolder sessionHolder = new SessionHolder("test_user_1", "test_session_1", mockSession);
            SparkConnectStreamingQueryCache sessionMgr = this.createSessionManager();
            ManualClock clock = (ManualClock)sessionMgr.clock();
            Mockito.when((Object)mockQuery.id()).thenReturn((Object)UUID.fromString(queryId));
            Mockito.when((Object)mockQuery.runId()).thenReturn((Object)UUID.fromString(runId));
            Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)mockQuery.isActive())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
            Mockito.when((Object)mockSession.streams()).thenReturn((Object)mockStreamingQueryManager);
            Mockito.when((Object)mockStreamingQueryManager.get(queryId)).thenReturn((Object)mockQuery);
            sessionMgr.registerNewStreamingQuery(sessionHolder, (org.apache.spark.sql.streaming.StreamingQuery)mockQuery, (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{tag})), "");
            Option option = sessionMgr.getCachedValue(queryId, runId);
            if (option instanceof Some) {
                Seq taggedQueries;
                Some some = (Some)option;
                SparkConnectStreamingQueryCache.QueryCacheValue v = (SparkConnectStreamingQueryCache.QueryCacheValue)some.value();
                String $org_scalatest_assert_macro_left = v.sessionId();
                String $org_scalatest_assert_macro_right = sessionHolder.sessionId();
                String string = $org_scalatest_assert_macro_left;
                String string2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectStreamingQueryCacheSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 73));
                Option $org_scalatest_assert_macro_left2 = v.expiresAtMs();
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left2, "isEmpty", $org_scalatest_assert_macro_left2.isEmpty(), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"No expiry time should be set for active query", Prettifier$.MODULE$.default(), new Position("SparkConnectStreamingQueryCacheSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 74));
                Seq $org_scalatest_assert_macro_left3 = taggedQueries = sessionMgr.getTaggedQuery(tag, (SparkSession)mockSession);
                SparkConnectStreamingQueryCache.QueryCacheValue $org_scalatest_assert_macro_right2 = v;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left3.contains((Object)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectStreamingQueryCacheSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 77));
            } else if (None$.MODULE$.equals(option)) {
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"Query should be found", Prettifier$.MODULE$.default(), new Position("SparkConnectStreamingQueryCacheSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 79));
            } else {
                throw new MatchError((Object)option);
            }
            Option $org_scalatest_assert_macro_left = sessionMgr.getCachedQuery(queryId, runId, Predef$.MODULE$.Set().empty(), (SparkSession)this.mock(ClassTag$.MODULE$.apply(org.apache.spark.sql.classic.SparkSession.class)));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectStreamingQueryCacheSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 83));
            Option $org_scalatest_assert_macro_left4 = sessionMgr.getCachedQuery(queryId, runId, Predef$.MODULE$.Set().empty(), (SparkSession)mockSession).map((Function1 & Serializable)x$1 -> x$1.query());
            StreamingQuery $org_scalatest_assert_macro_right = mockQuery;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left4.contains((Object)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectStreamingQueryCacheSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 86));
            Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)mockQuery.isActive())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
            long expectedExpiryTimeMs = sessionMgr.clock().getTimeMillis() + new package.DurationInt(package$.MODULE$.DurationInt(1)).minute().toMillis();
            Eventually$.MODULE$.eventually(Futures$.MODULE$.timeout(Span$.MODULE$.convertDurationToSpan((Duration)new package.DurationInt(package$.MODULE$.DurationInt(1)).minute())), (Function0 & Serializable)() -> {
                Option expiresAtOpt;
                Option $org_scalatest_assert_macro_left = expiresAtOpt = sessionMgr.getCachedValue(queryId, runId).flatMap((Function1 & Serializable)x$2 -> x$2.expiresAtMs());
                long $org_scalatest_assert_macro_right = expectedExpiryTimeMs;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left.contains((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right)), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectStreamingQueryCacheSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 100));
            }, Eventually$.MODULE$.patienceConfig(), Retrying$.MODULE$.retryingNatureOfT(), new Position("SparkConnectStreamingQueryCacheSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 98));
            long prevExpiryTimeMs = BoxesRunTime.unboxToLong((Object)((SparkConnectStreamingQueryCache.QueryCacheValue)sessionMgr.getCachedValue(queryId, runId).get()).expiresAtMs().get());
            clock.advance(new package.DurationInt(package$.MODULE$.DurationInt(30)).seconds().toMillis());
            Option $org_scalatest_assert_macro_left5 = sessionMgr.getCachedQuery(queryId, runId, Predef$.MODULE$.Set().empty(), (SparkSession)mockSession).map((Function1 & Serializable)x$3 -> x$3.query());
            StreamingQuery $org_scalatest_assert_macro_right3 = mockQuery;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left5.contains((Object)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectStreamingQueryCacheSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 109));
            long $org_scalatest_assert_macro_left6 = expiresAtMs = BoxesRunTime.unboxToLong((Object)((SparkConnectStreamingQueryCache.QueryCacheValue)sessionMgr.getCachedValue(queryId, runId).get()).expiresAtMs().get());
            long $org_scalatest_assert_macro_right4 = prevExpiryTimeMs + new package.DurationInt(package$.MODULE$.DurationInt(30)).seconds().toMillis();
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left6), "==", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left6 == $org_scalatest_assert_macro_right4, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectStreamingQueryCacheSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 115));
            String restartedRunId = UUID.randomUUID().toString();
            StreamingQuery restartedQuery = (StreamingQuery)this.mock(ClassTag$.MODULE$.apply(StreamingQuery.class));
            Mockito.when((Object)restartedQuery.id()).thenReturn((Object)UUID.fromString(queryId));
            Mockito.when((Object)restartedQuery.runId()).thenReturn((Object)UUID.fromString(restartedRunId));
            Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)restartedQuery.isActive())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
            Mockito.when((Object)mockStreamingQueryManager.get(queryId)).thenReturn((Object)restartedQuery);
            sessionMgr.registerNewStreamingQuery(sessionHolder, (org.apache.spark.sql.streaming.StreamingQuery)restartedQuery, Predef$.MODULE$.Set().empty(), "");
            Option $org_scalatest_assert_macro_left7 = sessionMgr.getCachedValue(queryId, runId).map((Function1 & Serializable)x$4 -> x$4.query());
            StreamingQuery $org_scalatest_assert_macro_right5 = mockQuery;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "contains", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left7.contains((Object)$org_scalatest_assert_macro_right5), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectStreamingQueryCacheSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 129));
            Option $org_scalatest_assert_macro_left8 = sessionMgr.getCachedValue(queryId, restartedRunId).map((Function1 & Serializable)x$5 -> x$5.query());
            StreamingQuery $org_scalatest_assert_macro_right6 = restartedQuery;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "contains", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left8.contains((Object)$org_scalatest_assert_macro_right6), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectStreamingQueryCacheSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 130));
            Eventually$.MODULE$.eventually(Futures$.MODULE$.timeout(Span$.MODULE$.convertDurationToSpan((Duration)new package.DurationInt(package$.MODULE$.DurationInt(1)).minute())), (Function0 & Serializable)() -> {
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(sessionMgr.taggedQueries().containsKey(tag), "sessionMgr.taggedQueries.containsKey(tag)", Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectStreamingQueryCacheSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 133));
            }, Eventually$.MODULE$.patienceConfig(), Retrying$.MODULE$.retryingNatureOfT(), new Position("SparkConnectStreamingQueryCacheSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 132));
            clock.advance(new package.DurationInt(package$.MODULE$.DurationInt(1)).minute().toMillis());
            Eventually$.MODULE$.eventually(Futures$.MODULE$.timeout(Span$.MODULE$.convertDurationToSpan((Duration)new package.DurationInt(package$.MODULE$.DurationInt(1)).minute())), (Function0 & Serializable)() -> {
                Option $org_scalatest_assert_macro_left = sessionMgr.getCachedValue(queryId, runId);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectStreamingQueryCacheSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 139));
            }, Eventually$.MODULE$.patienceConfig(), Retrying$.MODULE$.retryingNatureOfT(), new Position("SparkConnectStreamingQueryCacheSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 138));
            Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)restartedQuery.isActive())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
            Eventually$.MODULE$.eventually(Futures$.MODULE$.timeout(Span$.MODULE$.convertDurationToSpan((Duration)new package.DurationInt(package$.MODULE$.DurationInt(1)).minute())), (Function0 & Serializable)() -> {
                Option $org_scalatest_assert_macro_left = sessionMgr.getCachedValue(queryId, restartedRunId).flatMap((Function1 & Serializable)x$6 -> x$6.expiresAtMs());
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "nonEmpty", $org_scalatest_assert_macro_left.nonEmpty(), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectStreamingQueryCacheSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 145));
            }, Eventually$.MODULE$.patienceConfig(), Retrying$.MODULE$.retryingNatureOfT(), new Position("SparkConnectStreamingQueryCacheSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 144));
            clock.advance(new package.DurationInt(package$.MODULE$.DurationInt(1)).minute().toMillis());
            Eventually$.MODULE$.eventually(Futures$.MODULE$.timeout(Span$.MODULE$.convertDurationToSpan((Duration)new package.DurationInt(package$.MODULE$.DurationInt(1)).minute())), (Function0 & Serializable)() -> {
                Option $org_scalatest_assert_macro_left = sessionMgr.getCachedValue(queryId, restartedRunId);
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left, "isEmpty", $org_scalatest_assert_macro_left.isEmpty(), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectStreamingQueryCacheSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 151));
                Seq $org_scalatest_assert_macro_left2 = sessionMgr.getTaggedQuery(tag, (SparkSession)mockSession);
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left2, "isEmpty", $org_scalatest_assert_macro_left2.isEmpty(), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectStreamingQueryCacheSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 152));
            }, Eventually$.MODULE$.patienceConfig(), Retrying$.MODULE$.retryingNatureOfT(), new Position("SparkConnectStreamingQueryCacheSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 150));
            Eventually$.MODULE$.eventually(Futures$.MODULE$.timeout(Span$.MODULE$.convertDurationToSpan((Duration)new package.DurationInt(package$.MODULE$.DurationInt(1)).minute())), (Function0 & Serializable)() -> {
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(sessionMgr.taggedQueries().containsKey(tag), "sessionMgr.taggedQueries.containsKey(tag)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectStreamingQueryCacheSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 155));
            }, Eventually$.MODULE$.patienceConfig(), Retrying$.MODULE$.retryingNatureOfT(), new Position("SparkConnectStreamingQueryCacheSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 154));
            sessionMgr.shutdown();
        }, new Position("SparkConnectStreamingQueryCacheSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 44));
    }
}

