/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connect.service;

import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.spark.SparkEnv$;
import org.apache.spark.SparkSQLException;
import org.apache.spark.connect.proto.ExecutePlanRequest;
import org.apache.spark.connect.proto.ExecutePlanResponse;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.sql.connect.config.Connect$;
import org.apache.spark.sql.connect.execution.ExecuteGrpcResponseSender;
import org.apache.spark.sql.connect.service.ExecuteHolder;
import org.apache.spark.sql.connect.service.ExecuteInfo;
import org.apache.spark.sql.connect.service.ExecuteKey;
import org.apache.spark.sql.connect.service.ExecuteKey$;
import org.apache.spark.sql.connect.service.SessionHolder;
import org.apache.spark.sql.connect.service.SessionKey;
import org.apache.spark.sql.connect.service.SparkConnectService$;
import org.apache.spark.util.ThreadUtils$;
import org.slf4j.Logger;
import org.sparkproject.connect.grpc.stub.StreamObserver;
import org.sparkproject.connect.guava.cache.Cache;
import org.sparkproject.connect.guava.cache.CacheBuilder;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\t\u0015a!\u0002\u0010 \u0001\u0005Z\u0003\"\u0002\u001d\u0001\t\u0003Q\u0004bB\u001f\u0001\u0005\u0004%IA\u0010\u0005\u0007\u001f\u0002\u0001\u000b\u0011B \t\u000fA\u0003!\u0019!C\u0005#\"1\u0011\r\u0001Q\u0001\nICqA\u0019\u0001A\u0002\u0013%1\rC\u0004k\u0001\u0001\u0007I\u0011B6\t\rE\u0004\u0001\u0015)\u0003e\u0011\u001d\u0011\b\u00011A\u0005\nMDqA\u001f\u0001A\u0002\u0013%1\u0010\u0003\u0004~\u0001\u0001\u0006K\u0001\u001e\u0005\u0007}\u0002!\t!I@\t\u000fy\u0004A\u0011A\u0011\u0002\"!A\u0011q\u0005\u0001\u0005\u0002\u0005\nI\u0003\u0003\u0006\u0002:\u0001\t\n\u0011\"\u0001\"\u0003wA\u0001\"!\u0015\u0001\t\u0003\t\u00131\u000b\u0005\t\u0003;\u0002A\u0011A\u0011\u0002`!A\u0011Q\u0011\u0001\u0005\u0002\u0005\n9\t\u0003\u0005\u0002,\u0002!\t!IAW\u0011!\t9\f\u0001C\u0001C\u0005e\u0006bBA`\u0001\u0011\u0005\u0011\u0011\u0019\u0005\b\u0003C\u0004A\u0011AAr\u0011!\t)\u000f\u0001C\u0001C\u0005\u001d\bbBAu\u0001\u0011%\u0011q\u001d\u0005\b\u0003W\u0004A\u0011BAt\u0011!\ti\u000f\u0001C\u0001C\u0005=\b\u0002CA{\u0001\u0011\u0005\u0011%a>\t\u0011\u0005u\b\u0001\"\u0001\"\u0003OD\u0001\"a@\u0001\t\u0003\t#\u0011\u0001\u0002\u001d'B\f'o[\"p]:,7\r^#yK\u000e,H/[8o\u001b\u0006t\u0017mZ3s\u0015\t\u0001\u0013%A\u0004tKJ4\u0018nY3\u000b\u0005\t\u001a\u0013aB2p]:,7\r\u001e\u0006\u0003I\u0015\n1a]9m\u0015\t1s%A\u0003ta\u0006\u00148N\u0003\u0002)S\u00051\u0011\r]1dQ\u0016T\u0011AK\u0001\u0004_J<7c\u0001\u0001-eA\u0011Q\u0006M\u0007\u0002])\tq&A\u0003tG\u0006d\u0017-\u0003\u00022]\t1\u0011I\\=SK\u001a\u0004\"a\r\u001c\u000e\u0003QR!!N\u0013\u0002\u0011%tG/\u001a:oC2L!a\u000e\u001b\u0003\u000f1{wmZ5oO\u00061A(\u001b8jiz\u001a\u0001\u0001F\u0001<!\ta\u0004!D\u0001 \u0003))\u00070Z2vi&|gn]\u000b\u0002\u007fA!\u0001iR%M\u001b\u0005\t%B\u0001\"D\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003\t\u0016\u000bA!\u001e;jY*\ta)\u0001\u0003kCZ\f\u0017B\u0001%B\u00055\u0019uN\\2veJ,g\u000e^'baB\u0011AHS\u0005\u0003\u0017~\u0011!\"\u0012=fGV$XmS3z!\taT*\u0003\u0002O?\tiQ\t_3dkR,\u0007j\u001c7eKJ\f1\"\u001a=fGV$\u0018n\u001c8tA\u0005\u0019\u0012MY1oI>tW\r\u001a+p[\n\u001cHo\u001c8fgV\t!\u000b\u0005\u0003T9&sV\"\u0001+\u000b\u0005U3\u0016!B2bG\",'BA,Y\u0003\u0019\u0019w.\\7p]*\u0011\u0011LW\u0001\u0007O>|w\r\\3\u000b\u0003m\u000b1aY8n\u0013\tiFKA\u0003DC\u000eDW\r\u0005\u0002=?&\u0011\u0001m\b\u0002\f\u000bb,7-\u001e;f\u0013:4w.\u0001\u000bbE\u0006tGm\u001c8fIR{WNY:u_:,7\u000fI\u0001\u0014Y\u0006\u001cH/\u0012=fGV$\u0018n\u001c8US6,gj]\u000b\u0002IB\u0011Q\r[\u0007\u0002M*\u0011q-Q\u0001\u0007CR|W.[2\n\u0005%4'AC!u_6L7\rT8oO\u00069B.Y:u\u000bb,7-\u001e;j_:$\u0016.\\3Og~#S-\u001d\u000b\u0003Y>\u0004\"!L7\n\u00059t#\u0001B+oSRDq\u0001]\u0004\u0002\u0002\u0003\u0007A-A\u0002yIE\nA\u0003\\1ti\u0016CXmY;uS>tG+[7f\u001dN\u0004\u0013!E:dQ\u0016$W\u000f\\3e\u000bb,7-\u001e;peV\tA\u000fE\u0002fk^L!A\u001e4\u0003\u001f\u0005#x.\\5d%\u00164WM]3oG\u0016\u0004\"\u0001\u0011=\n\u0005e\f%\u0001G*dQ\u0016$W\u000f\\3e\u000bb,7-\u001e;peN+'O^5dK\u0006)2o\u00195fIVdW\rZ#yK\u000e,Ho\u001c:`I\u0015\fHC\u00017}\u0011\u001d\u0001(\"!AA\u0002Q\f!c]2iK\u0012,H.\u001a3Fq\u0016\u001cW\u000f^8sA\u0005\u00192M]3bi\u0016,\u00050Z2vi\u0016Du\u000e\u001c3feR9A*!\u0001\u0002\u0006\u0005]\u0001BBA\u0002\u0019\u0001\u0007\u0011*\u0001\u0006fq\u0016\u001cW\u000f^3LKfDq!a\u0002\r\u0001\u0004\tI!A\u0004sKF,Xm\u001d;\u0011\t\u0005-\u00111C\u0007\u0003\u0003\u001bQA!a\u0004\u0002\u0012\u0005)\u0001O]8u_*\u0011!%J\u0005\u0005\u0003+\tiA\u0001\nFq\u0016\u001cW\u000f^3QY\u0006t'+Z9vKN$\bbBA\r\u0019\u0001\u0007\u00111D\u0001\u000eg\u0016\u001c8/[8o\u0011>dG-\u001a:\u0011\u0007q\ni\"C\u0002\u0002 }\u0011QbU3tg&|g\u000eS8mI\u0016\u0014Hc\u0001'\u0002$!9\u0011QE\u0007A\u0002\u0005%\u0011!\u0001<\u0002'I,Wn\u001c<f\u000bb,7-\u001e;f\u0011>dG-\u001a:\u0015\u000b1\fY#a\f\t\r\u00055b\u00021\u0001J\u0003\rYW-\u001f\u0005\n\u0003cq\u0001\u0013!a\u0001\u0003g\t\u0011\"\u00192b]\u0012|g.\u001a3\u0011\u00075\n)$C\u0002\u000289\u0012qAQ8pY\u0016\fg.A\u000fsK6|g/Z#yK\u000e,H/\u001a%pY\u0012,'\u000f\n3fM\u0006,H\u000e\u001e\u00133+\t\tiD\u000b\u0003\u00024\u0005}2FAA!!\u0011\t\u0019%!\u0014\u000e\u0005\u0005\u0015#\u0002BA$\u0003\u0013\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005-c&\u0001\u0006b]:|G/\u0019;j_:LA!a\u0014\u0002F\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002!\u001d,G/\u0012=fGV$X\rS8mI\u0016\u0014H\u0003BA+\u00037\u0002B!LA,\u0019&\u0019\u0011\u0011\f\u0018\u0003\r=\u0003H/[8o\u0011\u0019\ti\u0003\u0005a\u0001\u0013\u0006a2M]3bi\u0016,\u00050Z2vi\u0016Du\u000e\u001c3fe\u0006sG-\u0011;uC\u000eDG#\u0003'\u0002b\u0005\r\u0014QMA4\u0011\u0019\t\u0019!\u0005a\u0001\u0013\"9\u0011qA\tA\u0002\u0005%\u0001bBA\r#\u0001\u0007\u00111\u0004\u0005\b\u0003S\n\u0002\u0019AA6\u0003A\u0011Xm\u001d9p]N,wJY:feZ,'\u000f\u0005\u0004\u0002n\u0005m\u0014qP\u0007\u0003\u0003_RA!!\u001d\u0002t\u0005!1\u000f^;c\u0015\u0011\t)(a\u001e\u0002\t\u001d\u0014\bo\u0019\u0006\u0003\u0003s\n!![8\n\t\u0005u\u0014q\u000e\u0002\u000f'R\u0014X-Y7PEN,'O^3s!\u0011\tY!!!\n\t\u0005\r\u0015Q\u0002\u0002\u0014\u000bb,7-\u001e;f!2\fgNU3ta>t7/Z\u0001\u0016e\u0016\fG\u000f^1dQ\u0016CXmY;uK\"{G\u000eZ3s)\u001da\u0017\u0011RAG\u0003\u001fCa!a#\u0013\u0001\u0004a\u0015!D3yK\u000e,H/\u001a%pY\u0012,'\u000fC\u0004\u0002jI\u0001\r!a\u001b\t\u000f\u0005E%\u00031\u0001\u0002\u0014\u00061B.Y:u\u0007>t7/^7fIJ+7\u000f]8og\u0016LE\rE\u0003.\u0003/\n)\n\u0005\u0003\u0002\u0018\u0006\u0015f\u0002BAM\u0003C\u00032!a'/\u001b\t\tiJC\u0002\u0002 f\na\u0001\u0010:p_Rt\u0014bAAR]\u00051\u0001K]3eK\u001aLA!a*\u0002*\n11\u000b\u001e:j]\u001eT1!a)/\u0003u\u0011X-\\8wK\u0006cG.\u0012=fGV$\u0018n\u001c8t\r>\u00148+Z:tS>tGc\u00017\u00020\"9\u0011QF\nA\u0002\u0005E\u0006c\u0001\u001f\u00024&\u0019\u0011QW\u0010\u0003\u0015M+7o]5p].+\u00170A\u000bhKR\f%-\u00198e_:,G\rV8nEN$xN\\3\u0015\t\u0005m\u0016Q\u0018\t\u0005[\u0005]c\f\u0003\u0004\u0002.Q\u0001\r!S\u0001\u0015Y&\u001cH/Q2uSZ,W\t_3dkRLwN\\:\u0016\u0005\u0005\r\u0007\u0003CAc\u0003\u001f\f).a7\u000f\t\u0005\u001d\u00171\u001a\b\u0005\u00037\u000bI-C\u00010\u0013\r\tiML\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t\t.a5\u0003\r\u0015KG\u000f[3s\u0015\r\tiM\f\t\u0004[\u0005]\u0017bAAm]\t!Aj\u001c8h!\u0015\t)-!8_\u0013\u0011\ty.a5\u0003\u0007M+\u0017/A\fmSN$\u0018IY1oI>tW\rZ#yK\u000e,H/[8ogV\u0011\u00111\\\u0001\tg\",H\u000fZ8x]R\tA.A\fva\u0012\fG/\u001a'bgR,\u00050Z2vi&|g\u000eV5nK\u000612o\u00195fIVdW\rU3sS>$\u0017nY\"iK\u000e\\7/A\nqKJLw\u000eZ5d\u001b\u0006Lg\u000e^3oC:\u001cW\rF\u0002m\u0003cDq!a=\u001b\u0001\u0004\t).A\u0005uS6,w.\u001e;Og\u0006\u00112/\u001a;BY2\u0014\u0006kQ:EK\u0006$G.\u001b8f)\ra\u0017\u0011 \u0005\b\u0003w\\\u0002\u0019AAk\u0003)!W-\u00193mS:,gj]\u0001\u0011S:$XM\u001d:vaR\fE\u000e\u001c*Q\u0007N\f!\u0003\\5ti\u0016CXmY;uK\"{G\u000eZ3sgV\u0011!1\u0001\t\u0006\u0003\u000b\fi\u000e\u0014")
public class SparkConnectExecutionManager
implements Logging {
    private final ConcurrentMap<ExecuteKey, ExecuteHolder> executions;
    private final Cache<ExecuteKey, ExecuteInfo> abandonedTombstones;
    private AtomicLong lastExecutionTimeNs;
    private AtomicReference<ScheduledExecutorService> scheduledExecutor;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private ConcurrentMap<ExecuteKey, ExecuteHolder> executions() {
        return this.executions;
    }

    private Cache<ExecuteKey, ExecuteInfo> abandonedTombstones() {
        return this.abandonedTombstones;
    }

    private AtomicLong lastExecutionTimeNs() {
        return this.lastExecutionTimeNs;
    }

    private void lastExecutionTimeNs_$eq(AtomicLong x$1) {
        this.lastExecutionTimeNs = x$1;
    }

    private AtomicReference<ScheduledExecutorService> scheduledExecutor() {
        return this.scheduledExecutor;
    }

    private void scheduledExecutor_$eq(AtomicReference<ScheduledExecutorService> x$1) {
        this.scheduledExecutor = x$1;
    }

    public ExecuteHolder createExecuteHolder(ExecuteKey executeKey2, ExecutePlanRequest request, SessionHolder sessionHolder) {
        ExecuteHolder executeHolder = this.executions().compute(executeKey2, (executeKey, oldExecuteHolder) -> {
            if (oldExecuteHolder != null) {
                throw new SparkSQLException("INVALID_HANDLE.OPERATION_ALREADY_EXISTS", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"handle"), (Object)executeKey.operationId())})));
            }
            if (this.getAbandonedTombstone((ExecuteKey)executeKey).isDefined()) {
                throw new SparkSQLException("INVALID_HANDLE.OPERATION_ABANDONED", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"handle"), (Object)executeKey.operationId())})));
            }
            return new ExecuteHolder((ExecuteKey)executeKey, request, sessionHolder);
        });
        sessionHolder.addOperationId(executeHolder.operationId());
        this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"ExecuteHolder ", " is created."}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.EXECUTE_KEY$.MODULE$, (Object)executeHolder.key())}))));
        this.schedulePeriodicChecks();
        return executeHolder;
    }

    public ExecuteHolder createExecuteHolder(ExecutePlanRequest v) {
        Some some;
        boolean bl = v.hasClientObservedServerSideSessionId();
        if (bl) {
            some = new Some((Object)v.getClientObservedServerSideSessionId());
        } else if (!bl) {
            some = None$.MODULE$;
        } else {
            throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
        }
        Some previousSessionId = some;
        SessionHolder sessionHolder = SparkConnectService$.MODULE$.getOrCreateIsolatedSession(v.getUserContext().getUserId(), v.getSessionId(), (Option<String>)previousSessionId);
        ExecuteKey executeKey = ExecuteKey$.MODULE$.apply(v, sessionHolder);
        return this.createExecuteHolder(executeKey, v, sessionHolder);
    }

    public void removeExecuteHolder(ExecuteKey key, boolean abandoned) {
        ExecuteHolder executeHolder = (ExecuteHolder)this.executions().get(key);
        if (executeHolder == null) {
            return;
        }
        if (abandoned) {
            this.abandonedTombstones().put(key, executeHolder.getExecuteInfo());
        }
        this.executions().remove(key);
        executeHolder.sessionHolder().removeOperationId(executeHolder.operationId());
        this.updateLastExecutionTime();
        this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"ExecuteHolder ", " is removed."}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.EXECUTE_KEY$.MODULE$, (Object)key)}))));
        executeHolder.close();
        if (abandoned) {
            this.abandonedTombstones().put(key, executeHolder.getExecuteInfo());
            return;
        }
    }

    public boolean removeExecuteHolder$default$2() {
        return false;
    }

    public Option<ExecuteHolder> getExecuteHolder(ExecuteKey key) {
        return Option$.MODULE$.apply(this.executions().get(key));
    }

    public ExecuteHolder createExecuteHolderAndAttach(ExecuteKey executeKey, ExecutePlanRequest request, SessionHolder sessionHolder, StreamObserver<ExecutePlanResponse> responseObserver) {
        ExecuteHolder executeHolder = this.createExecuteHolder(executeKey, request, sessionHolder);
        try {
            executeHolder.eventsManager().postStarted();
            executeHolder.start();
        }
        catch (Throwable t2) {
            this.removeExecuteHolder(executeHolder.key(), this.removeExecuteHolder$default$2());
            throw t2;
        }
        try {
            ExecuteGrpcResponseSender<ExecutePlanResponse> responseSender = new ExecuteGrpcResponseSender<ExecutePlanResponse>(executeHolder, responseObserver);
            executeHolder.runGrpcResponseSender(responseSender);
        }
        finally {
            executeHolder.afterInitialRPC();
        }
        return executeHolder;
    }

    public void reattachExecuteHolder(ExecuteHolder executeHolder, StreamObserver<ExecutePlanResponse> responseObserver, Option<String> lastConsumedResponseId) {
        if (!executeHolder.reattachable()) {
            this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Reattach to not reattachable operation."}))).log((Seq)Nil$.MODULE$)));
            throw new SparkSQLException("INVALID_CURSOR.NOT_REATTACHABLE", Predef$.MODULE$.Map().empty());
        }
        if (executeHolder.isOrphan()) {
            this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Reattach to an orphan operation."}))).log((Seq)Nil$.MODULE$)));
            this.removeExecuteHolder(executeHolder.key(), this.removeExecuteHolder$default$2());
            throw new IllegalStateException("Operation was orphaned because of an internal error.");
        }
        ExecuteGrpcResponseSender<ExecutePlanResponse> responseSender = new ExecuteGrpcResponseSender<ExecutePlanResponse>(executeHolder, responseObserver);
        Option<String> option = lastConsumedResponseId;
        if (option instanceof Some) {
            Some some = (Some)option;
            String lastResponseId = (String)some.value();
            executeHolder.runGrpcResponseSender(responseSender, lastResponseId);
            return;
        }
        if (None$.MODULE$.equals(option)) {
            executeHolder.runGrpcResponseSender(responseSender);
            return;
        }
        throw new MatchError(option);
    }

    public void removeAllExecutionsForSession(SessionKey key) {
        this.executions().forEach((x$1, executeHolder) -> {
            SessionKey sessionKey = executeHolder.sessionHolder().key();
            SessionKey sessionKey2 = key;
            if (!(sessionKey != null ? !((Object)sessionKey).equals(sessionKey2) : sessionKey2 != null)) {
                ExecuteInfo info = executeHolder.getExecuteInfo();
                this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Execution ", " removed in removeSessionExecutions."}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.EXECUTE_INFO$.MODULE$, (Object)info)}))));
                this.removeExecuteHolder(executeHolder.key(), true);
                return;
            }
        });
    }

    public Option<ExecuteInfo> getAbandonedTombstone(ExecuteKey key) {
        return Option$.MODULE$.apply((Object)this.abandonedTombstones().getIfPresent(key));
    }

    public Either<Object, Seq<ExecuteInfo>> listActiveExecutions() {
        if (this.executions().isEmpty()) {
            return new Left((Object)BoxesRunTime.boxToLong((long)this.lastExecutionTimeNs().getAcquire()));
        }
        return new Right((Object)((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(this.executions().values()).asScala().map((Function1 & Serializable)x$2 -> x$2.getExecuteInfo())).toBuffer().toSeq());
    }

    public Seq<ExecuteInfo> listAbandonedExecutions() {
        return CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(this.abandonedTombstones().asMap()).asScala().values().toSeq();
    }

    public void shutdown() {
        ScheduledExecutorService executor = this.scheduledExecutor().getAndSet(null);
        if (executor != null) {
            ThreadUtils$.MODULE$.shutdown((ExecutorService)executor, (Duration)FiniteDuration$.MODULE$.apply(1L, TimeUnit.MINUTES));
        }
        this.executions().clear();
        this.abandonedTombstones().invalidateAll();
        this.updateLastExecutionTime();
    }

    private void updateLastExecutionTime() {
        this.lastExecutionTimeNs().getAndUpdate(prev -> RichLong$.MODULE$.max$extension(Predef$.MODULE$.longWrapper(prev), System.nanoTime()));
    }

    private void schedulePeriodicChecks() {
        ScheduledExecutorService executor = this.scheduledExecutor().getAcquire();
        if (executor == null) {
            executor = Executors.newSingleThreadScheduledExecutor();
            if (this.scheduledExecutor().compareAndExchangeRelease(null, executor) == null) {
                long interval = BoxesRunTime.unboxToLong((Object)SparkEnv$.MODULE$.get().conf().get(Connect$.MODULE$.CONNECT_EXECUTE_MANAGER_MAINTENANCE_INTERVAL()));
                this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Starting thread for cleanup of abandoned executions every "}))).log((Seq)Nil$.MODULE$).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", " ms"}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.INTERVAL$.MODULE$, (Object)BoxesRunTime.boxToLong((long)interval))})))));
                executor.scheduleAtFixedRate(() -> {
                    try {
                        long timeoutNs = BoxesRunTime.unboxToLong((Object)SparkEnv$.MODULE$.get().conf().get(Connect$.MODULE$.CONNECT_EXECUTE_MANAGER_DETACHED_TIMEOUT())) * 1000000L;
                        this.periodicMaintenance(timeoutNs);
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2;
                        Throwable throwable3 = throwable;
                        if (throwable3 != null && NonFatal$.MODULE$.apply(throwable2 = throwable3)) {
                            this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Unexpected exception in periodic task", throwable2);
                        }
                        throw throwable;
                    }
                }, interval, interval, TimeUnit.MILLISECONDS);
                return;
            }
            return;
        }
    }

    public void periodicMaintenance(long timeoutNs) {
        this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Started periodic run of SparkConnectExecutionManager maintenance.");
        long nowNs = System.nanoTime();
        this.executions().forEach((x$3, executeHolder) -> {
            Option<Object> option = executeHolder.lastAttachedRpcTimeNs();
            if (option instanceof Some) {
                Some some = (Some)option;
                long detachedNs = BoxesRunTime.unboxToLong((Object)some.value());
                if (detachedNs + timeoutNs <= nowNs) {
                    ExecuteInfo info = executeHolder.getExecuteInfo();
                    this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Found execution ", " that was abandoned "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)LogKeys.EXECUTE_INFO$.MODULE$, (Object)info)})).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"and expired and will be removed."}))).log((Seq)Nil$.MODULE$))));
                    this.removeExecuteHolder(executeHolder.key(), true);
                    return;
                }
                return;
            }
        });
        this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Finished periodic run of SparkConnectExecutionManager maintenance.");
    }

    public void setAllRPCsDeadline(long deadlineNs) {
        CollectionConverters$.MODULE$.CollectionHasAsScala(this.executions().values()).asScala().foreach((Function1 & Serializable)x$4 -> {
            x$4.setGrpcResponseSendersDeadline(deadlineNs);
            return BoxedUnit.UNIT;
        });
    }

    public void interruptAllRPCs() {
        CollectionConverters$.MODULE$.CollectionHasAsScala(this.executions().values()).asScala().foreach((Function1 & Serializable)x$5 -> {
            x$5.interruptGrpcResponseSenders();
            return BoxedUnit.UNIT;
        });
    }

    public Seq<ExecuteHolder> listExecuteHolders() {
        return CollectionConverters$.MODULE$.CollectionHasAsScala(this.executions().values()).asScala().toSeq();
    }

    public SparkConnectExecutionManager() {
        Logging.$init$((Logging)this);
        this.executions = new ConcurrentHashMap<ExecuteKey, ExecuteHolder>();
        this.abandonedTombstones = CacheBuilder.newBuilder().maximumSize(BoxesRunTime.unboxToInt((Object)SparkEnv$.MODULE$.get().conf().get(Connect$.MODULE$.CONNECT_EXECUTE_MANAGER_ABANDONED_TOMBSTONES_SIZE()))).build();
        this.lastExecutionTimeNs = new AtomicLong(System.nanoTime());
        this.scheduledExecutor = new AtomicReference();
    }
}

