/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connect.pipelines;

import io.grpc.stub.StreamObserver;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.List;
import org.apache.spark.connect.proto.ExecutePlanResponse;
import org.apache.spark.sql.classic.RuntimeConfig;
import org.apache.spark.sql.classic.SparkSession;
import org.apache.spark.sql.connect.pipelines.PipelineEventSender;
import org.apache.spark.sql.connect.pipelines.SparkDeclarativePipelinesServerTest;
import org.apache.spark.sql.connect.service.SessionHolder;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.pipelines.common.FlowStatus;
import org.apache.spark.sql.pipelines.common.RunState;
import org.apache.spark.sql.pipelines.logging.EventDetails;
import org.apache.spark.sql.pipelines.logging.EventLevel;
import org.apache.spark.sql.pipelines.logging.FlowProgress;
import org.apache.spark.sql.pipelines.logging.PipelineEvent;
import org.apache.spark.sql.pipelines.logging.PipelineEventOrigin;
import org.apache.spark.sql.pipelines.logging.RunProgress;
import org.mockito.ArgumentCaptor;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import org.scalatestplus.mockito.MockitoSugar;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005y4A!\u0003\u0006\u0001/!)A\u0005\u0001C\u0001K!)q\u0005\u0001C\u0005Q!91\u000bAI\u0001\n\u0013!\u0006\"B0\u0001\t\u0013\u0001\u0007b\u0002<\u0001#\u0003%I\u0001\u0016\u0005\bo\u0002\t\n\u0011\"\u0003U\u0011\u001dA\b!%A\u0005\neDqa\u001f\u0001\u0012\u0002\u0013%AP\u0001\rQSB,G.\u001b8f\u000bZ,g\u000e^*f]\u0012,'oU;ji\u0016T!a\u0003\u0007\u0002\u0013AL\u0007/\u001a7j]\u0016\u001c(BA\u0007\u000f\u0003\u001d\u0019wN\u001c8fGRT!a\u0004\t\u0002\u0007M\fHN\u0003\u0002\u0012%\u0005)1\u000f]1sW*\u00111\u0003F\u0001\u0007CB\f7\r[3\u000b\u0003U\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\r\u001d!\tI\"$D\u0001\u000b\u0013\tY\"BA\u0012Ta\u0006\u00148\u000eR3dY\u0006\u0014\u0018\r^5wKBK\u0007/\u001a7j]\u0016\u001c8+\u001a:wKJ$Vm\u001d;\u0011\u0005u\u0011S\"\u0001\u0010\u000b\u0005}\u0001\u0013aB7pG.LGo\u001c\u0006\u0003CQ\tQb]2bY\u0006$Xm\u001d;qYV\u001c\u0018BA\u0012\u001f\u00051iunY6ji>\u001cVoZ1s\u0003\u0019a\u0014N\\5u}Q\ta\u0005\u0005\u0002\u001a\u0001\u0005y1M]3bi\u0016lunY6TKR,\b\u000f\u0006\u0002*\rB!!&L\u0018A\u001b\u0005Y#\"\u0001\u0017\u0002\u000bM\u001c\u0017\r\\1\n\u00059Z#A\u0002+va2,'\u0007E\u00021oej\u0011!\r\u0006\u0003eM\nAa\u001d;vE*\u0011A'N\u0001\u0005OJ\u00048MC\u00017\u0003\tIw.\u0003\u00029c\tq1\u000b\u001e:fC6|%m]3sm\u0016\u0014\bC\u0001\u001e?\u001b\u0005Y$B\u0001\u001f>\u0003\u0015\u0001(o\u001c;p\u0015\ti\u0001#\u0003\u0002@w\t\u0019R\t_3dkR,\u0007\u000b\\1o%\u0016\u001c\bo\u001c8tKB\u0011\u0011\tR\u0007\u0002\u0005*\u00111\tD\u0001\bg\u0016\u0014h/[2f\u0013\t)%IA\u0007TKN\u001c\u0018n\u001c8I_2$WM\u001d\u0005\b\u000f\n\u0001\n\u00111\u0001I\u0003%\tX/Z;f'&TX\r\u0005\u0002J!:\u0011!J\u0014\t\u0003\u0017.j\u0011\u0001\u0014\u0006\u0003\u001bZ\ta\u0001\u0010:p_Rt\u0014BA(,\u0003\u0019\u0001&/\u001a3fM&\u0011\u0011K\u0015\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005=[\u0013!G2sK\u0006$X-T8dWN+G/\u001e9%I\u00164\u0017-\u001e7uIE*\u0012!\u0016\u0016\u0003\u0011Z[\u0013a\u0016\t\u00031vk\u0011!\u0017\u0006\u00035n\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0005q[\u0013AC1o]>$\u0018\r^5p]&\u0011a,\u0017\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017aD2sK\u0006$X\rV3ti\u00163XM\u001c;\u0015\u000b\u0005D'\u000e\\9\u0011\u0005\t4W\"A2\u000b\u0005\u0011,\u0017a\u00027pO\u001eLgn\u001a\u0006\u0003\u00179I!aZ2\u0003\u001bAK\u0007/\u001a7j]\u0016,e/\u001a8u\u0011\u001dIG\u0001%AA\u0002!\u000b!!\u001b3\t\u000f-$\u0001\u0013!a\u0001\u0011\u00069Q.Z:tC\u001e,\u0007bB7\u0005!\u0003\u0005\rA\\\u0001\u0006Y\u00164X\r\u001c\t\u0003E>L!\u0001]2\u0003\u0015\u00153XM\u001c;MKZ,G\u000eC\u0004s\tA\u0005\t\u0019A:\u0002\u000f\u0011,G/Y5mgB\u0011!\r^\u0005\u0003k\u000e\u0014A\"\u0012<f]R$U\r^1jYN\f\u0011d\u0019:fCR,G+Z:u\u000bZ,g\u000e\u001e\u0013eK\u001a\fW\u000f\u001c;%c\u0005I2M]3bi\u0016$Vm\u001d;Fm\u0016tG\u000f\n3fM\u0006,H\u000e\u001e\u00133\u0003e\u0019'/Z1uKR+7\u000f^#wK:$H\u0005Z3gCVdG\u000fJ\u001a\u0016\u0003iT#A\u001c,\u00023\r\u0014X-\u0019;f)\u0016\u001cH/\u0012<f]R$C-\u001a4bk2$H\u0005N\u000b\u0002{*\u00121O\u0016")
public class PipelineEventSenderSuite
extends SparkDeclarativePipelinesServerTest
implements MockitoSugar {
    public <T> T mock(ClassTag<T> classTag) {
        return (T)MockitoSugar.mock$((MockitoSugar)this, classTag);
    }

    public <T> T mock(Answer<?> defaultAnswer, ClassTag<T> classTag) {
        return (T)MockitoSugar.mock$((MockitoSugar)this, defaultAnswer, classTag);
    }

    public <T> T mock(MockSettings mockSettings, ClassTag<T> classTag) {
        return (T)MockitoSugar.mock$((MockitoSugar)this, (MockSettings)mockSettings, classTag);
    }

    public <T> T mock(String name, ClassTag<T> classTag) {
        return (T)MockitoSugar.mock$((MockitoSugar)this, (String)name, classTag);
    }

    public <T> ArgumentCaptor<T> capture(ClassTag<T> classTag) {
        return MockitoSugar.capture$((MockitoSugar)this, classTag);
    }

    public <T> T invokeCaptureOnArgumentCaptor(ArgumentCaptor<T> captor) {
        return (T)MockitoSugar.invokeCaptureOnArgumentCaptor$((MockitoSugar)this, captor);
    }

    private Tuple2<StreamObserver<ExecutePlanResponse>, SessionHolder> createMockSetup(String queueSize) {
        StreamObserver mockObserver = (StreamObserver)this.mock(ClassTag$.MODULE$.apply(StreamObserver.class));
        SessionHolder mockSessionHolder = (SessionHolder)this.mock(ClassTag$.MODULE$.apply(SessionHolder.class));
        Mockito.when((Object)mockSessionHolder.sessionId()).thenReturn((Object)"test-session-id");
        Mockito.when((Object)mockSessionHolder.serverSessionId()).thenReturn((Object)"test-server-session-id");
        SparkSession mockSession = (SparkSession)this.mock(ClassTag$.MODULE$.apply(SparkSession.class));
        RuntimeConfig mockConf = (RuntimeConfig)this.mock(ClassTag$.MODULE$.apply(RuntimeConfig.class));
        Mockito.when((Object)mockSessionHolder.session()).thenReturn((Object)mockSession);
        Mockito.when((Object)mockSession.conf()).thenReturn((Object)mockConf);
        Mockito.when((Object)mockConf.get(SQLConf$.MODULE$.PIPELINES_EVENT_QUEUE_CAPACITY().key())).thenReturn((Object)queueSize);
        return new Tuple2((Object)mockObserver, (Object)mockSessionHolder);
    }

    private String createMockSetup$default$1() {
        return "1000";
    }

    private PipelineEvent createTestEvent(String id, String message, EventLevel level, EventDetails details) {
        Some x$1 = new Some((Object)"test-flow");
        None$ x$2 = None$.MODULE$;
        None$ x$3 = None$.MODULE$;
        return new PipelineEvent(id, new Timestamp(System.currentTimeMillis()), new PipelineEventOrigin((Option)x$2, (Option)x$1, (Option)x$3), level, message, details, (Option)None$.MODULE$);
    }

    private String createTestEvent$default$1() {
        return "test-event-id";
    }

    private String createTestEvent$default$2() {
        return "Test message";
    }

    private EventLevel createTestEvent$default$3() {
        return EventLevel.INFO$.MODULE$;
    }

    private EventDetails createTestEvent$default$4() {
        return new FlowProgress((FlowStatus)FlowStatus.RUNNING$.MODULE$);
    }

    public PipelineEventSenderSuite() {
        MockitoSugar.$init$((MockitoSugar)this);
        this.test("PipelineEventSender sends events", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            Assertion assertion;
            Tuple2<StreamObserver<ExecutePlanResponse>, SessionHolder> tuple2 = this.createMockSetup(this.createMockSetup$default$1());
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            StreamObserver mockObserver = (StreamObserver)tuple2._1();
            SessionHolder mockSessionHolder = (SessionHolder)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)mockObserver, (Object)mockSessionHolder);
            StreamObserver mockObserver2 = (StreamObserver)tuple22._1();
            SessionHolder mockSessionHolder2 = (SessionHolder)tuple22._2();
            PipelineEventSender eventSender = new PipelineEventSender(mockObserver2, mockSessionHolder2);
            try {
                PipelineEvent testEvent = this.createTestEvent(this.createTestEvent$default$1(), this.createTestEvent$default$2(), this.createTestEvent$default$3(), this.createTestEvent$default$4());
                eventSender.sendEvent(testEvent);
                ArgumentCaptor responseCaptor = ArgumentCaptor.forClass(ExecutePlanResponse.class);
                ((StreamObserver)Mockito.verify((Object)mockObserver2, (VerificationMode)Mockito.timeout((long)1000L))).onNext(responseCaptor.capture());
                ExecutePlanResponse response = (ExecutePlanResponse)responseCaptor.getValue();
                String $org_scalatest_assert_macro_left = response.getSessionId();
                String $org_scalatest_assert_macro_right = "test-session-id";
                String string = $org_scalatest_assert_macro_left;
                String string2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PipelineEventSenderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 84));
                String $org_scalatest_assert_macro_left2 = response.getServerSideSessionId();
                String $org_scalatest_assert_macro_right2 = "test-server-session-id";
                String string3 = $org_scalatest_assert_macro_left2;
                String string4 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("PipelineEventSenderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 85));
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(response.hasPipelineEventResult(), "response.hasPipelineEventResult()", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("PipelineEventSenderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 86));
                org.apache.spark.connect.proto.PipelineEvent pipelineEvent = response.getPipelineEventResult().getEvent();
                String $org_scalatest_assert_macro_left3 = pipelineEvent.getMessage();
                String $org_scalatest_assert_macro_right3 = "Test message";
                String string5 = $org_scalatest_assert_macro_left3;
                String string6 = $org_scalatest_assert_macro_right3;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(string5 != null ? !string5.equals(string6) : string6 != null), Prettifier$.MODULE$.default());
                assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("PipelineEventSenderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 89));
            }
            finally {
                eventSender.shutdown();
            }
            return assertion;
        }, new Position("PipelineEventSenderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 70));
        this.test("PipelineEventSender graceful shutdown waits for previously queued events to process", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            List responses;
            Tuple2<StreamObserver<ExecutePlanResponse>, SessionHolder> tuple2 = this.createMockSetup(this.createMockSetup$default$1());
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            StreamObserver mockObserver = (StreamObserver)tuple2._1();
            SessionHolder mockSessionHolder = (SessionHolder)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)mockObserver, (Object)mockSessionHolder);
            StreamObserver mockObserver2 = (StreamObserver)tuple22._1();
            SessionHolder mockSessionHolder2 = (SessionHolder)tuple22._2();
            PipelineEventSender eventSender = new PipelineEventSender(mockObserver2, mockSessionHolder2);
            Seq events = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2})).map((Function1 & Serializable)i -> this.createTestEvent("event-" + BoxesRunTime.unboxToInt((Object)i), "Event " + BoxesRunTime.unboxToInt((Object)i) + " before shutdown", (EventLevel)EventLevel.INFO$.MODULE$, (EventDetails)new FlowProgress((FlowStatus)FlowStatus.RUNNING$.MODULE$)));
            events.foreach((Function1 & Serializable)event -> {
                eventSender.sendEvent(event);
                return BoxedUnit.UNIT;
            });
            eventSender.shutdown();
            ArgumentCaptor responseCaptor = ArgumentCaptor.forClass(ExecutePlanResponse.class);
            ((StreamObserver)Mockito.verify((Object)mockObserver2, (VerificationMode)Mockito.times((int)2))).onNext(responseCaptor.capture());
            List $org_scalatest_assert_macro_left = responses = responseCaptor.getAllValues();
            int $org_scalatest_assert_macro_right = 2;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PipelineEventSenderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 117));
            String $org_scalatest_assert_macro_left2 = ((ExecutePlanResponse)responses.get(0)).getPipelineEventResult().getEvent().getMessage();
            String $org_scalatest_assert_macro_right2 = "Event 1 before shutdown";
            String string = $org_scalatest_assert_macro_left2;
            String string2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("PipelineEventSenderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 118));
            String $org_scalatest_assert_macro_left3 = ((ExecutePlanResponse)responses.get(1)).getPipelineEventResult().getEvent().getMessage();
            String $org_scalatest_assert_macro_right3 = "Event 2 before shutdown";
            String string3 = $org_scalatest_assert_macro_left3;
            String string4 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("PipelineEventSenderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 120));
        }, new Position("PipelineEventSenderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 95));
        this.test("PipelineEventSender throws exception on send after shutdown", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            Tuple2<StreamObserver<ExecutePlanResponse>, SessionHolder> tuple2 = this.createMockSetup(this.createMockSetup$default$1());
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            StreamObserver mockObserver = (StreamObserver)tuple2._1();
            SessionHolder mockSessionHolder = (SessionHolder)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)mockObserver, (Object)mockSessionHolder);
            StreamObserver mockObserver2 = (StreamObserver)tuple22._1();
            SessionHolder mockSessionHolder2 = (SessionHolder)tuple22._2();
            PipelineEventSender eventSender = new PipelineEventSender(mockObserver2, mockSessionHolder2);
            eventSender.shutdown();
            return (IllegalStateException)this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> eventSender.sendEvent(this.createTestEvent(this.createTestEvent$default$1(), this.createTestEvent$default$2(), this.createTestEvent$default$3(), this.createTestEvent$default$4())), ClassTag$.MODULE$.apply(IllegalStateException.class), new Position("PipelineEventSenderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 129));
        }, new Position("PipelineEventSenderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 124));
        this.test("PipelineEventSender drops events after reaching capacity", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            Assertion assertion;
            Tuple2<StreamObserver<ExecutePlanResponse>, SessionHolder> tuple2 = this.createMockSetup("1");
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            StreamObserver mockObserver = (StreamObserver)tuple2._1();
            SessionHolder mockSessionHolder = (SessionHolder)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)mockObserver, (Object)mockSessionHolder);
            StreamObserver mockObserver2 = (StreamObserver)tuple22._1();
            SessionHolder mockSessionHolder2 = (SessionHolder)tuple22._2();
            PipelineEventSender eventSender = new PipelineEventSender(null, mockObserver2, mockSessionHolder2){

                public void sendEventToClient(PipelineEvent event) {
                    Thread.sleep(2000L);
                    super.sendEventToClient(event);
                }
            };
            try {
                List responses;
                String x$1 = "startedEvent";
                String x$2 = "Flow a started";
                FlowProgress x$3 = new FlowProgress((FlowStatus)FlowStatus.STARTING$.MODULE$);
                EventLevel x$4 = this.createTestEvent$default$3();
                PipelineEvent startedEvent = this.createTestEvent("startedEvent", "Flow a started", x$4, (EventDetails)x$3);
                eventSender.sendEvent(startedEvent);
                String x$5 = "firstRunningEvent";
                String x$6 = "Flow a running";
                FlowProgress x$7 = new FlowProgress((FlowStatus)FlowStatus.RUNNING$.MODULE$);
                EventLevel x$8 = this.createTestEvent$default$3();
                PipelineEvent firstRunningEvent = this.createTestEvent("firstRunningEvent", "Flow a running", x$8, (EventDetails)x$7);
                eventSender.sendEvent(firstRunningEvent);
                String x$9 = "secondRunningEvent";
                String x$10 = "Flow a running";
                FlowProgress x$11 = new FlowProgress((FlowStatus)FlowStatus.RUNNING$.MODULE$);
                EventLevel x$12 = this.createTestEvent$default$3();
                PipelineEvent secondRunningEvent = this.createTestEvent("secondRunningEvent", "Flow a running", x$12, (EventDetails)x$11);
                eventSender.sendEvent(secondRunningEvent);
                String x$13 = "runProgressRunning";
                String x$14 = "Update completed";
                RunProgress x$15 = new RunProgress((RunState)RunState.RUNNING$.MODULE$);
                EventLevel x$16 = this.createTestEvent$default$3();
                PipelineEvent runProgressRunningEvent = this.createTestEvent("runProgressRunning", "Update completed", x$16, (EventDetails)x$15);
                eventSender.sendEvent(runProgressRunningEvent);
                String x$17 = "thirdRunningEvent";
                String x$18 = "Flow a running";
                FlowProgress x$19 = new FlowProgress((FlowStatus)FlowStatus.RUNNING$.MODULE$);
                EventLevel x$20 = this.createTestEvent$default$3();
                PipelineEvent thirdRunningEvent = this.createTestEvent("thirdRunningEvent", "Flow a running", x$20, (EventDetails)x$19);
                eventSender.sendEvent(thirdRunningEvent);
                String x$21 = "completed";
                String x$22 = "Flow has completed";
                FlowProgress x$23 = new FlowProgress((FlowStatus)FlowStatus.COMPLETED$.MODULE$);
                EventLevel x$24 = this.createTestEvent$default$3();
                PipelineEvent completedEvent = this.createTestEvent("completed", "Flow has completed", x$24, (EventDetails)x$23);
                eventSender.sendEvent(completedEvent);
                String x$25 = "runProgressCompletedEvent";
                String x$26 = "Update completed";
                RunProgress x$27 = new RunProgress((RunState)RunState.COMPLETED$.MODULE$);
                EventLevel x$28 = this.createTestEvent$default$3();
                PipelineEvent runProgressCompletedEvent = this.createTestEvent("runProgressCompletedEvent", "Update completed", x$28, (EventDetails)x$27);
                eventSender.sendEvent(runProgressCompletedEvent);
                eventSender.shutdown();
                ArgumentCaptor responseCaptor = ArgumentCaptor.forClass(ExecutePlanResponse.class);
                ((StreamObserver)Mockito.verify((Object)mockObserver2, (VerificationMode)Mockito.times((int)5))).onNext(responseCaptor.capture());
                List $org_scalatest_assert_macro_left = responses = responseCaptor.getAllValues();
                int $org_scalatest_assert_macro_right = 5;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PipelineEventSenderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 204));
                String $org_scalatest_assert_macro_left2 = ((ExecutePlanResponse)responses.get(0)).getPipelineEventResult().getEvent().getMessage();
                String $org_scalatest_assert_macro_right2 = startedEvent.message();
                String string = $org_scalatest_assert_macro_left2;
                String string2 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("PipelineEventSenderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 207));
                String $org_scalatest_assert_macro_left3 = ((ExecutePlanResponse)responses.get(1)).getPipelineEventResult().getEvent().getMessage();
                String $org_scalatest_assert_macro_right3 = firstRunningEvent.message();
                String string3 = $org_scalatest_assert_macro_left3;
                String string4 = $org_scalatest_assert_macro_right3;
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("PipelineEventSenderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 210));
                String $org_scalatest_assert_macro_left4 = ((ExecutePlanResponse)responses.get(2)).getPipelineEventResult().getEvent().getMessage();
                String $org_scalatest_assert_macro_right4 = runProgressRunningEvent.message();
                String string5 = $org_scalatest_assert_macro_left4;
                String string6 = $org_scalatest_assert_macro_right4;
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(string5 != null ? !string5.equals(string6) : string6 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("PipelineEventSenderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 215));
                String $org_scalatest_assert_macro_left5 = ((ExecutePlanResponse)responses.get(3)).getPipelineEventResult().getEvent().getMessage();
                String $org_scalatest_assert_macro_right5 = completedEvent.message();
                String string7 = $org_scalatest_assert_macro_left5;
                String string8 = $org_scalatest_assert_macro_right5;
                Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", (Object)$org_scalatest_assert_macro_right5, !(string7 != null ? !string7.equals(string8) : string8 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("PipelineEventSenderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 220));
                String $org_scalatest_assert_macro_left6 = ((ExecutePlanResponse)responses.get(4)).getPipelineEventResult().getEvent().getMessage();
                String $org_scalatest_assert_macro_right6 = runProgressCompletedEvent.message();
                String string9 = $org_scalatest_assert_macro_left6;
                String string10 = $org_scalatest_assert_macro_right6;
                Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "==", (Object)$org_scalatest_assert_macro_right6, !(string9 != null ? !string9.equals(string10) : string10 != null), Prettifier$.MODULE$.default());
                assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("PipelineEventSenderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 224));
            }
            finally {
                eventSender.shutdown();
            }
            return assertion;
        }, new Position("PipelineEventSenderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 134));
    }
}

