/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connect.pipelines;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.SparkThrowable;
import org.apache.spark.api.python.PythonUtils$;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.TableIdentifier$;
import org.apache.spark.sql.connect.pipelines.SparkDeclarativePipelinesServerTest;
import org.apache.spark.sql.connect.service.SessionHolder;
import org.apache.spark.sql.connect.service.SparkConnectService$;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.connector.expressions.NamedReference;
import org.apache.spark.sql.pipelines.common.FlowStatus;
import org.apache.spark.sql.pipelines.common.RunState;
import org.apache.spark.sql.pipelines.graph.DataflowGraph;
import org.apache.spark.sql.pipelines.graph.GraphRegistrationContext;
import org.apache.spark.sql.pipelines.graph.PipelineUpdateContextImpl;
import org.apache.spark.sql.pipelines.graph.PipelineUpdateContextImpl$;
import org.apache.spark.sql.pipelines.graph.ResolvedFlow;
import org.apache.spark.sql.pipelines.logging.EventLevel;
import org.apache.spark.sql.pipelines.logging.PipelineEvent;
import org.apache.spark.sql.pipelines.utils.EventVerificationTestHelpers;
import org.apache.spark.sql.pipelines.utils.PipelineRunEventBuffer;
import org.apache.spark.sql.pipelines.utils.TestPipelineUpdateContextMixin;
import org.apache.spark.sql.pipelines.utils.TestPipelineUpdateContextMixin$TestPipelineUpdateContext$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Set;
import scala.collection.SetOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.sys.package$;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005i3A!\u0002\u0004\u0001'!)!\u0005\u0001C\u0001G!)Q\u0005\u0001C\u0001M!)A\b\u0001C\u0001{!)a\t\u0001C\u0005\u000f\n\u0019\u0002+\u001f;i_:\u0004\u0016\u000e]3mS:,7+^5uK*\u0011q\u0001C\u0001\na&\u0004X\r\\5oKNT!!\u0003\u0006\u0002\u000f\r|gN\\3di*\u00111\u0002D\u0001\u0004gFd'BA\u0007\u000f\u0003\u0015\u0019\b/\u0019:l\u0015\ty\u0001#\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002#\u0005\u0019qN]4\u0004\u0001M!\u0001\u0001\u0006\r !\t)b#D\u0001\u0007\u0013\t9bAA\u0012Ta\u0006\u00148\u000eR3dY\u0006\u0014\u0018\r^5wKBK\u0007/\u001a7j]\u0016\u001c8+\u001a:wKJ$Vm\u001d;\u0011\u0005eiR\"\u0001\u000e\u000b\u0005ma\u0012!B;uS2\u001c(BA\u0004\u000b\u0013\tq\"D\u0001\u0010UKN$\b+\u001b9fY&tW-\u00169eCR,7i\u001c8uKb$X*\u001b=j]B\u0011\u0011\u0004I\u0005\u0003Ci\u0011A$\u0012<f]R4VM]5gS\u000e\fG/[8o)\u0016\u001cH\u000fS3ma\u0016\u00148/\u0001\u0004=S:LGO\u0010\u000b\u0002IA\u0011Q\u0003A\u0001\u000bEVLG\u000eZ$sCBDGCA\u0014.!\tA3&D\u0001*\u0015\tQC$A\u0003he\u0006\u0004\b.\u0003\u0002-S\tiA)\u0019;bM2|wo\u0012:ba\"DQA\f\u0002A\u0002=\n!\u0002]=uQ>tG+\u001a=u!\t\u0001\u0014H\u0004\u00022oA\u0011!'N\u0007\u0002g)\u0011AGE\u0001\u0007yI|w\u000e\u001e \u000b\u0003Y\nQa]2bY\u0006L!\u0001O\u001b\u0002\rA\u0013X\rZ3g\u0013\tQ4H\u0001\u0004TiJLgn\u001a\u0006\u0003qU\nqb\u001a:ba\"LE-\u001a8uS\u001aLWM\u001d\u000b\u0003}\u0011\u0003\"a\u0010\"\u000e\u0003\u0001S!!\u0011\u0006\u0002\u0011\r\fG/\u00197zgRL!a\u0011!\u0003\u001fQ\u000b'\r\\3JI\u0016tG/\u001b4jKJDQ!R\u0002A\u0002=\nAA\\1nK\u0006\tR\r_3dkR,\u0007+\u001f;i_:\u001cu\u000eZ3\u0015\u0005!C\u0006\u0003B%K\u0019>k\u0011!N\u0005\u0003\u0017V\u0012a\u0001V;qY\u0016\u0014\u0004CA%N\u0013\tqUGA\u0002J]R\u00042\u0001U+0\u001d\t\t6K\u0004\u00023%&\ta'\u0003\u0002Uk\u00059\u0001/Y2lC\u001e,\u0017B\u0001,X\u0005\r\u0019V-\u001d\u0006\u0003)VBQ!\u0017\u0003A\u0002=\n!\u0002]=uQ>t7i\u001c3f\u0001")
public class PythonPipelineSuite
extends SparkDeclarativePipelinesServerTest
implements TestPipelineUpdateContextMixin,
EventVerificationTestHelpers {
    private volatile TestPipelineUpdateContextMixin$TestPipelineUpdateContext$ TestPipelineUpdateContext$module;

    public void assertFlowProgressEvent(PipelineRunEventBuffer eventBuffer, TableIdentifier identifier, FlowStatus expectedFlowStatus, EventLevel expectedEventLevel, Function1<Throwable, Object> errorChecker, Function1<String, Object> msgChecker, Function1<PipelineEvent, Object> cond, Option<Object> expectedNumOfEvents) {
        EventVerificationTestHelpers.assertFlowProgressEvent$((EventVerificationTestHelpers)this, (PipelineRunEventBuffer)eventBuffer, (TableIdentifier)identifier, (FlowStatus)expectedFlowStatus, (EventLevel)expectedEventLevel, errorChecker, msgChecker, cond, expectedNumOfEvents);
    }

    public Function1<Throwable, Object> assertFlowProgressEvent$default$5() {
        return EventVerificationTestHelpers.assertFlowProgressEvent$default$5$((EventVerificationTestHelpers)this);
    }

    public Function1<String, Object> assertFlowProgressEvent$default$6() {
        return EventVerificationTestHelpers.assertFlowProgressEvent$default$6$((EventVerificationTestHelpers)this);
    }

    public Function1<PipelineEvent, Object> assertFlowProgressEvent$default$7() {
        return EventVerificationTestHelpers.assertFlowProgressEvent$default$7$((EventVerificationTestHelpers)this);
    }

    public Option<Object> assertFlowProgressEvent$default$8() {
        return EventVerificationTestHelpers.assertFlowProgressEvent$default$8$((EventVerificationTestHelpers)this);
    }

    public void assertFlowProgressStatusInOrder(PipelineRunEventBuffer eventBuffer, TableIdentifier identifier, Seq<Tuple2<EventLevel, FlowStatus>> expectedFlowProgressStatus) {
        EventVerificationTestHelpers.assertFlowProgressStatusInOrder$((EventVerificationTestHelpers)this, (PipelineRunEventBuffer)eventBuffer, (TableIdentifier)identifier, expectedFlowProgressStatus);
    }

    public void assertNoFlowProgressEvent(PipelineRunEventBuffer eventBuffer, TableIdentifier identifier, FlowStatus flowStatus) {
        EventVerificationTestHelpers.assertNoFlowProgressEvent$((EventVerificationTestHelpers)this, (PipelineRunEventBuffer)eventBuffer, (TableIdentifier)identifier, (FlowStatus)flowStatus);
    }

    public Map<String, FlowStatus> latestFlowStatuses(PipelineRunEventBuffer eventBuffer) {
        return EventVerificationTestHelpers.latestFlowStatuses$((EventVerificationTestHelpers)this, (PipelineRunEventBuffer)eventBuffer);
    }

    public void assertPlanningEvent(PipelineRunEventBuffer eventBuffer, TableIdentifier identifier) {
        EventVerificationTestHelpers.assertPlanningEvent$((EventVerificationTestHelpers)this, (PipelineRunEventBuffer)eventBuffer, (TableIdentifier)identifier);
    }

    public void assertRunProgressEvent(PipelineRunEventBuffer eventBuffer, RunState state, EventLevel expectedEventLevel, Function1<Option<Throwable>, Object> errorChecker, Function1<String, Object> msgChecker) {
        EventVerificationTestHelpers.assertRunProgressEvent$((EventVerificationTestHelpers)this, (PipelineRunEventBuffer)eventBuffer, (RunState)state, (EventLevel)expectedEventLevel, errorChecker, msgChecker);
    }

    public Function1<Option<Throwable>, Object> assertRunProgressEvent$default$4() {
        return EventVerificationTestHelpers.assertRunProgressEvent$default$4$((EventVerificationTestHelpers)this);
    }

    public Function1<String, Object> assertRunProgressEvent$default$5() {
        return EventVerificationTestHelpers.assertRunProgressEvent$default$5$((EventVerificationTestHelpers)this);
    }

    public TestPipelineUpdateContextMixin$TestPipelineUpdateContext$ TestPipelineUpdateContext() {
        if (this.TestPipelineUpdateContext$module == null) {
            this.TestPipelineUpdateContext$lzycompute$1();
        }
        return this.TestPipelineUpdateContext$module;
    }

    public DataflowGraph buildGraph(String pythonText) {
        Seq dataflowGraphContexts;
        String indentedPythonText = StringOps$.MODULE$.linesIterator$extension(Predef$.MODULE$.augmentString(pythonText)).map((Function1 & Serializable)x$1 -> "    " + x$1).mkString("\n");
        String customSessionIdentifier = UUID.randomUUID().toString();
        String pythonCode = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n         |from pyspark.sql import SparkSession\n         |from pyspark import pipelines as dp\n         |from pyspark.pipelines.spark_connect_graph_element_registry import (\n         |    SparkConnectGraphElementRegistry,\n         |)\n         |from pyspark.pipelines.spark_connect_pipeline import create_dataflow_graph\n         |from pyspark.pipelines.graph_element_registry import (\n         |    graph_element_registration_context,\n         |)\n         |\n         |spark = SparkSession.builder \\\n         |    .remote(\"sc://localhost:" + this.serverPort() + "\") \\\n         |    .config(\"spark.connect.grpc.channel.timeout\", \"5s\") \\\n         |    .config(\"spark.custom.identifier\", \"" + customSessionIdentifier + "\") \\\n         |    .create()\n         |\n         |dataflow_graph_id = create_dataflow_graph(\n         |    spark,\n         |    default_catalog=None,\n         |    default_database=None,\n         |    sql_conf={},\n         |)\n         |\n         |registry = SparkConnectGraphElementRegistry(spark, dataflow_graph_id)\n         |with graph_element_registration_context(registry):\n         |" + indentedPythonText + "\n         |"));
        this.logInfo((Function0 & Serializable)() -> "Running code: " + pythonCode);
        Tuple2<Object, Seq<String>> tuple2 = this.executePythonCode(pythonCode);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int exitCode = tuple2._1$mcI$sp();
        Seq output = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)exitCode), (Object)output);
        int exitCode2 = tuple22._1$mcI$sp();
        Seq output2 = (Seq)tuple22._2();
        if (exitCode2 != 0) {
            throw new RuntimeException("Python process failed with exit code " + exitCode2 + ". Output: " + output2.mkString("\n"));
        }
        Seq activeSessions = SparkConnectService$.MODULE$.sessionManager().listActiveSessions();
        SessionHolder sessionHolder = (SessionHolder)((IterableOnceOps)activeSessions.map((Function1 & Serializable)info -> SparkConnectService$.MODULE$.sessionManager().getIsolatedSession(info.key(), (Option)None$.MODULE$))).find((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)PythonPipelineSuite.$anonfun$buildGraph$4(customSessionIdentifier, x$3))).getOrElse((Function0 & Serializable)() -> {
            throw new RuntimeException("Session with identifier " + customSessionIdentifier + " not found");
        });
        Seq $org_scalatest_assert_macro_left = dataflowGraphContexts = sessionHolder.dataflowGraphRegistry().getAllDataflowGraphs();
        int $org_scalatest_assert_macro_right = 1;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 98));
        return ((GraphRegistrationContext)dataflowGraphContexts.head()).toDataflowGraph();
    }

    public TableIdentifier graphIdentifier(String name) {
        Option x$1 = Option$.MODULE$.apply((Object)"spark_catalog");
        Option x$2 = Option$.MODULE$.apply((Object)"default");
        String x$3 = name;
        return new TableIdentifier(x$3, x$2, x$1);
    }

    private Tuple2<Object, Seq<String>> executePythonCode(String pythonCode) {
        String pythonExec = (String)package$.MODULE$.env().getOrElse((Object)"PYSPARK_DRIVER_PYTHON", (Function0 & Serializable)() -> (String)package$.MODULE$.env().getOrElse((Object)"PYSPARK_PYTHON", (Function0 & Serializable)() -> "python3"));
        String sparkHome = (String)package$.MODULE$.props().getOrElse((Object)"spark.test.home", (Function0 & Serializable)() -> (String)package$.MODULE$.env().getOrElse((Object)"SPARK_HOME", (Function0 & Serializable)() -> "."));
        Path sourcePath = Paths.get(sparkHome, "python").toAbsolutePath();
        Path py4jPath = Paths.get(sparkHome, "python", "lib", PythonUtils$.MODULE$.PY4J_ZIP_NAME()).toAbsolutePath();
        String pythonPath = PythonUtils$.MODULE$.mergePythonPaths((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{((Object)sourcePath).toString(), ((Object)py4jPath).toString(), (String)package$.MODULE$.env().getOrElse((Object)"PYTHONPATH", (Function0 & Serializable)() -> "")}));
        ProcessBuilder pb = new ProcessBuilder(pythonExec, "-c", pythonCode);
        pb.redirectErrorStream(true);
        pb.environment().put("PYTHONPATH", pythonPath);
        Process process = pb.start();
        BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8));
        ArrayBuffer output = new ArrayBuffer();
        String line2 = null;
        while ((line2 = reader.readLine()) != null) {
            output.$plus$eq((Object)line2);
            Predef$.MODULE$.println((Object)("Python output: " + line2));
        }
        process.waitFor(60L, TimeUnit.SECONDS);
        int exitCode = process.exitValue();
        if (exitCode != 0) {
            Console$.MODULE$.err().println("Python process failed with exit code " + exitCode);
            Console$.MODULE$.err().println("Output:");
            output.foreach((Function1 & Serializable)line -> {
                PythonPipelineSuite.$anonfun$executePythonCode$6(line);
                return BoxedUnit.UNIT;
            });
        }
        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)exitCode), (Object)output.toSeq());
    }

    private final void TestPipelineUpdateContext$lzycompute$1() {
        PythonPipelineSuite pythonPipelineSuite = this;
        synchronized (pythonPipelineSuite) {
            if (this.TestPipelineUpdateContext$module == null) {
                this.TestPipelineUpdateContext$module = new TestPipelineUpdateContextMixin$TestPipelineUpdateContext$((TestPipelineUpdateContextMixin)this);
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$buildGraph$4(String customSessionIdentifier$1, SessionHolder x$3) {
        String string = x$3.session().conf().get("spark.custom.identifier");
        String string2 = customSessionIdentifier$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$new$8(ResolvedFlow x$6) {
        return x$6.df().isStreaming();
    }

    public static final /* synthetic */ boolean $anonfun$new$13(ResolvedFlow x$11) {
        return x$11.inputs().isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$new$14(ResolvedFlow x$12) {
        return x$12.df().isStreaming();
    }

    public static final /* synthetic */ void $anonfun$new$41(PipelineEvent x$25) {
    }

    public static final /* synthetic */ void $anonfun$new$48(PipelineEvent x$27) {
    }

    public static final /* synthetic */ Tuple2 $anonfun$new$52(int id) {
        return new Tuple2.mcJJ.sp((long)id, (long)(id % 2));
    }

    public static final /* synthetic */ void $anonfun$executePythonCode$6(String line) {
        Console$.MODULE$.err().println(line);
    }

    public PythonPipelineSuite() {
        TestPipelineUpdateContextMixin.$init$((TestPipelineUpdateContextMixin)this);
        EventVerificationTestHelpers.$init$((EventVerificationTestHelpers)this);
        this.test("basic", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            DataflowGraph graph = this.buildGraph(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |@dp.table\n        |def table1():\n        |    return spark.readStream.format(\"rate\").load()\n        |"))).resolve().validate();
            Seq $org_scalatest_assert_macro_left = graph.flows();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 115));
            Seq $org_scalatest_assert_macro_left2 = graph.tables();
            int $org_scalatest_assert_macro_right2 = 1;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left2, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 116));
        }, new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 107));
        this.test("basic with inverted topological order", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            DataflowGraph graph = this.buildGraph(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |@dp.table()\n        |def b():\n        |  return spark.readStream.table(\"a\")\n        |\n        |@dp.table()\n        |def c():\n        |  return spark.readStream.table(\"a\")\n        |\n        |@dp.materialized_view()\n        |def d():\n        |  return spark.read.table(\"a\")\n        |\n        |@dp.materialized_view()\n        |def a():\n        |  return spark.range(5)\n        |")));
            DataflowGraph resolvedGraph = graph.resolve().validate();
            Seq $org_scalatest_assert_macro_left = resolvedGraph.tables();
            int $org_scalatest_assert_macro_right = 4;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 139));
            Seq $org_scalatest_assert_macro_left2 = resolvedGraph.resolvedFlows();
            int $org_scalatest_assert_macro_right2 = 4;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left2, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 140));
        }, new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 119));
        this.test("flows", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            DataflowGraph graph = this.buildGraph(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n      |@dp.table()\n      |def a():\n      |  return spark.readStream.format(\"rate\").load()\n      |\n      |@dp.append_flow(target = \"a\")\n      |def supplement():\n      |  return spark.readStream.format(\"rate\").load()\n      |"))).resolve().validate();
            scala.collection.immutable.Set $org_scalatest_assert_macro_left = ((IterableOnceOps)graph.tables().map((Function1 & Serializable)x$4 -> x$4.identifier().table())).toSet();
            scala.collection.immutable.Set $org_scalatest_assert_macro_right = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}));
            scala.collection.immutable.Set set = $org_scalatest_assert_macro_left;
            scala.collection.immutable.Set set2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(set != null ? !set.equals(set2) : set2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 154));
            Seq $org_scalatest_assert_macro_left2 = graph.resolvedFlows();
            int $org_scalatest_assert_macro_right2 = 2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left2, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 155));
            scala.collection.immutable.Set $org_scalatest_assert_macro_left3 = ((IterableOnceOps)((IterableOps)graph.flowsTo().apply((Object)this.graphIdentifier("a"))).map((Function1 & Serializable)x$5 -> x$5.identifier())).toSet();
            scala.collection.immutable.Set $org_scalatest_assert_macro_right3 = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TableIdentifier[]{this.graphIdentifier("a"), this.graphIdentifier("supplement")}));
            scala.collection.immutable.Set set3 = $org_scalatest_assert_macro_left3;
            scala.collection.immutable.Set set4 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(set3 != null ? !set3.equals(set4) : set4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 156));
        }, new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 143));
        this.test("referencing internal datasets", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            DataflowGraph graph = this.buildGraph(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n      |@dp.materialized_view\n      |def src():\n      |  return spark.range(5)\n      |\n      |@dp.materialized_view\n      |def a():\n      |  return spark.read.table(\"src\")\n      |\n      |@dp.table\n      |def b():\n      |  return spark.readStream.table(\"src\")\n      |"))).resolve().validate();
            scala.collection.immutable.Set $org_scalatest_assert_macro_left = graph.table().keySet();
            scala.collection.immutable.Set $org_scalatest_assert_macro_right = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TableIdentifier[]{this.graphIdentifier("src"), this.graphIdentifier("a"), this.graphIdentifier("b")}));
            scala.collection.immutable.Set set = $org_scalatest_assert_macro_left;
            scala.collection.immutable.Set set2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(set != null ? !set.equals(set2) : set2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 177));
            new .colon.colon((Object)"a", (List)new .colon.colon((Object)"b", (List)Nil$.MODULE$)).foreach((Function1 & Serializable)flowName -> {
                scala.collection.immutable.Set $org_scalatest_assert_macro_left = ((ResolvedFlow)graph.resolvedFlow().apply((Object)this.graphIdentifier((String)flowName))).inputs();
                scala.collection.immutable.Set $org_scalatest_assert_macro_right = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TableIdentifier[]{this.graphIdentifier("src")}));
                scala.collection.immutable.Set set = $org_scalatest_assert_macro_left;
                scala.collection.immutable.Set set2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(set != null ? !set.equals(set2) : set2 != null), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 184));
            });
            Tuple2 tuple2 = graph.resolvedFlows().partition((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)PythonPipelineSuite.$anonfun$new$8(x$6)));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Seq streamingFlows = (Seq)tuple2._1();
            Seq batchFlows = (Seq)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)streamingFlows, (Object)batchFlows);
            Seq streamingFlows2 = (Seq)tuple22._1();
            Seq batchFlows2 = (Seq)tuple22._2();
            Seq $org_scalatest_assert_macro_left2 = (Seq)batchFlows2.map((Function1 & Serializable)x$8 -> x$8.identifier());
            .colon.colon $org_scalatest_assert_macro_right2 = new .colon.colon((Object)this.graphIdentifier("src"), (List)new .colon.colon((Object)this.graphIdentifier("a"), (List)Nil$.MODULE$));
            Seq seq = $org_scalatest_assert_macro_left2;
            .colon.colon colon2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(seq != null ? !seq.equals(colon2) : colon2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 188));
            Seq $org_scalatest_assert_macro_left3 = (Seq)streamingFlows2.map((Function1 & Serializable)x$9 -> x$9.identifier());
            .colon.colon $org_scalatest_assert_macro_right3 = new .colon.colon((Object)this.graphIdentifier("b"), (List)Nil$.MODULE$);
            Seq seq2 = $org_scalatest_assert_macro_left3;
            .colon.colon colon3 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(seq2 != null ? !seq2.equals(colon3) : colon3 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 189));
        }, new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 162));
        this.test("referencing external datasets", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            this.sql().apply((Object)"CREATE TABLE spark_catalog.default.src AS SELECT * FROM RANGE(5)");
            DataflowGraph graph = this.buildGraph(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |@dp.materialized_view\n        |def a():\n        |  return spark.read.table(\"spark_catalog.default.src\")\n        |\n        |@dp.materialized_view\n        |def b():\n        |  return spark.table(\"spark_catalog.default.src\")\n        |\n        |@dp.table\n        |def c():\n        |  return spark.readStream.table(\"spark_catalog.default.src\")\n        |"))).resolve().validate();
            scala.collection.immutable.Set $org_scalatest_assert_macro_left = ((IterableOnceOps)graph.tables().map((Function1 & Serializable)x$10 -> x$10.identifier())).toSet();
            scala.collection.immutable.Set $org_scalatest_assert_macro_right = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TableIdentifier[]{this.graphIdentifier("a"), this.graphIdentifier("b"), this.graphIdentifier("c")}));
            scala.collection.immutable.Set set = $org_scalatest_assert_macro_left;
            scala.collection.immutable.Set set2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(set != null ? !set.equals(set2) : set2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 208));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(graph.resolvedFlows().forall((Function1 & Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)PythonPipelineSuite.$anonfun$new$13(x$11))), "graph.resolvedFlows.forall(((x$11: org.apache.spark.sql.pipelines.graph.ResolvedFlow) => x$11.inputs.isEmpty))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 214));
            Tuple2 tuple2 = graph.resolvedFlows().partition((Function1 & Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)PythonPipelineSuite.$anonfun$new$14(x$12)));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Seq streamingFlows = (Seq)tuple2._1();
            Seq batchFlows = (Seq)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)streamingFlows, (Object)batchFlows);
            Seq streamingFlows2 = (Seq)tuple22._1();
            Seq batchFlows2 = (Seq)tuple22._2();
            scala.collection.immutable.Set $org_scalatest_assert_macro_left2 = ((IterableOnceOps)batchFlows2.map((Function1 & Serializable)x$14 -> x$14.identifier())).toSet();
            scala.collection.immutable.Set $org_scalatest_assert_macro_right2 = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TableIdentifier[]{this.graphIdentifier("a"), this.graphIdentifier("b")}));
            scala.collection.immutable.Set set3 = $org_scalatest_assert_macro_left2;
            scala.collection.immutable.Set set4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(set3 != null ? !set3.equals(set4) : set4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 216));
            Seq $org_scalatest_assert_macro_left3 = (Seq)streamingFlows2.map((Function1 & Serializable)x$15 -> x$15.identifier());
            .colon.colon $org_scalatest_assert_macro_right3 = new .colon.colon((Object)this.graphIdentifier("c"), (List)Nil$.MODULE$);
            Seq seq = $org_scalatest_assert_macro_left3;
            .colon.colon colon2 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(seq != null ? !seq.equals(colon2) : colon2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 217));
        }, new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 192));
        this.test("referencing internal datasets failed", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            DataflowGraph graph = this.buildGraph(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |@dp.table\n        |def a():\n        |  return spark.read.table(\"src\")\n        |\n        |@dp.table\n        |def b():\n        |  return spark.table(\"src\")\n        |\n        |@dp.table\n        |def c():\n        |  return spark.readStream.table(\"src\")\n        |"))).resolve();
            Seq $org_scalatest_assert_macro_left = graph.resolutionFailedFlows();
            int $org_scalatest_assert_macro_right = 3;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 235));
            graph.resolutionFailedFlows().foreach((Function1 & Serializable)flow -> {
                String $org_scalatest_assert_macro_left = ((Throwable)flow.failure().head()).getMessage();
                String $org_scalatest_assert_macro_right = "[TABLE_OR_VIEW_NOT_FOUND]";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 237));
                String $org_scalatest_assert_macro_left2 = ((Throwable)flow.failure().head()).getMessage();
                String $org_scalatest_assert_macro_right2 = "`src`";
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 238));
            });
        }, new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 220));
        this.test("referencing external datasets failed", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            DataflowGraph graph = this.buildGraph(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |@dp.table\n        |def a():\n        |  return spark.read.table(\"spark_catalog.default.src\")\n        |\n        |@dp.materialized_view\n        |def b():\n        |  return spark.table(\"spark_catalog.default.src\")\n        |\n        |@dp.materialized_view\n        |def c():\n        |  return spark.readStream.table(\"spark_catalog.default.src\")\n        |"))).resolve();
            graph.resolutionFailedFlows().foreach((Function1 & Serializable)flow -> {
                String $org_scalatest_assert_macro_left = ((Throwable)flow.failure().head()).getMessage();
                String $org_scalatest_assert_macro_right = "[TABLE_OR_VIEW_NOT_FOUND] The table or view";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 257));
            });
        }, new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 242));
        this.test("create dataset with the same name will fail", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            AnalysisException ex = (AnalysisException)this.intercept((Function0 & Serializable)() -> this.buildGraph(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n           |@dp.materialized_view\n           |def a():\n           |  return spark.range(1)\n           |\n           |@dp.materialized_view(name = \"a\")\n           |def b():\n           |  return spark.range(1)\n           |"))), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 262));
            String $org_scalatest_assert_macro_left = ex.getCondition();
            String $org_scalatest_assert_macro_right = "PIPELINE_DUPLICATE_IDENTIFIERS.DATASET";
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 273));
        }, new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 261));
        this.test("create datasets with fully/partially qualified names", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            DataflowGraph graph = this.buildGraph(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n         |@dp.table\n         |def mv_1():\n         |  return spark.range(5)\n         |\n         |@dp.table(name = \"schema_a.mv_2\")\n         |def irrelevant_1():\n         |  return spark.range(5)\n         |\n         |@dp.table(name = \"st_1\")\n         |def irrelevant_2():\n         |  return spark.readStream.format(\"rate\").load()\n         |\n         |@dp.table(name = \"schema_b.st_2\")\n         |def irrelevant_3():\n         |  return spark.readStream.format(\"rate\").load()\n         |"))).resolve();
            scala.collection.immutable.Set $org_scalatest_assert_macro_left = ((IterableOnceOps)graph.tables().map((Function1 & Serializable)x$16 -> x$16.identifier())).toSet();
            TableIdentifier[] tableIdentifierArray = new TableIdentifier[4];
            Option x$1 = Option$.MODULE$.apply((Object)"spark_catalog");
            Option x$2 = Option$.MODULE$.apply((Object)"default");
            String x$3 = "mv_1";
            tableIdentifierArray[0] = new TableIdentifier("mv_1", x$2, x$1);
            Option x$4 = Option$.MODULE$.apply((Object)"spark_catalog");
            Option x$5 = Option$.MODULE$.apply((Object)"schema_a");
            String x$6 = "mv_2";
            tableIdentifierArray[1] = new TableIdentifier("mv_2", x$5, x$4);
            Option x$7 = Option$.MODULE$.apply((Object)"spark_catalog");
            Option x$8 = Option$.MODULE$.apply((Object)"default");
            String x$9 = "st_1";
            tableIdentifierArray[2] = new TableIdentifier("st_1", x$8, x$7);
            Option x$10 = Option$.MODULE$.apply((Object)"spark_catalog");
            Option x$11 = Option$.MODULE$.apply((Object)"schema_b");
            String x$12 = "st_2";
            tableIdentifierArray[3] = new TableIdentifier("st_2", x$11, x$10);
            scala.collection.immutable.Set $org_scalatest_assert_macro_right = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])tableIdentifierArray));
            scala.collection.immutable.Set set = $org_scalatest_assert_macro_left;
            scala.collection.immutable.Set set2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(set != null ? !set.equals(set2) : set2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 296));
            scala.collection.immutable.Set $org_scalatest_assert_macro_left2 = ((IterableOnceOps)graph.flows().map((Function1 & Serializable)x$17 -> x$17.identifier())).toSet();
            TableIdentifier[] tableIdentifierArray2 = new TableIdentifier[4];
            Option x$13 = Option$.MODULE$.apply((Object)"spark_catalog");
            Option x$14 = Option$.MODULE$.apply((Object)"default");
            String x$15 = "mv_1";
            tableIdentifierArray2[0] = new TableIdentifier("mv_1", x$14, x$13);
            Option x$162 = Option$.MODULE$.apply((Object)"spark_catalog");
            Option x$172 = Option$.MODULE$.apply((Object)"schema_a");
            String x$18 = "mv_2";
            tableIdentifierArray2[1] = new TableIdentifier("mv_2", x$172, x$162);
            Option x$19 = Option$.MODULE$.apply((Object)"spark_catalog");
            Option x$20 = Option$.MODULE$.apply((Object)"default");
            String x$21 = "st_1";
            tableIdentifierArray2[2] = new TableIdentifier("st_1", x$20, x$19);
            Option x$22 = Option$.MODULE$.apply((Object)"spark_catalog");
            Option x$23 = Option$.MODULE$.apply((Object)"schema_b");
            String x$24 = "st_2";
            tableIdentifierArray2[3] = new TableIdentifier("st_2", x$23, x$22);
            scala.collection.immutable.Set $org_scalatest_assert_macro_right2 = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])tableIdentifierArray2));
            scala.collection.immutable.Set set3 = $org_scalatest_assert_macro_left2;
            scala.collection.immutable.Set set4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(set3 != null ? !set3.equals(set4) : set4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 314));
        }, new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 276));
        this.test("create datasets with three part names", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            Try graphTry = Try$.MODULE$.apply((Function0 & Serializable)() -> this.buildGraph(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n           |@dp.table(name = \"some_catalog.some_schema.mv\")\n           |def irrelevant_1():\n           |  return spark.range(5)\n           |\n           |@dp.table(name = \"some_catalog.some_schema.st\")\n           |def irrelevant_2():\n           |  return spark.readStream.format(\"rate\").load()\n           |"))).resolve());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(graphTry.isSuccess(), "graphTry.isSuccess", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 346));
            scala.collection.immutable.Set $org_scalatest_assert_macro_left = ((IterableOnceOps)((DataflowGraph)graphTry.get()).tables().map((Function1 & Serializable)x$18 -> x$18.identifier())).toSet();
            scala.collection.immutable.Set $org_scalatest_assert_macro_right = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TableIdentifier[]{new TableIdentifier("mv", (Option)new Some((Object)"some_schema"), (Option)new Some((Object)"some_catalog")), new TableIdentifier("st", (Option)new Some((Object)"some_schema"), (Option)new Some((Object)"some_catalog"))}));
            scala.collection.immutable.Set set = $org_scalatest_assert_macro_left;
            scala.collection.immutable.Set set2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(set != null ? !set.equals(set2) : set2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 347));
            scala.collection.immutable.Set $org_scalatest_assert_macro_left2 = ((IterableOnceOps)((DataflowGraph)graphTry.get()).flows().map((Function1 & Serializable)x$19 -> x$19.identifier())).toSet();
            scala.collection.immutable.Set $org_scalatest_assert_macro_right2 = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TableIdentifier[]{new TableIdentifier("mv", (Option)new Some((Object)"some_schema"), (Option)new Some((Object)"some_catalog")), new TableIdentifier("st", (Option)new Some((Object)"some_schema"), (Option)new Some((Object)"some_catalog"))}));
            scala.collection.immutable.Set set3 = $org_scalatest_assert_macro_left2;
            scala.collection.immutable.Set set4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(set3 != null ? !set3.equals(set4) : set4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 351));
        }, new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 334));
        this.test("temporary views works", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            DataflowGraph graph = this.buildGraph(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n         |@dp.table\n         |def mv_1():\n         |  return spark.range(5)\n         |@dp.temporary_view\n         |def view_1():\n         |  return spark.range(5)\n         |\n         |@dp.temporary_view(name= \"view_2\")\n         |def irrelevant_1():\n         |  return spark.read.table(\"view_1\")\n         |\n         |@dp.temporary_view(name= \"view_3\")\n         |def irrelevant_2():\n         |  return spark.read.table(\"view_1\")\n         |"))).resolve();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(((SetOps)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"view_1", "view_2", "view_3"}))).subsetOf((Set)((IterableOnceOps)graph.flows().map((Function1 & Serializable)x$20 -> x$20.identifier().unquotedString())).toSet()), "scala.Predef.Set.apply[String](\"view_1\", \"view_2\", \"view_3\").subsetOf(graph.flows.map[String](((x$20: org.apache.spark.sql.pipelines.graph.Flow) => x$20.identifier.unquotedString)).toSet[String])", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 376));
            scala.collection.immutable.Set $org_scalatest_assert_macro_left = ((ResolvedFlow)graph.resolvedFlow().apply((Object)TableIdentifier$.MODULE$.apply("view_2"))).inputs();
            TableIdentifier $org_scalatest_assert_macro_right = TableIdentifier$.MODULE$.apply("view_1");
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains((Object)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 380));
            scala.collection.immutable.Set $org_scalatest_assert_macro_left2 = ((ResolvedFlow)graph.resolvedFlow().apply((Object)TableIdentifier$.MODULE$.apply("view_3"))).inputs();
            TableIdentifier $org_scalatest_assert_macro_right2 = TableIdentifier$.MODULE$.apply("view_1");
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains((Object)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 382));
        }, new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 357));
        this.test("create named flow with multipart name will fail", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            RuntimeException ex = (RuntimeException)this.intercept((Function0 & Serializable)() -> this.buildGraph(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n           |@dp.table\n           |def src():\n           |  return spark.readStream.table(\"src0\")\n           |\n           |@dp.append_flow(name =\"some_schema.some_flow\", target = \"src\")\n           |def some_flow():\n           |  return spark.readStream.format(\"rate\").load()\n           |"))), ClassTag$.MODULE$.apply(RuntimeException.class), new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 387));
            String $org_scalatest_assert_macro_left = ex.getMessage();
            String $org_scalatest_assert_macro_right = "MULTIPART_FLOW_NAME_NOT_SUPPORTED";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 398));
        }, new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 386));
        this.test("create flow with multipart target and no explicit name succeeds", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            DataflowGraph graph = this.buildGraph(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n           |@dp.table()\n           |def a():\n           |  return spark.readStream.format(\"rate\").load()\n           |\n           |@dp.append_flow(target = \"default.a\")\n           |def supplement():\n           |  return spark.readStream.format(\"rate\").load()\n           |"))).resolve().validate();
            Seq $org_scalatest_assert_macro_left = (Seq)graph.tables().map((Function1 & Serializable)x$21 -> x$21.identifier());
            .colon.colon $org_scalatest_assert_macro_right = new .colon.colon((Object)this.graphIdentifier("a"), (List)Nil$.MODULE$);
            Seq seq = $org_scalatest_assert_macro_left;
            .colon.colon colon2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(seq != null ? !seq.equals(colon2) : colon2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 412));
            scala.collection.immutable.Set $org_scalatest_assert_macro_left2 = ((IterableOnceOps)((IterableOps)graph.flowsTo().apply((Object)this.graphIdentifier("a"))).map((Function1 & Serializable)x$22 -> x$22.identifier())).toSet();
            scala.collection.immutable.Set $org_scalatest_assert_macro_right2 = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TableIdentifier[]{this.graphIdentifier("a"), this.graphIdentifier("supplement")}));
            scala.collection.immutable.Set set = $org_scalatest_assert_macro_left2;
            scala.collection.immutable.Set set2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(set != null ? !set.equals(set2) : set2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 413));
        }, new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 401));
        this.test("create named flow with multipart target succeeds", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            DataflowGraph graph = this.buildGraph(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n           |@dp.table()\n           |def a():\n           |  return spark.readStream.format(\"rate\").load()\n           |\n           |@dp.append_flow(target = \"default.a\", name = \"something\")\n           |def supplement():\n           |  return spark.readStream.format(\"rate\").load()\n           |")));
            Seq $org_scalatest_assert_macro_left = (Seq)graph.tables().map((Function1 & Serializable)x$23 -> x$23.identifier());
            .colon.colon $org_scalatest_assert_macro_right = new .colon.colon((Object)this.graphIdentifier("a"), (List)Nil$.MODULE$);
            Seq seq = $org_scalatest_assert_macro_left;
            .colon.colon colon2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(seq != null ? !seq.equals(colon2) : colon2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 431));
            Seq $org_scalatest_assert_macro_left2 = (Seq)((IterableOps)graph.flowsTo().apply((Object)this.graphIdentifier("a"))).map((Function1 & Serializable)x$24 -> x$24.identifier());
            .colon.colon $org_scalatest_assert_macro_right2 = new .colon.colon((Object)this.graphIdentifier("a"), (List)new .colon.colon((Object)this.graphIdentifier("something"), (List)Nil$.MODULE$));
            Seq seq2 = $org_scalatest_assert_macro_left2;
            .colon.colon colon3 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(seq2 != null ? !seq2.equals(colon3) : colon3 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 432));
        }, new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 420));
        this.test("groupby and rollup works with internal datasets, referencing with (col, str)", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            DataflowGraph graph = this.buildGraph("\n      from pyspark.sql.functions import col, sum, count\n\n      @dp.materialized_view\n      def src():\n        return spark.range(3)\n\n      @dp.materialized_view\n      def groupby_with_col_result():\n        return spark.read.table(\"src\").groupBy(col(\"id\")).agg(\n          sum(\"id\").alias(\"sum_id\"),\n          count(\"*\").alias(\"cnt\")\n        )\n\n      @dp.materialized_view\n      def groupby_with_str_result():\n        return spark.read.table(\"src\").groupBy(\"id\").agg(\n          sum(\"id\").alias(\"sum_id\"),\n          count(\"*\").alias(\"cnt\")\n        )\n\n      @dp.materialized_view\n      def rollup_with_col_result():\n        return spark.read.table(\"src\").rollup(col(\"id\")).agg(\n          sum(\"id\").alias(\"sum_id\"),\n          count(\"*\").alias(\"cnt\")\n        )\n\n      @dp.materialized_view\n      def rollup_with_str_result():\n        return spark.read.table(\"src\").rollup(\"id\").agg(\n          sum(\"id\").alias(\"sum_id\"),\n          count(\"*\").alias(\"cnt\")\n        )\n    ");
            PipelineUpdateContextImpl updateContext = new PipelineUpdateContextImpl(graph, (Function1 & Serializable)x$25 -> {
                PythonPipelineSuite.$anonfun$new$41(x$25);
                return BoxedUnit.UNIT;
            }, PipelineUpdateContextImpl$.MODULE$.$lessinit$greater$default$3(), PipelineUpdateContextImpl$.MODULE$.$lessinit$greater$default$4());
            updateContext.pipelineExecution().runPipeline();
            updateContext.pipelineExecution().awaitCompletion();
            .colon.colon groupbyDfs = new .colon.colon((Object)this.spark().table("groupby_with_col_result"), (List)new .colon.colon((Object)this.spark().table("groupby_with_str_result"), (List)Nil$.MODULE$));
            .colon.colon rollupDfs = new .colon.colon((Object)this.spark().table("rollup_with_col_result"), (List)new .colon.colon((Object)this.spark().table("rollup_with_str_result"), (List)Nil$.MODULE$));
            groupbyDfs.foreach((Function1 & Serializable)df -> {
                scala.collection.immutable.Set $org_scalatest_assert_macro_left = Predef$.MODULE$.wrapLongArray((long[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])df.select("id", (Seq)Nil$.MODULE$).collect()), (Function1 & Serializable)x$26 -> BoxesRunTime.boxToLong((long)x$26.getLong(0)), (ClassTag)ClassTag$.MODULE$.Long())).toSet();
                scala.collection.immutable.Set $org_scalatest_assert_macro_right = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{0L, 1L, 2L}));
                scala.collection.immutable.Set set = $org_scalatest_assert_macro_left;
                scala.collection.immutable.Set set2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(set != null ? !set.equals(set2) : set2 != null), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 487));
            });
            rollupDfs.foreach((Function1 & Serializable)df -> {
                Bool bool;
                long $org_scalatest_assert_macro_left = df.count();
                int $org_scalatest_assert_macro_right = 4;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == (long)$org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 492));
                Row totalRow = (Row)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])df.filter("id IS NULL").collect()));
                long $org_scalatest_assert_macro_left2 = totalRow.getLong(1);
                long $org_scalatest_assert_macro_right2 = 3L;
                Bool $org_scalatest_assert_macro_left3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
                if ($org_scalatest_assert_macro_left3.value()) {
                    long $org_scalatest_assert_macro_left4 = totalRow.getLong(2);
                    long $org_scalatest_assert_macro_right3 = 3L;
                    bool = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left4), "==", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left4 == $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
                } else {
                    bool = Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
                }
                Bool $org_scalatest_assert_macro_right4 = bool;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "&&", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left3.$amp$amp((Function0 & Serializable)() -> $org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 494));
            });
        }, new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 438));
        this.test("MV/ST with partition columns works", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"mv", "st"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            DataflowGraph graph = this.buildGraph(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n             |from pyspark.sql.functions import col\n             |\n             |@dp.materialized_view(partition_cols = [\"id_mod\"])\n             |def mv():\n             |  return spark.range(5).withColumn(\"id_mod\", col(\"id\") % 2)\n             |\n             |@dp.table(partition_cols = [\"id_mod\"])\n             |def st():\n             |  return spark.readStream.table(\"mv\")\n             |")));
            PipelineUpdateContextImpl updateContext = new PipelineUpdateContextImpl(graph, (Function1 & Serializable)x$27 -> {
                PythonPipelineSuite.$anonfun$new$48(x$27);
                return BoxedUnit.UNIT;
            }, PipelineUpdateContextImpl$.MODULE$.$lessinit$greater$default$3(), PipelineUpdateContextImpl$.MODULE$.$lessinit$greater$default$4());
            updateContext.pipelineExecution().runPipeline();
            updateContext.pipelineExecution().awaitCompletion();
            TableCatalog catalog = (TableCatalog)this.spark().sessionState().catalogManager().currentCatalog();
            new .colon.colon((Object)"mv", (List)new .colon.colon((Object)"st", (List)Nil$.MODULE$)).foreach((Function1 & Serializable)tableName -> {
                Table table = catalog.loadTable(Identifier.of((String[])((String[])((Object[])new String[]{"default"})), (String)tableName));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])table.partitioning()), (Function1 & Serializable)x$28 -> (String)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])((NamedReference)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])x$28.references()))).fieldNames())), ClassTag$.MODULE$.apply(String.class)));
                String[] $org_scalatest_assert_macro_right = (String[])((Object[])new String[]{"id_mod"});
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 521));
                scala.collection.immutable.Set rows = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])this.spark().table(tableName).collect()), (Function1 & Serializable)r -> new Tuple2.mcJJ.sp(r.getLong(0), r.getLong(1)), ClassTag$.MODULE$.apply(Tuple2.class))).toSet();
                scala.collection.immutable.Set expected = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 5).map((Function1 & Serializable)id -> PythonPipelineSuite.$anonfun$new$52(BoxesRunTime.unboxToInt((Object)id))).toSet();
                scala.collection.immutable.Set $org_scalatest_assert_macro_left2 = rows;
                scala.collection.immutable.Set $org_scalatest_assert_macro_right2 = expected;
                scala.collection.immutable.Set set = $org_scalatest_assert_macro_left2;
                scala.collection.immutable.Set set2 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(set != null ? !set.equals(set2) : set2 != null), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 526));
            });
        }), new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 498));
        this.test("create pipeline without table will throw RUN_EMPTY_PIPELINE exception", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            AnalysisException x$25 = (AnalysisException)this.intercept((Function0 & Serializable)() -> this.buildGraph(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n            |spark.range(1)\n            |"))), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 533));
            String x$26 = "RUN_EMPTY_PIPELINE";
            Map x$27 = Predef$.MODULE$.Map().empty();
            Option x$28 = this.checkError$default$3();
            boolean x$29 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$30 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$25, "RUN_EMPTY_PIPELINE", x$28, x$27, x$29, x$30);
        }, new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 531));
        this.test("create pipeline with only temp view will throw RUN_EMPTY_PIPELINE exception", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            AnalysisException x$31 = (AnalysisException)this.intercept((Function0 & Serializable)() -> this.buildGraph(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n            |@dp.temporary_view\n            |def view_1():\n            |  return spark.range(5)\n            |"))), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 544));
            String x$32 = "RUN_EMPTY_PIPELINE";
            Map x$33 = Predef$.MODULE$.Map().empty();
            Option x$34 = this.checkError$default$3();
            boolean x$35 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$36 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$31, "RUN_EMPTY_PIPELINE", x$34, x$33, x$35, x$36);
        }, new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 542));
        this.test("create pipeline with only flow will throw RUN_EMPTY_PIPELINE exception", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            AnalysisException x$37 = (AnalysisException)this.intercept((Function0 & Serializable)() -> this.buildGraph(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n            |@dp.append_flow(target = \"a\")\n            |def flow():\n            |  return spark.range(5)\n            |"))), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 557));
            String x$38 = "RUN_EMPTY_PIPELINE";
            Map x$39 = Predef$.MODULE$.Map().empty();
            Option x$40 = this.checkError$default$3();
            boolean x$41 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$42 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$37, "RUN_EMPTY_PIPELINE", x$40, x$39, x$41, x$42);
        }, new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 555));
    }
}

