/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connect.pipelines;

import java.io.Serializable;
import java.util.Iterator;
import java.util.UUID;
import org.apache.spark.connect.proto.DatasetType;
import org.apache.spark.connect.proto.ExecutePlanRequest;
import org.apache.spark.connect.proto.ExecutePlanResponse;
import org.apache.spark.connect.proto.Expression;
import org.apache.spark.connect.proto.PipelineCommand;
import org.apache.spark.connect.proto.Relation;
import org.apache.spark.connect.proto.SparkConnectServiceGrpc;
import org.apache.spark.connect.proto.UnresolvedTableValuedFunction;
import org.apache.spark.connect.proto.UserContext;
import org.apache.spark.sql.connect.pipelines.SparkDeclarativePipelinesServerTest;
import org.apache.spark.sql.connect.pipelines.TestPipelineDefinition;
import org.apache.spark.sql.connect.service.SessionHolder;
import org.apache.spark.sql.connect.service.SessionKey;
import org.apache.spark.sql.connect.service.SparkConnectService$;
import org.apache.spark.sql.pipelines.graph.DataflowGraph;
import org.apache.spark.sql.pipelines.graph.GraphRegistrationContext;
import org.apache.spark.sql.pipelines.graph.ResolvedFlow;
import org.apache.spark.sql.pipelines.graph.Table;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005y1AAA\u0002\u0001!!)1\u0004\u0001C\u00019\t!3\u000b]1sW\u0012+7\r\\1sCRLg/\u001a)ja\u0016d\u0017N\\3t'\u0016\u0014h/\u001a:Tk&$XM\u0003\u0002\u0005\u000b\u0005I\u0001/\u001b9fY&tWm\u001d\u0006\u0003\r\u001d\tqaY8o]\u0016\u001cGO\u0003\u0002\t\u0013\u0005\u00191/\u001d7\u000b\u0005)Y\u0011!B:qCJ\\'B\u0001\u0007\u000e\u0003\u0019\t\u0007/Y2iK*\ta\"A\u0002pe\u001e\u001c\u0001aE\u0002\u0001#U\u0001\"AE\n\u000e\u0003\rI!\u0001F\u0002\u0003GM\u0003\u0018M]6EK\u000ed\u0017M]1uSZ,\u0007+\u001b9fY&tWm]*feZ,'\u000fV3tiB\u0011a#G\u0007\u0002/)\u0011\u0001$C\u0001\tS:$XM\u001d8bY&\u0011!d\u0006\u0002\b\u0019><w-\u001b8h\u0003\u0019a\u0014N\\5u}Q\tQ\u0004\u0005\u0002\u0013\u0001\u0001")
public class SparkDeclarativePipelinesServerSuite
extends SparkDeclarativePipelinesServerTest {
    public static final /* synthetic */ void $anonfun$new$2(SparkDeclarativePipelinesServerSuite $this, SparkConnectServiceGrpc.SparkConnectServiceBlockingStub stub) {
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(Option$.MODULE$.apply((Object)$this.createDataflowGraph(stub)).isDefined(), "scala.Option.apply[String](SparkDeclarativePipelinesServerSuite.this.createDataflowGraph(stub)).isDefined", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkDeclarativePipelinesServerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 33));
    }

    public static final /* synthetic */ void $anonfun$new$4(SparkDeclarativePipelinesServerSuite $this, SparkConnectServiceGrpc.SparkConnectServiceBlockingStub stub) {
        $this.sendPlan($this.buildSqlCommandPlan("CREATE DATABASE test_db"), stub);
        $this.sendPlan($this.buildSqlCommandPlan("USE DATABASE test_db"), stub);
        String graphId = $this.sendPlan($this.buildCreateDataflowGraphPlan(PipelineCommand.CreateDataflowGraph.newBuilder().build()), stub).getPipelineCommandResult().getCreateDataflowGraphResult().getDataflowGraphId();
        GraphRegistrationContext definition = $this.getDefaultSessionHolder().dataflowGraphRegistry().getDataflowGraphOrThrow(graphId);
        String $org_scalatest_assert_macro_left = definition.defaultDatabase();
        String $org_scalatest_assert_macro_right = "test_db";
        String string = $org_scalatest_assert_macro_left;
        String string2 = $org_scalatest_assert_macro_right;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkDeclarativePipelinesServerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 48));
    }

    public static final /* synthetic */ boolean $anonfun$new$10(ResolvedFlow x$1) {
        String string = x$1.identifier().unquotedString();
        String string2 = "spark_catalog.default.mv";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$new$11(ResolvedFlow x$2) {
        String string = x$2.identifier().unquotedString();
        String string2 = "spark_catalog.default.mv2";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$new$12(ResolvedFlow x$3) {
        String string = x$3.identifier().unquotedString();
        String string2 = "spark_catalog.default.f";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$new$9(SparkDeclarativePipelinesServerSuite $this, SparkConnectServiceGrpc.SparkConnectServiceBlockingStub stub) {
        String graphId = $this.createDataflowGraph(stub);
        $this.sendPlan($this.buildPlanFromPipelineCommand(PipelineCommand.newBuilder().setDefineDataset(PipelineCommand.DefineDataset.newBuilder().setDataflowGraphId(graphId).setDatasetName("mv").setDatasetType(DatasetType.MATERIALIZED_VIEW)).build()), stub);
        $this.sendPlan($this.buildPlanFromPipelineCommand(PipelineCommand.newBuilder().setDefineFlow(PipelineCommand.DefineFlow.newBuilder().setDataflowGraphId(graphId).setFlowName("mv").setTargetDatasetName("mv").setRelation(Relation.newBuilder().setUnresolvedTableValuedFunction(UnresolvedTableValuedFunction.newBuilder().setFunctionName("range").addArguments(Expression.newBuilder().setLiteral(Expression.Literal.newBuilder().setInteger(5).build()).build()).build()).build())).build()), stub);
        $this.registerGraphElementsFromSql(graphId, StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n                |CREATE MATERIALIZED VIEW mv2 AS SELECT 2;\n                |CREATE FLOW f AS INSERT INTO mv2 BY NAME SELECT * FROM mv\n                |")), $this.registerGraphElementsFromSql$default$3(), stub);
        GraphRegistrationContext definition = $this.getDefaultSessionHolder().dataflowGraphRegistry().getDataflowGraphOrThrow(graphId);
        DataflowGraph graph = definition.toDataflowGraph().resolve();
        Seq $org_scalatest_assert_macro_left = graph.flows();
        int $org_scalatest_assert_macro_right = 3;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkDeclarativePipelinesServerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 124));
        Seq $org_scalatest_assert_macro_left2 = graph.tables();
        int $org_scalatest_assert_macro_right2 = 2;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left2, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkDeclarativePipelinesServerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 125));
        Seq $org_scalatest_assert_macro_left3 = graph.views();
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left3, "isEmpty", $org_scalatest_assert_macro_left3.isEmpty(), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkDeclarativePipelinesServerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 126));
        ResolvedFlow mvFlow = (ResolvedFlow)((IterableOps)graph.resolvedFlows().filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)SparkDeclarativePipelinesServerSuite.$anonfun$new$10(x$1)))).head();
        Set $org_scalatest_assert_macro_left4 = mvFlow.inputs();
        Set $org_scalatest_assert_macro_right3 = (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$);
        Set set = $org_scalatest_assert_macro_left4;
        Set set2 = $org_scalatest_assert_macro_right3;
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right3, !(set != null ? !set.equals(set2) : set2 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkDeclarativePipelinesServerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 130));
        String $org_scalatest_assert_macro_left5 = mvFlow.destinationIdentifier().unquotedString();
        String $org_scalatest_assert_macro_right4 = "spark_catalog.default.mv";
        String string = $org_scalatest_assert_macro_left5;
        String string2 = $org_scalatest_assert_macro_right4;
        Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", (Object)$org_scalatest_assert_macro_right4, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkDeclarativePipelinesServerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 131));
        ResolvedFlow mv2Flow = (ResolvedFlow)((IterableOps)graph.resolvedFlows().filter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)SparkDeclarativePipelinesServerSuite.$anonfun$new$11(x$2)))).head();
        Set $org_scalatest_assert_macro_left6 = mv2Flow.inputs();
        Set $org_scalatest_assert_macro_right5 = (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$);
        Set set3 = $org_scalatest_assert_macro_left6;
        Set set4 = $org_scalatest_assert_macro_right5;
        Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "==", (Object)$org_scalatest_assert_macro_right5, !(set3 != null ? !set3.equals(set4) : set4 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkDeclarativePipelinesServerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 137));
        String $org_scalatest_assert_macro_left7 = mv2Flow.destinationIdentifier().unquotedString();
        String $org_scalatest_assert_macro_right6 = "spark_catalog.default.mv2";
        String string3 = $org_scalatest_assert_macro_left7;
        String string4 = $org_scalatest_assert_macro_right6;
        Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "==", (Object)$org_scalatest_assert_macro_right6, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkDeclarativePipelinesServerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 138));
        ResolvedFlow namedFlow = (ResolvedFlow)((IterableOps)graph.resolvedFlows().filter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)SparkDeclarativePipelinesServerSuite.$anonfun$new$12(x$3)))).head();
        Set $org_scalatest_assert_macro_left8 = (Set)namedFlow.inputs().map((Function1 & Serializable)x$4 -> x$4.unquotedString());
        Set $org_scalatest_assert_macro_right7 = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"spark_catalog.default.mv"}));
        Set set5 = $org_scalatest_assert_macro_left8;
        Set set6 = $org_scalatest_assert_macro_right7;
        Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "==", (Object)$org_scalatest_assert_macro_right7, !(set5 != null ? !set5.equals(set6) : set6 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkDeclarativePipelinesServerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 144));
        String $org_scalatest_assert_macro_left9 = namedFlow.destinationIdentifier().unquotedString();
        String $org_scalatest_assert_macro_right8 = "spark_catalog.default.mv2";
        String string5 = $org_scalatest_assert_macro_left9;
        String string6 = $org_scalatest_assert_macro_right8;
        Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "==", (Object)$org_scalatest_assert_macro_right8, !(string5 != null ? !string5.equals(string6) : string6 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkDeclarativePipelinesServerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 145));
    }

    public static final /* synthetic */ boolean $anonfun$new$16(ResolvedFlow x$5) {
        String string = x$5.identifier().unquotedString();
        String string2 = "spark_catalog.default.tableC";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$new$18(ResolvedFlow x$7) {
        String string = x$7.identifier().unquotedString();
        String string2 = "viewB";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$new$20(ResolvedFlow x$9) {
        String string = x$9.identifier().unquotedString();
        String string2 = "spark_catalog.default.tableA";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$new$15(SparkDeclarativePipelinesServerSuite $this, SparkConnectServiceGrpc.SparkConnectServiceBlockingStub stub) {
        String graphId = $this.createDataflowGraph(stub);
        TestPipelineDefinition pipeline = new TestPipelineDefinition(null, graphId){
            {
                this.createTable("tableA", DatasetType.MATERIALIZED_VIEW, (Option<String>)new Some((Object)"SELECT * FROM RANGE(5)"));
                this.createView("viewB", "SELECT * FROM tableA");
                this.createTable("tableC", DatasetType.TABLE, (Option<String>)new Some((Object)"SELECT * FROM tableA, viewB"));
            }
        };
        GraphRegistrationContext definition = $this.getDefaultSessionHolder().dataflowGraphRegistry().getDataflowGraphOrThrow(graphId);
        $this.registerPipelineDatasets(pipeline, stub);
        DataflowGraph graph = definition.toDataflowGraph().resolve();
        Seq $org_scalatest_assert_macro_left = graph.flows();
        int $org_scalatest_assert_macro_right = 3;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkDeclarativePipelinesServerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 171));
        Seq $org_scalatest_assert_macro_left2 = graph.tables();
        int $org_scalatest_assert_macro_right2 = 2;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left2, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkDeclarativePipelinesServerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 172));
        Seq $org_scalatest_assert_macro_left3 = graph.views();
        int $org_scalatest_assert_macro_right3 = 1;
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left3, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkDeclarativePipelinesServerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 173));
        ResolvedFlow tableCFlow = (ResolvedFlow)((IterableOps)graph.resolvedFlows().filter((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)SparkDeclarativePipelinesServerSuite.$anonfun$new$16(x$5)))).head();
        Set $org_scalatest_assert_macro_left4 = (Set)tableCFlow.inputs().map((Function1 & Serializable)x$6 -> x$6.unquotedString());
        Set $org_scalatest_assert_macro_right4 = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"viewB", "spark_catalog.default.tableA"}));
        Set set = $org_scalatest_assert_macro_left4;
        Set set2 = $org_scalatest_assert_macro_right4;
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(set != null ? !set.equals(set2) : set2 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkDeclarativePipelinesServerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 179));
        ResolvedFlow viewBFlow = (ResolvedFlow)((IterableOps)graph.resolvedFlows().filter((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)SparkDeclarativePipelinesServerSuite.$anonfun$new$18(x$7)))).head();
        Set $org_scalatest_assert_macro_left5 = (Set)viewBFlow.inputs().map((Function1 & Serializable)x$8 -> x$8.unquotedString());
        Set $org_scalatest_assert_macro_right5 = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"spark_catalog.default.tableA"}));
        Set set3 = $org_scalatest_assert_macro_left5;
        Set set4 = $org_scalatest_assert_macro_right5;
        Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", (Object)$org_scalatest_assert_macro_right5, !(set3 != null ? !set3.equals(set4) : set4 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkDeclarativePipelinesServerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 184));
        ResolvedFlow tableAFlow = (ResolvedFlow)((IterableOps)graph.resolvedFlows().filter((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)SparkDeclarativePipelinesServerSuite.$anonfun$new$20(x$9)))).head();
        Set $org_scalatest_assert_macro_left6 = tableAFlow.inputs();
        Set $org_scalatest_assert_macro_right6 = (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$);
        Set set5 = $org_scalatest_assert_macro_left6;
        Set set6 = $org_scalatest_assert_macro_right6;
        Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "==", (Object)$org_scalatest_assert_macro_right6, !(set5 != null ? !set5.equals(set6) : set6 != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkDeclarativePipelinesServerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 190));
    }

    public static final /* synthetic */ void $anonfun$new$22(SparkDeclarativePipelinesServerSuite $this, SparkConnectServiceGrpc.SparkConnectServiceBlockingStub stub) {
        String graphId = $this.createDataflowGraph(stub);
        TestPipelineDefinition pipeline = new TestPipelineDefinition(null, graphId){
            {
                this.createTable("tableA", DatasetType.MATERIALIZED_VIEW, (Option<String>)new Some((Object)"SELECT * FROM RANGE(5)"));
                this.createTable("tableB", DatasetType.TABLE, (Option<String>)new Some((Object)"SELECT * FROM STREAM tableA"));
                this.createTable("tableC", DatasetType.MATERIALIZED_VIEW, (Option<String>)new Some((Object)"SELECT * FROM tableB"));
            }
        };
        $this.registerPipelineDatasets(pipeline, stub);
        $this.startPipelineAndWaitForCompletion(graphId);
        long $org_scalatest_assert_macro_left = $this.spark().table("spark_catalog.default.tableA").count();
        int $org_scalatest_assert_macro_right = 5;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == (long)$org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkDeclarativePipelinesServerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 216));
        long $org_scalatest_assert_macro_left2 = $this.spark().table("spark_catalog.default.tableB").count();
        int $org_scalatest_assert_macro_right2 = 5;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == (long)$org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkDeclarativePipelinesServerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 217));
        long $org_scalatest_assert_macro_left3 = $this.spark().table("spark_catalog.default.tableC").count();
        int $org_scalatest_assert_macro_right3 = 5;
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 == (long)$org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkDeclarativePipelinesServerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 218));
    }

    public static final /* synthetic */ void $anonfun$new$24(SparkDeclarativePipelinesServerSuite $this, SparkConnectServiceGrpc.SparkConnectServiceBlockingStub stub) {
        String graphId = $this.createDataflowGraph(stub);
        $this.sql().apply((Object)"CREATE SCHEMA IF NOT EXISTS spark_catalog.`curr`");
        $this.sql().apply((Object)"CREATE SCHEMA IF NOT EXISTS spark_catalog.`other`");
        TestPipelineDefinition pipeline = new TestPipelineDefinition(null, graphId){
            {
                this.createTable("curr.tableA", DatasetType.MATERIALIZED_VIEW, (Option<String>)new Some((Object)"SELECT * FROM RANGE(5)"));
                this.createTable("curr.tableB", DatasetType.TABLE, (Option<String>)new Some((Object)"SELECT * FROM STREAM curr.tableA"));
                this.createView("viewC", "SELECT * FROM curr.tableB");
                this.createTable("other.tableD", DatasetType.MATERIALIZED_VIEW, (Option<String>)new Some((Object)"SELECT * FROM viewC"));
            }
        };
        $this.registerPipelineDatasets(pipeline, stub);
        $this.startPipelineAndWaitForCompletion(graphId);
        long $org_scalatest_assert_macro_left = $this.spark().table("spark_catalog.curr.tableA").count();
        int $org_scalatest_assert_macro_right = 5;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == (long)$org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkDeclarativePipelinesServerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 249));
        long $org_scalatest_assert_macro_left2 = $this.spark().table("spark_catalog.curr.tableB").count();
        int $org_scalatest_assert_macro_right2 = 5;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == (long)$org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkDeclarativePipelinesServerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 250));
        long $org_scalatest_assert_macro_left3 = $this.spark().table("spark_catalog.other.tableD").count();
        int $org_scalatest_assert_macro_right3 = 5;
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 == (long)$org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkDeclarativePipelinesServerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 251));
    }

    public static final /* synthetic */ void $anonfun$new$26(SparkDeclarativePipelinesServerSuite $this, SparkConnectServiceGrpc.SparkConnectServiceBlockingStub stub) {
        String graphId1 = $this.createDataflowGraph(stub);
        $this.sendPlan($this.buildPlanFromPipelineCommand(PipelineCommand.newBuilder().setDefineDataset(PipelineCommand.DefineDataset.newBuilder().setDataflowGraphId(graphId1).setDatasetName("session1_table").setDatasetType(DatasetType.MATERIALIZED_VIEW)).build()), stub);
        Seq $org_scalatest_assert_macro_left = $this.getDefaultSessionHolder().dataflowGraphRegistry().getAllDataflowGraphs();
        int $org_scalatest_assert_macro_right = 1;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkDeclarativePipelinesServerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 274));
    }

    public static final /* synthetic */ boolean $anonfun$new$28(Table x$10) {
        String string = x$10.identifier().table();
        String string2 = "session1_table";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$new$29(Table x$11) {
        String string = x$11.identifier().table();
        String string2 = "session2_table";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$new$27(SparkDeclarativePipelinesServerSuite $this, String newSessionUserId$1, String newSessionId$1, SparkConnectServiceGrpc.SparkConnectServiceBlockingStub stub) {
        ExecutePlanRequest newSessionExecuteRequest = $this.buildExecutePlanRequest($this.buildCreateDataflowGraphPlan(PipelineCommand.CreateDataflowGraph.newBuilder().setDefaultCatalog("spark_catalog").setDefaultDatabase("default").build()), $this.buildExecutePlanRequest$default$2(), $this.buildExecutePlanRequest$default$3()).toBuilder().setUserContext(UserContext.newBuilder().setUserId(newSessionUserId$1).build()).setSessionId(newSessionId$1).build();
        Iterator response = stub.executePlan(newSessionExecuteRequest);
        String graphId2 = ((ExecutePlanResponse)response.next()).getPipelineCommandResult().getCreateDataflowGraphResult().getDataflowGraphId();
        ExecutePlanRequest session2DefineRequest = $this.buildExecutePlanRequest($this.buildPlanFromPipelineCommand(PipelineCommand.newBuilder().setDefineDataset(PipelineCommand.DefineDataset.newBuilder().setDataflowGraphId(graphId2).setDatasetName("session2_table").setDatasetType(DatasetType.MATERIALIZED_VIEW)).build()), $this.buildExecutePlanRequest$default$2(), $this.buildExecutePlanRequest$default$3()).toBuilder().setUserContext(UserContext.newBuilder().setUserId(newSessionUserId$1).build()).setSessionId(newSessionId$1).build();
        stub.executePlan(session2DefineRequest).next();
        SessionHolder newSessionHolder = SparkConnectService$.MODULE$.sessionManager().getIsolatedSession(new SessionKey(newSessionUserId$1, newSessionId$1), (Option)None$.MODULE$);
        Seq defaultSessionGraphs = $this.getDefaultSessionHolder().dataflowGraphRegistry().getAllDataflowGraphs();
        Seq newSessionGraphs = newSessionHolder.dataflowGraphRegistry().getAllDataflowGraphs();
        Seq $org_scalatest_assert_macro_left = defaultSessionGraphs;
        int $org_scalatest_assert_macro_right = 1;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkDeclarativePipelinesServerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 330));
        Seq $org_scalatest_assert_macro_left2 = newSessionGraphs;
        int $org_scalatest_assert_macro_right2 = 1;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left2, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkDeclarativePipelinesServerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 331));
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(((GraphRegistrationContext)defaultSessionGraphs.head()).toDataflowGraph().tables().exists((Function1 & Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)SparkDeclarativePipelinesServerSuite.$anonfun$new$28(x$10))), "defaultSessionGraphs.head.toDataflowGraph.tables.exists(((x$10: org.apache.spark.sql.pipelines.graph.Table) => x$10.identifier.table.==(\"session1_table\")))", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"Session 1 should have its own table", Prettifier$.MODULE$.default(), new Position("SparkDeclarativePipelinesServerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 333));
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(((GraphRegistrationContext)newSessionGraphs.head()).toDataflowGraph().tables().exists((Function1 & Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)SparkDeclarativePipelinesServerSuite.$anonfun$new$29(x$11))), "newSessionGraphs.head.toDataflowGraph.tables.exists(((x$11: org.apache.spark.sql.pipelines.graph.Table) => x$11.identifier.table.==(\"session2_table\")))", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"Session 2 should have its own table", Prettifier$.MODULE$.default(), new Position("SparkDeclarativePipelinesServerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 337));
    }

    public static final /* synthetic */ void $anonfun$new$31(SparkDeclarativePipelinesServerSuite $this, String testUserId$1, String testSessionId$1, SparkConnectServiceGrpc.SparkConnectServiceBlockingStub stub) {
        Seq graphsAfter;
        Option sessionAfterClose;
        Seq graphsBefore;
        ExecutePlanRequest createGraphRequest = $this.buildExecutePlanRequest($this.buildCreateDataflowGraphPlan(PipelineCommand.CreateDataflowGraph.newBuilder().setDefaultCatalog("spark_catalog").setDefaultDatabase("default").build()), $this.buildExecutePlanRequest$default$2(), $this.buildExecutePlanRequest$default$3()).toBuilder().setUserContext(UserContext.newBuilder().setUserId(testUserId$1).build()).setSessionId(testSessionId$1).build();
        Iterator response = stub.executePlan(createGraphRequest);
        String graphId = ((ExecutePlanResponse)response.next()).getPipelineCommandResult().getCreateDataflowGraphResult().getDataflowGraphId();
        ExecutePlanRequest defineRequest = $this.buildExecutePlanRequest($this.buildPlanFromPipelineCommand(PipelineCommand.newBuilder().setDefineDataset(PipelineCommand.DefineDataset.newBuilder().setDataflowGraphId(graphId).setDatasetName("test_table").setDatasetType(DatasetType.MATERIALIZED_VIEW)).build()), $this.buildExecutePlanRequest$default$2(), $this.buildExecutePlanRequest$default$3()).toBuilder().setUserContext(UserContext.newBuilder().setUserId(testUserId$1).build()).setSessionId(testSessionId$1).build();
        stub.executePlan(defineRequest).next();
        SessionHolder sessionHolder = (SessionHolder)SparkConnectService$.MODULE$.sessionManager().getIsolatedSessionIfPresent(new SessionKey(testUserId$1, testSessionId$1)).get();
        Seq $org_scalatest_assert_macro_left = graphsBefore = sessionHolder.dataflowGraphRegistry().getAllDataflowGraphs();
        int $org_scalatest_assert_macro_right = 1;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkDeclarativePipelinesServerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 395));
        SparkConnectService$.MODULE$.sessionManager().closeSession(new SessionKey(testUserId$1, testSessionId$1), SparkConnectService$.MODULE$.sessionManager().closeSession$default$2());
        Option $org_scalatest_assert_macro_left2 = sessionAfterClose = SparkConnectService$.MODULE$.sessionManager().getIsolatedSessionIfPresent(new SessionKey(testUserId$1, testSessionId$1));
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left2, "isEmpty", $org_scalatest_assert_macro_left2.isEmpty(), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"Session should be cleaned up after close", Prettifier$.MODULE$.default(), new Position("SparkDeclarativePipelinesServerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 404));
        Seq $org_scalatest_assert_macro_left3 = graphsAfter = sessionHolder.dataflowGraphRegistry().getAllDataflowGraphs();
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left3, "isEmpty", $org_scalatest_assert_macro_left3.isEmpty(), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"Graph should be removed after session close", Prettifier$.MODULE$.default(), new Position("SparkDeclarativePipelinesServerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 407));
    }

    public static final /* synthetic */ boolean $anonfun$new$34(Table x$12) {
        String string = x$12.identifier().table();
        String string2 = "graph1_table";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$new$35(Table x$13) {
        String string = x$13.identifier().table();
        String string2 = "graph2_table";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$new$33(SparkDeclarativePipelinesServerSuite $this, SparkConnectServiceGrpc.SparkConnectServiceBlockingStub stub) {
        String graphId1 = $this.createDataflowGraph(stub);
        String graphId2 = $this.createDataflowGraph(stub);
        $this.sendPlan($this.buildPlanFromPipelineCommand(PipelineCommand.newBuilder().setDefineDataset(PipelineCommand.DefineDataset.newBuilder().setDataflowGraphId(graphId1).setDatasetName("graph1_table").setDatasetType(DatasetType.MATERIALIZED_VIEW)).build()), stub);
        $this.sendPlan($this.buildPlanFromPipelineCommand(PipelineCommand.newBuilder().setDefineDataset(PipelineCommand.DefineDataset.newBuilder().setDataflowGraphId(graphId2).setDatasetName("graph2_table").setDatasetType(DatasetType.MATERIALIZED_VIEW)).build()), stub);
        SessionHolder sessionHolder = $this.getDefaultSessionHolder();
        GraphRegistrationContext graph1 = sessionHolder.dataflowGraphRegistry().getDataflowGraphOrThrow(graphId1);
        GraphRegistrationContext graph2 = sessionHolder.dataflowGraphRegistry().getDataflowGraphOrThrow(graphId2);
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(graph1.toDataflowGraph().tables().exists((Function1 & Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)SparkDeclarativePipelinesServerSuite.$anonfun$new$34(x$12))), "graph1.toDataflowGraph.tables.exists(((x$12: org.apache.spark.sql.pipelines.graph.Table) => x$12.identifier.table.==(\"graph1_table\")))", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkDeclarativePipelinesServerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 447));
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(graph2.toDataflowGraph().tables().exists((Function1 & Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)SparkDeclarativePipelinesServerSuite.$anonfun$new$35(x$13))), "graph2.toDataflowGraph.tables.exists(((x$13: org.apache.spark.sql.pipelines.graph.Table) => x$13.identifier.table.==(\"graph2_table\")))", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkDeclarativePipelinesServerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 448));
    }

    public static final /* synthetic */ void $anonfun$new$37(SparkDeclarativePipelinesServerSuite $this, SparkConnectServiceGrpc.SparkConnectServiceBlockingStub stub) {
        Seq graphsAfter;
        Seq graphsBefore;
        String graphId = $this.createDataflowGraph(stub);
        $this.sendPlan($this.buildPlanFromPipelineCommand(PipelineCommand.newBuilder().setDefineDataset(PipelineCommand.DefineDataset.newBuilder().setDataflowGraphId(graphId).setDatasetName("test_table").setDatasetType(DatasetType.MATERIALIZED_VIEW)).build()), stub);
        SessionHolder sessionHolder = $this.getDefaultSessionHolder();
        Seq $org_scalatest_assert_macro_left = graphsBefore = sessionHolder.dataflowGraphRegistry().getAllDataflowGraphs();
        int $org_scalatest_assert_macro_right = 1;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkDeclarativePipelinesServerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 472));
        $this.sendPlan($this.buildPlanFromPipelineCommand(PipelineCommand.newBuilder().setDropDataflowGraph(PipelineCommand.DropDataflowGraph.newBuilder().setDataflowGraphId(graphId)).build()), stub);
        Seq $org_scalatest_assert_macro_left2 = graphsAfter = sessionHolder.dataflowGraphRegistry().getAllDataflowGraphs();
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)$org_scalatest_assert_macro_left2, "isEmpty", $org_scalatest_assert_macro_left2.isEmpty(), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"Graph should be removed after drop", Prettifier$.MODULE$.default(), new Position("SparkDeclarativePipelinesServerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 486));
    }

    public SparkDeclarativePipelinesServerSuite() {
        this.test("CreateDataflowGraph request creates a new graph", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withRawBlockingStub((Function1<SparkConnectServiceGrpc.SparkConnectServiceBlockingStub, BoxedUnit>)(Function1 & Serializable)stub -> {
            SparkDeclarativePipelinesServerSuite.$anonfun$new$2(this, stub);
            return BoxedUnit.UNIT;
        }), new Position("SparkDeclarativePipelinesServerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 31));
        this.test("create dataflow graph falls back to current database in session", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withRawBlockingStub((Function1<SparkConnectServiceGrpc.SparkConnectServiceBlockingStub, BoxedUnit>)(Function1 & Serializable)stub -> {
            SparkDeclarativePipelinesServerSuite.$anonfun$new$4(this, stub);
            return BoxedUnit.UNIT;
        }), new Position("SparkDeclarativePipelinesServerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 37));
        this.test("Define a flow for a graph that does not exist", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            Exception ex = (Exception)this.intercept((Function0)(JFunction0.mcV.sp & Serializable)() -> this.withRawBlockingStub((Function1<SparkConnectServiceGrpc.SparkConnectServiceBlockingStub, BoxedUnit>)(Function1 & Serializable)stub -> {
                this.sendPlan(this.buildPlanFromPipelineCommand(PipelineCommand.newBuilder().setDefineDataset(PipelineCommand.DefineDataset.newBuilder().setDataflowGraphId("random-graph-id-that-dne").setDatasetName("mv").setDatasetType(DatasetType.MATERIALIZED_VIEW)).build()), stub);
                return BoxedUnit.UNIT;
            }), ClassTag$.MODULE$.apply(Exception.class), new Position("SparkDeclarativePipelinesServerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 53));
            String $org_scalatest_assert_macro_left = ex.getMessage();
            String $org_scalatest_assert_macro_right = "DATAFLOW_GRAPH_NOT_FOUND";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkDeclarativePipelinesServerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 68));
        }, new Position("SparkDeclarativePipelinesServerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 52));
        this.test("Cross dependency between SQL dataset and non-SQL dataset is valid and can be registered", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withRawBlockingStub((Function1<SparkConnectServiceGrpc.SparkConnectServiceBlockingStub, BoxedUnit>)(Function1 & Serializable)stub -> {
            SparkDeclarativePipelinesServerSuite.$anonfun$new$9(this, stub);
            return BoxedUnit.UNIT;
        }), new Position("SparkDeclarativePipelinesServerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 73));
        this.test("simple graph resolution test", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withRawBlockingStub((Function1<SparkConnectServiceGrpc.SparkConnectServiceBlockingStub, BoxedUnit>)(Function1 & Serializable)stub -> {
            SparkDeclarativePipelinesServerSuite.$anonfun$new$15(this, stub);
            return BoxedUnit.UNIT;
        }), new Position("SparkDeclarativePipelinesServerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 149));
        this.test("execute pipeline end-to-end test", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withRawBlockingStub((Function1<SparkConnectServiceGrpc.SparkConnectServiceBlockingStub, BoxedUnit>)(Function1 & Serializable)stub -> {
            SparkDeclarativePipelinesServerSuite.$anonfun$new$22(this, stub);
            return BoxedUnit.UNIT;
        }), new Position("SparkDeclarativePipelinesServerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 194));
        this.test("create streaming tables, materialized views, and temporary views", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withRawBlockingStub((Function1<SparkConnectServiceGrpc.SparkConnectServiceBlockingStub, BoxedUnit>)(Function1 & Serializable)stub -> {
            SparkDeclarativePipelinesServerSuite.$anonfun$new$24(this, stub);
            return BoxedUnit.UNIT;
        }), new Position("SparkDeclarativePipelinesServerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 222));
        this.test("dataflow graphs are session-specific", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            this.withRawBlockingStub((Function1<SparkConnectServiceGrpc.SparkConnectServiceBlockingStub, BoxedUnit>)(Function1 & Serializable)stub -> {
                SparkDeclarativePipelinesServerSuite.$anonfun$new$26(this, stub);
                return BoxedUnit.UNIT;
            });
            String newSessionId = UUID.randomUUID().toString();
            String newSessionUserId = "session2_user";
            this.withRawBlockingStub((Function1<SparkConnectServiceGrpc.SparkConnectServiceBlockingStub, BoxedUnit>)(Function1 & Serializable)stub -> {
                SparkDeclarativePipelinesServerSuite.$anonfun$new$27(this, newSessionUserId, newSessionId, stub);
                return BoxedUnit.UNIT;
            });
        }, new Position("SparkDeclarativePipelinesServerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 255));
        this.test("dataflow graphs are cleaned up when session is closed", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            String testUserId = "test_user";
            String testSessionId = UUID.randomUUID().toString();
            this.withRawBlockingStub((Function1<SparkConnectServiceGrpc.SparkConnectServiceBlockingStub, BoxedUnit>)(Function1 & Serializable)stub -> {
                SparkDeclarativePipelinesServerSuite.$anonfun$new$31(this, testUserId, testSessionId, stub);
                return BoxedUnit.UNIT;
            });
        }, new Position("SparkDeclarativePipelinesServerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 344));
        this.test("multiple dataflow graphs can exist in the same session", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withRawBlockingStub((Function1<SparkConnectServiceGrpc.SparkConnectServiceBlockingStub, BoxedUnit>)(Function1 & Serializable)stub -> {
            SparkDeclarativePipelinesServerSuite.$anonfun$new$33(this, stub);
            return BoxedUnit.UNIT;
        }), new Position("SparkDeclarativePipelinesServerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 411));
        this.test("dropping a dataflow graph removes it from session", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withRawBlockingStub((Function1<SparkConnectServiceGrpc.SparkConnectServiceBlockingStub, BoxedUnit>)(Function1 & Serializable)stub -> {
            SparkDeclarativePipelinesServerSuite.$anonfun$new$37(this, stub);
            return BoxedUnit.UNIT;
        }), new Position("SparkDeclarativePipelinesServerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 452));
    }
}

