/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connect.planner;

import java.io.Serializable;
import org.apache.spark.connect.proto.DataType;
import org.apache.spark.connect.proto.Expression;
import org.apache.spark.sql.catalyst.CatalystTypeConverters$;
import org.apache.spark.sql.catalyst.expressions.GenericRowWithSchema;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.MapData;
import org.apache.spark.sql.connect.common.InvalidPlanInput;
import org.apache.spark.sql.connect.common.LiteralValueProtoConverter;
import org.apache.spark.sql.connect.common.LiteralValueProtoConverter$;
import org.apache.spark.sql.connect.planner.LiteralExpressionProtoConverter$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.MapType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.funsuite.AnyFunSuite;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u00013A\u0001B\u0003\u0001%!)1\u0004\u0001C\u00019!)q\u0004\u0001C\u0005A!)q\u0004\u0001C\u0005m\t!C*\u001b;fe\u0006dW\t\u001f9sKN\u001c\u0018n\u001c8Qe>$xnQ8om\u0016\u0014H/\u001a:Tk&$XM\u0003\u0002\u0007\u000f\u00059\u0001\u000f\\1o]\u0016\u0014(B\u0001\u0005\n\u0003\u001d\u0019wN\u001c8fGRT!AC\u0006\u0002\u0007M\fHN\u0003\u0002\r\u001b\u0005)1\u000f]1sW*\u0011abD\u0001\u0007CB\f7\r[3\u000b\u0003A\t1a\u001c:h\u0007\u0001\u0019\"\u0001A\n\u0011\u0005QIR\"A\u000b\u000b\u0005Y9\u0012\u0001\u00034v]N,\u0018\u000e^3\u000b\u0005ay\u0011!C:dC2\fG/Z:u\u0013\tQRCA\u0006B]f4UO\\*vSR,\u0017A\u0002\u001fj]&$h\bF\u0001\u001e!\tq\u0002!D\u0001\u0006\u00039!x\u000eT5uKJ\fG\u000e\u0015:pi>$\"!\t\u0018\u0011\u0005\tZcBA\u0012)\u001d\t!c%D\u0001&\u0015\tA1\"\u0003\u0002(K\u0005)\u0001O]8u_&\u0011\u0011FK\u0001\u000b\u000bb\u0004(/Z:tS>t'BA\u0014&\u0013\taSFA\u0004MSR,'/\u00197\u000b\u0005%R\u0003\"B\u0018\u0003\u0001\u0004\u0001\u0014!\u0001<\u0011\u0005E\"T\"\u0001\u001a\u000b\u0003M\nQa]2bY\u0006L!!\u000e\u001a\u0003\u0007\u0005s\u0017\u0010F\u0002\"oaBQaL\u0002A\u0002ABQ!O\u0002A\u0002i\n\u0011\u0001\u001e\t\u0003wyj\u0011\u0001\u0010\u0006\u0003{%\tQ\u0001^=qKNL!a\u0010\u001f\u0003\u0011\u0011\u000bG/\u0019+za\u0016\u0004")
public class LiteralExpressionProtoConverterSuite
extends AnyFunSuite {
    private Expression.Literal toLiteralProto(Object v) {
        return LiteralValueProtoConverter$.MODULE$.toLiteralProtoWithOptions(v, (Option)None$.MODULE$, new LiteralValueProtoConverter.ToLiteralProtoOptions(false));
    }

    private Expression.Literal toLiteralProto(Object v, DataType t) {
        return LiteralValueProtoConverter$.MODULE$.toLiteralProtoWithOptions(v, (Option)new Some((Object)t), new LiteralValueProtoConverter.ToLiteralProtoOptions(false));
    }

    public static final /* synthetic */ void $anonfun$new$3(LiteralExpressionProtoConverterSuite $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Tuple2 tuple22 = (Tuple2)tuple2._1();
            int idx = tuple2._2$mcI$sp();
            if (tuple22 != null) {
                Object v = tuple22._1();
                DataType t = (DataType)tuple22._2();
                Function1 convert = CatalystTypeConverters$.MODULE$.createToCatalystConverter(t);
                Literal expected = new Literal(convert.apply(v), t);
                $this.test("complex proto value and catalyst value conversion #" + idx, (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> $this.assertResult(expected, LiteralExpressionProtoConverter$.MODULE$.toCatalystExpression(LiteralValueProtoConverter$.MODULE$.toLiteralProtoWithOptions(v, (Option)new Some((Object)t), new LiteralValueProtoConverter.ToLiteralProtoOptions(false))), Prettifier$.MODULE$.default(), new Position("LiteralExpressionProtoConverterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 103)), new Position("LiteralExpressionProtoConverterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 102));
                $this.test("complex proto value and catalyst value conversion #" + idx + " - backward compatibility", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> $this.assertResult(expected, LiteralExpressionProtoConverter$.MODULE$.toCatalystExpression(LiteralValueProtoConverter$.MODULE$.toLiteralProtoWithOptions(v, (Option)new Some((Object)t), new LiteralValueProtoConverter.ToLiteralProtoOptions(true))), Prettifier$.MODULE$.default(), new Position("LiteralExpressionProtoConverterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 112)), new Position("LiteralExpressionProtoConverterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 111));
                return;
            }
        }
        throw new MatchError((Object)tuple2);
    }

    public LiteralExpressionProtoConverterSuite() {
        this.test("basic proto value and catalyst value conversion", (Seq)Nil$.MODULE$, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Object[] values = new Object[]{null, BoxesRunTime.boxToBoolean((boolean)true), BoxesRunTime.boxToByte((byte)((byte)1)), BoxesRunTime.boxToShort((short)((short)1)), BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToLong((long)1L), BoxesRunTime.boxToDouble((double)1.1), BoxesRunTime.boxToFloat((float)1.1f), "spark"};
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.genericArrayOps((Object)values), (Function1 & Serializable)v -> this.assertResult(v, LiteralValueProtoConverter$.MODULE$.toScalaValue(this.toLiteralProto(v)), Prettifier$.MODULE$.default(), new Position("LiteralExpressionProtoConverterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 52)));
        }, new Position("LiteralExpressionProtoConverterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 49));
        ((IterableOnceOps)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)new String[]{null, "a", null}, (Object)ArrayType$.MODULE$.apply((DataType)StringType$.MODULE$)), new Tuple2(Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), null), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), null)})), (Object)MapType$.MODULE$.apply((DataType)StringType$.MODULE$, (DataType)StringType$.MODULE$)), new Tuple2((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)"string", (Object)BoxesRunTime.boxToBoolean((boolean)true)), (Object)StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("a", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("b", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("c", (DataType)BooleanType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$))))), new Tuple2((Object)new Tuple3[]{new Tuple3((Object)BoxesRunTime.boxToInteger((int)1), (Object)"string", (Object)BoxesRunTime.boxToBoolean((boolean)true)), new Tuple3((Object)BoxesRunTime.boxToInteger((int)2), (Object)"string", (Object)BoxesRunTime.boxToBoolean((boolean)false)), new Tuple3((Object)BoxesRunTime.boxToInteger((int)3), (Object)"string", (Object)BoxesRunTime.boxToBoolean((boolean)true))}, (Object)ArrayType$.MODULE$.apply((DataType)StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("a", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("b", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("c", (DataType)BooleanType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)))))), new Tuple2((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)1), (Object)new Tuple2.mcII.sp(2, 3)), (Object)StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("a", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("b", (DataType)StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("c", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("d", (DataType)IntegerType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$))), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)))), new Tuple2((Object)new boolean[]{true, false, true}, (Object)ArrayType$.MODULE$.apply((DataType)BooleanType$.MODULE$)), new Tuple2((Object)new short[]{(short)1, (short)2, (short)3}, (Object)ArrayType$.MODULE$.apply((DataType)ShortType$.MODULE$)), new Tuple2((Object)new int[]{1, 2, 3}, (Object)ArrayType$.MODULE$.apply((DataType)IntegerType$.MODULE$)), new Tuple2((Object)new long[]{1L, 2L, 3L}, (Object)ArrayType$.MODULE$.apply((DataType)LongType$.MODULE$)), new Tuple2((Object)new double[]{1.1, 2.1, 3.1}, (Object)ArrayType$.MODULE$.apply((DataType)DoubleType$.MODULE$)), new Tuple2((Object)new float[]{1.1f, 2.1f, 3.1f}, (Object)ArrayType$.MODULE$.apply((DataType)FloatType$.MODULE$)), new Tuple2((Object)((Object[])new int[][]{(int[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, (ClassTag)ClassTag$.MODULE$.Int()), {1, 2, 3}, {4, 5, 6}}), (Object)ArrayType$.MODULE$.apply((DataType)ArrayType$.MODULE$.apply((DataType)IntegerType$.MODULE$))), new Tuple2((Object)((Object[])new int[][]{{1, 2, 3}, {4, 5, 6}, (int[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, (ClassTag)ClassTag$.MODULE$.Int())}), (Object)ArrayType$.MODULE$.apply((DataType)ArrayType$.MODULE$.apply((DataType)IntegerType$.MODULE$))), new Tuple2((Object)((Object[])new int[][][][][][]{(int[][][][][])((Object[])new int[][][][][]{(int[][][][])((Object[])new int[][][][]{(int[][][])((Object[])new int[][][]{(int[][])((Object[])new int[][]{{1, 2, 3}})})})})}), (Object)ArrayType$.MODULE$.apply((DataType)ArrayType$.MODULE$.apply((DataType)ArrayType$.MODULE$.apply((DataType)ArrayType$.MODULE$.apply((DataType)ArrayType$.MODULE$.apply((DataType)ArrayType$.MODULE$.apply((DataType)IntegerType$.MODULE$))))))), new Tuple2(Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"1"), (Object)"2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"3"), (Object)"4")})), (Object)MapType$.MODULE$.apply((DataType)StringType$.MODULE$, (DataType)StringType$.MODULE$)), new Tuple2(Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"1"), (Object)BoxesRunTime.boxToBoolean((boolean)true)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"2"), (Object)BoxesRunTime.boxToBoolean((boolean)false))})), (Object)MapType$.MODULE$.apply((DataType)StringType$.MODULE$, (DataType)BooleanType$.MODULE$)), new Tuple2(Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), (Object)MapType$.MODULE$.apply((DataType)IntegerType$.MODULE$, (DataType)IntegerType$.MODULE$)), new Tuple2(Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)BoxesRunTime.boxToInteger((int)4)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)5)), (Object)BoxesRunTime.boxToInteger((int)6))})), (Object)MapType$.MODULE$.apply((DataType)IntegerType$.MODULE$, (DataType)IntegerType$.MODULE$))})).zipWithIndex()).foreach((Function1 & Serializable)x0$1 -> {
            LiteralExpressionProtoConverterSuite.$anonfun$new$3(this, x0$1);
            return BoxedUnit.UNIT;
        });
        this.test("backward compatibility for array literal proto", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Expression.Literal literalProto = LiteralValueProtoConverter$.MODULE$.toLiteralProtoWithOptions((Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Option)new Some((Object)new ArrayType((DataType)IntegerType$.MODULE$, false)), new LiteralValueProtoConverter.ToLiteralProtoOptions(true));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(literalProto.hasDataType(), "literalProto.hasDataType()", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("LiteralExpressionProtoConverterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 127));
            java.util.List $org_scalatest_assert_macro_left = literalProto.getArray().getElementsList();
            int $org_scalatest_assert_macro_right = 3;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("LiteralExpressionProtoConverterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 128));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(literalProto.getArray().getElementType().hasInteger(), "literalProto.getArray().getElementType().hasInteger()", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("LiteralExpressionProtoConverterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 129));
            Literal literal = LiteralExpressionProtoConverter$.MODULE$.toCatalystExpression(literalProto);
            DataType $org_scalatest_assert_macro_left2 = literal.dataType();
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.spark.sql.types.ArrayType", $org_scalatest_assert_macro_left2 instanceof ArrayType, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("LiteralExpressionProtoConverterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 132));
            DataType $org_scalatest_assert_macro_left3 = ((ArrayType)literal.dataType()).elementType();
            IntegerType$ $org_scalatest_assert_macro_right2 = IntegerType$.MODULE$;
            DataType dataType = $org_scalatest_assert_macro_left3;
            IntegerType$ integerType$ = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right2, !(dataType != null ? !dataType.equals(integerType$) : integerType$ != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("LiteralExpressionProtoConverterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 133));
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.simpleMacroBool(((ArrayType)literal.dataType()).containsNull(), "literal.dataType.asInstanceOf[org.apache.spark.sql.types.ArrayType].containsNull", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("LiteralExpressionProtoConverterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 135));
            ArrayData arrayData = (ArrayData)literal.value();
            int $org_scalatest_assert_macro_left4 = arrayData.numElements();
            int $org_scalatest_assert_macro_right3 = 3;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left4), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left4 == $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("LiteralExpressionProtoConverterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 138));
            int $org_scalatest_assert_macro_left5 = arrayData.getInt(0);
            int $org_scalatest_assert_macro_right4 = 1;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left5), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left5 == $org_scalatest_assert_macro_right4, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("LiteralExpressionProtoConverterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 139));
            int $org_scalatest_assert_macro_left6 = arrayData.getInt(1);
            int $org_scalatest_assert_macro_right5 = 2;
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left6), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left6 == $org_scalatest_assert_macro_right5, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("LiteralExpressionProtoConverterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 140));
            int $org_scalatest_assert_macro_left7 = arrayData.getInt(2);
            int $org_scalatest_assert_macro_right6 = 3;
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left7), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), $org_scalatest_assert_macro_left7 == $org_scalatest_assert_macro_right6, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("LiteralExpressionProtoConverterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 141));
        }, new Position("LiteralExpressionProtoConverterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 121));
        this.test("backward compatibility for map literal proto", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Expression.Literal literalProto = LiteralValueProtoConverter$.MODULE$.toLiteralProtoWithOptions(Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"a"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"b"), (Object)BoxesRunTime.boxToInteger((int)2))})), (Option)new Some((Object)new MapType((DataType)StringType$.MODULE$, (DataType)IntegerType$.MODULE$, false)), new LiteralValueProtoConverter.ToLiteralProtoOptions(true));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(literalProto.hasDataType(), "literalProto.hasDataType()", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("LiteralExpressionProtoConverterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 150));
            java.util.List $org_scalatest_assert_macro_left = literalProto.getMap().getKeysList();
            int $org_scalatest_assert_macro_right = 2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("LiteralExpressionProtoConverterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 151));
            java.util.List $org_scalatest_assert_macro_left2 = literalProto.getMap().getValuesList();
            int $org_scalatest_assert_macro_right2 = 2;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left2, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("LiteralExpressionProtoConverterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 152));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(literalProto.getMap().getKeyType().hasString(), "literalProto.getMap().getKeyType().hasString()", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("LiteralExpressionProtoConverterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 153));
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(literalProto.getMap().getValueType().hasInteger(), "literalProto.getMap().getValueType().hasInteger()", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("LiteralExpressionProtoConverterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 154));
            Literal literal = LiteralExpressionProtoConverter$.MODULE$.toCatalystExpression(literalProto);
            DataType $org_scalatest_assert_macro_left3 = literal.dataType();
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left3, "isInstanceOf", "org.apache.spark.sql.types.MapType", $org_scalatest_assert_macro_left3 instanceof MapType, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("LiteralExpressionProtoConverterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 157));
            DataType $org_scalatest_assert_macro_left4 = ((MapType)literal.dataType()).keyType();
            StringType$ $org_scalatest_assert_macro_right3 = StringType$.MODULE$;
            DataType dataType = $org_scalatest_assert_macro_left4;
            StringType$ stringType$ = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right3, !(dataType != null ? !dataType.equals(stringType$) : stringType$ != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("LiteralExpressionProtoConverterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 158));
            DataType $org_scalatest_assert_macro_left5 = ((MapType)literal.dataType()).valueType();
            IntegerType$ $org_scalatest_assert_macro_right4 = IntegerType$.MODULE$;
            DataType dataType2 = $org_scalatest_assert_macro_left5;
            IntegerType$ integerType$ = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", (Object)$org_scalatest_assert_macro_right4, !(dataType2 != null ? !dataType2.equals(integerType$) : integerType$ != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("LiteralExpressionProtoConverterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 159));
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.simpleMacroBool(((MapType)literal.dataType()).valueContainsNull(), "literal.dataType.asInstanceOf[org.apache.spark.sql.types.MapType].valueContainsNull", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("LiteralExpressionProtoConverterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 161));
            MapData mapData = (MapData)literal.value();
            int $org_scalatest_assert_macro_left6 = mapData.numElements();
            int $org_scalatest_assert_macro_right5 = 2;
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left6), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left6 == $org_scalatest_assert_macro_right5, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("LiteralExpressionProtoConverterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 164));
            ArrayData keys = mapData.keyArray();
            ArrayData values = mapData.valueArray();
            String $org_scalatest_assert_macro_left7 = keys.getUTF8String(0).toString();
            String $org_scalatest_assert_macro_right6 = "a";
            String string = $org_scalatest_assert_macro_left7;
            String string2 = $org_scalatest_assert_macro_right6;
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "==", (Object)$org_scalatest_assert_macro_right6, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("LiteralExpressionProtoConverterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 167));
            int $org_scalatest_assert_macro_left8 = values.getInt(0);
            int $org_scalatest_assert_macro_right7 = 1;
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left8), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left8 == $org_scalatest_assert_macro_right7, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("LiteralExpressionProtoConverterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 168));
            String $org_scalatest_assert_macro_left9 = keys.getUTF8String(1).toString();
            String $org_scalatest_assert_macro_right8 = "b";
            String string3 = $org_scalatest_assert_macro_left9;
            String string4 = $org_scalatest_assert_macro_right8;
            Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "==", (Object)$org_scalatest_assert_macro_right8, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"", Prettifier$.MODULE$.default(), new Position("LiteralExpressionProtoConverterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 169));
            int $org_scalatest_assert_macro_left10 = values.getInt(1);
            int $org_scalatest_assert_macro_right9 = 2;
            Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left10), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right9), $org_scalatest_assert_macro_left10 == $org_scalatest_assert_macro_right9, Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)"", Prettifier$.MODULE$.default(), new Position("LiteralExpressionProtoConverterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 170));
        }, new Position("LiteralExpressionProtoConverterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 144));
        this.test("backward compatibility for struct literal proto", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            GenericRowWithSchema row;
            Expression.Literal structProto = LiteralValueProtoConverter$.MODULE$.toLiteralProtoWithOptions((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)1), (Object)"test"), (Option)new Some((Object)StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("a", (DataType)IntegerType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("b", (DataType)StringType$.MODULE$, false, StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)))), new LiteralValueProtoConverter.ToLiteralProtoOptions(true));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(structProto.hasDataType(), "structProto.hasDataType()", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("LiteralExpressionProtoConverterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 183));
            java.util.List $org_scalatest_assert_macro_left = structProto.getStruct().getElementsList();
            int $org_scalatest_assert_macro_right = 2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("LiteralExpressionProtoConverterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 184));
            DataType.Struct structTypeProto = structProto.getStruct().getStructType().getStruct();
            java.util.List $org_scalatest_assert_macro_left2 = structTypeProto.getFieldsList();
            int $org_scalatest_assert_macro_right2 = 2;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left2, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("LiteralExpressionProtoConverterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 186));
            String $org_scalatest_assert_macro_left3 = ((DataType.StructField)structTypeProto.getFieldsList().get(0)).getName();
            String $org_scalatest_assert_macro_right3 = "a";
            String string = $org_scalatest_assert_macro_left3;
            String string2 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("LiteralExpressionProtoConverterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 187));
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(((DataType.StructField)structTypeProto.getFieldsList().get(0)).getDataType().hasInteger(), "structTypeProto.getFieldsList().get(0).getDataType().hasInteger()", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("LiteralExpressionProtoConverterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 188));
            String $org_scalatest_assert_macro_left4 = ((DataType.StructField)structTypeProto.getFieldsList().get(1)).getName();
            String $org_scalatest_assert_macro_right4 = "b";
            String string3 = $org_scalatest_assert_macro_left4;
            String string4 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("LiteralExpressionProtoConverterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 189));
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.simpleMacroBool(((DataType.StructField)structTypeProto.getFieldsList().get(1)).getDataType().hasString(), "structTypeProto.getFieldsList().get(1).getDataType().hasString()", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("LiteralExpressionProtoConverterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 190));
            Object result = LiteralValueProtoConverter$.MODULE$.toScalaValue(structProto);
            org.apache.spark.connect.proto.DataType resultType = LiteralValueProtoConverter$.MODULE$.getProtoDataType(structProto);
            Object $org_scalatest_assert_macro_left5 = result;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.isInstanceOfMacroBool($org_scalatest_assert_macro_left5, "isInstanceOf", "org.apache.spark.sql.catalyst.expressions.GenericRowWithSchema", $org_scalatest_assert_macro_left5 instanceof GenericRowWithSchema, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("LiteralExpressionProtoConverterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 196));
            GenericRowWithSchema $org_scalatest_assert_macro_left6 = row = (GenericRowWithSchema)result;
            int $org_scalatest_assert_macro_right5 = 2;
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left6, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left6.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("LiteralExpressionProtoConverterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 198));
            Object $org_scalatest_assert_macro_left7 = row.get(0);
            int $org_scalatest_assert_macro_right6 = 1;
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left7, "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6), BoxesRunTime.equals((Object)$org_scalatest_assert_macro_left7, (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right6)), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("LiteralExpressionProtoConverterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 199));
            Object $org_scalatest_assert_macro_left8 = row.get(1);
            String $org_scalatest_assert_macro_right7 = "test";
            Object object = $org_scalatest_assert_macro_left8;
            String string5 = $org_scalatest_assert_macro_right7;
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left8, "==", (Object)$org_scalatest_assert_macro_right7, !(object != null ? !object.equals(string5) : string5 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("LiteralExpressionProtoConverterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 200));
            DataType.KindCase $org_scalatest_assert_macro_left9 = resultType.getKindCase();
            DataType.KindCase $org_scalatest_assert_macro_right8 = DataType.KindCase.STRUCT;
            DataType.KindCase kindCase = $org_scalatest_assert_macro_left9;
            DataType.KindCase kindCase2 = $org_scalatest_assert_macro_right8;
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "==", (Object)$org_scalatest_assert_macro_right8, !(kindCase != null ? !kindCase.equals(kindCase2) : kindCase2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("LiteralExpressionProtoConverterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 203));
            DataType.Struct structType = resultType.getStruct();
            int $org_scalatest_assert_macro_left10 = structType.getFieldsCount();
            int $org_scalatest_assert_macro_right9 = 2;
            Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left10), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right9), $org_scalatest_assert_macro_left10 == $org_scalatest_assert_macro_right9, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"", Prettifier$.MODULE$.default(), new Position("LiteralExpressionProtoConverterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 205));
            String $org_scalatest_assert_macro_left11 = structType.getFields(0).getName();
            String $org_scalatest_assert_macro_right10 = "a";
            String string6 = $org_scalatest_assert_macro_left11;
            String string7 = $org_scalatest_assert_macro_right10;
            Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left11, "==", (Object)$org_scalatest_assert_macro_right10, !(string6 != null ? !string6.equals(string7) : string7 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)"", Prettifier$.MODULE$.default(), new Position("LiteralExpressionProtoConverterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 206));
            Bool $org_scalatest_assert_macro_expr15 = Bool$.MODULE$.simpleMacroBool(structType.getFields(0).getDataType().hasInteger(), "structType.getFields(0).getDataType().hasInteger()", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr15, (Object)"", Prettifier$.MODULE$.default(), new Position("LiteralExpressionProtoConverterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 207));
            Bool $org_scalatest_assert_macro_expr16 = Bool$.MODULE$.simpleMacroBool(structType.getFields(0).getNullable(), "structType.getFields(0).getNullable()", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr16, (Object)"", Prettifier$.MODULE$.default(), new Position("LiteralExpressionProtoConverterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 208));
            String $org_scalatest_assert_macro_left12 = structType.getFields(1).getName();
            String $org_scalatest_assert_macro_right11 = "b";
            String string8 = $org_scalatest_assert_macro_left12;
            String string9 = $org_scalatest_assert_macro_right11;
            Bool $org_scalatest_assert_macro_expr17 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left12, "==", (Object)$org_scalatest_assert_macro_right11, !(string8 != null ? !string8.equals(string9) : string9 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr17, (Object)"", Prettifier$.MODULE$.default(), new Position("LiteralExpressionProtoConverterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 209));
            Bool $org_scalatest_assert_macro_expr18 = Bool$.MODULE$.simpleMacroBool(structType.getFields(1).getDataType().hasString(), "structType.getFields(1).getDataType().hasString()", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr18, (Object)"", Prettifier$.MODULE$.default(), new Position("LiteralExpressionProtoConverterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 210));
            Bool $org_scalatest_assert_macro_expr19 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(structType.getFields(1).getNullable(), "structType.getFields(1).getNullable()", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr19, (Object)"", Prettifier$.MODULE$.default(), new Position("LiteralExpressionProtoConverterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 211));
        }, new Position("LiteralExpressionProtoConverterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 173));
        this.test("an invalid array literal", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Expression.Literal literalProto = Expression.Literal.newBuilder().setArray(Expression.Literal.Array.newBuilder()).build();
            return (InvalidPlanInput)this.intercept((Function0 & Serializable)() -> LiteralValueProtoConverter$.MODULE$.toScalaValue(literalProto), ClassTag$.MODULE$.apply(InvalidPlanInput.class), new Position("LiteralExpressionProtoConverterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 219));
        }, new Position("LiteralExpressionProtoConverterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 214));
        this.test("an invalid map literal", (Seq)Nil$.MODULE$, (Function0 & Serializable)() -> {
            Expression.Literal literalProto = Expression.Literal.newBuilder().setMap(Expression.Literal.Map.newBuilder()).build();
            return (InvalidPlanInput)this.intercept((Function0 & Serializable)() -> LiteralValueProtoConverter$.MODULE$.toScalaValue(literalProto), ClassTag$.MODULE$.apply(InvalidPlanInput.class), new Position("LiteralExpressionProtoConverterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 229));
        }, new Position("LiteralExpressionProtoConverterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 224));
    }
}

