/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connect.planner;

import org.apache.spark.connect.proto.Command;
import org.apache.spark.connect.proto.ExecutePlanRequest;
import org.apache.spark.connect.proto.Plan;
import org.apache.spark.connect.proto.Relation;
import org.apache.spark.connect.proto.UserContext;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.classic.SparkSession;
import org.apache.spark.sql.connect.SparkConnectTestUtils$;
import org.apache.spark.sql.connect.planner.SparkConnectPlanner;
import org.apache.spark.sql.connect.planner.SparkConnectPlanner$;
import org.apache.spark.sql.connect.service.ExecuteHolder;
import org.apache.spark.sql.connect.service.ExecuteStatus;
import org.apache.spark.sql.connect.service.SessionHolder;
import org.apache.spark.sql.connect.service.SessionStatus;
import org.apache.spark.sql.connect.service.SparkConnectService$;

public final class SparkConnectPlannerTestUtils$ {
    public static final SparkConnectPlannerTestUtils$ MODULE$ = new SparkConnectPlannerTestUtils$();

    public LogicalPlan transform(SparkSession spark, Relation relation) {
        return new SparkConnectPlanner(SparkConnectTestUtils$.MODULE$.createDummySessionHolder(spark), SparkConnectPlanner$.MODULE$.$lessinit$greater$default$2()).transformRelation(relation);
    }

    public void transform(SparkSession spark, Command command) {
        ExecuteHolder executeHolder = this.buildExecutePlanHolder(spark, command);
        new SparkConnectPlanner(executeHolder).processWithoutResponseObserverForTesting(command);
    }

    private ExecuteHolder buildExecutePlanHolder(SparkSession spark, Command command) {
        SessionHolder sessionHolder = SparkConnectTestUtils$.MODULE$.createDummySessionHolder(spark);
        sessionHolder.eventManager().status_((SessionStatus)SessionStatus.Started$.MODULE$);
        UserContext context = UserContext.newBuilder().setUserId(sessionHolder.userId()).build();
        Plan plan = Plan.newBuilder().setCommand(command).build();
        ExecutePlanRequest request = ExecutePlanRequest.newBuilder().setPlan(plan).setSessionId(sessionHolder.sessionId()).setUserContext(context).build();
        ExecuteHolder executeHolder = SparkConnectService$.MODULE$.executionManager().createExecuteHolder(request);
        executeHolder.eventsManager().status_((ExecuteStatus)ExecuteStatus.Started$.MODULE$);
        return executeHolder;
    }

    private SparkConnectPlannerTestUtils$() {
    }
}

