/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connect.service;

import com.google.common.cache.Cache;
import io.grpc.stub.StreamObserver;
import java.io.File;
import java.io.Serializable;
import java.net.URI;
import java.nio.file.Path;
import java.time.ZoneId;
import java.util.Map;
import java.util.UUID;
import org.apache.spark.BreakingChangeInfo;
import org.apache.spark.MitigationConfig;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.connect.proto.FetchErrorDetailsRequest;
import org.apache.spark.connect.proto.FetchErrorDetailsResponse;
import org.apache.spark.connect.proto.UserContext;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.catalyst.SQLConfHelper;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.AliasHelper;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeMap;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.PredicateHelper;
import org.apache.spark.sql.catalyst.plans.PlanTestBase;
import org.apache.spark.sql.catalyst.plans.SQLHelper;
import org.apache.spark.sql.catalyst.plans.logical.Aggregate;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.classic.Dataset;
import org.apache.spark.sql.classic.SparkSession;
import org.apache.spark.sql.connect.ResourceHelper;
import org.apache.spark.sql.connect.config.Connect$;
import org.apache.spark.sql.connect.service.FetchErrorDetailsResponseObserver;
import org.apache.spark.sql.connect.service.SessionHolder;
import org.apache.spark.sql.connect.service.SparkConnectFetchErrorDetailsHandler;
import org.apache.spark.sql.connect.service.SparkConnectService$;
import org.apache.spark.sql.connect.service.TestSparkThrowableWithBreakingChange;
import org.apache.spark.sql.connect.utils.ErrorUtils$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.test.SQLTestData;
import org.apache.spark.sql.test.SQLTestData$internalImplicits$;
import org.apache.spark.sql.test.SQLTestUtils;
import org.apache.spark.sql.test.SQLTestUtilsBase;
import org.apache.spark.sql.test.SQLTestUtilsBase$testImplicits$;
import org.apache.spark.sql.test.SharedSparkSession;
import org.apache.spark.sql.test.SharedSparkSessionBase;
import org.apache.spark.sql.test.TestSparkSession;
import org.apache.spark.util.ThreadUtils$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.Tag;
import org.scalatest.compatible.Assertion;
import org.scalatest.concurrent.AbstractPatienceConfiguration;
import org.scalatest.concurrent.AbstractPatienceConfiguration$PatienceConfig$;
import org.scalatest.concurrent.Eventually;
import org.scalatest.concurrent.PatienceConfiguration;
import org.scalatest.concurrent.ScaledTimeSpans;
import org.scalatest.enablers.Retrying;
import org.scalatest.time.Span;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.Awaitable;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u000593Aa\u0002\u0005\u0001+!)A\u0005\u0001C\u0001K!9\u0001\u0006\u0001b\u0001\n\u0013I\u0003B\u0002\u001a\u0001A\u0003%!\u0006C\u00044\u0001\t\u0007I\u0011B\u0015\t\rQ\u0002\u0001\u0015!\u0003+\u0011\u0015)\u0004\u0001\"\u00037\u0005u1U\r^2i\u000bJ\u0014xN\u001d#fi\u0006LGn\u001d%b]\u0012dWM]*vSR,'BA\u0005\u000b\u0003\u001d\u0019XM\u001d<jG\u0016T!a\u0003\u0007\u0002\u000f\r|gN\\3di*\u0011QBD\u0001\u0004gFd'BA\b\u0011\u0003\u0015\u0019\b/\u0019:l\u0015\t\t\"#\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002'\u0005\u0019qN]4\u0004\u0001M!\u0001A\u0006\u000e!!\t9\u0002$D\u0001\u000f\u0013\tIbBA\u0007Ta\u0006\u00148NR;o'VLG/\u001a\t\u00037yi\u0011\u0001\b\u0006\u0003;1\tA\u0001^3ti&\u0011q\u0004\b\u0002\u0013'\"\f'/\u001a3Ta\u0006\u00148nU3tg&|g\u000e\u0005\u0002\"E5\t!\"\u0003\u0002$\u0015\tq!+Z:pkJ\u001cW\rS3ma\u0016\u0014\u0018A\u0002\u001fj]&$h\bF\u0001'!\t9\u0003!D\u0001\t\u0003\u0019)8/\u001a:JIV\t!\u0006\u0005\u0002,a5\tAF\u0003\u0002.]\u0005!A.\u00198h\u0015\u0005y\u0013\u0001\u00026bm\u0006L!!\r\u0017\u0003\rM#(/\u001b8h\u0003\u001d)8/\u001a:JI\u0002\n\u0011b]3tg&|g.\u00133\u0002\u0015M,7o]5p]&#\u0007%A\tgKR\u001c\u0007.\u0012:s_J$U\r^1jYN$Ba\u000e L\u0019B\u0011\u0001\bP\u0007\u0002s)\u0011!hO\u0001\u0006aJ|Go\u001c\u0006\u0003\u00179I!!P\u001d\u00033\u0019+Go\u00195FeJ|'\u000fR3uC&d7OU3ta>t7/\u001a\u0005\u0006Q\u0019\u0001\ra\u0010\t\u0003\u0001&s!!Q$\u0011\u0005\t+U\"A\"\u000b\u0005\u0011#\u0012A\u0002\u001fs_>$hHC\u0001G\u0003\u0015\u00198-\u00197b\u0013\tAU)\u0001\u0004Qe\u0016$WMZ\u0005\u0003c)S!\u0001S#\t\u000bM2\u0001\u0019A \t\u000b53\u0001\u0019A \u0002\u000f\u0015\u0014(o\u001c:JI\u0002")
public class FetchErrorDetailsHandlerSuite
extends SparkFunSuite
implements SharedSparkSession,
ResourceHelper {
    private final String userId;
    private final String sessionId;
    private Path baseResourcePath;
    private Path commonResourcePath;
    private boolean enableAutoThreadAudit;
    private TestSparkSession org$apache$spark$sql$test$SharedSparkSessionBase$$_spark;
    private boolean org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests;
    private Function1<String, Dataset<Row>> sql;
    private volatile SQLTestUtilsBase$testImplicits$ testImplicits$module;
    private String sparkHome;
    private volatile SQLTestData$internalImplicits$ internalImplicits$module;
    private Dataset<Row> emptyTestData;
    private Dataset<Row> testData;
    private Dataset<Row> testData2;
    private Dataset<Row> testData3;
    private Dataset<Row> negativeData;
    private Dataset<Row> largeAndSmallInts;
    private Dataset<Row> decimalData;
    private Dataset<Row> binaryData;
    private Dataset<Row> upperCaseData;
    private Dataset<Row> lowerCaseData;
    private Dataset<Row> lowerCaseDataWithDuplicates;
    private RDD<SQLTestData.ArrayData> arrayData;
    private RDD<SQLTestData.MapData> mapData;
    private RDD<SQLTestData.IntervalData> calendarIntervalData;
    private RDD<SQLTestData.StringData> repeatedData;
    private RDD<SQLTestData.StringData> nullableRepeatedData;
    private Dataset<Row> nullInts;
    private Dataset<Row> allNulls;
    private Dataset<Row> nullStrings;
    private Dataset<Row> tableName;
    private RDD<String> unparsedStrings;
    private RDD<SQLTestData.IntField> withEmptyParts;
    private Dataset<Row> person;
    private Dataset<Row> salary;
    private Dataset<Row> complexData;
    private Dataset<Row> courseSales;
    private Dataset<Row> trainingSales;
    private Dataset<Row> intervalData;
    private AbstractPatienceConfiguration.PatienceConfig org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig;
    private volatile AbstractPatienceConfiguration$PatienceConfig$ PatienceConfig$module;
    private volatile int bitmap$0;

    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSession$$super$beforeAll() {
        SharedSparkSessionBase.beforeAll$((SharedSparkSessionBase)this);
    }

    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSession$$super$afterAll() {
        SharedSparkSessionBase.afterAll$((SharedSparkSessionBase)this);
    }

    public void beforeAll() {
        SharedSparkSession.beforeAll$((SharedSparkSession)this);
    }

    public void afterAll() {
        SharedSparkSession.afterAll$((SharedSparkSession)this);
    }

    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSessionBase$$super$beforeAll() {
        SQLTestUtils.beforeAll$((SQLTestUtils)this);
    }

    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSessionBase$$super$afterAll() {
        super.afterAll();
    }

    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSessionBase$$super$beforeEach() {
        BeforeAndAfterEach.beforeEach$((BeforeAndAfterEach)this);
    }

    public /* synthetic */ void org$apache$spark$sql$test$SharedSparkSessionBase$$super$afterEach() {
        BeforeAndAfterEach.afterEach$((BeforeAndAfterEach)this);
    }

    public SparkConf sparkConf() {
        return SharedSparkSessionBase.sparkConf$((SharedSparkSessionBase)this);
    }

    public SparkSession spark() {
        return SharedSparkSessionBase.spark$((SharedSparkSessionBase)this);
    }

    public SQLContext sqlContext() {
        return SharedSparkSessionBase.sqlContext$((SharedSparkSessionBase)this);
    }

    public TestSparkSession createSparkSession() {
        return SharedSparkSessionBase.createSparkSession$((SharedSparkSessionBase)this);
    }

    public SQLConf sqlConf() {
        return SharedSparkSessionBase.sqlConf$((SharedSparkSessionBase)this);
    }

    public void initializeSession() {
        SharedSparkSessionBase.initializeSession$((SharedSparkSessionBase)this);
    }

    public void beforeEach() {
        SharedSparkSessionBase.beforeEach$((SharedSparkSessionBase)this);
    }

    public void afterEach() {
        SharedSparkSessionBase.afterEach$((SharedSparkSessionBase)this);
    }

    public /* synthetic */ void org$apache$spark$sql$test$SQLTestUtils$$super$beforeAll() {
        super.beforeAll();
    }

    public /* synthetic */ void org$apache$spark$sql$test$SQLTestUtils$$super$withTempDir(Function1 f) {
        super.withTempDir(f);
    }

    public /* synthetic */ void org$apache$spark$sql$test$SQLTestUtils$$super$test(String testName, Seq testTags, Function0 testBody, Position pos) {
        super.test(testName, testTags, testBody, pos);
    }

    public void withTempDir(Function1<File, BoxedUnit> f) {
        SQLTestUtils.withTempDir$((SQLTestUtils)this, f);
    }

    public void testWithWholeStageCodegenOnAndOff(String testName, Function1<String, BoxedUnit> f) {
        SQLTestUtils.testWithWholeStageCodegenOnAndOff$((SQLTestUtils)this, (String)testName, f);
    }

    public void setupTestData() {
        SQLTestUtils.setupTestData$((SQLTestUtils)this);
    }

    public void testQuietly(String name, Function0<BoxedUnit> f) {
        SQLTestUtils.testQuietly$((SQLTestUtils)this, (String)name, f);
    }

    public void test(String testName, Seq<Tag> testTags, Function0<Object> testFun, Position pos) {
        SQLTestUtils.test$((SQLTestUtils)this, (String)testName, testTags, testFun, (Position)pos);
    }

    public void testWithUninterruptibleThread(String name, boolean quietly, Function0<BoxedUnit> body) {
        SQLTestUtils.testWithUninterruptibleThread$((SQLTestUtils)this, (String)name, (boolean)quietly, body);
    }

    public boolean testWithUninterruptibleThread$default$2() {
        return SQLTestUtils.testWithUninterruptibleThread$default$2$((SQLTestUtils)this);
    }

    public void withResourceTempPath(String resourcePath, Function1<File, BoxedUnit> f) {
        SQLTestUtils.withResourceTempPath$((SQLTestUtils)this, (String)resourcePath, f);
    }

    public void waitForTasksToFinish() {
        SQLTestUtils.waitForTasksToFinish$((SQLTestUtils)this);
    }

    public void withTempPaths(int numPaths, Function1<Seq<File>, BoxedUnit> f) {
        SQLTestUtils.withTempPaths$((SQLTestUtils)this, (int)numPaths, f);
    }

    public /* synthetic */ Object org$apache$spark$sql$test$SQLTestUtilsBase$$super$withSQLConf(Seq pairs, Function0 f) {
        return SQLConfHelper.withSQLConf$((SQLConfHelper)this, (Seq)pairs, (Function0)f);
    }

    public SparkContext sparkContext() {
        return SQLTestUtilsBase.sparkContext$((SQLTestUtilsBase)this);
    }

    public <T> T withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<T> f) {
        return (T)SQLTestUtilsBase.withSQLConf$((SQLTestUtilsBase)this, pairs, f);
    }

    public void withUserDefinedFunction(Seq<Tuple2<String, Object>> functions, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withUserDefinedFunction$((SQLTestUtilsBase)this, functions, f);
    }

    public void withTempView(Seq<String> viewNames, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withTempView$((SQLTestUtilsBase)this, viewNames, f);
    }

    public void withGlobalTempView(Seq<String> viewNames, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withGlobalTempView$((SQLTestUtilsBase)this, viewNames, f);
    }

    public void withTable(Seq<String> tableNames, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withTable$((SQLTestUtilsBase)this, tableNames, f);
    }

    public void withView(Seq<String> viewNames, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withView$((SQLTestUtilsBase)this, viewNames, f);
    }

    public void withCache(Seq<String> cacheNames, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withCache$((SQLTestUtilsBase)this, cacheNames, f);
    }

    public void uncacheTable(String tableName) {
        SQLTestUtilsBase.uncacheTable$((SQLTestUtilsBase)this, (String)tableName);
    }

    public void withTempDatabase(Function1<String, BoxedUnit> f) {
        SQLTestUtilsBase.withTempDatabase$((SQLTestUtilsBase)this, f);
    }

    public void withDatabase(Seq<String> dbNames, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withDatabase$((SQLTestUtilsBase)this, dbNames, f);
    }

    public void withNamespace(Seq<String> namespaces, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withNamespace$((SQLTestUtilsBase)this, namespaces, f);
    }

    public void withCurrentCatalogAndNamespace(Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withCurrentCatalogAndNamespace$((SQLTestUtilsBase)this, f);
    }

    public void withLocale(String language, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withLocale$((SQLTestUtilsBase)this, (String)language, f);
    }

    public void withSessionVariable(Seq<String> variableNames, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.withSessionVariable$((SQLTestUtilsBase)this, variableNames, f);
    }

    public void activateDatabase(String db, Function0<BoxedUnit> f) {
        SQLTestUtilsBase.activateDatabase$((SQLTestUtilsBase)this, (String)db, f);
    }

    public Dataset<Row> stripSparkFilter(Dataset<Row> df) {
        return SQLTestUtilsBase.stripSparkFilter$((SQLTestUtilsBase)this, df);
    }

    public Dataset<Row> logicalPlanToSparkQuery(LogicalPlan plan) {
        return SQLTestUtilsBase.logicalPlanToSparkQuery$((SQLTestUtilsBase)this, (LogicalPlan)plan);
    }

    public URI makeQualifiedPath(String path) {
        return SQLTestUtilsBase.makeQualifiedPath$((SQLTestUtilsBase)this, (String)path);
    }

    public String testFile(String fileName) {
        return SQLTestUtilsBase.testFile$((SQLTestUtilsBase)this, (String)fileName);
    }

    public long getLocalDirSize(File file) {
        return SQLTestUtilsBase.getLocalDirSize$((SQLTestUtilsBase)this, (File)file);
    }

    public LogicalPlan normalizeExprIds(LogicalPlan plan) {
        return PlanTestBase.normalizeExprIds$((PlanTestBase)this, (LogicalPlan)plan);
    }

    public LogicalPlan rewriteNameFromAttrNullability(LogicalPlan plan) {
        return PlanTestBase.rewriteNameFromAttrNullability$((PlanTestBase)this, (LogicalPlan)plan);
    }

    public LogicalPlan normalizePlan(LogicalPlan plan) {
        return PlanTestBase.normalizePlan$((PlanTestBase)this, (LogicalPlan)plan);
    }

    public void comparePlans(LogicalPlan plan1, LogicalPlan plan2, boolean checkAnalysis) {
        PlanTestBase.comparePlans$((PlanTestBase)this, (LogicalPlan)plan1, (LogicalPlan)plan2, (boolean)checkAnalysis);
    }

    public boolean comparePlans$default$3() {
        return PlanTestBase.comparePlans$default$3$((PlanTestBase)this);
    }

    public void compareExpressions(Expression e1, Expression e2) {
        PlanTestBase.compareExpressions$((PlanTestBase)this, (Expression)e1, (Expression)e2);
    }

    public void withTempPath(Function1<File, BoxedUnit> f) {
        SQLHelper.withTempPath$((SQLHelper)this, f);
    }

    public <T> void testSpecialDatetimeValues(Function1<ZoneId, T> test) {
        SQLHelper.testSpecialDatetimeValues$((SQLHelper)this, test);
    }

    public SQLConf conf() {
        return SQLConfHelper.conf$((SQLConfHelper)this);
    }

    public Seq<Expression> splitConjunctivePredicates(Expression condition) {
        return PredicateHelper.splitConjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Option<Tuple2<Expression, LogicalPlan>> findExpressionAndTrackLineageDown(Expression exp, LogicalPlan plan) {
        return PredicateHelper.findExpressionAndTrackLineageDown$((PredicateHelper)this, (Expression)exp, (LogicalPlan)plan);
    }

    public Seq<Expression> splitDisjunctivePredicates(Expression condition) {
        return PredicateHelper.splitDisjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Expression buildBalancedPredicate(Seq<Expression> expressions2, Function2<Expression, Expression, Expression> op) {
        return PredicateHelper.buildBalancedPredicate$((PredicateHelper)this, expressions2, op);
    }

    public boolean canEvaluate(Expression expr, LogicalPlan plan) {
        return PredicateHelper.canEvaluate$((PredicateHelper)this, (Expression)expr, (LogicalPlan)plan);
    }

    public boolean canEvaluateWithinJoin(Expression expr) {
        return PredicateHelper.canEvaluateWithinJoin$((PredicateHelper)this, (Expression)expr);
    }

    public Option<Expression> extractPredicatesWithinOutputSet(Expression condition, AttributeSet outputSet) {
        return PredicateHelper.extractPredicatesWithinOutputSet$((PredicateHelper)this, (Expression)condition, (AttributeSet)outputSet);
    }

    public boolean isNullIntolerant(Expression expr) {
        return PredicateHelper.isNullIntolerant$((PredicateHelper)this, (Expression)expr);
    }

    public Seq<Attribute> outputWithNullability(Seq<Attribute> output, Seq<ExprId> nonNullAttrExprIds) {
        return PredicateHelper.outputWithNullability$((PredicateHelper)this, output, nonNullAttrExprIds);
    }

    public boolean isLikelySelective(Expression e) {
        return PredicateHelper.isLikelySelective$((PredicateHelper)this, (Expression)e);
    }

    public AttributeMap<Alias> getAliasMap(Project plan) {
        return AliasHelper.getAliasMap$((AliasHelper)this, (Project)plan);
    }

    public AttributeMap<Alias> getAliasMap(Aggregate plan) {
        return AliasHelper.getAliasMap$((AliasHelper)this, (Aggregate)plan);
    }

    public AttributeMap<Alias> getAliasMap(Iterable<NamedExpression> exprs) {
        return AliasHelper.getAliasMap$((AliasHelper)this, exprs);
    }

    public Expression replaceAlias(Expression expr, AttributeMap<Alias> aliasMap) {
        return AliasHelper.replaceAlias$((AliasHelper)this, (Expression)expr, aliasMap);
    }

    public NamedExpression replaceAliasButKeepName(NamedExpression expr, AttributeMap<Alias> aliasMap) {
        return AliasHelper.replaceAliasButKeepName$((AliasHelper)this, (NamedExpression)expr, aliasMap);
    }

    public Expression trimAliases(Expression e) {
        return AliasHelper.trimAliases$((AliasHelper)this, (Expression)e);
    }

    public <T extends Expression> T trimNonTopLevelAliases(T e) {
        return (T)AliasHelper.trimNonTopLevelAliases$((AliasHelper)this, e);
    }

    public void loadTestData() {
        SQLTestData.loadTestData$((SQLTestData)this);
    }

    public <T> T eventually(PatienceConfiguration.Timeout timeout, PatienceConfiguration.Interval interval, Function0<T> fun, Retrying<T> retrying, Position pos) {
        return (T)Eventually.eventually$((Eventually)this, (PatienceConfiguration.Timeout)timeout, (PatienceConfiguration.Interval)interval, fun, retrying, (Position)pos);
    }

    public <T> T eventually(PatienceConfiguration.Timeout timeout, Function0<T> fun, AbstractPatienceConfiguration.PatienceConfig config, Retrying<T> retrying, Position pos) {
        return (T)Eventually.eventually$((Eventually)this, (PatienceConfiguration.Timeout)timeout, fun, (AbstractPatienceConfiguration.PatienceConfig)config, retrying, (Position)pos);
    }

    public <T> T eventually(PatienceConfiguration.Interval interval, Function0<T> fun, AbstractPatienceConfiguration.PatienceConfig config, Retrying<T> retrying, Position pos) {
        return (T)Eventually.eventually$((Eventually)this, (PatienceConfiguration.Interval)interval, fun, (AbstractPatienceConfiguration.PatienceConfig)config, retrying, (Position)pos);
    }

    public <T> T eventually(Function0<T> fun, AbstractPatienceConfiguration.PatienceConfig config, Retrying<T> retrying, Position pos) {
        return (T)Eventually.eventually$((Eventually)this, fun, (AbstractPatienceConfiguration.PatienceConfig)config, retrying, (Position)pos);
    }

    public AbstractPatienceConfiguration.PatienceConfig patienceConfig() {
        return PatienceConfiguration.patienceConfig$((PatienceConfiguration)this);
    }

    public PatienceConfiguration.Timeout timeout(Span value) {
        return PatienceConfiguration.timeout$((PatienceConfiguration)this, (Span)value);
    }

    public PatienceConfiguration.Interval interval(Span value) {
        return PatienceConfiguration.interval$((PatienceConfiguration)this, (Span)value);
    }

    public final Span scaled(Span span) {
        return ScaledTimeSpans.scaled$((ScaledTimeSpans)this, (Span)span);
    }

    public double spanScaleFactor() {
        return ScaledTimeSpans.spanScaleFactor$((ScaledTimeSpans)this);
    }

    @Override
    public Path baseResourcePath() {
        return this.baseResourcePath;
    }

    @Override
    public Path commonResourcePath() {
        return this.commonResourcePath;
    }

    @Override
    public void org$apache$spark$sql$connect$ResourceHelper$_setter_$baseResourcePath_$eq(Path x$1) {
        this.baseResourcePath = x$1;
    }

    @Override
    public void org$apache$spark$sql$connect$ResourceHelper$_setter_$commonResourcePath_$eq(Path x$1) {
        this.commonResourcePath = x$1;
    }

    public boolean enableAutoThreadAudit() {
        return this.enableAutoThreadAudit;
    }

    public void org$apache$spark$sql$test$SharedSparkSession$_setter_$enableAutoThreadAudit_$eq(boolean x$1) {
        this.enableAutoThreadAudit = x$1;
    }

    public TestSparkSession org$apache$spark$sql$test$SharedSparkSessionBase$$_spark() {
        return this.org$apache$spark$sql$test$SharedSparkSessionBase$$_spark;
    }

    public void org$apache$spark$sql$test$SharedSparkSessionBase$$_spark_$eq(TestSparkSession x$1) {
        this.org$apache$spark$sql$test$SharedSparkSessionBase$$_spark = x$1;
    }

    public boolean org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests() {
        return this.org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests;
    }

    public void org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests_$eq(boolean x$1) {
        this.org$apache$spark$sql$test$SQLTestUtils$$loadTestDataBeforeTests = x$1;
    }

    private Function1<String, Dataset<Row>> sql$lzycompute() {
        FetchErrorDetailsHandlerSuite fetchErrorDetailsHandlerSuite = this;
        synchronized (fetchErrorDetailsHandlerSuite) {
            if ((this.bitmap$0 & 1) == 0) {
                this.sql = SQLTestUtilsBase.sql$((SQLTestUtilsBase)this);
                this.bitmap$0 |= 1;
            }
        }
        return this.sql;
    }

    public Function1<String, Dataset<Row>> sql() {
        if ((this.bitmap$0 & 1) == 0) {
            return this.sql$lzycompute();
        }
        return this.sql;
    }

    public SQLTestUtilsBase$testImplicits$ testImplicits() {
        if (this.testImplicits$module == null) {
            this.testImplicits$lzycompute$1();
        }
        return this.testImplicits$module;
    }

    private String sparkHome$lzycompute() {
        FetchErrorDetailsHandlerSuite fetchErrorDetailsHandlerSuite = this;
        synchronized (fetchErrorDetailsHandlerSuite) {
            if ((this.bitmap$0 & 2) == 0) {
                this.sparkHome = SQLHelper.sparkHome$((SQLHelper)this);
                this.bitmap$0 |= 2;
            }
        }
        return this.sparkHome;
    }

    public String sparkHome() {
        if ((this.bitmap$0 & 2) == 0) {
            return this.sparkHome$lzycompute();
        }
        return this.sparkHome;
    }

    public SQLTestData$internalImplicits$ org$apache$spark$sql$test$SQLTestData$$internalImplicits() {
        if (this.internalImplicits$module == null) {
            this.org$apache$spark$sql$test$SQLTestData$$internalImplicits$lzycompute$1();
        }
        return this.internalImplicits$module;
    }

    private Dataset<Row> emptyTestData$lzycompute() {
        FetchErrorDetailsHandlerSuite fetchErrorDetailsHandlerSuite = this;
        synchronized (fetchErrorDetailsHandlerSuite) {
            if ((this.bitmap$0 & 4) == 0) {
                this.emptyTestData = SQLTestData.emptyTestData$((SQLTestData)this);
                this.bitmap$0 |= 4;
            }
        }
        return this.emptyTestData;
    }

    public Dataset<Row> emptyTestData() {
        if ((this.bitmap$0 & 4) == 0) {
            return this.emptyTestData$lzycompute();
        }
        return this.emptyTestData;
    }

    private Dataset<Row> testData$lzycompute() {
        FetchErrorDetailsHandlerSuite fetchErrorDetailsHandlerSuite = this;
        synchronized (fetchErrorDetailsHandlerSuite) {
            if ((this.bitmap$0 & 8) == 0) {
                this.testData = SQLTestData.testData$((SQLTestData)this);
                this.bitmap$0 |= 8;
            }
        }
        return this.testData;
    }

    public Dataset<Row> testData() {
        if ((this.bitmap$0 & 8) == 0) {
            return this.testData$lzycompute();
        }
        return this.testData;
    }

    private Dataset<Row> testData2$lzycompute() {
        FetchErrorDetailsHandlerSuite fetchErrorDetailsHandlerSuite = this;
        synchronized (fetchErrorDetailsHandlerSuite) {
            if ((this.bitmap$0 & 0x10) == 0) {
                this.testData2 = SQLTestData.testData2$((SQLTestData)this);
                this.bitmap$0 |= 0x10;
            }
        }
        return this.testData2;
    }

    public Dataset<Row> testData2() {
        if ((this.bitmap$0 & 0x10) == 0) {
            return this.testData2$lzycompute();
        }
        return this.testData2;
    }

    private Dataset<Row> testData3$lzycompute() {
        FetchErrorDetailsHandlerSuite fetchErrorDetailsHandlerSuite = this;
        synchronized (fetchErrorDetailsHandlerSuite) {
            if ((this.bitmap$0 & 0x20) == 0) {
                this.testData3 = SQLTestData.testData3$((SQLTestData)this);
                this.bitmap$0 |= 0x20;
            }
        }
        return this.testData3;
    }

    public Dataset<Row> testData3() {
        if ((this.bitmap$0 & 0x20) == 0) {
            return this.testData3$lzycompute();
        }
        return this.testData3;
    }

    private Dataset<Row> negativeData$lzycompute() {
        FetchErrorDetailsHandlerSuite fetchErrorDetailsHandlerSuite = this;
        synchronized (fetchErrorDetailsHandlerSuite) {
            if ((this.bitmap$0 & 0x40) == 0) {
                this.negativeData = SQLTestData.negativeData$((SQLTestData)this);
                this.bitmap$0 |= 0x40;
            }
        }
        return this.negativeData;
    }

    public Dataset<Row> negativeData() {
        if ((this.bitmap$0 & 0x40) == 0) {
            return this.negativeData$lzycompute();
        }
        return this.negativeData;
    }

    private Dataset<Row> largeAndSmallInts$lzycompute() {
        FetchErrorDetailsHandlerSuite fetchErrorDetailsHandlerSuite = this;
        synchronized (fetchErrorDetailsHandlerSuite) {
            if ((this.bitmap$0 & 0x80) == 0) {
                this.largeAndSmallInts = SQLTestData.largeAndSmallInts$((SQLTestData)this);
                this.bitmap$0 |= 0x80;
            }
        }
        return this.largeAndSmallInts;
    }

    public Dataset<Row> largeAndSmallInts() {
        if ((this.bitmap$0 & 0x80) == 0) {
            return this.largeAndSmallInts$lzycompute();
        }
        return this.largeAndSmallInts;
    }

    private Dataset<Row> decimalData$lzycompute() {
        FetchErrorDetailsHandlerSuite fetchErrorDetailsHandlerSuite = this;
        synchronized (fetchErrorDetailsHandlerSuite) {
            if ((this.bitmap$0 & 0x100) == 0) {
                this.decimalData = SQLTestData.decimalData$((SQLTestData)this);
                this.bitmap$0 |= 0x100;
            }
        }
        return this.decimalData;
    }

    public Dataset<Row> decimalData() {
        if ((this.bitmap$0 & 0x100) == 0) {
            return this.decimalData$lzycompute();
        }
        return this.decimalData;
    }

    private Dataset<Row> binaryData$lzycompute() {
        FetchErrorDetailsHandlerSuite fetchErrorDetailsHandlerSuite = this;
        synchronized (fetchErrorDetailsHandlerSuite) {
            if ((this.bitmap$0 & 0x200) == 0) {
                this.binaryData = SQLTestData.binaryData$((SQLTestData)this);
                this.bitmap$0 |= 0x200;
            }
        }
        return this.binaryData;
    }

    public Dataset<Row> binaryData() {
        if ((this.bitmap$0 & 0x200) == 0) {
            return this.binaryData$lzycompute();
        }
        return this.binaryData;
    }

    private Dataset<Row> upperCaseData$lzycompute() {
        FetchErrorDetailsHandlerSuite fetchErrorDetailsHandlerSuite = this;
        synchronized (fetchErrorDetailsHandlerSuite) {
            if ((this.bitmap$0 & 0x400) == 0) {
                this.upperCaseData = SQLTestData.upperCaseData$((SQLTestData)this);
                this.bitmap$0 |= 0x400;
            }
        }
        return this.upperCaseData;
    }

    public Dataset<Row> upperCaseData() {
        if ((this.bitmap$0 & 0x400) == 0) {
            return this.upperCaseData$lzycompute();
        }
        return this.upperCaseData;
    }

    private Dataset<Row> lowerCaseData$lzycompute() {
        FetchErrorDetailsHandlerSuite fetchErrorDetailsHandlerSuite = this;
        synchronized (fetchErrorDetailsHandlerSuite) {
            if ((this.bitmap$0 & 0x800) == 0) {
                this.lowerCaseData = SQLTestData.lowerCaseData$((SQLTestData)this);
                this.bitmap$0 |= 0x800;
            }
        }
        return this.lowerCaseData;
    }

    public Dataset<Row> lowerCaseData() {
        if ((this.bitmap$0 & 0x800) == 0) {
            return this.lowerCaseData$lzycompute();
        }
        return this.lowerCaseData;
    }

    private Dataset<Row> lowerCaseDataWithDuplicates$lzycompute() {
        FetchErrorDetailsHandlerSuite fetchErrorDetailsHandlerSuite = this;
        synchronized (fetchErrorDetailsHandlerSuite) {
            if ((this.bitmap$0 & 0x1000) == 0) {
                this.lowerCaseDataWithDuplicates = SQLTestData.lowerCaseDataWithDuplicates$((SQLTestData)this);
                this.bitmap$0 |= 0x1000;
            }
        }
        return this.lowerCaseDataWithDuplicates;
    }

    public Dataset<Row> lowerCaseDataWithDuplicates() {
        if ((this.bitmap$0 & 0x1000) == 0) {
            return this.lowerCaseDataWithDuplicates$lzycompute();
        }
        return this.lowerCaseDataWithDuplicates;
    }

    private RDD<SQLTestData.ArrayData> arrayData$lzycompute() {
        FetchErrorDetailsHandlerSuite fetchErrorDetailsHandlerSuite = this;
        synchronized (fetchErrorDetailsHandlerSuite) {
            if ((this.bitmap$0 & 0x2000) == 0) {
                this.arrayData = SQLTestData.arrayData$((SQLTestData)this);
                this.bitmap$0 |= 0x2000;
            }
        }
        return this.arrayData;
    }

    public RDD<SQLTestData.ArrayData> arrayData() {
        if ((this.bitmap$0 & 0x2000) == 0) {
            return this.arrayData$lzycompute();
        }
        return this.arrayData;
    }

    private RDD<SQLTestData.MapData> mapData$lzycompute() {
        FetchErrorDetailsHandlerSuite fetchErrorDetailsHandlerSuite = this;
        synchronized (fetchErrorDetailsHandlerSuite) {
            if ((this.bitmap$0 & 0x4000) == 0) {
                this.mapData = SQLTestData.mapData$((SQLTestData)this);
                this.bitmap$0 |= 0x4000;
            }
        }
        return this.mapData;
    }

    public RDD<SQLTestData.MapData> mapData() {
        if ((this.bitmap$0 & 0x4000) == 0) {
            return this.mapData$lzycompute();
        }
        return this.mapData;
    }

    private RDD<SQLTestData.IntervalData> calendarIntervalData$lzycompute() {
        FetchErrorDetailsHandlerSuite fetchErrorDetailsHandlerSuite = this;
        synchronized (fetchErrorDetailsHandlerSuite) {
            if ((this.bitmap$0 & 0x8000) == 0) {
                this.calendarIntervalData = SQLTestData.calendarIntervalData$((SQLTestData)this);
                this.bitmap$0 |= 0x8000;
            }
        }
        return this.calendarIntervalData;
    }

    public RDD<SQLTestData.IntervalData> calendarIntervalData() {
        if ((this.bitmap$0 & 0x8000) == 0) {
            return this.calendarIntervalData$lzycompute();
        }
        return this.calendarIntervalData;
    }

    private RDD<SQLTestData.StringData> repeatedData$lzycompute() {
        FetchErrorDetailsHandlerSuite fetchErrorDetailsHandlerSuite = this;
        synchronized (fetchErrorDetailsHandlerSuite) {
            if ((this.bitmap$0 & 0x10000) == 0) {
                this.repeatedData = SQLTestData.repeatedData$((SQLTestData)this);
                this.bitmap$0 |= 0x10000;
            }
        }
        return this.repeatedData;
    }

    public RDD<SQLTestData.StringData> repeatedData() {
        if ((this.bitmap$0 & 0x10000) == 0) {
            return this.repeatedData$lzycompute();
        }
        return this.repeatedData;
    }

    private RDD<SQLTestData.StringData> nullableRepeatedData$lzycompute() {
        FetchErrorDetailsHandlerSuite fetchErrorDetailsHandlerSuite = this;
        synchronized (fetchErrorDetailsHandlerSuite) {
            if ((this.bitmap$0 & 0x20000) == 0) {
                this.nullableRepeatedData = SQLTestData.nullableRepeatedData$((SQLTestData)this);
                this.bitmap$0 |= 0x20000;
            }
        }
        return this.nullableRepeatedData;
    }

    public RDD<SQLTestData.StringData> nullableRepeatedData() {
        if ((this.bitmap$0 & 0x20000) == 0) {
            return this.nullableRepeatedData$lzycompute();
        }
        return this.nullableRepeatedData;
    }

    private Dataset<Row> nullInts$lzycompute() {
        FetchErrorDetailsHandlerSuite fetchErrorDetailsHandlerSuite = this;
        synchronized (fetchErrorDetailsHandlerSuite) {
            if ((this.bitmap$0 & 0x40000) == 0) {
                this.nullInts = SQLTestData.nullInts$((SQLTestData)this);
                this.bitmap$0 |= 0x40000;
            }
        }
        return this.nullInts;
    }

    public Dataset<Row> nullInts() {
        if ((this.bitmap$0 & 0x40000) == 0) {
            return this.nullInts$lzycompute();
        }
        return this.nullInts;
    }

    private Dataset<Row> allNulls$lzycompute() {
        FetchErrorDetailsHandlerSuite fetchErrorDetailsHandlerSuite = this;
        synchronized (fetchErrorDetailsHandlerSuite) {
            if ((this.bitmap$0 & 0x80000) == 0) {
                this.allNulls = SQLTestData.allNulls$((SQLTestData)this);
                this.bitmap$0 |= 0x80000;
            }
        }
        return this.allNulls;
    }

    public Dataset<Row> allNulls() {
        if ((this.bitmap$0 & 0x80000) == 0) {
            return this.allNulls$lzycompute();
        }
        return this.allNulls;
    }

    private Dataset<Row> nullStrings$lzycompute() {
        FetchErrorDetailsHandlerSuite fetchErrorDetailsHandlerSuite = this;
        synchronized (fetchErrorDetailsHandlerSuite) {
            if ((this.bitmap$0 & 0x100000) == 0) {
                this.nullStrings = SQLTestData.nullStrings$((SQLTestData)this);
                this.bitmap$0 |= 0x100000;
            }
        }
        return this.nullStrings;
    }

    public Dataset<Row> nullStrings() {
        if ((this.bitmap$0 & 0x100000) == 0) {
            return this.nullStrings$lzycompute();
        }
        return this.nullStrings;
    }

    private Dataset<Row> tableName$lzycompute() {
        FetchErrorDetailsHandlerSuite fetchErrorDetailsHandlerSuite = this;
        synchronized (fetchErrorDetailsHandlerSuite) {
            if ((this.bitmap$0 & 0x200000) == 0) {
                this.tableName = SQLTestData.tableName$((SQLTestData)this);
                this.bitmap$0 |= 0x200000;
            }
        }
        return this.tableName;
    }

    public Dataset<Row> tableName() {
        if ((this.bitmap$0 & 0x200000) == 0) {
            return this.tableName$lzycompute();
        }
        return this.tableName;
    }

    private RDD<String> unparsedStrings$lzycompute() {
        FetchErrorDetailsHandlerSuite fetchErrorDetailsHandlerSuite = this;
        synchronized (fetchErrorDetailsHandlerSuite) {
            if ((this.bitmap$0 & 0x400000) == 0) {
                this.unparsedStrings = SQLTestData.unparsedStrings$((SQLTestData)this);
                this.bitmap$0 |= 0x400000;
            }
        }
        return this.unparsedStrings;
    }

    public RDD<String> unparsedStrings() {
        if ((this.bitmap$0 & 0x400000) == 0) {
            return this.unparsedStrings$lzycompute();
        }
        return this.unparsedStrings;
    }

    private RDD<SQLTestData.IntField> withEmptyParts$lzycompute() {
        FetchErrorDetailsHandlerSuite fetchErrorDetailsHandlerSuite = this;
        synchronized (fetchErrorDetailsHandlerSuite) {
            if ((this.bitmap$0 & 0x800000) == 0) {
                this.withEmptyParts = SQLTestData.withEmptyParts$((SQLTestData)this);
                this.bitmap$0 |= 0x800000;
            }
        }
        return this.withEmptyParts;
    }

    public RDD<SQLTestData.IntField> withEmptyParts() {
        if ((this.bitmap$0 & 0x800000) == 0) {
            return this.withEmptyParts$lzycompute();
        }
        return this.withEmptyParts;
    }

    private Dataset<Row> person$lzycompute() {
        FetchErrorDetailsHandlerSuite fetchErrorDetailsHandlerSuite = this;
        synchronized (fetchErrorDetailsHandlerSuite) {
            if ((this.bitmap$0 & 0x1000000) == 0) {
                this.person = SQLTestData.person$((SQLTestData)this);
                this.bitmap$0 |= 0x1000000;
            }
        }
        return this.person;
    }

    public Dataset<Row> person() {
        if ((this.bitmap$0 & 0x1000000) == 0) {
            return this.person$lzycompute();
        }
        return this.person;
    }

    private Dataset<Row> salary$lzycompute() {
        FetchErrorDetailsHandlerSuite fetchErrorDetailsHandlerSuite = this;
        synchronized (fetchErrorDetailsHandlerSuite) {
            if ((this.bitmap$0 & 0x2000000) == 0) {
                this.salary = SQLTestData.salary$((SQLTestData)this);
                this.bitmap$0 |= 0x2000000;
            }
        }
        return this.salary;
    }

    public Dataset<Row> salary() {
        if ((this.bitmap$0 & 0x2000000) == 0) {
            return this.salary$lzycompute();
        }
        return this.salary;
    }

    private Dataset<Row> complexData$lzycompute() {
        FetchErrorDetailsHandlerSuite fetchErrorDetailsHandlerSuite = this;
        synchronized (fetchErrorDetailsHandlerSuite) {
            if ((this.bitmap$0 & 0x4000000) == 0) {
                this.complexData = SQLTestData.complexData$((SQLTestData)this);
                this.bitmap$0 |= 0x4000000;
            }
        }
        return this.complexData;
    }

    public Dataset<Row> complexData() {
        if ((this.bitmap$0 & 0x4000000) == 0) {
            return this.complexData$lzycompute();
        }
        return this.complexData;
    }

    private Dataset<Row> courseSales$lzycompute() {
        FetchErrorDetailsHandlerSuite fetchErrorDetailsHandlerSuite = this;
        synchronized (fetchErrorDetailsHandlerSuite) {
            if ((this.bitmap$0 & 0x8000000) == 0) {
                this.courseSales = SQLTestData.courseSales$((SQLTestData)this);
                this.bitmap$0 |= 0x8000000;
            }
        }
        return this.courseSales;
    }

    public Dataset<Row> courseSales() {
        if ((this.bitmap$0 & 0x8000000) == 0) {
            return this.courseSales$lzycompute();
        }
        return this.courseSales;
    }

    private Dataset<Row> trainingSales$lzycompute() {
        FetchErrorDetailsHandlerSuite fetchErrorDetailsHandlerSuite = this;
        synchronized (fetchErrorDetailsHandlerSuite) {
            if ((this.bitmap$0 & 0x10000000) == 0) {
                this.trainingSales = SQLTestData.trainingSales$((SQLTestData)this);
                this.bitmap$0 |= 0x10000000;
            }
        }
        return this.trainingSales;
    }

    public Dataset<Row> trainingSales() {
        if ((this.bitmap$0 & 0x10000000) == 0) {
            return this.trainingSales$lzycompute();
        }
        return this.trainingSales;
    }

    private Dataset<Row> intervalData$lzycompute() {
        FetchErrorDetailsHandlerSuite fetchErrorDetailsHandlerSuite = this;
        synchronized (fetchErrorDetailsHandlerSuite) {
            if ((this.bitmap$0 & 0x20000000) == 0) {
                this.intervalData = SQLTestData.intervalData$((SQLTestData)this);
                this.bitmap$0 |= 0x20000000;
            }
        }
        return this.intervalData;
    }

    public Dataset<Row> intervalData() {
        if ((this.bitmap$0 & 0x20000000) == 0) {
            return this.intervalData$lzycompute();
        }
        return this.intervalData;
    }

    public AbstractPatienceConfiguration.PatienceConfig org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig() {
        return this.org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig;
    }

    public final void org$scalatest$concurrent$PatienceConfiguration$_setter_$org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig_$eq(AbstractPatienceConfiguration.PatienceConfig x$1) {
        this.org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig = x$1;
    }

    public AbstractPatienceConfiguration$PatienceConfig$ PatienceConfig() {
        if (this.PatienceConfig$module == null) {
            this.PatienceConfig$lzycompute$1();
        }
        return this.PatienceConfig$module;
    }

    private String userId() {
        return this.userId;
    }

    private String sessionId() {
        return this.sessionId;
    }

    private FetchErrorDetailsResponse fetchErrorDetails(String userId, String sessionId, String errorId) {
        Promise promise = Promise$.MODULE$.apply();
        SparkConnectFetchErrorDetailsHandler handler = new SparkConnectFetchErrorDetailsHandler((StreamObserver)new FetchErrorDetailsResponseObserver((Promise<FetchErrorDetailsResponse>)promise));
        UserContext context = UserContext.newBuilder().setUserId(userId).build();
        FetchErrorDetailsRequest request = FetchErrorDetailsRequest.newBuilder().setUserContext(context).setSessionId(sessionId).setErrorId(errorId).build();
        handler.handle(request);
        return (FetchErrorDetailsResponse)ThreadUtils$.MODULE$.awaitResult((Awaitable)promise.future(), (Duration)new package.DurationInt(package$.MODULE$.DurationInt(5)).seconds());
    }

    private final void testImplicits$lzycompute$1() {
        FetchErrorDetailsHandlerSuite fetchErrorDetailsHandlerSuite = this;
        synchronized (fetchErrorDetailsHandlerSuite) {
            if (this.testImplicits$module == null) {
                this.testImplicits$module = new SQLTestUtilsBase$testImplicits$((SQLTestUtilsBase)this);
            }
        }
    }

    private final void org$apache$spark$sql$test$SQLTestData$$internalImplicits$lzycompute$1() {
        FetchErrorDetailsHandlerSuite fetchErrorDetailsHandlerSuite = this;
        synchronized (fetchErrorDetailsHandlerSuite) {
            if (this.internalImplicits$module == null) {
                this.internalImplicits$module = new SQLTestData$internalImplicits$((SQLTestData)this);
            }
        }
    }

    private final void PatienceConfig$lzycompute$1() {
        FetchErrorDetailsHandlerSuite fetchErrorDetailsHandlerSuite = this;
        synchronized (fetchErrorDetailsHandlerSuite) {
            if (this.PatienceConfig$module == null) {
                this.PatienceConfig$module = new AbstractPatienceConfiguration$PatienceConfig$((AbstractPatienceConfiguration)this);
            }
        }
    }

    public FetchErrorDetailsHandlerSuite() {
        ScaledTimeSpans.$init$((ScaledTimeSpans)this);
        AbstractPatienceConfiguration.$init$((AbstractPatienceConfiguration)this);
        PatienceConfiguration.$init$((PatienceConfiguration)this);
        Eventually.$init$((Eventually)this);
        SQLTestData.$init$((SQLTestData)this);
        AliasHelper.$init$((AliasHelper)this);
        PredicateHelper.$init$((PredicateHelper)this);
        SQLConfHelper.$init$((SQLConfHelper)this);
        SQLHelper.$init$((SQLHelper)this);
        PlanTestBase.$init$((PlanTestBase)this);
        SQLTestUtilsBase.$init$((SQLTestUtilsBase)this);
        SQLTestUtils.$init$((SQLTestUtils)this);
        SharedSparkSessionBase.$init$((SharedSparkSessionBase)this);
        SharedSparkSession.$init$((SharedSparkSession)this);
        ResourceHelper.$init$(this);
        this.userId = "user1";
        this.sessionId = UUID.randomUUID().toString();
        scala.package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapBooleanArray(new boolean[]{false, true})).foreach((Function1 & Serializable)serverStacktraceEnabled -> {
            this.test("error chain is properly constructed - " + BoxesRunTime.unboxToBoolean((Object)serverStacktraceEnabled), (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
                Assertion assertion;
                Exception testError = new Exception("test1", new Exception("test2"));
                String errorId = UUID.randomUUID().toString();
                SessionHolder sessionHolder = SparkConnectService$.MODULE$.getOrCreateIsolatedSession($this.userId(), $this.sessionId(), (Option)None$.MODULE$);
                sessionHolder.errorIdToError().put((Object)errorId, (Object)testError);
                sessionHolder.session().conf().set(Connect$.MODULE$.CONNECT_SERVER_STACKTRACE_ENABLED().key(), serverStacktraceEnabled);
                sessionHolder.session().conf().set(SQLConf$.MODULE$.PYSPARK_JVM_STACKTRACE_ENABLED().key(), false);
                try {
                    FetchErrorDetailsResponse response = $this.fetchErrorDetails($this.userId(), $this.sessionId(), errorId);
                    Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(response.hasRootErrorIdx(), "response.hasRootErrorIdx()", Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FetchErrorDetailsHandlerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 114));
                    int $org_scalatest_assert_macro_left = response.getRootErrorIdx();
                    int $org_scalatest_assert_macro_right = 0;
                    Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("FetchErrorDetailsHandlerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 115));
                    int $org_scalatest_assert_macro_left2 = response.getErrorsCount();
                    int $org_scalatest_assert_macro_right2 = 2;
                    Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("FetchErrorDetailsHandlerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 117));
                    String $org_scalatest_assert_macro_left3 = response.getErrors(0).getMessage();
                    String $org_scalatest_assert_macro_right3 = "test1";
                    String string = $org_scalatest_assert_macro_left3;
                    String string2 = $org_scalatest_assert_macro_right3;
                    Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("FetchErrorDetailsHandlerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 118));
                    int $org_scalatest_assert_macro_left4 = response.getErrors(0).getErrorTypeHierarchyCount();
                    int $org_scalatest_assert_macro_right4 = 3;
                    Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left4), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4 == $org_scalatest_assert_macro_right4, Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("FetchErrorDetailsHandlerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 119));
                    String $org_scalatest_assert_macro_left5 = response.getErrors(0).getErrorTypeHierarchy(0);
                    String $org_scalatest_assert_macro_right5 = Exception.class.getName();
                    String string3 = $org_scalatest_assert_macro_left5;
                    String string4 = $org_scalatest_assert_macro_right5;
                    Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", (Object)$org_scalatest_assert_macro_right5, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("FetchErrorDetailsHandlerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 120));
                    String $org_scalatest_assert_macro_left6 = response.getErrors(0).getErrorTypeHierarchy(1);
                    String $org_scalatest_assert_macro_right6 = Throwable.class.getName();
                    String string5 = $org_scalatest_assert_macro_left6;
                    String string6 = $org_scalatest_assert_macro_right6;
                    Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "==", (Object)$org_scalatest_assert_macro_right6, !(string5 != null ? !string5.equals(string6) : string6 != null), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("FetchErrorDetailsHandlerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 121));
                    String $org_scalatest_assert_macro_left7 = response.getErrors(0).getErrorTypeHierarchy(2);
                    String $org_scalatest_assert_macro_right7 = Object.class.getName();
                    String string7 = $org_scalatest_assert_macro_left7;
                    String string8 = $org_scalatest_assert_macro_right7;
                    Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left7, "==", (Object)$org_scalatest_assert_macro_right7, !(string7 != null ? !string7.equals(string8) : string8 != null), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("FetchErrorDetailsHandlerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 122));
                    Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.simpleMacroBool(response.getErrors(0).hasCauseIdx(), "response.getErrors(0).hasCauseIdx()", Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("FetchErrorDetailsHandlerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 123));
                    int $org_scalatest_assert_macro_left8 = response.getErrors(0).getCauseIdx();
                    int $org_scalatest_assert_macro_right8 = 1;
                    Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left8), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right8), $org_scalatest_assert_macro_left8 == $org_scalatest_assert_macro_right8, Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("FetchErrorDetailsHandlerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 124));
                    String $org_scalatest_assert_macro_left9 = response.getErrors(1).getMessage();
                    String $org_scalatest_assert_macro_right9 = "test2";
                    String string9 = $org_scalatest_assert_macro_left9;
                    String string10 = $org_scalatest_assert_macro_right9;
                    Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "==", (Object)$org_scalatest_assert_macro_right9, !(string9 != null ? !string9.equals(string10) : string10 != null), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("FetchErrorDetailsHandlerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 126));
                    int $org_scalatest_assert_macro_left10 = response.getErrors(1).getErrorTypeHierarchyCount();
                    int $org_scalatest_assert_macro_right10 = 3;
                    Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left10), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right10), $org_scalatest_assert_macro_left10 == $org_scalatest_assert_macro_right10, Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("FetchErrorDetailsHandlerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 127));
                    String $org_scalatest_assert_macro_left11 = response.getErrors(1).getErrorTypeHierarchy(0);
                    String $org_scalatest_assert_macro_right11 = Exception.class.getName();
                    String string11 = $org_scalatest_assert_macro_left11;
                    String string12 = $org_scalatest_assert_macro_right11;
                    Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left11, "==", (Object)$org_scalatest_assert_macro_right11, !(string11 != null ? !string11.equals(string12) : string12 != null), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"", Prettifier$.MODULE$.default(), new Position("FetchErrorDetailsHandlerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 128));
                    String $org_scalatest_assert_macro_left12 = response.getErrors(1).getErrorTypeHierarchy(1);
                    String $org_scalatest_assert_macro_right12 = Throwable.class.getName();
                    String string13 = $org_scalatest_assert_macro_left12;
                    String string14 = $org_scalatest_assert_macro_right12;
                    Bool $org_scalatest_assert_macro_expr14 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left12, "==", (Object)$org_scalatest_assert_macro_right12, !(string13 != null ? !string13.equals(string14) : string14 != null), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr14, (Object)"", Prettifier$.MODULE$.default(), new Position("FetchErrorDetailsHandlerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 129));
                    String $org_scalatest_assert_macro_left13 = response.getErrors(1).getErrorTypeHierarchy(2);
                    String $org_scalatest_assert_macro_right13 = Object.class.getName();
                    String string15 = $org_scalatest_assert_macro_left13;
                    String string16 = $org_scalatest_assert_macro_right13;
                    Bool $org_scalatest_assert_macro_expr15 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left13, "==", (Object)$org_scalatest_assert_macro_right13, !(string15 != null ? !string15.equals(string16) : string16 != null), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr15, (Object)"", Prettifier$.MODULE$.default(), new Position("FetchErrorDetailsHandlerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 130));
                    Bool $org_scalatest_assert_macro_expr16 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(response.getErrors(1).hasCauseIdx(), "response.getErrors(1).hasCauseIdx()", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr16, (Object)"", Prettifier$.MODULE$.default(), new Position("FetchErrorDetailsHandlerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 131));
                    int $org_scalatest_assert_macro_left14 = response.getErrors(0).getStackTraceCount();
                    int $org_scalatest_assert_macro_right14 = testError.getStackTrace().length;
                    Bool $org_scalatest_assert_macro_expr17 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left14), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right14), $org_scalatest_assert_macro_left14 == $org_scalatest_assert_macro_right14, Prettifier$.MODULE$.default());
                    Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr17, (Object)"", Prettifier$.MODULE$.default(), new Position("FetchErrorDetailsHandlerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 132));
                    int $org_scalatest_assert_macro_left15 = response.getErrors(1).getStackTraceCount();
                    int $org_scalatest_assert_macro_right15 = testError.getCause().getStackTrace().length;
                    Bool $org_scalatest_assert_macro_expr18 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left15), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right15), $org_scalatest_assert_macro_left15 == $org_scalatest_assert_macro_right15, Prettifier$.MODULE$.default());
                    assertion = Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr18, (Object)"", Prettifier$.MODULE$.default(), new Position("FetchErrorDetailsHandlerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 133));
                }
                finally {
                    sessionHolder.session().conf().unset(Connect$.MODULE$.CONNECT_SERVER_STACKTRACE_ENABLED().key());
                    sessionHolder.session().conf().unset(SQLConf$.MODULE$.PYSPARK_JVM_STACKTRACE_ENABLED().key());
                }
                return assertion;
            }, new Position("FetchErrorDetailsHandlerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 98));
            return BoxedUnit.UNIT;
        });
        this.test("error not found", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            FetchErrorDetailsResponse response = this.fetchErrorDetails(this.userId(), this.sessionId(), UUID.randomUUID().toString());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(response.hasRootErrorIdx(), "response.hasRootErrorIdx()", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FetchErrorDetailsHandlerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 146));
        }, new Position("FetchErrorDetailsHandlerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 144));
        this.test("invalidate cached exceptions after first request", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            Exception testError = new Exception("test1");
            String errorId = UUID.randomUUID().toString();
            SparkConnectService$.MODULE$.getOrCreateIsolatedSession(this.userId(), this.sessionId(), (Option)None$.MODULE$).errorIdToError().put((Object)errorId, (Object)testError);
            FetchErrorDetailsResponse response = this.fetchErrorDetails(this.userId(), this.sessionId(), errorId);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(response.hasRootErrorIdx(), "response.hasRootErrorIdx()", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FetchErrorDetailsHandlerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 159));
            int $org_scalatest_assert_macro_left = response.getRootErrorIdx();
            int $org_scalatest_assert_macro_right = 0;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("FetchErrorDetailsHandlerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 160));
            int $org_scalatest_assert_macro_left2 = response.getErrorsCount();
            int $org_scalatest_assert_macro_right2 = 1;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("FetchErrorDetailsHandlerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 162));
            String $org_scalatest_assert_macro_left3 = response.getErrors(0).getMessage();
            String $org_scalatest_assert_macro_right3 = "test1";
            String string = $org_scalatest_assert_macro_left3;
            String string2 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("FetchErrorDetailsHandlerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 163));
            Cache $org_scalatest_assert_macro_left4 = SparkConnectService$.MODULE$.getOrCreateIsolatedSession(this.userId(), this.sessionId(), (Option)None$.MODULE$).errorIdToError();
            int $org_scalatest_assert_macro_right4 = 0;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left4, "size", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left4.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("FetchErrorDetailsHandlerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 165));
        }, new Position("FetchErrorDetailsHandlerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 149));
        this.test("error chain is truncated after reaching max depth", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            ObjectRef testError = ObjectRef.create((Object)new Exception("test"));
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 2 * ErrorUtils$.MODULE$.MAX_ERROR_CHAIN_LENGTH()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                String errorId = UUID.randomUUID().toString();
                SparkConnectService$.MODULE$.getOrCreateIsolatedSession(this.userId(), this.sessionId(), (Option)None$.MODULE$).errorIdToError().put((Object)errorId, (Object)((Exception)testError$1.elem));
                FetchErrorDetailsResponse response = this.fetchErrorDetails(this.userId(), this.sessionId(), errorId);
                int expectedErrorCount = Math.min(i + 1, ErrorUtils$.MODULE$.MAX_ERROR_CHAIN_LENGTH());
                int $org_scalatest_assert_macro_left = response.getErrorsCount();
                int $org_scalatest_assert_macro_right = expectedErrorCount;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FetchErrorDetailsHandlerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 184));
                boolean $org_scalatest_assert_macro_left2 = response.getErrors(expectedErrorCount - 1).hasCauseIdx();
                boolean $org_scalatest_assert_macro_right2 = false;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("FetchErrorDetailsHandlerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 185));
                testError$1.elem = new Exception("test" + i, (Exception)testError$1.elem);
            });
        }, new Position("FetchErrorDetailsHandlerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 172));
        this.test("null filename in stack trace elements", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            Exception testError = new Exception("test");
            StackTraceElement[] stackTrace = testError.getStackTrace();
            stackTrace[0] = new StackTraceElement(stackTrace[0].getClassName(), stackTrace[0].getMethodName(), null, stackTrace[0].getLineNumber());
            testError.setStackTrace(stackTrace);
            String errorId = UUID.randomUUID().toString();
            SparkConnectService$.MODULE$.getOrCreateIsolatedSession(this.userId(), this.sessionId(), (Option)None$.MODULE$).errorIdToError().put((Object)errorId, (Object)testError);
            FetchErrorDetailsResponse response = this.fetchErrorDetails(this.userId(), this.sessionId(), errorId);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(response.hasRootErrorIdx(), "response.hasRootErrorIdx()", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FetchErrorDetailsHandlerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 209));
            int $org_scalatest_assert_macro_left = response.getRootErrorIdx();
            int $org_scalatest_assert_macro_right = 0;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("FetchErrorDetailsHandlerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 210));
            int $org_scalatest_assert_macro_left2 = response.getErrors(0).getStackTraceCount();
            int $org_scalatest_assert_macro_right2 = 0;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), ">", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 > $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("FetchErrorDetailsHandlerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 212));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(response.getErrors(0).getStackTrace(0).hasFileName(), "response.getErrors(0).getStackTrace(0).hasFileName()", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("FetchErrorDetailsHandlerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 213));
        }, new Position("FetchErrorDetailsHandlerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 191));
        this.test("error framework parameters are set", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            AnalysisException testError = (AnalysisException)Try$.MODULE$.apply((Function0 & Serializable)() -> this.spark().sql("select x")).failed().get();
            String errorId = UUID.randomUUID().toString();
            SparkConnectService$.MODULE$.getOrCreateIsolatedSession(this.userId(), this.sessionId(), (Option)None$.MODULE$).errorIdToError().put((Object)errorId, (Object)testError);
            FetchErrorDetailsResponse response = this.fetchErrorDetails(this.userId(), this.sessionId(), errorId);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(response.hasRootErrorIdx(), "response.hasRootErrorIdx()", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FetchErrorDetailsHandlerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 226));
            int $org_scalatest_assert_macro_left = response.getRootErrorIdx();
            int $org_scalatest_assert_macro_right = 0;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("FetchErrorDetailsHandlerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 227));
            FetchErrorDetailsResponse.SparkThrowable sparkThrowableProto = response.getErrors(0).getSparkThrowable();
            String $org_scalatest_assert_macro_left2 = sparkThrowableProto.getErrorClass();
            String $org_scalatest_assert_macro_right2 = (String)testError.errorClass().get();
            String string = $org_scalatest_assert_macro_left2;
            String string2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("FetchErrorDetailsHandlerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 230));
            Map $org_scalatest_assert_macro_left3 = sparkThrowableProto.getMessageParametersMap();
            Map $org_scalatest_assert_macro_right3 = testError.getMessageParameters();
            Map map = $org_scalatest_assert_macro_left3;
            Map map2 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(map != null ? !((Object)map).equals(map2) : map2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("FetchErrorDetailsHandlerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 231));
            String $org_scalatest_assert_macro_left4 = sparkThrowableProto.getSqlState();
            String $org_scalatest_assert_macro_right4 = testError.getSqlState();
            String string3 = $org_scalatest_assert_macro_left4;
            String string4 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("FetchErrorDetailsHandlerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 232));
        }, new Position("FetchErrorDetailsHandlerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 216));
        this.test("breaking change info is not present when error has no breaking change", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            AnalysisException testError = new AnalysisException("UNSUPPORTED_FEATURE.DESC_TABLE_COLUMN_JSON", Predef$.MODULE$.Map().empty());
            String errorId = UUID.randomUUID().toString();
            SessionHolder sessionHolder = SparkConnectService$.MODULE$.getOrCreateIsolatedSession(this.userId(), this.sessionId(), (Option)None$.MODULE$);
            sessionHolder.errorIdToError().put((Object)errorId, (Object)testError);
            FetchErrorDetailsResponse response = this.fetchErrorDetails(this.userId(), this.sessionId(), errorId);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(response.hasRootErrorIdx(), "response.hasRootErrorIdx()", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FetchErrorDetailsHandlerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 247));
            FetchErrorDetailsResponse.SparkThrowable sparkThrowableProto = response.getErrors(0).getSparkThrowable();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(sparkThrowableProto.hasBreakingChangeInfo(), "sparkThrowableProto.hasBreakingChangeInfo()", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("FetchErrorDetailsHandlerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 249));
        }, new Position("FetchErrorDetailsHandlerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 235));
        this.test("breaking change info serialization works for errors with breaking change", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            AnalysisException testError = (AnalysisException)Try$.MODULE$.apply((Function0 & Serializable)() -> this.spark().sql("select x")).failed().get();
            String errorId = UUID.randomUUID().toString();
            SparkConnectService$.MODULE$.getOrCreateIsolatedSession(this.userId(), this.sessionId(), (Option)None$.MODULE$).errorIdToError().put((Object)errorId, (Object)testError);
            FetchErrorDetailsResponse response = this.fetchErrorDetails(this.userId(), this.sessionId(), errorId);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(response.hasRootErrorIdx(), "response.hasRootErrorIdx()", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FetchErrorDetailsHandlerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 271));
            FetchErrorDetailsResponse.SparkThrowable sparkThrowableProto = response.getErrors(0).getSparkThrowable();
            String $org_scalatest_assert_macro_left = sparkThrowableProto.getErrorClass();
            String $org_scalatest_assert_macro_right = (String)testError.errorClass().get();
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("FetchErrorDetailsHandlerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 279));
        }, new Position("FetchErrorDetailsHandlerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 252));
        this.test("throwableToFetchErrorDetailsResponse includes breaking change info", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            .colon.colon migrationMessages = new .colon.colon((Object)"Please update your code to use new API", (List)new .colon.colon((Object)"See documentation for details", (List)Nil$.MODULE$));
            Some mitigationConfig = new Some((Object)new MitigationConfig("spark.sql.legacy.behavior.enabled", "true"));
            BreakingChangeInfo breakingChangeInfo = new BreakingChangeInfo((Seq)migrationMessages, (Option)mitigationConfig, false);
            TestSparkThrowableWithBreakingChange testError = new TestSparkThrowableWithBreakingChange("TEST_BREAKING_CHANGE_ERROR", (scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"param"), (Object)"value")}))), (Option<BreakingChangeInfo>)new Some((Object)breakingChangeInfo));
            FetchErrorDetailsResponse response = ErrorUtils$.MODULE$.throwableToFetchErrorDetailsResponse((Throwable)testError, false);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(response.hasRootErrorIdx(), "response.hasRootErrorIdx()", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FetchErrorDetailsHandlerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 306));
            int $org_scalatest_assert_macro_left = response.getRootErrorIdx();
            int $org_scalatest_assert_macro_right = 0;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("FetchErrorDetailsHandlerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 307));
            int $org_scalatest_assert_macro_left2 = response.getErrorsCount();
            int $org_scalatest_assert_macro_right2 = 1;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("FetchErrorDetailsHandlerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 308));
            FetchErrorDetailsResponse.Error error = response.getErrors(0);
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(error.hasSparkThrowable(), "error.hasSparkThrowable()", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("FetchErrorDetailsHandlerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 311));
            FetchErrorDetailsResponse.SparkThrowable sparkThrowableProto = error.getSparkThrowable();
            String $org_scalatest_assert_macro_left3 = sparkThrowableProto.getErrorClass();
            String $org_scalatest_assert_macro_right3 = "TEST_BREAKING_CHANGE_ERROR";
            String string = $org_scalatest_assert_macro_left3;
            String string2 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("FetchErrorDetailsHandlerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 314));
            Bool $org_scalatest_assert_macro_expr6 = Bool$.MODULE$.simpleMacroBool(sparkThrowableProto.hasBreakingChangeInfo(), "sparkThrowableProto.hasBreakingChangeInfo()", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr6, (Object)"", Prettifier$.MODULE$.default(), new Position("FetchErrorDetailsHandlerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 315));
            FetchErrorDetailsResponse.BreakingChangeInfo bciProto = sparkThrowableProto.getBreakingChangeInfo();
            int $org_scalatest_assert_macro_left4 = bciProto.getMigrationMessageCount();
            int $org_scalatest_assert_macro_right4 = 2;
            Bool $org_scalatest_assert_macro_expr7 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left4), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4 == $org_scalatest_assert_macro_right4, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr7, (Object)"", Prettifier$.MODULE$.default(), new Position("FetchErrorDetailsHandlerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 318));
            String $org_scalatest_assert_macro_left5 = bciProto.getMigrationMessage(0);
            String $org_scalatest_assert_macro_right5 = "Please update your code to use new API";
            String string3 = $org_scalatest_assert_macro_left5;
            String string4 = $org_scalatest_assert_macro_right5;
            Bool $org_scalatest_assert_macro_expr8 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", (Object)$org_scalatest_assert_macro_right5, !(string3 != null ? !string3.equals(string4) : string4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr8, (Object)"", Prettifier$.MODULE$.default(), new Position("FetchErrorDetailsHandlerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 319));
            String $org_scalatest_assert_macro_left6 = bciProto.getMigrationMessage(1);
            String $org_scalatest_assert_macro_right6 = "See documentation for details";
            String string5 = $org_scalatest_assert_macro_left6;
            String string6 = $org_scalatest_assert_macro_right6;
            Bool $org_scalatest_assert_macro_expr9 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left6, "==", (Object)$org_scalatest_assert_macro_right6, !(string5 != null ? !string5.equals(string6) : string6 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr9, (Object)"", Prettifier$.MODULE$.default(), new Position("FetchErrorDetailsHandlerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 320));
            boolean $org_scalatest_assert_macro_left7 = bciProto.getNeedsAudit();
            boolean $org_scalatest_assert_macro_right7 = false;
            Bool $org_scalatest_assert_macro_expr10 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_left7), "==", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right7), $org_scalatest_assert_macro_left7 == $org_scalatest_assert_macro_right7, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr10, (Object)"", Prettifier$.MODULE$.default(), new Position("FetchErrorDetailsHandlerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 321));
            Bool $org_scalatest_assert_macro_expr11 = Bool$.MODULE$.simpleMacroBool(bciProto.hasMitigationConfig(), "bciProto.hasMitigationConfig()", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr11, (Object)"", Prettifier$.MODULE$.default(), new Position("FetchErrorDetailsHandlerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 323));
            FetchErrorDetailsResponse.MitigationConfig mitigationConfigProto = bciProto.getMitigationConfig();
            String $org_scalatest_assert_macro_left8 = mitigationConfigProto.getKey();
            String $org_scalatest_assert_macro_right8 = "spark.sql.legacy.behavior.enabled";
            String string7 = $org_scalatest_assert_macro_left8;
            String string8 = $org_scalatest_assert_macro_right8;
            Bool $org_scalatest_assert_macro_expr12 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left8, "==", (Object)$org_scalatest_assert_macro_right8, !(string7 != null ? !string7.equals(string8) : string8 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr12, (Object)"", Prettifier$.MODULE$.default(), new Position("FetchErrorDetailsHandlerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 325));
            String $org_scalatest_assert_macro_left9 = mitigationConfigProto.getValue();
            String $org_scalatest_assert_macro_right9 = "true";
            String string9 = $org_scalatest_assert_macro_left9;
            String string10 = $org_scalatest_assert_macro_right9;
            Bool $org_scalatest_assert_macro_expr13 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left9, "==", (Object)$org_scalatest_assert_macro_right9, !(string9 != null ? !string9.equals(string10) : string10 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr13, (Object)"", Prettifier$.MODULE$.default(), new Position("FetchErrorDetailsHandlerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 326));
        }, new Position("FetchErrorDetailsHandlerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 290));
        this.test("throwableToFetchErrorDetailsResponse without breaking change info", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            TestSparkThrowableWithBreakingChange testError = new TestSparkThrowableWithBreakingChange("REGULAR_ERROR", (scala.collection.immutable.Map<String, String>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"param"), (Object)"value")}))), (Option<BreakingChangeInfo>)None$.MODULE$);
            FetchErrorDetailsResponse response = ErrorUtils$.MODULE$.throwableToFetchErrorDetailsResponse((Throwable)testError, false);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(response.hasRootErrorIdx(), "response.hasRootErrorIdx()", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FetchErrorDetailsHandlerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 336));
            FetchErrorDetailsResponse.SparkThrowable sparkThrowableProto = response.getErrors(0).getSparkThrowable();
            String $org_scalatest_assert_macro_left = sparkThrowableProto.getErrorClass();
            String $org_scalatest_assert_macro_right = "REGULAR_ERROR";
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("FetchErrorDetailsHandlerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 338));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(sparkThrowableProto.hasBreakingChangeInfo(), "sparkThrowableProto.hasBreakingChangeInfo()", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("FetchErrorDetailsHandlerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 339));
        }, new Position("FetchErrorDetailsHandlerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 329));
        this.test("throwableToFetchErrorDetailsResponse with breaking change info without mitigation config", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            .colon.colon migrationMessages = new .colon.colon((Object)"Migration message only", (List)Nil$.MODULE$);
            BreakingChangeInfo breakingChangeInfo = new BreakingChangeInfo((Seq)migrationMessages, (Option)None$.MODULE$, true);
            TestSparkThrowableWithBreakingChange testError = new TestSparkThrowableWithBreakingChange("TEST_BREAKING_CHANGE_NO_MITIGATION", (scala.collection.immutable.Map<String, String>)Predef$.MODULE$.Map().empty(), (Option<BreakingChangeInfo>)new Some((Object)breakingChangeInfo));
            FetchErrorDetailsResponse response = ErrorUtils$.MODULE$.throwableToFetchErrorDetailsResponse((Throwable)testError, false);
            FetchErrorDetailsResponse.BreakingChangeInfo bciProto = response.getErrors(0).getSparkThrowable().getBreakingChangeInfo();
            int $org_scalatest_assert_macro_left = bciProto.getMigrationMessageCount();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FetchErrorDetailsHandlerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 356));
            String $org_scalatest_assert_macro_left2 = bciProto.getMigrationMessage(0);
            String $org_scalatest_assert_macro_right2 = "Migration message only";
            String string = $org_scalatest_assert_macro_left2;
            String string2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("FetchErrorDetailsHandlerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 357));
            boolean $org_scalatest_assert_macro_left3 = bciProto.getNeedsAudit();
            boolean $org_scalatest_assert_macro_right3 = true;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToBoolean((boolean)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3 == $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("FetchErrorDetailsHandlerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 358));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(bciProto.hasMitigationConfig(), "bciProto.hasMitigationConfig()", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("FetchErrorDetailsHandlerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 359));
        }, new Position("FetchErrorDetailsHandlerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 343));
        this.test("throwableToFetchErrorDetailsResponse with non-SparkThrowable", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            RuntimeException testError = new RuntimeException("Regular runtime exception");
            FetchErrorDetailsResponse response = ErrorUtils$.MODULE$.throwableToFetchErrorDetailsResponse((Throwable)testError, false);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(response.hasRootErrorIdx(), "response.hasRootErrorIdx()", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("FetchErrorDetailsHandlerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 368));
            FetchErrorDetailsResponse.Error error = response.getErrors(0);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(error.hasSparkThrowable(), "error.hasSparkThrowable()", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("FetchErrorDetailsHandlerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 370));
            String $org_scalatest_assert_macro_left = error.getMessage();
            String $org_scalatest_assert_macro_right = "Regular runtime exception";
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("FetchErrorDetailsHandlerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 371));
        }, new Position("FetchErrorDetailsHandlerSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 362));
        Statics.releaseFence();
    }
}

