/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connect;

import com.google.protobuf.ByteString;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import java.io.Serializable;
import java.util.TimeZone;
import java.util.UUID;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.connect.proto.Command;
import org.apache.spark.connect.proto.ExecutePlanRequest;
import org.apache.spark.connect.proto.ExecutePlanResponse;
import org.apache.spark.connect.proto.LocalRelation;
import org.apache.spark.connect.proto.Plan;
import org.apache.spark.connect.proto.ReattachExecuteRequest;
import org.apache.spark.connect.proto.ReattachOptions;
import org.apache.spark.connect.proto.Relation;
import org.apache.spark.connect.proto.ReleaseSessionRequest;
import org.apache.spark.connect.proto.SparkConnectServiceGrpc;
import org.apache.spark.connect.proto.SqlCommand;
import org.apache.spark.connect.proto.UserContext;
import org.apache.spark.sql.catalyst.ScalaReflection$;
import org.apache.spark.sql.catalyst.encoders.AgnosticEncoder;
import org.apache.spark.sql.connect.client.CloseableIterator;
import org.apache.spark.sql.connect.client.CustomSparkConnectBlockingStub;
import org.apache.spark.sql.connect.client.ExecutePlanResponseReattachableIterator;
import org.apache.spark.sql.connect.client.ExecutePlanResponseReattachableIterator$;
import org.apache.spark.sql.connect.client.RetryPolicy;
import org.apache.spark.sql.connect.client.RetryPolicy$;
import org.apache.spark.sql.connect.client.SparkConnectClient;
import org.apache.spark.sql.connect.client.SparkConnectClient$;
import org.apache.spark.sql.connect.client.SparkConnectStubState;
import org.apache.spark.sql.connect.client.arrow.ArrowSerializer$;
import org.apache.spark.sql.connect.common.config.ConnectCommon$;
import org.apache.spark.sql.connect.config.Connect$;
import org.apache.spark.sql.connect.dsl.package;
import org.apache.spark.sql.connect.dsl.package$plans$;
import org.apache.spark.sql.connect.service.ExecuteHolder;
import org.apache.spark.sql.connect.service.ExecuteInfo;
import org.apache.spark.sql.connect.service.SparkConnectService$;
import org.apache.spark.sql.test.SharedSparkSession;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions;
import org.scalatest.Assertions$;
import org.scalatest.concurrent.Eventually$;
import org.scalatest.concurrent.Signaler$;
import org.scalatest.concurrent.TimeLimits$;
import org.scalatest.enablers.Retrying$;
import org.scalatest.enablers.Timed$;
import org.scalatest.time.Span;
import org.scalatest.time.SpanSugar$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.reflect.api.TypeTags;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Random$;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0005\r\raa\u0002\u00192!\u0003\r\t\u0001\u0010\u0005\u0006\u000f\u0002!\t\u0001\u0013\u0005\b\u001f\u0002\u0011\r\u0011\"\u0001Q\u0011\u001d!\u0006A1A\u0005\u0002UCqA\u0018\u0001C\u0002\u0013\u0005q\fC\u0003i\u0001\u0011\u0005\u0003\nC\u0003j\u0001\u0011\u0005\u0003\nC\u0003k\u0001\u0011E\u0003\nC\u0003l\u0001\u0011E\u0003\nC\u0003m\u0001\u0011E\u0001\nC\u0004n\u0001\t\u0007I\u0011\u00038\t\u000f]\u0004!\u0019!C\t]\"9\u0001\u0010\u0001b\u0001\n#I\b\"CA\u0012\u0001\t\u0007I\u0011CA\u0013\u0011\u001d\t)\u0004\u0001C\t\u0003oA\u0011\"a\u0018\u0001#\u0003%\t\"!\u0019\t\u0013\u0005]\u0004!%A\u0005\u0012\u0005\u0005\u0004bBA=\u0001\u0011E\u00111\u0010\u0005\b\u0003\u001f\u0003A\u0011CAI\u0011%\t)\u000bAI\u0001\n#\t\t\u0007C\u0005\u0002(\u0002\t\n\u0011\"\u0005\u0002*\"9\u0011Q\u0016\u0001\u0005\u0012\u0005=\u0006bBA[\u0001\u0011E\u0011q\u0017\u0005\b\u0003{\u0003A\u0011CA`\u0011\u001d\u0011i\u0002\u0001C\t\u0005?AaA!\u0010\u0001\t#A\u0005B\u0002B \u0001\u0011E\u0001\n\u0003\u0004\u0003B\u0001!\t\u0002\u0013\u0005\u0007\u0005\u0007\u0002A\u0011\u0003%\t\u000f\t\u0015\u0003\u0001\"\u0005\u0003H!9!1\n\u0001\u0005\u0012\t5\u0003b\u0002B)\u0001\u0011E!1\u000b\u0005\b\u0005C\u0002A\u0011\u0003B*\u0011\u001d\u0011\u0019\u0007\u0001C\t\u0005KB\u0011Ba \u0001#\u0003%\t\"!\u0019\t\u0013\t\u0005\u0005!%A\u0005\u0012\u0005\u0005\u0004b\u0002B2\u0001\u0011E!1\u0011\u0005\b\u0005G\u0002A\u0011\u0003BD\u0011\u001d\u0011y\t\u0001C\t\u0005#CqAa+\u0001\t#\u0011i\u000bC\u0005\u0003H\u0002\t\n\u0011\"\u0005\u0003J\"9!Q\u001a\u0001\u0005\u0012\t=\u0007b\u0002Bg\u0001\u0011E!\u0011\u001d\u0005\n\u0005S\u0004\u0011\u0013!C\t\u0005WDQBa<\u0001!\u0003\r\t\u0011!C\u0005\u0011\nE\b\"\u0004Bz\u0001A\u0005\u0019\u0011!A\u0005\n!\u0013)\u0010C\u0007\u0003x\u0002\u0001\n1!A\u0001\n\u0013A%\u0011 \u0005\u000e\u0005\u007f\u0004\u0001\u0013aA\u0001\u0002\u0013%\u0001j!\u0001\u0003-M\u0003\u0018M]6D_:tWm\u0019;TKJ4XM\u001d+fgRT!AM\u001a\u0002\u000f\r|gN\\3di*\u0011A'N\u0001\u0004gFd'B\u0001\u001c8\u0003\u0015\u0019\b/\u0019:l\u0015\tA\u0014(\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002u\u0005\u0019qN]4\u0004\u0001M\u0019\u0001!P!\u0011\u0005yzT\"A\u001b\n\u0005\u0001+$!D*qCJ\\g)\u001e8Tk&$X\r\u0005\u0002C\u000b6\t1I\u0003\u0002Eg\u0005!A/Z:u\u0013\t15I\u0001\nTQ\u0006\u0014X\rZ*qCJ\\7+Z:tS>t\u0017A\u0002\u0013j]&$H\u0005F\u0001J!\tQU*D\u0001L\u0015\u0005a\u0015!B:dC2\f\u0017B\u0001(L\u0005\u0011)f.\u001b;\u0002\u0015M,'O^3s!>\u0014H/F\u0001R!\tQ%+\u0003\u0002T\u0017\n\u0019\u0011J\u001c;\u0002#\u00154XM\u001c;vC2d\u0017\u0010V5nK>,H/F\u0001W!\t9F,D\u0001Y\u0015\tI&,\u0001\u0003uS6,'BA.:\u0003%\u00198-\u00197bi\u0016\u001cH/\u0003\u0002^1\n!1\u000b]1o\u0003%\tG\u000e\\8dCR|'/F\u0001a!\t\tg-D\u0001c\u0015\t\u0019G-\u0001\u0004nK6|'/\u001f\u0006\u0003K^\nQ!\u0019:s_^L!a\u001a2\u0003\u001bI{w\u000e^!mY>\u001c\u0017\r^8s\u0003%\u0011WMZ8sK\u0006cG.\u0001\u0005bMR,'/\u00117m\u0003)\u0011WMZ8sK\u0016\u000b7\r[\u0001\nC\u001a$XM]#bG\"\f!c\u00197fCJ\fE\u000e\\#yK\u000e,H/[8og\u0006\u0001B-\u001a4bk2$8+Z:tS>t\u0017\nZ\u000b\u0002_B\u0011\u0001/^\u0007\u0002c*\u0011!o]\u0001\u0005Y\u0006twMC\u0001u\u0003\u0011Q\u0017M^1\n\u0005Y\f(AB*ue&tw-A\u0007eK\u001a\fW\u000f\u001c;Vg\u0016\u0014\u0018\nZ\u0001\u0004INdW#\u0001>\u0011\u0007m\fiBD\u0002}\u0003/q1!`A\u000b\u001d\rq\u00181\u0003\b\u0004\u007f\u0006Ea\u0002BA\u0001\u0003\u001fqA!a\u0001\u0002\u000e9!\u0011QAA\u0006\u001b\t\t9AC\u0002\u0002\nm\na\u0001\u0010:p_Rt\u0014\"\u0001\u001e\n\u0005aJ\u0014B\u0001\u001c8\u0013\t!T'\u0003\u00023g%\u0011\u00010M\u0005\u0005\u00033\tY\"A\u0004qC\u000e\\\u0017mZ3\u000b\u0005a\f\u0014\u0002BA\u0010\u0003C\u0011\u0011#T8dWJ+Wn\u001c;f'\u0016\u001c8/[8o\u0015\u0011\tI\"a\u0007\u0002\u0017U\u001cXM]\"p]R,\u0007\u0010^\u000b\u0003\u0003O\u0001B!!\u000b\u000225\u0011\u00111\u0006\u0006\u0005\u0003[\ty#A\u0003qe>$xN\u0003\u00023k%!\u00111GA\u0016\u0005-)6/\u001a:D_:$X\r\u001f;\u0002/\t,\u0018\u000e\u001c3Fq\u0016\u001cW\u000f^3QY\u0006t'+Z9vKN$H\u0003CA\u001d\u0003\u007f\tI%a\u0017\u0011\t\u0005%\u00121H\u0005\u0005\u0003{\tYC\u0001\nFq\u0016\u001cW\u000f^3QY\u0006t'+Z9vKN$\bbBA!\u001d\u0001\u0007\u00111I\u0001\u0005a2\fg\u000e\u0005\u0003\u0002*\u0005\u0015\u0013\u0002BA$\u0003W\u0011A\u0001\u00157b]\"I\u00111\n\b\u0011\u0002\u0003\u0007\u0011QJ\u0001\ng\u0016\u001c8/[8o\u0013\u0012\u0004B!a\u0014\u0002X9!\u0011\u0011KA*!\r\t)aS\u0005\u0004\u0003+Z\u0015A\u0002)sK\u0012,g-C\u0002w\u00033R1!!\u0016L\u0011%\tiF\u0004I\u0001\u0002\u0004\ti%A\u0006pa\u0016\u0014\u0018\r^5p]&#\u0017!\t2vS2$W\t_3dkR,\u0007\u000b\\1o%\u0016\fX/Z:uI\u0011,g-Y;mi\u0012\u0012TCAA2U\u0011\ti%!\u001a,\u0005\u0005\u001d\u0004\u0003BA5\u0003gj!!a\u001b\u000b\t\u00055\u0014qN\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\u001dL\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003k\nYGA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f\u0011EY;jY\u0012,\u00050Z2vi\u0016\u0004F.\u00198SKF,Xm\u001d;%I\u00164\u0017-\u001e7uIM\n1DY;jY\u0012\u0014V-\u0019;uC\u000eDW\t_3dkR,'+Z9vKN$HCBA?\u0003\u0007\u000b)\t\u0005\u0003\u0002*\u0005}\u0014\u0002BAA\u0003W\u0011aCU3biR\f7\r[#yK\u000e,H/\u001a*fcV,7\u000f\u001e\u0005\b\u0003;\n\u0002\u0019AA'\u0011\u001d\t9)\u0005a\u0001\u0003\u0013\u000b!B]3ta>t7/Z%e!\u0015Q\u00151RA'\u0013\r\tii\u0013\u0002\u0007\u001fB$\u0018n\u001c8\u00025\t,\u0018\u000e\u001c3SK2,\u0017m]3TKN\u001c\u0018n\u001c8SKF,Xm\u001d;\u0015\r\u0005M\u0015\u0011TAN!\u0011\tI#!&\n\t\u0005]\u00151\u0006\u0002\u0016%\u0016dW-Y:f'\u0016\u001c8/[8o%\u0016\fX/Z:u\u0011%\tYE\u0005I\u0001\u0002\u0004\ti\u0005C\u0005\u0002\u001eJ\u0001\n\u00111\u0001\u0002 \u0006q\u0011\r\u001c7poJ+7m\u001c8oK\u000e$\bc\u0001&\u0002\"&\u0019\u00111U&\u0003\u000f\t{w\u000e\\3b]\u0006!#-^5mIJ+G.Z1tKN+7o]5p]J+\u0017/^3ti\u0012\"WMZ1vYR$\u0013'\u0001\u0013ck&dGMU3mK\u0006\u001cXmU3tg&|gNU3rk\u0016\u001cH\u000f\n3fM\u0006,H\u000e\u001e\u00133+\t\tYK\u000b\u0003\u0002 \u0006\u0015\u0014!\u00032vS2$\u0007\u000b\\1o)\u0011\t\u0019%!-\t\u000f\u0005MV\u00031\u0001\u0002N\u0005)\u0011/^3ss\u0006\u0019\"-^5mIN\u000bHnQ8n[\u0006tG\r\u00157b]R!\u00111IA]\u0011\u001d\tYL\u0006a\u0001\u0003\u001b\n!b]9m\u0007>lW.\u00198e\u0003I\u0011W/\u001b7e\u0019>\u001c\u0017\r\u001c*fY\u0006$\u0018n\u001c8\u0016\t\u0005\u0005\u00171 \u000b\u0005\u0003\u0007\u0014i\u0001\u0006\u0003\u0002D\u0005\u0015\u0007\"CAd/\u0005\u0005\t9AAe\u0003))g/\u001b3f]\u000e,G%\r\t\u0007\u0003\u0017\fY/a>\u000f\t\u00055\u0017Q\u001d\b\u0005\u0003\u001f\f\tO\u0004\u0003\u0002R\u0006mg\u0002BAj\u0003/tA!!\u0002\u0002V&\tA*C\u0002\u0002Z.\u000bqA]3gY\u0016\u001cG/\u0003\u0003\u0002^\u0006}\u0017a\u0002:v]RLW.\u001a\u0006\u0004\u00033\\\u0015\u0002BA\r\u0003GTA!!8\u0002`&!\u0011q]Au\u0003!)h.\u001b<feN,'\u0002BA\r\u0003GLA!!<\u0002p\n9A+\u001f9f)\u0006<\u0017\u0002BAy\u0003g\u0014\u0001\u0002V=qKR\u000bwm\u001d\u0006\u0005\u0003k\fy.A\u0002ba&\u0004B!!?\u0002|2\u0001AaBA\u007f/\t\u0007\u0011q \u0002\u0002\u0003F!!\u0011\u0001B\u0004!\rQ%1A\u0005\u0004\u0005\u000bY%a\u0002(pi\"Lgn\u001a\t\u0004\u0015\n%\u0011b\u0001B\u0006\u0017\n9\u0001K]8ek\u000e$\bb\u0002B\b/\u0001\u0007!\u0011C\u0001\u0005I\u0006$\u0018\r\u0005\u0004\u0003\u0014\t]\u0011q\u001f\b\u0005\u0003'\u0014)\"C\u0002\u0002\u001a-KAA!\u0007\u0003\u001c\t\u00191+Z9\u000b\u0007\u0005e1*A\fhKR\u0014V-\u0019;uC\u000eD\u0017M\u00197f\u0013R,'/\u0019;peR!!\u0011\u0005B\u0017!\u0011\u0011\u0019C!\u000b\u000e\u0005\t\u0015\"b\u0001B\u0014c\u000511\r\\5f]RLAAa\u000b\u0003&\t9S\t_3dkR,\u0007\u000b\\1o%\u0016\u001c\bo\u001c8tKJ+\u0017\r\u001e;bG\"\f'\r\\3Ji\u0016\u0014\u0018\r^8s\u0011\u001d\u0011y\u0003\u0007a\u0001\u0005c\tAb\u001d;vE&#XM]1u_J\u0004bAa\t\u00034\t]\u0012\u0002\u0002B\u001b\u0005K\u0011\u0011c\u00117pg\u0016\f'\r\\3Ji\u0016\u0014\u0018\r^8s!\u0011\tIC!\u000f\n\t\tm\u00121\u0006\u0002\u0014\u000bb,7-\u001e;f!2\fgNU3ta>t7/Z\u0001\u0013CN\u001cXM\u001d;O_\u0006\u001bG/\u001b<f%B\u001c7/\u0001\u000fbgN,'\u000f^#wK:$X/\u00197ms:{\u0017i\u0019;jm\u0016\u0014\u0006oY:\u00021\u0005\u001c8/\u001a:u\u001d>\f5\r^5wK\u0016CXmY;uS>t7/\u0001\u0012bgN,'\u000f^#wK:$X/\u00197ms:{\u0017i\u0019;jm\u0016,\u00050Z2vi&|gn]\u0001\u0018CN\u001cXM\u001d;Fq\u0016\u001cW\u000f^5p]J+G.Z1tK\u0012$2!\u0013B%\u0011\u001d\ti&\ba\u0001\u0003\u001b\n\u0011%Y:tKJ$XI^3oiV\fG\u000e\\=Fq\u0016\u001cW\u000f^5p]J+G.Z1tK\u0012$2!\u0013B(\u0011\u001d\tiF\ba\u0001\u0003\u001b\n!cZ3u\u000bb,7-\u001e;j_:Du\u000e\u001c3feV\u0011!Q\u000b\t\u0005\u0005/\u0012i&\u0004\u0002\u0003Z)\u0019!1L\u0019\u0002\u000fM,'O^5dK&!!q\fB-\u00055)\u00050Z2vi\u0016Du\u000e\u001c3fe\u0006aRM^3oiV\fG\u000e\\=HKR,\u00050Z2vi&|g\u000eS8mI\u0016\u0014\u0018AC<ji\"\u001cE.[3oiR1!q\rB=\u0005w\"2!\u0013B5\u0011\u001d\u0011Y'\ta\u0001\u0005[\n\u0011A\u001a\t\u0007\u0015\n=$1O%\n\u0007\tE4JA\u0005Gk:\u001cG/[8ocA!!1\u0005B;\u0013\u0011\u00119H!\n\u0003%M\u0003\u0018M]6D_:tWm\u0019;DY&,g\u000e\u001e\u0005\n\u0003\u0017\n\u0003\u0013!a\u0001\u0003\u001bB\u0011B! \"!\u0003\u0005\r!!\u0014\u0002\rU\u001cXM]%e\u0003Q9\u0018\u000e\u001e5DY&,g\u000e\u001e\u0013eK\u001a\fW\u000f\u001c;%c\u0005!r/\u001b;i\u00072LWM\u001c;%I\u00164\u0017-\u001e7uII\"2!\u0013BC\u0011\u001d\u0011Y\u0007\na\u0001\u0005[\"r!\u0013BE\u0005\u0017\u0013i\tC\u0004\u0003l\u0015\u0002\rA!\u001c\t\u000f\u0005-S\u00051\u0001\u0002N!9!QP\u0013A\u0002\u00055\u0013aE<ji\"\u0014\u0016m\u001e\"m_\u000e\\\u0017N\\4TiV\u0014GcA%\u0003\u0014\"9!1\u000e\u0014A\u0002\tU\u0005C\u0002&\u0003p\t]\u0015\n\u0005\u0003\u0003\u001a\n\u0015f\u0002\u0002BN\u0005CsAA!(\u0003 6\u0011\u0011qF\u0005\u0005\u0003[\ty#\u0003\u0003\u0003$\u0006-\u0012aF*qCJ\\7i\u001c8oK\u000e$8+\u001a:wS\u000e,wI\u001d9d\u0013\u0011\u00119K!+\u0003?M\u0003\u0018M]6D_:tWm\u0019;TKJ4\u0018nY3CY>\u001c7.\u001b8h'R,(M\u0003\u0003\u0003$\u0006-\u0012AF<ji\"\u001cUo\u001d;p[\ncwnY6j]\u001e\u001cF/\u001e2\u0015\t\t=&1\u0018\u000b\u0004\u0013\nE\u0006b\u0002B6O\u0001\u0007!1\u0017\t\u0007\u0015\n=$QW%\u0011\t\t\r\"qW\u0005\u0005\u0005s\u0013)C\u0001\u0010DkN$x.\\*qCJ\\7i\u001c8oK\u000e$(\t\\8dW&twm\u0015;vE\"I!QX\u0014\u0011\u0002\u0003\u0007!qX\u0001\u000ee\u0016$(/\u001f)pY&\u001c\u0017.Z:\u0011\r\tM!q\u0003Ba!\u0011\u0011\u0019Ca1\n\t\t\u0015'Q\u0005\u0002\f%\u0016$(/\u001f)pY&\u001c\u00170\u0001\u0011xSRD7)^:u_6\u0014En\\2lS:<7\u000b^;cI\u0011,g-Y;mi\u0012\nTC\u0001BfU\u0011\u0011y,!\u001a\u0002\u0011I,h.U;fef$r!\u0013Bi\u0005'\u00149\u000eC\u0004\u0002B%\u0002\r!a\u0011\t\r\tU\u0017\u00061\u0001W\u00031\tX/\u001a:z)&lWm\\;u\u0011\u001d\u0011I.\u000ba\u0001\u00057\f\u0011\"\u001b;feNcW-\u001a9\u0011\u0007)\u0013i.C\u0002\u0003`.\u0013A\u0001T8oOR9\u0011Ja9\u0003f\n\u001d\bbBAZU\u0001\u0007\u0011Q\n\u0005\u0007\u0005+T\u0003\u0019\u0001,\t\u0013\te'\u0006%AA\u0002\tm\u0017A\u0005:v]F+XM]=%I\u00164\u0017-\u001e7uIM*\"A!<+\t\tm\u0017QM\u0001\u0010gV\u0004XM\u001d\u0013cK\u001a|'/Z!mY&\u0011\u0001.R\u0001\u000fgV\u0004XM\u001d\u0013bMR,'/\u00117m\u0013\tIW)\u0001\ttkB,'\u000f\n2fM>\u0014X-R1dQ&\u0019!Na?\n\u0007\tu8I\u0001\fTQ\u0006\u0014X\rZ*qCJ\\7+Z:tS>t')Y:f\u0003=\u0019X\u000f]3sI\u00054G/\u001a:FC\u000eD\u0017bA6\u0003|\u0002")
public interface SparkConnectServerTest
extends SharedSparkSession {
    public void org$apache$spark$sql$connect$SparkConnectServerTest$_setter_$serverPort_$eq(int var1);

    public void org$apache$spark$sql$connect$SparkConnectServerTest$_setter_$eventuallyTimeout_$eq(Span var1);

    public void org$apache$spark$sql$connect$SparkConnectServerTest$_setter_$allocator_$eq(RootAllocator var1);

    public void org$apache$spark$sql$connect$SparkConnectServerTest$_setter_$defaultSessionId_$eq(String var1);

    public void org$apache$spark$sql$connect$SparkConnectServerTest$_setter_$defaultUserId_$eq(String var1);

    public void org$apache$spark$sql$connect$SparkConnectServerTest$_setter_$dsl_$eq(package.MockRemoteSession var1);

    public void org$apache$spark$sql$connect$SparkConnectServerTest$_setter_$userContext_$eq(UserContext var1);

    public /* synthetic */ void org$apache$spark$sql$connect$SparkConnectServerTest$$super$beforeAll();

    public /* synthetic */ void org$apache$spark$sql$connect$SparkConnectServerTest$$super$afterAll();

    public /* synthetic */ void org$apache$spark$sql$connect$SparkConnectServerTest$$super$beforeEach();

    public /* synthetic */ void org$apache$spark$sql$connect$SparkConnectServerTest$$super$afterEach();

    public int serverPort();

    public Span eventuallyTimeout();

    public RootAllocator allocator();

    public static /* synthetic */ void beforeAll$(SparkConnectServerTest $this) {
        $this.beforeAll();
    }

    default public void beforeAll() {
        this.org$apache$spark$sql$connect$SparkConnectServerTest$$super$beforeAll();
        SparkConnectService$.MODULE$.executionManager().shutdown();
        ((SparkFunSuite)this).withSparkEnvConfs((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)Connect$.MODULE$.CONNECT_GRPC_BINDING_PORT().key(), (Object)Integer.toString(this.serverPort()))}), (Function0)(JFunction0.mcV.sp & Serializable)() -> SparkConnectService$.MODULE$.start(this.spark().sparkContext()));
    }

    public static /* synthetic */ void afterAll$(SparkConnectServerTest $this) {
        $this.afterAll();
    }

    default public void afterAll() {
        SparkConnectService$.MODULE$.stop(SparkConnectService$.MODULE$.stop$default$1(), SparkConnectService$.MODULE$.stop$default$2());
        this.allocator().close();
        this.org$apache$spark$sql$connect$SparkConnectServerTest$$super$afterAll();
    }

    public static /* synthetic */ void beforeEach$(SparkConnectServerTest $this) {
        $this.beforeEach();
    }

    default public void beforeEach() {
        this.org$apache$spark$sql$connect$SparkConnectServerTest$$super$beforeEach();
        this.clearAllExecutions();
    }

    public static /* synthetic */ void afterEach$(SparkConnectServerTest $this) {
        $this.afterEach();
    }

    default public void afterEach() {
        this.clearAllExecutions();
        this.org$apache$spark$sql$connect$SparkConnectServerTest$$super$afterEach();
    }

    public static /* synthetic */ void clearAllExecutions$(SparkConnectServerTest $this) {
        $this.clearAllExecutions();
    }

    default public void clearAllExecutions() {
        SparkConnectService$.MODULE$.executionManager().listExecuteHolders().foreach((Function1 & Serializable)x$1 -> {
            x$1.close();
            return BoxedUnit.UNIT;
        });
        SparkConnectService$.MODULE$.executionManager().periodicMaintenance(0L);
        SparkConnectService$.MODULE$.sessionManager().invalidateAllSessions();
        this.assertNoActiveExecutions();
    }

    public String defaultSessionId();

    public String defaultUserId();

    public package.MockRemoteSession dsl();

    public UserContext userContext();

    public static /* synthetic */ ExecutePlanRequest buildExecutePlanRequest$(SparkConnectServerTest $this, Plan plan, String sessionId, String operationId) {
        return $this.buildExecutePlanRequest(plan, sessionId, operationId);
    }

    default public ExecutePlanRequest buildExecutePlanRequest(Plan plan, String sessionId, String operationId) {
        return ExecutePlanRequest.newBuilder().setUserContext(this.userContext()).setSessionId(sessionId).setOperationId(operationId).setPlan(plan).addRequestOptions(ExecutePlanRequest.RequestOption.newBuilder().setReattachOptions(ReattachOptions.newBuilder().setReattachable(true).build()).build()).build();
    }

    public static /* synthetic */ String buildExecutePlanRequest$default$2$(SparkConnectServerTest $this) {
        return $this.buildExecutePlanRequest$default$2();
    }

    default public String buildExecutePlanRequest$default$2() {
        return this.defaultSessionId();
    }

    public static /* synthetic */ String buildExecutePlanRequest$default$3$(SparkConnectServerTest $this) {
        return $this.buildExecutePlanRequest$default$3();
    }

    default public String buildExecutePlanRequest$default$3() {
        return UUID.randomUUID().toString();
    }

    public static /* synthetic */ ReattachExecuteRequest buildReattachExecuteRequest$(SparkConnectServerTest $this, String operationId, Option responseId) {
        return $this.buildReattachExecuteRequest(operationId, (Option<String>)responseId);
    }

    default public ReattachExecuteRequest buildReattachExecuteRequest(String operationId, Option<String> responseId) {
        ReattachExecuteRequest.Builder req = ReattachExecuteRequest.newBuilder().setUserContext(this.userContext()).setSessionId(this.defaultSessionId()).setOperationId(operationId);
        Object object = responseId.isDefined() ? req.setLastResponseId((String)responseId.get()) : BoxedUnit.UNIT;
        return req.build();
    }

    public static /* synthetic */ ReleaseSessionRequest buildReleaseSessionRequest$(SparkConnectServerTest $this, String sessionId, boolean allowReconnect) {
        return $this.buildReleaseSessionRequest(sessionId, allowReconnect);
    }

    default public ReleaseSessionRequest buildReleaseSessionRequest(String sessionId, boolean allowReconnect) {
        return ReleaseSessionRequest.newBuilder().setUserContext(this.userContext()).setSessionId(sessionId).setAllowReconnect(allowReconnect).build();
    }

    public static /* synthetic */ String buildReleaseSessionRequest$default$1$(SparkConnectServerTest $this) {
        return $this.buildReleaseSessionRequest$default$1();
    }

    default public String buildReleaseSessionRequest$default$1() {
        return this.defaultSessionId();
    }

    public static /* synthetic */ boolean buildReleaseSessionRequest$default$2$(SparkConnectServerTest $this) {
        return $this.buildReleaseSessionRequest$default$2();
    }

    default public boolean buildReleaseSessionRequest$default$2() {
        return false;
    }

    public static /* synthetic */ Plan buildPlan$(SparkConnectServerTest $this, String query) {
        return $this.buildPlan(query);
    }

    default public Plan buildPlan(String query) {
        return Plan.newBuilder().setRoot(package$plans$.MODULE$.DslMockRemoteSession(this.dsl()).sql(query)).build();
    }

    public static /* synthetic */ Plan buildSqlCommandPlan$(SparkConnectServerTest $this, String sqlCommand) {
        return $this.buildSqlCommandPlan(sqlCommand);
    }

    default public Plan buildSqlCommandPlan(String sqlCommand) {
        return Plan.newBuilder().setCommand(Command.newBuilder().setSqlCommand(SqlCommand.newBuilder().setSql(sqlCommand).build()).build()).build();
    }

    public static /* synthetic */ Plan buildLocalRelation$(SparkConnectServerTest $this, Seq data, TypeTags.TypeTag evidence$1) {
        return $this.buildLocalRelation(data, evidence$1);
    }

    default public <A extends Product> Plan buildLocalRelation(Seq<A> data, TypeTags.TypeTag<A> evidence$1) {
        AgnosticEncoder encoder = ScalaReflection$.MODULE$.encoderFor(evidence$1);
        ByteString arrowData = ArrowSerializer$.MODULE$.serialize(data.iterator(), encoder, (BufferAllocator)this.allocator(), TimeZone.getDefault().getID(), false);
        LocalRelation localRelation = LocalRelation.newBuilder().setData(arrowData).setSchema(encoder.schema().json()).build();
        Relation relation = Relation.newBuilder().setLocalRelation(localRelation).build();
        return Plan.newBuilder().setRoot(relation).build();
    }

    public static /* synthetic */ ExecutePlanResponseReattachableIterator getReattachableIterator$(SparkConnectServerTest $this, CloseableIterator stubIterator) {
        return $this.getReattachableIterator((CloseableIterator<ExecutePlanResponse>)stubIterator);
    }

    default public ExecutePlanResponseReattachableIterator getReattachableIterator(CloseableIterator<ExecutePlanResponse> stubIterator) {
        return ExecutePlanResponseReattachableIterator$.MODULE$.fromIterator(stubIterator);
    }

    public static /* synthetic */ void assertNoActiveRpcs$(SparkConnectServerTest $this) {
        $this.assertNoActiveRpcs();
    }

    default public void assertNoActiveRpcs() {
        Either either = SparkConnectService$.MODULE$.executionManager().listActiveExecutions();
        if (either instanceof Left) {
            return;
        }
        if (either instanceof Right) {
            Right right = (Right)either;
            Seq executions = (Seq)right.value();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(executions.forall((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)SparkConnectServerTest.$anonfun$assertNoActiveRpcs$1(x$2))), "executions.forall(((x$2: org.apache.spark.sql.connect.service.ExecuteInfo) => x$2.lastAttachedRpcTimeNs.isDefined))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)("Expected no RPCs, but got " + executions), Prettifier$.MODULE$.default(), new Position("SparkConnectServerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 189));
            return;
        }
        throw new MatchError((Object)either);
    }

    public static /* synthetic */ void assertEventuallyNoActiveRpcs$(SparkConnectServerTest $this) {
        $this.assertEventuallyNoActiveRpcs();
    }

    default public void assertEventuallyNoActiveRpcs() {
        Eventually$.MODULE$.eventually(this.timeout(this.eventuallyTimeout()), (Function0)(JFunction0.mcV.sp & Serializable)() -> this.assertNoActiveRpcs(), Eventually$.MODULE$.patienceConfig(), Retrying$.MODULE$.retryingNatureOfT(), new Position("SparkConnectServerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 196));
    }

    public static /* synthetic */ void assertNoActiveExecutions$(SparkConnectServerTest $this) {
        $this.assertNoActiveExecutions();
    }

    default public void assertNoActiveExecutions() {
        Either either = SparkConnectService$.MODULE$.executionManager().listActiveExecutions();
        if (either instanceof Left) {
            return;
        }
        if (either instanceof Right) {
            Right right = (Right)either;
            Seq executions = (Seq)right.value();
            throw ((Assertions)this).fail("Expected empty, but got " + executions, new Position("SparkConnectServerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 204));
        }
        throw new MatchError((Object)either);
    }

    public static /* synthetic */ void assertEventuallyNoActiveExecutions$(SparkConnectServerTest $this) {
        $this.assertEventuallyNoActiveExecutions();
    }

    default public void assertEventuallyNoActiveExecutions() {
        Eventually$.MODULE$.eventually(this.timeout(this.eventuallyTimeout()), (Function0)(JFunction0.mcV.sp & Serializable)() -> this.assertNoActiveExecutions(), Eventually$.MODULE$.patienceConfig(), Retrying$.MODULE$.retryingNatureOfT(), new Position("SparkConnectServerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 209));
    }

    public static /* synthetic */ void assertExecutionReleased$(SparkConnectServerTest $this, String operationId) {
        $this.assertExecutionReleased(operationId);
    }

    default public void assertExecutionReleased(String operationId) {
        Either either = SparkConnectService$.MODULE$.executionManager().listActiveExecutions();
        if (either instanceof Left) {
            return;
        }
        if (either instanceof Right) {
            Right right = (Right)either;
            Seq executions = (Seq)right.value();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(executions.exists((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)SparkConnectServerTest.$anonfun$assertExecutionReleased$1(operationId, x$3))), "executions.exists(((x$3: org.apache.spark.sql.connect.service.ExecuteInfo) => x$3.operationId.==(operationId)))", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectServerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 217));
            return;
        }
        throw new MatchError((Object)either);
    }

    public static /* synthetic */ void assertEventuallyExecutionReleased$(SparkConnectServerTest $this, String operationId) {
        $this.assertEventuallyExecutionReleased(operationId);
    }

    default public void assertEventuallyExecutionReleased(String operationId) {
        Eventually$.MODULE$.eventually(this.timeout(this.eventuallyTimeout()), (Function0)(JFunction0.mcV.sp & Serializable)() -> this.assertExecutionReleased(operationId), Eventually$.MODULE$.patienceConfig(), Retrying$.MODULE$.retryingNatureOfT(), new Position("SparkConnectServerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 222));
    }

    public static /* synthetic */ ExecuteHolder getExecutionHolder$(SparkConnectServerTest $this) {
        return $this.getExecutionHolder();
    }

    default public ExecuteHolder getExecutionHolder() {
        Seq executions;
        Seq $org_scalatest_assert_macro_left = executions = SparkConnectService$.MODULE$.executionManager().listExecuteHolders();
        int $org_scalatest_assert_macro_right = 1;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectServerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 230));
        return (ExecuteHolder)executions.head();
    }

    public static /* synthetic */ ExecuteHolder eventuallyGetExecutionHolder$(SparkConnectServerTest $this) {
        return $this.eventuallyGetExecutionHolder();
    }

    default public ExecuteHolder eventuallyGetExecutionHolder() {
        return (ExecuteHolder)Eventually$.MODULE$.eventually(this.timeout(this.eventuallyTimeout()), (Function0 & Serializable)() -> this.getExecutionHolder(), Eventually$.MODULE$.patienceConfig(), Retrying$.MODULE$.retryingNatureOfT(), new Position("SparkConnectServerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 235));
    }

    public static /* synthetic */ void withClient$(SparkConnectServerTest $this, String sessionId, String userId, Function1 f) {
        $this.withClient(sessionId, userId, (Function1<SparkConnectClient, BoxedUnit>)f);
    }

    default public void withClient(String sessionId, String userId, Function1<SparkConnectClient, BoxedUnit> f) {
        this.withClient(f, sessionId, userId);
    }

    public static /* synthetic */ void withClient$(SparkConnectServerTest $this, Function1 f) {
        $this.withClient((Function1<SparkConnectClient, BoxedUnit>)f);
    }

    default public void withClient(Function1<SparkConnectClient, BoxedUnit> f) {
        this.withClient(f, this.defaultSessionId(), this.defaultUserId());
    }

    public static /* synthetic */ void withClient$(SparkConnectServerTest $this, Function1 f, String sessionId, String userId) {
        $this.withClient((Function1<SparkConnectClient, BoxedUnit>)f, sessionId, userId);
    }

    default public void withClient(Function1<SparkConnectClient, BoxedUnit> f, String sessionId, String userId) {
        SparkConnectClient client = SparkConnectClient$.MODULE$.builder().port(this.serverPort()).sessionId(sessionId).userId(userId).enableReattachableExecute().build();
        try {
            f.apply((Object)client);
        }
        finally {
            client.shutdown();
        }
    }

    public static /* synthetic */ String withClient$default$1$(SparkConnectServerTest $this) {
        return $this.withClient$default$1();
    }

    default public String withClient$default$1() {
        return this.defaultSessionId();
    }

    public static /* synthetic */ String withClient$default$2$(SparkConnectServerTest $this) {
        return $this.withClient$default$2();
    }

    default public String withClient$default$2() {
        return this.defaultUserId();
    }

    public static /* synthetic */ void withRawBlockingStub$(SparkConnectServerTest $this, Function1 f) {
        $this.withRawBlockingStub((Function1<SparkConnectServiceGrpc.SparkConnectServiceBlockingStub, BoxedUnit>)f);
    }

    default public void withRawBlockingStub(Function1<SparkConnectServiceGrpc.SparkConnectServiceBlockingStub, BoxedUnit> f) {
        int x$1 = this.serverPort();
        String x$2 = SparkConnectClient.Configuration$.MODULE$.apply$default$1();
        String x$3 = SparkConnectClient.Configuration$.MODULE$.apply$default$2();
        String x$4 = SparkConnectClient.Configuration$.MODULE$.apply$default$3();
        Option x$5 = SparkConnectClient.Configuration$.MODULE$.apply$default$5();
        Option x$6 = SparkConnectClient.Configuration$.MODULE$.apply$default$6();
        Map x$7 = SparkConnectClient.Configuration$.MODULE$.apply$default$7();
        String x$8 = SparkConnectClient.Configuration$.MODULE$.apply$default$8();
        Seq x$9 = SparkConnectClient.Configuration$.MODULE$.apply$default$9();
        boolean x$10 = SparkConnectClient.Configuration$.MODULE$.apply$default$10();
        List x$11 = SparkConnectClient.Configuration$.MODULE$.apply$default$11();
        Option x$12 = SparkConnectClient.Configuration$.MODULE$.apply$default$12();
        int x$13 = SparkConnectClient.Configuration$.MODULE$.apply$default$13();
        int x$14 = SparkConnectClient.Configuration$.MODULE$.apply$default$14();
        boolean x$15 = SparkConnectClient.Configuration$.MODULE$.apply$default$15();
        Option x$16 = SparkConnectClient.Configuration$.MODULE$.apply$default$16();
        SparkConnectClient.Configuration conf = new SparkConnectClient.Configuration(x$2, x$3, x$4, x$1, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16);
        ManagedChannel channel = conf.createChannel();
        SparkConnectServiceGrpc.SparkConnectServiceBlockingStub bstub = SparkConnectServiceGrpc.newBlockingStub((Channel)channel);
        try {
            f.apply((Object)bstub);
        }
        finally {
            channel.shutdownNow();
        }
    }

    public static /* synthetic */ void withCustomBlockingStub$(SparkConnectServerTest $this, Seq retryPolicies, Function1 f) {
        $this.withCustomBlockingStub((Seq<RetryPolicy>)retryPolicies, (Function1<CustomSparkConnectBlockingStub, BoxedUnit>)f);
    }

    default public void withCustomBlockingStub(Seq<RetryPolicy> retryPolicies, Function1<CustomSparkConnectBlockingStub, BoxedUnit> f) {
        int x$1 = this.serverPort();
        String x$2 = SparkConnectClient.Configuration$.MODULE$.apply$default$1();
        String x$3 = SparkConnectClient.Configuration$.MODULE$.apply$default$2();
        String x$4 = SparkConnectClient.Configuration$.MODULE$.apply$default$3();
        Option x$5 = SparkConnectClient.Configuration$.MODULE$.apply$default$5();
        Option x$6 = SparkConnectClient.Configuration$.MODULE$.apply$default$6();
        Map x$7 = SparkConnectClient.Configuration$.MODULE$.apply$default$7();
        String x$8 = SparkConnectClient.Configuration$.MODULE$.apply$default$8();
        Seq x$9 = SparkConnectClient.Configuration$.MODULE$.apply$default$9();
        boolean x$10 = SparkConnectClient.Configuration$.MODULE$.apply$default$10();
        List x$11 = SparkConnectClient.Configuration$.MODULE$.apply$default$11();
        Option x$12 = SparkConnectClient.Configuration$.MODULE$.apply$default$12();
        int x$13 = SparkConnectClient.Configuration$.MODULE$.apply$default$13();
        int x$14 = SparkConnectClient.Configuration$.MODULE$.apply$default$14();
        boolean x$15 = SparkConnectClient.Configuration$.MODULE$.apply$default$15();
        Option x$16 = SparkConnectClient.Configuration$.MODULE$.apply$default$16();
        SparkConnectClient.Configuration conf = new SparkConnectClient.Configuration(x$2, x$3, x$4, x$1, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16);
        ManagedChannel channel = conf.createChannel();
        SparkConnectStubState stubState = new SparkConnectStubState(channel, retryPolicies);
        CustomSparkConnectBlockingStub bstub = new CustomSparkConnectBlockingStub(channel, stubState);
        try {
            f.apply((Object)bstub);
        }
        finally {
            channel.shutdownNow();
        }
    }

    public static /* synthetic */ Seq withCustomBlockingStub$default$1$(SparkConnectServerTest $this) {
        return $this.withCustomBlockingStub$default$1();
    }

    default public Seq<RetryPolicy> withCustomBlockingStub$default$1() {
        return RetryPolicy$.MODULE$.defaultPolicies();
    }

    public static /* synthetic */ void runQuery$(SparkConnectServerTest $this, Plan plan, Span queryTimeout, long iterSleep) {
        $this.runQuery(plan, queryTimeout, iterSleep);
    }

    default public void runQuery(Plan plan, Span queryTimeout, long iterSleep) {
        this.withClient((Function1<SparkConnectClient, BoxedUnit>)(Function1 & Serializable)client -> {
            TimeLimits$.MODULE$.failAfter(queryTimeout, (Function0)(JFunction0.mcV.sp & Serializable)() -> {
                CloseableIterator iter = client.execute(plan$1, client.execute$default$2());
                None$ operationId = None$.MODULE$;
                ExecutePlanResponse r = null;
                ExecutePlanResponseReattachableIterator reattachableIter = $this.getReattachableIterator((CloseableIterator<ExecutePlanResponse>)iter);
                while (iter.hasNext()) {
                    r = (ExecutePlanResponse)iter.next();
                    None$ none$ = operationId;
                    if (None$.MODULE$.equals(none$)) {
                        operationId = new Some((Object)r.getOperationId());
                    } else if (none$ instanceof Some) {
                        Some some = (Some)none$;
                        String id = (String)some.value();
                        String $org_scalatest_assert_macro_left = r.getOperationId();
                        String $org_scalatest_assert_macro_right = id;
                        String string = $org_scalatest_assert_macro_left;
                        String string2 = $org_scalatest_assert_macro_right;
                        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
                        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectServerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 301));
                    } else {
                        throw new MatchError((Object)none$);
                    }
                    if (iterSleep$1 <= 0L) continue;
                    Thread.sleep(iterSleep$1);
                }
                ExecutePlanResponse $org_scalatest_assert_macro_left = r;
                Object $org_scalatest_assert_macro_right = null;
                ExecutePlanResponse executePlanResponse = $org_scalatest_assert_macro_left;
                Object var20_17 = null;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "!=", null, executePlanResponse == null ? var20_17 != null : !executePlanResponse.equals(var20_17), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectServerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 308));
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(r.hasResultComplete(), "r.hasResultComplete()", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectServerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 309));
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(reattachableIter.resultComplete(), "reattachableIter.resultComplete", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectServerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 311));
                Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(operationId.isDefined(), "operationId.isDefined", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkConnectServerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 313));
                $this.assertEventuallyExecutionReleased((String)operationId.get());
            }, Signaler$.MODULE$.default(), Prettifier$.MODULE$.default(), new Position("SparkConnectServerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 292), Timed$.MODULE$.timed());
            return BoxedUnit.UNIT;
        });
    }

    public static /* synthetic */ void runQuery$(SparkConnectServerTest $this, String query, Span queryTimeout, long iterSleep) {
        $this.runQuery(query, queryTimeout, iterSleep);
    }

    default public void runQuery(String query, Span queryTimeout, long iterSleep) {
        Plan plan = this.buildPlan(query);
        this.runQuery(plan, queryTimeout, iterSleep);
    }

    public static /* synthetic */ long runQuery$default$3$(SparkConnectServerTest $this) {
        return $this.runQuery$default$3();
    }

    default public long runQuery$default$3() {
        return 0L;
    }

    public static /* synthetic */ boolean $anonfun$assertNoActiveRpcs$1(ExecuteInfo x$2) {
        return x$2.lastAttachedRpcTimeNs().isDefined();
    }

    public static /* synthetic */ boolean $anonfun$assertExecutionReleased$1(String operationId$1, ExecuteInfo x$3) {
        String string = x$3.operationId();
        String string2 = operationId$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static void $init$(SparkConnectServerTest $this) {
        $this.org$apache$spark$sql$connect$SparkConnectServerTest$_setter_$serverPort_$eq(ConnectCommon$.MODULE$.CONNECT_GRPC_BINDING_PORT() + Random$.MODULE$.nextInt(1000));
        $this.org$apache$spark$sql$connect$SparkConnectServerTest$_setter_$eventuallyTimeout_$eq(SpanSugar$.MODULE$.convertIntToGrainOfTime(30).seconds());
        $this.org$apache$spark$sql$connect$SparkConnectServerTest$_setter_$allocator_$eq(new RootAllocator());
        $this.org$apache$spark$sql$connect$SparkConnectServerTest$_setter_$defaultSessionId_$eq(UUID.randomUUID().toString());
        $this.org$apache$spark$sql$connect$SparkConnectServerTest$_setter_$defaultUserId_$eq(UUID.randomUUID().toString());
        $this.org$apache$spark$sql$connect$SparkConnectServerTest$_setter_$dsl_$eq(new package.MockRemoteSession());
        $this.org$apache$spark$sql$connect$SparkConnectServerTest$_setter_$userContext_$eq(UserContext.newBuilder().setUserId($this.defaultUserId()).build());
    }
}

