/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connect.pipelines;

import java.io.Serializable;
import org.apache.spark.connect.proto.OutputType;
import org.apache.spark.connect.proto.PipelineCommand;
import org.apache.spark.connect.proto.SparkConnectServiceGrpc;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.QueryTest$;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.connect.pipelines.SparkDeclarativePipelinesServerTest;
import org.apache.spark.sql.connect.pipelines.TestPipelineDefinition;
import org.apache.spark.sql.connect.service.SessionKey;
import org.apache.spark.sql.connect.service.SparkConnectService$;
import org.apache.spark.sql.pipelines.common.FlowStatus;
import org.apache.spark.sql.pipelines.common.RunState;
import org.apache.spark.sql.pipelines.logging.EventLevel;
import org.apache.spark.sql.pipelines.logging.PipelineEvent;
import org.apache.spark.sql.pipelines.utils.EventVerificationTestHelpers;
import org.apache.spark.sql.pipelines.utils.PipelineRunEventBuffer;
import org.apache.spark.sql.pipelines.utils.StorageRootMixin;
import org.apache.spark.sql.pipelines.utils.TestPipelineUpdateContextMixin;
import org.apache.spark.sql.pipelines.utils.TestPipelineUpdateContextMixin$TestPipelineUpdateContext$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayBuffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005ub\u0001B\u0006\r\u0001eAQ\u0001\u000b\u0001\u0005\u0002%Bqa\u000b\u0001C\u0002\u0013%A\u0006\u0003\u00044\u0001\u0001\u0006I!\f\u0005\u0006i\u0001!\t%\u000e\u0005\u0006y\u0001!\t%\u000e\u0005\u0006{\u0001!IA\u0010\u0005\u0006\u001f\u0002!I\u0001\u0015\u0005\t\u007f\u0002\t\n\u0011\"\u0003\u0002\u0002!I\u0011q\u0003\u0001\u0012\u0002\u0013%\u0011\u0011\u0004\u0005\b\u0003;\u0001A\u0011BA\u0010\u0005y\u0001\u0016\u000e]3mS:,'+\u001a4sKNDg)\u001e8di&|g.\u00197Tk&$XM\u0003\u0002\u000e\u001d\u0005I\u0001/\u001b9fY&tWm\u001d\u0006\u0003\u001fA\tqaY8o]\u0016\u001cGO\u0003\u0002\u0012%\u0005\u00191/\u001d7\u000b\u0005M!\u0012!B:qCJ\\'BA\u000b\u0017\u0003\u0019\t\u0007/Y2iK*\tq#A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u00015y)\u0003CA\u000e\u001d\u001b\u0005a\u0011BA\u000f\r\u0005\r\u001a\u0006/\u0019:l\t\u0016\u001cG.\u0019:bi&4X\rU5qK2Lg.Z:TKJ4XM\u001d+fgR\u0004\"aH\u0012\u000e\u0003\u0001R!!\t\u0012\u0002\u000bU$\u0018\u000e\\:\u000b\u00055\u0001\u0012B\u0001\u0013!\u0005y!Vm\u001d;QSB,G.\u001b8f+B$\u0017\r^3D_:$X\r\u001f;NSbLg\u000e\u0005\u0002 M%\u0011q\u0005\t\u0002\u001d\u000bZ,g\u000e\u001e,fe&4\u0017nY1uS>tG+Z:u\u0011\u0016d\u0007/\u001a:t\u0003\u0019a\u0014N\\5u}Q\t!\u0006\u0005\u0002\u001c\u0001\u0005\u0019R\r\u001f;fe:\fGnU8ve\u000e,G+\u00192mKV\tQ\u0006\u0005\u0002/c5\tqF\u0003\u00021!\u0005A1-\u0019;bYf\u001cH/\u0003\u00023_\tyA+\u00192mK&#WM\u001c;jM&,'/\u0001\u000bfqR,'O\\1m'>,(oY3UC\ndW\rI\u0001\u000bE\u00164wN]3FC\u000eDG#\u0001\u001c\u0011\u0005]RT\"\u0001\u001d\u000b\u0003e\nQa]2bY\u0006L!a\u000f\u001d\u0003\tUs\u0017\u000e^\u0001\nC\u001a$XM]#bG\"\f!c\u0019:fCR,G+Z:u!&\u0004X\r\\5oKR\u0011qH\u0011\t\u00037\u0001K!!\u0011\u0007\u0003-Q+7\u000f\u001e)ja\u0016d\u0017N\\3EK\u001aLg.\u001b;j_:DQa\u0011\u0004A\u0002\u0011\u000bqa\u001a:ba\"LE\r\u0005\u0002F\u0019:\u0011aI\u0013\t\u0003\u000fbj\u0011\u0001\u0013\u0006\u0003\u0013b\ta\u0001\u0010:p_Rt\u0014BA&9\u0003\u0019\u0001&/\u001a3fM&\u0011QJ\u0014\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005-C\u0014A\u0004:v]J+gM]3tQR+7\u000f\u001e\u000b\u0005mE#\u0007\u000fC\u0004S\u000fA\u0005\t\u0019A*\u0002)I,gM]3tQ\u000e{gNZ5h\u0005VLG\u000eZ3s!\u00119D\u000b\u0012,\n\u0005UC$!\u0003$v]\u000e$\u0018n\u001c82!\r9t+W\u0005\u00031b\u0012aa\u00149uS>t\u0007C\u0001.b\u001d\tYv,D\u0001]\u0015\tif,A\u0003qe>$xN\u0003\u0002\u0010%%\u0011\u0001\rX\u0001\u0010!&\u0004X\r\\5oK\u000e{W.\\1oI&\u0011!m\u0019\u0002\t'R\f'\u000f\u001e*v]*\u0011\u0001\r\u0018\u0005\u0006K\u001e\u0001\rAZ\u0001\u001cKb\u0004Xm\u0019;fI\u000e{g\u000e^3oi\u00063G/\u001a:SK\u001a\u0014Xm\u001d5\u0011\t\u0015;G)[\u0005\u0003Q:\u00131!T1q!\r)%\u000e\\\u0005\u0003W:\u00131aU3u!\u0011)u\rR7\u0011\u0005]r\u0017BA89\u0005\r\te.\u001f\u0005\bc\u001e\u0001\n\u00111\u0001s\u0003=)g/\u001a8u-\u0006d\u0017\u000eZ1uS>t\u0007cA\u001cXgB!q\u0007\u0016;7!\r)(\u0010`\u0007\u0002m*\u0011q\u000f_\u0001\b[V$\u0018M\u00197f\u0015\tI\b(\u0001\u0006d_2dWm\u0019;j_:L!a\u001f<\u0003\u0017\u0005\u0013(/Y=Ck\u001a4WM\u001d\t\u00037vL!A /\u0003\u001bAK\u0007/\u001a7j]\u0016,e/\u001a8u\u0003a\u0011XO\u001c*fMJ,7\u000f\u001b+fgR$C-\u001a4bk2$H%M\u000b\u0003\u0003\u0007Q3aUA\u0003W\t\t9\u0001\u0005\u0003\u0002\n\u0005MQBAA\u0006\u0015\u0011\ti!a\u0004\u0002\u0013Ut7\r[3dW\u0016$'bAA\tq\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005U\u00111\u0002\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017\u0001\u0007:v]J+gM]3tQR+7\u000f\u001e\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u00111\u0004\u0016\u0004e\u0006\u0015\u0011!E2iK\u000e\\G+\u00192mK\u000e{g\u000e^3oiV!\u0011\u0011EA\u0019)\u00151\u00141EA\u0014\u0011\u0019\t)C\u0003a\u0001\t\u0006!a.Y7f\u0011\u001d\tIC\u0003a\u0001\u0003W\tq\"\u001a=qK\u000e$X\rZ\"p]R,g\u000e\u001e\t\u0005\u000b*\fi\u0003\u0005\u0003\u00020\u0005EB\u0002\u0001\u0003\b\u0003gQ!\u0019AA\u001b\u0005\u0005\t\u0015cAA\u001cYB\u0019q'!\u000f\n\u0007\u0005m\u0002HA\u0004O_RD\u0017N\\4")
public class PipelineRefreshFunctionalSuite
extends SparkDeclarativePipelinesServerTest
implements TestPipelineUpdateContextMixin,
EventVerificationTestHelpers {
    private final TableIdentifier org$apache$spark$sql$connect$pipelines$PipelineRefreshFunctionalSuite$$externalSourceTable;
    private volatile TestPipelineUpdateContextMixin$TestPipelineUpdateContext$ TestPipelineUpdateContext$module;

    public void assertFlowProgressEvent(PipelineRunEventBuffer eventBuffer, TableIdentifier identifier, FlowStatus expectedFlowStatus, EventLevel expectedEventLevel, Function1<Throwable, Object> errorChecker, Function1<String, Object> msgChecker, Function1<PipelineEvent, Object> cond, Option<Object> expectedNumOfEvents) {
        EventVerificationTestHelpers.assertFlowProgressEvent$((EventVerificationTestHelpers)this, (PipelineRunEventBuffer)eventBuffer, (TableIdentifier)identifier, (FlowStatus)expectedFlowStatus, (EventLevel)expectedEventLevel, errorChecker, msgChecker, cond, expectedNumOfEvents);
    }

    public Function1<Throwable, Object> assertFlowProgressEvent$default$5() {
        return EventVerificationTestHelpers.assertFlowProgressEvent$default$5$((EventVerificationTestHelpers)this);
    }

    public Function1<String, Object> assertFlowProgressEvent$default$6() {
        return EventVerificationTestHelpers.assertFlowProgressEvent$default$6$((EventVerificationTestHelpers)this);
    }

    public Function1<PipelineEvent, Object> assertFlowProgressEvent$default$7() {
        return EventVerificationTestHelpers.assertFlowProgressEvent$default$7$((EventVerificationTestHelpers)this);
    }

    public Option<Object> assertFlowProgressEvent$default$8() {
        return EventVerificationTestHelpers.assertFlowProgressEvent$default$8$((EventVerificationTestHelpers)this);
    }

    public void assertFlowProgressStatusInOrder(PipelineRunEventBuffer eventBuffer, TableIdentifier identifier, scala.collection.immutable.Seq<Tuple2<EventLevel, FlowStatus>> expectedFlowProgressStatus) {
        EventVerificationTestHelpers.assertFlowProgressStatusInOrder$((EventVerificationTestHelpers)this, (PipelineRunEventBuffer)eventBuffer, (TableIdentifier)identifier, expectedFlowProgressStatus);
    }

    public void assertNoFlowProgressEvent(PipelineRunEventBuffer eventBuffer, TableIdentifier identifier, FlowStatus flowStatus) {
        EventVerificationTestHelpers.assertNoFlowProgressEvent$((EventVerificationTestHelpers)this, (PipelineRunEventBuffer)eventBuffer, (TableIdentifier)identifier, (FlowStatus)flowStatus);
    }

    public Map<String, FlowStatus> latestFlowStatuses(PipelineRunEventBuffer eventBuffer) {
        return EventVerificationTestHelpers.latestFlowStatuses$((EventVerificationTestHelpers)this, (PipelineRunEventBuffer)eventBuffer);
    }

    public void assertPlanningEvent(PipelineRunEventBuffer eventBuffer, TableIdentifier identifier) {
        EventVerificationTestHelpers.assertPlanningEvent$((EventVerificationTestHelpers)this, (PipelineRunEventBuffer)eventBuffer, (TableIdentifier)identifier);
    }

    public void assertRunProgressEvent(PipelineRunEventBuffer eventBuffer, RunState state, EventLevel expectedEventLevel, Function1<Option<Throwable>, Object> errorChecker, Function1<String, Object> msgChecker) {
        EventVerificationTestHelpers.assertRunProgressEvent$((EventVerificationTestHelpers)this, (PipelineRunEventBuffer)eventBuffer, (RunState)state, (EventLevel)expectedEventLevel, errorChecker, msgChecker);
    }

    public Function1<Option<Throwable>, Object> assertRunProgressEvent$default$4() {
        return EventVerificationTestHelpers.assertRunProgressEvent$default$4$((EventVerificationTestHelpers)this);
    }

    public Function1<String, Object> assertRunProgressEvent$default$5() {
        return EventVerificationTestHelpers.assertRunProgressEvent$default$5$((EventVerificationTestHelpers)this);
    }

    public TestPipelineUpdateContextMixin$TestPipelineUpdateContext$ TestPipelineUpdateContext() {
        if (this.TestPipelineUpdateContext$module == null) {
            this.TestPipelineUpdateContext$lzycompute$1();
        }
        return this.TestPipelineUpdateContext$module;
    }

    public TableIdentifier org$apache$spark$sql$connect$pipelines$PipelineRefreshFunctionalSuite$$externalSourceTable() {
        return this.org$apache$spark$sql$connect$pipelines$PipelineRefreshFunctionalSuite$$externalSourceTable;
    }

    @Override
    public void beforeEach() {
        StorageRootMixin.beforeEach$((StorageRootMixin)this);
        this.spark().sql("CREATE TABLE " + this.org$apache$spark$sql$connect$pipelines$PipelineRefreshFunctionalSuite$$externalSourceTable() + " AS SELECT * FROM RANGE(1, 2)");
    }

    @Override
    public void afterEach() {
        super.afterEach();
        this.spark().sql("DROP TABLE IF EXISTS " + this.org$apache$spark$sql$connect$pipelines$PipelineRefreshFunctionalSuite$$externalSourceTable());
    }

    private TestPipelineDefinition createTestPipeline(String graphId) {
        return new TestPipelineDefinition(this, graphId){
            {
                this.createTable("a", OutputType.TABLE, (Option<String>)new Some((Object)("SELECT id FROM STREAM " + $outer.org$apache$spark$sql$connect$pipelines$PipelineRefreshFunctionalSuite$$externalSourceTable())));
                this.createTable("b", OutputType.TABLE, (Option<String>)new Some((Object)("SELECT id FROM STREAM " + $outer.org$apache$spark$sql$connect$pipelines$PipelineRefreshFunctionalSuite$$externalSourceTable())));
                this.createTable("mv", OutputType.MATERIALIZED_VIEW, (Option<String>)new Some((Object)"SELECT id FROM a"));
            }
        };
    }

    private void runRefreshTest(Function1<String, Option<PipelineCommand.StartRun>> refreshConfigBuilder, Map<String, Set<Map<String, Object>>> expectedContentAfterRefresh, Option<Function1<ArrayBuffer<org.apache.spark.connect.proto.PipelineEvent>, BoxedUnit>> eventValidation) {
        this.withRawBlockingStub((Function1<SparkConnectServiceGrpc.SparkConnectServiceBlockingStub, BoxedUnit>)(Function1 & Serializable)stub -> {
            PipelineRefreshFunctionalSuite.$anonfun$runRefreshTest$1(this, refreshConfigBuilder, eventValidation, expectedContentAfterRefresh, stub);
            return BoxedUnit.UNIT;
        });
    }

    private Function1<String, Option<PipelineCommand.StartRun>> runRefreshTest$default$1() {
        return (Function1 & Serializable)x$1 -> None$.MODULE$;
    }

    private Option<Function1<ArrayBuffer<org.apache.spark.connect.proto.PipelineEvent>, BoxedUnit>> runRefreshTest$default$3() {
        return None$.MODULE$;
    }

    private <A extends Map<String, Object>> void checkTableContent(String name, Set<A> expectedContent) {
        this.spark().catalog().refreshTable(name);
        org.apache.spark.sql.classic.Dataset df = this.spark().table(name);
        QueryTest$.MODULE$.checkAnswer((Dataset)df, CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((IterableOnceOps)expectedContent.map((Function1 & Serializable)row -> Row$.MODULE$.fromSeq(row.values().toSeq()))).toSeq()).asJava());
    }

    private final void TestPipelineUpdateContext$lzycompute$1() {
        PipelineRefreshFunctionalSuite pipelineRefreshFunctionalSuite = this;
        synchronized (pipelineRefreshFunctionalSuite) {
            if (this.TestPipelineUpdateContext$module == null) {
                this.TestPipelineUpdateContext$module = new TestPipelineUpdateContextMixin$TestPipelineUpdateContext$((TestPipelineUpdateContextMixin)this);
            }
        }
    }

    public static final /* synthetic */ void $anonfun$runRefreshTest$2(PipelineRefreshFunctionalSuite $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String tableName = (String)tuple2._1();
            Set expectedRows = (Set)tuple2._2();
            $this.checkTableContent(tableName, expectedRows);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$runRefreshTest$5(PipelineRefreshFunctionalSuite $this, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            String tableName = (String)tuple2._1();
            Set expectedRows = (Set)tuple2._2();
            $this.checkTableContent(tableName, expectedRows);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$runRefreshTest$1(PipelineRefreshFunctionalSuite $this, Function1 refreshConfigBuilder$1, Option eventValidation$1, Map expectedContentAfterRefresh$1, SparkConnectServiceGrpc.SparkConnectServiceBlockingStub stub) {
        ArrayBuffer<org.apache.spark.connect.proto.PipelineEvent> arrayBuffer;
        String graphId = $this.createDataflowGraph(stub);
        TestPipelineDefinition pipeline = $this.createTestPipeline(graphId);
        $this.registerPipelineOutputs(pipeline, stub);
        $this.startPipelineAndWaitForCompletion(graphId);
        Map initialContent = (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark_catalog.default.a"), Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Map[]{(Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"id"), (Object)BoxesRunTime.boxToInteger((int)1))}))}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark_catalog.default.b"), Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Map[]{(Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"id"), (Object)BoxesRunTime.boxToInteger((int)1))}))}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark_catalog.default.mv"), Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Map[]{(Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"id"), (Object)BoxesRunTime.boxToInteger((int)1))}))})))}));
        initialContent.foreach((Function1 & Serializable)x0$1 -> {
            PipelineRefreshFunctionalSuite.$anonfun$runRefreshTest$2($this, x0$1);
            return BoxedUnit.UNIT;
        });
        SparkConnectService$.MODULE$.sessionManager().getIsolatedSessionIfPresent(new SessionKey($this.defaultUserId(), $this.defaultSessionId())).foreach((Function1 & Serializable)x$2 -> {
            x$2.removeAllPipelineExecutions();
            return BoxedUnit.UNIT;
        });
        $this.spark().sql("INSERT OVERWRITE TABLE spark_catalog.default.source_data SELECT * FROM VALUES (2), (3) AS t(id)");
        Option option = (Option)refreshConfigBuilder$1.apply((Object)graphId);
        if (option instanceof Some) {
            Some some = (Some)option;
            PipelineCommand.StartRun startRun = (PipelineCommand.StartRun)some.value();
            arrayBuffer = $this.startPipelineAndWaitForCompletion(startRun);
        } else if (None$.MODULE$.equals(option)) {
            arrayBuffer = $this.startPipelineAndWaitForCompletion(graphId);
        } else {
            throw new MatchError((Object)option);
        }
        ArrayBuffer<org.apache.spark.connect.proto.PipelineEvent> capturedEvents = arrayBuffer;
        eventValidation$1.foreach((Function1 & Serializable)x$3 -> {
            x$3.apply((Object)capturedEvents);
            return BoxedUnit.UNIT;
        });
        expectedContentAfterRefresh$1.foreach((Function1 & Serializable)x0$2 -> {
            PipelineRefreshFunctionalSuite.$anonfun$runRefreshTest$5($this, x0$2);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$new$4(org.apache.spark.connect.proto.PipelineEvent x$4) {
        return x$4.getMessage().contains("Flow 'spark_catalog.default.b' is EXCLUDED.");
    }

    public static final /* synthetic */ boolean $anonfun$new$5(org.apache.spark.connect.proto.PipelineEvent x$5) {
        return x$5.getMessage().contains("Flow spark_catalog.default.a has COMPLETED.");
    }

    public static final /* synthetic */ boolean $anonfun$new$6(org.apache.spark.connect.proto.PipelineEvent x$6) {
        return x$6.getMessage().contains("Flow 'spark_catalog.default.mv' is EXCLUDED.");
    }

    public static final /* synthetic */ boolean $anonfun$new$7(org.apache.spark.connect.proto.PipelineEvent x$7) {
        return x$7.getMessage().contains("Run is COMPLETED");
    }

    public static final /* synthetic */ void $anonfun$new$3(ArrayBuffer capturedEvents) {
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(capturedEvents.exists((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)PipelineRefreshFunctionalSuite.$anonfun$new$4(x$4))), "capturedEvents.exists(((x$4: org.apache.spark.connect.proto.PipelineEvent) => x$4.getMessage().contains(\"Flow \\'spark_catalog.default.b\\' is EXCLUDED.\")))", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PipelineRefreshFunctionalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 147));
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(capturedEvents.exists((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)PipelineRefreshFunctionalSuite.$anonfun$new$5(x$5))), "capturedEvents.exists(((x$5: org.apache.spark.connect.proto.PipelineEvent) => x$5.getMessage().contains(\"Flow spark_catalog.default.a has COMPLETED.\")))", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("PipelineRefreshFunctionalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 151));
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(capturedEvents.exists((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)PipelineRefreshFunctionalSuite.$anonfun$new$6(x$6))), "capturedEvents.exists(((x$6: org.apache.spark.connect.proto.PipelineEvent) => x$6.getMessage().contains(\"Flow \\'spark_catalog.default.mv\\' is EXCLUDED.\")))", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("PipelineRefreshFunctionalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 155));
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(capturedEvents.exists((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)PipelineRefreshFunctionalSuite.$anonfun$new$7(x$7))), "capturedEvents.exists(((x$7: org.apache.spark.connect.proto.PipelineEvent) => x$7.getMessage().contains(\"Run is COMPLETED\")))", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("PipelineRefreshFunctionalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 159));
    }

    public static final /* synthetic */ void $anonfun$new$14(PipelineRefreshFunctionalSuite $this, SparkConnectServiceGrpc.SparkConnectServiceBlockingStub stub) {
        String graphId = $this.createDataflowGraph(stub);
        TestPipelineDefinition pipeline = $this.createTestPipeline(graphId);
        $this.registerPipelineOutputs(pipeline, stub);
        PipelineCommand.StartRun startRun = PipelineCommand.StartRun.newBuilder().setDataflowGraphId(graphId).setStorage($this.storageRoot()).setFullRefreshAll(true).addRefreshSelection("a").build();
        IllegalArgumentException exception = (IllegalArgumentException)$this.intercept((Function0 & Serializable)() -> $this.startPipelineAndWaitForCompletion(startRun), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("PipelineRefreshFunctionalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 242));
        String $org_scalatest_assert_macro_left = exception.getMessage();
        String $org_scalatest_assert_macro_right = "Cannot specify a subset to refresh when full refresh all is set to true";
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PipelineRefreshFunctionalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 245));
    }

    public static final /* synthetic */ void $anonfun$new$17(PipelineRefreshFunctionalSuite $this, SparkConnectServiceGrpc.SparkConnectServiceBlockingStub stub) {
        String graphId = $this.createDataflowGraph(stub);
        TestPipelineDefinition pipeline = $this.createTestPipeline(graphId);
        $this.registerPipelineOutputs(pipeline, stub);
        PipelineCommand.StartRun startRun = PipelineCommand.StartRun.newBuilder().setDataflowGraphId(graphId).setStorage($this.storageRoot()).setFullRefreshAll(true).addFullRefreshSelection("a").build();
        IllegalArgumentException exception = (IllegalArgumentException)$this.intercept((Function0 & Serializable)() -> $this.startPipelineAndWaitForCompletion(startRun), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("PipelineRefreshFunctionalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 265));
        String $org_scalatest_assert_macro_left = exception.getMessage();
        String $org_scalatest_assert_macro_right = "Cannot specify a subset to full refresh when full refresh all is set to true";
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PipelineRefreshFunctionalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 268));
    }

    public static final /* synthetic */ void $anonfun$new$20(PipelineRefreshFunctionalSuite $this, SparkConnectServiceGrpc.SparkConnectServiceBlockingStub stub) {
        String graphId = $this.createDataflowGraph(stub);
        TestPipelineDefinition pipeline = $this.createTestPipeline(graphId);
        $this.registerPipelineOutputs(pipeline, stub);
        PipelineCommand.StartRun startRun = PipelineCommand.StartRun.newBuilder().setDataflowGraphId(graphId).setStorage($this.storageRoot()).addRefreshSelection("a").addFullRefreshSelection("a").build();
        IllegalArgumentException exception = (IllegalArgumentException)$this.intercept((Function0 & Serializable)() -> $this.startPipelineAndWaitForCompletion(startRun), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("PipelineRefreshFunctionalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 288));
        String $org_scalatest_assert_macro_left = exception.getMessage();
        String $org_scalatest_assert_macro_right = "Datasets specified for refresh and full refresh cannot overlap";
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PipelineRefreshFunctionalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 291));
        String $org_scalatest_assert_macro_left2 = exception.getMessage();
        String $org_scalatest_assert_macro_right2 = "a";
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("PipelineRefreshFunctionalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 294));
    }

    public static final /* synthetic */ void $anonfun$new$23(PipelineRefreshFunctionalSuite $this, SparkConnectServiceGrpc.SparkConnectServiceBlockingStub stub) {
        String graphId = $this.createDataflowGraph(stub);
        TestPipelineDefinition pipeline = $this.createTestPipeline(graphId);
        $this.registerPipelineOutputs(pipeline, stub);
        PipelineCommand.StartRun startRun = PipelineCommand.StartRun.newBuilder().setDataflowGraphId(graphId).setStorage($this.storageRoot()).addRefreshSelection("a").addRefreshSelection("b").addFullRefreshSelection("a").build();
        IllegalArgumentException exception = (IllegalArgumentException)$this.intercept((Function0 & Serializable)() -> $this.startPipelineAndWaitForCompletion(startRun), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("PipelineRefreshFunctionalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 313));
        String $org_scalatest_assert_macro_left = exception.getMessage();
        String $org_scalatest_assert_macro_right = "Datasets specified for refresh and full refresh cannot overlap";
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PipelineRefreshFunctionalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 316));
        String $org_scalatest_assert_macro_left2 = exception.getMessage();
        String $org_scalatest_assert_macro_right2 = "a";
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("PipelineRefreshFunctionalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 319));
    }

    public static final /* synthetic */ void $anonfun$new$26(PipelineRefreshFunctionalSuite $this, SparkConnectServiceGrpc.SparkConnectServiceBlockingStub stub) {
        String graphId = $this.createDataflowGraph(stub);
        TestPipelineDefinition pipeline = $this.createTestPipeline(graphId);
        $this.registerPipelineOutputs(pipeline, stub);
        PipelineCommand.StartRun startRun = PipelineCommand.StartRun.newBuilder().setStorage($this.storageRoot()).setDataflowGraphId(graphId).addRefreshSelection("spark_catalog.default.a").addFullRefreshSelection("a").build();
        IllegalArgumentException exception = (IllegalArgumentException)$this.intercept((Function0 & Serializable)() -> $this.startPipelineAndWaitForCompletion(startRun), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("PipelineRefreshFunctionalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 337));
        String $org_scalatest_assert_macro_left = exception.getMessage();
        String $org_scalatest_assert_macro_right = "Datasets specified for refresh and full refresh cannot overlap";
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PipelineRefreshFunctionalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 340));
    }

    public PipelineRefreshFunctionalSuite() {
        TestPipelineUpdateContextMixin.$init$((TestPipelineUpdateContextMixin)this);
        EventVerificationTestHelpers.$init$((EventVerificationTestHelpers)this);
        Some x$1 = new Some((Object)"spark_catalog");
        Some x$2 = new Some((Object)"default");
        String x$3 = "source_data";
        this.org$apache$spark$sql$connect$pipelines$PipelineRefreshFunctionalSuite$$externalSourceTable = new TableIdentifier("source_data", (Option)x$2, (Option)x$1);
        this.test("pipeline runs selective full_refresh", (scala.collection.immutable.Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.runRefreshTest((Function1<String, Option<PipelineCommand.StartRun>>)(Function1 & Serializable)graphId -> new Some((Object)PipelineCommand.StartRun.newBuilder().setDataflowGraphId(graphId).setStorage(this.storageRoot()).addAllFullRefreshSelection((Iterable)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)"a", (List)Nil$.MODULE$)).asJava()).build()), (Map<String, Set<Map<String, Object>>>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark_catalog.default.a"), Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Map[]{(Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"id"), (Object)BoxesRunTime.boxToInteger((int)2))})), (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"id"), (Object)BoxesRunTime.boxToInteger((int)3))}))}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark_catalog.default.b"), Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Map[]{(Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"id"), (Object)BoxesRunTime.boxToInteger((int)1))}))}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark_catalog.default.mv"), Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Map[]{(Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"id"), (Object)BoxesRunTime.boxToInteger((int)1))}))})))}))), (Option<Function1<ArrayBuffer<org.apache.spark.connect.proto.PipelineEvent>, BoxedUnit>>)new Some((Function1 & Serializable)capturedEvents -> {
            PipelineRefreshFunctionalSuite.$anonfun$new$3(capturedEvents);
            return BoxedUnit.UNIT;
        })), new Position("PipelineRefreshFunctionalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 124));
        this.test("pipeline runs selective full_refresh and selective refresh", (scala.collection.immutable.Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.runRefreshTest((Function1<String, Option<PipelineCommand.StartRun>>)(Function1 & Serializable)graphId -> new Some((Object)PipelineCommand.StartRun.newBuilder().setDataflowGraphId(graphId).addAllFullRefreshSelection((Iterable)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)"a", (List)new .colon.colon((Object)"mv", (List)Nil$.MODULE$))).asJava()).addRefreshSelection("b").setStorage(this.storageRoot()).build()), (Map<String, Set<Map<String, Object>>>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark_catalog.default.a"), Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Map[]{(Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"id"), (Object)BoxesRunTime.boxToInteger((int)2))})), (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"id"), (Object)BoxesRunTime.boxToInteger((int)3))}))}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark_catalog.default.b"), Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Map[]{(Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"id"), (Object)BoxesRunTime.boxToInteger((int)1))})), (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"id"), (Object)BoxesRunTime.boxToInteger((int)2))})), (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"id"), (Object)BoxesRunTime.boxToInteger((int)3))}))}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark_catalog.default.mv"), Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Map[]{(Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"id"), (Object)BoxesRunTime.boxToInteger((int)2))})), (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"id"), (Object)BoxesRunTime.boxToInteger((int)3))}))})))}))), this.runRefreshTest$default$3()), new Position("PipelineRefreshFunctionalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 163));
        this.test("pipeline runs refresh by default", (scala.collection.immutable.Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            Map x$4 = (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark_catalog.default.a"), Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Map[]{(Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"id"), (Object)BoxesRunTime.boxToInteger((int)1))})), (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"id"), (Object)BoxesRunTime.boxToInteger((int)2))})), (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"id"), (Object)BoxesRunTime.boxToInteger((int)3))}))}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark_catalog.default.b"), Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Map[]{(Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"id"), (Object)BoxesRunTime.boxToInteger((int)1))})), (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"id"), (Object)BoxesRunTime.boxToInteger((int)2))})), (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"id"), (Object)BoxesRunTime.boxToInteger((int)3))}))}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark_catalog.default.mv"), Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Map[]{(Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"id"), (Object)BoxesRunTime.boxToInteger((int)1))})), (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"id"), (Object)BoxesRunTime.boxToInteger((int)2))})), (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"id"), (Object)BoxesRunTime.boxToInteger((int)3))}))})))}));
            Function1<String, Option<PipelineCommand.StartRun>> x$5 = this.runRefreshTest$default$1();
            Option<Function1<ArrayBuffer<org.apache.spark.connect.proto.PipelineEvent>, BoxedUnit>> x$6 = this.runRefreshTest$default$3();
            this.runRefreshTest(x$5, (Map<String, Set<Map<String, Object>>>)x$4, x$6);
        }, new Position("PipelineRefreshFunctionalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 188));
        this.test("pipeline runs full refresh all", (scala.collection.immutable.Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.runRefreshTest((Function1<String, Option<PipelineCommand.StartRun>>)(Function1 & Serializable)graphId -> new Some((Object)PipelineCommand.StartRun.newBuilder().setDataflowGraphId(graphId).setStorage(this.storageRoot()).setFullRefreshAll(true).build()), (Map<String, Set<Map<String, Object>>>)((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark_catalog.default.a"), Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Map[]{(Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"id"), (Object)BoxesRunTime.boxToInteger((int)2))})), (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"id"), (Object)BoxesRunTime.boxToInteger((int)3))}))}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark_catalog.default.b"), Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Map[]{(Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"id"), (Object)BoxesRunTime.boxToInteger((int)2))})), (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"id"), (Object)BoxesRunTime.boxToInteger((int)3))}))}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark_catalog.default.mv"), Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Map[]{(Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"id"), (Object)BoxesRunTime.boxToInteger((int)2))})), (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"id"), (Object)BoxesRunTime.boxToInteger((int)3))}))})))}))), this.runRefreshTest$default$3()), new Position("PipelineRefreshFunctionalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 209));
        this.test("validation: cannot specify subset refresh when full_refresh_all is true", (scala.collection.immutable.Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withRawBlockingStub((Function1<SparkConnectServiceGrpc.SparkConnectServiceBlockingStub, BoxedUnit>)(Function1 & Serializable)stub -> {
            PipelineRefreshFunctionalSuite.$anonfun$new$14(this, stub);
            return BoxedUnit.UNIT;
        }), new Position("PipelineRefreshFunctionalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 228));
        this.test("validation: cannot specify subset full_refresh when full_refresh_all is true", (scala.collection.immutable.Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withRawBlockingStub((Function1<SparkConnectServiceGrpc.SparkConnectServiceBlockingStub, BoxedUnit>)(Function1 & Serializable)stub -> {
            PipelineRefreshFunctionalSuite.$anonfun$new$17(this, stub);
            return BoxedUnit.UNIT;
        }), new Position("PipelineRefreshFunctionalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 251));
        this.test("validation: refresh and full_refresh cannot overlap", (scala.collection.immutable.Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withRawBlockingStub((Function1<SparkConnectServiceGrpc.SparkConnectServiceBlockingStub, BoxedUnit>)(Function1 & Serializable)stub -> {
            PipelineRefreshFunctionalSuite.$anonfun$new$20(this, stub);
            return BoxedUnit.UNIT;
        }), new Position("PipelineRefreshFunctionalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 274));
        this.test("validation: multiple overlapping tables in refresh and full_refresh not allowed", (scala.collection.immutable.Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withRawBlockingStub((Function1<SparkConnectServiceGrpc.SparkConnectServiceBlockingStub, BoxedUnit>)(Function1 & Serializable)stub -> {
            PipelineRefreshFunctionalSuite.$anonfun$new$23(this, stub);
            return BoxedUnit.UNIT;
        }), new Position("PipelineRefreshFunctionalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 298));
        this.test("validation: fully qualified table names in validation", (scala.collection.immutable.Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withRawBlockingStub((Function1<SparkConnectServiceGrpc.SparkConnectServiceBlockingStub, BoxedUnit>)(Function1 & Serializable)stub -> {
            PipelineRefreshFunctionalSuite.$anonfun$new$26(this, stub);
            return BoxedUnit.UNIT;
        }), new Position("PipelineRefreshFunctionalSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 323));
    }
}

