/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connect.pipelines;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.spark.SparkFunSuite;
import org.apache.spark.SparkThrowable;
import org.apache.spark.api.python.PythonUtils$;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.TableIdentifier$;
import org.apache.spark.sql.connect.PythonTestDepsChecker$;
import org.apache.spark.sql.connect.pipelines.SparkDeclarativePipelinesServerTest;
import org.apache.spark.sql.connect.service.SessionHolder;
import org.apache.spark.sql.connect.service.SparkConnectService$;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.connector.expressions.NamedReference;
import org.apache.spark.sql.connector.expressions.Transform;
import org.apache.spark.sql.pipelines.Language;
import org.apache.spark.sql.pipelines.common.FlowStatus;
import org.apache.spark.sql.pipelines.common.RunState;
import org.apache.spark.sql.pipelines.graph.DataflowGraph;
import org.apache.spark.sql.pipelines.graph.GraphRegistrationContext;
import org.apache.spark.sql.pipelines.graph.PipelineUpdateContextImpl;
import org.apache.spark.sql.pipelines.graph.PipelineUpdateContextImpl$;
import org.apache.spark.sql.pipelines.graph.QueryOrigin;
import org.apache.spark.sql.pipelines.graph.QueryOrigin$;
import org.apache.spark.sql.pipelines.graph.QueryOriginType$;
import org.apache.spark.sql.pipelines.graph.ResolvedFlow;
import org.apache.spark.sql.pipelines.graph.Sink;
import org.apache.spark.sql.pipelines.graph.Table;
import org.apache.spark.sql.pipelines.graph.TableFilter;
import org.apache.spark.sql.pipelines.logging.EventLevel;
import org.apache.spark.sql.pipelines.logging.PipelineEvent;
import org.apache.spark.sql.pipelines.utils.EventVerificationTestHelpers;
import org.apache.spark.sql.pipelines.utils.PipelineRunEventBuffer;
import org.apache.spark.sql.pipelines.utils.TestPipelineUpdateContextMixin;
import org.apache.spark.sql.pipelines.utils.TestPipelineUpdateContextMixin$TestPipelineUpdateContext$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Set;
import scala.collection.SetOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\r4A!\u0003\u0006\u0001/!)a\u0005\u0001C\u0001O!)\u0011\u0006\u0001C\u0001U!)\u0001\t\u0001C\u0001\u0003\")!\n\u0001C\u0005\u0017\"9a\f\u0001b\u0001\n\u0013y\u0006B\u00021\u0001A\u0003%1\u000bC\u0004b\u0001\t\u0007I\u0011A0\t\r\t\u0004\u0001\u0015!\u0003T\u0005M\u0001\u0016\u0010\u001e5p]BK\u0007/\u001a7j]\u0016\u001cV/\u001b;f\u0015\tYA\"A\u0005qSB,G.\u001b8fg*\u0011QBD\u0001\bG>tg.Z2u\u0015\ty\u0001#A\u0002tc2T!!\u0005\n\u0002\u000bM\u0004\u0018M]6\u000b\u0005M!\u0012AB1qC\u000eDWMC\u0001\u0016\u0003\ry'oZ\u0002\u0001'\u0011\u0001\u0001\u0004H\u0012\u0011\u0005eQR\"\u0001\u0006\n\u0005mQ!aI*qCJ\\G)Z2mCJ\fG/\u001b<f!&\u0004X\r\\5oKN\u001cVM\u001d<feR+7\u000f\u001e\t\u0003;\u0005j\u0011A\b\u0006\u0003?\u0001\nQ!\u001e;jYNT!a\u0003\b\n\u0005\tr\"A\b+fgR\u0004\u0016\u000e]3mS:,W\u000b\u001d3bi\u0016\u001cuN\u001c;fqRl\u0015\u000e_5o!\tiB%\u0003\u0002&=\taRI^3oiZ+'/\u001b4jG\u0006$\u0018n\u001c8UKN$\b*\u001a7qKJ\u001c\u0018A\u0002\u001fj]&$h\bF\u0001)!\tI\u0002!\u0001\u0006ck&dGm\u0012:ba\"$\"aK\u0019\u0011\u00051zS\"A\u0017\u000b\u00059\u0002\u0013!B4sCBD\u0017B\u0001\u0019.\u00055!\u0015\r^1gY><xI]1qQ\")!G\u0001a\u0001g\u0005Q\u0001/\u001f;i_:$V\r\u001f;\u0011\u0005QjdBA\u001b<!\t1\u0014(D\u00018\u0015\tAd#\u0001\u0004=e>|GO\u0010\u0006\u0002u\u0005)1oY1mC&\u0011A(O\u0001\u0007!J,G-\u001a4\n\u0005yz$AB*ue&twM\u0003\u0002=s\u0005yqM]1qQ&#WM\u001c;jM&,'\u000f\u0006\u0002C\u0011B\u00111IR\u0007\u0002\t*\u0011QID\u0001\tG\u0006$\u0018\r\\=ti&\u0011q\t\u0012\u0002\u0010)\u0006\u0014G.Z%eK:$\u0018NZ5fe\")\u0011j\u0001a\u0001g\u0005!a.Y7f\u0003E)\u00070Z2vi\u0016\u0004\u0016\u0010\u001e5p]\u000e{G-\u001a\u000b\u0003\u0019r\u0003B!\u0014(Q'6\t\u0011(\u0003\u0002Ps\t1A+\u001e9mKJ\u0002\"!T)\n\u0005IK$aA%oiB\u0019A+W\u001a\u000f\u0005U;fB\u0001\u001cW\u0013\u0005Q\u0014B\u0001-:\u0003\u001d\u0001\u0018mY6bO\u0016L!AW.\u0003\u0007M+\u0017O\u0003\u0002Ys!)Q\f\u0002a\u0001g\u0005Q\u0001/\u001f;i_:\u001cu\u000eZ3\u00023Ut7/\u001e9q_J$X\rZ*rY\u000e{W.\\1oI2K7\u000f^\u000b\u0002'\u0006QRO\\:vaB|'\u000f^3e'Fd7i\\7nC:$G*[:uA\u000592/\u001e9q_J$X\rZ*rY\u000e{W.\\1oI2K7\u000f^\u0001\u0019gV\u0004\bo\u001c:uK\u0012\u001c\u0016\u000f\\\"p[6\fg\u000e\u001a'jgR\u0004\u0003")
public class PythonPipelineSuite
extends SparkDeclarativePipelinesServerTest
implements TestPipelineUpdateContextMixin,
EventVerificationTestHelpers {
    private final Seq<String> unsupportedSqlCommandList;
    private final Seq<String> supportedSqlCommandList;
    private volatile TestPipelineUpdateContextMixin$TestPipelineUpdateContext$ TestPipelineUpdateContext$module;

    public void assertFlowProgressEvent(PipelineRunEventBuffer eventBuffer, TableIdentifier identifier, FlowStatus expectedFlowStatus, EventLevel expectedEventLevel, Function1<Throwable, Object> errorChecker, Function1<String, Object> msgChecker, Function1<PipelineEvent, Object> cond, Option<Object> expectedNumOfEvents) {
        EventVerificationTestHelpers.assertFlowProgressEvent$((EventVerificationTestHelpers)this, (PipelineRunEventBuffer)eventBuffer, (TableIdentifier)identifier, (FlowStatus)expectedFlowStatus, (EventLevel)expectedEventLevel, errorChecker, msgChecker, cond, expectedNumOfEvents);
    }

    public Function1<Throwable, Object> assertFlowProgressEvent$default$5() {
        return EventVerificationTestHelpers.assertFlowProgressEvent$default$5$((EventVerificationTestHelpers)this);
    }

    public Function1<String, Object> assertFlowProgressEvent$default$6() {
        return EventVerificationTestHelpers.assertFlowProgressEvent$default$6$((EventVerificationTestHelpers)this);
    }

    public Function1<PipelineEvent, Object> assertFlowProgressEvent$default$7() {
        return EventVerificationTestHelpers.assertFlowProgressEvent$default$7$((EventVerificationTestHelpers)this);
    }

    public Option<Object> assertFlowProgressEvent$default$8() {
        return EventVerificationTestHelpers.assertFlowProgressEvent$default$8$((EventVerificationTestHelpers)this);
    }

    public void assertFlowProgressStatusInOrder(PipelineRunEventBuffer eventBuffer, TableIdentifier identifier, Seq<Tuple2<EventLevel, FlowStatus>> expectedFlowProgressStatus) {
        EventVerificationTestHelpers.assertFlowProgressStatusInOrder$((EventVerificationTestHelpers)this, (PipelineRunEventBuffer)eventBuffer, (TableIdentifier)identifier, expectedFlowProgressStatus);
    }

    public void assertNoFlowProgressEvent(PipelineRunEventBuffer eventBuffer, TableIdentifier identifier, FlowStatus flowStatus) {
        EventVerificationTestHelpers.assertNoFlowProgressEvent$((EventVerificationTestHelpers)this, (PipelineRunEventBuffer)eventBuffer, (TableIdentifier)identifier, (FlowStatus)flowStatus);
    }

    public Map<String, FlowStatus> latestFlowStatuses(PipelineRunEventBuffer eventBuffer) {
        return EventVerificationTestHelpers.latestFlowStatuses$((EventVerificationTestHelpers)this, (PipelineRunEventBuffer)eventBuffer);
    }

    public void assertPlanningEvent(PipelineRunEventBuffer eventBuffer, TableIdentifier identifier) {
        EventVerificationTestHelpers.assertPlanningEvent$((EventVerificationTestHelpers)this, (PipelineRunEventBuffer)eventBuffer, (TableIdentifier)identifier);
    }

    public void assertRunProgressEvent(PipelineRunEventBuffer eventBuffer, RunState state, EventLevel expectedEventLevel, Function1<Option<Throwable>, Object> errorChecker, Function1<String, Object> msgChecker) {
        EventVerificationTestHelpers.assertRunProgressEvent$((EventVerificationTestHelpers)this, (PipelineRunEventBuffer)eventBuffer, (RunState)state, (EventLevel)expectedEventLevel, errorChecker, msgChecker);
    }

    public Function1<Option<Throwable>, Object> assertRunProgressEvent$default$4() {
        return EventVerificationTestHelpers.assertRunProgressEvent$default$4$((EventVerificationTestHelpers)this);
    }

    public Function1<String, Object> assertRunProgressEvent$default$5() {
        return EventVerificationTestHelpers.assertRunProgressEvent$default$5$((EventVerificationTestHelpers)this);
    }

    public TestPipelineUpdateContextMixin$TestPipelineUpdateContext$ TestPipelineUpdateContext() {
        if (this.TestPipelineUpdateContext$module == null) {
            this.TestPipelineUpdateContext$lzycompute$1();
        }
        return this.TestPipelineUpdateContext$module;
    }

    public DataflowGraph buildGraph(String pythonText) {
        Seq dataflowGraphContexts;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(PythonTestDepsChecker$.MODULE$.isConnectDepsAvailable(), "org.apache.spark.sql.connect.PythonTestDepsChecker.isConnectDepsAvailable", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssume($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 52));
        String indentedPythonText = StringOps$.MODULE$.linesIterator$extension(Predef$.MODULE$.augmentString(pythonText)).map((Function1 & Serializable)x$1 -> "        " + x$1).mkString("\n");
        String customSessionIdentifier = UUID.randomUUID().toString();
        String pythonCode = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n         |from pyspark.sql import SparkSession\n         |from pyspark import pipelines as dp\n         |from pyspark.pipelines.spark_connect_graph_element_registry import (\n         |    SparkConnectGraphElementRegistry,\n         |)\n         |from pyspark.pipelines.spark_connect_pipeline import create_dataflow_graph\n         |from pyspark.pipelines.graph_element_registry import (\n         |    graph_element_registration_context,\n         |)\n         |from pyspark.pipelines.add_pipeline_analysis_context import (\n         |    add_pipeline_analysis_context\n         |)\n         |\n         |spark = SparkSession.builder \\\n         |    .remote(\"sc://localhost:" + this.serverPort() + "\") \\\n         |    .config(\"spark.connect.grpc.channel.timeout\", \"5s\") \\\n         |    .config(\"spark.custom.identifier\", \"" + customSessionIdentifier + "\") \\\n         |    .create()\n         |\n         |dataflow_graph_id = create_dataflow_graph(\n         |    spark,\n         |    default_catalog=None,\n         |    default_database=None,\n         |    sql_conf={},\n         |)\n         |\n         |registry = SparkConnectGraphElementRegistry(spark, dataflow_graph_id)\n         |with add_pipeline_analysis_context(\n         |    spark=spark, dataflow_graph_id=dataflow_graph_id, flow_name=None\n         |):\n         |    with graph_element_registration_context(registry):\n         |" + indentedPythonText + "\n         |"));
        this.logInfo((Function0 & Serializable)() -> "Running code: " + pythonCode);
        Tuple2<Object, Seq<String>> tuple2 = this.executePythonCode(pythonCode);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int exitCode = tuple2._1$mcI$sp();
        Seq output = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)exitCode), (Object)output);
        int exitCode2 = tuple22._1$mcI$sp();
        Seq output2 = (Seq)tuple22._2();
        if (exitCode2 != 0) {
            throw new RuntimeException("Python process failed with exit code " + exitCode2 + ". Output: " + output2.mkString("\n"));
        }
        Seq activeSessions = SparkConnectService$.MODULE$.sessionManager().listActiveSessions();
        SessionHolder sessionHolder = (SessionHolder)((IterableOnceOps)activeSessions.map((Function1 & Serializable)info -> SparkConnectService$.MODULE$.sessionManager().getIsolatedSession(info.key(), (Option)None$.MODULE$))).find((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)PythonPipelineSuite.$anonfun$buildGraph$4(customSessionIdentifier, x$3))).getOrElse((Function0 & Serializable)() -> {
            throw new RuntimeException("Session with identifier " + customSessionIdentifier + " not found");
        });
        Seq $org_scalatest_assert_macro_left = dataflowGraphContexts = sessionHolder.dataflowGraphRegistry().getAllDataflowGraphs();
        int $org_scalatest_assert_macro_right = 1;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 110));
        return ((GraphRegistrationContext)dataflowGraphContexts.head()).toDataflowGraph();
    }

    public TableIdentifier graphIdentifier(String name) {
        Option x$1 = Option$.MODULE$.apply((Object)"spark_catalog");
        Option x$2 = Option$.MODULE$.apply((Object)"default");
        String x$3 = name;
        return new TableIdentifier(x$3, x$2, x$1);
    }

    private Tuple2<Object, Seq<String>> executePythonCode(String pythonCode) {
        String pythonExec = (String)scala.sys.package$.MODULE$.env().getOrElse((Object)"PYSPARK_DRIVER_PYTHON", (Function0 & Serializable)() -> (String)scala.sys.package$.MODULE$.env().getOrElse((Object)"PYSPARK_PYTHON", (Function0 & Serializable)() -> "python3"));
        String sparkHome = (String)scala.sys.package$.MODULE$.props().getOrElse((Object)"spark.test.home", (Function0 & Serializable)() -> (String)scala.sys.package$.MODULE$.env().getOrElse((Object)"SPARK_HOME", (Function0 & Serializable)() -> "."));
        Path sourcePath = Paths.get(sparkHome, "python").toAbsolutePath();
        Path py4jPath = Paths.get(sparkHome, "python", "lib", PythonUtils$.MODULE$.PY4J_ZIP_NAME()).toAbsolutePath();
        String pythonPath = PythonUtils$.MODULE$.mergePythonPaths((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{((Object)sourcePath).toString(), ((Object)py4jPath).toString(), (String)scala.sys.package$.MODULE$.env().getOrElse((Object)"PYTHONPATH", (Function0 & Serializable)() -> "")}));
        ProcessBuilder pb = new ProcessBuilder(pythonExec, "-c", pythonCode);
        pb.redirectErrorStream(true);
        pb.environment().put("PYTHONPATH", pythonPath);
        Process process = pb.start();
        BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8));
        ArrayBuffer output = new ArrayBuffer();
        String line2 = null;
        while ((line2 = reader.readLine()) != null) {
            output.$plus$eq((Object)line2);
            Predef$.MODULE$.println((Object)("Python output: " + line2));
        }
        process.waitFor(60L, TimeUnit.SECONDS);
        int exitCode = process.exitValue();
        if (exitCode != 0) {
            Console$.MODULE$.err().println("Python process failed with exit code " + exitCode);
            Console$.MODULE$.err().println("Output:");
            output.foreach((Function1 & Serializable)line -> {
                PythonPipelineSuite.$anonfun$executePythonCode$6(line);
                return BoxedUnit.UNIT;
            });
        }
        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)exitCode), (Object)output.toSeq());
    }

    private Seq<String> unsupportedSqlCommandList() {
        return this.unsupportedSqlCommandList;
    }

    public Seq<String> supportedSqlCommandList() {
        return this.supportedSqlCommandList;
    }

    private final void TestPipelineUpdateContext$lzycompute$1() {
        PythonPipelineSuite pythonPipelineSuite = this;
        synchronized (pythonPipelineSuite) {
            if (this.TestPipelineUpdateContext$module == null) {
                this.TestPipelineUpdateContext$module = new TestPipelineUpdateContextMixin$TestPipelineUpdateContext$((TestPipelineUpdateContextMixin)this);
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$buildGraph$4(String customSessionIdentifier$1, SessionHolder x$3) {
        String string = x$3.session().conf().get("spark.custom.identifier");
        String string2 = customSessionIdentifier$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$new$3(PipelineEvent flowProgressEvent) {
        Option option = flowProgressEvent.origin().sourceCodeLocation();
        Option x$1 = Option$.MODULE$.apply((Object)new Language.Python());
        Option x$2 = Option$.MODULE$.apply((Object)"<string>");
        Option x$3 = Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)34));
        Option x$4 = Option$.MODULE$.apply((Object)"spark_catalog.default.table1");
        Option x$5 = Option$.MODULE$.apply((Object)QueryOriginType$.MODULE$.Flow().toString());
        Option x$6 = QueryOrigin$.MODULE$.apply$default$3();
        Option x$7 = QueryOrigin$.MODULE$.apply$default$5();
        Option option2 = Option$.MODULE$.apply((Object)new QueryOrigin(x$1, x$2, x$6, x$3, x$7, x$5, x$4));
        return !(option != null ? !option.equals(option2) : option2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$new$4(Throwable ex) {
        return ex.getMessage().contains("A column, variable, or function parameter with name `name` cannot be resolved.");
    }

    public static final /* synthetic */ boolean $anonfun$new$7(PipelineEvent flowProgressEvent) {
        Option option = flowProgressEvent.origin().sourceCodeLocation();
        Option x$16 = Option$.MODULE$.apply((Object)new Language.Python());
        Option x$17 = Option$.MODULE$.apply((Object)"<string>");
        Option x$18 = Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)40));
        Option x$19 = Option$.MODULE$.apply((Object)"spark_catalog.default.mv2");
        Option x$20 = Option$.MODULE$.apply((Object)QueryOriginType$.MODULE$.Flow().toString());
        Option x$21 = QueryOrigin$.MODULE$.apply$default$3();
        Option x$22 = QueryOrigin$.MODULE$.apply$default$5();
        Option option2 = Option$.MODULE$.apply((Object)new QueryOrigin(x$16, x$17, x$21, x$18, x$22, x$20, x$19));
        return !(option != null ? !option.equals(option2) : option2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$new$8(PipelineEvent flowProgressEvent) {
        Option option = flowProgressEvent.origin().sourceCodeLocation();
        Option x$31 = Option$.MODULE$.apply((Object)new Language.Python());
        Option x$32 = Option$.MODULE$.apply((Object)"<string>");
        Option x$33 = Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)44));
        Option x$34 = Option$.MODULE$.apply((Object)"spark_catalog.default.mv");
        Option x$35 = Option$.MODULE$.apply((Object)QueryOriginType$.MODULE$.Flow().toString());
        Option x$36 = QueryOrigin$.MODULE$.apply$default$3();
        Option x$37 = QueryOrigin$.MODULE$.apply$default$5();
        Option option2 = Option$.MODULE$.apply((Object)new QueryOrigin(x$31, x$32, x$36, x$33, x$37, x$35, x$34));
        return !(option != null ? !option.equals(option2) : option2 != null);
    }

    public static final /* synthetic */ void $anonfun$new$6(PythonPipelineSuite $this, TestPipelineUpdateContextMixin.TestPipelineUpdateContext updateContext$1, Product flowStatus) {
        PipelineRunEventBuffer x$23 = updateContext$1.eventBuffer();
        TableIdentifier x$24 = $this.graphIdentifier("mv2");
        Product x$25 = flowStatus;
        Function1 & Serializable x$26 = (Function1 & Serializable)flowProgressEvent -> BoxesRunTime.boxToBoolean((boolean)PythonPipelineSuite.$anonfun$new$7(flowProgressEvent));
        EventLevel.INFO$ x$27 = EventLevel.INFO$.MODULE$;
        Function1<Throwable, Object> x$28 = $this.assertFlowProgressEvent$default$5();
        Function1<String, Object> x$29 = $this.assertFlowProgressEvent$default$6();
        Option<Object> x$30 = $this.assertFlowProgressEvent$default$8();
        $this.assertFlowProgressEvent(x$23, x$24, (FlowStatus)x$25, (EventLevel)x$27, x$28, x$29, (Function1<PipelineEvent, Object>)x$26, x$30);
        PipelineRunEventBuffer x$38 = updateContext$1.eventBuffer();
        TableIdentifier x$39 = $this.graphIdentifier("mv");
        Product x$40 = flowStatus;
        Function1 & Serializable x$41 = (Function1 & Serializable)flowProgressEvent -> BoxesRunTime.boxToBoolean((boolean)PythonPipelineSuite.$anonfun$new$8(flowProgressEvent));
        EventLevel.INFO$ x$42 = EventLevel.INFO$.MODULE$;
        Function1<Throwable, Object> x$43 = $this.assertFlowProgressEvent$default$5();
        Function1<String, Object> x$44 = $this.assertFlowProgressEvent$default$6();
        Option<Object> x$45 = $this.assertFlowProgressEvent$default$8();
        $this.assertFlowProgressEvent(x$38, x$39, (FlowStatus)x$40, (EventLevel)x$42, x$43, x$44, (Function1<PipelineEvent, Object>)x$41, x$45);
    }

    public static final /* synthetic */ boolean $anonfun$new$10(PipelineEvent flowProgressEvent) {
        Option option = flowProgressEvent.origin().sourceCodeLocation();
        Option x$46 = Option$.MODULE$.apply((Object)new Language.Python());
        Option x$47 = Option$.MODULE$.apply((Object)"<string>");
        Option x$48 = Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)34));
        Option x$49 = Option$.MODULE$.apply((Object)"spark_catalog.default.table1");
        Option x$50 = Option$.MODULE$.apply((Object)QueryOriginType$.MODULE$.Flow().toString());
        Option x$51 = QueryOrigin$.MODULE$.apply$default$3();
        Option x$52 = QueryOrigin$.MODULE$.apply$default$5();
        Option option2 = Option$.MODULE$.apply((Object)new QueryOrigin(x$46, x$47, x$51, x$48, x$52, x$50, x$49));
        return !(option != null ? !option.equals(option2) : option2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$new$11(PipelineEvent flowProgressEvent) {
        Option option = flowProgressEvent.origin().sourceCodeLocation();
        Option x$61 = Option$.MODULE$.apply((Object)new Language.Python());
        Option x$62 = Option$.MODULE$.apply((Object)"<string>");
        Option x$63 = Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)49));
        Option x$64 = Option$.MODULE$.apply((Object)"spark_catalog.default.standalone_flow1");
        Option x$65 = Option$.MODULE$.apply((Object)QueryOriginType$.MODULE$.Flow().toString());
        Option x$66 = QueryOrigin$.MODULE$.apply$default$3();
        Option x$67 = QueryOrigin$.MODULE$.apply$default$5();
        Option option2 = Option$.MODULE$.apply((Object)new QueryOrigin(x$61, x$62, x$66, x$63, x$67, x$65, x$64));
        return !(option != null ? !option.equals(option2) : option2 != null);
    }

    public static final /* synthetic */ void $anonfun$new$9(PythonPipelineSuite $this, TestPipelineUpdateContextMixin.TestPipelineUpdateContext updateContext$1, Product flowStatus) {
        PipelineRunEventBuffer x$53 = updateContext$1.eventBuffer();
        TableIdentifier x$54 = $this.graphIdentifier("table1");
        Product x$55 = flowStatus;
        Function1 & Serializable x$56 = (Function1 & Serializable)flowProgressEvent -> BoxesRunTime.boxToBoolean((boolean)PythonPipelineSuite.$anonfun$new$10(flowProgressEvent));
        EventLevel.INFO$ x$57 = EventLevel.INFO$.MODULE$;
        Function1<Throwable, Object> x$58 = $this.assertFlowProgressEvent$default$5();
        Function1<String, Object> x$59 = $this.assertFlowProgressEvent$default$6();
        Option<Object> x$60 = $this.assertFlowProgressEvent$default$8();
        $this.assertFlowProgressEvent(x$53, x$54, (FlowStatus)x$55, (EventLevel)x$57, x$58, x$59, (Function1<PipelineEvent, Object>)x$56, x$60);
        PipelineRunEventBuffer x$68 = updateContext$1.eventBuffer();
        TableIdentifier x$69 = $this.graphIdentifier("standalone_flow1");
        Product x$70 = flowStatus;
        Function1 & Serializable x$71 = (Function1 & Serializable)flowProgressEvent -> BoxesRunTime.boxToBoolean((boolean)PythonPipelineSuite.$anonfun$new$11(flowProgressEvent));
        EventLevel.INFO$ x$72 = EventLevel.INFO$.MODULE$;
        Function1<Throwable, Object> x$73 = $this.assertFlowProgressEvent$default$5();
        Function1<String, Object> x$74 = $this.assertFlowProgressEvent$default$6();
        Option<Object> x$75 = $this.assertFlowProgressEvent$default$8();
        $this.assertFlowProgressEvent(x$68, x$69, (FlowStatus)x$70, (EventLevel)x$72, x$73, x$74, (Function1<PipelineEvent, Object>)x$71, x$75);
    }

    public static final /* synthetic */ boolean $anonfun$new$18(Sink x$7) {
        TableIdentifier tableIdentifier = x$7.identifier();
        TableIdentifier tableIdentifier2 = TableIdentifier$.MODULE$.apply("myKafkaSink");
        return !(tableIdentifier != null ? !tableIdentifier.equals(tableIdentifier2) : tableIdentifier2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$new$23(ResolvedFlow x$9) {
        return x$9.df().isStreaming();
    }

    public static final /* synthetic */ boolean $anonfun$new$28(ResolvedFlow x$14) {
        return x$14.inputs().isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$new$29(ResolvedFlow x$15) {
        return x$15.df().isStreaming();
    }

    public static final /* synthetic */ boolean $anonfun$new$38(ResolvedFlow x$20) {
        return x$20.inputs().isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$new$39(ResolvedFlow x$21) {
        return !x$21.df().isStreaming();
    }

    public static final /* synthetic */ boolean $anonfun$new$42(ResolvedFlow x$23) {
        return !x$23.df().isStreaming();
    }

    public static final /* synthetic */ void $anonfun$new$43(PythonPipelineSuite $this, String command) {
        RuntimeException ex = (RuntimeException)$this.intercept((Function0 & Serializable)() -> $this.buildGraph(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |@dp.materialized_view\n        |def src():\n        |  return spark.range(5)\n        |\n        |spark_sql_df = " + command + "\n        |\n        |@dp.materialized_view\n        |def mv_from_spark_sql_df():\n        |  return spark_sql_df\n        |"))), ClassTag$.MODULE$.apply(RuntimeException.class), new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 533));
        String $org_scalatest_assert_macro_left = ex.getMessage();
        String $org_scalatest_assert_macro_right = "TABLE_OR_VIEW_NOT_FOUND";
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 546));
        String $org_scalatest_assert_macro_left2 = ex.getMessage();
        String $org_scalatest_assert_macro_right2 = "`src`";
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 547));
    }

    public static final /* synthetic */ void $anonfun$new$65(PipelineEvent x$33) {
    }

    public static final /* synthetic */ void $anonfun$new$72(PipelineEvent x$35) {
    }

    public static final /* synthetic */ Tuple2 $anonfun$new$76(int id) {
        return new Tuple2.mcJJ.sp((long)id, (long)(id % 2));
    }

    public static final /* synthetic */ void $anonfun$executePythonCode$6(String line) {
        Console$.MODULE$.err().println(line);
    }

    public static final /* synthetic */ void $anonfun$new$91(PipelineEvent x$37) {
    }

    public static final /* synthetic */ void $anonfun$new$92(PythonPipelineSuite $this, String unsupportedSqlCommand) {
        RuntimeException ex = (RuntimeException)$this.intercept((Function0 & Serializable)() -> $this.buildGraph(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |spark.sql(\"" + unsupportedSqlCommand + "\")\n        |\n        |@dp.materialized_view()\n        |def mv():\n        |  return spark.range(5)\n        |"))), ClassTag$.MODULE$.apply(RuntimeException.class), new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1050));
        String $org_scalatest_assert_macro_left = ex.getMessage();
        String $org_scalatest_assert_macro_right = "UNSUPPORTED_PIPELINE_SPARK_SQL_COMMAND";
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1059));
    }

    public static final /* synthetic */ void $anonfun$new$94(PythonPipelineSuite $this, String unsupportedSqlCommand) {
        RuntimeException ex = (RuntimeException)$this.intercept((Function0 & Serializable)() -> $this.buildGraph(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |@dp.materialized_view()\n        |def mv():\n        |  spark.sql(\"" + unsupportedSqlCommand + "\")\n        |  return spark.range(5)\n        |"))), ClassTag$.MODULE$.apply(RuntimeException.class), new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1064));
        String $org_scalatest_assert_macro_left = ex.getMessage();
        String $org_scalatest_assert_macro_right = "UNSUPPORTED_PIPELINE_SPARK_SQL_COMMAND";
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1072));
    }

    public static final /* synthetic */ void $anonfun$new$96(PythonPipelineSuite $this, String supportedSqlCommand) {
        $this.sql().apply((Object)"CREATE TABLE spark_catalog.default.src AS SELECT * FROM RANGE(5)");
        $this.buildGraph(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |spark.sql(\"" + supportedSqlCommand + "\")\n        |\n        |@dp.materialized_view()\n        |def mv():\n        |  return spark.range(5)\n        |")));
    }

    public static final /* synthetic */ void $anonfun$new$97(PythonPipelineSuite $this, String supportedSqlCommand) {
        $this.sql().apply((Object)"CREATE TABLE spark_catalog.default.src AS SELECT * FROM RANGE(5)");
        $this.buildGraph(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |@dp.materialized_view()\n        |def mv():\n        |  spark.sql(\"" + supportedSqlCommand + "\")\n        |  return spark.range(5)\n        |")));
    }

    public PythonPipelineSuite() {
        TestPipelineUpdateContextMixin.$init$((TestPipelineUpdateContextMixin)this);
        EventVerificationTestHelpers.$init$((EventVerificationTestHelpers)this);
        this.test("basic", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            DataflowGraph graph = this.buildGraph(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |@dp.table\n        |def table1():\n        |    return spark.readStream.format(\"rate\").load()\n        |"))).resolve().validate();
            Seq $org_scalatest_assert_macro_left = graph.flows();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 127));
            Seq $org_scalatest_assert_macro_left2 = graph.tables();
            int $org_scalatest_assert_macro_right2 = 1;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left2, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 128));
        }, new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 119));
        this.test("failed flow progress event has correct python source code location", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            DataflowGraph unresolvedGraph = this.buildGraph(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |@dp.table()\n        |def table1():\n        |    df = spark.createDataFrame([(25,), (30,), (45,)], [\"age\"])\n        |    return df.select(\"name\")\n        |")));
            TestPipelineUpdateContextMixin.TestPipelineUpdateContext updateContext = new TestPipelineUpdateContextMixin.TestPipelineUpdateContext((TestPipelineUpdateContextMixin)this, this.spark(), unresolvedGraph, this.storageRoot(), this.TestPipelineUpdateContext().apply$default$4(), this.TestPipelineUpdateContext().apply$default$5(), this.TestPipelineUpdateContext().apply$default$6(), this.TestPipelineUpdateContext().apply$default$7());
            updateContext.pipelineExecution().runPipeline();
            PipelineRunEventBuffer x$8 = updateContext.eventBuffer();
            TableIdentifier x$9 = this.graphIdentifier("table1");
            FlowStatus.FAILED$ x$10 = FlowStatus.FAILED$.MODULE$;
            Function1 & Serializable x$11 = (Function1 & Serializable)flowProgressEvent -> BoxesRunTime.boxToBoolean((boolean)PythonPipelineSuite.$anonfun$new$3(flowProgressEvent));
            Function1 & Serializable x$12 = (Function1 & Serializable)ex -> BoxesRunTime.boxToBoolean((boolean)PythonPipelineSuite.$anonfun$new$4(ex));
            EventLevel.WARN$ x$13 = EventLevel.WARN$.MODULE$;
            Function1<String, Object> x$14 = this.assertFlowProgressEvent$default$6();
            Option<Object> x$15 = this.assertFlowProgressEvent$default$8();
            this.assertFlowProgressEvent(x$8, x$9, (FlowStatus)x$10, (EventLevel)x$13, (Function1<Throwable, Object>)x$12, x$14, (Function1<PipelineEvent, Object>)x$11, x$15);
        }, new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 131));
        this.test("flow progress events have correct python source code location", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            DataflowGraph unresolvedGraph = this.buildGraph(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |@dp.table(\n        | comment = 'my table'\n        |)\n        |def table1():\n        |    return spark.readStream.table('mv')\n        |\n        |@dp.materialized_view\n        |def mv2():\n        |   return spark.range(26, 29)\n        |\n        |@dp.materialized_view\n        |def mv():\n        |   df = spark.createDataFrame([(25,), (30,), (45,)], [\"age\"])\n        |   return df.select(\"age\")\n        |\n        |@dp.append_flow(\n        | target = 'table1'\n        |)\n        |def standalone_flow1():\n        |   return spark.readStream.table('mv2')\n        |")));
            TestPipelineUpdateContextMixin.TestPipelineUpdateContext updateContext = new TestPipelineUpdateContextMixin.TestPipelineUpdateContext((TestPipelineUpdateContextMixin)this, this.spark(), unresolvedGraph, this.storageRoot(), this.TestPipelineUpdateContext().apply$default$4(), this.TestPipelineUpdateContext().apply$default$5(), this.TestPipelineUpdateContext().apply$default$6(), this.TestPipelineUpdateContext().apply$default$7());
            updateContext.pipelineExecution().runPipeline();
            updateContext.pipelineExecution().awaitCompletion();
            new .colon.colon((Object)FlowStatus.QUEUED$.MODULE$, (List)new .colon.colon((Object)FlowStatus.STARTING$.MODULE$, (List)new .colon.colon((Object)FlowStatus.PLANNING$.MODULE$, (List)new .colon.colon((Object)FlowStatus.RUNNING$.MODULE$, (List)new .colon.colon((Object)FlowStatus.COMPLETED$.MODULE$, (List)Nil$.MODULE$))))).foreach((Function1 & Serializable)flowStatus -> {
                PythonPipelineSuite.$anonfun$new$6(this, updateContext, flowStatus);
                return BoxedUnit.UNIT;
            });
            new .colon.colon((Object)FlowStatus.QUEUED$.MODULE$, (List)new .colon.colon((Object)FlowStatus.STARTING$.MODULE$, (List)new .colon.colon((Object)FlowStatus.RUNNING$.MODULE$, (List)new .colon.colon((Object)FlowStatus.COMPLETED$.MODULE$, (List)Nil$.MODULE$)))).foreach((Function1 & Serializable)flowStatus -> {
                PythonPipelineSuite.$anonfun$new$9(this, updateContext, flowStatus);
                return BoxedUnit.UNIT;
            });
        }, new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 161));
        this.test("basic with inverted topological order", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            DataflowGraph graph = this.buildGraph(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |@dp.table()\n        |def b():\n        |  return spark.readStream.table(\"a\")\n        |\n        |@dp.table()\n        |def c():\n        |  return spark.readStream.table(\"a\")\n        |\n        |@dp.materialized_view()\n        |def d():\n        |  return spark.read.table(\"a\")\n        |\n        |@dp.materialized_view()\n        |def a():\n        |  return spark.range(5)\n        |")));
            DataflowGraph resolvedGraph = graph.resolve().validate();
            Seq $org_scalatest_assert_macro_left = resolvedGraph.tables();
            int $org_scalatest_assert_macro_right = 4;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 277));
            Seq $org_scalatest_assert_macro_left2 = resolvedGraph.resolvedFlows();
            int $org_scalatest_assert_macro_right2 = 4;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left2, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 278));
        }, new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 257));
        this.test("flows", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            DataflowGraph graph = this.buildGraph(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n      |@dp.table()\n      |def a():\n      |  return spark.readStream.format(\"rate\").load()\n      |\n      |@dp.append_flow(target = \"a\")\n      |def supplement():\n      |  return spark.readStream.format(\"rate\").load()\n      |"))).resolve().validate();
            scala.collection.immutable.Set $org_scalatest_assert_macro_left = ((IterableOnceOps)graph.tables().map((Function1 & Serializable)x$4 -> x$4.identifier().table())).toSet();
            scala.collection.immutable.Set $org_scalatest_assert_macro_right = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"a"}));
            scala.collection.immutable.Set set = $org_scalatest_assert_macro_left;
            scala.collection.immutable.Set set2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(set != null ? !set.equals(set2) : set2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 292));
            Seq $org_scalatest_assert_macro_left2 = graph.resolvedFlows();
            int $org_scalatest_assert_macro_right2 = 2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left2, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 293));
            scala.collection.immutable.Set $org_scalatest_assert_macro_left3 = ((IterableOnceOps)((IterableOps)graph.flowsTo().apply((Object)this.graphIdentifier("a"))).map((Function1 & Serializable)x$5 -> x$5.identifier())).toSet();
            scala.collection.immutable.Set $org_scalatest_assert_macro_right3 = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TableIdentifier[]{this.graphIdentifier("a"), this.graphIdentifier("supplement")}));
            scala.collection.immutable.Set set3 = $org_scalatest_assert_macro_left3;
            scala.collection.immutable.Set set4 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(set3 != null ? !set3.equals(set4) : set4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 294));
        }, new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 281));
        this.test("external sink", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            DataflowGraph graph = this.buildGraph(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |dp.create_sink(\n        |  \"myKafkaSink\",\n        |  format = \"kafka\",\n        |  options = {\"kafka.bootstrap.servers\": \"host1:port1,host2:port2\"}\n        |)\n        |\n        |@dp.append_flow(\n        |  target = \"myKafkaSink\"\n        |)\n        |def mySinkFlow():\n        |  return spark.readStream.format(\"rate\").load()\n        |")));
            Seq $org_scalatest_assert_macro_left = (Seq)graph.sinks().map((Function1 & Serializable)x$6 -> x$6.identifier());
            .colon.colon $org_scalatest_assert_macro_right = new .colon.colon((Object)TableIdentifier$.MODULE$.apply("myKafkaSink"), (List)Nil$.MODULE$);
            Seq seq = $org_scalatest_assert_macro_left;
            .colon.colon colon2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(seq != null ? !seq.equals(colon2) : colon2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 315));
            ((IterableOnceOps)graph.sinks().filter((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)PythonPipelineSuite.$anonfun$new$18(x$7)))).foreach((Function1 & Serializable)sink -> {
                String $org_scalatest_assert_macro_left = sink.format();
                String $org_scalatest_assert_macro_right = "kafka";
                String string = $org_scalatest_assert_macro_left;
                String string2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 319));
                Option $org_scalatest_assert_macro_left2 = sink.options().get((Object)"kafka.bootstrap.servers");
                String $org_scalatest_assert_macro_right2 = "host1:port1,host2:port2";
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains((Object)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 320));
            });
            Seq $org_scalatest_assert_macro_left2 = (Seq)((IterableOps)graph.flowsTo().apply((Object)TableIdentifier$.MODULE$.apply("myKafkaSink"))).map((Function1 & Serializable)x$8 -> x$8.identifier());
            .colon.colon $org_scalatest_assert_macro_right2 = new .colon.colon((Object)TableIdentifier$.MODULE$.apply("mySinkFlow"), (List)Nil$.MODULE$);
            Seq seq2 = $org_scalatest_assert_macro_left2;
            .colon.colon colon3 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(seq2 != null ? !seq2.equals(colon3) : colon3 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 324));
        }, new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 300));
        this.test("referencing internal datasets", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            DataflowGraph graph = this.buildGraph(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n      |@dp.materialized_view\n      |def src():\n      |  return spark.range(5)\n      |\n      |@dp.materialized_view\n      |def a():\n      |  return spark.read.table(\"src\")\n      |\n      |@dp.table\n      |def b():\n      |  return spark.readStream.table(\"src\")\n      |\n      |@dp.materialized_view\n      |def c():\n      |  return spark.sql(\"SELECT * FROM src\")\n      |\n      |@dp.table\n      |def d():\n      |  return spark.sql(\"SELECT * FROM STREAM src\")\n      |"))).resolve().validate();
            scala.collection.immutable.Set $org_scalatest_assert_macro_left = graph.table().keySet();
            scala.collection.immutable.Set $org_scalatest_assert_macro_right = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TableIdentifier[]{this.graphIdentifier("src"), this.graphIdentifier("a"), this.graphIdentifier("b"), this.graphIdentifier("c"), this.graphIdentifier("d")}));
            scala.collection.immutable.Set set = $org_scalatest_assert_macro_left;
            scala.collection.immutable.Set set2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(set != null ? !set.equals(set2) : set2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 353));
            new .colon.colon((Object)"a", (List)new .colon.colon((Object)"b", (List)new .colon.colon((Object)"c", (List)Nil$.MODULE$))).foreach((Function1 & Serializable)flowName -> {
                scala.collection.immutable.Set $org_scalatest_assert_macro_left = ((ResolvedFlow)graph.resolvedFlow().apply((Object)this.graphIdentifier((String)flowName))).inputs();
                scala.collection.immutable.Set $org_scalatest_assert_macro_right = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TableIdentifier[]{this.graphIdentifier("src")}));
                scala.collection.immutable.Set set = $org_scalatest_assert_macro_left;
                scala.collection.immutable.Set set2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(set != null ? !set.equals(set2) : set2 != null), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 362));
            });
            Tuple2 tuple2 = graph.resolvedFlows().partition((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)PythonPipelineSuite.$anonfun$new$23(x$9)));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Seq streamingFlows = (Seq)tuple2._1();
            Seq batchFlows = (Seq)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)streamingFlows, (Object)batchFlows);
            Seq streamingFlows2 = (Seq)tuple22._1();
            Seq batchFlows2 = (Seq)tuple22._2();
            scala.collection.immutable.Set $org_scalatest_assert_macro_left2 = ((IterableOnceOps)batchFlows2.map((Function1 & Serializable)x$11 -> x$11.identifier())).toSet();
            scala.collection.immutable.Set $org_scalatest_assert_macro_right2 = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TableIdentifier[]{this.graphIdentifier("src"), this.graphIdentifier("a"), this.graphIdentifier("c")}));
            scala.collection.immutable.Set set3 = $org_scalatest_assert_macro_left2;
            scala.collection.immutable.Set set4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(set3 != null ? !set3.equals(set4) : set4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 366));
            scala.collection.immutable.Set $org_scalatest_assert_macro_left3 = ((IterableOnceOps)streamingFlows2.map((Function1 & Serializable)x$12 -> x$12.identifier())).toSet();
            scala.collection.immutable.Set $org_scalatest_assert_macro_right3 = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TableIdentifier[]{this.graphIdentifier("b"), this.graphIdentifier("d")}));
            scala.collection.immutable.Set set5 = $org_scalatest_assert_macro_left3;
            scala.collection.immutable.Set set6 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(set5 != null ? !set5.equals(set6) : set6 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 371));
        }, new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 330));
        this.test("referencing external datasets", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            this.sql().apply((Object)"CREATE TABLE spark_catalog.default.src AS SELECT * FROM RANGE(5)");
            DataflowGraph graph = this.buildGraph(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |@dp.materialized_view\n        |def a():\n        |  return spark.read.table(\"spark_catalog.default.src\")\n        |\n        |@dp.materialized_view\n        |def b():\n        |  return spark.table(\"spark_catalog.default.src\")\n        |\n        |@dp.table\n        |def c():\n        |  return spark.readStream.table(\"spark_catalog.default.src\")\n        |\n        |@dp.materialized_view\n        |def d():\n        |  return spark.sql(\"SELECT * FROM spark_catalog.default.src\")\n        |\n        |@dp.table\n        |def e():\n        |  return spark.sql(\"SELECT * FROM STREAM spark_catalog.default.src\")\n        |"))).resolve().validate();
            scala.collection.immutable.Set $org_scalatest_assert_macro_left = ((IterableOnceOps)graph.tables().map((Function1 & Serializable)x$13 -> x$13.identifier())).toSet();
            scala.collection.immutable.Set $org_scalatest_assert_macro_right = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TableIdentifier[]{this.graphIdentifier("a"), this.graphIdentifier("b"), this.graphIdentifier("c"), this.graphIdentifier("d"), this.graphIdentifier("e")}));
            scala.collection.immutable.Set set = $org_scalatest_assert_macro_left;
            scala.collection.immutable.Set set2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(set != null ? !set.equals(set2) : set2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 400));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(graph.resolvedFlows().forall((Function1 & Serializable)x$14 -> BoxesRunTime.boxToBoolean((boolean)PythonPipelineSuite.$anonfun$new$28(x$14))), "graph.resolvedFlows.forall(((x$14: org.apache.spark.sql.pipelines.graph.ResolvedFlow) => x$14.inputs.isEmpty))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 408));
            Tuple2 tuple2 = graph.resolvedFlows().partition((Function1 & Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)PythonPipelineSuite.$anonfun$new$29(x$15)));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Seq streamingFlows = (Seq)tuple2._1();
            Seq batchFlows = (Seq)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)streamingFlows, (Object)batchFlows);
            Seq streamingFlows2 = (Seq)tuple22._1();
            Seq batchFlows2 = (Seq)tuple22._2();
            scala.collection.immutable.Set $org_scalatest_assert_macro_left2 = ((IterableOnceOps)batchFlows2.map((Function1 & Serializable)x$17 -> x$17.identifier())).toSet();
            scala.collection.immutable.Set $org_scalatest_assert_macro_right2 = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TableIdentifier[]{this.graphIdentifier("a"), this.graphIdentifier("b"), this.graphIdentifier("d")}));
            scala.collection.immutable.Set set3 = $org_scalatest_assert_macro_left2;
            scala.collection.immutable.Set set4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(set3 != null ? !set3.equals(set4) : set4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 410));
            scala.collection.immutable.Set $org_scalatest_assert_macro_left3 = ((IterableOnceOps)streamingFlows2.map((Function1 & Serializable)x$18 -> x$18.identifier())).toSet();
            scala.collection.immutable.Set $org_scalatest_assert_macro_right3 = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TableIdentifier[]{this.graphIdentifier("c"), this.graphIdentifier("e")}));
            scala.collection.immutable.Set set5 = $org_scalatest_assert_macro_left3;
            scala.collection.immutable.Set set6 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(set5 != null ? !set5.equals(set6) : set6 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 415));
        }, new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 376));
        this.test("referencing internal datasets failed", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            DataflowGraph graph = this.buildGraph(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |@dp.table\n        |def a():\n        |  return spark.read.table(\"src\")\n        |\n        |@dp.table\n        |def b():\n        |  return spark.table(\"src\")\n        |\n        |@dp.table\n        |def c():\n        |  return spark.readStream.table(\"src\")\n        |\n        |@dp.materialized_view\n        |def d():\n        |  return spark.sql(\"SELECT * FROM src\")\n        |\n        |@dp.table\n        |def e():\n        |  return spark.sql(\"SELECT * FROM STREAM src\")\n        |"))).resolve();
            Seq $org_scalatest_assert_macro_left = graph.resolutionFailedFlows();
            int $org_scalatest_assert_macro_right = 5;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 442));
            graph.resolutionFailedFlows().foreach((Function1 & Serializable)flow -> {
                String $org_scalatest_assert_macro_left = ((Throwable)flow.failure().head()).getMessage();
                String $org_scalatest_assert_macro_right = "[TABLE_OR_VIEW_NOT_FOUND]";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 444));
                String $org_scalatest_assert_macro_left2 = ((Throwable)flow.failure().head()).getMessage();
                String $org_scalatest_assert_macro_right2 = "`src`";
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 445));
            });
        }, new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 419));
        this.test("referencing external datasets failed", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            DataflowGraph graph = this.buildGraph(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |@dp.table\n        |def a():\n        |  return spark.read.table(\"spark_catalog.default.src\")\n        |\n        |@dp.materialized_view\n        |def b():\n        |  return spark.table(\"spark_catalog.default.src\")\n        |\n        |@dp.materialized_view\n        |def c():\n        |  return spark.readStream.table(\"spark_catalog.default.src\")\n        |\n        |@dp.materialized_view\n        |def d():\n        |  return spark.sql(\"SELECT * FROM spark_catalog.default.src\")\n        |\n        |@dp.table\n        |def e():\n        |  return spark.sql(\"SELECT * FROM STREAM spark_catalog.default.src\")\n        |"))).resolve();
            Seq $org_scalatest_assert_macro_left = graph.resolutionFailedFlows();
            int $org_scalatest_assert_macro_right = 5;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 471));
            graph.resolutionFailedFlows().foreach((Function1 & Serializable)flow -> {
                String $org_scalatest_assert_macro_left = ((Throwable)flow.failure().head()).getMessage();
                String $org_scalatest_assert_macro_right = "[TABLE_OR_VIEW_NOT_FOUND]";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 473));
                String $org_scalatest_assert_macro_left2 = ((Throwable)flow.failure().head()).getMessage();
                String $org_scalatest_assert_macro_right2 = "`spark_catalog`.`default`.`src`";
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 474));
            });
        }, new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 449));
        this.test("reading external datasets outside query function works", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            this.sql().apply((Object)"CREATE TABLE spark_catalog.default.src AS SELECT * FROM RANGE(5)");
            DataflowGraph graph = this.buildGraph(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |spark_sql_df = spark.sql(\"SELECT * FROM spark_catalog.default.src\")\n        |read_table_df = spark.read.table(\"spark_catalog.default.src\")\n        |\n        |@dp.materialized_view\n        |def mv_from_spark_sql_df():\n        |  return spark_sql_df\n        |\n        |@dp.materialized_view\n        |def mv_from_read_table_df():\n        |  return read_table_df\n        |"))).resolve().validate();
            scala.collection.immutable.Set $org_scalatest_assert_macro_left = ((IterableOnceOps)graph.resolvedFlows().map((Function1 & Serializable)x$19 -> x$19.identifier())).toSet();
            scala.collection.immutable.Set $org_scalatest_assert_macro_right = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TableIdentifier[]{this.graphIdentifier("mv_from_spark_sql_df"), this.graphIdentifier("mv_from_read_table_df")}));
            scala.collection.immutable.Set set = $org_scalatest_assert_macro_left;
            scala.collection.immutable.Set set2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(set != null ? !set.equals(set2) : set2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 493));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(graph.resolvedFlows().forall((Function1 & Serializable)x$20 -> BoxesRunTime.boxToBoolean((boolean)PythonPipelineSuite.$anonfun$new$38(x$20))), "graph.resolvedFlows.forall(((x$20: org.apache.spark.sql.pipelines.graph.ResolvedFlow) => x$20.inputs.isEmpty))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 497));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(graph.resolvedFlows().forall((Function1 & Serializable)x$21 -> BoxesRunTime.boxToBoolean((boolean)PythonPipelineSuite.$anonfun$new$39(x$21))), "graph.resolvedFlows.forall(((x$21: org.apache.spark.sql.pipelines.graph.ResolvedFlow) => x$21.df.isStreaming.unary_!))", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 498));
        }, new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 478));
        this.test("reading internal datasets outside query function that don't trigger eager analysis or execution", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            DataflowGraph graph = this.buildGraph(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |@dp.materialized_view\n        |def src():\n        |  return spark.range(5)\n        |\n        |read_table_df = spark.read.table(\"src\")\n        |\n        |@dp.materialized_view\n        |def mv_from_read_table_df():\n        |  return read_table_df\n        |\n        |"))).resolve().validate();
            scala.collection.immutable.Set $org_scalatest_assert_macro_left = ((IterableOnceOps)graph.resolvedFlows().map((Function1 & Serializable)x$22 -> x$22.identifier())).toSet();
            scala.collection.immutable.Set $org_scalatest_assert_macro_right = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TableIdentifier[]{this.graphIdentifier("mv_from_read_table_df"), this.graphIdentifier("src")}));
            scala.collection.immutable.Set set = $org_scalatest_assert_macro_left;
            scala.collection.immutable.Set set2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(set != null ? !set.equals(set2) : set2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 516));
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(graph.resolvedFlows().forall((Function1 & Serializable)x$23 -> BoxesRunTime.boxToBoolean((boolean)PythonPipelineSuite.$anonfun$new$42(x$23))), "graph.resolvedFlows.forall(((x$23: org.apache.spark.sql.pipelines.graph.ResolvedFlow) => x$23.df.isStreaming.unary_!))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 520));
            scala.collection.immutable.Set $org_scalatest_assert_macro_left2 = ((ResolvedFlow)graph.resolvedFlow().apply((Object)this.graphIdentifier("mv_from_read_table_df"))).inputs();
            TableIdentifier $org_scalatest_assert_macro_right2 = this.graphIdentifier("src");
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains((Object)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 521));
        }, new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 503));
        this.gridTest("reading internal datasets outside query function that trigger eager analysis or execution will fail", (Seq)Nil$.MODULE$, (Seq)new .colon.colon((Object)"spark.sql(\"SELECT * FROM src\")", (List)new .colon.colon((Object)"spark.read.table(\"src\").collect()", (List)Nil$.MODULE$)), (Function1 & Serializable)command -> {
            PythonPipelineSuite.$anonfun$new$43(this, command);
            return BoxedUnit.UNIT;
        });
        this.test("create dataset with the same name will fail", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(PythonTestDepsChecker$.MODULE$.isConnectDepsAvailable(), "org.apache.spark.sql.connect.PythonTestDepsChecker.isConnectDepsAvailable", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssume($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 551));
            AnalysisException ex = (AnalysisException)this.intercept((Function0 & Serializable)() -> this.buildGraph(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n           |@dp.materialized_view\n           |def a():\n           |  return spark.range(1)\n           |\n           |@dp.materialized_view(name = \"a\")\n           |def b():\n           |  return spark.range(1)\n           |"))), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 552));
            String $org_scalatest_assert_macro_left = ex.getCondition();
            String $org_scalatest_assert_macro_right = "PIPELINE_DUPLICATE_IDENTIFIERS.OUTPUT";
            String string = $org_scalatest_assert_macro_left;
            String string2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 563));
        }, new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 550));
        this.test("create datasets with fully/partially qualified names", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            DataflowGraph graph = this.buildGraph(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n         |@dp.table\n         |def mv_1():\n         |  return spark.range(5)\n         |\n         |@dp.table(name = \"schema_a.mv_2\")\n         |def irrelevant_1():\n         |  return spark.range(5)\n         |\n         |@dp.table(name = \"st_1\")\n         |def irrelevant_2():\n         |  return spark.readStream.format(\"rate\").load()\n         |\n         |@dp.table(name = \"schema_b.st_2\")\n         |def irrelevant_3():\n         |  return spark.readStream.format(\"rate\").load()\n         |"))).resolve();
            scala.collection.immutable.Set $org_scalatest_assert_macro_left = ((IterableOnceOps)graph.tables().map((Function1 & Serializable)x$24 -> x$24.identifier())).toSet();
            TableIdentifier[] tableIdentifierArray = new TableIdentifier[4];
            Option x$76 = Option$.MODULE$.apply((Object)"spark_catalog");
            Option x$77 = Option$.MODULE$.apply((Object)"default");
            String x$78 = "mv_1";
            tableIdentifierArray[0] = new TableIdentifier("mv_1", x$77, x$76);
            Option x$79 = Option$.MODULE$.apply((Object)"spark_catalog");
            Option x$80 = Option$.MODULE$.apply((Object)"schema_a");
            String x$81 = "mv_2";
            tableIdentifierArray[1] = new TableIdentifier("mv_2", x$80, x$79);
            Option x$82 = Option$.MODULE$.apply((Object)"spark_catalog");
            Option x$83 = Option$.MODULE$.apply((Object)"default");
            String x$84 = "st_1";
            tableIdentifierArray[2] = new TableIdentifier("st_1", x$83, x$82);
            Option x$85 = Option$.MODULE$.apply((Object)"spark_catalog");
            Option x$86 = Option$.MODULE$.apply((Object)"schema_b");
            String x$87 = "st_2";
            tableIdentifierArray[3] = new TableIdentifier("st_2", x$86, x$85);
            scala.collection.immutable.Set $org_scalatest_assert_macro_right = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])tableIdentifierArray));
            scala.collection.immutable.Set set = $org_scalatest_assert_macro_left;
            scala.collection.immutable.Set set2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(set != null ? !set.equals(set2) : set2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 586));
            scala.collection.immutable.Set $org_scalatest_assert_macro_left2 = ((IterableOnceOps)graph.flows().map((Function1 & Serializable)x$25 -> x$25.identifier())).toSet();
            TableIdentifier[] tableIdentifierArray2 = new TableIdentifier[4];
            Option x$88 = Option$.MODULE$.apply((Object)"spark_catalog");
            Option x$89 = Option$.MODULE$.apply((Object)"default");
            String x$90 = "mv_1";
            tableIdentifierArray2[0] = new TableIdentifier("mv_1", x$89, x$88);
            Option x$91 = Option$.MODULE$.apply((Object)"spark_catalog");
            Option x$92 = Option$.MODULE$.apply((Object)"schema_a");
            String x$93 = "mv_2";
            tableIdentifierArray2[1] = new TableIdentifier("mv_2", x$92, x$91);
            Option x$94 = Option$.MODULE$.apply((Object)"spark_catalog");
            Option x$95 = Option$.MODULE$.apply((Object)"default");
            String x$96 = "st_1";
            tableIdentifierArray2[2] = new TableIdentifier("st_1", x$95, x$94);
            Option x$97 = Option$.MODULE$.apply((Object)"spark_catalog");
            Option x$98 = Option$.MODULE$.apply((Object)"schema_b");
            String x$99 = "st_2";
            tableIdentifierArray2[3] = new TableIdentifier("st_2", x$98, x$97);
            scala.collection.immutable.Set $org_scalatest_assert_macro_right2 = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])tableIdentifierArray2));
            scala.collection.immutable.Set set3 = $org_scalatest_assert_macro_left2;
            scala.collection.immutable.Set set4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(set3 != null ? !set3.equals(set4) : set4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 604));
        }, new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 566));
        this.test("create datasets with three part names", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(PythonTestDepsChecker$.MODULE$.isConnectDepsAvailable(), "org.apache.spark.sql.connect.PythonTestDepsChecker.isConnectDepsAvailable", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssume($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 625));
            Try graphTry = Try$.MODULE$.apply((Function0 & Serializable)() -> this.buildGraph(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n           |@dp.table(name = \"some_catalog.some_schema.mv\")\n           |def irrelevant_1():\n           |  return spark.range(5)\n           |\n           |@dp.table(name = \"some_catalog.some_schema.st\")\n           |def irrelevant_2():\n           |  return spark.readStream.format(\"rate\").load()\n           |"))).resolve());
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.simpleMacroBool(graphTry.isSuccess(), "graphTry.isSuccess", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 637));
            scala.collection.immutable.Set $org_scalatest_assert_macro_left = ((IterableOnceOps)((DataflowGraph)graphTry.get()).tables().map((Function1 & Serializable)x$26 -> x$26.identifier())).toSet();
            scala.collection.immutable.Set $org_scalatest_assert_macro_right = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TableIdentifier[]{new TableIdentifier("mv", (Option)new Some((Object)"some_schema"), (Option)new Some((Object)"some_catalog")), new TableIdentifier("st", (Option)new Some((Object)"some_schema"), (Option)new Some((Object)"some_catalog"))}));
            scala.collection.immutable.Set set = $org_scalatest_assert_macro_left;
            scala.collection.immutable.Set set2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(set != null ? !set.equals(set2) : set2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 638));
            scala.collection.immutable.Set $org_scalatest_assert_macro_left2 = ((IterableOnceOps)((DataflowGraph)graphTry.get()).flows().map((Function1 & Serializable)x$27 -> x$27.identifier())).toSet();
            scala.collection.immutable.Set $org_scalatest_assert_macro_right2 = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TableIdentifier[]{new TableIdentifier("mv", (Option)new Some((Object)"some_schema"), (Option)new Some((Object)"some_catalog")), new TableIdentifier("st", (Option)new Some((Object)"some_schema"), (Option)new Some((Object)"some_catalog"))}));
            scala.collection.immutable.Set set3 = $org_scalatest_assert_macro_left2;
            scala.collection.immutable.Set set4 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(set3 != null ? !set3.equals(set4) : set4 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 642));
        }, new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 624));
        this.test("temporary views works", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            DataflowGraph graph = this.buildGraph(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n         |@dp.table\n         |def mv_1():\n         |  return spark.range(5)\n         |@dp.temporary_view\n         |def view_1():\n         |  return spark.range(5)\n         |\n         |@dp.temporary_view(name= \"view_2\")\n         |def irrelevant_1():\n         |  return spark.read.table(\"view_1\")\n         |\n         |@dp.temporary_view(name= \"view_3\")\n         |def irrelevant_2():\n         |  return spark.read.table(\"view_1\")\n         |"))).resolve();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(((SetOps)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"view_1", "view_2", "view_3"}))).subsetOf((Set)((IterableOnceOps)graph.flows().map((Function1 & Serializable)x$28 -> x$28.identifier().unquotedString())).toSet()), "scala.Predef.Set.apply[String](\"view_1\", \"view_2\", \"view_3\").subsetOf(graph.flows.map[String](((x$28: org.apache.spark.sql.pipelines.graph.Flow) => x$28.identifier.unquotedString)).toSet[String])", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 667));
            scala.collection.immutable.Set $org_scalatest_assert_macro_left = ((ResolvedFlow)graph.resolvedFlow().apply((Object)TableIdentifier$.MODULE$.apply("view_2"))).inputs();
            TableIdentifier $org_scalatest_assert_macro_right = TableIdentifier$.MODULE$.apply("view_1");
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains((Object)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 671));
            scala.collection.immutable.Set $org_scalatest_assert_macro_left2 = ((ResolvedFlow)graph.resolvedFlow().apply((Object)TableIdentifier$.MODULE$.apply("view_3"))).inputs();
            TableIdentifier $org_scalatest_assert_macro_right2 = TableIdentifier$.MODULE$.apply("view_1");
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains((Object)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 673));
        }, new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 648));
        this.test("create named flow with multipart name will fail", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(PythonTestDepsChecker$.MODULE$.isConnectDepsAvailable(), "org.apache.spark.sql.connect.PythonTestDepsChecker.isConnectDepsAvailable", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssume($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 678));
            RuntimeException ex = (RuntimeException)this.intercept((Function0 & Serializable)() -> this.buildGraph(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n           |@dp.table\n           |def src():\n           |  return spark.readStream.table(\"src0\")\n           |\n           |@dp.append_flow(name =\"some_schema.some_flow\", target = \"src\")\n           |def some_flow():\n           |  return spark.readStream.format(\"rate\").load()\n           |"))), ClassTag$.MODULE$.apply(RuntimeException.class), new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 679));
            String $org_scalatest_assert_macro_left = ex.getMessage();
            String $org_scalatest_assert_macro_right = "MULTIPART_FLOW_NAME_NOT_SUPPORTED";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 690));
        }, new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 677));
        this.test("create flow with multipart target and no explicit name succeeds", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            DataflowGraph graph = this.buildGraph(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n           |@dp.table()\n           |def a():\n           |  return spark.readStream.format(\"rate\").load()\n           |\n           |@dp.append_flow(target = \"default.a\")\n           |def supplement():\n           |  return spark.readStream.format(\"rate\").load()\n           |"))).resolve().validate();
            Seq $org_scalatest_assert_macro_left = (Seq)graph.tables().map((Function1 & Serializable)x$29 -> x$29.identifier());
            .colon.colon $org_scalatest_assert_macro_right = new .colon.colon((Object)this.graphIdentifier("a"), (List)Nil$.MODULE$);
            Seq seq = $org_scalatest_assert_macro_left;
            .colon.colon colon2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(seq != null ? !seq.equals(colon2) : colon2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 704));
            scala.collection.immutable.Set $org_scalatest_assert_macro_left2 = ((IterableOnceOps)((IterableOps)graph.flowsTo().apply((Object)this.graphIdentifier("a"))).map((Function1 & Serializable)x$30 -> x$30.identifier())).toSet();
            scala.collection.immutable.Set $org_scalatest_assert_macro_right2 = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TableIdentifier[]{this.graphIdentifier("a"), this.graphIdentifier("supplement")}));
            scala.collection.immutable.Set set = $org_scalatest_assert_macro_left2;
            scala.collection.immutable.Set set2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(set != null ? !set.equals(set2) : set2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 705));
        }, new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 693));
        this.test("create named flow with multipart target succeeds", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            DataflowGraph graph = this.buildGraph(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n           |@dp.table()\n           |def a():\n           |  return spark.readStream.format(\"rate\").load()\n           |\n           |@dp.append_flow(target = \"default.a\", name = \"something\")\n           |def supplement():\n           |  return spark.readStream.format(\"rate\").load()\n           |")));
            Seq $org_scalatest_assert_macro_left = (Seq)graph.tables().map((Function1 & Serializable)x$31 -> x$31.identifier());
            .colon.colon $org_scalatest_assert_macro_right = new .colon.colon((Object)this.graphIdentifier("a"), (List)Nil$.MODULE$);
            Seq seq = $org_scalatest_assert_macro_left;
            .colon.colon colon2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(seq != null ? !seq.equals(colon2) : colon2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 723));
            scala.collection.immutable.Set $org_scalatest_assert_macro_left2 = ((IterableOnceOps)((IterableOps)graph.flowsTo().apply((Object)this.graphIdentifier("a"))).map((Function1 & Serializable)x$32 -> x$32.identifier())).toSet();
            scala.collection.immutable.Set $org_scalatest_assert_macro_right2 = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TableIdentifier[]{this.graphIdentifier("a"), this.graphIdentifier("something")}));
            scala.collection.immutable.Set set = $org_scalatest_assert_macro_left2;
            scala.collection.immutable.Set set2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(set != null ? !set.equals(set2) : set2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 724));
        }, new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 712));
        this.test("groupby and rollup works with internal datasets, referencing with (col, str)", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            DataflowGraph graph;
            DataflowGraph x$100 = graph = this.buildGraph("\n      from pyspark.sql.functions import col, sum, count\n\n      @dp.materialized_view\n      def src():\n        return spark.range(3)\n\n      @dp.materialized_view\n      def groupby_with_col_result():\n        return spark.read.table(\"src\").groupBy(col(\"id\")).agg(\n          sum(\"id\").alias(\"sum_id\"),\n          count(\"*\").alias(\"cnt\")\n        )\n\n      @dp.materialized_view\n      def groupby_with_str_result():\n        return spark.read.table(\"src\").groupBy(\"id\").agg(\n          sum(\"id\").alias(\"sum_id\"),\n          count(\"*\").alias(\"cnt\")\n        )\n\n      @dp.materialized_view\n      def rollup_with_col_result():\n        return spark.read.table(\"src\").rollup(col(\"id\")).agg(\n          sum(\"id\").alias(\"sum_id\"),\n          count(\"*\").alias(\"cnt\")\n        )\n\n      @dp.materialized_view\n      def rollup_with_str_result():\n        return spark.read.table(\"src\").rollup(\"id\").agg(\n          sum(\"id\").alias(\"sum_id\"),\n          count(\"*\").alias(\"cnt\")\n        )\n    ");
            Function1 & Serializable x$101 = (Function1 & Serializable)x$33 -> {
                PythonPipelineSuite.$anonfun$new$65(x$33);
                return BoxedUnit.UNIT;
            };
            String x$102 = this.storageRoot();
            TableFilter x$103 = PipelineUpdateContextImpl$.MODULE$.$lessinit$greater$default$3();
            TableFilter x$104 = PipelineUpdateContextImpl$.MODULE$.$lessinit$greater$default$4();
            PipelineUpdateContextImpl updateContext = new PipelineUpdateContextImpl(x$100, (Function1)x$101, x$103, x$104, x$102);
            updateContext.pipelineExecution().runPipeline();
            updateContext.pipelineExecution().awaitCompletion();
            .colon.colon groupbyDfs = new .colon.colon((Object)this.spark().table("groupby_with_col_result"), (List)new .colon.colon((Object)this.spark().table("groupby_with_str_result"), (List)Nil$.MODULE$));
            .colon.colon rollupDfs = new .colon.colon((Object)this.spark().table("rollup_with_col_result"), (List)new .colon.colon((Object)this.spark().table("rollup_with_str_result"), (List)Nil$.MODULE$));
            groupbyDfs.foreach((Function1 & Serializable)df -> {
                scala.collection.immutable.Set $org_scalatest_assert_macro_left = Predef$.MODULE$.wrapLongArray((long[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])df.select("id", (Seq)Nil$.MODULE$).collect()), (Function1 & Serializable)x$34 -> BoxesRunTime.boxToLong((long)x$34.getLong(0)), (ClassTag)ClassTag$.MODULE$.Long())).toSet();
                scala.collection.immutable.Set $org_scalatest_assert_macro_right = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{0L, 1L, 2L}));
                scala.collection.immutable.Set set = $org_scalatest_assert_macro_left;
                scala.collection.immutable.Set set2 = $org_scalatest_assert_macro_right;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(set != null ? !set.equals(set2) : set2 != null), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 781));
            });
            rollupDfs.foreach((Function1 & Serializable)df -> {
                Bool bool;
                long $org_scalatest_assert_macro_left = df.count();
                int $org_scalatest_assert_macro_right = 4;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == (long)$org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 786));
                Row totalRow = (Row)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])df.filter("id IS NULL").collect()));
                long $org_scalatest_assert_macro_left2 = totalRow.getLong(1);
                long $org_scalatest_assert_macro_right2 = 3L;
                Bool $org_scalatest_assert_macro_left3 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
                if ($org_scalatest_assert_macro_left3.value()) {
                    long $org_scalatest_assert_macro_left4 = totalRow.getLong(2);
                    long $org_scalatest_assert_macro_right3 = 3L;
                    bool = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left4), "==", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left4 == $org_scalatest_assert_macro_right3, Prettifier$.MODULE$.default());
                } else {
                    bool = Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
                }
                Bool $org_scalatest_assert_macro_right4 = bool;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "&&", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left3.$amp$amp((Function0 & Serializable)() -> $org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 788));
            });
        }, new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 731));
        this.test("MV/ST with partition columns works", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"mv", "st"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            DataflowGraph graph;
            DataflowGraph x$105 = graph = this.buildGraph(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n            |from pyspark.sql.functions import col\n            |\n            |@dp.materialized_view(partition_cols = [\"id_mod\"])\n            |def mv():\n            |  return spark.range(5).withColumn(\"id_mod\", col(\"id\") % 2)\n            |\n            |@dp.table(partition_cols = [\"id_mod\"])\n            |def st():\n            |  return spark.readStream.table(\"mv\")\n            |")));
            Function1 & Serializable x$106 = (Function1 & Serializable)x$35 -> {
                PythonPipelineSuite.$anonfun$new$72(x$35);
                return BoxedUnit.UNIT;
            };
            String x$107 = this.storageRoot();
            TableFilter x$108 = PipelineUpdateContextImpl$.MODULE$.$lessinit$greater$default$3();
            TableFilter x$109 = PipelineUpdateContextImpl$.MODULE$.$lessinit$greater$default$4();
            PipelineUpdateContextImpl updateContext = new PipelineUpdateContextImpl(x$105, (Function1)x$106, x$108, x$109, x$107);
            updateContext.pipelineExecution().runPipeline();
            updateContext.pipelineExecution().awaitCompletion();
            TableCatalog catalog = (TableCatalog)this.spark().sessionState().catalogManager().currentCatalog();
            new .colon.colon((Object)"mv", (List)new .colon.colon((Object)"st", (List)Nil$.MODULE$)).foreach((Function1 & Serializable)tableName -> {
                org.apache.spark.sql.connector.catalog.Table table = catalog.loadTable(Identifier.of((String[])((String[])((Object[])new String[]{"default"})), (String)tableName));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])table.partitioning()), (Function1 & Serializable)x$36 -> (String)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])((NamedReference)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])x$36.references()))).fieldNames())), ClassTag$.MODULE$.apply(String.class)));
                String[] $org_scalatest_assert_macro_right = (String[])((Object[])new String[]{"id_mod"});
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 816));
                scala.collection.immutable.Set rows = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])this.spark().table(tableName).collect()), (Function1 & Serializable)r -> new Tuple2.mcJJ.sp(r.getLong(0), r.getLong(1)), ClassTag$.MODULE$.apply(Tuple2.class))).toSet();
                scala.collection.immutable.Set expected = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 5).map((Function1 & Serializable)id -> PythonPipelineSuite.$anonfun$new$76(BoxesRunTime.unboxToInt((Object)id))).toSet();
                scala.collection.immutable.Set $org_scalatest_assert_macro_left2 = rows;
                scala.collection.immutable.Set $org_scalatest_assert_macro_right2 = expected;
                scala.collection.immutable.Set set = $org_scalatest_assert_macro_left2;
                scala.collection.immutable.Set set2 = $org_scalatest_assert_macro_right2;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(set != null ? !set.equals(set2) : set2 != null), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 821));
            });
        }), new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 792));
        this.test("create pipeline without table will throw RUN_EMPTY_PIPELINE exception", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(PythonTestDepsChecker$.MODULE$.isConnectDepsAvailable(), "org.apache.spark.sql.connect.PythonTestDepsChecker.isConnectDepsAvailable", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssume($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 827));
            AnalysisException x$110 = (AnalysisException)this.intercept((Function0 & Serializable)() -> this.buildGraph(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n            |spark.range(1)\n            |"))), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 829));
            String x$111 = "RUN_EMPTY_PIPELINE";
            Map x$112 = Predef$.MODULE$.Map().empty();
            Option x$113 = this.checkError$default$3();
            boolean x$114 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$115 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$110, "RUN_EMPTY_PIPELINE", x$113, x$112, x$114, x$115);
        }, new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 826));
        this.test("create pipeline with only temp view will throw RUN_EMPTY_PIPELINE exception", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(PythonTestDepsChecker$.MODULE$.isConnectDepsAvailable(), "org.apache.spark.sql.connect.PythonTestDepsChecker.isConnectDepsAvailable", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssume($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 839));
            AnalysisException x$116 = (AnalysisException)this.intercept((Function0 & Serializable)() -> this.buildGraph(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n            |@dp.temporary_view\n            |def view_1():\n            |  return spark.range(5)\n            |"))), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 841));
            String x$117 = "RUN_EMPTY_PIPELINE";
            Map x$118 = Predef$.MODULE$.Map().empty();
            Option x$119 = this.checkError$default$3();
            boolean x$120 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$121 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$116, "RUN_EMPTY_PIPELINE", x$119, x$118, x$120, x$121);
        }, new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 838));
        this.test("create pipeline with only flow will throw RUN_EMPTY_PIPELINE exception", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> {
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(PythonTestDepsChecker$.MODULE$.isConnectDepsAvailable(), "org.apache.spark.sql.connect.PythonTestDepsChecker.isConnectDepsAvailable", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssume($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 853));
            AnalysisException x$122 = (AnalysisException)this.intercept((Function0 & Serializable)() -> this.buildGraph(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n            |@dp.append_flow(target = \"a\")\n            |def flow():\n            |  return spark.range(5)\n            |"))), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 855));
            String x$123 = "RUN_EMPTY_PIPELINE";
            Map x$124 = Predef$.MODULE$.Map().empty();
            Option x$125 = this.checkError$default$3();
            boolean x$126 = this.checkError$default$5();
            SparkFunSuite.ExpectedContext[] x$127 = this.checkError$default$6();
            this.checkError((SparkThrowable)x$122, "RUN_EMPTY_PIPELINE", x$125, x$124, x$126, x$127);
        }, new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 852));
        this.test("table with string schema", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            DataflowGraph graph = this.buildGraph(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |from pyspark.sql.functions import lit\n        |\n        |@dp.materialized_view(schema=\"id LONG, name STRING\")\n        |def table_with_string_schema():\n        |    return spark.range(5).withColumn(\"name\", lit(\"test\"))\n        |"))).resolve().validate();
            Seq $org_scalatest_assert_macro_left = graph.flows();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 877));
            Seq $org_scalatest_assert_macro_left2 = graph.tables();
            int $org_scalatest_assert_macro_right2 = 1;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left2, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 878));
            Table table = (Table)graph.table().apply((Object)this.graphIdentifier("table_with_string_schema"));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(table.specifiedSchema().isDefined(), "table.specifiedSchema.isDefined", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 881));
            StructType $org_scalatest_assert_macro_left3 = (StructType)table.specifiedSchema().get();
            StructType $org_scalatest_assert_macro_right3 = StructType$.MODULE$.fromDDL("id LONG, name STRING");
            StructType structType = $org_scalatest_assert_macro_left3;
            StructType structType2 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 882));
        }, new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 866));
        this.test("table with StructType schema", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            DataflowGraph graph = this.buildGraph(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |from pyspark.sql.types import StructType, StructField, LongType, StringType\n        |from pyspark.sql.functions import lit\n        |\n        |@dp.materialized_view(schema=StructType([\n        |    StructField(\"id\", LongType(), True),\n        |    StructField(\"name\", StringType(), True)\n        |]))\n        |def table_with_struct_schema():\n        |    return spark.range(5).withColumn(\"name\", lit(\"test\"))\n        |"))).resolve().validate();
            Seq $org_scalatest_assert_macro_left = graph.flows();
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 900));
            Seq $org_scalatest_assert_macro_left2 = graph.tables();
            int $org_scalatest_assert_macro_right2 = 1;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left2, "size", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2.size()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 901));
            Table table = (Table)graph.table().apply((Object)this.graphIdentifier("table_with_struct_schema"));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(table.specifiedSchema().isDefined(), "table.specifiedSchema.isDefined", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 904));
            StructType $org_scalatest_assert_macro_left3 = (StructType)table.specifiedSchema().get();
            StructType $org_scalatest_assert_macro_right3 = StructType$.MODULE$.fromDDL("id LONG, name STRING");
            StructType structType = $org_scalatest_assert_macro_left3;
            StructType structType2 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(structType != null ? !structType.equals(structType2) : structType2 != null), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 905));
        }, new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 885));
        this.test("string schema validation error - schema mismatch", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            DataflowGraph graph = this.buildGraph(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |from pyspark.sql.functions import lit\n        |\n        |@dp.materialized_view(schema=\"id LONG, name STRING\")\n        |def table_with_wrong_schema():\n        |    return spark.range(5).withColumn(\"wrong_column\", lit(\"test\"))\n        |"))).resolve();
            AnalysisException ex = (AnalysisException)this.intercept((Function0 & Serializable)() -> graph.validate(), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 918));
            String $org_scalatest_assert_macro_left = ex.getMessage();
            String $org_scalatest_assert_macro_right = "has a user-specified schema that is incompatible";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 919));
            String $org_scalatest_assert_macro_left2 = ex.getMessage();
            String $org_scalatest_assert_macro_right2 = "table_with_wrong_schema";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 920));
        }, new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 908));
        this.test("StructType schema validation error - schema mismatch", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(Function0 & Serializable)() -> {
            DataflowGraph graph = this.buildGraph(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n        |from pyspark.sql.types import StructType, StructField, LongType, StringType\n        |from pyspark.sql.functions import lit\n        |\n        |@dp.materialized_view(schema=StructType([\n        |    StructField(\"id\", LongType(), True),\n        |    StructField(\"name\", StringType(), True)\n        |]))\n        |def table_with_wrong_struct_schema():\n        |    return spark.range(5).withColumn(\"different_column\", lit(\"test\"))\n        |"))).resolve();
            AnalysisException ex = (AnalysisException)this.intercept((Function0 & Serializable)() -> graph.validate(), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 937));
            String $org_scalatest_assert_macro_left = ex.getMessage();
            String $org_scalatest_assert_macro_right = "has a user-specified schema that is incompatible";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 938));
            String $org_scalatest_assert_macro_left2 = ex.getMessage();
            String $org_scalatest_assert_macro_right2 = "table_with_wrong_struct_schema";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 939));
        }, new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 923));
        this.test("empty cluster_by list should work and create table with no clustering", (Seq<Tag>)Nil$.MODULE$, (Function0<Object>)(JFunction0.mcV.sp & Serializable)() -> this.withTable((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"mv", "st"}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            DataflowGraph graph;
            DataflowGraph x$128 = graph = this.buildGraph(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n            |from pyspark.sql.functions import col\n            |\n            |@dp.materialized_view(cluster_by = [])\n            |def mv():\n            |  return spark.range(5).withColumn(\"id_mod\", col(\"id\") % 2)\n            |\n            |@dp.table(cluster_by = [])\n            |def st():\n            |  return spark.readStream.table(\"mv\")\n            |")));
            Function1 & Serializable x$129 = (Function1 & Serializable)x$37 -> {
                PythonPipelineSuite.$anonfun$new$91(x$37);
                return BoxedUnit.UNIT;
            };
            String x$130 = this.storageRoot();
            TableFilter x$131 = PipelineUpdateContextImpl$.MODULE$.$lessinit$greater$default$3();
            TableFilter x$132 = PipelineUpdateContextImpl$.MODULE$.$lessinit$greater$default$4();
            PipelineUpdateContextImpl updateContext = new PipelineUpdateContextImpl(x$128, (Function1)x$129, x$131, x$132, x$130);
            updateContext.pipelineExecution().runPipeline();
            updateContext.pipelineExecution().awaitCompletion();
            TableCatalog catalog = (TableCatalog)this.spark().sessionState().catalogManager().currentCatalog();
            Identifier mvIdentifier = Identifier.of((String[])((String[])((Object[])new String[]{"default"})), (String)"mv");
            org.apache.spark.sql.connector.catalog.Table mvTable = catalog.loadTable(mvIdentifier);
            Transform[] mvTransforms = mvTable.partitioning();
            Object $org_scalatest_assert_macro_left = Predef$.MODULE$.refArrayOps((Object[])mvTransforms);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.unaryMacroBool((Object)new ArrayOps($org_scalatest_assert_macro_left), "isEmpty", ArrayOps$.MODULE$.isEmpty$extension($org_scalatest_assert_macro_left), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)("MaterializedView should have no transforms, but got: " + Predef$.MODULE$.wrapRefArray((Object[])mvTransforms).mkString(", ")), Prettifier$.MODULE$.default(), new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1021));
            Identifier stIdentifier = Identifier.of((String[])((String[])((Object[])new String[]{"default"})), (String)"st");
            org.apache.spark.sql.connector.catalog.Table stTable = catalog.loadTable(stIdentifier);
            Transform[] stTransforms = stTable.partitioning();
            Object $org_scalatest_assert_macro_left2 = Predef$.MODULE$.refArrayOps((Object[])stTransforms);
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.unaryMacroBool((Object)new ArrayOps($org_scalatest_assert_macro_left2), "isEmpty", ArrayOps$.MODULE$.isEmpty$extension($org_scalatest_assert_macro_left2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)("Table should have no transforms, but got: " + Predef$.MODULE$.wrapRefArray((Object[])stTransforms).mkString(", ")), Prettifier$.MODULE$.default(), new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1028));
        }), new Position("PythonPipelineSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 997));
        this.unsupportedSqlCommandList = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"SET CATALOG some_catalog", "USE SCHEMA some_schema", "SET `test_conf` = `true`", "CREATE TABLE some_table (id INT)", "CREATE VIEW some_view AS SELECT * FROM some_table", "INSERT INTO some_table VALUES (1)", "ALTER TABLE some_table RENAME TO some_new_table", "CREATE NAMESPACE some_namespace", "DROP VIEW some_view", "CREATE MATERIALIZED VIEW some_view AS SELECT * FROM some_table", "CREATE STREAMING TABLE some_table AS SELECT * FROM some_table"}));
        this.gridTest("Unsupported SQL command outside query function should result in a failure", (Seq)Nil$.MODULE$, this.unsupportedSqlCommandList(), (Function1 & Serializable)unsupportedSqlCommand -> {
            PythonPipelineSuite.$anonfun$new$92(this, unsupportedSqlCommand);
            return BoxedUnit.UNIT;
        });
        this.gridTest("Unsupported SQL command inside query function should result in a failure", (Seq)Nil$.MODULE$, this.unsupportedSqlCommandList(), (Function1 & Serializable)unsupportedSqlCommand -> {
            PythonPipelineSuite.$anonfun$new$94(this, unsupportedSqlCommand);
            return BoxedUnit.UNIT;
        });
        this.supportedSqlCommandList = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"DESCRIBE TABLE spark_catalog.default.src", "SHOW TABLES", "SHOW TBLPROPERTIES spark_catalog.default.src", "SHOW NAMESPACES", "SHOW COLUMNS FROM spark_catalog.default.src", "SHOW FUNCTIONS", "SHOW VIEWS", "SHOW CATALOGS", "SHOW CREATE TABLE spark_catalog.default.src", "SELECT * FROM RANGE(5)", "SELECT * FROM spark_catalog.default.src"}));
        this.gridTest("Supported SQL command outside query function should work", (Seq)Nil$.MODULE$, this.supportedSqlCommandList(), (Function1 & Serializable)supportedSqlCommand -> {
            PythonPipelineSuite.$anonfun$new$96(this, supportedSqlCommand);
            return BoxedUnit.UNIT;
        });
        this.gridTest("Supported SQL command inside query function should work", (Seq)Nil$.MODULE$, this.supportedSqlCommandList(), (Function1 & Serializable)supportedSqlCommand -> {
            PythonPipelineSuite.$anonfun$new$97(this, supportedSqlCommand);
            return BoxedUnit.UNIT;
        });
    }
}

