/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.graphx;

import java.io.Serializable;
import org.apache.spark.SparkException;
import org.apache.spark.graphx.Edge;
import org.apache.spark.graphx.EdgeContext;
import org.apache.spark.graphx.EdgeDirection;
import org.apache.spark.graphx.EdgeDirection$;
import org.apache.spark.graphx.EdgeTriplet;
import org.apache.spark.graphx.Graph;
import org.apache.spark.graphx.Graph$;
import org.apache.spark.graphx.Pregel$;
import org.apache.spark.graphx.TripletFields;
import org.apache.spark.graphx.VertexRDD;
import org.apache.spark.graphx.lib.ConnectedComponents$;
import org.apache.spark.graphx.lib.PageRank$;
import org.apache.spark.graphx.lib.StronglyConnectedComponents$;
import org.apache.spark.graphx.lib.TriangleCount$;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction2;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0001\teg\u0001B\u0001\u0003\u0001-\u0011\u0001b\u0012:ba\"|\u0005o\u001d\u0006\u0003\u0007\u0011\taa\u001a:ba\"D(BA\u0003\u0007\u0003\u0015\u0019\b/\u0019:l\u0015\t9\u0001\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0013\u0005\u0019qN]4\u0004\u0001U\u0019AB\b\u0015\u0014\u0007\u0001i1\u0003\u0005\u0002\u000f#5\tqBC\u0001\u0011\u0003\u0015\u00198-\u00197b\u0013\t\u0011rB\u0001\u0004B]f\u0014VM\u001a\t\u0003\u001dQI!!F\b\u0003\u0019M+'/[1mSj\f'\r\\3\t\u0011]\u0001!\u0011!Q\u0001\na\tQa\u001a:ba\"\u0004B!\u0007\u000e\u001dO5\t!!\u0003\u0002\u001c\u0005\t)qI]1qQB\u0011QD\b\u0007\u0001\t\u0015y\u0002A1\u0001!\u0005\t1F)\u0005\u0002\"IA\u0011aBI\u0005\u0003G=\u0011qAT8uQ&tw\r\u0005\u0002\u000fK%\u0011ae\u0004\u0002\u0004\u0003:L\bCA\u000f)\t\u0015I\u0003A1\u0001!\u0005\t)E\t\u0003\u0005,\u0001\t\r\t\u0015a\u0003-\u0003))g/\u001b3f]\u000e,G%\r\t\u0004[AbR\"\u0001\u0018\u000b\u0005=z\u0011a\u0002:fM2,7\r^\u0005\u0003c9\u0012\u0001b\u00117bgN$\u0016m\u001a\u0005\tg\u0001\u0011\u0019\u0011)A\u0006i\u0005QQM^5eK:\u001cW\r\n\u001a\u0011\u00075\u0002t\u0005C\u00037\u0001\u0011\u0005q'\u0001\u0004=S:LGO\u0010\u000b\u0003qq\"2!\u000f\u001e<!\u0011I\u0002\u0001H\u0014\t\u000b-*\u00049\u0001\u0017\t\u000bM*\u00049\u0001\u001b\t\u000b])\u0004\u0019\u0001\r\t\u0011y\u0002\u0001R1A\u0005\u0002}\n\u0001B\\;n\u000b\u0012<Wm]\u000b\u0002\u0001B\u0011a\"Q\u0005\u0003\u0005>\u0011A\u0001T8oO\"\u0012Q\b\u0012\t\u0003\u001d\u0015K!AR\b\u0003\u0013Q\u0014\u0018M\\:jK:$\b\u0002\u0003%\u0001\u0011\u000b\u0007I\u0011A \u0002\u00179,XNV3si&\u001cWm\u001d\u0015\u0003\u000f\u0012C\u0001b\u0013\u0001\t\u0006\u0004%\t\u0001T\u0001\nS:$Um\u001a:fKN,\u0012!\u0014\t\u000439\u0003\u0016BA(\u0003\u0005%1VM\u001d;fqJ#E\t\u0005\u0002\u000f#&\u0011!k\u0004\u0002\u0004\u0013:$\bF\u0001&E\u0011!)\u0006\u0001#b\u0001\n\u0003a\u0015AC8vi\u0012+wM]3fg\"\u0012A\u000b\u0012\u0005\t1\u0002A)\u0019!C\u0001\u0019\u00069A-Z4sK\u0016\u001c\bFA,E\u0011\u0015Y\u0006\u0001\"\u0003]\u0003)!Wm\u001a:fKN\u0014F\t\u0012\u000b\u0003\u001bvCQA\u0018.A\u0002}\u000bQ\"\u001a3hK\u0012K'/Z2uS>t\u0007CA\ra\u0013\t\t'AA\u0007FI\u001e,G)\u001b:fGRLwN\u001c\u0005\u0006G\u0002!\t\u0001Z\u0001\u0013G>dG.Z2u\u001d\u0016Lw\r\u001b2pe&#7\u000f\u0006\u0002faB\u0019\u0011D\u00144\u0011\u000799\u0017.\u0003\u0002i\u001f\t)\u0011I\u001d:bsB\u0011!.\u001c\b\u00033-L!\u0001\u001c\u0002\u0002\u000fA\f7m[1hK&\u0011an\u001c\u0002\t-\u0016\u0014H/\u001a=JI*\u0011AN\u0001\u0005\u0006=\n\u0004\ra\u0018\u0005\u0006e\u0002!\ta]\u0001\u0011G>dG.Z2u\u001d\u0016Lw\r\u001b2peN$\"\u0001^=\u0011\u0007eqU\u000fE\u0002\u000fOZ\u0004BAD<j9%\u0011\u0001p\u0004\u0002\u0007)V\u0004H.\u001a\u001a\t\u000by\u000b\b\u0019A0\t\u000bm\u0004A\u0011\u0001?\u0002\u0019\r|G\u000e\\3di\u0016#w-Z:\u0015\u0007u\f)\u0001E\u0002\u001a\u001dz\u00042AD4\u0000!\u0011I\u0012\u0011A\u0014\n\u0007\u0005\r!A\u0001\u0003FI\u001e,\u0007\"\u00020{\u0001\u0004y\u0006bBA\u0005\u0001\u0011\u0005\u00111B\u0001\u0010e\u0016lwN^3TK24W\tZ4fgR\t\u0001\u0004C\u0004\u0002\u0010\u0001!\t!!\u0005\u0002\u0019)|\u0017N\u001c,feRL7-Z:\u0016\t\u0005M\u0011\u0011\u0005\u000b\u0005\u0003+\ty\u0003\u0006\u0003\u0002\u0018\u0005\u0015Bc\u0001\r\u0002\u001a!Q\u00111DA\u0007\u0003\u0003\u0005\u001d!!\b\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$3\u0007\u0005\u0003.a\u0005}\u0001cA\u000f\u0002\"\u00119\u00111EA\u0007\u0005\u0004\u0001#!A+\t\u0011\u0005\u001d\u0012Q\u0002a\u0001\u0003S\tq!\\1q\rVt7\r\u0005\u0005\u000f\u0003WIG$a\b\u001d\u0013\r\tic\u0004\u0002\n\rVt7\r^5p]NB\u0001\"!\r\u0002\u000e\u0001\u0007\u00111G\u0001\u0006i\u0006\u0014G.\u001a\t\u0007\u0003k\tY$a\u0010\u000e\u0005\u0005]\"bAA\u001d\t\u0005\u0019!\u000f\u001a3\n\t\u0005u\u0012q\u0007\u0002\u0004%\u0012#\u0005#\u0002\bxS\u0006}\u0001bBA\"\u0001\u0011\u0005\u0011QI\u0001\u0007M&dG/\u001a:\u0016\r\u0005\u001d\u00131KA0)!\tI%a\u0019\u0002p\u0005\u0005E#\u0002\r\u0002L\u0005]\u0003BCA'\u0003\u0003\n\t\u0011q\u0001\u0002P\u0005QQM^5eK:\u001cW\r\n\u001b\u0011\t5\u0002\u0014\u0011\u000b\t\u0004;\u0005MCaBA+\u0003\u0003\u0012\r\u0001\t\u0002\u0004-\u0012\u0013\u0004BCA-\u0003\u0003\n\t\u0011q\u0001\u0002\\\u0005QQM^5eK:\u001cW\rJ\u001b\u0011\t5\u0002\u0014Q\f\t\u0004;\u0005}CaBA1\u0003\u0003\u0012\r\u0001\t\u0002\u0004\u000b\u0012\u0013\u0004\u0002CA3\u0003\u0003\u0002\r!a\u001a\u0002\u0015A\u0014X\r\u001d:pG\u0016\u001c8\u000f\u0005\u0004\u000f\u0003SB\u0012QN\u0005\u0004\u0003Wz!!\u0003$v]\u000e$\u0018n\u001c82!\u0019I\"$!\u0015\u0002^!Q\u0011\u0011OA!!\u0003\u0005\r!a\u001d\u0002\u000b\u0015\u0004(/\u001a3\u0011\u000f9\tI'!\u001e\u0002|A9\u0011$a\u001e\u0002R\u0005u\u0013bAA=\u0005\tYQ\tZ4f)JL\u0007\u000f\\3u!\rq\u0011QP\u0005\u0004\u0003\u007fz!a\u0002\"p_2,\u0017M\u001c\u0005\u000b\u0003\u0007\u000b\t\u0005%AA\u0002\u0005\u0015\u0015!\u0002<qe\u0016$\u0007\u0003\u0003\b\u0002\b&\f\t&a\u001f\n\u0007\u0005%uBA\u0005Gk:\u001cG/[8oe!9\u0011Q\u0012\u0001\u0005\u0002\u0005=\u0015\u0001\u00059jG.\u0014\u0016M\u001c3p[Z+'\u000f^3y)\u0005I\u0007bBAJ\u0001\u0011\u0005\u0011QS\u0001\u0018G>tg/\u001a:u)>\u001c\u0015M\\8oS\u000e\fG.\u00123hKN$2\u0001GAL\u0011)\tI*!%\u0011\u0002\u0003\u0007\u00111T\u0001\n[\u0016\u0014x-\u001a$v]\u000e\u0004bADADO\u001d:\u0003bBAP\u0001\u0011\u0005\u0011\u0011U\u0001\u0007aJ,w-\u001a7\u0016\t\u0005\r\u0016\u0011\u0017\u000b\t\u0003K\u000b\t/!:\u0002jRA\u0011qUA[\u0003w\u000bY\u000eF\u0002\u0019\u0003SC!\"a+\u0002\u001e\u0006\u0005\t9AAW\u0003))g/\u001b3f]\u000e,GE\u000e\t\u0005[A\ny\u000bE\u0002\u001e\u0003c#q!a-\u0002\u001e\n\u0007\u0001EA\u0001B\u0011!\t9,!(A\u0002\u0005e\u0016!\u0002<qe><\u0007\u0003\u0003\b\u0002,%d\u0012q\u0016\u000f\t\u0011\u0005u\u0016Q\u0014a\u0001\u0003\u007f\u000bqa]3oI6\u001bx\rE\u0004\u000f\u0003S\n\t-a1\u0011\u000be\t9\bH\u0014\u0011\r\u0005\u0015\u00171[Am\u001d\u0011\t9-!5\u000f\t\u0005%\u0017qZ\u0007\u0003\u0003\u0017T1!!4\u000b\u0003\u0019a$o\\8u}%\t\u0001#\u0003\u0002m\u001f%!\u0011Q[Al\u0005!IE/\u001a:bi>\u0014(B\u00017\u0010!\u0015qq/[AX\u0011!\ti.!(A\u0002\u0005}\u0017\u0001C7fe\u001e,Wj]4\u0011\u00139\t9)a,\u00020\u0006=\u0006\u0002CAr\u0003;\u0003\r!a,\u0002\u0015%t\u0017\u000e^5bY6\u001bx\rC\u0005\u0002h\u0006u\u0005\u0013!a\u0001!\u0006iQ.\u0019=Ji\u0016\u0014\u0018\r^5p]ND\u0011\"a;\u0002\u001eB\u0005\t\u0019A0\u0002\u001f\u0005\u001cG/\u001b<f\t&\u0014Xm\u0019;j_:Dq!a<\u0001\t\u0003\t\t0\u0001\u0005qC\u001e,'+\u00198l)\u0019\t\u00190a?\u0002\u0000B1\u0011DGA{\u0003k\u00042ADA|\u0013\r\tIp\u0004\u0002\u0007\t>,(\r\\3\t\u0011\u0005u\u0018Q\u001ea\u0001\u0003k\f1\u0001^8m\u0011)\u0011\t!!<\u0011\u0002\u0003\u0007\u0011Q_\u0001\ne\u0016\u001cX\r\u001e)s_\nDqA!\u0002\u0001\t\u0003\u00119!\u0001\u000bqKJ\u001cxN\\1mSj,G\rU1hKJ\u000bgn\u001b\u000b\t\u0003g\u0014IA!\u0004\u0003\u0010!9!1\u0002B\u0002\u0001\u0004I\u0017aA:sG\"A\u0011Q B\u0002\u0001\u0004\t)\u0010\u0003\u0006\u0003\u0002\t\r\u0001\u0013!a\u0001\u0003kDqAa\u0005\u0001\t\u0003\u0011)\"\u0001\u0012ti\u0006$\u0018n\u0019)be\u0006dG.\u001a7QKJ\u001cxN\\1mSj,G\rU1hKJ\u000bgn\u001b\u000b\t\u0005/\u0011IC!\f\u00032A1\u0011D\u0007B\r\u0003k\u0004BAa\u0007\u0003&5\u0011!Q\u0004\u0006\u0005\u0005?\u0011\t#\u0001\u0004mS:\fGn\u001a\u0006\u0004\u0005G!\u0011AA7m\u0013\u0011\u00119C!\b\u0003\rY+7\r^8s\u0011\u001d\u0011YC!\u0005A\u0002\u0019\fqa]8ve\u000e,7\u000fC\u0004\u00030\tE\u0001\u0019\u0001)\u0002\u000f9,X.\u0013;fe\"Q!\u0011\u0001B\t!\u0003\u0005\r!!>\t\u000f\tU\u0002\u0001\"\u0001\u00038\u0005Q2\u000f^1uS\u000e\u0004VM]:p]\u0006d\u0017N_3e!\u0006<WMU1oWRA\u00111\u001fB\u001d\u0005w\u0011i\u0004C\u0004\u0003\f\tM\u0002\u0019A5\t\u000f\t=\"1\u0007a\u0001!\"Q!\u0011\u0001B\u001a!\u0003\u0005\r!!>\t\u000f\t\u0005\u0003\u0001\"\u0001\u0003D\u0005q1\u000f^1uS\u000e\u0004\u0016mZ3SC:\\GCBAz\u0005\u000b\u00129\u0005C\u0004\u00030\t}\u0002\u0019\u0001)\t\u0015\t\u0005!q\bI\u0001\u0002\u0004\t)\u0010C\u0004\u0003L\u0001!\tA!\u0014\u0002'\r|gN\\3di\u0016$7i\\7q_:,g\u000e^:\u0015\u0005\t=\u0003\u0003B\r\u001bS\u001eBqAa\u0013\u0001\t\u0003\u0011\u0019\u0006\u0006\u0003\u0003P\tU\u0003bBAt\u0005#\u0002\r\u0001\u0015\u0005\b\u00053\u0002A\u0011\u0001B.\u00035!(/[1oO2,7i\\;oiR\u0011!Q\f\t\u00053i\u0001v\u0005C\u0004\u0003b\u0001!\tAa\u0019\u00027M$(o\u001c8hYf\u001cuN\u001c8fGR,GmQ8na>tWM\u001c;t)\u0011\u0011yE!\u001a\t\u000f\t=\"q\fa\u0001!\"I!\u0011\u000e\u0001\u0012\u0002\u0013\u0005!1N\u0001\u0011M&dG/\u001a:%I\u00164\u0017-\u001e7uII*bA!\u001c\u0003x\tmTC\u0001B8U\u0011\u0011\tH! \u0011\u000f9\tIGa\u001d\u0002|A9\u0011$a\u001e\u0003v\te\u0004cA\u000f\u0003x\u00119\u0011Q\u000bB4\u0005\u0004\u0001\u0003cA\u000f\u0003|\u00119\u0011\u0011\rB4\u0005\u0004\u00013F\u0001B@!\u0011\u0011\tIa#\u000e\u0005\t\r%\u0002\u0002BC\u0005\u000f\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\t%u\"\u0001\u0006b]:|G/\u0019;j_:LAA!$\u0003\u0004\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u0013\tE\u0005!%A\u0005\u0002\tM\u0015\u0001\u00054jYR,'\u000f\n3fM\u0006,H\u000e\u001e\u00134+\u0019\u0011)J!(\u0003 V\u0011!q\u0013\u0016\u0005\u00053\u0013i\b\u0005\u0005\u000f\u0003\u000fK'1TA>!\ri\"Q\u0014\u0003\b\u0003+\u0012yI1\u0001!\t\u001d\t\tGa$C\u0002\u0001B\u0011Ba)\u0001#\u0003%\tA!*\u0002C\r|gN^3siR{7)\u00198p]&\u001c\u0017\r\\#eO\u0016\u001cH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\t\u001d&\u0006BAN\u0005{B\u0011Ba+\u0001#\u0003%\tA!,\u0002!A\u0014XmZ3mI\u0011,g-Y;mi\u0012\u0012T\u0003\u0002BX\u0005g+\"A!-+\u0007A\u0013i\bB\u0004\u00024\n%&\u0019\u0001\u0011\t\u0013\t]\u0006!%A\u0005\u0002\te\u0016\u0001\u00059sK\u001e,G\u000e\n3fM\u0006,H\u000e\u001e\u00134+\u0011\u0011YLa0\u0016\u0005\tu&fA0\u0003~\u00119\u00111\u0017B[\u0005\u0004\u0001\u0003\"\u0003Bb\u0001E\u0005I\u0011\u0001Bc\u0003I\u0001\u0018mZ3SC:\\G\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\t\u001d'\u0006BA{\u0005{B\u0011Ba3\u0001#\u0003%\tA!2\u0002=A,'o]8oC2L'0\u001a3QC\u001e,'+\u00198lI\u0011,g-Y;mi\u0012\u001a\u0004\"\u0003Bh\u0001E\u0005I\u0011\u0001Bc\u00031\u001aH/\u0019;jGB\u000b'/\u00197mK2\u0004VM]:p]\u0006d\u0017N_3e!\u0006<WMU1oW\u0012\"WMZ1vYR$3\u0007C\u0005\u0003T\u0002\t\n\u0011\"\u0001\u0003F\u0006!3\u000f^1uS\u000e\u0004VM]:p]\u0006d\u0017N_3e!\u0006<WMU1oW\u0012\"WMZ1vYR$3\u0007C\u0005\u0003X\u0002\t\n\u0011\"\u0001\u0003F\u0006A2\u000f^1uS\u000e\u0004\u0016mZ3SC:\\G\u0005Z3gCVdG\u000f\n\u001a")
public class GraphOps<VD, ED>
implements scala.Serializable {
    private transient long numEdges;
    private transient long numVertices;
    private transient VertexRDD<Object> inDegrees;
    private transient VertexRDD<Object> outDegrees;
    private transient VertexRDD<Object> degrees;
    private final Graph<VD, ED> graph;
    private final ClassTag<VD> evidence$1;
    private final ClassTag<ED> evidence$2;
    private volatile transient byte bitmap$trans$0;

    private long numEdges$lzycompute() {
        GraphOps graphOps = this;
        synchronized (graphOps) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.numEdges = this.graph.edges().count();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.numEdges;
    }

    public long numEdges() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.numEdges$lzycompute() : this.numEdges;
    }

    private long numVertices$lzycompute() {
        GraphOps graphOps = this;
        synchronized (graphOps) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.numVertices = this.graph.vertices().count();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.numVertices;
    }

    public long numVertices() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.numVertices$lzycompute() : this.numVertices;
    }

    private VertexRDD<Object> inDegrees$lzycompute() {
        GraphOps graphOps = this;
        synchronized (graphOps) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                this.inDegrees = (VertexRDD)this.degreesRDD(EdgeDirection$.MODULE$.In()).setName("GraphOps.inDegrees");
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
        }
        return this.inDegrees;
    }

    public VertexRDD<Object> inDegrees() {
        return (byte)(this.bitmap$trans$0 & 4) == 0 ? this.inDegrees$lzycompute() : this.inDegrees;
    }

    private VertexRDD<Object> outDegrees$lzycompute() {
        GraphOps graphOps = this;
        synchronized (graphOps) {
            if ((byte)(this.bitmap$trans$0 & 8) == 0) {
                this.outDegrees = (VertexRDD)this.degreesRDD(EdgeDirection$.MODULE$.Out()).setName("GraphOps.outDegrees");
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 8);
            }
        }
        return this.outDegrees;
    }

    public VertexRDD<Object> outDegrees() {
        return (byte)(this.bitmap$trans$0 & 8) == 0 ? this.outDegrees$lzycompute() : this.outDegrees;
    }

    private VertexRDD<Object> degrees$lzycompute() {
        GraphOps graphOps = this;
        synchronized (graphOps) {
            if ((byte)(this.bitmap$trans$0 & 0x10) == 0) {
                this.degrees = (VertexRDD)this.degreesRDD(EdgeDirection$.MODULE$.Either()).setName("GraphOps.degrees");
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 0x10);
            }
        }
        return this.degrees;
    }

    public VertexRDD<Object> degrees() {
        return (byte)(this.bitmap$trans$0 & 0x10) == 0 ? this.degrees$lzycompute() : this.degrees;
    }

    private VertexRDD<Object> degreesRDD(EdgeDirection edgeDirection) {
        VertexRDD<Object> vertexRDD;
        EdgeDirection edgeDirection2 = edgeDirection;
        EdgeDirection edgeDirection3 = EdgeDirection$.MODULE$.In();
        if (!(edgeDirection2 != null ? !((Object)edgeDirection2).equals(edgeDirection3) : edgeDirection3 != null)) {
            vertexRDD = this.graph.aggregateMessages((Function1 & Serializable & scala.Serializable)x$1 -> {
                x$1.sendToDst(BoxesRunTime.boxToInteger((int)1));
                return BoxedUnit.UNIT;
            }, (JFunction2.mcIII.sp & Serializable & scala.Serializable)(x$2, x$3) -> x$2 + x$3, TripletFields.None, ClassTag$.MODULE$.Int());
        } else {
            EdgeDirection edgeDirection4 = edgeDirection;
            EdgeDirection edgeDirection5 = EdgeDirection$.MODULE$.Out();
            vertexRDD = !(edgeDirection4 != null ? !((Object)edgeDirection4).equals(edgeDirection5) : edgeDirection5 != null) ? this.graph.aggregateMessages((Function1 & Serializable & scala.Serializable)x$4 -> {
                x$4.sendToSrc(BoxesRunTime.boxToInteger((int)1));
                return BoxedUnit.UNIT;
            }, (JFunction2.mcIII.sp & Serializable & scala.Serializable)(x$5, x$6) -> x$5 + x$6, TripletFields.None, ClassTag$.MODULE$.Int()) : this.graph.aggregateMessages((Function1 & Serializable & scala.Serializable)ctx -> {
                GraphOps.$anonfun$degreesRDD$5(ctx);
                return BoxedUnit.UNIT;
            }, (JFunction2.mcIII.sp & Serializable & scala.Serializable)(x$7, x$8) -> x$7 + x$8, TripletFields.None, ClassTag$.MODULE$.Int());
        }
        return vertexRDD;
    }

    public VertexRDD<long[]> collectNeighborIds(EdgeDirection edgeDirection) {
        VertexRDD vertexRDD;
        EdgeDirection edgeDirection2 = edgeDirection;
        EdgeDirection edgeDirection3 = EdgeDirection$.MODULE$.Either();
        if (!(edgeDirection2 != null ? !((Object)edgeDirection2).equals(edgeDirection3) : edgeDirection3 != null)) {
            vertexRDD = this.graph.aggregateMessages((Function1 & Serializable & scala.Serializable)ctx -> {
                GraphOps.$anonfun$collectNeighborIds$1(ctx);
                return BoxedUnit.UNIT;
            }, (Function2 & Serializable & scala.Serializable)(x$9, x$10) -> (long[])new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(x$9)).$plus$plus((GenTraversableOnce)new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(x$10)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Long.TYPE))), TripletFields.None, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Long.TYPE)));
        } else {
            EdgeDirection edgeDirection4 = edgeDirection;
            EdgeDirection edgeDirection5 = EdgeDirection$.MODULE$.Out();
            if (!(edgeDirection4 != null ? !((Object)edgeDirection4).equals(edgeDirection5) : edgeDirection5 != null)) {
                vertexRDD = this.graph.aggregateMessages((Function1 & Serializable & scala.Serializable)ctx -> {
                    ctx.sendToSrc(new long[]{ctx.dstId()});
                    return BoxedUnit.UNIT;
                }, (Function2 & Serializable & scala.Serializable)(x$11, x$12) -> (long[])new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(x$11)).$plus$plus((GenTraversableOnce)new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(x$12)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Long.TYPE))), TripletFields.None, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Long.TYPE)));
            } else {
                EdgeDirection edgeDirection6 = edgeDirection;
                EdgeDirection edgeDirection7 = EdgeDirection$.MODULE$.In();
                if (!(edgeDirection6 != null ? !((Object)edgeDirection6).equals(edgeDirection7) : edgeDirection7 != null)) {
                    vertexRDD = this.graph.aggregateMessages((Function1 & Serializable & scala.Serializable)ctx -> {
                        ctx.sendToDst(new long[]{ctx.srcId()});
                        return BoxedUnit.UNIT;
                    }, (Function2 & Serializable & scala.Serializable)(x$13, x$14) -> (long[])new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(x$13)).$plus$plus((GenTraversableOnce)new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(x$14)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Long.TYPE))), TripletFields.None, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Long.TYPE)));
                } else {
                    throw new SparkException("It doesn't make sense to collect neighbor ids without a direction. (EdgeDirection.Both is not supported; use EdgeDirection.Either instead.)");
                }
            }
        }
        VertexRDD nbrs = vertexRDD;
        return this.graph.vertices().leftZipJoin(nbrs, (Function3 & Serializable & scala.Serializable)(vid, vdata, nbrsOpt) -> GraphOps.$anonfun$collectNeighborIds$7(BoxesRunTime.unboxToLong((Object)vid), vdata, nbrsOpt), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Long.TYPE)), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Long.TYPE)));
    }

    public VertexRDD<Tuple2<Object, VD>[]> collectNeighbors(EdgeDirection edgeDirection) {
        VertexRDD vertexRDD;
        EdgeDirection edgeDirection2 = edgeDirection;
        EdgeDirection edgeDirection3 = EdgeDirection$.MODULE$.Either();
        EdgeDirection edgeDirection4 = edgeDirection2;
        if (!(edgeDirection3 != null ? !((Object)edgeDirection3).equals(edgeDirection4) : edgeDirection4 != null)) {
            vertexRDD = this.graph.aggregateMessages((Function1 & Serializable & scala.Serializable)ctx -> {
                GraphOps.$anonfun$collectNeighbors$1(ctx);
                return BoxedUnit.UNIT;
            }, (Function2 & Serializable & scala.Serializable)(a, b) -> (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])a)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])b)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))), TripletFields.All, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Tuple2.class)));
        } else {
            EdgeDirection edgeDirection5 = EdgeDirection$.MODULE$.In();
            EdgeDirection edgeDirection6 = edgeDirection2;
            if (!(edgeDirection5 != null ? !((Object)edgeDirection5).equals(edgeDirection6) : edgeDirection6 != null)) {
                vertexRDD = this.graph.aggregateMessages((Function1 & Serializable & scala.Serializable)ctx -> {
                    ctx.sendToDst((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToLong((long)ctx.srcId()), ctx.srcAttr())});
                    return BoxedUnit.UNIT;
                }, (Function2 & Serializable & scala.Serializable)(a, b) -> (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])a)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])b)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))), TripletFields.Src, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Tuple2.class)));
            } else {
                EdgeDirection edgeDirection7 = EdgeDirection$.MODULE$.Out();
                EdgeDirection edgeDirection8 = edgeDirection2;
                if (!(edgeDirection7 != null ? !((Object)edgeDirection7).equals(edgeDirection8) : edgeDirection8 != null)) {
                    vertexRDD = this.graph.aggregateMessages((Function1 & Serializable & scala.Serializable)ctx -> {
                        ctx.sendToSrc((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToLong((long)ctx.dstId()), ctx.dstAttr())});
                        return BoxedUnit.UNIT;
                    }, (Function2 & Serializable & scala.Serializable)(a, b) -> (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])a)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])b)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))), TripletFields.Dst, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Tuple2.class)));
                } else {
                    EdgeDirection edgeDirection9 = EdgeDirection$.MODULE$.Both();
                    EdgeDirection edgeDirection10 = edgeDirection2;
                    if (!(edgeDirection9 != null ? !((Object)edgeDirection9).equals(edgeDirection10) : edgeDirection10 != null)) {
                        throw new SparkException("collectEdges does not support EdgeDirection.Both. UseEdgeDirection.Either instead.");
                    }
                    throw new MatchError((Object)edgeDirection2);
                }
            }
        }
        VertexRDD nbrs = vertexRDD;
        return this.graph.vertices().leftJoin(nbrs, (Function3 & Serializable & scala.Serializable)(vid, vdata, nbrsOpt) -> GraphOps.$anonfun$collectNeighbors$7(BoxesRunTime.unboxToLong((Object)vid), vdata, nbrsOpt), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Tuple2.class)), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Tuple2.class)));
    }

    public VertexRDD<Edge<ED>[]> collectEdges(EdgeDirection edgeDirection) {
        VertexRDD<Object> vertexRDD;
        EdgeDirection edgeDirection2 = edgeDirection;
        EdgeDirection edgeDirection3 = EdgeDirection$.MODULE$.Either();
        EdgeDirection edgeDirection4 = edgeDirection2;
        if (!(edgeDirection3 != null ? !((Object)edgeDirection3).equals(edgeDirection4) : edgeDirection4 != null)) {
            vertexRDD = this.graph.aggregateMessages((Function1 & Serializable & scala.Serializable)ctx -> {
                GraphOps.$anonfun$collectEdges$1(ctx);
                return BoxedUnit.UNIT;
            }, (Function2 & Serializable & scala.Serializable)(a, b) -> (Edge[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])a)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])b)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Edge.class))), TripletFields.EdgeOnly, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Edge.class)));
        } else {
            EdgeDirection edgeDirection5 = EdgeDirection$.MODULE$.In();
            EdgeDirection edgeDirection6 = edgeDirection2;
            if (!(edgeDirection5 != null ? !((Object)edgeDirection5).equals(edgeDirection6) : edgeDirection6 != null)) {
                vertexRDD = this.graph.aggregateMessages((Function1 & Serializable & scala.Serializable)ctx -> {
                    ctx.sendToDst((Object[])new Edge[]{new Edge(ctx.srcId(), ctx.dstId(), ctx.attr())});
                    return BoxedUnit.UNIT;
                }, (Function2 & Serializable & scala.Serializable)(a, b) -> (Edge[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])a)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])b)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Edge.class))), TripletFields.EdgeOnly, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Edge.class)));
            } else {
                EdgeDirection edgeDirection7 = EdgeDirection$.MODULE$.Out();
                EdgeDirection edgeDirection8 = edgeDirection2;
                if (!(edgeDirection7 != null ? !((Object)edgeDirection7).equals(edgeDirection8) : edgeDirection8 != null)) {
                    vertexRDD = this.graph.aggregateMessages((Function1 & Serializable & scala.Serializable)ctx -> {
                        ctx.sendToSrc((Object[])new Edge[]{new Edge(ctx.srcId(), ctx.dstId(), ctx.attr())});
                        return BoxedUnit.UNIT;
                    }, (Function2 & Serializable & scala.Serializable)(a, b) -> (Edge[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])a)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])b)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Edge.class))), TripletFields.EdgeOnly, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Edge.class)));
                } else {
                    EdgeDirection edgeDirection9 = EdgeDirection$.MODULE$.Both();
                    EdgeDirection edgeDirection10 = edgeDirection2;
                    if (!(edgeDirection9 != null ? !((Object)edgeDirection9).equals(edgeDirection10) : edgeDirection10 != null)) {
                        throw new SparkException("collectEdges does not support EdgeDirection.Both. UseEdgeDirection.Either instead.");
                    }
                    throw new MatchError((Object)edgeDirection2);
                }
            }
        }
        return vertexRDD;
    }

    public Graph<VD, ED> removeSelfEdges() {
        return this.graph.subgraph((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToBoolean((boolean)GraphOps.$anonfun$removeSelfEdges$1(e)), this.graph.subgraph$default$2());
    }

    public <U> Graph<VD, ED> joinVertices(RDD<Tuple2<Object, U>> table, Function3<Object, VD, U, VD> mapFunc, ClassTag<U> evidence$3) {
        Function3 & Serializable & scala.Serializable uf = (Function3 & Serializable & scala.Serializable)(id, data, o) -> GraphOps.$anonfun$joinVertices$1(mapFunc, BoxesRunTime.unboxToLong((Object)id), data, o);
        return this.graph.outerJoinVertices(table, uf, evidence$3, this.evidence$1, Predef.$eq$colon$eq$.MODULE$.tpEquals());
    }

    public <VD2, ED2> Graph<VD, ED> filter(Function1<Graph<VD, ED>, Graph<VD2, ED2>> preprocess, Function1<EdgeTriplet<VD2, ED2>, Object> epred, Function2<Object, VD2, Object> vpred, ClassTag<VD2> evidence$4, ClassTag<ED2> evidence$5) {
        return this.graph.mask(((Graph)preprocess.apply(this.graph)).subgraph(epred, vpred), evidence$4, evidence$5);
    }

    public <VD2, ED2> Function1<EdgeTriplet<VD2, ED2>, Object> filter$default$2() {
        return (Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)GraphOps.$anonfun$filter$default$2$1(x));
    }

    public <VD2, ED2> Function2<Object, VD2, Object> filter$default$3() {
        return (Function2 & Serializable & scala.Serializable)(v, d) -> BoxesRunTime.boxToBoolean((boolean)GraphOps.$anonfun$filter$default$3$1(BoxesRunTime.unboxToLong((Object)v), d));
    }

    public long pickRandomVertex() {
        double probability = 50.0 / (double)Graph$.MODULE$.graphToGraphOps(this.graph, this.evidence$1, this.evidence$2).numVertices();
        boolean found = false;
        long retVal = BoxesRunTime.unboxToLong(null);
        while (!found) {
            RDD selectedVertices = this.graph.vertices().flatMap((Function1 & Serializable & scala.Serializable)vidVvals -> Random$.MODULE$.nextDouble() < probability ? Option$.MODULE$.option2Iterable((Option)new Some((Object)BoxesRunTime.boxToLong((long)vidVvals._1$mcJ$sp()))) : Option$.MODULE$.option2Iterable((Option)None$.MODULE$), ClassTag$.MODULE$.apply(Long.TYPE));
            if (selectedVertices.count() <= 0L) continue;
            found = true;
            long[] collectedVertices = (long[])selectedVertices.collect();
            retVal = collectedVertices[Random$.MODULE$.nextInt(collectedVertices.length)];
        }
        return retVal;
    }

    public Graph<VD, ED> convertToCanonicalEdges(Function2<ED, ED, ED> mergeFunc) {
        RDD newEdges = RDD$.MODULE$.rddToPairRDDFunctions(this.graph.edges().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Edge edge = x0$1;
            Tuple2 tuple2 = edge.srcId() < edge.dstId() ? new Tuple2((Object)new Tuple2.mcJJ.sp(edge.srcId(), edge.dstId()), edge.attr()) : new Tuple2((Object)new Tuple2.mcJJ.sp(edge.dstId(), edge.srcId()), edge.attr());
            return tuple2;
        }, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(Tuple2.class), this.evidence$2, Ordering$.MODULE$.Tuple2((Ordering)Ordering.Long$.MODULE$, (Ordering)Ordering.Long$.MODULE$)).reduceByKey(mergeFunc).map((Function1 & Serializable & scala.Serializable)e -> new Edge<Object>(((Tuple2)e._1())._1$mcJ$sp(), ((Tuple2)e._1())._2$mcJ$sp(), e._2()), ClassTag$.MODULE$.apply(Edge.class));
        return Graph$.MODULE$.apply(this.graph.vertices(), newEdges, Graph$.MODULE$.apply$default$3(), Graph$.MODULE$.apply$default$4(), Graph$.MODULE$.apply$default$5(), this.evidence$1, this.evidence$2);
    }

    public Function2<ED, ED, ED> convertToCanonicalEdges$default$1() {
        return (Function2 & Serializable & scala.Serializable)(e1, e2) -> e1;
    }

    public <A> Graph<VD, ED> pregel(A initialMsg, int maxIterations, EdgeDirection activeDirection, Function3<Object, VD, A, VD> vprog, Function1<EdgeTriplet<VD, ED>, Iterator<Tuple2<Object, A>>> sendMsg, Function2<A, A, A> mergeMsg, ClassTag<A> evidence$6) {
        return Pregel$.MODULE$.apply(this.graph, initialMsg, maxIterations, activeDirection, vprog, sendMsg, mergeMsg, this.evidence$1, this.evidence$2, evidence$6);
    }

    public <A> int pregel$default$2() {
        return Integer.MAX_VALUE;
    }

    public <A> EdgeDirection pregel$default$3() {
        return EdgeDirection$.MODULE$.Either();
    }

    public Graph<Object, Object> pageRank(double tol, double resetProb) {
        return PageRank$.MODULE$.runUntilConvergence(this.graph, tol, resetProb, this.evidence$1, this.evidence$2);
    }

    public double pageRank$default$2() {
        return 0.15;
    }

    public Graph<Object, Object> personalizedPageRank(long src, double tol, double resetProb) {
        return PageRank$.MODULE$.runUntilConvergenceWithOptions(this.graph, tol, resetProb, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)src)), this.evidence$1, this.evidence$2);
    }

    public double personalizedPageRank$default$3() {
        return 0.15;
    }

    public Graph<Vector, Object> staticParallelPersonalizedPageRank(long[] sources, int numIter, double resetProb) {
        return PageRank$.MODULE$.runParallelPersonalizedPageRank(this.graph, numIter, resetProb, sources, this.evidence$1, this.evidence$2);
    }

    public double staticParallelPersonalizedPageRank$default$3() {
        return 0.15;
    }

    public Graph<Object, Object> staticPersonalizedPageRank(long src, int numIter, double resetProb) {
        return PageRank$.MODULE$.runWithOptions(this.graph, numIter, resetProb, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)src)), this.evidence$1, this.evidence$2);
    }

    public double staticPersonalizedPageRank$default$3() {
        return 0.15;
    }

    public Graph<Object, Object> staticPageRank(int numIter, double resetProb) {
        return PageRank$.MODULE$.run(this.graph, numIter, resetProb, this.evidence$1, this.evidence$2);
    }

    public double staticPageRank$default$2() {
        return 0.15;
    }

    public Graph<Object, ED> connectedComponents() {
        return ConnectedComponents$.MODULE$.run(this.graph, this.evidence$1, this.evidence$2);
    }

    public Graph<Object, ED> connectedComponents(int maxIterations) {
        return ConnectedComponents$.MODULE$.run(this.graph, maxIterations, this.evidence$1, this.evidence$2);
    }

    public Graph<Object, ED> triangleCount() {
        return TriangleCount$.MODULE$.run(this.graph, this.evidence$1, this.evidence$2);
    }

    public Graph<Object, ED> stronglyConnectedComponents(int numIter) {
        return StronglyConnectedComponents$.MODULE$.run(this.graph, numIter, this.evidence$1, this.evidence$2);
    }

    public static final /* synthetic */ void $anonfun$degreesRDD$5(EdgeContext ctx) {
        ctx.sendToSrc(BoxesRunTime.boxToInteger((int)1));
        ctx.sendToDst(BoxesRunTime.boxToInteger((int)1));
    }

    public static final /* synthetic */ void $anonfun$collectNeighborIds$1(EdgeContext ctx) {
        ctx.sendToSrc(new long[]{ctx.dstId()});
        ctx.sendToDst(new long[]{ctx.srcId()});
    }

    public static final /* synthetic */ long[] $anonfun$collectNeighborIds$7(long vid, Object vdata, Option nbrsOpt) {
        return (long[])nbrsOpt.getOrElse((Function0 & Serializable & scala.Serializable)() -> (long[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Long.TYPE)));
    }

    public static final /* synthetic */ void $anonfun$collectNeighbors$1(EdgeContext ctx) {
        ctx.sendToSrc((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToLong((long)ctx.dstId()), ctx.dstAttr())});
        ctx.sendToDst((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToLong((long)ctx.srcId()), ctx.srcAttr())});
    }

    public static final /* synthetic */ Tuple2[] $anonfun$collectNeighbors$7(long vid, Object vdata, Option nbrsOpt) {
        return (Tuple2[])nbrsOpt.getOrElse((Function0 & Serializable & scala.Serializable)() -> (Tuple2[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Tuple2.class)));
    }

    public static final /* synthetic */ void $anonfun$collectEdges$1(EdgeContext ctx) {
        ctx.sendToSrc((Object[])new Edge[]{new Edge(ctx.srcId(), ctx.dstId(), ctx.attr())});
        ctx.sendToDst((Object[])new Edge[]{new Edge(ctx.srcId(), ctx.dstId(), ctx.attr())});
    }

    public static final /* synthetic */ boolean $anonfun$removeSelfEdges$1(EdgeTriplet e) {
        return e.srcId() != e.dstId();
    }

    public static final /* synthetic */ Object $anonfun$joinVertices$1(Function3 mapFunc$1, long id, Object data, Option o) {
        Object object;
        Option option = o;
        if (option instanceof Some) {
            Some some = (Some)option;
            Object u = some.value();
            object = mapFunc$1.apply((Object)BoxesRunTime.boxToLong((long)id), data, u);
        } else if (None$.MODULE$.equals(option)) {
            object = data;
        } else {
            throw new MatchError((Object)option);
        }
        return object;
    }

    public static final /* synthetic */ boolean $anonfun$filter$default$2$1(EdgeTriplet x) {
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$filter$default$3$1(long v, Object d) {
        return true;
    }

    public GraphOps(Graph<VD, ED> graph, ClassTag<VD> evidence$1, ClassTag<ED> evidence$2) {
        this.graph = graph;
        this.evidence$1 = evidence$1;
        this.evidence$2 = evidence$2;
    }
}

