/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.graphx;

import java.io.Serializable;
import org.apache.spark.HashPartitioner;
import org.apache.spark.Partitioner;
import org.apache.spark.graphx.EdgeRDD;
import org.apache.spark.graphx.VertexRDD;
import org.apache.spark.graphx.impl.EdgePartition;
import org.apache.spark.graphx.impl.RoutingTablePartition;
import org.apache.spark.graphx.impl.RoutingTablePartition$;
import org.apache.spark.graphx.impl.ShippableVertexPartition;
import org.apache.spark.graphx.impl.ShippableVertexPartition$;
import org.apache.spark.graphx.impl.VertexRDDImpl;
import org.apache.spark.graphx.impl.VertexRDDImpl$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import scala.Function$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class VertexRDD$
implements scala.Serializable {
    public static VertexRDD$ MODULE$;

    static {
        new VertexRDD$();
    }

    public <VD> VertexRDD<VD> apply(RDD<Tuple2<Object, VD>> vertices, ClassTag<VD> evidence$14) {
        RDD rDD;
        Option option = vertices.partitioner();
        if (option instanceof Some) {
            rDD = vertices;
        } else if (None$.MODULE$.equals(option)) {
            rDD = RDD$.MODULE$.rddToPairRDDFunctions(vertices, ClassTag$.MODULE$.apply(Long.TYPE), evidence$14, (Ordering)Ordering.Long$.MODULE$).partitionBy((Partitioner)new HashPartitioner(vertices.partitions().length));
        } else {
            throw new MatchError((Object)option);
        }
        RDD vPartitioned = rDD;
        RDD vertexPartitions = vPartitioned.mapPartitions((Function1 & Serializable & scala.Serializable)iter -> package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ShippableVertexPartition[]{ShippableVertexPartition$.MODULE$.apply(iter, evidence$14)})), true, ClassTag$.MODULE$.apply(ShippableVertexPartition.class));
        return new VertexRDDImpl<VD>(vertexPartitions, VertexRDDImpl$.MODULE$.$lessinit$greater$default$2(), evidence$14);
    }

    public <VD> VertexRDD<VD> apply(RDD<Tuple2<Object, VD>> vertices, EdgeRDD<?> edges, VD defaultVal, ClassTag<VD> evidence$15) {
        return this.apply(vertices, edges, defaultVal, (Function2 & Serializable & scala.Serializable)(a, b) -> a, evidence$15);
    }

    public <VD> VertexRDD<VD> apply(RDD<Tuple2<Object, VD>> vertices, EdgeRDD<?> edges, VD defaultVal, Function2<VD, VD, VD> mergeFunc, ClassTag<VD> evidence$16) {
        RDD rDD;
        Option option = vertices.partitioner();
        if (option instanceof Some) {
            rDD = vertices;
        } else if (None$.MODULE$.equals(option)) {
            rDD = RDD$.MODULE$.rddToPairRDDFunctions(vertices, ClassTag$.MODULE$.apply(Long.TYPE), evidence$16, (Ordering)Ordering.Long$.MODULE$).partitionBy((Partitioner)new HashPartitioner(vertices.partitions().length));
        } else {
            throw new MatchError((Object)option);
        }
        RDD vPartitioned = rDD;
        RDD<RoutingTablePartition> routingTables = this.createRoutingTables(edges, (Partitioner)vPartitioned.partitioner().get());
        RDD vertexPartitions = vPartitioned.zipPartitions(routingTables, true, (Function2 & Serializable & scala.Serializable)(vertexIter, routingTableIter) -> {
            RoutingTablePartition routingTable = routingTableIter.hasNext() ? (RoutingTablePartition)routingTableIter.next() : RoutingTablePartition$.MODULE$.empty();
            return package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ShippableVertexPartition[]{ShippableVertexPartition$.MODULE$.apply(vertexIter, routingTable, defaultVal, mergeFunc, evidence$16)}));
        }, ClassTag$.MODULE$.apply(RoutingTablePartition.class), ClassTag$.MODULE$.apply(ShippableVertexPartition.class));
        return new VertexRDDImpl<VD>(vertexPartitions, VertexRDDImpl$.MODULE$.$lessinit$greater$default$2(), evidence$16);
    }

    public <VD> VertexRDD<VD> fromEdges(EdgeRDD<?> edges, int numPartitions, VD defaultVal, ClassTag<VD> evidence$17) {
        RDD<RoutingTablePartition> routingTables = this.createRoutingTables(edges, (Partitioner)new HashPartitioner(numPartitions));
        RDD vertexPartitions = routingTables.mapPartitions((Function1 & Serializable & scala.Serializable)routingTableIter -> {
            RoutingTablePartition routingTable = routingTableIter.hasNext() ? (RoutingTablePartition)routingTableIter.next() : RoutingTablePartition$.MODULE$.empty();
            return package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ShippableVertexPartition[]{ShippableVertexPartition$.MODULE$.apply(package$.MODULE$.Iterator().empty(), routingTable, defaultVal, evidence$17)}));
        }, true, ClassTag$.MODULE$.apply(ShippableVertexPartition.class));
        return new VertexRDDImpl<VD>(vertexPartitions, VertexRDDImpl$.MODULE$.$lessinit$greater$default$2(), evidence$17);
    }

    public RDD<RoutingTablePartition> createRoutingTables(EdgeRDD<?> edges, Partitioner vertexPartitioner) {
        RDD<Tuple2<Object, EdgePartition<?, Object>>> qual$1 = edges.partitionsRDD();
        Function1 & Serializable & scala.Serializable x$3 = (Function1 & Serializable & scala.Serializable)x$2 -> x$2.flatMap(Function$.MODULE$.tupled((Function2 & Serializable & scala.Serializable)(pid, edgePartition) -> RoutingTablePartition$.MODULE$.edgePartitionToMsgs(BoxesRunTime.unboxToInt((Object)pid), edgePartition)));
        boolean x$4 = qual$1.mapPartitions$default$2();
        RDD vid2pid = qual$1.mapPartitions((Function1)x$3, x$4, ClassTag$.MODULE$.apply(Tuple2.class)).setName("VertexRDD.createRoutingTables - vid2pid (aggregation)");
        int numEdgePartitions = edges.partitions().length;
        return RDD$.MODULE$.rddToPairRDDFunctions(vid2pid, ClassTag$.MODULE$.apply(Long.TYPE), ClassTag$.MODULE$.Int(), (Ordering)Ordering.Long$.MODULE$).partitionBy(vertexPartitioner).mapPartitions((Function1 & Serializable & scala.Serializable)iter -> package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new RoutingTablePartition[]{RoutingTablePartition$.MODULE$.fromMsgs(numEdgePartitions, (Iterator<Tuple2<Object, Object>>)iter)})), true, ClassTag$.MODULE$.apply(RoutingTablePartition.class));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private VertexRDD$() {
        MODULE$ = this;
    }
}

