/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.graphx.impl;

import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import org.apache.spark.HashPartitioner;
import org.apache.spark.Partitioner;
import org.apache.spark.graphx.Edge;
import org.apache.spark.graphx.EdgeContext;
import org.apache.spark.graphx.EdgeDirection;
import org.apache.spark.graphx.EdgeDirection$;
import org.apache.spark.graphx.EdgeRDD;
import org.apache.spark.graphx.EdgeTriplet;
import org.apache.spark.graphx.Graph;
import org.apache.spark.graphx.PartitionStrategy;
import org.apache.spark.graphx.TripletFields;
import org.apache.spark.graphx.VertexRDD;
import org.apache.spark.graphx.impl.EdgeActiveness;
import org.apache.spark.graphx.impl.EdgePartition;
import org.apache.spark.graphx.impl.EdgePartitionBuilder;
import org.apache.spark.graphx.impl.EdgePartitionBuilder$;
import org.apache.spark.graphx.impl.EdgeRDDImpl;
import org.apache.spark.graphx.impl.GraphImpl$;
import org.apache.spark.graphx.impl.ReplicatedVertexView;
import org.apache.spark.graphx.impl.ShippableVertexPartition;
import org.apache.spark.graphx.impl.ShippableVertexPartition$;
import org.apache.spark.graphx.util.BytecodeUtils$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.storage.StorageLevel;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.Function4;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0011Me\u0001B\u0001\u0003\u00015\u0011\u0011b\u0012:ba\"LU\u000e\u001d7\u000b\u0005\r!\u0011\u0001B5na2T!!\u0002\u0004\u0002\r\u001d\u0014\u0018\r\u001d5y\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7\u0001A\u000b\u0004\u001dU\u00113c\u0001\u0001\u0010IA!\u0001#E\n\"\u001b\u0005!\u0011B\u0001\n\u0005\u0005\u00159%/\u00199i!\t!R\u0003\u0004\u0001\u0005\u000bY\u0001!\u0019A\f\u0003\u0005Y#\u0015C\u0001\r\u001f!\tIB$D\u0001\u001b\u0015\u0005Y\u0012!B:dC2\f\u0017BA\u000f\u001b\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"!G\u0010\n\u0005\u0001R\"aA!osB\u0011AC\t\u0003\u0006G\u0001\u0011\ra\u0006\u0002\u0003\u000b\u0012\u0003\"!G\u0013\n\u0005\u0019R\"\u0001D*fe&\fG.\u001b>bE2,\u0007\u0002\u0003\u0015\u0001\u0005\u000b\u0007I\u0011A\u0015\u0002\u0011Y,'\u000f^5dKN,\u0012A\u000b\t\u0004!-\u001a\u0012B\u0001\u0017\u0005\u0005%1VM\u001d;fqJ#E\t\u0003\u0005/\u0001\t\u0005\t\u0015!\u0003+\u0003%1XM\u001d;jG\u0016\u001c\b\u0005\u000b\u0002.aA\u0011\u0011$M\u0005\u0003ei\u0011\u0011\u0002\u001e:b]NLWM\u001c;\t\u0011Q\u0002!Q1A\u0005\u0002U\nAC]3qY&\u001c\u0017\r^3e-\u0016\u0014H/\u001a=WS\u0016<X#\u0001\u001c\u0011\t]B4#I\u0007\u0002\u0005%\u0011\u0011H\u0001\u0002\u0015%\u0016\u0004H.[2bi\u0016$g+\u001a:uKb4\u0016.Z<\t\u0011m\u0002!\u0011!Q\u0001\nY\nQC]3qY&\u001c\u0017\r^3e-\u0016\u0014H/\u001a=WS\u0016<\b\u0005\u000b\u0002;a!Aa\b\u0001B\u0002B\u0003-q(\u0001\u0006fm&$WM\\2fIE\u00022\u0001Q\"\u0014\u001b\u0005\t%B\u0001\"\u001b\u0003\u001d\u0011XM\u001a7fGRL!\u0001R!\u0003\u0011\rc\u0017m]:UC\u001eD\u0001B\u0012\u0001\u0003\u0004\u0003\u0006YaR\u0001\u000bKZLG-\u001a8dK\u0012\u0012\u0004c\u0001!DC!)\u0011\n\u0001C\t\u0015\u00061A(\u001b8jiz\"2aS(Q)\raUJ\u0014\t\u0005o\u0001\u0019\u0012\u0005C\u0003?\u0011\u0002\u000fq\bC\u0003G\u0011\u0002\u000fq\tC\u0003)\u0011\u0002\u0007!\u0006C\u00035\u0011\u0002\u0007a\u0007C\u0003J\u0001\u0011E!\u000bF\u0001T)\raEK\u0016\u0005\b+F\u000b\t\u0011q\u0001@\u0003))g/\u001b3f]\u000e,Ge\r\u0005\b/F\u000b\t\u0011q\u0001H\u0003))g/\u001b3f]\u000e,G\u0005\u000e\u0005\b3\u0002\u0011\r\u0011\"\u0011[\u0003\u0015)GmZ3t+\u0005Y\u0006\u0003B\u001c]CMI!!\u0018\u0002\u0003\u0017\u0015#w-\u001a*E\t&k\u0007\u000f\u001c\u0005\u0007?\u0002\u0001\u000b\u0011B.\u0002\r\u0015$w-Z:!Q\tq\u0006\u0007\u0003\u0005c\u0001!\u0015\r\u0011\"\u0011d\u0003!!(/\u001b9mKR\u001cX#\u00013\u0011\u0007\u0015D'.D\u0001g\u0015\t9g!A\u0002sI\u0012L!!\u001b4\u0003\u0007I#E\t\u0005\u0003\u0011WN\t\u0013B\u00017\u0005\u0005-)EmZ3Ue&\u0004H.\u001a;)\u0005\u0005\u0004\u0004\"B8\u0001\t\u0003\u0002\u0018a\u00029feNL7\u000f\u001e\u000b\u0003\u001fEDqA\u001d8\u0011\u0002\u0003\u00071/\u0001\u0005oK^dUM^3m!\t!x/D\u0001v\u0015\t1h!A\u0004ti>\u0014\u0018mZ3\n\u0005a,(\u0001D*u_J\fw-\u001a'fm\u0016d\u0007\"\u0002>\u0001\t\u0003Z\u0018!B2bG\",G#A\b\t\u000bu\u0004A\u0011\t@\u0002\u0015\rDWmY6q_&tG\u000fF\u0001\u0000!\rI\u0012\u0011A\u0005\u0004\u0003\u0007Q\"\u0001B+oSRDq!a\u0002\u0001\t\u0003\nI!\u0001\bjg\u000eCWmY6q_&tG/\u001a3\u0016\u0005\u0005-\u0001cA\r\u0002\u000e%\u0019\u0011q\u0002\u000e\u0003\u000f\t{w\u000e\\3b]\"9\u00111\u0003\u0001\u0005B\u0005U\u0011AE4fi\u000eCWmY6q_&tGOR5mKN,\"!a\u0006\u0011\r\u0005e\u0011\u0011FA\u0018\u001d\u0011\tY\"!\n\u000f\t\u0005u\u00111E\u0007\u0003\u0003?Q1!!\t\r\u0003\u0019a$o\\8u}%\t1$C\u0002\u0002(i\tq\u0001]1dW\u0006<W-\u0003\u0003\u0002,\u00055\"aA*fc*\u0019\u0011q\u0005\u000e\u0011\t\u0005E\u0012\u0011\b\b\u0005\u0003g\t)\u0004E\u0002\u0002\u001eiI1!a\u000e\u001b\u0003\u0019\u0001&/\u001a3fM&!\u00111HA\u001f\u0005\u0019\u0019FO]5oO*\u0019\u0011q\u0007\u000e\t\u000f\u0005\u0005\u0003\u0001\"\u0011\u0002D\u0005IQO\u001c9feNL7\u000f\u001e\u000b\u0004\u001f\u0005\u0015\u0003BCA$\u0003\u007f\u0001\n\u00111\u0001\u0002\f\u0005A!\r\\8dW&tw\rC\u0004\u0002L\u0001!\t%!\u0014\u0002#Ut\u0007/\u001a:tSN$h+\u001a:uS\u000e,7\u000fF\u0002\u0010\u0003\u001fB!\"a\u0012\u0002JA\u0005\t\u0019AA\u0006\u0011\u001d\t\u0019\u0006\u0001C!\u0003+\n1\u0002]1si&$\u0018n\u001c8CsR\u0019q\"a\u0016\t\u0011\u0005e\u0013\u0011\u000ba\u0001\u00037\n\u0011\u0003]1si&$\u0018n\u001c8TiJ\fG/Z4z!\r\u0001\u0012QL\u0005\u0004\u0003?\"!!\u0005)beRLG/[8o'R\u0014\u0018\r^3hs\"9\u00111\u000b\u0001\u0005B\u0005\rD#B\b\u0002f\u0005\u001d\u0004\u0002CA-\u0003C\u0002\r!a\u0017\t\u0011\u0005%\u0014\u0011\ra\u0001\u0003W\nQB\\;n!\u0006\u0014H/\u001b;j_:\u001c\bcA\r\u0002n%\u0019\u0011q\u000e\u000e\u0003\u0007%sG\u000fC\u0004\u0002t\u0001!\t%!\u001e\u0002\u000fI,g/\u001a:tKV\tq\u0002C\u0004\u0002z\u0001!\t%a\u001f\u0002\u00175\f\u0007OV3si&\u001cWm]\u000b\u0005\u0003{\n)\t\u0006\u0003\u0002\u0000\u0005eECBAA\u0003\u0013\u000by\tE\u0003\u0011#\u0005\r\u0015\u0005E\u0002\u0015\u0003\u000b#q!a\"\u0002x\t\u0007qCA\u0002W\tJB!\"a#\u0002x\u0005\u0005\t9AAG\u0003))g/\u001b3f]\u000e,G%\u000e\t\u0005\u0001\u000e\u000b\u0019\t\u0003\u0006\u0002\u0012\u0006]\u0004\u0013!a\u0002\u0003'\u000b!!Z9\u0011\u000f\u0005E\u0012QS\n\u0002\u0004&!\u0011qSA\u001f\u00051!S-\u001d\u0013d_2|g\u000eJ3r\u0011!\tY*a\u001eA\u0002\u0005u\u0015!\u00014\u0011\u0011e\ty*a)\u0014\u0003\u0007K1!!)\u001b\u0005%1UO\\2uS>t'\u0007\u0005\u0003\u0002&\u0006ef\u0002BAT\u0003osA!!+\u00026:!\u00111VAZ\u001d\u0011\ti+!-\u000f\t\u0005u\u0011qV\u0005\u0002\u0017%\u0011\u0011BC\u0005\u0003\u000f!I!!\u0002\u0004\n\u0007\u0005\u001dB!\u0003\u0003\u0002<\u0006u&\u0001\u0003,feR,\u00070\u00133\u000b\u0007\u0005\u001dB\u0001C\u0004\u0002B\u0002!\t%a1\u0002\u00115\f\u0007/\u00123hKN,B!!2\u0002NR!\u0011qYAl)\u0011\tI-!5\u0011\u000bA\t2#a3\u0011\u0007Q\ti\rB\u0004\u0002P\u0006}&\u0019A\f\u0003\u0007\u0015#%\u0007\u0003\u0006\u0002T\u0006}\u0016\u0011!a\u0002\u0003+\f!\"\u001a<jI\u0016t7-\u001a\u00137!\u0011\u00015)a3\t\u0011\u0005m\u0015q\u0018a\u0001\u00033\u0004\u0012\"GAP\u00037\f\t/!<\u0011\t\u0005\u0015\u0016Q\\\u0005\u0005\u0003?\fiLA\u0006QCJ$\u0018\u000e^5p]&#\u0005CBA\r\u0003G\f9/\u0003\u0003\u0002f\u00065\"\u0001C%uKJ\fGo\u001c:\u0011\tA\tI/I\u0005\u0004\u0003W$!\u0001B#eO\u0016\u0004b!!\u0007\u0002d\u0006-\u0007bBAy\u0001\u0011\u0005\u00131_\u0001\f[\u0006\u0004HK]5qY\u0016$8/\u0006\u0003\u0002v\u0006uHCBA|\u0005\u000b\u0011i\u0001\u0006\u0003\u0002z\u0006}\b#\u0002\t\u0012'\u0005m\bc\u0001\u000b\u0002~\u00129\u0011qZAx\u0005\u00049\u0002B\u0003B\u0001\u0003_\f\t\u0011q\u0001\u0003\u0004\u0005QQM^5eK:\u001cW\rJ\u001c\u0011\t\u0001\u001b\u00151 \u0005\t\u00037\u000by\u000f1\u0001\u0003\bAI\u0011$a(\u0002\\\n%!1\u0002\t\u0006\u00033\t\u0019O\u001b\t\u0007\u00033\t\u0019/a?\t\u0011\t=\u0011q\u001ea\u0001\u0005#\tQ\u0002\u001e:ja2,GOR5fY\u0012\u001c\bc\u0001\t\u0003\u0014%\u0019!Q\u0003\u0003\u0003\u001bQ\u0013\u0018\u000e\u001d7fi\u001aKW\r\u001c3t\u0011\u001d\u0011I\u0002\u0001C!\u00057\t\u0001b];cOJ\f\u0007\u000f\u001b\u000b\u0006\u001f\tu!q\u0005\u0005\u000b\u0005?\u00119\u0002%AA\u0002\t\u0005\u0012!B3qe\u0016$\u0007CB\r\u0003$)\fY!C\u0002\u0003&i\u0011\u0011BR;oGRLwN\\\u0019\t\u0015\t%\"q\u0003I\u0001\u0002\u0004\u0011Y#A\u0003waJ,G\r\u0005\u0005\u001a\u0003?\u000b\u0019kEA\u0006\u0011\u001d\u0011y\u0003\u0001C!\u0005c\tA!\\1tWV1!1\u0007B \u0005\u0013\"BA!\u000e\u0003LQ)qBa\u000e\u0003B!Q!\u0011\bB\u0017\u0003\u0003\u0005\u001dAa\u000f\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$\u0003\b\u0005\u0003A\u0007\nu\u0002c\u0001\u000b\u0003@\u00119\u0011q\u0011B\u0017\u0005\u00049\u0002B\u0003B\"\u0005[\t\t\u0011q\u0001\u0003F\u0005QQM^5eK:\u001cW\rJ\u001d\u0011\t\u0001\u001b%q\t\t\u0004)\t%CaBAh\u0005[\u0011\ra\u0006\u0005\t\u0005\u001b\u0012i\u00031\u0001\u0003P\u0005)q\u000e\u001e5feB1\u0001#\u0005B\u001f\u0005\u000fBqAa\u0015\u0001\t\u0003\u0012)&\u0001\u0006he>,\b/\u00123hKN$2a\u0004B,\u0011!\u0011IF!\u0015A\u0002\tm\u0013!B7fe\u001e,\u0007CB\r\u0002 \u0006\n\u0013\u0005C\u0004\u0003`\u0001!\tE!\u0019\u0002=\u0005<wM]3hCR,W*Z:tC\u001e,7oV5uQ\u0006\u001bG/\u001b<f'\u0016$X\u0003\u0002B2\u0005W\"\"B!\u001a\u0003v\t\u0005%q\u0011BE)\u0011\u00119Ga\u001c\u0011\tAY#\u0011\u000e\t\u0004)\t-Da\u0002B7\u0005;\u0012\ra\u0006\u0002\u0002\u0003\"Q!\u0011\u000fB/\u0003\u0003\u0005\u001dAa\u001d\u0002\u0017\u00154\u0018\u000eZ3oG\u0016$\u0013\u0007\r\t\u0005\u0001\u000e\u0013I\u0007\u0003\u0005\u0003x\tu\u0003\u0019\u0001B=\u0003\u001d\u0019XM\u001c3Ng\u001e\u0004b!\u0007B\u0012\u0005wz\bc\u0002\t\u0003~M\t#\u0011N\u0005\u0004\u0005\u007f\"!aC#eO\u0016\u001cuN\u001c;fqRD\u0001Ba!\u0003^\u0001\u0007!QQ\u0001\t[\u0016\u0014x-Z'tOBI\u0011$a(\u0003j\t%$\u0011\u000e\u0005\t\u0005\u001f\u0011i\u00061\u0001\u0003\u0012!A!1\u0012B/\u0001\u0004\u0011i)\u0001\u0007bGRLg/Z*fi>\u0003H\u000fE\u0003\u001a\u0005\u001f\u0013\u0019*C\u0002\u0003\u0012j\u0011aa\u00149uS>t\u0007cB\r\u0003\u0016\ne%QU\u0005\u0004\u0005/S\"A\u0002+va2,'\u0007\r\u0003\u0003\u001c\n}\u0005\u0003\u0002\t,\u0005;\u00032\u0001\u0006BP\t-\u0011\tKa)\u0002\u0002\u0003\u0005)\u0011A\f\u0003\u0007}#\u0013\u0007\u0003\u0005\u0003\f\nu\u0003\u0019\u0001BG!\r\u0001\"qU\u0005\u0004\u0005S#!!D#eO\u0016$\u0015N]3di&|g\u000eC\u0004\u0003.\u0002!\tEa,\u0002#=,H/\u001a:K_&tg+\u001a:uS\u000e,7/\u0006\u0004\u00032\n\u0015'1\u0018\u000b\u0005\u0005g\u0013y\u000e\u0006\u0003\u00036\nMG\u0003\u0003B\\\u0005{\u0013IMa4\u0011\u000bA\t\"\u0011X\u0011\u0011\u0007Q\u0011Y\fB\u0004\u0002\b\n-&\u0019A\f\t\u0015\t}&1VA\u0001\u0002\b\u0011\t-A\u0006fm&$WM\\2fIE\n\u0004\u0003\u0002!D\u0005\u0007\u00042\u0001\u0006Bc\t\u001d\u00119Ma+C\u0002]\u0011\u0011!\u0016\u0005\u000b\u0005\u0017\u0014Y+!AA\u0004\t5\u0017aC3wS\u0012,gnY3%cI\u0002B\u0001Q\"\u0003:\"Q\u0011\u0011\u0013BV!\u0003\u0005\u001dA!5\u0011\u000f\u0005E\u0012QS\n\u0003:\"A!Q\u001bBV\u0001\u0004\u00119.A\u0004va\u0012\fG/\u001a$\u0011\u0015e\u0011I.a)\u0014\u0005;\u0014I,C\u0002\u0003\\j\u0011\u0011BR;oGRLwN\\\u001a\u0011\u000be\u0011yIa1\t\u0011\t5#1\u0016a\u0001\u0005C\u0004B!\u001a5\u0003dB9\u0011D!&\u0002$\n\r\u0007b\u0002Bt\u0001\u0011%!\u0011^\u0001\u0013C\u000e\u001cWm]:fgZ+'\u000f^3y\u0003R$(\u000f\u0006\u0004\u0002\f\t-(Q\u001f\u0005\t\u0005[\u0014)\u000f1\u0001\u0003p\u000691\r\\8tkJ,\u0007cA\r\u0003r&\u0019!1\u001f\u000e\u0003\r\u0005s\u0017PU3g\u0011!\u00119P!:A\u0002\u0005=\u0012\u0001C1uiJt\u0015-\\3\t\u0013\tm\b!%A\u0005B\tu\u0018aE;oa\u0016\u00148/[:uI\u0011,g-Y;mi\u0012\nTC\u0001B\u0000U\u0011\tYa!\u0001,\u0005\r\r\u0001\u0003BB\u0003\u0007\u001fi!aa\u0002\u000b\t\r%11B\u0001\nk:\u001c\u0007.Z2lK\u0012T1a!\u0004\u001b\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0007#\u00199AA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016D\u0011b!\u0006\u0001#\u0003%\tE!@\u00027Ut\u0007/\u001a:tSN$h+\u001a:uS\u000e,7\u000f\n3fM\u0006,H\u000e\u001e\u00132\u0011%\u0019I\u0002AI\u0001\n\u0003\u001aY\"A\u000bnCB4VM\u001d;jG\u0016\u001cH\u0005Z3gCVdG\u000fJ\u001a\u0016\t\ru1Q\u0006\u000b\u0005\u0007?\u00199C\u000b\u0003\u0004\"\r\u0005\u0001cA\r\u0004$%\u00191Q\u0005\u000e\u0003\t9+H\u000e\u001c\u0005\t\u00037\u001b9\u00021\u0001\u0004*AA\u0011$a(\u0002$N\u0019Y\u0003E\u0002\u0015\u0007[!q!a\"\u0004\u0018\t\u0007q\u0003C\u0005\u00042\u0001\t\n\u0011\"\u0011\u00044\u0005\u00112/\u001e2he\u0006\u0004\b\u000e\n3fM\u0006,H\u000e\u001e\u00132+\t\u0019)D\u000b\u0003\u0003\"\r\u0005\u0001\"CB\u001d\u0001E\u0005I\u0011IB\u001e\u0003I\u0019XOY4sCBDG\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\ru\"\u0006\u0002B\u0016\u0007\u0003A\u0011b!\u0011\u0001#\u0003%\tea\u0011\u00027=,H/\u001a:K_&tg+\u001a:uS\u000e,7\u000f\n3fM\u0006,H\u000e\u001e\u00136+\u0019\u0019)e!\u0015\u0004VQ!1qIB,)\u0011\u0019yb!\u0013\t\u0011\tU7q\ba\u0001\u0007\u0017\u0002\"\"\u0007Bm\u0003G\u001b2QJB*!\u0015I\"qRB(!\r!2\u0011\u000b\u0003\b\u0005\u000f\u001cyD1\u0001\u0018!\r!2Q\u000b\u0003\b\u0003\u000f\u001byD1\u0001\u0018\u0011!\u0011iea\u0010A\u0002\re\u0003\u0003B3i\u00077\u0002r!\u0007BK\u0003G\u001byeB\u0004\u0004`\tA\ta!\u0019\u0002\u0013\u001d\u0013\u0018\r\u001d5J[Bd\u0007cA\u001c\u0004d\u00191\u0011A\u0001E\u0001\u0007K\u001aRaa\u0019\u0003p\u0012Bq!SB2\t\u0003\u0019I\u0007\u0006\u0002\u0004b!A1QNB2\t\u0003\u0019y'A\u0003baBd\u00170\u0006\u0004\u0004r\re4Q\u0010\u000b\u000b\u0007g\u001aYi!%\u0004\u0016\u000eeECBB;\u0007\u007f\u001a)\t\u0005\u00048\u0001\r]41\u0010\t\u0004)\reDA\u0002\f\u0004l\t\u0007q\u0003E\u0002\u0015\u0007{\"aaIB6\u0005\u00049\u0002BCBA\u0007W\n\t\u0011q\u0001\u0004\u0004\u0006YQM^5eK:\u001cW\rJ\u00194!\u0011\u00015ia\u001e\t\u0015\r\u001d51NA\u0001\u0002\b\u0019I)A\u0006fm&$WM\\2fIE\"\u0004\u0003\u0002!D\u0007wBq!WB6\u0001\u0004\u0019i\t\u0005\u0003fQ\u000e=\u0005#\u0002\t\u0002j\u000em\u0004\u0002CBJ\u0007W\u0002\raa\u001e\u0002#\u0011,g-Y;miZ+'\u000f^3y\u0003R$(\u000fC\u0004\u0004\u0018\u000e-\u0004\u0019A:\u0002!\u0015$w-Z*u_J\fw-\u001a'fm\u0016d\u0007bBBN\u0007W\u0002\ra]\u0001\u0013m\u0016\u0014H/\u001a=Ti>\u0014\u0018mZ3MKZ,G\u000e\u0003\u0005\u0004 \u000e\rD\u0011ABQ\u0003I1'o\\7FI\u001e,\u0007+\u0019:uSRLwN\\:\u0016\r\r\r61VBX))\u0019)k!0\u0004L\u000e57q\u001a\u000b\u0007\u0007O\u001b\tla.\u0011\r]\u00021\u0011VBW!\r!21\u0016\u0003\u0007-\ru%\u0019A\f\u0011\u0007Q\u0019y\u000b\u0002\u0004$\u0007;\u0013\ra\u0006\u0005\u000b\u0007g\u001bi*!AA\u0004\rU\u0016aC3wS\u0012,gnY3%cU\u0002B\u0001Q\"\u0004*\"Q1\u0011XBO\u0003\u0003\u0005\u001daa/\u0002\u0017\u00154\u0018\u000eZ3oG\u0016$\u0013G\u000e\t\u0005\u0001\u000e\u001bi\u000b\u0003\u0005\u0004@\u000eu\u0005\u0019ABa\u00039)GmZ3QCJ$\u0018\u000e^5p]N\u0004B!\u001a5\u0004DB9\u0011D!&\u0002\\\u000e\u0015\u0007cB\u001c\u0004H\u000e56\u0011V\u0005\u0004\u0007\u0013\u0014!!D#eO\u0016\u0004\u0016M\u001d;ji&|g\u000e\u0003\u0005\u0004\u0014\u000eu\u0005\u0019ABU\u0011\u001d\u00199j!(A\u0002MDqaa'\u0004\u001e\u0002\u00071\u000f\u0003\u0005\u0004n\r\rD\u0011ABj+\u0019\u0019)n!8\u0004bRa1q[Bx\u0007k\u001cYp!@\u0004\u0000R11\u0011\\Br\u0007S\u0004ba\u000e\u0001\u0004\\\u000e}\u0007c\u0001\u000b\u0004^\u00121ac!5C\u0002]\u00012\u0001FBq\t\u0019\u00193\u0011\u001bb\u0001/!Q1Q]Bi\u0003\u0003\u0005\u001daa:\u0002\u0017\u00154\u0018\u000eZ3oG\u0016$\u0013g\u000e\t\u0005\u0001\u000e\u001bY\u000e\u0003\u0006\u0004l\u000eE\u0017\u0011!a\u0002\u0007[\f1\"\u001a<jI\u0016t7-\u001a\u00132qA!\u0001iQBp\u0011\u001dA3\u0011\u001ba\u0001\u0007c\u0004B!\u001a5\u0004tB9\u0011D!&\u0002$\u000em\u0007bB-\u0004R\u0002\u00071q\u001f\t\u0005K\"\u001cI\u0010E\u0003\u0011\u0003S\u001cy\u000e\u0003\u0005\u0004\u0014\u000eE\u0007\u0019ABn\u0011\u001d\u00199j!5A\u0002MDqaa'\u0004R\u0002\u00071\u000f\u0003\u0005\u0004n\r\rD\u0011\u0001C\u0002+\u0019!)\u0001\"\u0004\u0005\u0012Q1Aq\u0001C\u0010\tG!b\u0001\"\u0003\u0005\u0014\u0011e\u0001CB\u001c\u0001\t\u0017!y\u0001E\u0002\u0015\t\u001b!aA\u0006C\u0001\u0005\u00049\u0002c\u0001\u000b\u0005\u0012\u001111\u0005\"\u0001C\u0002]A!\u0002\"\u0006\u0005\u0002\u0005\u0005\t9\u0001C\f\u0003-)g/\u001b3f]\u000e,G%M\u001d\u0011\t\u0001\u001bE1\u0002\u0005\u000b\t7!\t!!AA\u0004\u0011u\u0011aC3wS\u0012,gnY3%eA\u0002B\u0001Q\"\u0005\u0010!9\u0001\u0006\"\u0001A\u0002\u0011\u0005\u0002\u0003\u0002\t,\t\u0017Aq!\u0017C\u0001\u0001\u0004!)\u0003E\u0003\u0011\tO!y!C\u0002\u0005*\u0011\u0011q!\u00123hKJ#E\t\u0003\u0005\u0005.\r\rD\u0011\u0001C\u0018\u0003A1'o\\7Fq&\u001cH/\u001b8h%\u0012#5/\u0006\u0004\u00052\u0011eBQ\b\u000b\u0007\tg!Y\u0005b\u0014\u0015\r\u0011UBq\bC#!\u00199\u0004\u0001b\u000e\u0005<A\u0019A\u0003\"\u000f\u0005\rY!YC1\u0001\u0018!\r!BQ\b\u0003\u0007G\u0011-\"\u0019A\f\t\u0015\u0011\u0005C1FA\u0001\u0002\b!\u0019%A\u0006fm&$WM\\2fII\n\u0004\u0003\u0002!D\toA!\u0002b\u0012\u0005,\u0005\u0005\t9\u0001C%\u0003-)g/\u001b3f]\u000e,GE\r\u001a\u0011\t\u0001\u001bE1\b\u0005\bQ\u0011-\u0002\u0019\u0001C'!\u0011\u00012\u0006b\u000e\t\u000fe#Y\u00031\u0001\u0005RA)\u0001\u0003b\n\u0005<!AAQKB2\t\u0013!9&A\u0006ge>lW\tZ4f%\u0012#UC\u0002C-\tC\")\u0007\u0006\u0006\u0005\\\u0011MDq\u000fC=\tw\"b\u0001\"\u0018\u0005h\u00115\u0004CB\u001c\u0001\t?\"\u0019\u0007E\u0002\u0015\tC\"aA\u0006C*\u0005\u00049\u0002c\u0001\u000b\u0005f\u001111\u0005b\u0015C\u0002]A!\u0002\"\u001b\u0005T\u0005\u0005\t9\u0001C6\u0003-)g/\u001b3f]\u000e,GEM\u001a\u0011\t\u0001\u001bEq\f\u0005\u000b\t_\"\u0019&!AA\u0004\u0011E\u0014aC3wS\u0012,gnY3%eQ\u0002B\u0001Q\"\u0005d!9\u0011\fb\u0015A\u0002\u0011U\u0004CB\u001c]\tG\"y\u0006\u0003\u0005\u0004\u0014\u0012M\u0003\u0019\u0001C0\u0011\u001d\u00199\nb\u0015A\u0002MDqaa'\u0005T\u0001\u00071\u000f\u0003\u0006\u0005\u0000\r\r\u0014\u0011!C\u0005\t\u0003\u000b1B]3bIJ+7o\u001c7wKR\u0011A1\u0011\t\u0005\t\u000b#y)\u0004\u0002\u0005\b*!A\u0011\u0012CF\u0003\u0011a\u0017M\\4\u000b\u0005\u00115\u0015\u0001\u00026bm\u0006LA\u0001\"%\u0005\b\n1qJ\u00196fGR\u0004")
public class GraphImpl<VD, ED>
extends Graph<VD, ED> {
    private transient RDD<EdgeTriplet<VD, ED>> triplets;
    private final transient VertexRDD<VD> vertices;
    private final transient ReplicatedVertexView<VD, ED> replicatedVertexView;
    private final ClassTag<VD> evidence$1;
    private final ClassTag<ED> evidence$2;
    private final transient EdgeRDDImpl<ED, VD> edges;
    private volatile transient boolean bitmap$trans$0;

    public static <VD, ED> GraphImpl<VD, ED> fromExistingRDDs(VertexRDD<VD> vertexRDD, EdgeRDD<ED> edgeRDD, ClassTag<VD> classTag, ClassTag<ED> classTag2) {
        return GraphImpl$.MODULE$.fromExistingRDDs(vertexRDD, edgeRDD, classTag, classTag2);
    }

    public static <VD, ED> GraphImpl<VD, ED> apply(VertexRDD<VD> vertexRDD, EdgeRDD<ED> edgeRDD, ClassTag<VD> classTag, ClassTag<ED> classTag2) {
        return GraphImpl$.MODULE$.apply(vertexRDD, edgeRDD, classTag, classTag2);
    }

    public static <VD, ED> GraphImpl<VD, ED> apply(RDD<Tuple2<Object, VD>> rDD, RDD<Edge<ED>> rDD2, VD VD, StorageLevel storageLevel, StorageLevel storageLevel2, ClassTag<VD> classTag, ClassTag<ED> classTag2) {
        return GraphImpl$.MODULE$.apply(rDD, rDD2, VD, storageLevel, storageLevel2, classTag, classTag2);
    }

    public static <VD, ED> GraphImpl<VD, ED> fromEdgePartitions(RDD<Tuple2<Object, EdgePartition<ED, VD>>> rDD, VD VD, StorageLevel storageLevel, StorageLevel storageLevel2, ClassTag<VD> classTag, ClassTag<ED> classTag2) {
        return GraphImpl$.MODULE$.fromEdgePartitions(rDD, VD, storageLevel, storageLevel2, classTag, classTag2);
    }

    public static <VD, ED> GraphImpl<VD, ED> apply(RDD<Edge<ED>> rDD, VD VD, StorageLevel storageLevel, StorageLevel storageLevel2, ClassTag<VD> classTag, ClassTag<ED> classTag2) {
        return GraphImpl$.MODULE$.apply(rDD, VD, storageLevel, storageLevel2, classTag, classTag2);
    }

    @Override
    public VertexRDD<VD> vertices() {
        return this.vertices;
    }

    public ReplicatedVertexView<VD, ED> replicatedVertexView() {
        return this.replicatedVertexView;
    }

    public EdgeRDDImpl<ED, VD> edges() {
        return this.edges;
    }

    private RDD<EdgeTriplet<VD, ED>> triplets$lzycompute() {
        GraphImpl graphImpl = this;
        synchronized (graphImpl) {
            if (!this.bitmap$trans$0) {
                this.replicatedVertexView().upgrade(this.vertices(), true, true);
                RDD<Tuple2<Object, EdgePartition<ED, VD>>> qual$1 = this.replicatedVertexView().edges().partitionsRDD();
                Function1 & Serializable & scala.Serializable x$7 = (Function1 & Serializable & scala.Serializable)x$1 -> x$1.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    EdgePartition part = (EdgePartition)tuple2._2();
                    Iterator iterator = part.tripletIterator(part.tripletIterator$default$1(), part.tripletIterator$default$2());
                    return iterator;
                });
                boolean x$8 = qual$1.mapPartitions$default$2();
                this.triplets = qual$1.mapPartitions((Function1)x$7, x$8, ClassTag$.MODULE$.apply(EdgeTriplet.class));
                this.bitmap$trans$0 = true;
            }
        }
        return this.triplets;
    }

    @Override
    public RDD<EdgeTriplet<VD, ED>> triplets() {
        return !this.bitmap$trans$0 ? this.triplets$lzycompute() : this.triplets;
    }

    @Override
    public Graph<VD, ED> persist(StorageLevel newLevel) {
        this.vertices().persist(newLevel);
        this.replicatedVertexView().edges().persist(newLevel);
        return this;
    }

    @Override
    public Graph<VD, ED> cache() {
        this.vertices().cache();
        this.replicatedVertexView().edges().cache();
        return this;
    }

    @Override
    public void checkpoint() {
        this.vertices().checkpoint();
        this.replicatedVertexView().edges().checkpoint();
    }

    @Override
    public boolean isCheckpointed() {
        return this.vertices().isCheckpointed() && this.replicatedVertexView().edges().isCheckpointed();
    }

    @Override
    public Seq<String> getCheckpointFiles() {
        return (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Option[]{this.vertices().getCheckpointFile(), this.replicatedVertexView().edges().getCheckpointFile()}))).flatMap((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Seq seq;
            Option option = x0$2;
            if (option instanceof Some) {
                Some some = (Some)option;
                String path = (String)some.value();
                seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{path}));
            } else if (None$.MODULE$.equals(option)) {
                seq = (Seq)Seq$.MODULE$.empty();
            } else {
                throw new MatchError((Object)option);
            }
            return seq;
        }, Seq$.MODULE$.canBuildFrom());
    }

    @Override
    public Graph<VD, ED> unpersist(boolean blocking) {
        this.unpersistVertices(blocking);
        this.replicatedVertexView().edges().unpersist(blocking);
        return this;
    }

    @Override
    public boolean unpersist$default$1() {
        return true;
    }

    @Override
    public Graph<VD, ED> unpersistVertices(boolean blocking) {
        this.vertices().unpersist(blocking);
        return this;
    }

    @Override
    public boolean unpersistVertices$default$1() {
        return true;
    }

    @Override
    public Graph<VD, ED> partitionBy(PartitionStrategy partitionStrategy) {
        return this.partitionBy(partitionStrategy, this.edges().partitions().length);
    }

    @Override
    public Graph<VD, ED> partitionBy(PartitionStrategy partitionStrategy, int numPartitions) {
        ClassTag edTag = scala.reflect.package$.MODULE$.classTag(this.evidence$2);
        ClassTag vdTag = scala.reflect.package$.MODULE$.classTag(this.evidence$1);
        RDD newEdges = ((EdgeRDDImpl)this.edges()).withPartitionsRDD(RDD$.MODULE$.rddToPairRDDFunctions(this.edges().map((Function1 & Serializable & scala.Serializable)e -> {
            int part = partitionStrategy.getPartition(e.srcId(), e.dstId(), numPartitions);
            return new Tuple2((Object)BoxesRunTime.boxToInteger((int)part), (Object)new Tuple3((Object)BoxesRunTime.boxToLong((long)e.srcId()), (Object)BoxesRunTime.boxToLong((long)e.dstId()), e.attr()));
        }, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(Integer.TYPE), ClassTag$.MODULE$.apply(Tuple3.class), (Ordering)Ordering.Int$.MODULE$).partitionBy((Partitioner)new HashPartitioner(numPartitions)).mapPartitionsWithIndex((Function2 & Serializable & scala.Serializable)(pid, iter) -> GraphImpl.$anonfun$partitionBy$2(edTag, vdTag, BoxesRunTime.unboxToInt((Object)pid), iter), true, ClassTag$.MODULE$.apply(Tuple2.class)), this.evidence$2, this.evidence$1).cache();
        return GraphImpl$.MODULE$.fromExistingRDDs(this.vertices().withEdges((EdgeRDD<?>)newEdges), newEdges, this.evidence$1, this.evidence$2);
    }

    @Override
    public Graph<VD, ED> reverse() {
        return new GraphImpl<VD, ED>(this.vertices().reverseRoutingTables(), this.replicatedVertexView().reverse(), this.evidence$1, this.evidence$2);
    }

    @Override
    public <VD2> Graph<VD2, ED> mapVertices(Function2<Object, VD, VD2> f, ClassTag<VD2> evidence$5, Predef$.eq.colon.eq<VD, VD2> eq2) {
        GraphImpl<VD, ED> graphImpl;
        if (eq2 != null) {
            this.vertices().cache();
            VertexRDD newVerts = (VertexRDD)this.vertices().mapVertexPartitions((Function1 & Serializable & scala.Serializable)x$2 -> (ShippableVertexPartition)ShippableVertexPartition$.MODULE$.shippablePartitionToOps(x$2, $this.evidence$1).map(f, evidence$5), evidence$5).cache();
            VertexRDD<VD> changedVerts = this.vertices().diff(newVerts);
            ReplicatedVertexView<VD, ED> newReplicatedVertexView = this.replicatedVertexView().updateVertices(changedVerts);
            graphImpl = new GraphImpl<VD, ED>(newVerts, newReplicatedVertexView, evidence$5, this.evidence$2);
        } else {
            graphImpl = GraphImpl$.MODULE$.apply(this.vertices().mapVertexPartitions((Function1 & Serializable & scala.Serializable)x$3 -> (ShippableVertexPartition)ShippableVertexPartition$.MODULE$.shippablePartitionToOps(x$3, $this.evidence$1).map(f, evidence$5), evidence$5), this.replicatedVertexView().edges(), evidence$5, this.evidence$2);
        }
        return graphImpl;
    }

    @Override
    public <VD2> Null$ mapVertices$default$3(Function2<Object, VD, VD2> f) {
        return null;
    }

    @Override
    public <ED2> Graph<VD, ED2> mapEdges(Function2<Object, Iterator<Edge<ED>>, Iterator<ED2>> f, ClassTag<ED2> evidence$6) {
        EdgeRDDImpl<ED2, VD> newEdges = this.replicatedVertexView().edges().mapEdgePartitions((Function2 & Serializable & scala.Serializable)(pid, part) -> part.map((Iterator)f.apply((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)pid)), part.iterator()), evidence$6), evidence$6, this.evidence$1);
        return new GraphImpl<VD, ED2>(this.vertices(), this.replicatedVertexView().withEdges(newEdges, this.evidence$1, evidence$6), this.evidence$1, evidence$6);
    }

    @Override
    public <ED2> Graph<VD, ED2> mapTriplets(Function2<Object, Iterator<EdgeTriplet<VD, ED>>, Iterator<ED2>> f, TripletFields tripletFields, ClassTag<ED2> evidence$7) {
        this.vertices().cache();
        this.replicatedVertexView().upgrade(this.vertices(), tripletFields.useSrc, tripletFields.useDst);
        EdgeRDDImpl<ED2, VD> newEdges = this.replicatedVertexView().edges().mapEdgePartitions((Function2 & Serializable & scala.Serializable)(pid, part) -> part.map((Iterator)f.apply((Object)BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToInt((Object)pid)), part.tripletIterator(tripletFields.useSrc, tripletFields.useDst)), evidence$7), evidence$7, this.evidence$1);
        return new GraphImpl<VD, ED2>(this.vertices(), this.replicatedVertexView().withEdges(newEdges, this.evidence$1, evidence$7), this.evidence$1, evidence$7);
    }

    @Override
    public Graph<VD, ED> subgraph(Function1<EdgeTriplet<VD, ED>, Object> epred, Function2<Object, VD, Object> vpred) {
        this.vertices().cache();
        VertexRDD<VD> newVerts = this.vertices().mapVertexPartitions((Function1 & Serializable & scala.Serializable)x$4 -> (ShippableVertexPartition)ShippableVertexPartition$.MODULE$.shippablePartitionToOps(x$4, $this.evidence$1).filter(vpred), this.evidence$1);
        this.replicatedVertexView().upgrade(this.vertices(), true, true);
        EdgeRDDImpl<ED, VD> newEdges = this.replicatedVertexView().edges().filter(epred, vpred);
        return new GraphImpl<VD, ED>(newVerts, this.replicatedVertexView().withEdges(newEdges, this.evidence$1, this.evidence$2), this.evidence$1, this.evidence$2);
    }

    @Override
    public Function1<EdgeTriplet<VD, ED>, Object> subgraph$default$1() {
        return (Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)GraphImpl.$anonfun$subgraph$default$1$1(x));
    }

    @Override
    public Function2<Object, VD, Object> subgraph$default$2() {
        return (Function2 & Serializable & scala.Serializable)(a, b) -> BoxesRunTime.boxToBoolean((boolean)GraphImpl.$anonfun$subgraph$default$2$1(BoxesRunTime.unboxToLong((Object)a), b));
    }

    @Override
    public <VD2, ED2> Graph<VD, ED> mask(Graph<VD2, ED2> other, ClassTag<VD2> evidence$8, ClassTag<ED2> evidence$9) {
        VertexRDD<VD> newVerts = this.vertices().innerJoin(other.vertices(), (Function3 & Serializable & scala.Serializable)(vid, v, w) -> v, evidence$8, this.evidence$1);
        EdgeRDD newEdges = this.replicatedVertexView().edges().innerJoin((EdgeRDD)other.edges(), (Function4 & Serializable & scala.Serializable)(src, dst, v, w) -> v, (ClassTag)evidence$9, (ClassTag)this.evidence$2);
        return new GraphImpl<VD, ED>(newVerts, this.replicatedVertexView().withEdges(newEdges, this.evidence$1, this.evidence$2), this.evidence$1, this.evidence$2);
    }

    @Override
    public Graph<VD, ED> groupEdges(Function2<ED, ED, ED> merge) {
        EdgeRDDImpl<ED, VD> newEdges = this.replicatedVertexView().edges().mapEdgePartitions((Function2 & Serializable & scala.Serializable)(pid, part) -> part.groupEdges(merge), this.evidence$2, this.evidence$1);
        return new GraphImpl<VD, ED>(this.vertices(), this.replicatedVertexView().withEdges(newEdges, this.evidence$1, this.evidence$2), this.evidence$1, this.evidence$2);
    }

    @Override
    public <A> VertexRDD<A> aggregateMessagesWithActiveSet(Function1<EdgeContext<VD, ED, A>, BoxedUnit> sendMsg, Function2<A, A, A> mergeMsg, TripletFields tripletFields, Option<Tuple2<VertexRDD<?>, EdgeDirection>> activeSetOpt, ClassTag<A> evidence$10) {
        ReplicatedVertexView<VD, ED> replicatedVertexView;
        Some some;
        Tuple2 tuple2;
        this.vertices().cache();
        this.replicatedVertexView().upgrade(this.vertices(), tripletFields.useSrc, tripletFields.useDst);
        Option<Tuple2<VertexRDD<?>, EdgeDirection>> option = activeSetOpt;
        if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
            VertexRDD activeSet = (VertexRDD)((Object)tuple2._1());
            replicatedVertexView = this.replicatedVertexView().withActiveSet(activeSet);
        } else if (None$.MODULE$.equals(option)) {
            replicatedVertexView = this.replicatedVertexView();
        } else {
            throw new MatchError(option);
        }
        ReplicatedVertexView<VD, ED> view = replicatedVertexView;
        Option activeDirectionOpt = activeSetOpt.map((Function1 & Serializable & scala.Serializable)x$5 -> (EdgeDirection)x$5._2());
        RDD<Tuple2<Object, EdgePartition<ED, VD>>> qual$2 = view.edges().partitionsRDD();
        Function1 & Serializable & scala.Serializable x$9 = (Function1 & Serializable & scala.Serializable)x$6 -> x$6.flatMap(arg_0 -> GraphImpl.$anonfun$aggregateMessagesWithActiveSet$3(sendMsg, mergeMsg, tripletFields, evidence$10, activeDirectionOpt, arg_0));
        boolean x$10 = qual$2.mapPartitions$default$2();
        RDD preAgg = qual$2.mapPartitions((Function1)x$9, x$10, ClassTag$.MODULE$.apply(Tuple2.class)).setName("GraphImpl.aggregateMessages - preAgg");
        return this.vertices().aggregateUsingIndex(preAgg, mergeMsg, evidence$10);
    }

    @Override
    public <U, VD2> Graph<VD2, ED> outerJoinVertices(RDD<Tuple2<Object, U>> other, Function3<Object, VD, Option<U>, VD2> updateF, ClassTag<U> evidence$11, ClassTag<VD2> evidence$12, Predef$.eq.colon.eq<VD, VD2> eq2) {
        GraphImpl<VD, ED> graphImpl;
        if (eq2 != null) {
            this.vertices().cache();
            VertexRDD newVerts = (VertexRDD)this.vertices().leftJoin(other, updateF, evidence$11, evidence$12).cache();
            VertexRDD<VD> changedVerts = this.vertices().diff(newVerts);
            ReplicatedVertexView<VD, ED> newReplicatedVertexView = this.replicatedVertexView().updateVertices(changedVerts);
            graphImpl = new GraphImpl<VD, ED>(newVerts, newReplicatedVertexView, evidence$12, this.evidence$2);
        } else {
            VertexRDD<VD2> newVerts = this.vertices().leftJoin(other, updateF, evidence$11, evidence$12);
            graphImpl = GraphImpl$.MODULE$.apply(newVerts, this.replicatedVertexView().edges(), evidence$12, this.evidence$2);
        }
        return graphImpl;
    }

    @Override
    public <U, VD2> Null$ outerJoinVertices$default$5(RDD<Tuple2<Object, U>> other, Function3<Object, VD, Option<U>, VD2> updateF) {
        return null;
    }

    private boolean accessesVertexAttr(Object closure, String attrName) {
        boolean bl;
        try {
            bl = BytecodeUtils$.MODULE$.invokedMethod(closure, EdgeTriplet.class, attrName);
        }
        catch (ClassNotFoundException classNotFoundException) {
            bl = true;
        }
        return bl;
    }

    public static final /* synthetic */ void $anonfun$partitionBy$3(EdgePartitionBuilder builder$1, Tuple2 message) {
        Tuple3 data = (Tuple3)message._2();
        builder$1.add(BoxesRunTime.unboxToLong((Object)data._1()), BoxesRunTime.unboxToLong((Object)data._2()), data._3());
    }

    public static final /* synthetic */ Iterator $anonfun$partitionBy$2(ClassTag edTag$1, ClassTag vdTag$1, int pid, Iterator iter) {
        EdgePartitionBuilder builder = new EdgePartitionBuilder(EdgePartitionBuilder$.MODULE$.$lessinit$greater$default$1(), edTag$1, vdTag$1);
        iter.foreach((Function1 & Serializable & scala.Serializable)message -> {
            GraphImpl.$anonfun$partitionBy$3(builder, message);
            return BoxedUnit.UNIT;
        });
        EdgePartition edgePartition = builder.toEdgePartition();
        return package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToInteger((int)pid), edgePartition)}));
    }

    public static final /* synthetic */ boolean $anonfun$subgraph$default$1$1(EdgeTriplet x) {
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$subgraph$default$2$1(long a, Object b) {
        return true;
    }

    public static final /* synthetic */ int $anonfun$aggregateMessagesWithActiveSet$4() {
        return 0;
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ Iterator $anonfun$aggregateMessagesWithActiveSet$3(Function1 sendMsg$1, Function2 mergeMsg$1, TripletFields tripletFields$2, ClassTag evidence$10$1, Option activeDirectionOpt$1, Tuple2 x0$3) {
        block4: {
            block2: {
                block6: {
                    block5: {
                        block3: {
                            var8_6 = x0$3;
                            if (var8_6 == null) break block2;
                            edgePartition = (EdgePartition)var8_6._2();
                            activeFraction = (float)BoxesRunTime.unboxToInt((Object)edgePartition.numActives().getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()I, $anonfun$aggregateMessagesWithActiveSet$4(), ()I)())) / (float)edgePartition.indexSize();
                            var11_9 = false;
                            var12_10 = null;
                            var13_11 = activeDirectionOpt$1;
                            if (!(var13_11 instanceof Some)) break block3;
                            var11_9 = true;
                            var12_10 = (Some)var13_11;
                            var14_12 = (EdgeDirection)var12_10.value();
                            v0 = EdgeDirection$.MODULE$.Both();
                            var15_13 = var14_12;
                            if (v0 != null ? v0.equals(var15_13) == false : var15_13 != null) break block3;
                            var7_14 = (double)activeFraction < 0.8 ? edgePartition.aggregateMessagesIndexScan(sendMsg$1, mergeMsg$1, tripletFields$2, EdgeActiveness.Both, evidence$10$1) : edgePartition.aggregateMessagesEdgeScan(sendMsg$1, mergeMsg$1, tripletFields$2, EdgeActiveness.Both, evidence$10$1);
                            break block4;
                        }
                        if (!var11_9) break block5;
                        var16_15 = (EdgeDirection)var12_10.value();
                        v1 = EdgeDirection$.MODULE$.Either();
                        var17_16 = var16_15;
                        if (v1 != null ? v1.equals(var17_16) == false : var17_16 != null) break block5;
                        var7_14 = edgePartition.aggregateMessagesEdgeScan(sendMsg$1, mergeMsg$1, tripletFields$2, EdgeActiveness.Either, evidence$10$1);
                        break block4;
                    }
                    if (!var11_9) break block6;
                    var18_17 = (EdgeDirection)var12_10.value();
                    v2 = EdgeDirection$.MODULE$.Out();
                    var19_18 = var18_17;
                    if (v2 != null ? v2.equals(var19_18) == false : var19_18 != null) break block6;
                    var7_14 = (double)activeFraction < 0.8 ? edgePartition.aggregateMessagesIndexScan(sendMsg$1, mergeMsg$1, tripletFields$2, EdgeActiveness.SrcOnly, evidence$10$1) : edgePartition.aggregateMessagesEdgeScan(sendMsg$1, mergeMsg$1, tripletFields$2, EdgeActiveness.SrcOnly, evidence$10$1);
                    break block4;
                }
                if (!var11_9) ** GOTO lbl-1000
                var20_19 = (EdgeDirection)var12_10.value();
                v3 = EdgeDirection$.MODULE$.In();
                var21_20 = var20_19;
                if (!(v3 != null ? v3.equals(var21_20) == false : var21_20 != null)) {
                    var7_14 = edgePartition.aggregateMessagesEdgeScan(sendMsg$1, mergeMsg$1, tripletFields$2, EdgeActiveness.DstOnly, evidence$10$1);
                } else lbl-1000:
                // 2 sources

                {
                    var7_14 = edgePartition.aggregateMessagesEdgeScan(sendMsg$1, mergeMsg$1, tripletFields$2, EdgeActiveness.Neither, evidence$10$1);
                }
                break block4;
            }
            throw new MatchError((Object)var8_6);
        }
        var6_21 = var7_14;
        return var6_21;
    }

    public GraphImpl(VertexRDD<VD> vertices, ReplicatedVertexView<VD, ED> replicatedVertexView, ClassTag<VD> evidence$1, ClassTag<ED> evidence$2) {
        this.vertices = vertices;
        this.replicatedVertexView = replicatedVertexView;
        this.evidence$1 = evidence$1;
        this.evidence$2 = evidence$2;
        super(evidence$1, evidence$2);
        this.edges = replicatedVertexView.edges();
    }

    public GraphImpl(ClassTag<VD> evidence$3, ClassTag<ED> evidence$4) {
        this(null, null, evidence$3, evidence$4);
    }
}

