/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive.thriftserver;

import java.io.IOException;
import javax.security.auth.login.LoginException;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.shims.Utils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hive.service.ServiceException;
import org.apache.hive.service.auth.HiveAuthFactory;
import org.apache.hive.service.cli.CLIService;
import org.apache.hive.service.cli.GetInfoType;
import org.apache.hive.service.cli.GetInfoValue;
import org.apache.hive.service.cli.SessionHandle;
import org.apache.hive.service.server.HiveServer2;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.hive.thriftserver.ReflectedCompositeService;
import org.apache.spark.sql.hive.thriftserver.ReflectedCompositeService$class;
import org.apache.spark.sql.hive.thriftserver.ReflectionUtils$;
import org.apache.spark.sql.hive.thriftserver.SparkSQLSessionManager;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001U3Q!\u0001\u0002\u0001\t9\u0011!c\u00159be.\u001c\u0016\u000bT\"M\u0013N+'O^5dK*\u00111\u0001B\u0001\ri\"\u0014\u0018N\u001a;tKJ4XM\u001d\u0006\u0003\u000b\u0019\tA\u0001[5wK*\u0011q\u0001C\u0001\u0004gFd'BA\u0005\u000b\u0003\u0015\u0019\b/\u0019:l\u0015\tYA\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001b\u0005\u0019qN]4\u0014\u0007\u0001y\u0001\u0004\u0005\u0002\u0011-5\t\u0011C\u0003\u0002\u0013'\u0005\u00191\r\\5\u000b\u0005Q)\u0012aB:feZL7-\u001a\u0006\u0003\u000b)I!aF\t\u0003\u0015\rc\u0015jU3sm&\u001cW\r\u0005\u0002\u001a55\t!!\u0003\u0002\u001c\u0005\tI\"+\u001a4mK\u000e$X\rZ\"p[B|7/\u001b;f'\u0016\u0014h/[2f\u0011!i\u0002A!A!\u0002\u0013y\u0012A\u00035jm\u0016\u001cVM\u001d<fe\u000e\u0001\u0001C\u0001\u0011$\u001b\u0005\t#B\u0001\u0012\u0014\u0003\u0019\u0019XM\u001d<fe&\u0011A%\t\u0002\f\u0011&4XmU3sm\u0016\u0014(\u0007\u0003\u0005'\u0001\t\u0005\t\u0015!\u0003(\u0003)\u0019\u0018\u000f\\\"p]R,\u0007\u0010\u001e\t\u0003Q%j\u0011AB\u0005\u0003U\u0019\u0011!bU)M\u0007>tG/\u001a=u\u0011\u0015a\u0003\u0001\"\u0001.\u0003\u0019a\u0014N\\5u}Q\u0019af\f\u0019\u0011\u0005e\u0001\u0001\"B\u000f,\u0001\u0004y\u0002\"\u0002\u0014,\u0001\u00049\u0003\"\u0002\u001a\u0001\t\u0003\u001a\u0014\u0001B5oSR$\"\u0001\u000e\u001e\u0011\u0005UBT\"\u0001\u001c\u000b\u0003]\nQa]2bY\u0006L!!\u000f\u001c\u0003\tUs\u0017\u000e\u001e\u0005\u0006wE\u0002\r\u0001P\u0001\tQ&4XmQ8oMB\u0011QhQ\u0007\u0002})\u0011q\bQ\u0001\u0005G>tgM\u0003\u0002\u0006\u0003*\u0011!IC\u0001\u0007Q\u0006$wn\u001c9\n\u0005\u0011s$\u0001\u0003%jm\u0016\u001cuN\u001c4\t\u000b\u0019\u0003A\u0011I$\u0002\u000f\u001d,G/\u00138g_R\u0019\u0001j\u0013)\u0011\u0005AI\u0015B\u0001&\u0012\u000519U\r^%oM>4\u0016\r\\;f\u0011\u0015aU\t1\u0001N\u00035\u0019Xm]:j_:D\u0015M\u001c3mKB\u0011\u0001CT\u0005\u0003\u001fF\u0011QbU3tg&|g\u000eS1oI2,\u0007\"B)F\u0001\u0004\u0011\u0016aC4fi&sgm\u001c+za\u0016\u0004\"\u0001E*\n\u0005Q\u000b\"aC$fi&sgm\u001c+za\u0016\u0004")
public class SparkSQLCLIService
extends CLIService
implements ReflectedCompositeService {
    private final HiveServer2 hiveServer;
    private final SQLContext sqlContext;

    @Override
    public void initCompositeService(HiveConf hiveConf) {
        ReflectedCompositeService$class.initCompositeService(this, hiveConf);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void init(HiveConf hiveConf) {
        block5: {
            String keyTabFile;
            String principal;
            ReflectionUtils$.MODULE$.setSuperField(this, "hiveConf", hiveConf);
            SparkSQLSessionManager sparkSqlSessionManager = new SparkSQLSessionManager(this.hiveServer, this.sqlContext);
            ReflectionUtils$.MODULE$.setSuperField(this, "sessionManager", sparkSqlSessionManager);
            this.addService(sparkSqlSessionManager);
            UserGroupInformation sparkServiceUGI = null;
            UserGroupInformation httpUGI = null;
            if (!UserGroupInformation.isSecurityEnabled()) break block5;
            try {
                HiveAuthFactory.loginFromKeytab(hiveConf);
                sparkServiceUGI = Utils.getUGI();
                ReflectionUtils$.MODULE$.setSuperField(this, "serviceUGI", sparkServiceUGI);
                principal = hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_SPNEGO_PRINCIPAL).trim();
                keyTabFile = hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_SPNEGO_KEYTAB).trim();
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                boolean bl = throwable2 instanceof IOException ? true : throwable2 instanceof LoginException;
                if (bl) {
                    throw new ServiceException("Unable to login to kerberos with given principal/keytab", throwable2);
                }
                throw throwable;
            }
            if (!new StringOps(Predef$.MODULE$.augmentString(principal)).nonEmpty() || !new StringOps(Predef$.MODULE$.augmentString(keyTabFile)).nonEmpty()) break block5;
            try {}
            catch (IOException iOException) {
                throw new ServiceException(new StringBuilder().append((Object)"Unable to login to spnego with given principal ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " and keytab ", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{principal, keyTabFile, iOException}))).toString(), iOException);
            }
            httpUGI = HiveAuthFactory.loginFromSpnegoKeytabAndReturnUGI(hiveConf);
            ReflectionUtils$.MODULE$.setSuperField(this, "httpUGI", httpUGI);
        }
        this.initCompositeService(hiveConf);
    }

    @Override
    public GetInfoValue getInfo(SessionHandle sessionHandle, GetInfoType getInfoType) {
        GetInfoType getInfoType2 = getInfoType;
        GetInfoValue getInfoValue = ((Object)((Object)GetInfoType.CLI_SERVER_NAME)).equals((Object)getInfoType2) ? new GetInfoValue("Spark SQL") : (((Object)((Object)GetInfoType.CLI_DBMS_NAME)).equals((Object)getInfoType2) ? new GetInfoValue("Spark SQL") : (((Object)((Object)GetInfoType.CLI_DBMS_VER)).equals((Object)getInfoType2) ? new GetInfoValue(this.sqlContext.sparkContext().version()) : super.getInfo(sessionHandle, getInfoType)));
        return getInfoValue;
    }

    public SparkSQLCLIService(HiveServer2 hiveServer, SQLContext sqlContext) {
        this.hiveServer = hiveServer;
        this.sqlContext = sqlContext;
        super(hiveServer);
        ReflectedCompositeService$class.$init$(this);
    }
}

