/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive.thriftserver;

import java.io.Serializable;
import org.apache.hive.service.server.HiveServer2;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.internal.Logging;
import org.apache.spark.scheduler.SparkListenerInterface;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.hive.HiveUtils$;
import org.apache.spark.sql.hive.client.HiveClientImpl;
import org.apache.spark.sql.hive.thriftserver.HiveThriftServer2;
import org.apache.spark.sql.hive.thriftserver.SparkSQLEnv$;
import org.apache.spark.sql.hive.thriftserver.ui.ThriftServerTab;
import org.apache.spark.util.ShutdownHookManager$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;

public final class HiveThriftServer2$
implements Logging {
    public static HiveThriftServer2$ MODULE$;
    private Option<ThriftServerTab> uiTab;
    private HiveThriftServer2.HiveThriftServer2Listener listener;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new HiveThriftServer2$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Option<ThriftServerTab> uiTab() {
        return this.uiTab;
    }

    public void uiTab_$eq(Option<ThriftServerTab> x$1) {
        this.uiTab = x$1;
    }

    public HiveThriftServer2.HiveThriftServer2Listener listener() {
        return this.listener;
    }

    public void listener_$eq(HiveThriftServer2.HiveThriftServer2Listener x$1) {
        this.listener = x$1;
    }

    @DeveloperApi
    public void startWithContext(SQLContext sqlContext) {
        HiveThriftServer2 server = new HiveThriftServer2(sqlContext);
        HiveClientImpl executionHive = HiveUtils$.MODULE$.newClientForExecution(sqlContext.sparkContext().conf(), sqlContext.sessionState().newHadoopConf());
        server.init(executionHive.conf());
        server.start();
        this.listener_$eq(new HiveThriftServer2.HiveThriftServer2Listener(server, sqlContext.conf()));
        sqlContext.sparkContext().addSparkListener((SparkListenerInterface)this.listener());
        this.uiTab_$eq((Option<ThriftServerTab>)(sqlContext.sparkContext().getConf().getBoolean("spark.ui.enabled", true) ? new Some((Object)new ThriftServerTab(sqlContext.sparkContext())) : None$.MODULE$));
    }

    public void main(String[] args) {
        Utils$.MODULE$.initDaemon(this.log());
        HiveServer2.ServerOptionsProcessor optionsProcessor = new HiveServer2.ServerOptionsProcessor("HiveThriftServer2");
        optionsProcessor.parse(args);
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Starting SparkContext");
        SparkSQLEnv$.MODULE$.init();
        ShutdownHookManager$.MODULE$.addShutdownHook((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            SparkSQLEnv$.MODULE$.stop();
            MODULE$.uiTab().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                x$1.detach();
                return BoxedUnit.UNIT;
            });
        });
        HiveClientImpl executionHive = HiveUtils$.MODULE$.newClientForExecution(SparkSQLEnv$.MODULE$.sqlContext().sparkContext().conf(), SparkSQLEnv$.MODULE$.sqlContext().sessionState().newHadoopConf());
        try {
            HiveThriftServer2 server = new HiveThriftServer2(SparkSQLEnv$.MODULE$.sqlContext());
            server.init(executionHive.conf());
            server.start();
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "HiveThriftServer2 started");
            this.listener_$eq(new HiveThriftServer2.HiveThriftServer2Listener(server, SparkSQLEnv$.MODULE$.sqlContext().conf()));
            SparkSQLEnv$.MODULE$.sparkContext().addSparkListener((SparkListenerInterface)this.listener());
            this.uiTab_$eq((Option<ThriftServerTab>)(SparkSQLEnv$.MODULE$.sparkContext().getConf().getBoolean("spark.ui.enabled", true) ? new Some((Object)new ThriftServerTab(SparkSQLEnv$.MODULE$.sparkContext())) : None$.MODULE$));
            if (SparkSQLEnv$.MODULE$.sparkContext().stopped().get()) {
                this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "SparkContext has stopped even if HiveServer2 has started, so exit");
                System.exit(-1);
            }
        }
        catch (Exception e) {
            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error starting HiveThriftServer2", e);
            System.exit(-1);
        }
    }

    private HiveThriftServer2$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.uiTab = None$.MODULE$;
    }
}

