/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive.thriftserver;

import java.io.Serializable;
import java.util.Locale;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hive.service.cli.thrift.ThriftBinaryCLIService;
import org.apache.hive.service.cli.thrift.ThriftCLIService;
import org.apache.hive.service.cli.thrift.ThriftHttpCLIService;
import org.apache.hive.service.server.HiveServer2;
import org.apache.spark.SparkContext$;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.scheduler.SparkListener;
import org.apache.spark.scheduler.SparkListenerApplicationEnd;
import org.apache.spark.scheduler.SparkListenerJobStart;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.hive.thriftserver.HiveThriftServer2$;
import org.apache.spark.sql.hive.thriftserver.HiveThriftServer2$ExecutionState$;
import org.apache.spark.sql.hive.thriftserver.ReflectedCompositeService;
import org.apache.spark.sql.hive.thriftserver.ReflectionUtils$;
import org.apache.spark.sql.hive.thriftserver.SparkSQLCLIService;
import org.apache.spark.sql.hive.thriftserver.ui.ThriftServerTab;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import scala.Enumeration;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.LinkedHashMap;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\r-wA\u0002:t\u0011\u0003\t\tAB\u0004\u0002\u0006MD\t!a\u0002\t\u000f\u0005\u0005\u0012\u0001\"\u0001\u0002$!I\u0011QE\u0001A\u0002\u0013\u0005\u0011q\u0005\u0005\n\u0003w\t\u0001\u0019!C\u0001\u0003{A\u0001\"!\u0013\u0002A\u0003&\u0011\u0011\u0006\u0005\f\u0003\u0017\n\u0001\u0019!a\u0001\n\u0003\ti\u0005C\u0006\u0004F\u0005\u0001\r\u00111A\u0005\u0002\r\u001d\u0003bCB&\u0003\u0001\u0007\t\u0011)Q\u0005\u0003\u001fBqa!\u0014\u0002\t\u0003\u0019y\u0005C\u0004\u0004j\u0005!\taa\u001b\u0007\u000f\u0005m\u0017\u0001A:\u0002^\"Q\u0011q\\\u0006\u0003\u0006\u0004%\t!!9\t\u0015\u0005\r8B!A!\u0002\u0013\t\u0019\r\u0003\u0006\u0002f.\u0011)\u0019!C\u0001\u0003OD!\"a<\f\u0005\u0003\u0005\u000b\u0011BAu\u0011)\t\tp\u0003BC\u0002\u0013\u0005\u0011\u0011\u001d\u0005\u000b\u0003g\\!\u0011!Q\u0001\n\u0005\r\u0007BCA{\u0017\t\u0015\r\u0011\"\u0001\u0002b\"Q\u0011q_\u0006\u0003\u0002\u0003\u0006I!a1\t\u000f\u0005\u00052\u0002\"\u0001\u0002z\"I!1A\u0006A\u0002\u0013\u0005\u0011q\u001d\u0005\n\u0005\u000bY\u0001\u0019!C\u0001\u0005\u000fA\u0001Ba\u0003\fA\u0003&\u0011\u0011\u001e\u0005\n\u0005\u001bY\u0001\u0019!C\u0001\u0003?C\u0011Ba\u0004\f\u0001\u0004%\tA!\u0005\t\u0011\tU1\u0002)Q\u0005\u0003CCqAa\u0006\f\t\u0003\t9o\u0002\u0005\u0003V\u0005A\ta\u001dB,\r!\u0011I&\u0001E\u0001g\nm\u0003bBA\u0011;\u0011\u0005!1\r\u0005\n\u0005Kj\"\u0019!C\u0001\u0005OB\u0001B!\u001d\u001eA\u0003%!\u0011\u000e\u0005\n\u0005gj\"\u0019!C\u0001\u0005OB\u0001B!\u001e\u001eA\u0003%!\u0011\u000e\u0005\n\u0005oj\"\u0019!C\u0001\u0005OB\u0001B!\u001f\u001eA\u0003%!\u0011\u000e\u0005\n\u0005wj\"\u0019!C\u0001\u0005OB\u0001B! \u001eA\u0003%!\u0011N\u0003\u0007\u00053j\u0002A!\u001b\u0007\u000f\t\r\u0012\u0001A:\u0003&!Q!q\u0005\u0015\u0003\u0006\u0004%\t!!9\t\u0015\t%\u0002F!A!\u0002\u0013\t\u0019\r\u0003\u0006\u0002`\"\u0012)\u0019!C\u0001\u0003CD!\"a9)\u0005\u0003\u0005\u000b\u0011BAb\u0011)\t)\u000f\u000bBC\u0002\u0013\u0005\u0011q\u001d\u0005\u000b\u0003_D#\u0011!Q\u0001\n\u0005%\bBCA{Q\t\u0015\r\u0011\"\u0001\u0002b\"Q\u0011q\u001f\u0015\u0003\u0002\u0003\u0006I!a1\t\u000f\u0005\u0005\u0002\u0006\"\u0001\u0003,!I!1\u0001\u0015A\u0002\u0013\u0005\u0011q\u001d\u0005\n\u0005\u000bA\u0003\u0019!C\u0001\u0005kA\u0001Ba\u0003)A\u0003&\u0011\u0011\u001e\u0005\n\u0005sA\u0003\u0019!C\u0001\u0003CD\u0011Ba\u000f)\u0001\u0004%\tA!\u0010\t\u0011\t\u0005\u0003\u0006)Q\u0005\u0003\u0007D\u0011Ba\u0011)\u0001\u0004%\t!!9\t\u0013\t\u0015\u0003\u00061A\u0005\u0002\t\u001d\u0003\u0002\u0003B&Q\u0001\u0006K!a1\t\u0013\t5\u0003\u00061A\u0005\u0002\t=\u0003\"\u0003B@Q\u0001\u0007I\u0011\u0001BA\u0011!\u0011)\t\u000bQ!\n\tE\u0003\"\u0003BDQ\t\u0007I\u0011\u0001BE\u0011!\u0011\t\n\u000bQ\u0001\n\t-\u0005\"\u0003BJQ\u0001\u0007I\u0011AAq\u0011%\u0011)\n\u000ba\u0001\n\u0003\u00119\n\u0003\u0005\u0003\u001c\"\u0002\u000b\u0015BAb\u0011\u001d\u00119\u0002\u000bC\u0001\u0003O4q!a\u0015\u0002\u0001M\f)\u0006\u0003\u0006\u0002d\u0011\u0013)\u0019!C\u0001\u0003KB!\"a\u001eE\u0005\u0003\u0005\u000b\u0011BA4\u0011)\tI\b\u0012BC\u0002\u0013\u0005\u00111\u0010\u0005\u000b\u0003\u000f#%\u0011!Q\u0001\n\u0005u\u0004bBA\u0011\t\u0012\u0005\u0011\u0011\u0012\u0005\b\u0003\u001f#E\u0011IAI\u0011%\ti\n\u0012a\u0001\n\u0013\ty\nC\u0005\u0002(\u0012\u0003\r\u0011\"\u0003\u0002*\"A\u0011Q\u0016#!B\u0013\t\t\u000bC\u0005\u00020\u0012\u0013\r\u0011\"\u0003\u00022\"A!\u0011\u0004#!\u0002\u0013\t\u0019\fC\u0005\u0003\u001c\u0011\u0013\r\u0011\"\u0003\u0003\u001e!A!Q\u0014#!\u0002\u0013\u0011y\u0002C\u0005\u0003 \u0012\u0013\r\u0011\"\u0003\u0002 \"A!\u0011\u0015#!\u0002\u0013\t\t\u000bC\u0005\u0003$\u0012\u0013\r\u0011\"\u0003\u0002 \"A!Q\u0015#!\u0002\u0013\t\t\u000bC\u0005\u0003(\u0012\u0003\r\u0011\"\u0003\u0002 \"I!\u0011\u0016#A\u0002\u0013%!1\u0016\u0005\t\u0005_#\u0005\u0015)\u0003\u0002\"\"9!\u0011\u0017#\u0005\u0002\u0005}\u0005b\u0002BZ\t\u0012\u0005\u0011q\u0014\u0005\b\u0005k#E\u0011\u0001B\\\u0011\u001d\u0011Y\r\u0012C\u0001\u0005\u001bDqAa5E\t\u0003\u0011)\u000eC\u0004\u0003Z\u0012#\tEa7\t\u000f\t\u001dH\t\"\u0001\u0003j\"I!\u0011\u001f#\u0012\u0002\u0013\u0005!1\u001f\u0005\b\u0007\u0013!E\u0011AB\u0006\u0011\u001d\u0019y\u0001\u0012C\u0001\u0007#A\u0011ba\bE#\u0003%\tAa=\t\u000f\r\u0005B\t\"\u0001\u0004$!911\u0006#\u0005\u0002\r5\u0002bBB\u001d\t\u0012\u000511\b\u0005\b\u0007\u007f!E\u0011BB!\u0011\u001d\u0019\u0019\u0005\u0012C\u0005\u0007\u00032q!!\u0002t\u0001U\u001c9\b\u0003\u0006\u0004T%\u0014\t\u0011)A\u0005\u0007+Bq!!\tj\t\u0003\u0019y\bC\u0005\u0004\u0006&\u0014\r\u0011\"\u0003\u0004\b\"A1\u0011U5!\u0002\u0013\u0019I\tC\u0004\u0004$&$\te!*\t\u000f\rm\u0016\u000e\"\u0003\u0004>\"91qY5\u0005B\r\u0005\u0003bBBeS\u0012\u00053\u0011I\u0001\u0012\u0011&4X\r\u00165sS\u001a$8+\u001a:wKJ\u0014$B\u0001;v\u00031!\bN]5giN,'O^3s\u0015\t1x/\u0001\u0003iSZ,'B\u0001=z\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003un\fQa\u001d9be.T!\u0001`?\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005q\u0018aA8sO\u000e\u0001\u0001cAA\u0002\u00035\t1OA\tISZ,G\u000b\u001b:jMR\u001cVM\u001d<feJ\u001aR!AA\u0005\u0003+\u0001B!a\u0003\u0002\u00125\u0011\u0011Q\u0002\u0006\u0003\u0003\u001f\tQa]2bY\u0006LA!a\u0005\u0002\u000e\t1\u0011I\\=SK\u001a\u0004B!a\u0006\u0002\u001e5\u0011\u0011\u0011\u0004\u0006\u0004\u00037I\u0018\u0001C5oi\u0016\u0014h.\u00197\n\t\u0005}\u0011\u0011\u0004\u0002\b\u0019><w-\u001b8h\u0003\u0019a\u0014N\\5u}Q\u0011\u0011\u0011A\u0001\u0006k&$\u0016MY\u000b\u0003\u0003S\u0001b!a\u0003\u0002,\u0005=\u0012\u0002BA\u0017\u0003\u001b\u0011aa\u00149uS>t\u0007\u0003BA\u0019\u0003oi!!a\r\u000b\u0007\u0005U2/\u0001\u0002vS&!\u0011\u0011HA\u001a\u0005=!\u0006N]5giN+'O^3s)\u0006\u0014\u0017!C;j)\u0006\u0014w\fJ3r)\u0011\ty$!\u0012\u0011\t\u0005-\u0011\u0011I\u0005\u0005\u0003\u0007\niA\u0001\u0003V]&$\b\"CA$\t\u0005\u0005\t\u0019AA\u0015\u0003\rAH%M\u0001\u0007k&$\u0016M\u0019\u0011\u0002\u00111L7\u000f^3oKJ,\"!a\u0014\u0011\u0007\u0005EC)D\u0001\u0002\u0005eA\u0015N^3UQJLg\r^*feZ,'O\r'jgR,g.\u001a:\u0014\u0007\u0011\u000b9\u0006\u0005\u0003\u0002Z\u0005}SBAA.\u0015\r\ti&_\u0001\ng\u000eDW\rZ;mKJLA!!\u0019\u0002\\\ti1\u000b]1sW2K7\u000f^3oKJ\faa]3sm\u0016\u0014XCAA4!\u0011\tI'a\u001d\u000e\u0005\u0005-$\u0002BA2\u0003[RA!a\u001c\u0002r\u000591/\u001a:wS\u000e,'B\u0001<|\u0013\u0011\t)(a\u001b\u0003\u0017!Kg/Z*feZ,'OM\u0001\bg\u0016\u0014h/\u001a:!\u0003\u0011\u0019wN\u001c4\u0016\u0005\u0005u\u0004\u0003BA@\u0003\u0007k!!!!\u000b\u0007\u0005mq/\u0003\u0003\u0002\u0006\u0006\u0005%aB*R\u0019\u000e{gNZ\u0001\u0006G>tg\r\t\u000b\u0007\u0003\u001f\nY)!$\t\u000f\u0005\r\u0014\n1\u0001\u0002h!9\u0011\u0011P%A\u0002\u0005u\u0014\u0001E8o\u0003B\u0004H.[2bi&|g.\u00128e)\u0011\ty$a%\t\u000f\u0005U%\n1\u0001\u0002\u0018\u0006q\u0011\r\u001d9mS\u000e\fG/[8o\u000b:$\u0007\u0003BA-\u00033KA!a'\u0002\\\tY2\u000b]1sW2K7\u000f^3oKJ\f\u0005\u000f\u001d7jG\u0006$\u0018n\u001c8F]\u0012\f\u0001c\u001c8mS:,7+Z:tS>tg*^7\u0016\u0005\u0005\u0005\u0006\u0003BA\u0006\u0003GKA!!*\u0002\u000e\t\u0019\u0011J\u001c;\u0002)=tG.\u001b8f'\u0016\u001c8/[8o\u001dVlw\fJ3r)\u0011\ty$a+\t\u0013\u0005\u001dC*!AA\u0002\u0005\u0005\u0016!E8oY&tWmU3tg&|gNT;nA\u0005Y1/Z:tS>tG*[:u+\t\t\u0019\f\u0005\u0005\u00026\u0006}\u00161YAm\u001b\t\t9L\u0003\u0003\u0002:\u0006m\u0016aB7vi\u0006\u0014G.\u001a\u0006\u0005\u0003{\u000bi!\u0001\u0006d_2dWm\u0019;j_:LA!!1\u00028\niA*\u001b8lK\u0012D\u0015m\u001d5NCB\u0004B!!2\u0002T:!\u0011qYAh!\u0011\tI-!\u0004\u000e\u0005\u0005-'bAAg\u007f\u00061AH]8pizJA!!5\u0002\u000e\u00051\u0001K]3eK\u001aLA!!6\u0002X\n11\u000b\u001e:j]\u001eTA!!5\u0002\u000eA\u0019\u0011\u0011K\u0006\u0003\u0017M+7o]5p]&sgm\\\n\u0004\u0017\u0005%\u0011!C:fgNLwN\\%e+\t\t\u0019-\u0001\u0006tKN\u001c\u0018n\u001c8JI\u0002\nab\u001d;beR$\u0016.\\3ti\u0006l\u0007/\u0006\u0002\u0002jB!\u00111BAv\u0013\u0011\ti/!\u0004\u0003\t1{gnZ\u0001\u0010gR\f'\u000f\u001e+j[\u0016\u001cH/Y7qA\u0005\u0011\u0011\u000e]\u0001\u0004SB\u0004\u0013\u0001C;tKJt\u0015-\\3\u0002\u0013U\u001cXM\u001d(b[\u0016\u0004CCCAm\u0003w\fi0a@\u0003\u0002!9\u0011q\u001c\u000bA\u0002\u0005\r\u0007bBAs)\u0001\u0007\u0011\u0011\u001e\u0005\b\u0003c$\u0002\u0019AAb\u0011\u001d\t)\u0010\u0006a\u0001\u0003\u0007\fqBZ5oSNDG+[7fgR\fW\u000e]\u0001\u0014M&t\u0017n\u001d5US6,7\u000f^1na~#S-\u001d\u000b\u0005\u0003\u007f\u0011I\u0001C\u0005\u0002HY\t\t\u00111\u0001\u0002j\u0006\u0001b-\u001b8jg\"$\u0016.\\3ti\u0006l\u0007\u000fI\u0001\u000fi>$\u0018\r\\#yK\u000e,H/[8o\u0003I!x\u000e^1m\u000bb,7-\u001e;j_:|F%Z9\u0015\t\u0005}\"1\u0003\u0005\n\u0003\u000fJ\u0012\u0011!a\u0001\u0003C\u000bq\u0002^8uC2,\u00050Z2vi&|g\u000eI\u0001\ni>$\u0018\r\u001c+j[\u0016\fAb]3tg&|g\u000eT5ti\u0002\nQ\"\u001a=fGV$\u0018n\u001c8MSN$XC\u0001B\u0010!!\t),a0\u0002D\n\u0005\u0002cAA)Q\tiQ\t_3dkRLwN\\%oM>\u001c2\u0001KA\u0005\u0003%\u0019H/\u0019;f[\u0016tG/\u0001\u0006ti\u0006$X-\\3oi\u0002\"\"B!\t\u0003.\t=\"\u0011\u0007B\u001a\u0011\u001d\u00119#\ra\u0001\u0003\u0007Dq!a82\u0001\u0004\t\u0019\rC\u0004\u0002fF\u0002\r!!;\t\u000f\u0005U\u0018\u00071\u0001\u0002DR!\u0011q\bB\u001c\u0011%\t9eMA\u0001\u0002\u0004\tI/A\u0006fq\u0016\u001cW\u000f^3QY\u0006t\u0017aD3yK\u000e,H/\u001a)mC:|F%Z9\u0015\t\u0005}\"q\b\u0005\n\u0003\u000f2\u0014\u0011!a\u0001\u0003\u0007\fA\"\u001a=fGV$X\r\u00157b]\u0002\na\u0001Z3uC&d\u0017A\u00033fi\u0006LGn\u0018\u0013fcR!\u0011q\bB%\u0011%\t9%OA\u0001\u0002\u0004\t\u0019-A\u0004eKR\f\u0017\u000e\u001c\u0011\u0002\u000bM$\u0018\r^3\u0016\u0005\tE\u0003\u0003\u0002B*\u0005[r1!!\u0015\u001d\u00039)\u00050Z2vi&|gn\u0015;bi\u0016\u00042!!\u0015\u001e\u00059)\u00050Z2vi&|gn\u0015;bi\u0016\u001c2!\bB/!\u0011\tYAa\u0018\n\t\t\u0005\u0014Q\u0002\u0002\f\u000b:,X.\u001a:bi&|g\u000e\u0006\u0002\u0003X\u000591\u000bV!S)\u0016#UC\u0001B5!\u0011\u0011YG!\u001c\u000e\u0003uIAAa\u001c\u0003`\t)a+\u00197vK\u0006A1\u000bV!S)\u0016#\u0005%\u0001\u0005D\u001f6\u0003\u0016\nT#E\u0003%\u0019u*\u0014)J\u0019\u0016#\u0005%\u0001\u0004G\u0003&cU\tR\u0001\b\r\u0006KE*\u0012#!\u0003!1\u0015JT%T\u0011\u0016#\u0015!\u0003$J\u001d&\u001b\u0006*\u0012#!\u0003%\u0019H/\u0019;f?\u0012*\u0017\u000f\u0006\u0003\u0002@\t\r\u0005\"CA$y\u0005\u0005\t\u0019\u0001B)\u0003\u0019\u0019H/\u0019;fA\u0005)!n\u001c2JIV\u0011!1\u0012\t\u0007\u0003k\u0013i)a1\n\t\t=\u0015q\u0017\u0002\f\u0003J\u0014\u0018-\u001f\"vM\u001a,'/\u0001\u0004k_\nLE\rI\u0001\bOJ|W\u000f]%e\u0003-9'o\\;q\u0013\u0012|F%Z9\u0015\t\u0005}\"\u0011\u0014\u0005\n\u0003\u000f\n\u0015\u0011!a\u0001\u0003\u0007\f\u0001b\u001a:pkBLE\rI\u0001\u000fKb,7-\u001e;j_:d\u0015n\u001d;!\u0003I\u0011X\r^1j]\u0016$7\u000b^1uK6,g\u000e^:\u0002'I,G/Y5oK\u0012\u001cF/\u0019;f[\u0016tGo\u001d\u0011\u0002!I,G/Y5oK\u0012\u001cVm]:j_:\u001c\u0018!\u0005:fi\u0006Lg.\u001a3TKN\u001c\u0018n\u001c8tA\u0005aAo\u001c;bYJ+hN\\5oO\u0006\u0001Bo\u001c;bYJ+hN\\5oO~#S-\u001d\u000b\u0005\u0003\u007f\u0011i\u000bC\u0005\u0002H]\u000b\t\u00111\u0001\u0002\"\u0006iAo\u001c;bYJ+hN\\5oO\u0002\n1cZ3u\u001f:d\u0017N\\3TKN\u001c\u0018n\u001c8Ok6\fqbZ3u)>$\u0018\r\u001c*v]:LgnZ\u0001\u000fO\u0016$8+Z:tS>tG*[:u+\t\u0011I\f\u0005\u0004\u0003<\n\u0015\u0017\u0011\u001c\b\u0005\u0005{\u0013\tM\u0004\u0003\u0002J\n}\u0016BAA\b\u0013\u0011\u0011\u0019-!\u0004\u0002\u000fA\f7m[1hK&!!q\u0019Be\u0005\r\u0019V-\u001d\u0006\u0005\u0005\u0007\fi!\u0001\u0006hKR\u001cVm]:j_:$BAa4\u0003RB1\u00111BA\u0016\u00033Dq!a8]\u0001\u0004\t\u0019-\u0001\thKR,\u00050Z2vi&|g\u000eT5tiV\u0011!q\u001b\t\u0007\u0005w\u0013)M!\t\u0002\u0015=t'j\u001c2Ti\u0006\u0014H\u000f\u0006\u0003\u0002@\tu\u0007b\u0002Bp=\u0002\u0007!\u0011]\u0001\tU>\u00147\u000b^1siB!\u0011\u0011\fBr\u0013\u0011\u0011)/a\u0017\u0003+M\u0003\u0018M]6MSN$XM\\3s\u0015>\u00147\u000b^1si\u0006\u0001rN\\*fgNLwN\\\"sK\u0006$X\r\u001a\u000b\t\u0003\u007f\u0011YO!<\u0003p\"9\u0011\u0011_0A\u0002\u0005\r\u0007bBAp?\u0002\u0007\u00111\u0019\u0005\n\u0003k|\u0006\u0013!a\u0001\u0003\u0007\f!d\u001c8TKN\u001c\u0018n\u001c8De\u0016\fG/\u001a3%I\u00164\u0017-\u001e7uIM*\"A!>+\t\u0005\r'q_\u0016\u0003\u0005s\u0004BAa?\u0004\u00065\u0011!Q \u0006\u0005\u0005\u007f\u001c\t!A\u0005v]\u000eDWmY6fI*!11AA\u0007\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0007\u000f\u0011iPA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fqb\u001c8TKN\u001c\u0018n\u001c8DY>\u001cX\r\u001a\u000b\u0005\u0003\u007f\u0019i\u0001C\u0004\u0002`\u0006\u0004\r!a1\u0002!=t7\u000b^1uK6,g\u000e^*uCJ$H\u0003DA \u0007'\u00199b!\u0007\u0004\u001c\ru\u0001bBB\u000bE\u0002\u0007\u00111Y\u0001\u0003S\u0012Dq!a8c\u0001\u0004\t\u0019\rC\u0004\u0003(\t\u0004\r!a1\t\u000f\tM%\r1\u0001\u0002D\"I\u0011Q\u001f2\u0011\u0002\u0003\u0007\u00111Y\u0001\u001b_:\u001cF/\u0019;f[\u0016tGo\u0015;beR$C-\u001a4bk2$H%N\u0001\u0012_:\u001cF/\u0019;f[\u0016tG\u000fU1sg\u0016$GCBA \u0007K\u00199\u0003C\u0004\u0004\u0016\u0011\u0004\r!a1\t\u000f\r%B\r1\u0001\u0002D\u0006iQ\r_3dkRLwN\u001c)mC:\f\u0001c\u001c8Ti\u0006$X-\\3oi\u0016\u0013(o\u001c:\u0015\u0011\u0005}2qFB\u0019\u0007kAqa!\u0006f\u0001\u0004\t\u0019\rC\u0004\u00044\u0015\u0004\r!a1\u0002\u0019\u0015\u0014(o\u001c:NKN\u001c\u0018mZ3\t\u000f\r]R\r1\u0001\u0002D\u0006QQM\u001d:peR\u0013\u0018mY3\u0002#=t7\u000b^1uK6,g\u000e\u001e$j]&\u001c\b\u000e\u0006\u0003\u0002@\ru\u0002bBB\u000bM\u0002\u0007\u00111Y\u0001\u0019iJLW.\u0012=fGV$\u0018n\u001c8JM:+7-Z:tCJLHCAA \u0003Y!(/[7TKN\u001c\u0018n\u001c8JM:+7-Z:tCJL\u0018\u0001\u00047jgR,g.\u001a:`I\u0015\fH\u0003BA \u0007\u0013B\u0011\"a\u0012\b\u0003\u0003\u0005\r!a\u0014\u0002\u00131L7\u000f^3oKJ\u0004\u0013\u0001E:uCJ$x+\u001b;i\u0007>tG/\u001a=u)\u0011\tyd!\u0015\t\u000f\rM\u0013\u00021\u0001\u0004V\u0005Q1/\u001d7D_:$X\r\u001f;\u0011\t\r]3\u0011L\u0007\u0002o&\u001911L<\u0003\u0015M\u000bFjQ8oi\u0016DH\u000fK\u0002\n\u0007?\u0002Ba!\u0019\u0004f5\u001111\r\u0006\u0004\u0007\u0007I\u0018\u0002BB4\u0007G\u0012A\u0002R3wK2|\u0007/\u001a:Ba&\fA!\\1j]R!\u0011qHB7\u0011\u001d\u0019yG\u0003a\u0001\u0007c\nA!\u0019:hgB1\u00111BB:\u0003\u0007LAa!\u001e\u0002\u000e\t)\u0011I\u001d:bsN)\u0011.a\u001a\u0004zA!\u00111AB>\u0013\r\u0019ih\u001d\u0002\u001a%\u00164G.Z2uK\u0012\u001cu.\u001c9pg&$XmU3sm&\u001cW\r\u0006\u0003\u0004\u0002\u000e\r\u0005cAA\u0002S\"911K6A\u0002\rU\u0013aB:uCJ$X\rZ\u000b\u0003\u0007\u0013\u0003Baa#\u0004\u001e6\u00111Q\u0012\u0006\u0005\u0007\u001f\u001b\t*\u0001\u0004bi>l\u0017n\u0019\u0006\u0005\u0007'\u001b)*\u0001\u0006d_:\u001cWO\u001d:f]RTAaa&\u0004\u001a\u0006!Q\u000f^5m\u0015\t\u0019Y*\u0001\u0003kCZ\f\u0017\u0002BBP\u0007\u001b\u0013Q\"\u0011;p[&\u001c'i\\8mK\u0006t\u0017\u0001C:uCJ$X\r\u001a\u0011\u0002\t%t\u0017\u000e\u001e\u000b\u0005\u0003\u007f\u00199\u000bC\u0004\u0004*:\u0004\raa+\u0002\u0011!Lg/Z\"p]\u001a\u0004Ba!,\u000486\u00111q\u0016\u0006\u0005\u0003s\u001a\tLC\u0002w\u0007gS1a!.|\u0003\u0019A\u0017\rZ8pa&!1\u0011XBX\u0005!A\u0015N^3D_:4\u0017aE5t\u0011R#\u0006\u000b\u0016:b]N\u0004xN\u001d;N_\u0012,G\u0003BB`\u0007\u000b\u0004B!a\u0003\u0004B&!11YA\u0007\u0005\u001d\u0011un\u001c7fC:Dqa!+p\u0001\u0004\u0019Y+A\u0003ti\u0006\u0014H/\u0001\u0003ti>\u0004\b")
public class HiveThriftServer2
extends HiveServer2
implements ReflectedCompositeService {
    private final SQLContext sqlContext;
    private final AtomicBoolean started;

    public static void main(String[] stringArray) {
        HiveThriftServer2$.MODULE$.main(stringArray);
    }

    @DeveloperApi
    public static void startWithContext(SQLContext sQLContext) {
        HiveThriftServer2$.MODULE$.startWithContext(sQLContext);
    }

    public static void listener_$eq(HiveThriftServer2Listener hiveThriftServer2Listener) {
        HiveThriftServer2$.MODULE$.listener_$eq(hiveThriftServer2Listener);
    }

    public static HiveThriftServer2Listener listener() {
        return HiveThriftServer2$.MODULE$.listener();
    }

    public static void uiTab_$eq(Option<ThriftServerTab> option) {
        HiveThriftServer2$.MODULE$.uiTab_$eq(option);
    }

    public static Option<ThriftServerTab> uiTab() {
        return HiveThriftServer2$.MODULE$.uiTab();
    }

    @Override
    public void initCompositeService(HiveConf hiveConf) {
        ReflectedCompositeService.initCompositeService$(this, hiveConf);
    }

    private AtomicBoolean started() {
        return this.started;
    }

    @Override
    public void init(HiveConf hiveConf) {
        SparkSQLCLIService sparkSqlCliService = new SparkSQLCLIService(this, this.sqlContext);
        ReflectionUtils$.MODULE$.setSuperField(this, "cliService", sparkSqlCliService);
        this.addService(sparkSqlCliService);
        ThriftCLIService thriftCliService = this.isHTTPTransportMode(hiveConf) ? new ThriftHttpCLIService(sparkSqlCliService) : new ThriftBinaryCLIService(sparkSqlCliService);
        ReflectionUtils$.MODULE$.setSuperField(this, "thriftCLIService", thriftCliService);
        this.addService(thriftCliService);
        this.initCompositeService(hiveConf);
    }

    @Override
    private boolean isHTTPTransportMode(HiveConf hiveConf) {
        String transportMode = hiveConf.getVar(HiveConf.ConfVars.HIVE_SERVER2_TRANSPORT_MODE);
        return transportMode.toLowerCase(Locale.ROOT).equals("http");
    }

    @Override
    public void start() {
        super.start();
        this.started().set(true);
    }

    @Override
    public void stop() {
        block0: {
            if (!this.started().getAndSet(false)) break block0;
            super.stop();
        }
    }

    public HiveThriftServer2(SQLContext sqlContext) {
        this.sqlContext = sqlContext;
        ReflectedCompositeService.$init$(this);
        this.started = new AtomicBoolean(false);
    }

    public static class ExecutionInfo {
        private final String statement;
        private final String sessionId;
        private final long startTimestamp;
        private final String userName;
        private long finishTimestamp;
        private String executePlan;
        private String detail;
        private Enumeration.Value state;
        private final ArrayBuffer<String> jobId;
        private String groupId;

        public String statement() {
            return this.statement;
        }

        public String sessionId() {
            return this.sessionId;
        }

        public long startTimestamp() {
            return this.startTimestamp;
        }

        public String userName() {
            return this.userName;
        }

        public long finishTimestamp() {
            return this.finishTimestamp;
        }

        public void finishTimestamp_$eq(long x$1) {
            this.finishTimestamp = x$1;
        }

        public String executePlan() {
            return this.executePlan;
        }

        public void executePlan_$eq(String x$1) {
            this.executePlan = x$1;
        }

        public String detail() {
            return this.detail;
        }

        public void detail_$eq(String x$1) {
            this.detail = x$1;
        }

        public Enumeration.Value state() {
            return this.state;
        }

        public void state_$eq(Enumeration.Value x$1) {
            this.state = x$1;
        }

        public ArrayBuffer<String> jobId() {
            return this.jobId;
        }

        public String groupId() {
            return this.groupId;
        }

        public void groupId_$eq(String x$1) {
            this.groupId = x$1;
        }

        public long totalTime() {
            return this.finishTimestamp() == 0L ? System.currentTimeMillis() - this.startTimestamp() : this.finishTimestamp() - this.startTimestamp();
        }

        public ExecutionInfo(String statement, String sessionId, long startTimestamp, String userName) {
            this.statement = statement;
            this.sessionId = sessionId;
            this.startTimestamp = startTimestamp;
            this.userName = userName;
            this.finishTimestamp = 0L;
            this.executePlan = "";
            this.detail = "";
            this.state = HiveThriftServer2$ExecutionState$.MODULE$.STARTED();
            this.jobId = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
            this.groupId = "";
        }
    }

    public static class HiveThriftServer2Listener
    extends SparkListener {
        private final HiveServer2 server;
        private final SQLConf conf;
        private int onlineSessionNum;
        private final LinkedHashMap<String, SessionInfo> sessionList;
        private final LinkedHashMap<String, ExecutionInfo> executionList;
        private final int retainedStatements;
        private final int retainedSessions;
        private int totalRunning;

        public HiveServer2 server() {
            return this.server;
        }

        public SQLConf conf() {
            return this.conf;
        }

        public void onApplicationEnd(SparkListenerApplicationEnd applicationEnd) {
            this.server().stop();
        }

        private int onlineSessionNum() {
            return this.onlineSessionNum;
        }

        private void onlineSessionNum_$eq(int x$1) {
            this.onlineSessionNum = x$1;
        }

        private LinkedHashMap<String, SessionInfo> sessionList() {
            return this.sessionList;
        }

        private LinkedHashMap<String, ExecutionInfo> executionList() {
            return this.executionList;
        }

        private int retainedStatements() {
            return this.retainedStatements;
        }

        private int retainedSessions() {
            return this.retainedSessions;
        }

        private int totalRunning() {
            return this.totalRunning;
        }

        private void totalRunning_$eq(int x$1) {
            this.totalRunning = x$1;
        }

        public synchronized int getOnlineSessionNum() {
            return this.onlineSessionNum();
        }

        public synchronized int getTotalRunning() {
            return this.totalRunning();
        }

        public synchronized Seq<SessionInfo> getSessionList() {
            return this.sessionList().values().toSeq();
        }

        public synchronized Option<SessionInfo> getSession(String sessionId) {
            return this.sessionList().get((Object)sessionId);
        }

        public synchronized Seq<ExecutionInfo> getExecutionList() {
            return this.executionList().values().toSeq();
        }

        public synchronized void onJobStart(SparkListenerJobStart jobStart) {
            Option$.MODULE$.apply((Object)jobStart.properties()).foreach((Function1 & Serializable & scala.Serializable)props -> {
                HiveThriftServer2Listener.$anonfun$onJobStart$1(this, jobStart, props);
                return BoxedUnit.UNIT;
            });
        }

        public synchronized void onSessionCreated(String ip, String sessionId, String userName) {
            SessionInfo info = new SessionInfo(sessionId, System.currentTimeMillis(), ip, userName);
            this.sessionList().put((Object)sessionId, (Object)info);
            this.onlineSessionNum_$eq(this.onlineSessionNum() + 1);
            this.trimSessionIfNecessary();
        }

        public String onSessionCreated$default$3() {
            return "UNKNOWN";
        }

        public synchronized void onSessionClosed(String sessionId) {
            ((SessionInfo)this.sessionList().apply((Object)sessionId)).finishTimestamp_$eq(System.currentTimeMillis());
            this.onlineSessionNum_$eq(this.onlineSessionNum() - 1);
            this.trimSessionIfNecessary();
        }

        public synchronized void onStatementStart(String id, String sessionId, String statement, String groupId, String userName) {
            ExecutionInfo info = new ExecutionInfo(statement, sessionId, System.currentTimeMillis(), userName);
            info.state_$eq(HiveThriftServer2$ExecutionState$.MODULE$.STARTED());
            this.executionList().put((Object)id, (Object)info);
            this.trimExecutionIfNecessary();
            SessionInfo sessionInfo = (SessionInfo)this.sessionList().apply((Object)sessionId);
            sessionInfo.totalExecution_$eq(sessionInfo.totalExecution() + 1);
            ((ExecutionInfo)this.executionList().apply((Object)id)).groupId_$eq(groupId);
            this.totalRunning_$eq(this.totalRunning() + 1);
        }

        public String onStatementStart$default$5() {
            return "UNKNOWN";
        }

        public synchronized void onStatementParsed(String id, String executionPlan) {
            ((ExecutionInfo)this.executionList().apply((Object)id)).executePlan_$eq(executionPlan);
            ((ExecutionInfo)this.executionList().apply((Object)id)).state_$eq(HiveThriftServer2$ExecutionState$.MODULE$.COMPILED());
        }

        public synchronized void onStatementError(String id, String errorMessage, String errorTrace) {
            ((ExecutionInfo)this.executionList().apply((Object)id)).finishTimestamp_$eq(System.currentTimeMillis());
            ((ExecutionInfo)this.executionList().apply((Object)id)).detail_$eq(errorMessage);
            ((ExecutionInfo)this.executionList().apply((Object)id)).state_$eq(HiveThriftServer2$ExecutionState$.MODULE$.FAILED());
            this.totalRunning_$eq(this.totalRunning() - 1);
            this.trimExecutionIfNecessary();
        }

        public synchronized void onStatementFinish(String id) {
            ((ExecutionInfo)this.executionList().apply((Object)id)).finishTimestamp_$eq(System.currentTimeMillis());
            ((ExecutionInfo)this.executionList().apply((Object)id)).state_$eq(HiveThriftServer2$ExecutionState$.MODULE$.FINISHED());
            this.totalRunning_$eq(this.totalRunning() - 1);
            this.trimExecutionIfNecessary();
        }

        private void trimExecutionIfNecessary() {
            block0: {
                if (this.executionList().size() <= this.retainedStatements()) break block0;
                int toRemove = package$.MODULE$.max(this.retainedStatements() / 10, 1);
                ((LinkedHashMap)((IterableLike)this.executionList().filter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)HiveThriftServer2Listener.$anonfun$trimExecutionIfNecessary$1(x$4)))).take(toRemove)).foreach((Function1 & Serializable & scala.Serializable)s -> this.executionList().remove(s._1()));
            }
        }

        private void trimSessionIfNecessary() {
            block0: {
                if (this.sessionList().size() <= this.retainedSessions()) break block0;
                int toRemove = package$.MODULE$.max(this.retainedSessions() / 10, 1);
                ((LinkedHashMap)((IterableLike)this.sessionList().filter((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)HiveThriftServer2Listener.$anonfun$trimSessionIfNecessary$1(x$5)))).take(toRemove)).foreach((Function1 & Serializable & scala.Serializable)s -> this.sessionList().remove(s._1()));
            }
        }

        public static final /* synthetic */ boolean $anonfun$onJobStart$3(Tuple2 check$ifrefutable$1) {
            Tuple2 tuple2 = check$ifrefutable$1;
            boolean bl = tuple2 != null;
            return bl;
        }

        public static final /* synthetic */ boolean $anonfun$onJobStart$4(String groupId$1, Tuple2 x$2) {
            Tuple2 tuple2 = x$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            ExecutionInfo info = (ExecutionInfo)tuple2._2();
            String string = info.groupId();
            String string2 = groupId$1;
            boolean bl = !(string != null ? !string.equals(string2) : string2 != null);
            return bl;
        }

        public static final /* synthetic */ void $anonfun$onJobStart$5(SparkListenerJobStart jobStart$1, String groupId$1, Tuple2 x$3) {
            Tuple2 tuple2 = x$3;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            ExecutionInfo info = (ExecutionInfo)tuple2._2();
            info.jobId().$plus$eq((Object)((Object)BoxesRunTime.boxToInteger((int)jobStart$1.jobId())).toString());
            info.groupId_$eq(groupId$1);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }

        public static final /* synthetic */ void $anonfun$onJobStart$2(HiveThriftServer2Listener $this, SparkListenerJobStart jobStart$1, String groupId) {
            $this.executionList().withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)HiveThriftServer2Listener.$anonfun$onJobStart$3(check$ifrefutable$1))).withFilter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)HiveThriftServer2Listener.$anonfun$onJobStart$4(groupId, x$2))).foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
                HiveThriftServer2Listener.$anonfun$onJobStart$5(jobStart$1, groupId, x$3);
                return BoxedUnit.UNIT;
            });
        }

        public static final /* synthetic */ void $anonfun$onJobStart$1(HiveThriftServer2Listener $this, SparkListenerJobStart jobStart$1, Properties props) {
            Option$.MODULE$.apply((Object)props.getProperty(SparkContext$.MODULE$.SPARK_JOB_GROUP_ID())).foreach((Function1 & Serializable & scala.Serializable)groupId -> {
                HiveThriftServer2Listener.$anonfun$onJobStart$2($this, jobStart$1, groupId);
                return BoxedUnit.UNIT;
            });
        }

        public static final /* synthetic */ boolean $anonfun$trimExecutionIfNecessary$1(Tuple2 x$4) {
            return ((ExecutionInfo)x$4._2()).finishTimestamp() != 0L;
        }

        public static final /* synthetic */ boolean $anonfun$trimSessionIfNecessary$1(Tuple2 x$5) {
            return ((SessionInfo)x$5._2()).finishTimestamp() != 0L;
        }

        public HiveThriftServer2Listener(HiveServer2 server, SQLConf conf) {
            this.server = server;
            this.conf = conf;
            this.onlineSessionNum = 0;
            this.sessionList = new LinkedHashMap();
            this.executionList = new LinkedHashMap();
            this.retainedStatements = BoxesRunTime.unboxToInt((Object)conf.getConf(SQLConf$.MODULE$.THRIFTSERVER_UI_STATEMENT_LIMIT()));
            this.retainedSessions = BoxesRunTime.unboxToInt((Object)conf.getConf(SQLConf$.MODULE$.THRIFTSERVER_UI_SESSION_LIMIT()));
            this.totalRunning = 0;
        }
    }

    public static class SessionInfo {
        private final String sessionId;
        private final long startTimestamp;
        private final String ip;
        private final String userName;
        private long finishTimestamp;
        private int totalExecution;

        public String sessionId() {
            return this.sessionId;
        }

        public long startTimestamp() {
            return this.startTimestamp;
        }

        public String ip() {
            return this.ip;
        }

        public String userName() {
            return this.userName;
        }

        public long finishTimestamp() {
            return this.finishTimestamp;
        }

        public void finishTimestamp_$eq(long x$1) {
            this.finishTimestamp = x$1;
        }

        public int totalExecution() {
            return this.totalExecution;
        }

        public void totalExecution_$eq(int x$1) {
            this.totalExecution = x$1;
        }

        public long totalTime() {
            return this.finishTimestamp() == 0L ? System.currentTimeMillis() - this.startTimestamp() : this.finishTimestamp() - this.startTimestamp();
        }

        public SessionInfo(String sessionId, long startTimestamp, String ip, String userName) {
            this.sessionId = sessionId;
            this.startTimestamp = startTimestamp;
            this.ip = ip;
            this.userName = userName;
            this.finishTimestamp = 0L;
            this.totalExecution = 0;
        }
    }
}

