/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive.thriftserver;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import jline.console.ConsoleReader;
import jline.console.history.FileHistory;
import jline.console.history.History;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.cli.CliDriver;
import org.apache.hadoop.hive.cli.CliSessionState;
import org.apache.hadoop.hive.cli.OptionsProcessor;
import org.apache.hadoop.hive.common.HiveInterruptCallback;
import org.apache.hadoop.hive.common.HiveInterruptUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.SparkHadoopUtil$;
import org.apache.spark.deploy.security.HiveDelegationTokenProvider;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.hive.HiveUtils$;
import org.apache.spark.sql.hive.thriftserver.ReflectionUtils$;
import org.apache.spark.sql.hive.thriftserver.SparkSQLCLIDriver;
import org.apache.spark.sql.hive.thriftserver.SparkSQLEnv$;
import org.apache.spark.util.ShutdownHookManager$;
import org.apache.thrift.transport.TSocket;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.sys.package$;

public final class SparkSQLCLIDriver$
implements Logging {
    public static SparkSQLCLIDriver$ MODULE$;
    private final String prompt;
    private final String continuedPrompt;
    private TSocket org$apache$spark$sql$hive$thriftserver$SparkSQLCLIDriver$$transport;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new SparkSQLCLIDriver$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private String prompt() {
        return this.prompt;
    }

    private String continuedPrompt() {
        return this.continuedPrompt;
    }

    public TSocket org$apache$spark$sql$hive$thriftserver$SparkSQLCLIDriver$$transport() {
        return this.org$apache$spark$sql$hive$thriftserver$SparkSQLCLIDriver$$transport;
    }

    private void org$apache$spark$sql$hive$thriftserver$SparkSQLCLIDriver$$transport_$eq(TSocket x$1) {
        this.org$apache$spark$sql$hive$thriftserver$SparkSQLCLIDriver$$transport = x$1;
    }

    private final String SPARK_HADOOP_PROP_PREFIX() {
        return "spark.hadoop.";
    }

    public void installSignalHandler() {
        HiveInterruptUtils.add((HiveInterruptCallback)new HiveInterruptCallback(){

            public void interrupt() {
                block1: {
                    block0: {
                        if (SparkSQLEnv$.MODULE$.sparkContext() == null) break block0;
                        SparkSQLEnv$.MODULE$.sparkContext().cancelAllJobs();
                        break block1;
                    }
                    if (SparkSQLCLIDriver$.MODULE$.org$apache$spark$sql$hive$thriftserver$SparkSQLCLIDriver$$transport() == null) break block1;
                    SparkSQLCLIDriver$.MODULE$.org$apache$spark$sql$hive$thriftserver$SparkSQLCLIDriver$$transport().getSocket().close();
                }
            }
        });
    }

    public void main(String[] args) {
        ClassLoader loader;
        OptionsProcessor oproc = new OptionsProcessor();
        if (!oproc.process_stage1(args)) {
            System.exit(1);
        }
        SparkConf sparkConf = new SparkConf(true);
        Configuration hadoopConf = SparkHadoopUtil$.MODULE$.get().newConfiguration(sparkConf);
        Map extraConfigs = HiveUtils$.MODULE$.formatTimeVarsForHiveClient(hadoopConf);
        HiveConf cliConf = new HiveConf(SessionState.class);
        ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(hadoopConf.iterator()).asScala()).map((Function1 & Serializable & scala.Serializable)kv -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(kv.getKey()), kv.getValue())).$plus$plus((Function0 & Serializable & scala.Serializable)() -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sparkConf.getAll())).toMap(Predef$.MODULE$.$conforms())).$plus$plus((Function0 & Serializable & scala.Serializable)() -> extraConfigs).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            SparkSQLCLIDriver$.$anonfun$main$4(cliConf, x0$1);
            return BoxedUnit.UNIT;
        });
        CliSessionState sessionState = new CliSessionState(cliConf);
        sessionState.in = System.in;
        try {
            sessionState.out = new PrintStream((OutputStream)System.out, true, "UTF-8");
            sessionState.info = new PrintStream((OutputStream)System.err, true, "UTF-8");
            sessionState.err = new PrintStream((OutputStream)System.err, true, "UTF-8");
        }
        catch (UnsupportedEncodingException e2) {
            System.exit(3);
        }
        if (!oproc.process_stage2(sessionState)) {
            System.exit(2);
        }
        HiveConf conf = sessionState.getConf();
        ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(sessionState.cmdProperties.entrySet()).asScala()).foreach((Function1 & Serializable & scala.Serializable)item -> {
            Object object;
            String key = item.getKey().toString();
            String value = item.getValue().toString();
            String string = key;
            String string2 = "javax.jdo.option.ConnectionURL";
            if (string == null ? string2 != null : !string.equals(string2)) {
                conf.set(key, value);
                object = sessionState.getOverriddenConfigurations().put(key, value);
            } else {
                object = BoxedUnit.UNIT;
            }
            return object;
        });
        HiveDelegationTokenProvider tokenProvider = new HiveDelegationTokenProvider();
        if (tokenProvider.delegationTokensRequired(sparkConf, hadoopConf)) {
            Credentials credentials = new Credentials();
            tokenProvider.obtainDelegationTokens(hadoopConf, sparkConf, credentials);
            UserGroupInformation.getCurrentUser().addCredentials(credentials);
        }
        SessionState.start((SessionState)sessionState);
        ShutdownHookManager$.MODULE$.addShutdownHook((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> SparkSQLEnv$.MODULE$.stop());
        boolean remoteMode = this.isRemoteMode(sessionState);
        if (!remoteMode) {
            loader = conf.getClassLoader();
            String auxJars = HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVEAUXJARS);
            if (StringUtils.isNotBlank((CharSequence)auxJars)) {
                loader = Utilities.addToClassPath((ClassLoader)loader, (String[])StringUtils.split((String)auxJars, (String)","));
            }
        } else {
            throw new RuntimeException("Remote operations not supported");
        }
        conf.setClassLoader(loader);
        Thread.currentThread().setContextClassLoader(loader);
        Set hiveConfFromCmd = (Set)JavaConverters$.MODULE$.asScalaSetConverter(sessionState.getOverriddenConfigurations().entrySet()).asScala();
        Set newHiveConf = (Set)hiveConfFromCmd.map((Function1 & Serializable & scala.Serializable)kv -> {
            String k = (String)kv.getKey();
            String v = (String)package$.MODULE$.props().getOrElseUpdate((Object)new StringBuilder(13).append("spark.hadoop.").append(k).toString(), (Function0 & Serializable & scala.Serializable)() -> (String)kv.getValue());
            return new Tuple2((Object)k, (Object)v);
        }, Set$.MODULE$.canBuildFrom());
        SparkSQLCLIDriver cli = new SparkSQLCLIDriver();
        cli.setHiveVariables(oproc.getHiveVariables());
        sessionState.in = System.in;
        try {
            sessionState.out = new PrintStream((OutputStream)System.out, true, "UTF-8");
            sessionState.info = new PrintStream((OutputStream)System.err, true, "UTF-8");
            sessionState.err = new PrintStream((OutputStream)System.err, true, "UTF-8");
        }
        catch (UnsupportedEncodingException e3) {
            System.exit(3);
        }
        if (sessionState.database != null) {
            SparkSQLEnv$.MODULE$.sqlContext().sessionState().catalog().setCurrentDatabase(String.valueOf(sessionState.database));
        }
        cli.processInitFiles(sessionState);
        newHiveConf.foreach((Function1 & Serializable & scala.Serializable)kv -> {
            SparkSQLCLIDriver$.$anonfun$main$9(kv);
            return BoxedUnit.UNIT;
        });
        if (sessionState.execString != null) {
            System.exit(cli.processLine(sessionState.execString));
        }
        try {
            if (sessionState.fileName != null) {
                System.exit(cli.processFile(sessionState.fileName));
            }
        }
        catch (FileNotFoundException e4) {
            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Could not open input file for reading. (").append(e4.getMessage()).append(")").toString());
            System.exit(3);
        }
        ConsoleReader reader = new ConsoleReader();
        reader.setBellEnabled(false);
        reader.setExpandEvents(false);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])CliDriver.getCommandCompleter())).foreach((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToBoolean((boolean)reader.addCompleter(e)));
        String historyDirectory = System.getProperty("user.home");
        try {
            if (new File(historyDirectory).exists()) {
                String historyFile = new StringBuilder(12).append(historyDirectory).append(File.separator).append(".hivehistory").toString();
                reader.setHistory((History)new FileHistory(new File(historyFile)));
            } else {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(111).append("WARNING: Directory for Hive history file: ").append(historyDirectory).append(" does not exist.   History will not be available during this session.").toString());
            }
        }
        catch (Exception e5) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "WARNING: Encountered an error while trying to initialize Hive's history file.  History will not be available during this session.");
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> e5.getMessage());
        }
        ShutdownHookManager$.MODULE$.addShutdownHook((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            History history = reader.getHistory();
            if (history instanceof FileHistory) {
                BoxedUnit boxedUnit;
                FileHistory fileHistory = (FileHistory)history;
                try {
                    fileHistory.flush();
                    boxedUnit = BoxedUnit.UNIT;
                }
                catch (IOException e) {
                    MODULE$.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(47).append("WARNING: Failed to write command history file: ").append(e.getMessage()).toString());
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit2 = boxedUnit;
            } else {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        });
        this.org$apache$spark$sql$hive$thriftserver$SparkSQLCLIDriver$$transport_$eq(null);
        int ret = 0;
        String prefix = "";
        Object currentDB = ReflectionUtils$.MODULE$.invokeStatic(CliDriver.class, "getFormattedDb", (Seq<Tuple2<Class<?>, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(HiveConf.class), (Object)conf), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(CliSessionState.class), (Object)sessionState)}));
        cli.printMasterAndAppId();
        String currentPrompt = this.promptWithCurrentDB$1(currentDB);
        String line = reader.readLine(new StringBuilder(2).append(currentPrompt).append("> ").toString());
        while (line != null) {
            if (!line.startsWith("--")) {
                if (new StringOps(Predef$.MODULE$.augmentString(prefix)).nonEmpty()) {
                    prefix = new StringBuilder(0).append(prefix).append('\n').toString();
                }
                if (line.trim().endsWith(";") && !line.trim().endsWith("\\;")) {
                    line = new StringBuilder(0).append(prefix).append(line).toString();
                    ret = cli.processLine(line, true);
                    prefix = "";
                    currentPrompt = this.promptWithCurrentDB$1(currentDB);
                } else {
                    prefix = new StringBuilder(0).append(prefix).append(line).toString();
                    currentPrompt = this.continuedPromptWithDBSpaces$1(currentDB);
                }
            }
            line = reader.readLine(new StringBuilder(2).append(currentPrompt).append("> ").toString());
        }
        sessionState.close();
        System.exit(ret);
    }

    public boolean isRemoteMode(CliSessionState state) {
        return state.isHiveServerQuery();
    }

    public static final /* synthetic */ void $anonfun$main$4(HiveConf cliConf$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String k = (String)tuple2._1();
        String v = (String)tuple2._2();
        cliConf$1.set(k, v);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$main$9(Tuple2 kv) {
        SparkSQLEnv$.MODULE$.sqlContext().setConf((String)kv._1(), (String)kv._2());
    }

    private final String promptWithCurrentDB$1(Object currentDB$1) {
        return new StringBuilder(0).append(this.prompt()).append(currentDB$1).toString();
    }

    private final String continuedPromptWithDBSpaces$1(Object currentDB$1) {
        return new StringBuilder(0).append(this.continuedPrompt()).append(ReflectionUtils$.MODULE$.invokeStatic(CliDriver.class, "spacesForString", (Seq<Tuple2<Class<?>, Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(String.class), currentDB$1)}))).toString();
    }

    private SparkSQLCLIDriver$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.prompt = "spark-sql";
        this.continuedPrompt = (String)new StringOps(Predef$.MODULE$.augmentString("")).padTo(this.prompt().length(), (Object)BoxesRunTime.boxToCharacter((char)' '), Predef$.MODULE$.StringCanBuildFrom());
        this.installSignalHandler();
    }
}

